/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextblockformat_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QMap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>
#include <QtGui/qtextoption.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextBlockFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextBlockFormat >()))
        return -1;

    ::QTextBlockFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextBlockFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextBlockFormat::QTextBlockFormat()
    // 1: QTextBlockFormat::QTextBlockFormat(QTextBlockFormat)
    // 2: QTextBlockFormat::QTextBlockFormat(QTextFormat)
    if (numArgs == 0) {
        overloadId = 0; // QTextBlockFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextBlockFormat(QTextBlockFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextBlockFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextBlockFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextBlockFormat()
                cptr = new ::QTextBlockFormat();
            }
            break;
        }
        case 1: // QTextBlockFormat(const QTextBlockFormat & QTextBlockFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextBlockFormat cppArg0_local;
            ::QTextBlockFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextBlockFormat(QTextBlockFormat)
                cptr = new ::QTextBlockFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextBlockFormat(const QTextFormat & fmt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextBlockFormat(QTextFormat)
                cptr = new ::QTextBlockFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextBlockFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextBlockFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextBlockFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextBlockFormatFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.alignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alignment()const
            QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->alignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_bottomMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.bottomMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bottomMargin()const
            qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->bottomMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_headingLevel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.headingLevel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // headingLevel()const
            int cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->headingLevel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_indent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.indent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indent()const
            int cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->indent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_leftMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.leftMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leftMargin()const
            qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->leftMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_lineHeight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.lineHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QTextBlockFormatFunc_lineHeight_TypeError;

    if (!PyArg_UnpackTuple(args, "lineHeight", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextBlockFormat::lineHeight()const
    // 1: QTextBlockFormat::lineHeight(qreal,qreal)const
    if (numArgs == 0) {
        overloadId = 0; // lineHeight()const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // lineHeight(qreal,qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_lineHeight_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // lineHeight() const
        {

            if (!PyErr_Occurred()) {
                // lineHeight()const
                qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->lineHeight();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
        case 1: // lineHeight(qreal scriptLineHeight, qreal scaling) const
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // lineHeight(qreal,qreal)const
                qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->lineHeight(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextBlockFormatFunc_lineHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_lineHeightType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.lineHeightType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineHeightType()const
            int cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->lineHeightType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_marker(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.marker";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // marker()const
            QTextBlockFormat::MarkerType cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->marker();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_nonBreakableLines(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.nonBreakableLines";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nonBreakableLines()const
            bool cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->nonBreakableLines();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_pageBreakPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.pageBreakPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageBreakPolicy()const
            QFlags<QTextFormat::PageBreakFlag> cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->pageBreakPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_rightMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.rightMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rightMargin()const
            qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->rightMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setAlignment_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setBottomMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setBottomMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setBottomMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottomMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setBottomMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomMargin(qreal)
            cppSelf->setBottomMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setBottomMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setHeadingLevel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setHeadingLevel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setHeadingLevel(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHeadingLevel(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setHeadingLevel_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeadingLevel(int)
            cppSelf->setHeadingLevel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setHeadingLevel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setIndent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setIndent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setIndent(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setIndent(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setIndent_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIndent(int)
            cppSelf->setIndent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setIndent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setLeftMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setLeftMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setLeftMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeftMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setLeftMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftMargin(qreal)
            cppSelf->setLeftMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setLeftMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setLineHeight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setLineHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setLineHeight", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextBlockFormat::setLineHeight(qreal,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setLineHeight(qreal,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setLineHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setLineHeight(qreal,int)
            cppSelf->setLineHeight(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setLineHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setMarker(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setMarker";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setMarker(QTextBlockFormat::MarkerType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMarker(QTextBlockFormat::MarkerType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setMarker_TypeError;

    // Call function/method
    {
        ::QTextBlockFormat::MarkerType cppArg0{QTextBlockFormat::MarkerType::NoMarker};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMarker(QTextBlockFormat::MarkerType)
            cppSelf->setMarker(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setMarker_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setNonBreakableLines(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setNonBreakableLines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setNonBreakableLines(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setNonBreakableLines(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setNonBreakableLines_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNonBreakableLines(bool)
            cppSelf->setNonBreakableLines(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setNonBreakableLines_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setPageBreakPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setPageBreakPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setPageBreakPolicy_TypeError;

    // Call function/method
    {
        ::QFlags<QTextFormat::PageBreakFlag> cppArg0 = QFlags<QTextFormat::PageBreakFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPageBreakPolicy(QFlags<QTextFormat::PageBreakFlag>)
            cppSelf->setPageBreakPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setPageBreakPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setRightMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setRightMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setRightMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRightMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setRightMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightMargin(qreal)
            cppSelf->setRightMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setRightMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setTabPositions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setTabPositions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setTabPositions(QList<QTextOption::Tab>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], (pyArg)))) {
        overloadId = 0; // setTabPositions(QList<QTextOption::Tab>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setTabPositions_TypeError;

    // Call function/method
    {
        ::QList<QTextOption::Tab > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTabPositions(QList<QTextOption::Tab>)
            cppSelf->setTabPositions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setTabPositions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setTextIndent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setTextIndent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setTextIndent(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTextIndent(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setTextIndent_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextIndent(qreal)
            cppSelf->setTextIndent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setTextIndent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_setTopMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.setTopMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextBlockFormat::setTopMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTopMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextBlockFormatFunc_setTopMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopMargin(qreal)
            cppSelf->setTopMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextBlockFormatFunc_setTopMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextBlockFormatFunc_tabPositions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.tabPositions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tabPositions()const
            QList<QTextOption::Tab > cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->tabPositions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QTEXTOPTION_TAB_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_textIndent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.textIndent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textIndent()const
            qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->textIndent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormatFunc_topMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextBlockFormat.topMargin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // topMargin()const
            qreal cppResult = const_cast<const ::QTextBlockFormat *>(cppSelf)->topMargin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextBlockFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextBlockFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextBlockFormat_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_alignment), METH_NOARGS},
    {"bottomMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_bottomMargin), METH_NOARGS},
    {"headingLevel", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_headingLevel), METH_NOARGS},
    {"indent", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_indent), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_isValid), METH_NOARGS},
    {"leftMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_leftMargin), METH_NOARGS},
    {"lineHeight", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_lineHeight), METH_VARARGS},
    {"lineHeightType", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_lineHeightType), METH_NOARGS},
    {"marker", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_marker), METH_NOARGS},
    {"nonBreakableLines", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_nonBreakableLines), METH_NOARGS},
    {"pageBreakPolicy", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_pageBreakPolicy), METH_NOARGS},
    {"rightMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_rightMargin), METH_NOARGS},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setAlignment), METH_O},
    {"setBottomMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setBottomMargin), METH_O},
    {"setHeadingLevel", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setHeadingLevel), METH_O},
    {"setIndent", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setIndent), METH_O},
    {"setLeftMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setLeftMargin), METH_O},
    {"setLineHeight", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setLineHeight), METH_VARARGS},
    {"setMarker", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setMarker), METH_O},
    {"setNonBreakableLines", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setNonBreakableLines), METH_O},
    {"setPageBreakPolicy", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setPageBreakPolicy), METH_O},
    {"setRightMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setRightMargin), METH_O},
    {"setTabPositions", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setTabPositions), METH_O},
    {"setTextIndent", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setTextIndent), METH_O},
    {"setTopMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_setTopMargin), METH_O},
    {"tabPositions", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_tabPositions), METH_NOARGS},
    {"textIndent", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_textIndent), METH_NOARGS},
    {"topMargin", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormatFunc_topMargin), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextBlockFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextBlockFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextBlockFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextBlockFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextBlockFormat_TypeF(void)
{
    return _Sbk_QTextBlockFormat_Type;
}

static PyType_Slot Sbk_QTextBlockFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextBlockFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextBlockFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextBlockFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextBlockFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextBlockFormat_spec = {
    "2:PySide2.QtGui.QTextBlockFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextBlockFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextBlockFormat_LineHeightTypes_PythonToCpp_QTextBlockFormat_LineHeightTypes(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBlockFormat::LineHeightTypes *>(cppOut) =
        static_cast<::QTextBlockFormat::LineHeightTypes>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextBlockFormat_LineHeightTypes_PythonToCpp_QTextBlockFormat_LineHeightTypes_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX]))
        return QTextBlockFormat_LineHeightTypes_PythonToCpp_QTextBlockFormat_LineHeightTypes;
    return {};
}
static PyObject *QTextBlockFormat_LineHeightTypes_CppToPython_QTextBlockFormat_LineHeightTypes(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextBlockFormat::LineHeightTypes *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX], castCppIn);

}

static void QTextBlockFormat_MarkerType_PythonToCpp_QTextBlockFormat_MarkerType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBlockFormat::MarkerType *>(cppOut) =
        static_cast<::QTextBlockFormat::MarkerType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextBlockFormat_MarkerType_PythonToCpp_QTextBlockFormat_MarkerType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX]))
        return QTextBlockFormat_MarkerType_PythonToCpp_QTextBlockFormat_MarkerType;
    return {};
}
static PyObject *QTextBlockFormat_MarkerType_CppToPython_QTextBlockFormat_MarkerType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextBlockFormat::MarkerType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextBlockFormat_PythonToCpp_QTextBlockFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextBlockFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextBlockFormat_PythonToCpp_QTextBlockFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBlockFormat_TypeF())))
        return QTextBlockFormat_PythonToCpp_QTextBlockFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextBlockFormat_PTR_CppToPython_QTextBlockFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextBlockFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextBlockFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextBlockFormat_COPY_CppToPython_QTextBlockFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextBlockFormat_TypeF(), new ::QTextBlockFormat(*reinterpret_cast<const ::QTextBlockFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextBlockFormat_PythonToCpp_QTextBlockFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextBlockFormat *>(cppOut) = *reinterpret_cast< ::QTextBlockFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextBlockFormat_PythonToCpp_QTextBlockFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextBlockFormat_TypeF())))
        return QTextBlockFormat_PythonToCpp_QTextBlockFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextBlockFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextBlockFormat(self)",
    "1:PySide2.QtGui.QTextBlockFormat(self,QTextBlockFormat:PySide2.QtGui.QTextBlockFormat)",
    "0:PySide2.QtGui.QTextBlockFormat(self,fmt:PySide2.QtGui.QTextFormat)",
    "PySide2.QtGui.QTextBlockFormat.alignment(self)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtGui.QTextBlockFormat.bottomMargin(self)->qreal",
    "PySide2.QtGui.QTextBlockFormat.headingLevel(self)->int",
    "PySide2.QtGui.QTextBlockFormat.indent(self)->int",
    "PySide2.QtGui.QTextBlockFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextBlockFormat.leftMargin(self)->qreal",
    "1:PySide2.QtGui.QTextBlockFormat.lineHeight(self)->qreal",
    "0:PySide2.QtGui.QTextBlockFormat.lineHeight(self,scriptLineHeight:qreal,scaling:qreal)->qreal",
    "PySide2.QtGui.QTextBlockFormat.lineHeightType(self)->int",
    "PySide2.QtGui.QTextBlockFormat.marker(self)->PySide2.QtGui.QTextBlockFormat.MarkerType",
    "PySide2.QtGui.QTextBlockFormat.nonBreakableLines(self)->bool",
    "PySide2.QtGui.QTextBlockFormat.pageBreakPolicy(self)->PySide2.QtGui.QTextFormat.PageBreakFlags",
    "PySide2.QtGui.QTextBlockFormat.rightMargin(self)->qreal",
    "PySide2.QtGui.QTextBlockFormat.setAlignment(self,alignment:PySide2.QtCore.Qt.Alignment)",
    "PySide2.QtGui.QTextBlockFormat.setBottomMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextBlockFormat.setHeadingLevel(self,alevel:int)",
    "PySide2.QtGui.QTextBlockFormat.setIndent(self,indent:int)",
    "PySide2.QtGui.QTextBlockFormat.setLeftMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextBlockFormat.setLineHeight(self,height:qreal,heightType:int)",
    "PySide2.QtGui.QTextBlockFormat.setMarker(self,marker:PySide2.QtGui.QTextBlockFormat.MarkerType)",
    "PySide2.QtGui.QTextBlockFormat.setNonBreakableLines(self,b:bool)",
    "PySide2.QtGui.QTextBlockFormat.setPageBreakPolicy(self,flags:PySide2.QtGui.QTextFormat.PageBreakFlags)",
    "PySide2.QtGui.QTextBlockFormat.setRightMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextBlockFormat.setTabPositions(self,tabs:QList[PySide2.QtGui.QTextOption.Tab])",
    "PySide2.QtGui.QTextBlockFormat.setTextIndent(self,aindent:qreal)",
    "PySide2.QtGui.QTextBlockFormat.setTopMargin(self,margin:qreal)",
    "PySide2.QtGui.QTextBlockFormat.tabPositions(self)->QList[PySide2.QtGui.QTextOption.Tab]",
    "PySide2.QtGui.QTextBlockFormat.textIndent(self)->qreal",
    "PySide2.QtGui.QTextBlockFormat.topMargin(self)->qreal",
    "PySide2.QtGui.QTextBlockFormat.__copy__()",
    nullptr}; // Sentinel

void init_QTextBlockFormat(PyObject *module)
{
    _Sbk_QTextBlockFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextBlockFormat",
        "QTextBlockFormat",
        &Sbk_QTextBlockFormat_spec,
        &Shiboken::callCppDestructor< ::QTextBlockFormat >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextBlockFormat_Type);
    InitSignatureStrings(pyType, QTextBlockFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextBlockFormat_Type), Sbk_QTextBlockFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextBlockFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextBlockFormat_TypeF(),
        QTextBlockFormat_PythonToCpp_QTextBlockFormat_PTR,
        is_QTextBlockFormat_PythonToCpp_QTextBlockFormat_PTR_Convertible,
        QTextBlockFormat_PTR_CppToPython_QTextBlockFormat,
        QTextBlockFormat_COPY_CppToPython_QTextBlockFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextBlockFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextBlockFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextBlockFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextBlockFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextBlockFormat_PythonToCpp_QTextBlockFormat_COPY,
        is_QTextBlockFormat_PythonToCpp_QTextBlockFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'LineHeightTypes'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextBlockFormat_TypeF(),
        "LineHeightTypes",
        "2:PySide2.QtGui.QTextBlockFormat.LineHeightTypes",
        "QTextBlockFormat::LineHeightTypes");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
        Sbk_QTextBlockFormat_TypeF(), "SingleHeight", (long) QTextBlockFormat::LineHeightTypes::SingleHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
        Sbk_QTextBlockFormat_TypeF(), "ProportionalHeight", (long) QTextBlockFormat::LineHeightTypes::ProportionalHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
        Sbk_QTextBlockFormat_TypeF(), "FixedHeight", (long) QTextBlockFormat::LineHeightTypes::FixedHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
        Sbk_QTextBlockFormat_TypeF(), "MinimumHeight", (long) QTextBlockFormat::LineHeightTypes::MinimumHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
        Sbk_QTextBlockFormat_TypeF(), "LineDistanceHeight", (long) QTextBlockFormat::LineHeightTypes::LineDistanceHeight))
        return;
    // Register converter for enum 'QTextBlockFormat::LineHeightTypes'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX],
            QTextBlockFormat_LineHeightTypes_CppToPython_QTextBlockFormat_LineHeightTypes);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextBlockFormat_LineHeightTypes_PythonToCpp_QTextBlockFormat_LineHeightTypes,
            is_QTextBlockFormat_LineHeightTypes_PythonToCpp_QTextBlockFormat_LineHeightTypes_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_LINEHEIGHTTYPES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextBlockFormat::LineHeightTypes");
        Shiboken::Conversions::registerConverterName(converter, "LineHeightTypes");
    }
    // End of 'LineHeightTypes' enum.

    // Initialization of enum 'MarkerType'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextBlockFormat_TypeF(),
        "MarkerType",
        "2:PySide2.QtGui.QTextBlockFormat.MarkerType",
        "QTextBlockFormat::MarkerType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX],
        SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX], "NoMarker", (long) QTextBlockFormat::MarkerType::NoMarker))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX],
        SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX], "Unchecked", (long) QTextBlockFormat::MarkerType::Unchecked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX],
        SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX], "Checked", (long) QTextBlockFormat::MarkerType::Checked))
        return;
    // Register converter for enum 'QTextBlockFormat::MarkerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX],
            QTextBlockFormat_MarkerType_CppToPython_QTextBlockFormat_MarkerType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextBlockFormat_MarkerType_PythonToCpp_QTextBlockFormat_MarkerType,
            is_QTextBlockFormat_MarkerType_PythonToCpp_QTextBlockFormat_MarkerType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_MARKERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextBlockFormat::MarkerType");
        Shiboken::Conversions::registerConverterName(converter, "MarkerType");
    }
    // End of 'MarkerType' enum.

    qRegisterMetaType< ::QTextBlockFormat >("QTextBlockFormat");
    qRegisterMetaType< ::QTextBlockFormat::LineHeightTypes >("QTextBlockFormat::LineHeightTypes");
    qRegisterMetaType< ::QTextBlockFormat::MarkerType >("QTextBlockFormat::MarkerType");
}
