/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextcharformat_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qfont.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextCharFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextCharFormat >()))
        return -1;

    ::QTextCharFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextCharFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextCharFormat::QTextCharFormat()
    // 1: QTextCharFormat::QTextCharFormat(QTextCharFormat)
    // 2: QTextCharFormat::QTextCharFormat(QTextFormat)
    if (numArgs == 0) {
        overloadId = 0; // QTextCharFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextCharFormat(QTextCharFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextCharFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextCharFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextCharFormat()
                cptr = new ::QTextCharFormat();
            }
            break;
        }
        case 1: // QTextCharFormat(const QTextCharFormat & QTextCharFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextCharFormat cppArg0_local;
            ::QTextCharFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextCharFormat(QTextCharFormat)
                cptr = new ::QTextCharFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextCharFormat(const QTextFormat & fmt)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextCharFormat(QTextFormat)
                cptr = new ::QTextCharFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextCharFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextCharFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextCharFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextCharFormatFunc_anchorHref(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.anchorHref";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anchorHref()const
            QString cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->anchorHref();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_anchorName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.anchorName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anchorName()const
            QString cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->anchorName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_anchorNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.anchorNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anchorNames()const
            QStringList cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->anchorNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontCapitalization(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontCapitalization";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontCapitalization()const
            QFont::Capitalization cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontCapitalization();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontFamilies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontFamilies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontFamilies()const
            QVariant cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontFamilies();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontFamily(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontFamily";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontFamily()const
            QString cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontFamily();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontFixedPitch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontFixedPitch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontFixedPitch()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontFixedPitch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontHintingPreference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontHintingPreference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontHintingPreference()const
            QFont::HintingPreference cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontHintingPreference();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontItalic(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontItalic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontItalic()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontItalic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontKerning(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontKerning";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontKerning()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontKerning();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontLetterSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontLetterSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontLetterSpacing()const
            qreal cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontLetterSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontLetterSpacingType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontLetterSpacingType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontLetterSpacingType()const
            QFont::SpacingType cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontLetterSpacingType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontOverline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontOverline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontOverline()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontOverline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontPointSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontPointSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontPointSize()const
            qreal cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontPointSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontStretch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontStretch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontStretch()const
            int cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontStretch();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontStrikeOut(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontStrikeOut";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontStrikeOut()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontStrikeOut();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontStyleHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontStyleHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontStyleHint()const
            QFont::StyleHint cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontStyleHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontStyleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontStyleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontStyleName()const
            QVariant cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontStyleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontStyleStrategy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontStyleStrategy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontStyleStrategy()const
            QFont::StyleStrategy cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontStyleStrategy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontUnderline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontUnderline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontUnderline()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontUnderline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontWeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontWeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontWeight()const
            int cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontWeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_fontWordSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.fontWordSpacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontWordSpacing()const
            qreal cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->fontWordSpacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_isAnchor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.isAnchor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAnchor()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->isAnchor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_setAnchor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setAnchor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setAnchor(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAnchor(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setAnchor_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnchor(bool)
            cppSelf->setAnchor(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setAnchor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setAnchorHref(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setAnchorHref";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setAnchorHref(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setAnchorHref(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setAnchorHref_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnchorHref(QString)
            cppSelf->setAnchorHref(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setAnchorHref_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setAnchorName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setAnchorName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setAnchorName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setAnchorName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setAnchorName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnchorName(QString)
            cppSelf->setAnchorName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setAnchorName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setAnchorNames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setAnchorNames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setAnchorNames(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setAnchorNames(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setAnchorNames_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAnchorNames(QStringList)
            cppSelf->setAnchorNames(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setAnchorNames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFont(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFont", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCharFormat::setFont(QFont)
    // 1: QTextCharFormat::setFont(QFont,QTextCharFormat::FontPropertiesInheritanceBehavior)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFont(QFont)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // setFont(QFont,QTextCharFormat::FontPropertiesInheritanceBehavior)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFont_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFont(const QFont & font)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setFont(QFont)
                cppSelf->setFont(*cppArg0);
            }
            break;
        }
        case 1: // setFont(const QFont & font, QTextCharFormat::FontPropertiesInheritanceBehavior behavior)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QFont cppArg0_local;
            ::QFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QTextCharFormat::FontPropertiesInheritanceBehavior cppArg1{QTextCharFormat::FontPropertiesSpecifiedOnly};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFont(QFont,QTextCharFormat::FontPropertiesInheritanceBehavior)
                cppSelf->setFont(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontCapitalization(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontCapitalization";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontCapitalization(QFont::Capitalization)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_CAPITALIZATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFontCapitalization(QFont::Capitalization)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontCapitalization_TypeError;

    // Call function/method
    {
        ::QFont::Capitalization cppArg0{QFont::MixedCase};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontCapitalization(QFont::Capitalization)
            cppSelf->setFontCapitalization(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontCapitalization_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontFamilies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontFamilies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontFamilies(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setFontFamilies(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontFamilies_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontFamilies(QStringList)
            cppSelf->setFontFamilies(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontFamilies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontFamily(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFontFamily(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontFamily_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontFamily(QString)
            cppSelf->setFontFamily(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontFixedPitch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontFixedPitch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontFixedPitch(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontFixedPitch(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontFixedPitch_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontFixedPitch(bool)
            cppSelf->setFontFixedPitch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontFixedPitch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontHintingPreference(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontHintingPreference";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontHintingPreference(QFont::HintingPreference)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFontHintingPreference(QFont::HintingPreference)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontHintingPreference_TypeError;

    // Call function/method
    {
        ::QFont::HintingPreference cppArg0{QFont::PreferDefaultHinting};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontHintingPreference(QFont::HintingPreference)
            cppSelf->setFontHintingPreference(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontHintingPreference_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontItalic(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontItalic";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontItalic(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontItalic(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontItalic_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontItalic(bool)
            cppSelf->setFontItalic(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontItalic_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontKerning(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontKerning";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontKerning(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontKerning(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontKerning_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontKerning(bool)
            cppSelf->setFontKerning(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontKerning_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontLetterSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontLetterSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontLetterSpacing(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFontLetterSpacing(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontLetterSpacing_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontLetterSpacing(qreal)
            cppSelf->setFontLetterSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontLetterSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontLetterSpacingType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontLetterSpacingType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontLetterSpacingType(QFont::SpacingType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_SPACINGTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFontLetterSpacingType(QFont::SpacingType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontLetterSpacingType_TypeError;

    // Call function/method
    {
        ::QFont::SpacingType cppArg0{QFont::PercentageSpacing};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontLetterSpacingType(QFont::SpacingType)
            cppSelf->setFontLetterSpacingType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontLetterSpacingType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontOverline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontOverline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontOverline(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontOverline(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontOverline_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontOverline(bool)
            cppSelf->setFontOverline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontOverline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontPointSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontPointSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontPointSize(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFontPointSize(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontPointSize_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontPointSize(qreal)
            cppSelf->setFontPointSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontPointSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontStretch(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontStretch";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontStretch(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFontStretch(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontStretch_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontStretch(int)
            cppSelf->setFontStretch(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontStretch_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontStrikeOut(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontStrikeOut";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontStrikeOut(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontStrikeOut(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontStrikeOut_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontStrikeOut(bool)
            cppSelf->setFontStrikeOut(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontStrikeOut_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontStyleHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontStyleHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFontStyleHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCharFormat::setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_strategy = Shiboken::String::createStaticString("strategy");
            if (PyDict_Contains(kwds, key_strategy)) {
                value = PyDict_GetItem(kwds, key_strategy);
                if (value && pyArgs[1]) {
                    errInfo = key_strategy;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_strategy);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError;
            }
        }
        ::QFont::StyleHint cppArg0{QFont::SansSerif};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFont::StyleStrategy cppArg1 = QFont::PreferDefault;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFontStyleHint(QFont::StyleHint,QFont::StyleStrategy)
            cppSelf->setFontStyleHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontStyleHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontStyleName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontStyleName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontStyleName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setFontStyleName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontStyleName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontStyleName(QString)
            cppSelf->setFontStyleName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontStyleName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontStyleStrategy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontStyleStrategy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontStyleStrategy(QFont::StyleStrategy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLESTRATEGY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFontStyleStrategy(QFont::StyleStrategy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontStyleStrategy_TypeError;

    // Call function/method
    {
        ::QFont::StyleStrategy cppArg0 = static_cast< ::QFont::StyleStrategy>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontStyleStrategy(QFont::StyleStrategy)
            cppSelf->setFontStyleStrategy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontStyleStrategy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontUnderline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontUnderline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontUnderline(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontUnderline(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontUnderline_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontUnderline(bool)
            cppSelf->setFontUnderline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontUnderline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontWeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontWeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontWeight(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFontWeight(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontWeight_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontWeight(int)
            cppSelf->setFontWeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontWeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setFontWordSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setFontWordSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setFontWordSpacing(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFontWordSpacing(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setFontWordSpacing_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontWordSpacing(qreal)
            cppSelf->setFontWordSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setFontWordSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setTableCellColumnSpan(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setTableCellColumnSpan";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setTableCellColumnSpan(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTableCellColumnSpan(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setTableCellColumnSpan_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTableCellColumnSpan(int)
            cppSelf->setTableCellColumnSpan(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setTableCellColumnSpan_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setTableCellRowSpan(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setTableCellRowSpan";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setTableCellRowSpan(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTableCellRowSpan(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setTableCellRowSpan_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTableCellRowSpan(int)
            cppSelf->setTableCellRowSpan(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setTableCellRowSpan_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setTextOutline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setTextOutline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setTextOutline(QPen)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // setTextOutline(QPen)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setTextOutline_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTextOutline(QPen)
            cppSelf->setTextOutline(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setTextOutline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setToolTip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setToolTip_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setToolTip(QString)
            cppSelf->setToolTip(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setToolTip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setUnderlineColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setUnderlineColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setUnderlineColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setUnderlineColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setUnderlineColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUnderlineColor(QColor)
            cppSelf->setUnderlineColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setUnderlineColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setUnderlineStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setUnderlineStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setUnderlineStyle(QTextCharFormat::UnderlineStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUnderlineStyle(QTextCharFormat::UnderlineStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setUnderlineStyle_TypeError;

    // Call function/method
    {
        ::QTextCharFormat::UnderlineStyle cppArg0{QTextCharFormat::NoUnderline};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUnderlineStyle(QTextCharFormat::UnderlineStyle)
            cppSelf->setUnderlineStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setUnderlineStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_setVerticalAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.setVerticalAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCharFormat::setVerticalAlignment(QTextCharFormat::VerticalAlignment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVerticalAlignment(QTextCharFormat::VerticalAlignment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCharFormatFunc_setVerticalAlignment_TypeError;

    // Call function/method
    {
        ::QTextCharFormat::VerticalAlignment cppArg0{QTextCharFormat::AlignNormal};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalAlignment(QTextCharFormat::VerticalAlignment)
            cppSelf->setVerticalAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCharFormatFunc_setVerticalAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCharFormatFunc_tableCellColumnSpan(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.tableCellColumnSpan";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tableCellColumnSpan()const
            int cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->tableCellColumnSpan();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_tableCellRowSpan(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.tableCellRowSpan";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tableCellRowSpan()const
            int cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->tableCellRowSpan();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_textOutline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.textOutline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textOutline()const
            QPen cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->textOutline();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_toolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.toolTip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toolTip()const
            QString cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->toolTip();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_underlineColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.underlineColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underlineColor()const
            QColor cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->underlineColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_underlineStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.underlineStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underlineStyle()const
            QTextCharFormat::UnderlineStyle cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->underlineStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormatFunc_verticalAlignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCharFormat.verticalAlignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalAlignment()const
            QTextCharFormat::VerticalAlignment cppResult = const_cast<const ::QTextCharFormat *>(cppSelf)->verticalAlignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCharFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextCharFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextCharFormat_methods[] = {
    {"anchorHref", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_anchorHref), METH_NOARGS},
    {"anchorName", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_anchorName), METH_NOARGS},
    {"anchorNames", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_anchorNames), METH_NOARGS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_font), METH_NOARGS},
    {"fontCapitalization", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontCapitalization), METH_NOARGS},
    {"fontFamilies", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontFamilies), METH_NOARGS},
    {"fontFamily", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontFamily), METH_NOARGS},
    {"fontFixedPitch", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontFixedPitch), METH_NOARGS},
    {"fontHintingPreference", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontHintingPreference), METH_NOARGS},
    {"fontItalic", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontItalic), METH_NOARGS},
    {"fontKerning", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontKerning), METH_NOARGS},
    {"fontLetterSpacing", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontLetterSpacing), METH_NOARGS},
    {"fontLetterSpacingType", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontLetterSpacingType), METH_NOARGS},
    {"fontOverline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontOverline), METH_NOARGS},
    {"fontPointSize", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontPointSize), METH_NOARGS},
    {"fontStretch", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontStretch), METH_NOARGS},
    {"fontStrikeOut", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontStrikeOut), METH_NOARGS},
    {"fontStyleHint", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontStyleHint), METH_NOARGS},
    {"fontStyleName", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontStyleName), METH_NOARGS},
    {"fontStyleStrategy", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontStyleStrategy), METH_NOARGS},
    {"fontUnderline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontUnderline), METH_NOARGS},
    {"fontWeight", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontWeight), METH_NOARGS},
    {"fontWordSpacing", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_fontWordSpacing), METH_NOARGS},
    {"isAnchor", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_isAnchor), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_isValid), METH_NOARGS},
    {"setAnchor", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setAnchor), METH_O},
    {"setAnchorHref", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setAnchorHref), METH_O},
    {"setAnchorName", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setAnchorName), METH_O},
    {"setAnchorNames", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setAnchorNames), METH_O},
    {"setFont", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFont), METH_VARARGS},
    {"setFontCapitalization", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontCapitalization), METH_O},
    {"setFontFamilies", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontFamilies), METH_O},
    {"setFontFamily", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontFamily), METH_O},
    {"setFontFixedPitch", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontFixedPitch), METH_O},
    {"setFontHintingPreference", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontHintingPreference), METH_O},
    {"setFontItalic", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontItalic), METH_O},
    {"setFontKerning", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontKerning), METH_O},
    {"setFontLetterSpacing", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontLetterSpacing), METH_O},
    {"setFontLetterSpacingType", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontLetterSpacingType), METH_O},
    {"setFontOverline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontOverline), METH_O},
    {"setFontPointSize", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontPointSize), METH_O},
    {"setFontStretch", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontStretch), METH_O},
    {"setFontStrikeOut", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontStrikeOut), METH_O},
    {"setFontStyleHint", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontStyleHint), METH_VARARGS|METH_KEYWORDS},
    {"setFontStyleName", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontStyleName), METH_O},
    {"setFontStyleStrategy", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontStyleStrategy), METH_O},
    {"setFontUnderline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontUnderline), METH_O},
    {"setFontWeight", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontWeight), METH_O},
    {"setFontWordSpacing", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setFontWordSpacing), METH_O},
    {"setTableCellColumnSpan", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setTableCellColumnSpan), METH_O},
    {"setTableCellRowSpan", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setTableCellRowSpan), METH_O},
    {"setTextOutline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setTextOutline), METH_O},
    {"setToolTip", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setToolTip), METH_O},
    {"setUnderlineColor", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setUnderlineColor), METH_O},
    {"setUnderlineStyle", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setUnderlineStyle), METH_O},
    {"setVerticalAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_setVerticalAlignment), METH_O},
    {"tableCellColumnSpan", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_tableCellColumnSpan), METH_NOARGS},
    {"tableCellRowSpan", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_tableCellRowSpan), METH_NOARGS},
    {"textOutline", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_textOutline), METH_NOARGS},
    {"toolTip", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_toolTip), METH_NOARGS},
    {"underlineColor", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_underlineColor), METH_NOARGS},
    {"underlineStyle", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_underlineStyle), METH_NOARGS},
    {"verticalAlignment", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormatFunc_verticalAlignment), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextCharFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextCharFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextCharFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextCharFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextCharFormat_TypeF(void)
{
    return _Sbk_QTextCharFormat_Type;
}

static PyType_Slot Sbk_QTextCharFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextCharFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextCharFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextCharFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextCharFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextCharFormat_spec = {
    "2:PySide2.QtGui.QTextCharFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextCharFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextCharFormat_VerticalAlignment_PythonToCpp_QTextCharFormat_VerticalAlignment(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCharFormat::VerticalAlignment *>(cppOut) =
        static_cast<::QTextCharFormat::VerticalAlignment>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCharFormat_VerticalAlignment_PythonToCpp_QTextCharFormat_VerticalAlignment_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX]))
        return QTextCharFormat_VerticalAlignment_PythonToCpp_QTextCharFormat_VerticalAlignment;
    return {};
}
static PyObject *QTextCharFormat_VerticalAlignment_CppToPython_QTextCharFormat_VerticalAlignment(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCharFormat::VerticalAlignment *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX], castCppIn);

}

static void QTextCharFormat_UnderlineStyle_PythonToCpp_QTextCharFormat_UnderlineStyle(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCharFormat::UnderlineStyle *>(cppOut) =
        static_cast<::QTextCharFormat::UnderlineStyle>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCharFormat_UnderlineStyle_PythonToCpp_QTextCharFormat_UnderlineStyle_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX]))
        return QTextCharFormat_UnderlineStyle_PythonToCpp_QTextCharFormat_UnderlineStyle;
    return {};
}
static PyObject *QTextCharFormat_UnderlineStyle_CppToPython_QTextCharFormat_UnderlineStyle(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCharFormat::UnderlineStyle *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX], castCppIn);

}

static void QTextCharFormat_FontPropertiesInheritanceBehavior_PythonToCpp_QTextCharFormat_FontPropertiesInheritanceBehavior(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCharFormat::FontPropertiesInheritanceBehavior *>(cppOut) =
        static_cast<::QTextCharFormat::FontPropertiesInheritanceBehavior>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCharFormat_FontPropertiesInheritanceBehavior_PythonToCpp_QTextCharFormat_FontPropertiesInheritanceBehavior_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX]))
        return QTextCharFormat_FontPropertiesInheritanceBehavior_PythonToCpp_QTextCharFormat_FontPropertiesInheritanceBehavior;
    return {};
}
static PyObject *QTextCharFormat_FontPropertiesInheritanceBehavior_CppToPython_QTextCharFormat_FontPropertiesInheritanceBehavior(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCharFormat::FontPropertiesInheritanceBehavior *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextCharFormat_PythonToCpp_QTextCharFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextCharFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextCharFormat_PythonToCpp_QTextCharFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCharFormat_TypeF())))
        return QTextCharFormat_PythonToCpp_QTextCharFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextCharFormat_PTR_CppToPython_QTextCharFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextCharFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextCharFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextCharFormat_COPY_CppToPython_QTextCharFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextCharFormat_TypeF(), new ::QTextCharFormat(*reinterpret_cast<const ::QTextCharFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextCharFormat_PythonToCpp_QTextCharFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCharFormat *>(cppOut) = *reinterpret_cast< ::QTextCharFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextCharFormat_PythonToCpp_QTextCharFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCharFormat_TypeF())))
        return QTextCharFormat_PythonToCpp_QTextCharFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextCharFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextCharFormat(self)",
    "1:PySide2.QtGui.QTextCharFormat(self,QTextCharFormat:PySide2.QtGui.QTextCharFormat)",
    "0:PySide2.QtGui.QTextCharFormat(self,fmt:PySide2.QtGui.QTextFormat)",
    "PySide2.QtGui.QTextCharFormat.anchorHref(self)->QString",
    "PySide2.QtGui.QTextCharFormat.anchorName(self)->QString",
    "PySide2.QtGui.QTextCharFormat.anchorNames(self)->QStringList",
    "PySide2.QtGui.QTextCharFormat.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QTextCharFormat.fontCapitalization(self)->PySide2.QtGui.QFont.Capitalization",
    "PySide2.QtGui.QTextCharFormat.fontFamilies(self)->QVariant",
    "PySide2.QtGui.QTextCharFormat.fontFamily(self)->QString",
    "PySide2.QtGui.QTextCharFormat.fontFixedPitch(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontHintingPreference(self)->PySide2.QtGui.QFont.HintingPreference",
    "PySide2.QtGui.QTextCharFormat.fontItalic(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontKerning(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontLetterSpacing(self)->qreal",
    "PySide2.QtGui.QTextCharFormat.fontLetterSpacingType(self)->PySide2.QtGui.QFont.SpacingType",
    "PySide2.QtGui.QTextCharFormat.fontOverline(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontPointSize(self)->qreal",
    "PySide2.QtGui.QTextCharFormat.fontStretch(self)->int",
    "PySide2.QtGui.QTextCharFormat.fontStrikeOut(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontStyleHint(self)->PySide2.QtGui.QFont.StyleHint",
    "PySide2.QtGui.QTextCharFormat.fontStyleName(self)->QVariant",
    "PySide2.QtGui.QTextCharFormat.fontStyleStrategy(self)->PySide2.QtGui.QFont.StyleStrategy",
    "PySide2.QtGui.QTextCharFormat.fontUnderline(self)->bool",
    "PySide2.QtGui.QTextCharFormat.fontWeight(self)->int",
    "PySide2.QtGui.QTextCharFormat.fontWordSpacing(self)->qreal",
    "PySide2.QtGui.QTextCharFormat.isAnchor(self)->bool",
    "PySide2.QtGui.QTextCharFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextCharFormat.setAnchor(self,anchor:bool)",
    "PySide2.QtGui.QTextCharFormat.setAnchorHref(self,value:QString)",
    "PySide2.QtGui.QTextCharFormat.setAnchorName(self,name:QString)",
    "PySide2.QtGui.QTextCharFormat.setAnchorNames(self,names:QStringList)",
    "1:PySide2.QtGui.QTextCharFormat.setFont(self,font:PySide2.QtGui.QFont)",
    "0:PySide2.QtGui.QTextCharFormat.setFont(self,font:PySide2.QtGui.QFont,behavior:PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior)",
    "PySide2.QtGui.QTextCharFormat.setFontCapitalization(self,capitalization:PySide2.QtGui.QFont.Capitalization)",
    "PySide2.QtGui.QTextCharFormat.setFontFamilies(self,families:QStringList)",
    "PySide2.QtGui.QTextCharFormat.setFontFamily(self,family:QString)",
    "PySide2.QtGui.QTextCharFormat.setFontFixedPitch(self,fixedPitch:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontHintingPreference(self,hintingPreference:PySide2.QtGui.QFont.HintingPreference)",
    "PySide2.QtGui.QTextCharFormat.setFontItalic(self,italic:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontKerning(self,enable:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontLetterSpacing(self,spacing:qreal)",
    "PySide2.QtGui.QTextCharFormat.setFontLetterSpacingType(self,letterSpacingType:PySide2.QtGui.QFont.SpacingType)",
    "PySide2.QtGui.QTextCharFormat.setFontOverline(self,overline:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontPointSize(self,size:qreal)",
    "PySide2.QtGui.QTextCharFormat.setFontStretch(self,factor:int)",
    "PySide2.QtGui.QTextCharFormat.setFontStrikeOut(self,strikeOut:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontStyleHint(self,hint:PySide2.QtGui.QFont.StyleHint,strategy:PySide2.QtGui.QFont.StyleStrategy=QFont.PreferDefault)",
    "PySide2.QtGui.QTextCharFormat.setFontStyleName(self,styleName:QString)",
    "PySide2.QtGui.QTextCharFormat.setFontStyleStrategy(self,strategy:PySide2.QtGui.QFont.StyleStrategy)",
    "PySide2.QtGui.QTextCharFormat.setFontUnderline(self,underline:bool)",
    "PySide2.QtGui.QTextCharFormat.setFontWeight(self,weight:int)",
    "PySide2.QtGui.QTextCharFormat.setFontWordSpacing(self,spacing:qreal)",
    "PySide2.QtGui.QTextCharFormat.setTableCellColumnSpan(self,tableCellColumnSpan:int)",
    "PySide2.QtGui.QTextCharFormat.setTableCellRowSpan(self,tableCellRowSpan:int)",
    "PySide2.QtGui.QTextCharFormat.setTextOutline(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QTextCharFormat.setToolTip(self,tip:QString)",
    "PySide2.QtGui.QTextCharFormat.setUnderlineColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QTextCharFormat.setUnderlineStyle(self,style:PySide2.QtGui.QTextCharFormat.UnderlineStyle)",
    "PySide2.QtGui.QTextCharFormat.setVerticalAlignment(self,alignment:PySide2.QtGui.QTextCharFormat.VerticalAlignment)",
    "PySide2.QtGui.QTextCharFormat.tableCellColumnSpan(self)->int",
    "PySide2.QtGui.QTextCharFormat.tableCellRowSpan(self)->int",
    "PySide2.QtGui.QTextCharFormat.textOutline(self)->PySide2.QtGui.QPen",
    "PySide2.QtGui.QTextCharFormat.toolTip(self)->QString",
    "PySide2.QtGui.QTextCharFormat.underlineColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QTextCharFormat.underlineStyle(self)->PySide2.QtGui.QTextCharFormat.UnderlineStyle",
    "PySide2.QtGui.QTextCharFormat.verticalAlignment(self)->PySide2.QtGui.QTextCharFormat.VerticalAlignment",
    "PySide2.QtGui.QTextCharFormat.__copy__()",
    nullptr}; // Sentinel

void init_QTextCharFormat(PyObject *module)
{
    _Sbk_QTextCharFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextCharFormat",
        "QTextCharFormat",
        &Sbk_QTextCharFormat_spec,
        &Shiboken::callCppDestructor< ::QTextCharFormat >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextCharFormat_Type);
    InitSignatureStrings(pyType, QTextCharFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextCharFormat_Type), Sbk_QTextCharFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextCharFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextCharFormat_TypeF(),
        QTextCharFormat_PythonToCpp_QTextCharFormat_PTR,
        is_QTextCharFormat_PythonToCpp_QTextCharFormat_PTR_Convertible,
        QTextCharFormat_PTR_CppToPython_QTextCharFormat,
        QTextCharFormat_COPY_CppToPython_QTextCharFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextCharFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextCharFormat_PythonToCpp_QTextCharFormat_COPY,
        is_QTextCharFormat_PythonToCpp_QTextCharFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'VerticalAlignment'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCharFormat_TypeF(),
        "VerticalAlignment",
        "2:PySide2.QtGui.QTextCharFormat.VerticalAlignment",
        "QTextCharFormat::VerticalAlignment");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignNormal", (long) QTextCharFormat::VerticalAlignment::AlignNormal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignSuperScript", (long) QTextCharFormat::VerticalAlignment::AlignSuperScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignSubScript", (long) QTextCharFormat::VerticalAlignment::AlignSubScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignMiddle", (long) QTextCharFormat::VerticalAlignment::AlignMiddle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignTop", (long) QTextCharFormat::VerticalAlignment::AlignTop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignBottom", (long) QTextCharFormat::VerticalAlignment::AlignBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
        Sbk_QTextCharFormat_TypeF(), "AlignBaseline", (long) QTextCharFormat::VerticalAlignment::AlignBaseline))
        return;
    // Register converter for enum 'QTextCharFormat::VerticalAlignment'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX],
            QTextCharFormat_VerticalAlignment_CppToPython_QTextCharFormat_VerticalAlignment);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCharFormat_VerticalAlignment_PythonToCpp_QTextCharFormat_VerticalAlignment,
            is_QTextCharFormat_VerticalAlignment_PythonToCpp_QTextCharFormat_VerticalAlignment_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_VERTICALALIGNMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat::VerticalAlignment");
        Shiboken::Conversions::registerConverterName(converter, "VerticalAlignment");
    }
    // End of 'VerticalAlignment' enum.

    // Initialization of enum 'UnderlineStyle'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCharFormat_TypeF(),
        "UnderlineStyle",
        "2:PySide2.QtGui.QTextCharFormat.UnderlineStyle",
        "QTextCharFormat::UnderlineStyle");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "NoUnderline", (long) QTextCharFormat::UnderlineStyle::NoUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "SingleUnderline", (long) QTextCharFormat::UnderlineStyle::SingleUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "DashUnderline", (long) QTextCharFormat::UnderlineStyle::DashUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "DotLine", (long) QTextCharFormat::UnderlineStyle::DotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "DashDotLine", (long) QTextCharFormat::UnderlineStyle::DashDotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "DashDotDotLine", (long) QTextCharFormat::UnderlineStyle::DashDotDotLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "WaveUnderline", (long) QTextCharFormat::UnderlineStyle::WaveUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
        Sbk_QTextCharFormat_TypeF(), "SpellCheckUnderline", (long) QTextCharFormat::UnderlineStyle::SpellCheckUnderline))
        return;
    // Register converter for enum 'QTextCharFormat::UnderlineStyle'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX],
            QTextCharFormat_UnderlineStyle_CppToPython_QTextCharFormat_UnderlineStyle);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCharFormat_UnderlineStyle_PythonToCpp_QTextCharFormat_UnderlineStyle,
            is_QTextCharFormat_UnderlineStyle_PythonToCpp_QTextCharFormat_UnderlineStyle_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_UNDERLINESTYLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat::UnderlineStyle");
        Shiboken::Conversions::registerConverterName(converter, "UnderlineStyle");
    }
    // End of 'UnderlineStyle' enum.

    // Initialization of enum 'FontPropertiesInheritanceBehavior'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCharFormat_TypeF(),
        "FontPropertiesInheritanceBehavior",
        "2:PySide2.QtGui.QTextCharFormat.FontPropertiesInheritanceBehavior",
        "QTextCharFormat::FontPropertiesInheritanceBehavior");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX],
        Sbk_QTextCharFormat_TypeF(), "FontPropertiesSpecifiedOnly", (long) QTextCharFormat::FontPropertiesInheritanceBehavior::FontPropertiesSpecifiedOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX],
        Sbk_QTextCharFormat_TypeF(), "FontPropertiesAll", (long) QTextCharFormat::FontPropertiesInheritanceBehavior::FontPropertiesAll))
        return;
    // Register converter for enum 'QTextCharFormat::FontPropertiesInheritanceBehavior'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX],
            QTextCharFormat_FontPropertiesInheritanceBehavior_CppToPython_QTextCharFormat_FontPropertiesInheritanceBehavior);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCharFormat_FontPropertiesInheritanceBehavior_PythonToCpp_QTextCharFormat_FontPropertiesInheritanceBehavior,
            is_QTextCharFormat_FontPropertiesInheritanceBehavior_PythonToCpp_QTextCharFormat_FontPropertiesInheritanceBehavior_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_FONTPROPERTIESINHERITANCEBEHAVIOR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCharFormat::FontPropertiesInheritanceBehavior");
        Shiboken::Conversions::registerConverterName(converter, "FontPropertiesInheritanceBehavior");
    }
    // End of 'FontPropertiesInheritanceBehavior' enum.

    qRegisterMetaType< ::QTextCharFormat >("QTextCharFormat");
    qRegisterMetaType< ::QTextCharFormat::VerticalAlignment >("QTextCharFormat::VerticalAlignment");
    qRegisterMetaType< ::QTextCharFormat::UnderlineStyle >("QTextCharFormat::UnderlineStyle");
    qRegisterMetaType< ::QTextCharFormat::FontPropertiesInheritanceBehavior >("QTextCharFormat::FontPropertiesInheritanceBehavior");
}
