/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextcursor_wrapper.h"

// inner classes

// Extra includes
#include <QTextBlock>
#include <QTextDocumentFragment>
#include <QtGui/qimage.h>
#include <QtGui/qtextcursor.h>
#include <QtGui/qtextdocument.h>
#include <QtGui/qtextdocumentfragment.h>
#include <QtGui/qtextformat.h>
#include <QtGui/qtextlist.h>
#include <QtGui/qtextobject.h>
#include <QtGui/qtexttable.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextCursor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextCursor >()))
        return -1;

    ::QTextCursor *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextCursor", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextCursor::QTextCursor()
    // 1: QTextCursor::QTextCursor(QTextDocument*)
    // 2: QTextCursor::QTextCursor(QTextFrame*)
    // 3: QTextCursor::QTextCursor(QTextBlock)
    // 4: QTextCursor::QTextCursor(QTextCursor)
    if (numArgs == 0) {
        overloadId = 0; // QTextCursor()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QTextCursor(QTextCursor)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QTextCursor(QTextBlock)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTextCursor(QTextFrame*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextCursor(QTextDocument*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursor_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextCursor()
        {

            if (!PyErr_Occurred()) {
                // QTextCursor()
                cptr = new ::QTextCursor();
            }
            break;
        }
        case 1: // QTextCursor(QTextDocument * document)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextDocument *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextCursor(QTextDocument*)
                cptr = new ::QTextCursor(cppArg0);
            }
            break;
        }
        case 2: // QTextCursor(QTextFrame * frame)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFrame *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextCursor(QTextFrame*)
                cptr = new ::QTextCursor(cppArg0);
            }
            break;
        }
        case 3: // QTextCursor(const QTextBlock & block)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextBlock cppArg0_local;
            ::QTextBlock *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextCursor(QTextBlock)
                cptr = new ::QTextCursor(*cppArg0);
            }
            break;
        }
        case 4: // QTextCursor(const QTextCursor & cursor)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextCursor cppArg0_local;
            ::QTextCursor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextCursor(QTextCursor)
                cptr = new ::QTextCursor(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextCursor >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextCursor_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextCursor_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextCursorFunc_anchor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.anchor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // anchor()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->anchor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_atBlockEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.atBlockEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atBlockEnd()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->atBlockEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_atBlockStart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.atBlockStart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atBlockStart()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->atBlockStart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_atEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.atEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atEnd()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->atEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_atStart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.atStart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // atStart()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->atStart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_beginEditBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.beginEditBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // beginEditBlock()
            cppSelf->beginEditBlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_block(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.block";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // block()const
            QTextBlock cppResult = const_cast<const ::QTextCursor *>(cppSelf)->block();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCK_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_blockCharFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.blockCharFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockCharFormat()const
            QTextCharFormat cppResult = const_cast<const ::QTextCursor *>(cppSelf)->blockCharFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_blockFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.blockFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockFormat()const
            QTextBlockFormat cppResult = const_cast<const ::QTextCursor *>(cppSelf)->blockFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_blockNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.blockNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blockNumber()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->blockNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_charFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.charFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // charFormat()const
            QTextCharFormat cppResult = const_cast<const ::QTextCursor *>(cppSelf)->charFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_clearSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.clearSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearSelection()
            cppSelf->clearSelection();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_columnNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.columnNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnNumber()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->columnNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_createList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.createList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::createList(QTextListFormat::Style)
    // 1: QTextCursor::createList(QTextListFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), (pyArg)))) {
        overloadId = 1; // createList(QTextListFormat)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // createList(QTextListFormat::Style)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_createList_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createList(QTextListFormat::Style style)
        {
            ::QTextListFormat::Style cppArg0{QTextListFormat::ListStyleUndefined};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // createList(QTextListFormat::Style)
                QTextList * cppResult = cppSelf->createList(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // createList(const QTextListFormat & format)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextListFormat cppArg0_local;
            ::QTextListFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // createList(QTextListFormat)
                QTextList * cppResult = cppSelf->createList(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_createList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_currentFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.currentFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentFrame()const
            QTextFrame * cppResult = const_cast<const ::QTextCursor *>(cppSelf)->currentFrame();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_currentList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.currentList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentList()const
            QTextList * cppResult = const_cast<const ::QTextCursor *>(cppSelf)->currentList();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_currentTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.currentTable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentTable()const
            QTextTable * cppResult = const_cast<const ::QTextCursor *>(cppSelf)->currentTable();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLE_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_deleteChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.deleteChar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deleteChar()
            cppSelf->deleteChar();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_deletePreviousChar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.deletePreviousChar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deletePreviousChar()
            cppSelf->deletePreviousChar();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_document(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.document";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // document()const
            QTextDocument * cppResult = const_cast<const ::QTextCursor *>(cppSelf)->document();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_endEditBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.endEditBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endEditBlock()
            cppSelf->endEditBlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_hasComplexSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.hasComplexSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasComplexSelection()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->hasComplexSelection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_hasSelection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.hasSelection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasSelection()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->hasSelection();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_insertBlock(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertBlock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertBlock", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::insertBlock()
    // 1: QTextCursor::insertBlock(QTextBlockFormat)
    // 2: QTextCursor::insertBlock(QTextBlockFormat,QTextCharFormat)
    if (numArgs == 0) {
        overloadId = 0; // insertBlock()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // insertBlock(QTextBlockFormat)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // insertBlock(QTextBlockFormat,QTextCharFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertBlock_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertBlock()
        {

            if (!PyErr_Occurred()) {
                // insertBlock()
                cppSelf->insertBlock();
            }
            break;
        }
        case 1: // insertBlock(const QTextBlockFormat & format)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextBlockFormat cppArg0_local;
            ::QTextBlockFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // insertBlock(QTextBlockFormat)
                cppSelf->insertBlock(*cppArg0);
            }
            break;
        }
        case 2: // insertBlock(const QTextBlockFormat & format, const QTextCharFormat & charFormat)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextBlockFormat cppArg0_local;
            ::QTextBlockFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCharFormat cppArg1_local;
            ::QTextCharFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // insertBlock(QTextBlockFormat,QTextCharFormat)
                cppSelf->insertBlock(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_insertBlock_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertFragment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertFragment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::insertFragment(QTextDocumentFragment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), (pyArg)))) {
        overloadId = 0; // insertFragment(QTextDocumentFragment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertFragment_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextDocumentFragment cppArg0_local;
        ::QTextDocumentFragment *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // insertFragment(QTextDocumentFragment)
            cppSelf->insertFragment(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_insertFragment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertFrame(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertFrame";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::insertFrame(QTextFrameFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // insertFrame(QTextFrameFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertFrame_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextFrameFormat cppArg0_local;
        ::QTextFrameFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // insertFrame(QTextFrameFormat)
            QTextFrame * cppResult = cppSelf->insertFrame(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAME_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_insertFrame_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertHtml(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertHtml";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::insertHtml(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // insertHtml(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertHtml_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // insertHtml(QString)
            cppSelf->insertHtml(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_insertHtml_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_insertImage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_insertImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:insertImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::insertImage(QImage,QString)
    // 1: QTextCursor::insertImage(QString)
    // 2: QTextCursor::insertImage(QTextImageFormat)
    // 3: QTextCursor::insertImage(QTextImageFormat,QTextFrameFormat::Position)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // insertImage(QTextImageFormat)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_POSITION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // insertImage(QTextImageFormat,QTextFrameFormat::Position)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // insertImage(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // insertImage(QImage,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // insertImage(QImage,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertImage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertImage(const QImage & image, const QString & name)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_name = Shiboken::String::createStaticString("name");
                if (PyDict_Contains(kwds, key_name)) {
                    value = PyDict_GetItem(kwds, key_name);
                    if (value && pyArgs[1]) {
                        errInfo = key_name;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextCursorFunc_insertImage_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QTextCursorFunc_insertImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_name);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextCursorFunc_insertImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // insertImage(QImage,QString)
                cppSelf->insertImage(*cppArg0, cppArg1);
            }
            break;
        }
        case 1: // insertImage(const QString & name)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextCursorFunc_insertImage_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // insertImage(QString)
                cppSelf->insertImage(cppArg0);
            }
            break;
        }
        case 2: // insertImage(const QTextImageFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextCursorFunc_insertImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextImageFormat cppArg0_local;
            ::QTextImageFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // insertImage(QTextImageFormat)
                cppSelf->insertImage(*cppArg0);
            }
            break;
        }
        case 3: // insertImage(const QTextImageFormat & format, QTextFrameFormat::Position alignment)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextCursorFunc_insertImage_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QTextImageFormat cppArg0_local;
            ::QTextImageFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QTextFrameFormat::Position cppArg1{QTextFrameFormat::InFlow};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // insertImage(QTextImageFormat,QTextFrameFormat::Position)
                cppSelf->insertImage(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_insertImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertList";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::insertList(QTextListFormat::Style)
    // 1: QTextCursor::insertList(QTextListFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), (pyArg)))) {
        overloadId = 1; // insertList(QTextListFormat)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_STYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // insertList(QTextListFormat::Style)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertList_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertList(QTextListFormat::Style style)
        {
            ::QTextListFormat::Style cppArg0{QTextListFormat::ListStyleUndefined};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // insertList(QTextListFormat::Style)
                QTextList * cppResult = cppSelf->insertList(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // insertList(const QTextListFormat & format)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QTextListFormat cppArg0_local;
            ::QTextListFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // insertList(QTextListFormat)
                QTextList * cppResult = cppSelf->insertList(*cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLIST_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_insertList_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertTable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertTable", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::insertTable(int,int)
    // 1: QTextCursor::insertTable(int,int,QTextTableFormat)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // insertTable(int,int)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // insertTable(int,int,QTextTableFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertTable_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertTable(int rows, int cols)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // insertTable(int,int)
                QTextTable * cppResult = cppSelf->insertTable(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLE_IDX]), cppResult);

                // Ownership transferences.
            }
            break;
        }
        case 1: // insertTable(int rows, int cols, const QTextTableFormat & format)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QTextTableFormat cppArg2_local;
            ::QTextTableFormat *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // insertTable(int,int,QTextTableFormat)
                QTextTable * cppResult = cppSelf->insertTable(cppArg0, cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLE_IDX]), cppResult);

                // Ownership transferences.
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_insertTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_insertText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.insertText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "insertText", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::insertText(QString)
    // 1: QTextCursor::insertText(QString,QTextCharFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // insertText(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // insertText(QString,QTextCharFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_insertText_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // insertText(const QString & text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // insertText(QString)
                cppSelf->insertText(cppArg0);
            }
            break;
        }
        case 1: // insertText(const QString & text, const QTextCharFormat & format)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QTextCharFormat cppArg1_local;
            ::QTextCharFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // insertText(QString,QTextCharFormat)
                cppSelf->insertText(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_insertText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_isCopyOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.isCopyOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::isCopyOf(QTextCursor)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
        overloadId = 0; // isCopyOf(QTextCursor)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_isCopyOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCursor cppArg0_local;
        ::QTextCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isCopyOf(QTextCursor)const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->isCopyOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_isCopyOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_joinPreviousEditBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.joinPreviousEditBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // joinPreviousEditBlock()
            cppSelf->joinPreviousEditBlock();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_keepPositionOnInsert(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.keepPositionOnInsert";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keepPositionOnInsert()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->keepPositionOnInsert();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_mergeBlockCharFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.mergeBlockCharFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::mergeBlockCharFormat(QTextCharFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // mergeBlockCharFormat(QTextCharFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_mergeBlockCharFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCharFormat cppArg0_local;
        ::QTextCharFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mergeBlockCharFormat(QTextCharFormat)
            cppSelf->mergeBlockCharFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_mergeBlockCharFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_mergeBlockFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.mergeBlockFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::mergeBlockFormat(QTextBlockFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // mergeBlockFormat(QTextBlockFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_mergeBlockFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextBlockFormat cppArg0_local;
        ::QTextBlockFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mergeBlockFormat(QTextBlockFormat)
            cppSelf->mergeBlockFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_mergeBlockFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_mergeCharFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.mergeCharFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::mergeCharFormat(QTextCharFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // mergeCharFormat(QTextCharFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_mergeCharFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCharFormat cppArg0_local;
        ::QTextCharFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mergeCharFormat(QTextCharFormat)
            cppSelf->mergeCharFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_mergeCharFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_movePosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.movePosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_movePosition_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_movePosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:movePosition", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_movePosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__2 = Shiboken::String::createStaticString("arg__2");
            if (PyDict_Contains(kwds, key_arg__2)) {
                value = PyDict_GetItem(kwds, key_arg__2);
                if (value && pyArgs[1]) {
                    errInfo = key_arg__2;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCursorFunc_movePosition_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QTextCursorFunc_movePosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__2);
            }
            static PyObject *const key_n = Shiboken::String::createStaticString("n");
            if (PyDict_Contains(kwds, key_n)) {
                value = PyDict_GetItem(kwds, key_n);
                if (value && pyArgs[2]) {
                    errInfo = key_n;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCursorFunc_movePosition_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QTextCursorFunc_movePosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_n);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCursorFunc_movePosition_TypeError;
            }
        }
        ::QTextCursor::MoveOperation cppArg0{QTextCursor::NoMove};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QTextCursor::MoveMode cppArg1 = QTextCursor::MoveMode::MoveAnchor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // movePosition(QTextCursor::MoveOperation,QTextCursor::MoveMode,int)
            bool cppResult = cppSelf->movePosition(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextCursorFunc_movePosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_positionInBlock(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.positionInBlock";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // positionInBlock()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->positionInBlock();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_removeSelectedText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.removeSelectedText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // removeSelectedText()
            cppSelf->removeSelectedText();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextCursorFunc_select(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.select";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::select(QTextCursor::SelectionType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // select(QTextCursor::SelectionType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_select_TypeError;

    // Call function/method
    {
        ::QTextCursor::SelectionType cppArg0{QTextCursor::WordUnderCursor};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // select(QTextCursor::SelectionType)
            cppSelf->select(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_select_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_selectedTableCells(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.selectedTableCells";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedTableCells(int*,int*,int*,int*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            int a, b, c, d;
            cppSelf->::QTextCursor::selectedTableCells(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_selectedText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.selectedText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedText()const
            QString cppResult = const_cast<const ::QTextCursor *>(cppSelf)->selectedText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_selection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.selection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selection()const
            QTextDocumentFragment cppResult = const_cast<const ::QTextCursor *>(cppSelf)->selection();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENTFRAGMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_selectionEnd(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.selectionEnd";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionEnd()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->selectionEnd();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_selectionStart(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.selectionStart";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectionStart()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->selectionStart();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_setBlockCharFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setBlockCharFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setBlockCharFormat(QTextCharFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setBlockCharFormat(QTextCharFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setBlockCharFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCharFormat cppArg0_local;
        ::QTextCharFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBlockCharFormat(QTextCharFormat)
            cppSelf->setBlockCharFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setBlockCharFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setBlockFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setBlockFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setBlockFormat(QTextBlockFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setBlockFormat(QTextBlockFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setBlockFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextBlockFormat cppArg0_local;
        ::QTextBlockFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBlockFormat(QTextBlockFormat)
            cppSelf->setBlockFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setBlockFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setCharFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setCharFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setCharFormat(QTextCharFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setCharFormat(QTextCharFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setCharFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCharFormat cppArg0_local;
        ::QTextCharFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCharFormat(QTextCharFormat)
            cppSelf->setCharFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setCharFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setKeepPositionOnInsert(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setKeepPositionOnInsert";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setKeepPositionOnInsert(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeepPositionOnInsert(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setKeepPositionOnInsert_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeepPositionOnInsert(bool)
            cppSelf->setKeepPositionOnInsert(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setKeepPositionOnInsert_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setPosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_setPosition_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QTextCursorFunc_setPosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPosition", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextCursor::setPosition(int,QTextCursor::MoveMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPosition(int,QTextCursor::MoveMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setPosition(int,QTextCursor::MoveMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setPosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QTextCursorFunc_setPosition_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QTextCursorFunc_setPosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QTextCursorFunc_setPosition_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QTextCursor::MoveMode cppArg1 = QTextCursor::MoveMode::MoveAnchor;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setPosition(int,QTextCursor::MoveMode)
            cppSelf->setPosition(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setVerticalMovementX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setVerticalMovementX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setVerticalMovementX(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVerticalMovementX(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setVerticalMovementX_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVerticalMovementX(int)
            cppSelf->setVerticalMovementX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setVerticalMovementX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_setVisualNavigation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.setVisualNavigation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::setVisualNavigation(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisualNavigation(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_setVisualNavigation_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisualNavigation(bool)
            cppSelf->setVisualNavigation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_setVisualNavigation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextCursor::swap(QTextCursor&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QTextCursor&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextCursorFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextCursor cppArg0_local;
        ::QTextCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QTextCursor&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextCursorFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextCursorFunc_verticalMovementX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.verticalMovementX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // verticalMovementX()const
            int cppResult = const_cast<const ::QTextCursor *>(cppSelf)->verticalMovementX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursorFunc_visualNavigation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextCursor.visualNavigation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // visualNavigation()const
            bool cppResult = const_cast<const ::QTextCursor *>(cppSelf)->visualNavigation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextCursor___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextCursor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextCursor_methods[] = {
    {"anchor", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_anchor), METH_NOARGS},
    {"atBlockEnd", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_atBlockEnd), METH_NOARGS},
    {"atBlockStart", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_atBlockStart), METH_NOARGS},
    {"atEnd", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_atEnd), METH_NOARGS},
    {"atStart", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_atStart), METH_NOARGS},
    {"beginEditBlock", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_beginEditBlock), METH_NOARGS},
    {"block", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_block), METH_NOARGS},
    {"blockCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_blockCharFormat), METH_NOARGS},
    {"blockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_blockFormat), METH_NOARGS},
    {"blockNumber", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_blockNumber), METH_NOARGS},
    {"charFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_charFormat), METH_NOARGS},
    {"clearSelection", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_clearSelection), METH_NOARGS},
    {"columnNumber", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_columnNumber), METH_NOARGS},
    {"createList", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_createList), METH_O},
    {"currentFrame", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_currentFrame), METH_NOARGS},
    {"currentList", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_currentList), METH_NOARGS},
    {"currentTable", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_currentTable), METH_NOARGS},
    {"deleteChar", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_deleteChar), METH_NOARGS},
    {"deletePreviousChar", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_deletePreviousChar), METH_NOARGS},
    {"document", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_document), METH_NOARGS},
    {"endEditBlock", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_endEditBlock), METH_NOARGS},
    {"hasComplexSelection", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_hasComplexSelection), METH_NOARGS},
    {"hasSelection", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_hasSelection), METH_NOARGS},
    {"insertBlock", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertBlock), METH_VARARGS},
    {"insertFragment", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertFragment), METH_O},
    {"insertFrame", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertFrame), METH_O},
    {"insertHtml", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertHtml), METH_O},
    {"insertImage", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertImage), METH_VARARGS|METH_KEYWORDS},
    {"insertList", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertList), METH_O},
    {"insertTable", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertTable), METH_VARARGS},
    {"insertText", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_insertText), METH_VARARGS},
    {"isCopyOf", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_isCopyOf), METH_O},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_isNull), METH_NOARGS},
    {"joinPreviousEditBlock", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_joinPreviousEditBlock), METH_NOARGS},
    {"keepPositionOnInsert", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_keepPositionOnInsert), METH_NOARGS},
    {"mergeBlockCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_mergeBlockCharFormat), METH_O},
    {"mergeBlockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_mergeBlockFormat), METH_O},
    {"mergeCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_mergeCharFormat), METH_O},
    {"movePosition", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_movePosition), METH_VARARGS|METH_KEYWORDS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_position), METH_NOARGS},
    {"positionInBlock", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_positionInBlock), METH_NOARGS},
    {"removeSelectedText", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_removeSelectedText), METH_NOARGS},
    {"select", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_select), METH_O},
    {"selectedTableCells", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_selectedTableCells), METH_NOARGS},
    {"selectedText", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_selectedText), METH_NOARGS},
    {"selection", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_selection), METH_NOARGS},
    {"selectionEnd", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_selectionEnd), METH_NOARGS},
    {"selectionStart", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_selectionStart), METH_NOARGS},
    {"setBlockCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setBlockCharFormat), METH_O},
    {"setBlockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setBlockFormat), METH_O},
    {"setCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setCharFormat), METH_O},
    {"setKeepPositionOnInsert", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setKeepPositionOnInsert), METH_O},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setPosition), METH_VARARGS|METH_KEYWORDS},
    {"setVerticalMovementX", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setVerticalMovementX), METH_O},
    {"setVisualNavigation", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_setVisualNavigation), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_swap), METH_O},
    {"verticalMovementX", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_verticalMovementX), METH_NOARGS},
    {"visualNavigation", reinterpret_cast<PyCFunction>(Sbk_QTextCursorFunc_visualNavigation), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextCursor___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextCursor___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QTextCursor_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator!=(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_LT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator<(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTextCursor_RichComparison_TypeError;
            }

            break;
        case Py_LE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator<=(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf <=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTextCursor_RichComparison_TypeError;
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator==(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        case Py_GT:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator>(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTextCursor_RichComparison_TypeError;
            }

            break;
        case Py_GE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyArg)))) {
                // operator>=(const QTextCursor & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextCursor cppArg0_local;
                ::QTextCursor *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf >=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                goto Sbk_QTextCursor_RichComparison_TypeError;
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTextCursor_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTextCursor_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QTextCursor_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextCursor_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextCursor_Type = nullptr;
static SbkObjectType *Sbk_QTextCursor_TypeF(void)
{
    return _Sbk_QTextCursor_Type;
}

static PyType_Slot Sbk_QTextCursor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextCursor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextCursor_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTextCursor_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextCursor_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextCursor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QTextCursor___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QTextCursor___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QTextCursor_spec = {
    "2:PySide2.QtGui.QTextCursor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextCursor_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QTextCursor_MoveMode_PythonToCpp_QTextCursor_MoveMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCursor::MoveMode *>(cppOut) =
        static_cast<::QTextCursor::MoveMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCursor_MoveMode_PythonToCpp_QTextCursor_MoveMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX]))
        return QTextCursor_MoveMode_PythonToCpp_QTextCursor_MoveMode;
    return {};
}
static PyObject *QTextCursor_MoveMode_CppToPython_QTextCursor_MoveMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCursor::MoveMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX], castCppIn);

}

static void QTextCursor_MoveOperation_PythonToCpp_QTextCursor_MoveOperation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCursor::MoveOperation *>(cppOut) =
        static_cast<::QTextCursor::MoveOperation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCursor_MoveOperation_PythonToCpp_QTextCursor_MoveOperation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX]))
        return QTextCursor_MoveOperation_PythonToCpp_QTextCursor_MoveOperation;
    return {};
}
static PyObject *QTextCursor_MoveOperation_CppToPython_QTextCursor_MoveOperation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCursor::MoveOperation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX], castCppIn);

}

static void QTextCursor_SelectionType_PythonToCpp_QTextCursor_SelectionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCursor::SelectionType *>(cppOut) =
        static_cast<::QTextCursor::SelectionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextCursor_SelectionType_PythonToCpp_QTextCursor_SelectionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX]))
        return QTextCursor_SelectionType_PythonToCpp_QTextCursor_SelectionType;
    return {};
}
static PyObject *QTextCursor_SelectionType_CppToPython_QTextCursor_SelectionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextCursor::SelectionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextCursor_PythonToCpp_QTextCursor_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextCursor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextCursor_PythonToCpp_QTextCursor_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCursor_TypeF())))
        return QTextCursor_PythonToCpp_QTextCursor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextCursor_PTR_CppToPython_QTextCursor(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextCursor *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextCursor_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextCursor_COPY_CppToPython_QTextCursor(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextCursor_TypeF(), new ::QTextCursor(*reinterpret_cast<const ::QTextCursor *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextCursor_PythonToCpp_QTextCursor_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextCursor *>(cppOut) = *reinterpret_cast< ::QTextCursor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextCursor_PythonToCpp_QTextCursor_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextCursor_TypeF())))
        return QTextCursor_PythonToCpp_QTextCursor_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextCursor_SignatureStrings[] = {
    "4:PySide2.QtGui.QTextCursor(self)",
    "3:PySide2.QtGui.QTextCursor(self,document:PySide2.QtGui.QTextDocument)",
    "2:PySide2.QtGui.QTextCursor(self,frame:PySide2.QtGui.QTextFrame)",
    "1:PySide2.QtGui.QTextCursor(self,block:PySide2.QtGui.QTextBlock)",
    "0:PySide2.QtGui.QTextCursor(self,cursor:PySide2.QtGui.QTextCursor)",
    "PySide2.QtGui.QTextCursor.anchor(self)->int",
    "PySide2.QtGui.QTextCursor.atBlockEnd(self)->bool",
    "PySide2.QtGui.QTextCursor.atBlockStart(self)->bool",
    "PySide2.QtGui.QTextCursor.atEnd(self)->bool",
    "PySide2.QtGui.QTextCursor.atStart(self)->bool",
    "PySide2.QtGui.QTextCursor.beginEditBlock(self)",
    "PySide2.QtGui.QTextCursor.block(self)->PySide2.QtGui.QTextBlock",
    "PySide2.QtGui.QTextCursor.blockCharFormat(self)->PySide2.QtGui.QTextCharFormat",
    "PySide2.QtGui.QTextCursor.blockFormat(self)->PySide2.QtGui.QTextBlockFormat",
    "PySide2.QtGui.QTextCursor.blockNumber(self)->int",
    "PySide2.QtGui.QTextCursor.charFormat(self)->PySide2.QtGui.QTextCharFormat",
    "PySide2.QtGui.QTextCursor.clearSelection(self)",
    "PySide2.QtGui.QTextCursor.columnNumber(self)->int",
    "1:PySide2.QtGui.QTextCursor.createList(self,style:PySide2.QtGui.QTextListFormat.Style)->PySide2.QtGui.QTextList",
    "0:PySide2.QtGui.QTextCursor.createList(self,format:PySide2.QtGui.QTextListFormat)->PySide2.QtGui.QTextList",
    "PySide2.QtGui.QTextCursor.currentFrame(self)->PySide2.QtGui.QTextFrame",
    "PySide2.QtGui.QTextCursor.currentList(self)->PySide2.QtGui.QTextList",
    "PySide2.QtGui.QTextCursor.currentTable(self)->PySide2.QtGui.QTextTable",
    "PySide2.QtGui.QTextCursor.deleteChar(self)",
    "PySide2.QtGui.QTextCursor.deletePreviousChar(self)",
    "PySide2.QtGui.QTextCursor.document(self)->PySide2.QtGui.QTextDocument",
    "PySide2.QtGui.QTextCursor.endEditBlock(self)",
    "PySide2.QtGui.QTextCursor.hasComplexSelection(self)->bool",
    "PySide2.QtGui.QTextCursor.hasSelection(self)->bool",
    "2:PySide2.QtGui.QTextCursor.insertBlock(self)",
    "1:PySide2.QtGui.QTextCursor.insertBlock(self,format:PySide2.QtGui.QTextBlockFormat)",
    "0:PySide2.QtGui.QTextCursor.insertBlock(self,format:PySide2.QtGui.QTextBlockFormat,charFormat:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.insertFragment(self,fragment:PySide2.QtGui.QTextDocumentFragment)",
    "PySide2.QtGui.QTextCursor.insertFrame(self,format:PySide2.QtGui.QTextFrameFormat)->PySide2.QtGui.QTextFrame",
    "PySide2.QtGui.QTextCursor.insertHtml(self,html:QString)",
    "3:PySide2.QtGui.QTextCursor.insertImage(self,image:PySide2.QtGui.QImage,name:QString=QString())",
    "2:PySide2.QtGui.QTextCursor.insertImage(self,name:QString)",
    "1:PySide2.QtGui.QTextCursor.insertImage(self,format:PySide2.QtGui.QTextImageFormat)",
    "0:PySide2.QtGui.QTextCursor.insertImage(self,format:PySide2.QtGui.QTextImageFormat,alignment:PySide2.QtGui.QTextFrameFormat.Position)",
    "1:PySide2.QtGui.QTextCursor.insertList(self,style:PySide2.QtGui.QTextListFormat.Style)->PySide2.QtGui.QTextList",
    "0:PySide2.QtGui.QTextCursor.insertList(self,format:PySide2.QtGui.QTextListFormat)->PySide2.QtGui.QTextList",
    "1:PySide2.QtGui.QTextCursor.insertTable(self,rows:int,cols:int)->PySide2.QtGui.QTextTable",
    "0:PySide2.QtGui.QTextCursor.insertTable(self,rows:int,cols:int,format:PySide2.QtGui.QTextTableFormat)->PySide2.QtGui.QTextTable",
    "1:PySide2.QtGui.QTextCursor.insertText(self,text:QString)",
    "0:PySide2.QtGui.QTextCursor.insertText(self,text:QString,format:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.isCopyOf(self,other:PySide2.QtGui.QTextCursor)->bool",
    "PySide2.QtGui.QTextCursor.isNull(self)->bool",
    "PySide2.QtGui.QTextCursor.joinPreviousEditBlock(self)",
    "PySide2.QtGui.QTextCursor.keepPositionOnInsert(self)->bool",
    "PySide2.QtGui.QTextCursor.mergeBlockCharFormat(self,modifier:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.mergeBlockFormat(self,modifier:PySide2.QtGui.QTextBlockFormat)",
    "PySide2.QtGui.QTextCursor.mergeCharFormat(self,modifier:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.movePosition(self,op:PySide2.QtGui.QTextCursor.MoveOperation,arg__2:PySide2.QtGui.QTextCursor.MoveMode=MoveAnchor,n:int=1)->bool",
    "PySide2.QtGui.QTextCursor.position(self)->int",
    "PySide2.QtGui.QTextCursor.positionInBlock(self)->int",
    "PySide2.QtGui.QTextCursor.removeSelectedText(self)",
    "PySide2.QtGui.QTextCursor.select(self,selection:PySide2.QtGui.QTextCursor.SelectionType)",
    "PySide2.QtGui.QTextCursor.selectedTableCells(self,firstRow:int*,numRows:int*,firstColumn:int*,numColumns:int*)",
    "PySide2.QtGui.QTextCursor.selectedText(self)->QString",
    "PySide2.QtGui.QTextCursor.selection(self)->PySide2.QtGui.QTextDocumentFragment",
    "PySide2.QtGui.QTextCursor.selectionEnd(self)->int",
    "PySide2.QtGui.QTextCursor.selectionStart(self)->int",
    "PySide2.QtGui.QTextCursor.setBlockCharFormat(self,format:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.setBlockFormat(self,format:PySide2.QtGui.QTextBlockFormat)",
    "PySide2.QtGui.QTextCursor.setCharFormat(self,format:PySide2.QtGui.QTextCharFormat)",
    "PySide2.QtGui.QTextCursor.setKeepPositionOnInsert(self,b:bool)",
    "PySide2.QtGui.QTextCursor.setPosition(self,pos:int,mode:PySide2.QtGui.QTextCursor.MoveMode=MoveAnchor)",
    "PySide2.QtGui.QTextCursor.setVerticalMovementX(self,x:int)",
    "PySide2.QtGui.QTextCursor.setVisualNavigation(self,b:bool)",
    "PySide2.QtGui.QTextCursor.swap(self,other:PySide2.QtGui.QTextCursor)",
    "PySide2.QtGui.QTextCursor.verticalMovementX(self)->int",
    "PySide2.QtGui.QTextCursor.visualNavigation(self)->bool",
    "PySide2.QtGui.QTextCursor.__copy__()",
    nullptr}; // Sentinel

void init_QTextCursor(PyObject *module)
{
    _Sbk_QTextCursor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextCursor",
        "QTextCursor",
        &Sbk_QTextCursor_spec,
        &Shiboken::callCppDestructor< ::QTextCursor >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextCursor_Type);
    InitSignatureStrings(pyType, QTextCursor_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextCursor_Type), Sbk_QTextCursor_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextCursor_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextCursor_TypeF(),
        QTextCursor_PythonToCpp_QTextCursor_PTR,
        is_QTextCursor_PythonToCpp_QTextCursor_PTR_Convertible,
        QTextCursor_PTR_CppToPython_QTextCursor,
        QTextCursor_COPY_CppToPython_QTextCursor);

    Shiboken::Conversions::registerConverterName(converter, "QTextCursor");
    Shiboken::Conversions::registerConverterName(converter, "QTextCursor*");
    Shiboken::Conversions::registerConverterName(converter, "QTextCursor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextCursor).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextCursor_PythonToCpp_QTextCursor_COPY,
        is_QTextCursor_PythonToCpp_QTextCursor_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'MoveMode'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCursor_TypeF(),
        "MoveMode",
        "2:PySide2.QtGui.QTextCursor.MoveMode",
        "QTextCursor::MoveMode");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX],
        Sbk_QTextCursor_TypeF(), "MoveAnchor", (long) QTextCursor::MoveMode::MoveAnchor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX],
        Sbk_QTextCursor_TypeF(), "KeepAnchor", (long) QTextCursor::MoveMode::KeepAnchor))
        return;
    // Register converter for enum 'QTextCursor::MoveMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX],
            QTextCursor_MoveMode_CppToPython_QTextCursor_MoveMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCursor_MoveMode_PythonToCpp_QTextCursor_MoveMode,
            is_QTextCursor_MoveMode_PythonToCpp_QTextCursor_MoveMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCursor::MoveMode");
        Shiboken::Conversions::registerConverterName(converter, "MoveMode");
    }
    // End of 'MoveMode' enum.

    // Initialization of enum 'MoveOperation'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCursor_TypeF(),
        "MoveOperation",
        "2:PySide2.QtGui.QTextCursor.MoveOperation",
        "QTextCursor::MoveOperation");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NoMove", (long) QTextCursor::MoveOperation::NoMove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "Start", (long) QTextCursor::MoveOperation::Start))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "Up", (long) QTextCursor::MoveOperation::Up))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "StartOfLine", (long) QTextCursor::MoveOperation::StartOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "StartOfBlock", (long) QTextCursor::MoveOperation::StartOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "StartOfWord", (long) QTextCursor::MoveOperation::StartOfWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "PreviousBlock", (long) QTextCursor::MoveOperation::PreviousBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "PreviousCharacter", (long) QTextCursor::MoveOperation::PreviousCharacter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "PreviousWord", (long) QTextCursor::MoveOperation::PreviousWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "Left", (long) QTextCursor::MoveOperation::Left))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "WordLeft", (long) QTextCursor::MoveOperation::WordLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "End", (long) QTextCursor::MoveOperation::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "Down", (long) QTextCursor::MoveOperation::Down))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "EndOfLine", (long) QTextCursor::MoveOperation::EndOfLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "EndOfWord", (long) QTextCursor::MoveOperation::EndOfWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "EndOfBlock", (long) QTextCursor::MoveOperation::EndOfBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NextBlock", (long) QTextCursor::MoveOperation::NextBlock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NextCharacter", (long) QTextCursor::MoveOperation::NextCharacter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NextWord", (long) QTextCursor::MoveOperation::NextWord))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "Right", (long) QTextCursor::MoveOperation::Right))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "WordRight", (long) QTextCursor::MoveOperation::WordRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NextCell", (long) QTextCursor::MoveOperation::NextCell))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "PreviousCell", (long) QTextCursor::MoveOperation::PreviousCell))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "NextRow", (long) QTextCursor::MoveOperation::NextRow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
        Sbk_QTextCursor_TypeF(), "PreviousRow", (long) QTextCursor::MoveOperation::PreviousRow))
        return;
    // Register converter for enum 'QTextCursor::MoveOperation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX],
            QTextCursor_MoveOperation_CppToPython_QTextCursor_MoveOperation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCursor_MoveOperation_PythonToCpp_QTextCursor_MoveOperation,
            is_QTextCursor_MoveOperation_PythonToCpp_QTextCursor_MoveOperation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_MOVEOPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCursor::MoveOperation");
        Shiboken::Conversions::registerConverterName(converter, "MoveOperation");
    }
    // End of 'MoveOperation' enum.

    // Initialization of enum 'SelectionType'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextCursor_TypeF(),
        "SelectionType",
        "2:PySide2.QtGui.QTextCursor.SelectionType",
        "QTextCursor::SelectionType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX],
        Sbk_QTextCursor_TypeF(), "WordUnderCursor", (long) QTextCursor::SelectionType::WordUnderCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX],
        Sbk_QTextCursor_TypeF(), "LineUnderCursor", (long) QTextCursor::SelectionType::LineUnderCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX],
        Sbk_QTextCursor_TypeF(), "BlockUnderCursor", (long) QTextCursor::SelectionType::BlockUnderCursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX],
        Sbk_QTextCursor_TypeF(), "Document", (long) QTextCursor::SelectionType::Document))
        return;
    // Register converter for enum 'QTextCursor::SelectionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX],
            QTextCursor_SelectionType_CppToPython_QTextCursor_SelectionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextCursor_SelectionType_PythonToCpp_QTextCursor_SelectionType,
            is_QTextCursor_SelectionType_PythonToCpp_QTextCursor_SelectionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_SELECTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextCursor::SelectionType");
        Shiboken::Conversions::registerConverterName(converter, "SelectionType");
    }
    // End of 'SelectionType' enum.

    qRegisterMetaType< ::QTextCursor >("QTextCursor");
    qRegisterMetaType< ::QTextCursor::MoveMode >("QTextCursor::MoveMode");
    qRegisterMetaType< ::QTextCursor::MoveOperation >("QTextCursor::MoveOperation");
    qRegisterMetaType< ::QTextCursor::SelectionType >("QTextCursor::SelectionType");
}
