/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextformat_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpen.h>
#include <QtGui/qtextformat.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextFormat >()))
        return -1;

    ::QTextFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QTextFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QTextFormat::QTextFormat()
    // 1: QTextFormat::QTextFormat(QTextFormat)
    // 2: QTextFormat::QTextFormat(int)
    if (numArgs == 0) {
        overloadId = 0; // QTextFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QTextFormat(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QTextFormat(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTextFormat()
        {

            if (!PyErr_Occurred()) {
                // QTextFormat()
                cptr = new ::QTextFormat();
            }
            break;
        }
        case 1: // QTextFormat(const QTextFormat & rhs)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextFormat cppArg0_local;
            ::QTextFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTextFormat(QTextFormat)
                cptr = new ::QTextFormat(*cppArg0);
            }
            break;
        }
        case 2: // QTextFormat(int type)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTextFormat(int)
                cptr = new ::QTextFormat(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextFormatFunc_background(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.background";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // background()const
            QBrush cppResult = const_cast<const ::QTextFormat *>(cppSelf)->background();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_boolProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.boolProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::boolProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // boolProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_boolProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // boolProperty(int)const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->boolProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_boolProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_brushProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.brushProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::brushProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // brushProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_brushProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // brushProperty(int)const
            QBrush cppResult = const_cast<const ::QTextFormat *>(cppSelf)->brushProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_brushProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_clearBackground(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.clearBackground";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearBackground()
            cppSelf->clearBackground();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextFormatFunc_clearForeground(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.clearForeground";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearForeground()
            cppSelf->clearForeground();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QTextFormatFunc_clearProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.clearProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::clearProperty(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // clearProperty(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_clearProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // clearProperty(int)
            cppSelf->clearProperty(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_clearProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_colorProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.colorProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::colorProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // colorProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_colorProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // colorProperty(int)const
            QColor cppResult = const_cast<const ::QTextFormat *>(cppSelf)->colorProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_colorProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_doubleProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.doubleProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::doubleProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // doubleProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_doubleProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // doubleProperty(int)const
            qreal cppResult = const_cast<const ::QTextFormat *>(cppSelf)->doubleProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_doubleProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_foreground(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.foreground";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // foreground()const
            QBrush cppResult = const_cast<const ::QTextFormat *>(cppSelf)->foreground();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_hasProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.hasProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::hasProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // hasProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_hasProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasProperty(int)const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->hasProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_hasProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_intProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.intProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::intProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // intProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_intProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // intProperty(int)const
            int cppResult = const_cast<const ::QTextFormat *>(cppSelf)->intProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_intProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_isBlockFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isBlockFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBlockFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isBlockFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isCharFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isCharFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCharFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isCharFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isFrameFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isFrameFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFrameFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isFrameFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isImageFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isImageFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isImageFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isImageFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isListFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isListFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isListFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isListFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isTableCellFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isTableCellFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTableCellFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isTableCellFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isTableFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isTableFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTableFormat()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isTableFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QTextFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_layoutDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.layoutDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layoutDirection()const
            Qt::LayoutDirection cppResult = const_cast<const ::QTextFormat *>(cppSelf)->layoutDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_lengthProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.lengthProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::lengthProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // lengthProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_lengthProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // lengthProperty(int)const
            QTextLength cppResult = const_cast<const ::QTextFormat *>(cppSelf)->lengthProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLENGTH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_lengthProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_lengthVectorProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.lengthVectorProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::lengthVectorProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // lengthVectorProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_lengthVectorProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // lengthVectorProperty(int)const
            QVector<QTextLength > cppResult = const_cast<const ::QTextFormat *>(cppSelf)->lengthVectorProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLENGTH_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_lengthVectorProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_merge(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.merge";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::merge(QTextFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // merge(QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_merge_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextFormat cppArg0_local;
        ::QTextFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // merge(QTextFormat)
            cppSelf->merge(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_merge_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_objectIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.objectIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // objectIndex()const
            int cppResult = const_cast<const ::QTextFormat *>(cppSelf)->objectIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_objectType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.objectType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // objectType()const
            int cppResult = const_cast<const ::QTextFormat *>(cppSelf)->objectType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_penProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.penProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::penProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // penProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_penProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // penProperty(int)const
            QPen cppResult = const_cast<const ::QTextFormat *>(cppSelf)->penProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_penProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_properties(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.properties";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // properties()const
            QMap<int,QVariant > cppResult = const_cast<const ::QTextFormat *>(cppSelf)->properties();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QMAP_INT_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::property(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // property(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_property_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // property(int)const
            QVariant cppResult = const_cast<const ::QTextFormat *>(cppSelf)->property(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_propertyCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.propertyCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyCount()const
            int cppResult = const_cast<const ::QTextFormat *>(cppSelf)->propertyCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_setBackground(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setBackground";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::setBackground(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBackground(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setBackground_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBackground(QBrush)
            cppSelf->setBackground(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setBackground_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_setForeground(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setForeground";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::setForeground(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setForeground(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setForeground_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setForeground(QBrush)
            cppSelf->setForeground(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setForeground_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_setLayoutDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setLayoutDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::setLayoutDirection(Qt::LayoutDirection)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setLayoutDirection(Qt::LayoutDirection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setLayoutDirection_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLayoutDirection(Qt::LayoutDirection)
            cppSelf->setLayoutDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setLayoutDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_setObjectIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setObjectIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::setObjectIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setObjectIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setObjectIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setObjectIndex(int)
            cppSelf->setObjectIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setObjectIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_setObjectType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setObjectType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::setObjectType(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setObjectType(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setObjectType_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setObjectType(int)
            cppSelf->setObjectType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setObjectType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_setProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QTextFormat::setProperty(int,QVariant)
    // 1: QTextFormat::setProperty(int,QVector<QTextLength>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QTEXTLENGTH_IDX], (pyArgs[1])))) {
            overloadId = 1; // setProperty(int,QVector<QTextLength>)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            overloadId = 0; // setProperty(int,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_setProperty_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setProperty(int propertyId, const QVariant & value)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setProperty(int,QVariant)
                cppSelf->setProperty(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setProperty(int propertyId, const QVector<QTextLength > & lengths)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVector<QTextLength > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setProperty(int,QVector<QTextLength>)
                cppSelf->setProperty(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_stringProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.stringProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::stringProperty(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // stringProperty(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_stringProperty_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // stringProperty(int)const
            QString cppResult = const_cast<const ::QTextFormat *>(cppSelf)->stringProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc_stringProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QTextFormat::swap(QTextFormat&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QTextFormat&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextFormatFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextFormat cppArg0_local;
        ::QTextFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QTextFormat&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextFormatFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc_toBlockFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toBlockFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBlockFormat()const
            QTextBlockFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toBlockFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTBLOCKFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toCharFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toCharFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toCharFormat()const
            QTextCharFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toCharFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toFrameFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toFrameFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toFrameFormat()const
            QTextFrameFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toFrameFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFRAMEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toImageFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toImageFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toImageFormat()const
            QTextImageFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toImageFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTIMAGEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toListFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toListFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toListFormat()const
            QTextListFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toListFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTLISTFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toTableCellFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toTableCellFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTableCellFormat()const
            QTextTableCellFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toTableCellFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLECELLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_toTableFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.toTableFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTableFormat()const
            QTextTableFormat cppResult = const_cast<const ::QTextFormat *>(cppSelf)->toTableFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTTABLEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormatFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            int cppResult = const_cast<const ::QTextFormat *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextFormat_methods[] = {
    {"background", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_background), METH_NOARGS},
    {"boolProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_boolProperty), METH_O},
    {"brushProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_brushProperty), METH_O},
    {"clearBackground", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_clearBackground), METH_NOARGS},
    {"clearForeground", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_clearForeground), METH_NOARGS},
    {"clearProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_clearProperty), METH_O},
    {"colorProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_colorProperty), METH_O},
    {"doubleProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_doubleProperty), METH_O},
    {"foreground", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_foreground), METH_NOARGS},
    {"hasProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_hasProperty), METH_O},
    {"intProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_intProperty), METH_O},
    {"isBlockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isBlockFormat), METH_NOARGS},
    {"isCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isCharFormat), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isEmpty), METH_NOARGS},
    {"isFrameFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isFrameFormat), METH_NOARGS},
    {"isImageFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isImageFormat), METH_NOARGS},
    {"isListFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isListFormat), METH_NOARGS},
    {"isTableCellFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isTableCellFormat), METH_NOARGS},
    {"isTableFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isTableFormat), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_isValid), METH_NOARGS},
    {"layoutDirection", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_layoutDirection), METH_NOARGS},
    {"lengthProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_lengthProperty), METH_O},
    {"lengthVectorProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_lengthVectorProperty), METH_O},
    {"merge", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_merge), METH_O},
    {"objectIndex", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_objectIndex), METH_NOARGS},
    {"objectType", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_objectType), METH_NOARGS},
    {"penProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_penProperty), METH_O},
    {"properties", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_properties), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_property), METH_O},
    {"propertyCount", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_propertyCount), METH_NOARGS},
    {"setBackground", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setBackground), METH_O},
    {"setForeground", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setForeground), METH_O},
    {"setLayoutDirection", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setLayoutDirection), METH_O},
    {"setObjectIndex", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setObjectIndex), METH_O},
    {"setObjectType", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setObjectType), METH_O},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_setProperty), METH_VARARGS},
    {"stringProperty", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_stringProperty), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_swap), METH_O},
    {"toBlockFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toBlockFormat), METH_NOARGS},
    {"toCharFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toCharFormat), METH_NOARGS},
    {"toFrameFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toFrameFormat), METH_NOARGS},
    {"toImageFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toImageFormat), METH_NOARGS},
    {"toListFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toListFormat), METH_NOARGS},
    {"toTableCellFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toTableCellFormat), METH_NOARGS},
    {"toTableFormat", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_toTableFormat), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QTextFormatFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTextFormatFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QTextFormat::operator<<(QDataStream&,QTextFormat)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QTextFormat)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QTextFormatFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QTextFormat) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextFormatFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextFormat.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QTextFormat::operator>>(QDataStream&,QTextFormat&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QTextFormat&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QTextFormatFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QTextFormat&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextFormatFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QTextFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QTextFormat & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextFormat cppArg0_local;
                ::QTextFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArg)))) {
                // operator==(const QTextFormat & rhs) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextFormat cppArg0_local;
                ::QTextFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTextFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTextFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QTextFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QTextFormat__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextFormat_Type = nullptr;
static SbkObjectType *Sbk_QTextFormat_TypeF(void)
{
    return _Sbk_QTextFormat_Type;
}

static PyType_Slot Sbk_QTextFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QTextFormat__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTextFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QTextFormatFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QTextFormatFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextFormat_spec = {
    "2:PySide2.QtGui.QTextFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextFormat_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QTextFormat_PageBreakFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextFormat::PageBreakFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextFormat_PageBreakFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextFormat::PageBreakFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextFormat_PageBreakFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextFormat::PageBreakFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextFormat::PageBreakFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextFormat::PageBreakFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextFormat_PageBreakFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextFormat::PageBreakFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, self, &cppSelf);
    ::QTextFormat::PageBreakFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTextFormat_PageBreakFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTextFormat_PageBreakFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTextFormat_PageBreakFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextFormat_PageBreakFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextFormat_FormatType_PythonToCpp_QTextFormat_FormatType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFormat::FormatType *>(cppOut) =
        static_cast<::QTextFormat::FormatType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFormat_FormatType_PythonToCpp_QTextFormat_FormatType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX]))
        return QTextFormat_FormatType_PythonToCpp_QTextFormat_FormatType;
    return {};
}
static PyObject *QTextFormat_FormatType_CppToPython_QTextFormat_FormatType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFormat::FormatType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX], castCppIn);

}

static void QTextFormat_Property_PythonToCpp_QTextFormat_Property(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFormat::Property *>(cppOut) =
        static_cast<::QTextFormat::Property>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFormat_Property_PythonToCpp_QTextFormat_Property_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX]))
        return QTextFormat_Property_PythonToCpp_QTextFormat_Property;
    return {};
}
static PyObject *QTextFormat_Property_CppToPython_QTextFormat_Property(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFormat::Property *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX], castCppIn);

}

static void QTextFormat_ObjectTypes_PythonToCpp_QTextFormat_ObjectTypes(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFormat::ObjectTypes *>(cppOut) =
        static_cast<::QTextFormat::ObjectTypes>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFormat_ObjectTypes_PythonToCpp_QTextFormat_ObjectTypes_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX]))
        return QTextFormat_ObjectTypes_PythonToCpp_QTextFormat_ObjectTypes;
    return {};
}
static PyObject *QTextFormat_ObjectTypes_CppToPython_QTextFormat_ObjectTypes(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFormat::ObjectTypes *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX], castCppIn);

}

static void QTextFormat_PageBreakFlag_PythonToCpp_QTextFormat_PageBreakFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFormat::PageBreakFlag *>(cppOut) =
        static_cast<::QTextFormat::PageBreakFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextFormat_PageBreakFlag_PythonToCpp_QTextFormat_PageBreakFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX]))
        return QTextFormat_PageBreakFlag_PythonToCpp_QTextFormat_PageBreakFlag;
    return {};
}
static PyObject *QTextFormat_PageBreakFlag_CppToPython_QTextFormat_PageBreakFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextFormat::PageBreakFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX], castCppIn);

}

static void QFlags_QTextFormat_PageBreakFlag__PythonToCpp_QFlags_QTextFormat_PageBreakFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextFormat::PageBreakFlag> *>(cppOut) =
        ::QFlags<QTextFormat::PageBreakFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextFormat_PageBreakFlag__PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX]))
        return QFlags_QTextFormat_PageBreakFlag__PythonToCpp_QFlags_QTextFormat_PageBreakFlag_;
    return {};
}
static PyObject *QFlags_QTextFormat_PageBreakFlag__CppToPython_QFlags_QTextFormat_PageBreakFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextFormat::PageBreakFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX]));

}

static void QTextFormat_PageBreakFlag_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextFormat::PageBreakFlag> *>(cppOut) =
        ::QFlags<QTextFormat::PageBreakFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextFormat_PageBreakFlag_PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX]))
        return QTextFormat_PageBreakFlag_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextFormat::PageBreakFlag> *>(cppOut) =
        ::QFlags<QTextFormat::PageBreakFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextFormat_PythonToCpp_QTextFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextFormat_PythonToCpp_QTextFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextFormat_TypeF())))
        return QTextFormat_PythonToCpp_QTextFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextFormat_PTR_CppToPython_QTextFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTextFormat_COPY_CppToPython_QTextFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextFormat_TypeF(), new ::QTextFormat(*reinterpret_cast<const ::QTextFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTextFormat_PythonToCpp_QTextFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextFormat *>(cppOut) = *reinterpret_cast< ::QTextFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTextFormat_PythonToCpp_QTextFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextFormat_TypeF())))
        return QTextFormat_PythonToCpp_QTextFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextFormat(self)",
    "1:PySide2.QtGui.QTextFormat(self,rhs:PySide2.QtGui.QTextFormat)",
    "0:PySide2.QtGui.QTextFormat(self,type:int)",
    "PySide2.QtGui.QTextFormat.background(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextFormat.boolProperty(self,propertyId:int)->bool",
    "PySide2.QtGui.QTextFormat.brushProperty(self,propertyId:int)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextFormat.clearBackground(self)",
    "PySide2.QtGui.QTextFormat.clearForeground(self)",
    "PySide2.QtGui.QTextFormat.clearProperty(self,propertyId:int)",
    "PySide2.QtGui.QTextFormat.colorProperty(self,propertyId:int)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QTextFormat.doubleProperty(self,propertyId:int)->qreal",
    "PySide2.QtGui.QTextFormat.foreground(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QTextFormat.hasProperty(self,propertyId:int)->bool",
    "PySide2.QtGui.QTextFormat.intProperty(self,propertyId:int)->int",
    "PySide2.QtGui.QTextFormat.isBlockFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isCharFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isEmpty(self)->bool",
    "PySide2.QtGui.QTextFormat.isFrameFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isImageFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isListFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isTableCellFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isTableFormat(self)->bool",
    "PySide2.QtGui.QTextFormat.isValid(self)->bool",
    "PySide2.QtGui.QTextFormat.layoutDirection(self)->PySide2.QtCore.Qt.LayoutDirection",
    "PySide2.QtGui.QTextFormat.lengthProperty(self,propertyId:int)->PySide2.QtGui.QTextLength",
    "PySide2.QtGui.QTextFormat.lengthVectorProperty(self,propertyId:int)->QVector[PySide2.QtGui.QTextLength]",
    "PySide2.QtGui.QTextFormat.merge(self,other:PySide2.QtGui.QTextFormat)",
    "PySide2.QtGui.QTextFormat.objectIndex(self)->int",
    "PySide2.QtGui.QTextFormat.objectType(self)->int",
    "PySide2.QtGui.QTextFormat.penProperty(self,propertyId:int)->PySide2.QtGui.QPen",
    "PySide2.QtGui.QTextFormat.properties(self)->QMap[int, QVariant]",
    "PySide2.QtGui.QTextFormat.property(self,propertyId:int)->QVariant",
    "PySide2.QtGui.QTextFormat.propertyCount(self)->int",
    "PySide2.QtGui.QTextFormat.setBackground(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextFormat.setForeground(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QTextFormat.setLayoutDirection(self,direction:PySide2.QtCore.Qt.LayoutDirection)",
    "PySide2.QtGui.QTextFormat.setObjectIndex(self,object:int)",
    "PySide2.QtGui.QTextFormat.setObjectType(self,type:int)",
    "1:PySide2.QtGui.QTextFormat.setProperty(self,propertyId:int,value:QVariant)",
    "0:PySide2.QtGui.QTextFormat.setProperty(self,propertyId:int,lengths:QVector[PySide2.QtGui.QTextLength])",
    "PySide2.QtGui.QTextFormat.stringProperty(self,propertyId:int)->QString",
    "PySide2.QtGui.QTextFormat.swap(self,other:PySide2.QtGui.QTextFormat)",
    "PySide2.QtGui.QTextFormat.toBlockFormat(self)->PySide2.QtGui.QTextBlockFormat",
    "PySide2.QtGui.QTextFormat.toCharFormat(self)->PySide2.QtGui.QTextCharFormat",
    "PySide2.QtGui.QTextFormat.toFrameFormat(self)->PySide2.QtGui.QTextFrameFormat",
    "PySide2.QtGui.QTextFormat.toImageFormat(self)->PySide2.QtGui.QTextImageFormat",
    "PySide2.QtGui.QTextFormat.toListFormat(self)->PySide2.QtGui.QTextListFormat",
    "PySide2.QtGui.QTextFormat.toTableCellFormat(self)->PySide2.QtGui.QTextTableCellFormat",
    "PySide2.QtGui.QTextFormat.toTableFormat(self)->PySide2.QtGui.QTextTableFormat",
    "PySide2.QtGui.QTextFormat.type(self)->int",
    "PySide2.QtGui.QTextFormat.__copy__()",
    "PySide2.QtGui.QTextFormat.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QTextFormat.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QTextFormat(PyObject *module)
{
    _Sbk_QTextFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextFormat",
        "QTextFormat",
        &Sbk_QTextFormat_spec,
        &Shiboken::callCppDestructor< ::QTextFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextFormat_Type);
    InitSignatureStrings(pyType, QTextFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextFormat_Type), Sbk_QTextFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextFormat_TypeF(),
        QTextFormat_PythonToCpp_QTextFormat_PTR,
        is_QTextFormat_PythonToCpp_QTextFormat_PTR_Convertible,
        QTextFormat_PTR_CppToPython_QTextFormat,
        QTextFormat_COPY_CppToPython_QTextFormat);

    Shiboken::Conversions::registerConverterName(converter, "QTextFormat");
    Shiboken::Conversions::registerConverterName(converter, "QTextFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QTextFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTextFormat_PythonToCpp_QTextFormat_COPY,
        is_QTextFormat_PythonToCpp_QTextFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FormatType'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFormat_TypeF(),
        "FormatType",
        "2:PySide2.QtGui.QTextFormat.FormatType",
        "QTextFormat::FormatType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "InvalidFormat", (long) QTextFormat::FormatType::InvalidFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "BlockFormat", (long) QTextFormat::FormatType::BlockFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "CharFormat", (long) QTextFormat::FormatType::CharFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "ListFormat", (long) QTextFormat::FormatType::ListFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "TableFormat", (long) QTextFormat::FormatType::TableFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "FrameFormat", (long) QTextFormat::FormatType::FrameFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
        Sbk_QTextFormat_TypeF(), "UserFormat", (long) QTextFormat::FormatType::UserFormat))
        return;
    // Register converter for enum 'QTextFormat::FormatType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX],
            QTextFormat_FormatType_CppToPython_QTextFormat_FormatType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFormat_FormatType_PythonToCpp_QTextFormat_FormatType,
            is_QTextFormat_FormatType_PythonToCpp_QTextFormat_FormatType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_FORMATTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFormat::FormatType");
        Shiboken::Conversions::registerConverterName(converter, "FormatType");
    }
    // End of 'FormatType' enum.

    // Initialization of enum 'Property'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFormat_TypeF(),
        "Property",
        "2:PySide2.QtGui.QTextFormat.Property",
        "QTextFormat::Property");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ObjectIndex", (long) QTextFormat::Property::ObjectIndex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "CssFloat", (long) QTextFormat::Property::CssFloat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "LayoutDirection", (long) QTextFormat::Property::LayoutDirection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "OutlinePen", (long) QTextFormat::Property::OutlinePen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BackgroundBrush", (long) QTextFormat::Property::BackgroundBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ForegroundBrush", (long) QTextFormat::Property::ForegroundBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BackgroundImageUrl", (long) QTextFormat::Property::BackgroundImageUrl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockAlignment", (long) QTextFormat::Property::BlockAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockTopMargin", (long) QTextFormat::Property::BlockTopMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockBottomMargin", (long) QTextFormat::Property::BlockBottomMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockLeftMargin", (long) QTextFormat::Property::BlockLeftMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockRightMargin", (long) QTextFormat::Property::BlockRightMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextIndent", (long) QTextFormat::Property::TextIndent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TabPositions", (long) QTextFormat::Property::TabPositions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockIndent", (long) QTextFormat::Property::BlockIndent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "LineHeight", (long) QTextFormat::Property::LineHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "LineHeightType", (long) QTextFormat::Property::LineHeightType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockNonBreakableLines", (long) QTextFormat::Property::BlockNonBreakableLines))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockTrailingHorizontalRulerWidth", (long) QTextFormat::Property::BlockTrailingHorizontalRulerWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "HeadingLevel", (long) QTextFormat::Property::HeadingLevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockQuoteLevel", (long) QTextFormat::Property::BlockQuoteLevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockCodeLanguage", (long) QTextFormat::Property::BlockCodeLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockCodeFence", (long) QTextFormat::Property::BlockCodeFence))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "BlockMarker", (long) QTextFormat::Property::BlockMarker))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FirstFontProperty", (long) QTextFormat::Property::FirstFontProperty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontCapitalization", (long) QTextFormat::Property::FontCapitalization))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontLetterSpacingType", (long) QTextFormat::Property::FontLetterSpacingType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontLetterSpacing", (long) QTextFormat::Property::FontLetterSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontWordSpacing", (long) QTextFormat::Property::FontWordSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontStretch", (long) QTextFormat::Property::FontStretch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontStyleHint", (long) QTextFormat::Property::FontStyleHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontStyleStrategy", (long) QTextFormat::Property::FontStyleStrategy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontKerning", (long) QTextFormat::Property::FontKerning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontHintingPreference", (long) QTextFormat::Property::FontHintingPreference))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontFamilies", (long) QTextFormat::Property::FontFamilies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontStyleName", (long) QTextFormat::Property::FontStyleName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontFamily", (long) QTextFormat::Property::FontFamily))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontPointSize", (long) QTextFormat::Property::FontPointSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontSizeAdjustment", (long) QTextFormat::Property::FontSizeAdjustment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontSizeIncrement", (long) QTextFormat::Property::FontSizeIncrement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontWeight", (long) QTextFormat::Property::FontWeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontItalic", (long) QTextFormat::Property::FontItalic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontUnderline", (long) QTextFormat::Property::FontUnderline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontOverline", (long) QTextFormat::Property::FontOverline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontStrikeOut", (long) QTextFormat::Property::FontStrikeOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontFixedPitch", (long) QTextFormat::Property::FontFixedPitch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FontPixelSize", (long) QTextFormat::Property::FontPixelSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "LastFontProperty", (long) QTextFormat::Property::LastFontProperty))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextUnderlineColor", (long) QTextFormat::Property::TextUnderlineColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextVerticalAlignment", (long) QTextFormat::Property::TextVerticalAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextOutline", (long) QTextFormat::Property::TextOutline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextUnderlineStyle", (long) QTextFormat::Property::TextUnderlineStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TextToolTip", (long) QTextFormat::Property::TextToolTip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "IsAnchor", (long) QTextFormat::Property::IsAnchor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "AnchorHref", (long) QTextFormat::Property::AnchorHref))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "AnchorName", (long) QTextFormat::Property::AnchorName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ObjectType", (long) QTextFormat::Property::ObjectType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ListStyle", (long) QTextFormat::Property::ListStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ListIndent", (long) QTextFormat::Property::ListIndent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ListNumberPrefix", (long) QTextFormat::Property::ListNumberPrefix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ListNumberSuffix", (long) QTextFormat::Property::ListNumberSuffix))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameBorder", (long) QTextFormat::Property::FrameBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameMargin", (long) QTextFormat::Property::FrameMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FramePadding", (long) QTextFormat::Property::FramePadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameWidth", (long) QTextFormat::Property::FrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameHeight", (long) QTextFormat::Property::FrameHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameTopMargin", (long) QTextFormat::Property::FrameTopMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameBottomMargin", (long) QTextFormat::Property::FrameBottomMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameLeftMargin", (long) QTextFormat::Property::FrameLeftMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameRightMargin", (long) QTextFormat::Property::FrameRightMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameBorderBrush", (long) QTextFormat::Property::FrameBorderBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FrameBorderStyle", (long) QTextFormat::Property::FrameBorderStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableColumns", (long) QTextFormat::Property::TableColumns))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableColumnWidthConstraints", (long) QTextFormat::Property::TableColumnWidthConstraints))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellSpacing", (long) QTextFormat::Property::TableCellSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellPadding", (long) QTextFormat::Property::TableCellPadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableHeaderRowCount", (long) QTextFormat::Property::TableHeaderRowCount))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableBorderCollapse", (long) QTextFormat::Property::TableBorderCollapse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellRowSpan", (long) QTextFormat::Property::TableCellRowSpan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellColumnSpan", (long) QTextFormat::Property::TableCellColumnSpan))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellTopPadding", (long) QTextFormat::Property::TableCellTopPadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellBottomPadding", (long) QTextFormat::Property::TableCellBottomPadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellLeftPadding", (long) QTextFormat::Property::TableCellLeftPadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellRightPadding", (long) QTextFormat::Property::TableCellRightPadding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellTopBorder", (long) QTextFormat::Property::TableCellTopBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellBottomBorder", (long) QTextFormat::Property::TableCellBottomBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellLeftBorder", (long) QTextFormat::Property::TableCellLeftBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellRightBorder", (long) QTextFormat::Property::TableCellRightBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellTopBorderStyle", (long) QTextFormat::Property::TableCellTopBorderStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellBottomBorderStyle", (long) QTextFormat::Property::TableCellBottomBorderStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellLeftBorderStyle", (long) QTextFormat::Property::TableCellLeftBorderStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellRightBorderStyle", (long) QTextFormat::Property::TableCellRightBorderStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellTopBorderBrush", (long) QTextFormat::Property::TableCellTopBorderBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellBottomBorderBrush", (long) QTextFormat::Property::TableCellBottomBorderBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellLeftBorderBrush", (long) QTextFormat::Property::TableCellLeftBorderBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellRightBorderBrush", (long) QTextFormat::Property::TableCellRightBorderBrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageName", (long) QTextFormat::Property::ImageName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageTitle", (long) QTextFormat::Property::ImageTitle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageAltText", (long) QTextFormat::Property::ImageAltText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageWidth", (long) QTextFormat::Property::ImageWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageHeight", (long) QTextFormat::Property::ImageHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "ImageQuality", (long) QTextFormat::Property::ImageQuality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "FullWidthSelection", (long) QTextFormat::Property::FullWidthSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "PageBreakPolicy", (long) QTextFormat::Property::PageBreakPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
        Sbk_QTextFormat_TypeF(), "UserProperty", (long) QTextFormat::Property::UserProperty))
        return;
    // Register converter for enum 'QTextFormat::Property'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX],
            QTextFormat_Property_CppToPython_QTextFormat_Property);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFormat_Property_PythonToCpp_QTextFormat_Property,
            is_QTextFormat_Property_PythonToCpp_QTextFormat_Property_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PROPERTY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFormat::Property");
        Shiboken::Conversions::registerConverterName(converter, "Property");
    }
    // End of 'Property' enum.

    // Initialization of enum 'ObjectTypes'.
    SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFormat_TypeF(),
        "ObjectTypes",
        "2:PySide2.QtGui.QTextFormat.ObjectTypes",
        "QTextFormat::ObjectTypes");
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
        Sbk_QTextFormat_TypeF(), "NoObject", (long) QTextFormat::ObjectTypes::NoObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
        Sbk_QTextFormat_TypeF(), "ImageObject", (long) QTextFormat::ObjectTypes::ImageObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
        Sbk_QTextFormat_TypeF(), "TableObject", (long) QTextFormat::ObjectTypes::TableObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
        Sbk_QTextFormat_TypeF(), "TableCellObject", (long) QTextFormat::ObjectTypes::TableCellObject))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
        Sbk_QTextFormat_TypeF(), "UserObject", (long) QTextFormat::ObjectTypes::UserObject))
        return;
    // Register converter for enum 'QTextFormat::ObjectTypes'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX],
            QTextFormat_ObjectTypes_CppToPython_QTextFormat_ObjectTypes);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFormat_ObjectTypes_PythonToCpp_QTextFormat_ObjectTypes,
            is_QTextFormat_ObjectTypes_PythonToCpp_QTextFormat_ObjectTypes_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_OBJECTTYPES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFormat::ObjectTypes");
        Shiboken::Conversions::registerConverterName(converter, "ObjectTypes");
    }
    // End of 'ObjectTypes' enum.

    // Initialization of enum 'PageBreakFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTextFormat.PageBreakFlags", SbkPySide2_QtGui_QTextFormat_PageBreakFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextFormat_TypeF(),
        "PageBreakFlag",
        "2:PySide2.QtGui.QTextFormat.PageBreakFlag",
        "QTextFormat::PageBreakFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX],
        Sbk_QTextFormat_TypeF(), "PageBreak_Auto", (long) QTextFormat::PageBreakFlag::PageBreak_Auto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX],
        Sbk_QTextFormat_TypeF(), "PageBreak_AlwaysBefore", (long) QTextFormat::PageBreakFlag::PageBreak_AlwaysBefore))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX],
        Sbk_QTextFormat_TypeF(), "PageBreak_AlwaysAfter", (long) QTextFormat::PageBreakFlag::PageBreak_AlwaysAfter))
        return;
    // Register converter for enum 'QTextFormat::PageBreakFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX],
            QTextFormat_PageBreakFlag_CppToPython_QTextFormat_PageBreakFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFormat_PageBreakFlag_PythonToCpp_QTextFormat_PageBreakFlag,
            is_QTextFormat_PageBreakFlag_PythonToCpp_QTextFormat_PageBreakFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_PAGEBREAKFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFormat::PageBreakFlag");
        Shiboken::Conversions::registerConverterName(converter, "PageBreakFlag");
    }
    // Register converter for flag 'QFlags<QTextFormat::PageBreakFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX],
            QFlags_QTextFormat_PageBreakFlag__CppToPython_QFlags_QTextFormat_PageBreakFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextFormat_PageBreakFlag_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_,
            is_QTextFormat_PageBreakFlag_PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextFormat_PageBreakFlag__PythonToCpp_QFlags_QTextFormat_PageBreakFlag_,
            is_QFlags_QTextFormat_PageBreakFlag__PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextFormat_PageBreakFlag_,
            is_number_PythonToCpp_QFlags_QTextFormat_PageBreakFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTFORMAT_PAGEBREAKFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextFormat::PageBreakFlags");
        Shiboken::Conversions::registerConverterName(converter, "PageBreakFlags");
    }
    // End of 'PageBreakFlag' enum/flags.

    qRegisterMetaType< ::QTextFormat >("QTextFormat");
    qRegisterMetaType< ::QTextFormat::FormatType >("QTextFormat::FormatType");
    qRegisterMetaType< ::QTextFormat::Property >("QTextFormat::Property");
    qRegisterMetaType< ::QTextFormat::ObjectTypes >("QTextFormat::ObjectTypes");
    qRegisterMetaType< ::QTextFormat::PageBreakFlag >("QTextFormat::PageBreakFlag");
    qRegisterMetaType< ::QTextFormat::PageBreakFlags >("QTextFormat::PageBreakFlags");
}
