/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextoption_tab_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qtextoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextOption_Tab_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextOption::Tab >()))
        return -1;

    ::QTextOption::Tab *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextOption.Tab.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTextOption_Tab_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:Tab", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: Tab::Tab()
    // 1: Tab::Tab(QTextOption::Tab)
    // 2: Tab::Tab(qreal,QTextOption::TabType,QChar)
    if (numArgs == 0) {
        overloadId = 0; // Tab()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // Tab(qreal,QTextOption::TabType,QChar)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[2])))) {
            overloadId = 2; // Tab(qreal,QTextOption::TabType,QChar)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Tab(QTextOption::Tab)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextOption_Tab_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Tab()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextOption_Tab_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // Tab()
                cptr = new ::QTextOption::Tab();
            }
            break;
        }
        case 1: // Tab(const QTextOption::Tab & Tab)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTextOption_Tab_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextOption::Tab cppArg0_local;
            ::QTextOption::Tab *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Tab(QTextOption::Tab)
                cptr = new ::QTextOption::Tab(*cppArg0);
            }
            break;
        }
        case 2: // Tab(qreal pos, QTextOption::TabType tabType, QChar delim)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_delim = Shiboken::String::createStaticString("delim");
                if (PyDict_Contains(kwds, key_delim)) {
                    value = PyDict_GetItem(kwds, key_delim);
                    if (value && pyArgs[2]) {
                        errInfo = key_delim;
                        Py_INCREF(errInfo);
                        goto Sbk_QTextOption_Tab_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArgs[2]))))
                            goto Sbk_QTextOption_Tab_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_delim);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTextOption_Tab_Init_TypeError;
                }
            }
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QTextOption::TabType cppArg1{QTextOption::LeftTab};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QChar();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // Tab(qreal,QTextOption::TabType,QChar)
                cptr = new ::QTextOption::Tab(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextOption::Tab >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextOption_Tab_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextOption_Tab_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextOption_Tab___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextOption_Tab_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextOption_Tab_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextOption_Tab___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QTextOption_Tab_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), (pyArg)))) {
                // operator!=(const QTextOption::Tab & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextOption::Tab cppArg0_local;
                ::QTextOption::Tab *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), (pyArg)))) {
                // operator==(const QTextOption::Tab & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QTextOption::Tab cppArg0_local;
                ::QTextOption::Tab *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QTextOption_Tab_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QTextOption_Tab_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

static PyObject *Sbk_QTextOption_Tab_get_position(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->position);
    return pyOut;
}
static int Sbk_QTextOption_Tab_set_position(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->position;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QTextOption_Tab_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QTextOption::TabType cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QTextOption_Tab_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TABTYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'TabType' or convertible type expected");
        return -1;
    }

    ::QTextOption::TabType cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTextOption_Tab_get_delimiter(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], &cppSelf->delimiter);
    return pyOut;
}
static int Sbk_QTextOption_Tab_set_delimiter(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'delimiter' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'delimiter', 'QChar' or convertible type expected");
        return -1;
    }

    ::QChar& cppOut_ptr = cppSelf->delimiter;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for Tab
static PyGetSetDef Sbk_QTextOption_Tab_getsetlist[] = {
    {const_cast<char *>("position"), Sbk_QTextOption_Tab_get_position, Sbk_QTextOption_Tab_set_position},
    {const_cast<char *>("type"), Sbk_QTextOption_Tab_get_type, Sbk_QTextOption_Tab_set_type},
    {const_cast<char *>("delimiter"), Sbk_QTextOption_Tab_get_delimiter, Sbk_QTextOption_Tab_set_delimiter},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextOption_Tab_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextOption_Tab_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextOption_Tab_Type = nullptr;
static SbkObjectType *Sbk_QTextOption_Tab_TypeF(void)
{
    return _Sbk_QTextOption_Tab_Type;
}

static PyType_Slot Sbk_QTextOption_Tab_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextOption_Tab_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextOption_Tab_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QTextOption_Tab_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextOption_Tab_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTextOption_Tab_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextOption_Tab_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextOption_Tab_spec = {
    "2:PySide2.QtGui.QTextOption.Tab",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextOption_Tab_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Tab_PythonToCpp_Tab_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextOption_Tab_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Tab_PythonToCpp_Tab_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_Tab_TypeF())))
        return Tab_PythonToCpp_Tab_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Tab_PTR_CppToPython_Tab(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextOption::Tab *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextOption_Tab_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Tab_COPY_CppToPython_Tab(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextOption_Tab_TypeF(), new ::QTextOption::Tab(*reinterpret_cast<const ::QTextOption::Tab *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Tab_PythonToCpp_Tab_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextOption::Tab *>(cppOut) = *reinterpret_cast< ::QTextOption::Tab *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Tab_PythonToCpp_Tab_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_Tab_TypeF())))
        return Tab_PythonToCpp_Tab_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextOption_Tab_SignatureStrings[] = {
    "2:PySide2.QtGui.QTextOption.Tab(self)",
    "1:PySide2.QtGui.QTextOption.Tab(self,Tab:PySide2.QtGui.QTextOption.Tab)",
    "0:PySide2.QtGui.QTextOption.Tab(self,pos:qreal,tabType:PySide2.QtGui.QTextOption.TabType,delim:QChar=QChar())",
    "PySide2.QtGui.QTextOption.Tab.__copy__()",
    nullptr}; // Sentinel

void init_QTextOption_Tab(PyObject *enclosingClass)
{
    _Sbk_QTextOption_Tab_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Tab",
        "QTextOption::Tab",
        &Sbk_QTextOption_Tab_spec,
        &Shiboken::callCppDestructor< ::QTextOption::Tab >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextOption_Tab_Type);
    InitSignatureStrings(pyType, QTextOption_Tab_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextOption_Tab_Type), Sbk_QTextOption_Tab_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_TAB_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextOption_Tab_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextOption_Tab_TypeF(),
        Tab_PythonToCpp_Tab_PTR,
        is_Tab_PythonToCpp_Tab_PTR_Convertible,
        Tab_PTR_CppToPython_Tab,
        Tab_COPY_CppToPython_Tab);

    Shiboken::Conversions::registerConverterName(converter, "QTextOption::Tab");
    Shiboken::Conversions::registerConverterName(converter, "QTextOption::Tab*");
    Shiboken::Conversions::registerConverterName(converter, "QTextOption::Tab&");
    Shiboken::Conversions::registerConverterName(converter, "Tab");
    Shiboken::Conversions::registerConverterName(converter, "Tab*");
    Shiboken::Conversions::registerConverterName(converter, "Tab&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextOption::Tab).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Tab_PythonToCpp_Tab_COPY,
        is_Tab_PythonToCpp_Tab_COPY_Convertible);

    qRegisterMetaType< ::QTextOption::Tab >("Tab");
    qRegisterMetaType< ::QTextOption::Tab >("QTextOption::Tab");
}
