/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qvector2d_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qvector2d.h>
#include <QtGui/qvector3d.h>
#include <QtGui/qvector4d.h>
#include <qdatastream.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVector2D_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVector2D >()))
        return -1;

    ::QVector2D *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QVector2D", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QVector2D::QVector2D()
    // 1: QVector2D::QVector2D(QPoint)
    // 2: QVector2D::QVector2D(QPointF)
    // 3: QVector2D::QVector2D(QVector3D)
    // 4: QVector2D::QVector2D(QVector4D)
    // 5: QVector2D::QVector2D(float,float)
    if (numArgs == 0) {
        overloadId = 0; // QVector2D()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 5; // QVector2D(float,float)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QVector2D(QVector3D)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QVector2D(QVector4D)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QVector2D(QPoint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QVector2D(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2D_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVector2D()
        {

            if (!PyErr_Occurred()) {
                // QVector2D()
                cptr = new ::QVector2D();
            }
            break;
        }
        case 1: // QVector2D(const QPoint & point)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPoint cppArg0_local;
            ::QPoint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVector2D(QPoint)
                cptr = new ::QVector2D(*cppArg0);
            }
            break;
        }
        case 2: // QVector2D(const QPointF & point)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVector2D(QPointF)
                cptr = new ::QVector2D(*cppArg0);
            }
            break;
        }
        case 3: // QVector2D(const QVector3D & vector)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector3D cppArg0_local;
            ::QVector3D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVector2D(QVector3D)
                cptr = new ::QVector2D(*cppArg0);
            }
            break;
        }
        case 4: // QVector2D(const QVector4D & vector)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVector4D cppArg0_local;
            ::QVector4D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVector2D(QVector4D)
                cptr = new ::QVector2D(*cppArg0);
            }
            break;
        }
        case 5: // QVector2D(float xpos, float ypos)
        {
            float cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            float cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QVector2D(float,float)
                cptr = new ::QVector2D(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVector2D >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVector2D_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVector2D_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVector2DFunc___reduce__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__reduce__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __reduce__()
            // Begin code injection
            // TEMPLATE - reduce_code - START
            pyResult = Py_BuildValue("(N(dd))", PyObject_Type(self), cppSelf->x(), cppSelf->y());
            // TEMPLATE - reduce_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc___repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__repr__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // __repr__()
            // Begin code injection
            // TEMPLATE - repr_code - START
            QString format = QString::asprintf("%s(%f, %f)",
                Py_TYPE(self)->tp_name, cppSelf->x(), cppSelf->y());
            pyResult = Shiboken::String::fromCString(qPrintable(format));
            // TEMPLATE - repr_code - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_distanceToLine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.distanceToLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "distanceToLine", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVector2D::distanceToLine(QVector2D,QVector2D)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
        overloadId = 0; // distanceToLine(QVector2D,QVector2D)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc_distanceToLine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVector2D cppArg1_local;
        ::QVector2D *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // distanceToLine(QVector2D,QVector2D)const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->distanceToLine(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc_distanceToLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc_distanceToPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.distanceToPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::distanceToPoint(QVector2D)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // distanceToPoint(QVector2D)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc_distanceToPoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // distanceToPoint(QVector2D)const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->distanceToPoint(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc_distanceToPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc_dotProduct(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.dotProduct";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "dotProduct", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QVector2D::dotProduct(QVector2D,QVector2D)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArgs[1])))) {
        overloadId = 0; // dotProduct(QVector2D,QVector2D)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc_dotProduct_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVector2D cppArg1_local;
        ::QVector2D *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // dotProduct(QVector2D,QVector2D)
            float cppResult = ::QVector2D::dotProduct(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc_dotProduct_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QVector2D *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_lengthSquared(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.lengthSquared";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lengthSquared()const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->lengthSquared();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_normalize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.normalize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalize()
            cppSelf->normalize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QVector2DFunc_normalized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.normalized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // normalized()const
            QVector2D cppResult = const_cast<const ::QVector2D *>(cppSelf)->normalized();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_setX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.setX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::setX(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setX(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc_setX_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setX(float)
            cppSelf->setX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVector2DFunc_setX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc_setY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.setY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::setY(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setY(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc_setY_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setY(float)
            cppSelf->setY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVector2DFunc_setY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc_toPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.toPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPoint()const
            QPoint cppResult = const_cast<const ::QVector2D *>(cppSelf)->toPoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_toPointF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.toPointF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPointF()const
            QPointF cppResult = const_cast<const ::QVector2D *>(cppSelf)->toPointF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_toTuple(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.toTuple";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toTuple()
            // Begin code injection
            // TEMPLATE - to_tuple - START
            pyResult = Py_BuildValue("dd", cppSelf->x(), cppSelf->y());
            // TEMPLATE - to_tuple - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_toVector3D(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.toVector3D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVector3D()const
            QVector3D cppResult = const_cast<const ::QVector2D *>(cppSelf)->toVector3D();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR3D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_toVector4D(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.toVector4D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVector4D()const
            QVector4D cppResult = const_cast<const ::QVector2D *>(cppSelf)->toVector4D();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR4D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            float cppResult = const_cast<const ::QVector2D *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2D___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVector2D_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVector2D_methods[] = {
    {"__reduce__", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc___reduce__), METH_NOARGS},
    {"distanceToLine", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_distanceToLine), METH_VARARGS},
    {"distanceToPoint", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_distanceToPoint), METH_O},
    {"dotProduct", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_dotProduct), METH_VARARGS|METH_STATIC},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_isNull), METH_NOARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_length), METH_NOARGS},
    {"lengthSquared", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_lengthSquared), METH_NOARGS},
    {"normalize", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_normalize), METH_NOARGS},
    {"normalized", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_normalized), METH_NOARGS},
    {"setX", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_setX), METH_O},
    {"setY", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_setY), METH_O},
    {"toPoint", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_toPoint), METH_NOARGS},
    {"toPointF", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_toPointF), METH_NOARGS},
    {"toTuple", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_toTuple), METH_NOARGS},
    {"toVector3D", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_toVector3D), METH_NOARGS},
    {"toVector4D", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_toVector4D), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QVector2DFunc_y), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVector2D___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QVector2D___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QVector2DFunc___mul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__mul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator*(QVector2D,QVector2D)
    // 1: QVector2D::operator*(float,QVector2D)
    // 2: QVector2D::operator*(QVector2D,float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 2; // operator*(QVector2D,float)
    } else if (isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator*(float,QVector2D)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator*(QVector2D,QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___mul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*(const QVector2D & v2)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector2D cppArg0_local;
            ::QVector2D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*(QVector2D,QVector2D)
                const QVector2D cppResult = (*cppSelf) * (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(float,QVector2D) [reverse operator]
                const QVector2D cppResult = cppArg0 * (*cppSelf);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
            }
            break;
        }
        case 2: // operator*(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*(QVector2D,float)
                const QVector2D cppResult = (*cppSelf) * cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___mul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___imul__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__imul__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator*=(QVector2D)
    // 1: QVector2D::operator*=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator*=(float)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator*=(QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___imul___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator*=(const QVector2D & vector)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector2D cppArg0_local;
            ::QVector2D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator*=(QVector2D)
                (*cppSelf) *= (*cppArg0);
            }
            break;
        }
        case 1: // operator*=(float factor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator*=(float)
                (*cppSelf) *= cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QVector2DFunc___imul___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator+(QVector2D,QVector2D)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator+(QVector2D,QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___add___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+(QVector2D,QVector2D)
            const QVector2D cppResult = (*cppSelf) + (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator+=(QVector2D)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___iadd___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+=(QVector2D)
            (*cppSelf) += (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QVector2DFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___neg__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__neg__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // operator-(QVector2D)
            const QVector2D cppResult = - (*cppSelf);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVector2DFunc___sub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__sub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator-(QVector2D,QVector2D)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator-(QVector2D,QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___sub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-(QVector2D,QVector2D)
            const QVector2D cppResult = (*cppSelf) - (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___sub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator-=(QVector2D)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___isub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVector2D cppArg0_local;
        ::QVector2D *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-=(QVector2D)
            (*cppSelf) -= (*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QVector2DFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___div__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__div__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator/(QVector2D,QVector2D)
    // 1: QVector2D::operator/(QVector2D,float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator/(QVector2D,float)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator/(QVector2D,QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___div___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator/(const QVector2D & divisor)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector2D cppArg0_local;
            ::QVector2D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator/(QVector2D,QVector2D)
                const QVector2D cppResult = (*cppSelf) / (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
            }
            break;
        }
        case 1: // operator/(float divisor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator/(QVector2D,float)
                const QVector2D cppResult = (*cppSelf) / cppArg0;
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___div___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___idiv__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__idiv__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVector2D::operator/=(QVector2D)
    // 1: QVector2D::operator/=(float)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 1; // operator/=(float)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
        overloadId = 0; // operator/=(QVector2D)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVector2DFunc___idiv___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator/=(const QVector2D & vector)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QVector2D cppArg0_local;
            ::QVector2D *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator/=(QVector2D)
                (*cppSelf) /= (*cppArg0);
            }
            break;
        }
        case 1: // operator/=(float divisor)
        {
            float cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator/=(float)
                (*cppSelf) /= cppArg0;
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QVector2DFunc___idiv___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QVector2D::operator<<(QDataStream&,QVector2D)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QVector2D)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QVector2DFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QVector2D) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVector2DFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QVector2D.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QVector2D::operator>>(QDataStream&,QVector2D&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QVector2D&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QVector2DFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QVector2D&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVector2DFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QVector2D_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
                // operator!=(const QVector2D & v2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVector2D cppArg0_local;
                ::QVector2D *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), (pyArg)))) {
                // operator==(const QVector2D & v2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVector2D cppArg0_local;
                ::QVector2D *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVector2D_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVector2D_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVector2D_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVector2D_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVector2D_Type = nullptr;
static SbkObjectType *Sbk_QVector2D_TypeF(void)
{
    return _Sbk_QVector2D_Type;
}

static PyType_Slot Sbk_QVector2D_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QVector2DFunc___repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVector2D_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVector2D_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVector2D_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVector2D_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVector2D_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_multiply, (void *)Sbk_QVector2DFunc___imul__},
    {Py_nb_inplace_add, (void *)Sbk_QVector2DFunc___iadd__},
    {Py_nb_multiply, (void *)Sbk_QVector2DFunc___mul__},
    {Py_nb_rshift, (void *)Sbk_QVector2DFunc___rshift__},
    {Py_nb_add, (void *)Sbk_QVector2DFunc___add__},
    {Py_nb_inplace_subtract, (void *)Sbk_QVector2DFunc___isub__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QVector2D___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QVector2D___nb_bool},
#endif
    {Py_nb_subtract, (void *)Sbk_QVector2DFunc___sub__},
    {Py_nb_lshift, (void *)Sbk_QVector2DFunc___lshift__},
    {Py_nb_negative, (void *)Sbk_QVector2DFunc___neg__},
    {Py_nb_true_divide, (void *)Sbk_QVector2DFunc___div__},
#ifndef IS_PY3K
    {Py_nb_divide, (void *)Sbk_QVector2DFunc___div__},
#endif
    // This function is unused in Python 3. We reference it here.
    {0, (void *)Sbk_QVector2DFunc___idiv__},
    // This list is ending at the first 0 entry.
    // Therefore, we need to put the unused functions at the very end.
    {0, nullptr}
};
static PyType_Spec Sbk_QVector2D_spec = {
    "2:PySide2.QtGui.QVector2D",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVector2D_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVector2D_PythonToCpp_QVector2D_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVector2D_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVector2D_PythonToCpp_QVector2D_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVector2D_TypeF())))
        return QVector2D_PythonToCpp_QVector2D_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVector2D_PTR_CppToPython_QVector2D(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVector2D *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVector2D_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVector2D_COPY_CppToPython_QVector2D(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVector2D_TypeF(), new ::QVector2D(*reinterpret_cast<const ::QVector2D *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVector2D_PythonToCpp_QVector2D_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVector2D *>(cppOut) = *reinterpret_cast< ::QVector2D *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVector2D_PythonToCpp_QVector2D_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVector2D_TypeF())))
        return QVector2D_PythonToCpp_QVector2D_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVector2D_SignatureStrings[] = {
    "5:PySide2.QtGui.QVector2D(self)",
    "4:PySide2.QtGui.QVector2D(self,point:PySide2.QtCore.QPoint)",
    "3:PySide2.QtGui.QVector2D(self,point:PySide2.QtCore.QPointF)",
    "2:PySide2.QtGui.QVector2D(self,vector:PySide2.QtGui.QVector3D)",
    "1:PySide2.QtGui.QVector2D(self,vector:PySide2.QtGui.QVector4D)",
    "0:PySide2.QtGui.QVector2D(self,xpos:float,ypos:float)",
    "PySide2.QtGui.QVector2D.__reduce__(self)->PyObject",
    "PySide2.QtGui.QVector2D.__repr__(self)->PyObject",
    "PySide2.QtGui.QVector2D.distanceToLine(self,point:PySide2.QtGui.QVector2D,direction:PySide2.QtGui.QVector2D)->float",
    "PySide2.QtGui.QVector2D.distanceToPoint(self,point:PySide2.QtGui.QVector2D)->float",
    "PySide2.QtGui.QVector2D.dotProduct(v1:PySide2.QtGui.QVector2D,v2:PySide2.QtGui.QVector2D)->float",
    "PySide2.QtGui.QVector2D.isNull(self)->bool",
    "PySide2.QtGui.QVector2D.length(self)->float",
    "PySide2.QtGui.QVector2D.lengthSquared(self)->float",
    "PySide2.QtGui.QVector2D.normalize(self)",
    "PySide2.QtGui.QVector2D.normalized(self)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.setX(self,x:float)",
    "PySide2.QtGui.QVector2D.setY(self,y:float)",
    "PySide2.QtGui.QVector2D.toPoint(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QVector2D.toPointF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QVector2D.toTuple(self)->PyObject",
    "PySide2.QtGui.QVector2D.toVector3D(self)->PySide2.QtGui.QVector3D",
    "PySide2.QtGui.QVector2D.toVector4D(self)->PySide2.QtGui.QVector4D",
    "PySide2.QtGui.QVector2D.x(self)->float",
    "PySide2.QtGui.QVector2D.y(self)->float",
    "PySide2.QtGui.QVector2D.__copy__()",
    "2:PySide2.QtGui.QVector2D.__mul__(self,v2:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "1:PySide2.QtGui.QVector2D.__mul__(self,factor:float)->PySide2.QtGui.QVector2D",
    "0:PySide2.QtGui.QVector2D.__mul__(self,factor:float)->PySide2.QtGui.QVector2D",
    "1:PySide2.QtGui.QVector2D.__imul__(self,vector:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "0:PySide2.QtGui.QVector2D.__imul__(self,factor:float)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__add__(self,v2:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__iadd__(self,vector:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__neg__(self)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__sub__(self,v2:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__isub__(self,vector:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "1:PySide2.QtGui.QVector2D.__div__(self,divisor:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "0:PySide2.QtGui.QVector2D.__div__(self,divisor:float)->PySide2.QtGui.QVector2D",
    "1:PySide2.QtGui.QVector2D.__idiv__(self,vector:PySide2.QtGui.QVector2D)->PySide2.QtGui.QVector2D",
    "0:PySide2.QtGui.QVector2D.__idiv__(self,divisor:float)->PySide2.QtGui.QVector2D",
    "PySide2.QtGui.QVector2D.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QVector2D.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QVector2D(PyObject *module)
{
    _Sbk_QVector2D_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVector2D",
        "QVector2D",
        &Sbk_QVector2D_spec,
        &Shiboken::callCppDestructor< ::QVector2D >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVector2D_Type);
    InitSignatureStrings(pyType, QVector2D_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVector2D_Type), Sbk_QVector2D_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QVECTOR2D_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVector2D_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVector2D_TypeF(),
        QVector2D_PythonToCpp_QVector2D_PTR,
        is_QVector2D_PythonToCpp_QVector2D_PTR_Convertible,
        QVector2D_PTR_CppToPython_QVector2D,
        QVector2D_COPY_CppToPython_QVector2D);

    Shiboken::Conversions::registerConverterName(converter, "QVector2D");
    Shiboken::Conversions::registerConverterName(converter, "QVector2D*");
    Shiboken::Conversions::registerConverterName(converter, "QVector2D&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVector2D).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVector2D_PythonToCpp_QVector2D_COPY,
        is_QVector2D_PythonToCpp_QVector2D_COPY_Convertible);

    qRegisterMetaType< ::QVector2D >("QVector2D");
}
