/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QWINDOWWRAPPER_H
#define SBK_QWINDOWWRAPPER_H

#define protected public

#include <QtGui/qwindow.h>


// Extra includes
#include <qobject.h>
#include <QtGui/qscreen.h>
#include <QtGui/qwindow.h>
#include <QtGui/qsurfaceformat.h>
#include <QtGui/qregion.h>
#include <qsize.h>
#include <qrect.h>
#include <qmargins.h>
#include <qpoint.h>
#include <QtGui/qicon.h>
#include <QtGui/qaccessible.h>
#include <QtGui/qcursor.h>
#include <QtGui/qevent.h>
#include <qcoreevent.h>
#include <qbytearray.h>
#include <qmetaobject.h>
#include <qobjectdefs.h>
#include <qthread.h>
#include <QList>
namespace PySide { class DynamicQMetaObject; }

class QWindowWrapper : public QWindow
{
public:
    QWindowWrapper(::QScreen * screen = nullptr);
    QWindowWrapper(::QWindow * parent);
    ::QAccessibleInterface * accessibleRoot() const override;
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void exposeEvent(::QExposeEvent * arg__1) override;
    void focusInEvent(::QFocusEvent * arg__1) override;
    ::QObject * focusObject() const override;
    void focusOutEvent(::QFocusEvent * arg__1) override;
    ::QSurfaceFormat format() const override;
    void hideEvent(::QHideEvent * arg__1) override;
    void keyPressEvent(::QKeyEvent * arg__1) override;
    void keyReleaseEvent(::QKeyEvent * arg__1) override;
    const ::QMetaObject * metaObject() const override;
    void mouseDoubleClickEvent(::QMouseEvent * arg__1) override;
    void mouseMoveEvent(::QMouseEvent * arg__1) override;
    void mousePressEvent(::QMouseEvent * arg__1) override;
    void mouseReleaseEvent(::QMouseEvent * arg__1) override;
    void moveEvent(::QMoveEvent * arg__1) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    void resizeEvent(::QResizeEvent * arg__1) override;
    void showEvent(::QShowEvent * arg__1) override;
    ::QSize size() const override;
    ::QSurface::SurfaceType surfaceType() const override;
    void tabletEvent(::QTabletEvent * arg__1) override;
    void timerEvent(::QTimerEvent * event) override;
    void touchEvent(::QTouchEvent * arg__1) override;
    void wheelEvent(::QWheelEvent * arg__1) override;
    ~QWindowWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[31];
};

#endif // SBK_QWINDOWWRAPPER_H

