/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qthelp_python.h"

// main header
#include "qhelpfilterengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QHelpFilterEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QHelpFilterEngineWrapper::QHelpFilterEngineWrapper(::QHelpEngineCore * helpEngine) : QHelpFilterEngine(helpEngine)
{
    resetPyMethodCache();
    // ... middle
}

void QHelpFilterEngineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QHelpFilterEngineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QHelpFilterEngineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QHelpFilterEngineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QHelpFilterEngineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QHelpFilterEngine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QHelpFilterEngineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QHelpFilterEngine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QHelpFilterEngineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QHelpFilterEngineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QHelpFilterEngine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QHelpFilterEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QHelpFilterEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QHelpFilterEngineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QHelpFilterEngineWrapper *>(this));
        return QHelpFilterEngine::qt_metacast(_clname);
}

QHelpFilterEngineWrapper::~QHelpFilterEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHelpFilterEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHelpFilterEngine >()))
        return -1;

    ::QHelpFilterEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QHelpFilterEngine", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QHelpFilterEngine::QHelpFilterEngine(QHelpEngineCore*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPENGINECORE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QHelpFilterEngine(QHelpEngineCore*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngine_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QHelpEngineCore *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QHelpFilterEngine(QHelpEngineCore*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QHelpFilterEngineWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QHelpFilterEngineWrapper(cppArg0);
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHelpFilterEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHelpFilterEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QHelpFilterEngine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QHelpFilterEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHelpFilterEngineFunc_activeFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.activeFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeFilter()const
            QString cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->activeFilter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_availableComponents(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.availableComponents";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableComponents()const
            QStringList cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->availableComponents();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_availableVersions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.availableVersions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableVersions()const
            QList<QVersionNumber > cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->availableVersions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtHelpTypeConverters[SBK_QTHELP_QLIST_QVERSIONNUMBER_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_filterData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.filterData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHelpFilterEngine::filterData(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // filterData(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_filterData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // filterData(QString)const
            QHelpFilterData cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->filterData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERDATA_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_filterData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpFilterEngineFunc_filters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.filters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filters()const
            QStringList cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->filters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_indices(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.indices";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "indices", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QHelpFilterEngine::indices()const
    // 1: QHelpFilterEngine::indices(QString)const
    if (numArgs == 0) {
        overloadId = 0; // indices()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 1; // indices(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_indices_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // indices() const
        {

            if (!PyErr_Occurred()) {
                // indices()const
                QStringList cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->indices();
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
        case 1: // indices(const QString & filterName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // indices(QString)const
                QStringList cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->indices(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_indices_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpFilterEngineFunc_namespaceToComponent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.namespaceToComponent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceToComponent()const
            QMap<QString,QString > cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->namespaceToComponent();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtHelpTypeConverters[SBK_QTHELP_QMAP_QSTRING_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_namespaceToVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.namespaceToVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namespaceToVersion()const
            QMap<QString,QVersionNumber > cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->namespaceToVersion();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtHelpTypeConverters[SBK_QTHELP_QMAP_QSTRING_QVERSIONNUMBER_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpFilterEngineFunc_namespacesForFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.namespacesForFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHelpFilterEngine::namespacesForFilter(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // namespacesForFilter(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_namespacesForFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // namespacesForFilter(QString)const
            QStringList cppResult = const_cast<const ::QHelpFilterEngine *>(cppSelf)->namespacesForFilter(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_namespacesForFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpFilterEngineFunc_removeFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.removeFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHelpFilterEngine::removeFilter(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeFilter(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_removeFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeFilter(QString)
            bool cppResult = cppSelf->removeFilter(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_removeFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpFilterEngineFunc_setActiveFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.setActiveFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHelpFilterEngine::setActiveFilter(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setActiveFilter(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_setActiveFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveFilter(QString)
            bool cppResult = cppSelf->setActiveFilter(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_setActiveFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpFilterEngineFunc_setFilterData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpFilterEngine.setFilterData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFilterData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QHelpFilterEngine::setFilterData(QString,QHelpFilterData)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERDATA_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setFilterData(QString,QHelpFilterData)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpFilterEngineFunc_setFilterData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QHelpFilterData cppArg1_local;
        ::QHelpFilterData *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERDATA_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setFilterData(QString,QHelpFilterData)
            bool cppResult = cppSelf->setFilterData(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpFilterEngineFunc_setFilterData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QHelpFilterEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHelpFilterEngine_methods[] = {
    {"activeFilter", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_activeFilter), METH_NOARGS},
    {"availableComponents", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_availableComponents), METH_NOARGS},
    {"availableVersions", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_availableVersions), METH_NOARGS},
    {"filterData", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_filterData), METH_O},
    {"filters", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_filters), METH_NOARGS},
    {"indices", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_indices), METH_VARARGS},
    {"namespaceToComponent", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_namespaceToComponent), METH_NOARGS},
    {"namespaceToVersion", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_namespaceToVersion), METH_NOARGS},
    {"namespacesForFilter", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_namespacesForFilter), METH_O},
    {"removeFilter", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_removeFilter), METH_O},
    {"setActiveFilter", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_setActiveFilter), METH_O},
    {"setFilterData", reinterpret_cast<PyCFunction>(Sbk_QHelpFilterEngineFunc_setFilterData), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QHelpFilterEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QHelpFilterEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QHelpFilterEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QHelpFilterEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHelpFilterEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHelpFilterEngine_Type = nullptr;
static SbkObjectType *Sbk_QHelpFilterEngine_TypeF(void)
{
    return _Sbk_QHelpFilterEngine_Type;
}

static PyType_Slot Sbk_QHelpFilterEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QHelpFilterEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHelpFilterEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHelpFilterEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHelpFilterEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHelpFilterEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHelpFilterEngine_spec = {
    "2:PySide2.QtHelp.QHelpFilterEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHelpFilterEngine_slots
};

} //extern "C"

static void *Sbk_QHelpFilterEngine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QHelpFilterEngine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHelpFilterEngine_PythonToCpp_QHelpFilterEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHelpFilterEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHelpFilterEngine_PythonToCpp_QHelpFilterEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHelpFilterEngine_TypeF())))
        return QHelpFilterEngine_PythonToCpp_QHelpFilterEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHelpFilterEngine_PTR_CppToPython_QHelpFilterEngine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QHelpFilterEngine *>(const_cast<void *>(cppIn)), Sbk_QHelpFilterEngine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHelpFilterEngine_SignatureStrings[] = {
    "PySide2.QtHelp.QHelpFilterEngine(self,helpEngine:PySide2.QtHelp.QHelpEngineCore)",
    "PySide2.QtHelp.QHelpFilterEngine.activeFilter(self)->QString",
    "PySide2.QtHelp.QHelpFilterEngine.availableComponents(self)->QStringList",
    "PySide2.QtHelp.QHelpFilterEngine.availableVersions(self)->QList[PySide2.QtCore.QVersionNumber]",
    "PySide2.QtHelp.QHelpFilterEngine.filterData(self,filterName:QString)->PySide2.QtHelp.QHelpFilterData",
    "PySide2.QtHelp.QHelpFilterEngine.filters(self)->QStringList",
    "1:PySide2.QtHelp.QHelpFilterEngine.indices(self)->QStringList",
    "0:PySide2.QtHelp.QHelpFilterEngine.indices(self,filterName:QString)->QStringList",
    "PySide2.QtHelp.QHelpFilterEngine.namespaceToComponent(self)->QMap[QString, QString]",
    "PySide2.QtHelp.QHelpFilterEngine.namespaceToVersion(self)->QMap[QString, PySide2.QtCore.QVersionNumber]",
    "PySide2.QtHelp.QHelpFilterEngine.namespacesForFilter(self,filterName:QString)->QStringList",
    "PySide2.QtHelp.QHelpFilterEngine.removeFilter(self,filterName:QString)->bool",
    "PySide2.QtHelp.QHelpFilterEngine.setActiveFilter(self,filterName:QString)->bool",
    "PySide2.QtHelp.QHelpFilterEngine.setFilterData(self,filterName:QString,filterData:PySide2.QtHelp.QHelpFilterData)->bool",
    nullptr}; // Sentinel

void init_QHelpFilterEngine(PyObject *module)
{
    _Sbk_QHelpFilterEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHelpFilterEngine",
        "QHelpFilterEngine*",
        &Sbk_QHelpFilterEngine_spec,
        &Shiboken::callCppDestructor< ::QHelpFilterEngine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHelpFilterEngine_Type);
    InitSignatureStrings(pyType, QHelpFilterEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHelpFilterEngine_Type), Sbk_QHelpFilterEngine_PropertyStrings);
    SbkPySide2_QtHelpTypes[SBK_QHELPFILTERENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHelpFilterEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHelpFilterEngine_TypeF(),
        QHelpFilterEngine_PythonToCpp_QHelpFilterEngine_PTR,
        is_QHelpFilterEngine_PythonToCpp_QHelpFilterEngine_PTR_Convertible,
        QHelpFilterEngine_PTR_CppToPython_QHelpFilterEngine);

    Shiboken::Conversions::registerConverterName(converter, "QHelpFilterEngine");
    Shiboken::Conversions::registerConverterName(converter, "QHelpFilterEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QHelpFilterEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHelpFilterEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHelpFilterEngineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QHelpFilterEngine_TypeF(), &Sbk_QHelpFilterEngine_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QHelpFilterEngine_TypeF(), &::QHelpFilterEngine::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QHelpFilterEngine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QHelpFilterEngine_TypeF(), &::QHelpFilterEngine::staticMetaObject, sizeof(QHelpFilterEngineWrapper));
}
