/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeorouterequest_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QMap>
#include <QtLocation/qgeorouterequest.h>
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeorectangle.h>
#include <qdatetime.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoRouteRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoRouteRequest >()))
        return -1;

    ::QGeoRouteRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoRouteRequest_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGeoRouteRequest", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoRouteRequest::QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)
    // 1: QGeoRouteRequest::QGeoRouteRequest(QGeoRouteRequest)
    // 2: QGeoRouteRequest::QGeoRouteRequest(QList<QGeoCoordinate>)
    if (numArgs == 0) {
        overloadId = 2; // QGeoRouteRequest(QList<QGeoCoordinate>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoRouteRequest(QGeoRouteRequest)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX], (pyArgs[0])))) {
        overloadId = 2; // QGeoRouteRequest(QList<QGeoCoordinate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoRouteRequest(const QGeoCoordinate & origin, const QGeoCoordinate & destination)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGeoRouteRequest_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoCoordinate cppArg0_local;
            ::QGeoCoordinate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QGeoCoordinate cppArg1_local;
            ::QGeoCoordinate *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QGeoRouteRequest(QGeoCoordinate,QGeoCoordinate)
                cptr = new ::QGeoRouteRequest(*cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // QGeoRouteRequest(const QGeoRouteRequest & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGeoRouteRequest_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoRouteRequest *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGeoRouteRequest(QGeoRouteRequest)
                cptr = new ::QGeoRouteRequest(*cppArg0);
            }
            break;
        }
        case 2: // QGeoRouteRequest(const QList<QGeoCoordinate > & waypoints)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_waypoints = Shiboken::String::createStaticString("waypoints");
                if (PyDict_Contains(kwds, key_waypoints)) {
                    value = PyDict_GetItem(kwds, key_waypoints);
                    if (value && pyArgs[0]) {
                        errInfo = key_waypoints;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoRouteRequest_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX], (pyArgs[0]))))
                            goto Sbk_QGeoRouteRequest_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_waypoints);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGeoRouteRequest_Init_TypeError;
                }
            }
            ::QList<QGeoCoordinate > cppArg0;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QGeoRouteRequest(QList<QGeoCoordinate>)
                cptr = new ::QGeoRouteRequest(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoRouteRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoRouteRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoRouteRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoRouteRequestFunc_departureTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.departureTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // departureTime()const
            QDateTime cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->departureTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_excludeAreas(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.excludeAreas";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // excludeAreas()const
            QList<QGeoRectangle > cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->excludeAreas();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEORECTANGLE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_extraParameters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.extraParameters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extraParameters()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->extraParameters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_featureTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.featureTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // featureTypes()const
            QList<QGeoRouteRequest::FeatureType > cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->featureTypes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTEREQUEST_FEATURETYPE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_featureWeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.featureWeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::featureWeight(QGeoRouteRequest::FeatureType)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // featureWeight(QGeoRouteRequest::FeatureType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_featureWeight_TypeError;

    // Call function/method
    {
        ::QGeoRouteRequest::FeatureType cppArg0{QGeoRouteRequest::NoFeature};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // featureWeight(QGeoRouteRequest::FeatureType)const
            QGeoRouteRequest::FeatureWeight cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->featureWeight(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoRouteRequestFunc_featureWeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_maneuverDetail(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.maneuverDetail";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maneuverDetail()const
            QGeoRouteRequest::ManeuverDetail cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->maneuverDetail();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_numberAlternativeRoutes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.numberAlternativeRoutes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numberAlternativeRoutes()const
            int cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->numberAlternativeRoutes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_routeOptimization(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.routeOptimization";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routeOptimization()const
            QFlags<QGeoRouteRequest::RouteOptimization> cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->routeOptimization();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_segmentDetail(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.segmentDetail";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // segmentDetail()const
            QGeoRouteRequest::SegmentDetail cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->segmentDetail();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_setDepartureTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setDepartureTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setDepartureTime(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // setDepartureTime(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setDepartureTime_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDepartureTime(QDateTime)
            cppSelf->setDepartureTime(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setDepartureTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setExcludeAreas(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setExcludeAreas";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setExcludeAreas(QList<QGeoRectangle>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEORECTANGLE_IDX], (pyArg)))) {
        overloadId = 0; // setExcludeAreas(QList<QGeoRectangle>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setExcludeAreas_TypeError;

    // Call function/method
    {
        ::QList<QGeoRectangle > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExcludeAreas(QList<QGeoRectangle>)
            cppSelf->setExcludeAreas(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setExcludeAreas_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setExtraParameters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setExtraParameters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setExtraParameters(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setExtraParameters(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setExtraParameters_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setExtraParameters(QMap<QString,QVariant>)
            cppSelf->setExtraParameters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setExtraParameters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setFeatureWeight(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setFeatureWeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFeatureWeight", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoRouteRequest::setFeatureWeight(QGeoRouteRequest::FeatureType,QGeoRouteRequest::FeatureWeight)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // setFeatureWeight(QGeoRouteRequest::FeatureType,QGeoRouteRequest::FeatureWeight)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setFeatureWeight_TypeError;

    // Call function/method
    {
        ::QGeoRouteRequest::FeatureType cppArg0{QGeoRouteRequest::NoFeature};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QGeoRouteRequest::FeatureWeight cppArg1{QGeoRouteRequest::NeutralFeatureWeight};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFeatureWeight(QGeoRouteRequest::FeatureType,QGeoRouteRequest::FeatureWeight)
            cppSelf->setFeatureWeight(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setFeatureWeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setManeuverDetail(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setManeuverDetail";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setManeuverDetail(QGeoRouteRequest::ManeuverDetail)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setManeuverDetail(QGeoRouteRequest::ManeuverDetail)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setManeuverDetail_TypeError;

    // Call function/method
    {
        ::QGeoRouteRequest::ManeuverDetail cppArg0{QGeoRouteRequest::NoManeuvers};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setManeuverDetail(QGeoRouteRequest::ManeuverDetail)
            cppSelf->setManeuverDetail(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setManeuverDetail_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setNumberAlternativeRoutes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setNumberAlternativeRoutes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setNumberAlternativeRoutes(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setNumberAlternativeRoutes(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setNumberAlternativeRoutes_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumberAlternativeRoutes(int)
            cppSelf->setNumberAlternativeRoutes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setNumberAlternativeRoutes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setRouteOptimization(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setRouteOptimization";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setRouteOptimization(QFlags<QGeoRouteRequest::RouteOptimization>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRouteOptimization(QFlags<QGeoRouteRequest::RouteOptimization>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setRouteOptimization_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::RouteOptimization> cppArg0 = QFlags<QGeoRouteRequest::RouteOptimization>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRouteOptimization(QFlags<QGeoRouteRequest::RouteOptimization>)
            cppSelf->setRouteOptimization(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setRouteOptimization_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setSegmentDetail(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setSegmentDetail";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setSegmentDetail(QGeoRouteRequest::SegmentDetail)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSegmentDetail(QGeoRouteRequest::SegmentDetail)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setSegmentDetail_TypeError;

    // Call function/method
    {
        ::QGeoRouteRequest::SegmentDetail cppArg0{QGeoRouteRequest::NoSegmentData};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSegmentDetail(QGeoRouteRequest::SegmentDetail)
            cppSelf->setSegmentDetail(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setSegmentDetail_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setTravelModes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setTravelModes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setTravelModes_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::TravelMode> cppArg0 = QFlags<QGeoRouteRequest::TravelMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
            cppSelf->setTravelModes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setTravelModes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setWaypoints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setWaypoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setWaypoints(QList<QGeoCoordinate>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX], (pyArg)))) {
        overloadId = 0; // setWaypoints(QList<QGeoCoordinate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setWaypoints_TypeError;

    // Call function/method
    {
        ::QList<QGeoCoordinate > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWaypoints(QList<QGeoCoordinate>)
            cppSelf->setWaypoints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setWaypoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_setWaypointsMetadata(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.setWaypointsMetadata";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteRequest::setWaypointsMetadata(QList<QMap<QString,QVariant> >)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setWaypointsMetadata(QList<QMap<QString,QVariant> >)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteRequestFunc_setWaypointsMetadata_TypeError;

    // Call function/method
    {
        ::QList<QMap< QString,QVariant > > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWaypointsMetadata(QList<QMap<QString,QVariant> >)
            cppSelf->setWaypointsMetadata(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteRequestFunc_setWaypointsMetadata_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteRequestFunc_travelModes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.travelModes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // travelModes()const
            QFlags<QGeoRouteRequest::TravelMode> cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->travelModes();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_waypoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.waypoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waypoints()const
            QList<QGeoCoordinate > cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->waypoints();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOCOORDINATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteRequestFunc_waypointsMetadata(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteRequest.waypointsMetadata";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // waypointsMetadata()const
            QList<QMap< QString,QVariant > > cppResult = const_cast<const ::QGeoRouteRequest *>(cppSelf)->waypointsMetadata();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoRouteRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoRouteRequest_methods[] = {
    {"departureTime", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_departureTime), METH_NOARGS},
    {"excludeAreas", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_excludeAreas), METH_NOARGS},
    {"extraParameters", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_extraParameters), METH_NOARGS},
    {"featureTypes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_featureTypes), METH_NOARGS},
    {"featureWeight", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_featureWeight), METH_O},
    {"maneuverDetail", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_maneuverDetail), METH_NOARGS},
    {"numberAlternativeRoutes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_numberAlternativeRoutes), METH_NOARGS},
    {"routeOptimization", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_routeOptimization), METH_NOARGS},
    {"segmentDetail", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_segmentDetail), METH_NOARGS},
    {"setDepartureTime", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setDepartureTime), METH_O},
    {"setExcludeAreas", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setExcludeAreas), METH_O},
    {"setExtraParameters", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setExtraParameters), METH_O},
    {"setFeatureWeight", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setFeatureWeight), METH_VARARGS},
    {"setManeuverDetail", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setManeuverDetail), METH_O},
    {"setNumberAlternativeRoutes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setNumberAlternativeRoutes), METH_O},
    {"setRouteOptimization", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setRouteOptimization), METH_O},
    {"setSegmentDetail", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setSegmentDetail), METH_O},
    {"setTravelModes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setTravelModes), METH_O},
    {"setWaypoints", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setWaypoints), METH_O},
    {"setWaypointsMetadata", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_setWaypointsMetadata), METH_O},
    {"travelModes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_travelModes), METH_NOARGS},
    {"waypoints", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_waypoints), METH_NOARGS},
    {"waypointsMetadata", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteRequestFunc_waypointsMetadata), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGeoRouteRequest_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoRouteRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), (pyArg)))) {
                // operator!=(const QGeoRouteRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoRouteRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), (pyArg)))) {
                // operator==(const QGeoRouteRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoRouteRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoRouteRequest_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoRouteRequest_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoRouteRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoRouteRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoRouteRequest_Type = nullptr;
static SbkObjectType *Sbk_QGeoRouteRequest_TypeF(void)
{
    return _Sbk_QGeoRouteRequest_Type;
}

static PyType_Slot Sbk_QGeoRouteRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoRouteRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoRouteRequest_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoRouteRequest_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoRouteRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoRouteRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoRouteRequest_spec = {
    "2:PySide2.QtLocation.QGeoRouteRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoRouteRequest_slots
};

} //extern "C"

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::TravelModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::TravelModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::TravelModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::TravelModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::TravelModes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::TravelModes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureTypes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::FeatureTypes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureWeights cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureWeights cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureWeights cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::FeatureWeights>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::FeatureWeights cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::FeatureWeights cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::RouteOptimizations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::RouteOptimizations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::RouteOptimizations cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::RouteOptimizations>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::RouteOptimizations cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::RouteOptimizations cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::SegmentDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::SegmentDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::SegmentDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::SegmentDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::SegmentDetails cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::SegmentDetails cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::ManeuverDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::ManeuverDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::ManeuverDetails cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoRouteRequest::ManeuverDetails>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoRouteRequest::ManeuverDetails cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, self, &cppSelf);
    ::QGeoRouteRequest::ManeuverDetails cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoRouteRequest_TravelMode_PythonToCpp_QGeoRouteRequest_TravelMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::TravelMode *>(cppOut) =
        static_cast<::QGeoRouteRequest::TravelMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_TravelMode_PythonToCpp_QGeoRouteRequest_TravelMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX]))
        return QGeoRouteRequest_TravelMode_PythonToCpp_QGeoRouteRequest_TravelMode;
    return {};
}
static PyObject *QGeoRouteRequest_TravelMode_CppToPython_QGeoRouteRequest_TravelMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::TravelMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_TravelMode__PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::TravelMode> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::TravelMode>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_TravelMode__PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX]))
        return QFlags_QGeoRouteRequest_TravelMode__PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_TravelMode__CppToPython_QFlags_QGeoRouteRequest_TravelMode_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::TravelMode> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX]));

}

static void QGeoRouteRequest_TravelMode_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::TravelMode> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::TravelMode>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_TravelMode_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX]))
        return QGeoRouteRequest_TravelMode_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::TravelMode> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::TravelMode>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_;
    return {};
}
static void QGeoRouteRequest_FeatureType_PythonToCpp_QGeoRouteRequest_FeatureType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::FeatureType *>(cppOut) =
        static_cast<::QGeoRouteRequest::FeatureType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_FeatureType_PythonToCpp_QGeoRouteRequest_FeatureType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX]))
        return QGeoRouteRequest_FeatureType_PythonToCpp_QGeoRouteRequest_FeatureType;
    return {};
}
static PyObject *QGeoRouteRequest_FeatureType_CppToPython_QGeoRouteRequest_FeatureType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::FeatureType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_FeatureType__PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureType> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_FeatureType__PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX]))
        return QFlags_QGeoRouteRequest_FeatureType__PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_FeatureType__CppToPython_QFlags_QGeoRouteRequest_FeatureType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::FeatureType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX]));

}

static void QGeoRouteRequest_FeatureType_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureType> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_FeatureType_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX]))
        return QGeoRouteRequest_FeatureType_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureType> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_;
    return {};
}
static void QGeoRouteRequest_FeatureWeight_PythonToCpp_QGeoRouteRequest_FeatureWeight(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::FeatureWeight *>(cppOut) =
        static_cast<::QGeoRouteRequest::FeatureWeight>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_FeatureWeight_PythonToCpp_QGeoRouteRequest_FeatureWeight_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]))
        return QGeoRouteRequest_FeatureWeight_PythonToCpp_QGeoRouteRequest_FeatureWeight;
    return {};
}
static PyObject *QGeoRouteRequest_FeatureWeight_CppToPython_QGeoRouteRequest_FeatureWeight(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::FeatureWeight *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_FeatureWeight__PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureWeight> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureWeight>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_FeatureWeight__PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]))
        return QFlags_QGeoRouteRequest_FeatureWeight__PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_FeatureWeight__CppToPython_QFlags_QGeoRouteRequest_FeatureWeight_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::FeatureWeight> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]));

}

static void QGeoRouteRequest_FeatureWeight_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureWeight> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureWeight>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_FeatureWeight_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]))
        return QGeoRouteRequest_FeatureWeight_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::FeatureWeight> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::FeatureWeight>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_;
    return {};
}
static void QGeoRouteRequest_RouteOptimization_PythonToCpp_QGeoRouteRequest_RouteOptimization(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::RouteOptimization *>(cppOut) =
        static_cast<::QGeoRouteRequest::RouteOptimization>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_RouteOptimization_PythonToCpp_QGeoRouteRequest_RouteOptimization_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]))
        return QGeoRouteRequest_RouteOptimization_PythonToCpp_QGeoRouteRequest_RouteOptimization;
    return {};
}
static PyObject *QGeoRouteRequest_RouteOptimization_CppToPython_QGeoRouteRequest_RouteOptimization(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::RouteOptimization *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_RouteOptimization__PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::RouteOptimization> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::RouteOptimization>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_RouteOptimization__PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]))
        return QFlags_QGeoRouteRequest_RouteOptimization__PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_RouteOptimization__CppToPython_QFlags_QGeoRouteRequest_RouteOptimization_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::RouteOptimization> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]));

}

static void QGeoRouteRequest_RouteOptimization_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::RouteOptimization> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::RouteOptimization>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_RouteOptimization_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]))
        return QGeoRouteRequest_RouteOptimization_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::RouteOptimization> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::RouteOptimization>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_;
    return {};
}
static void QGeoRouteRequest_SegmentDetail_PythonToCpp_QGeoRouteRequest_SegmentDetail(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::SegmentDetail *>(cppOut) =
        static_cast<::QGeoRouteRequest::SegmentDetail>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_SegmentDetail_PythonToCpp_QGeoRouteRequest_SegmentDetail_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]))
        return QGeoRouteRequest_SegmentDetail_PythonToCpp_QGeoRouteRequest_SegmentDetail;
    return {};
}
static PyObject *QGeoRouteRequest_SegmentDetail_CppToPython_QGeoRouteRequest_SegmentDetail(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::SegmentDetail *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_SegmentDetail__PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::SegmentDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::SegmentDetail>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_SegmentDetail__PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]))
        return QFlags_QGeoRouteRequest_SegmentDetail__PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_SegmentDetail__CppToPython_QFlags_QGeoRouteRequest_SegmentDetail_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::SegmentDetail> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]));

}

static void QGeoRouteRequest_SegmentDetail_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::SegmentDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::SegmentDetail>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_SegmentDetail_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]))
        return QGeoRouteRequest_SegmentDetail_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::SegmentDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::SegmentDetail>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_;
    return {};
}
static void QGeoRouteRequest_ManeuverDetail_PythonToCpp_QGeoRouteRequest_ManeuverDetail(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteRequest::ManeuverDetail *>(cppOut) =
        static_cast<::QGeoRouteRequest::ManeuverDetail>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteRequest_ManeuverDetail_PythonToCpp_QGeoRouteRequest_ManeuverDetail_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]))
        return QGeoRouteRequest_ManeuverDetail_PythonToCpp_QGeoRouteRequest_ManeuverDetail;
    return {};
}
static PyObject *QGeoRouteRequest_ManeuverDetail_CppToPython_QGeoRouteRequest_ManeuverDetail(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteRequest::ManeuverDetail *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX], castCppIn);

}

static void QFlags_QGeoRouteRequest_ManeuverDetail__PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::ManeuverDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::ManeuverDetail>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoRouteRequest_ManeuverDetail__PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]))
        return QFlags_QGeoRouteRequest_ManeuverDetail__PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_;
    return {};
}
static PyObject *QFlags_QGeoRouteRequest_ManeuverDetail__CppToPython_QFlags_QGeoRouteRequest_ManeuverDetail_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoRouteRequest::ManeuverDetail> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]));

}

static void QGeoRouteRequest_ManeuverDetail_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoRouteRequest::ManeuverDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::ManeuverDetail>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoRouteRequest_ManeuverDetail_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]))
        return QGeoRouteRequest_ManeuverDetail_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoRouteRequest::ManeuverDetail> *>(cppOut) =
        ::QFlags<QGeoRouteRequest::ManeuverDetail>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]))
        return number_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoRouteRequest_PythonToCpp_QGeoRouteRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoRouteRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoRouteRequest_PythonToCpp_QGeoRouteRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoRouteRequest_TypeF())))
        return QGeoRouteRequest_PythonToCpp_QGeoRouteRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoRouteRequest_PTR_CppToPython_QGeoRouteRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoRouteRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoRouteRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoRouteRequest_SignatureStrings[] = {
    "2:PySide2.QtLocation.QGeoRouteRequest(self,origin:PySide2.QtPositioning.QGeoCoordinate,destination:PySide2.QtPositioning.QGeoCoordinate)",
    "1:PySide2.QtLocation.QGeoRouteRequest(self,other:PySide2.QtLocation.QGeoRouteRequest)",
    "0:PySide2.QtLocation.QGeoRouteRequest(self,waypoints:QList[PySide2.QtPositioning.QGeoCoordinate]=QList< QGeoCoordinate >())",
    "PySide2.QtLocation.QGeoRouteRequest.departureTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtLocation.QGeoRouteRequest.excludeAreas(self)->QList[PySide2.QtPositioning.QGeoRectangle]",
    "PySide2.QtLocation.QGeoRouteRequest.extraParameters(self)->QMap[QString, QVariant]",
    "PySide2.QtLocation.QGeoRouteRequest.featureTypes(self)->QList[PySide2.QtLocation.QGeoRouteRequest.FeatureType]",
    "PySide2.QtLocation.QGeoRouteRequest.featureWeight(self,featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType)->PySide2.QtLocation.QGeoRouteRequest.FeatureWeight",
    "PySide2.QtLocation.QGeoRouteRequest.maneuverDetail(self)->PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail",
    "PySide2.QtLocation.QGeoRouteRequest.numberAlternativeRoutes(self)->int",
    "PySide2.QtLocation.QGeoRouteRequest.routeOptimization(self)->PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations",
    "PySide2.QtLocation.QGeoRouteRequest.segmentDetail(self)->PySide2.QtLocation.QGeoRouteRequest.SegmentDetail",
    "PySide2.QtLocation.QGeoRouteRequest.setDepartureTime(self,departureTime:PySide2.QtCore.QDateTime)",
    "PySide2.QtLocation.QGeoRouteRequest.setExcludeAreas(self,areas:QList[PySide2.QtPositioning.QGeoRectangle])",
    "PySide2.QtLocation.QGeoRouteRequest.setExtraParameters(self,extraParameters:QMap[QString, QVariant])",
    "PySide2.QtLocation.QGeoRouteRequest.setFeatureWeight(self,featureType:PySide2.QtLocation.QGeoRouteRequest.FeatureType,featureWeight:PySide2.QtLocation.QGeoRouteRequest.FeatureWeight)",
    "PySide2.QtLocation.QGeoRouteRequest.setManeuverDetail(self,maneuverDetail:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail)",
    "PySide2.QtLocation.QGeoRouteRequest.setNumberAlternativeRoutes(self,alternatives:int)",
    "PySide2.QtLocation.QGeoRouteRequest.setRouteOptimization(self,optimization:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations)",
    "PySide2.QtLocation.QGeoRouteRequest.setSegmentDetail(self,segmentDetail:PySide2.QtLocation.QGeoRouteRequest.SegmentDetail)",
    "PySide2.QtLocation.QGeoRouteRequest.setTravelModes(self,travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes)",
    "PySide2.QtLocation.QGeoRouteRequest.setWaypoints(self,waypoints:QList[PySide2.QtPositioning.QGeoCoordinate])",
    "PySide2.QtLocation.QGeoRouteRequest.setWaypointsMetadata(self,waypointMetadata:QList[QMap[QString, QVariant]])",
    "PySide2.QtLocation.QGeoRouteRequest.travelModes(self)->PySide2.QtLocation.QGeoRouteRequest.TravelModes",
    "PySide2.QtLocation.QGeoRouteRequest.waypoints(self)->QList[PySide2.QtPositioning.QGeoCoordinate]",
    "PySide2.QtLocation.QGeoRouteRequest.waypointsMetadata(self)->QList[QMap[QString, QVariant]]",
    nullptr}; // Sentinel

void init_QGeoRouteRequest(PyObject *module)
{
    _Sbk_QGeoRouteRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoRouteRequest",
        "QGeoRouteRequest*",
        &Sbk_QGeoRouteRequest_spec,
        &Shiboken::callCppDestructor< ::QGeoRouteRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRouteRequest_Type);
    InitSignatureStrings(pyType, QGeoRouteRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRouteRequest_Type), Sbk_QGeoRouteRequest_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoRouteRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoRouteRequest_TypeF(),
        QGeoRouteRequest_PythonToCpp_QGeoRouteRequest_PTR,
        is_QGeoRouteRequest_PythonToCpp_QGeoRouteRequest_PTR_Convertible,
        QGeoRouteRequest_PTR_CppToPython_QGeoRouteRequest);

    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoRouteRequest).name());


    // Initialization of enums.

    // Initialization of enum 'TravelMode'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.TravelModes", SbkPySide2_QtLocation_QGeoRouteRequest_TravelMode_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "TravelMode",
        "2:PySide2.QtLocation.QGeoRouteRequest.TravelMode",
        "QGeoRouteRequest::TravelMode",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "CarTravel", (long) QGeoRouteRequest::TravelMode::CarTravel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "PedestrianTravel", (long) QGeoRouteRequest::TravelMode::PedestrianTravel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "BicycleTravel", (long) QGeoRouteRequest::TravelMode::BicycleTravel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "PublicTransitTravel", (long) QGeoRouteRequest::TravelMode::PublicTransitTravel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "TruckTravel", (long) QGeoRouteRequest::TravelMode::TruckTravel))
        return;
    // Register converter for enum 'QGeoRouteRequest::TravelMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX],
            QGeoRouteRequest_TravelMode_CppToPython_QGeoRouteRequest_TravelMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_TravelMode_PythonToCpp_QGeoRouteRequest_TravelMode,
            is_QGeoRouteRequest_TravelMode_PythonToCpp_QGeoRouteRequest_TravelMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_TRAVELMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::TravelMode");
        Shiboken::Conversions::registerConverterName(converter, "TravelMode");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::TravelMode>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX],
            QFlags_QGeoRouteRequest_TravelMode__CppToPython_QFlags_QGeoRouteRequest_TravelMode_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_TravelMode_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_,
            is_QGeoRouteRequest_TravelMode_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_TravelMode__PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_,
            is_QFlags_QGeoRouteRequest_TravelMode__PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_TravelMode__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::TravelModes");
        Shiboken::Conversions::registerConverterName(converter, "TravelModes");
    }
    // End of 'TravelMode' enum/flags.

    // Initialization of enum 'FeatureType'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.FeatureTypes", SbkPySide2_QtLocation_QGeoRouteRequest_FeatureType_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "FeatureType",
        "2:PySide2.QtLocation.QGeoRouteRequest.FeatureType",
        "QGeoRouteRequest::FeatureType",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "NoFeature", (long) QGeoRouteRequest::FeatureType::NoFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "TollFeature", (long) QGeoRouteRequest::FeatureType::TollFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "HighwayFeature", (long) QGeoRouteRequest::FeatureType::HighwayFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "PublicTransitFeature", (long) QGeoRouteRequest::FeatureType::PublicTransitFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "FerryFeature", (long) QGeoRouteRequest::FeatureType::FerryFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "TunnelFeature", (long) QGeoRouteRequest::FeatureType::TunnelFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "DirtRoadFeature", (long) QGeoRouteRequest::FeatureType::DirtRoadFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "ParksFeature", (long) QGeoRouteRequest::FeatureType::ParksFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "MotorPoolLaneFeature", (long) QGeoRouteRequest::FeatureType::MotorPoolLaneFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "TrafficFeature", (long) QGeoRouteRequest::FeatureType::TrafficFeature))
        return;
    // Register converter for enum 'QGeoRouteRequest::FeatureType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX],
            QGeoRouteRequest_FeatureType_CppToPython_QGeoRouteRequest_FeatureType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_FeatureType_PythonToCpp_QGeoRouteRequest_FeatureType,
            is_QGeoRouteRequest_FeatureType_PythonToCpp_QGeoRouteRequest_FeatureType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATURETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::FeatureType");
        Shiboken::Conversions::registerConverterName(converter, "FeatureType");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::FeatureType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX],
            QFlags_QGeoRouteRequest_FeatureType__CppToPython_QFlags_QGeoRouteRequest_FeatureType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_FeatureType_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_,
            is_QGeoRouteRequest_FeatureType_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_FeatureType__PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_,
            is_QFlags_QGeoRouteRequest_FeatureType__PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::FeatureTypes");
        Shiboken::Conversions::registerConverterName(converter, "FeatureTypes");
    }
    // End of 'FeatureType' enum/flags.

    // Initialization of enum 'FeatureWeight'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.FeatureWeights", SbkPySide2_QtLocation_QGeoRouteRequest_FeatureWeight_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "FeatureWeight",
        "2:PySide2.QtLocation.QGeoRouteRequest.FeatureWeight",
        "QGeoRouteRequest::FeatureWeight",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "NeutralFeatureWeight", (long) QGeoRouteRequest::FeatureWeight::NeutralFeatureWeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "PreferFeatureWeight", (long) QGeoRouteRequest::FeatureWeight::PreferFeatureWeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "RequireFeatureWeight", (long) QGeoRouteRequest::FeatureWeight::RequireFeatureWeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "AvoidFeatureWeight", (long) QGeoRouteRequest::FeatureWeight::AvoidFeatureWeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "DisallowFeatureWeight", (long) QGeoRouteRequest::FeatureWeight::DisallowFeatureWeight))
        return;
    // Register converter for enum 'QGeoRouteRequest::FeatureWeight'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
            QGeoRouteRequest_FeatureWeight_CppToPython_QGeoRouteRequest_FeatureWeight);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_FeatureWeight_PythonToCpp_QGeoRouteRequest_FeatureWeight,
            is_QGeoRouteRequest_FeatureWeight_PythonToCpp_QGeoRouteRequest_FeatureWeight_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::FeatureWeight");
        Shiboken::Conversions::registerConverterName(converter, "FeatureWeight");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::FeatureWeight>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX],
            QFlags_QGeoRouteRequest_FeatureWeight__CppToPython_QFlags_QGeoRouteRequest_FeatureWeight_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_FeatureWeight_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_,
            is_QGeoRouteRequest_FeatureWeight_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_FeatureWeight__PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_,
            is_QFlags_QGeoRouteRequest_FeatureWeight__PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_FeatureWeight__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::FeatureWeights");
        Shiboken::Conversions::registerConverterName(converter, "FeatureWeights");
    }
    // End of 'FeatureWeight' enum/flags.

    // Initialization of enum 'RouteOptimization'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations", SbkPySide2_QtLocation_QGeoRouteRequest_RouteOptimization_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "RouteOptimization",
        "2:PySide2.QtLocation.QGeoRouteRequest.RouteOptimization",
        "QGeoRouteRequest::RouteOptimization",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "ShortestRoute", (long) QGeoRouteRequest::RouteOptimization::ShortestRoute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "FastestRoute", (long) QGeoRouteRequest::RouteOptimization::FastestRoute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "MostEconomicRoute", (long) QGeoRouteRequest::RouteOptimization::MostEconomicRoute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "MostScenicRoute", (long) QGeoRouteRequest::RouteOptimization::MostScenicRoute))
        return;
    // Register converter for enum 'QGeoRouteRequest::RouteOptimization'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
            QGeoRouteRequest_RouteOptimization_CppToPython_QGeoRouteRequest_RouteOptimization);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_RouteOptimization_PythonToCpp_QGeoRouteRequest_RouteOptimization,
            is_QGeoRouteRequest_RouteOptimization_PythonToCpp_QGeoRouteRequest_RouteOptimization_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::RouteOptimization");
        Shiboken::Conversions::registerConverterName(converter, "RouteOptimization");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::RouteOptimization>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX],
            QFlags_QGeoRouteRequest_RouteOptimization__CppToPython_QFlags_QGeoRouteRequest_RouteOptimization_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_RouteOptimization_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_,
            is_QGeoRouteRequest_RouteOptimization_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_RouteOptimization__PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_,
            is_QFlags_QGeoRouteRequest_RouteOptimization__PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_RouteOptimization__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::RouteOptimizations");
        Shiboken::Conversions::registerConverterName(converter, "RouteOptimizations");
    }
    // End of 'RouteOptimization' enum/flags.

    // Initialization of enum 'SegmentDetail'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.SegmentDetails", SbkPySide2_QtLocation_QGeoRouteRequest_SegmentDetail_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "SegmentDetail",
        "2:PySide2.QtLocation.QGeoRouteRequest.SegmentDetail",
        "QGeoRouteRequest::SegmentDetail",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "NoSegmentData", (long) QGeoRouteRequest::SegmentDetail::NoSegmentData))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "BasicSegmentData", (long) QGeoRouteRequest::SegmentDetail::BasicSegmentData))
        return;
    // Register converter for enum 'QGeoRouteRequest::SegmentDetail'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX],
            QGeoRouteRequest_SegmentDetail_CppToPython_QGeoRouteRequest_SegmentDetail);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_SegmentDetail_PythonToCpp_QGeoRouteRequest_SegmentDetail,
            is_QGeoRouteRequest_SegmentDetail_PythonToCpp_QGeoRouteRequest_SegmentDetail_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::SegmentDetail");
        Shiboken::Conversions::registerConverterName(converter, "SegmentDetail");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::SegmentDetail>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX],
            QFlags_QGeoRouteRequest_SegmentDetail__CppToPython_QFlags_QGeoRouteRequest_SegmentDetail_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_SegmentDetail_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_,
            is_QGeoRouteRequest_SegmentDetail_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_SegmentDetail__PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_,
            is_QFlags_QGeoRouteRequest_SegmentDetail__PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_SegmentDetail__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::SegmentDetails");
        Shiboken::Conversions::registerConverterName(converter, "SegmentDetails");
    }
    // End of 'SegmentDetail' enum/flags.

    // Initialization of enum 'ManeuverDetail'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails", SbkPySide2_QtLocation_QGeoRouteRequest_ManeuverDetail_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteRequest_TypeF(),
        "ManeuverDetail",
        "2:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetail",
        "QGeoRouteRequest::ManeuverDetail",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "NoManeuvers", (long) QGeoRouteRequest::ManeuverDetail::NoManeuvers))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX],
        Sbk_QGeoRouteRequest_TypeF(), "BasicManeuvers", (long) QGeoRouteRequest::ManeuverDetail::BasicManeuvers))
        return;
    // Register converter for enum 'QGeoRouteRequest::ManeuverDetail'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX],
            QGeoRouteRequest_ManeuverDetail_CppToPython_QGeoRouteRequest_ManeuverDetail);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_ManeuverDetail_PythonToCpp_QGeoRouteRequest_ManeuverDetail,
            is_QGeoRouteRequest_ManeuverDetail_PythonToCpp_QGeoRouteRequest_ManeuverDetail_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::ManeuverDetail");
        Shiboken::Conversions::registerConverterName(converter, "ManeuverDetail");
    }
    // Register converter for flag 'QFlags<QGeoRouteRequest::ManeuverDetail>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX],
            QFlags_QGeoRouteRequest_ManeuverDetail__CppToPython_QFlags_QGeoRouteRequest_ManeuverDetail_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteRequest_ManeuverDetail_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_,
            is_QGeoRouteRequest_ManeuverDetail_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoRouteRequest_ManeuverDetail__PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_,
            is_QFlags_QGeoRouteRequest_ManeuverDetail__PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail_,
            is_number_PythonToCpp_QFlags_QGeoRouteRequest_ManeuverDetail__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteRequest::ManeuverDetails");
        Shiboken::Conversions::registerConverterName(converter, "ManeuverDetails");
    }
    // End of 'ManeuverDetail' enum/flags.

    qRegisterMetaType< ::QGeoRouteRequest::TravelMode >("QGeoRouteRequest::TravelMode");
    qRegisterMetaType< ::QGeoRouteRequest::TravelModes >("QGeoRouteRequest::TravelModes");
    qRegisterMetaType< ::QGeoRouteRequest::FeatureType >("QGeoRouteRequest::FeatureType");
    qRegisterMetaType< ::QGeoRouteRequest::FeatureTypes >("QGeoRouteRequest::FeatureTypes");
    qRegisterMetaType< ::QGeoRouteRequest::FeatureWeight >("QGeoRouteRequest::FeatureWeight");
    qRegisterMetaType< ::QGeoRouteRequest::FeatureWeights >("QGeoRouteRequest::FeatureWeights");
    qRegisterMetaType< ::QGeoRouteRequest::RouteOptimization >("QGeoRouteRequest::RouteOptimization");
    qRegisterMetaType< ::QGeoRouteRequest::RouteOptimizations >("QGeoRouteRequest::RouteOptimizations");
    qRegisterMetaType< ::QGeoRouteRequest::SegmentDetail >("QGeoRouteRequest::SegmentDetail");
    qRegisterMetaType< ::QGeoRouteRequest::SegmentDetails >("QGeoRouteRequest::SegmentDetails");
    qRegisterMetaType< ::QGeoRouteRequest::ManeuverDetail >("QGeoRouteRequest::ManeuverDetail");
    qRegisterMetaType< ::QGeoRouteRequest::ManeuverDetails >("QGeoRouteRequest::ManeuverDetails");
}
