/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeoserviceprovider_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoServiceProviderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoServiceProviderWrapper::QGeoServiceProviderWrapper(const ::QString & providerName, const ::QMap<QString,QVariant > & parameters, bool allowExperimental) : QGeoServiceProvider(providerName, parameters, allowExperimental)
{
    resetPyMethodCache();
    // ... middle
}

void QGeoServiceProviderWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoServiceProviderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoServiceProviderWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoServiceProviderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGeoServiceProviderWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProvider.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoServiceProviderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProvider.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGeoServiceProviderWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoServiceProviderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoServiceProvider::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoServiceProviderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoServiceProvider::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoServiceProviderWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoServiceProviderWrapper *>(this));
        return QGeoServiceProvider::qt_metacast(_clname);
}

QGeoServiceProviderWrapper::~QGeoServiceProviderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoServiceProvider_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoServiceProvider >()))
        return -1;

    ::QGeoServiceProviderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGeoServiceProvider_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QGeoServiceProvider", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoServiceProvider::QGeoServiceProvider(QString,QMap<QString,QVariant>,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QGeoServiceProvider(QString,QMap<QString,QVariant>,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // QGeoServiceProvider(QString,QMap<QString,QVariant>,bool)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
                overloadId = 0; // QGeoServiceProvider(QString,QMap<QString,QVariant>,bool)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProvider_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parameters = Shiboken::String::createStaticString("parameters");
            if (PyDict_Contains(kwds, key_parameters)) {
                value = PyDict_GetItem(kwds, key_parameters);
                if (value && pyArgs[1]) {
                    errInfo = key_parameters;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoServiceProvider_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QGeoServiceProvider_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parameters);
            }
            static PyObject *const key_allowExperimental = Shiboken::String::createStaticString("allowExperimental");
            if (PyDict_Contains(kwds, key_allowExperimental)) {
                value = PyDict_GetItem(kwds, key_allowExperimental);
                if (value && pyArgs[2]) {
                    errInfo = key_allowExperimental;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoServiceProvider_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))
                        goto Sbk_QGeoServiceProvider_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_allowExperimental);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QMap<QString,QVariant > cppArg1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // QGeoServiceProvider(QString,QMap<QString,QVariant>,bool)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGeoServiceProviderWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGeoServiceProviderWrapper(cppArg0, cppArg1, cppArg2);
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoServiceProvider >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoServiceProvider_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoServiceProvider_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoServiceProvider_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoServiceProviderFunc_availableServiceProviders(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.availableServiceProviders";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableServiceProviders()
            QStringList cppResult = ::QGeoServiceProvider::availableServiceProviders();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_geocodingError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.geocodingError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geocodingError()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->geocodingError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_geocodingErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.geocodingErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geocodingErrorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->geocodingErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_geocodingFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.geocodingFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geocodingFeatures()const
            QFlags<QGeoServiceProvider::GeocodingFeature> cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->geocodingFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_geocodingManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.geocodingManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geocodingManager()const
            QGeoCodingManager * cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->geocodingManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOCODINGMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_mappingError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.mappingError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mappingError()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->mappingError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_mappingErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.mappingErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mappingErrorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->mappingErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_mappingFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.mappingFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mappingFeatures()const
            QFlags<QGeoServiceProvider::MappingFeature> cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->mappingFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_navigationError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.navigationError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // navigationError()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->navigationError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_navigationErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.navigationErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // navigationErrorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->navigationErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_navigationFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.navigationFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // navigationFeatures()const
            QFlags<QGeoServiceProvider::NavigationFeature> cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->navigationFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_placeManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.placeManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placeManager()const
            QPlaceManager * cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->placeManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_placesError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.placesError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placesError()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->placesError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_placesErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.placesErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placesErrorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->placesErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_placesFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.placesFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placesFeatures()const
            QFlags<QGeoServiceProvider::PlacesFeature> cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->placesFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_routingError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.routingError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routingError()const
            QGeoServiceProvider::Error cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->routingError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_routingErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.routingErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routingErrorString()const
            QString cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->routingErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_routingFeatures(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.routingFeatures";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routingFeatures()const
            QFlags<QGeoServiceProvider::RoutingFeature> cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->routingFeatures();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_routingManager(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.routingManager";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routingManager()const
            QGeoRoutingManager * cppResult = const_cast<const ::QGeoServiceProvider *>(cppSelf)->routingManager();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoServiceProviderFunc_setAllowExperimental(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.setAllowExperimental";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoServiceProvider::setAllowExperimental(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAllowExperimental(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFunc_setAllowExperimental_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAllowExperimental(bool)
            cppSelf->setAllowExperimental(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoServiceProviderFunc_setAllowExperimental_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoServiceProviderFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoServiceProvider::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoServiceProviderFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoServiceProviderFunc_setParameters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProvider.setParameters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoServiceProvider::setParameters(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setParameters(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFunc_setParameters_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setParameters(QMap<QString,QVariant>)
            cppSelf->setParameters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoServiceProviderFunc_setParameters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGeoServiceProvider_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoServiceProvider_methods[] = {
    {"availableServiceProviders", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_availableServiceProviders), METH_NOARGS|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_errorString), METH_NOARGS},
    {"geocodingError", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_geocodingError), METH_NOARGS},
    {"geocodingErrorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_geocodingErrorString), METH_NOARGS},
    {"geocodingFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_geocodingFeatures), METH_NOARGS},
    {"geocodingManager", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_geocodingManager), METH_NOARGS},
    {"mappingError", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_mappingError), METH_NOARGS},
    {"mappingErrorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_mappingErrorString), METH_NOARGS},
    {"mappingFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_mappingFeatures), METH_NOARGS},
    {"navigationError", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_navigationError), METH_NOARGS},
    {"navigationErrorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_navigationErrorString), METH_NOARGS},
    {"navigationFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_navigationFeatures), METH_NOARGS},
    {"placeManager", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_placeManager), METH_NOARGS},
    {"placesError", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_placesError), METH_NOARGS},
    {"placesErrorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_placesErrorString), METH_NOARGS},
    {"placesFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_placesFeatures), METH_NOARGS},
    {"routingError", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_routingError), METH_NOARGS},
    {"routingErrorString", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_routingErrorString), METH_NOARGS},
    {"routingFeatures", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_routingFeatures), METH_NOARGS},
    {"routingManager", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_routingManager), METH_NOARGS},
    {"setAllowExperimental", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_setAllowExperimental), METH_O},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_setLocale), METH_O},
    {"setParameters", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFunc_setParameters), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoServiceProvider_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoServiceProvider *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoServiceProviderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoServiceProvider_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoServiceProvider_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoServiceProvider_Type = nullptr;
static SbkObjectType *Sbk_QGeoServiceProvider_TypeF(void)
{
    return _Sbk_QGeoServiceProvider_Type;
}

static PyType_Slot Sbk_QGeoServiceProvider_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoServiceProvider_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoServiceProvider_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoServiceProvider_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoServiceProvider_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoServiceProvider_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoServiceProvider_spec = {
    "2:PySide2.QtLocation.QGeoServiceProvider",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoServiceProvider_slots
};

} //extern "C"

static void *Sbk_QGeoServiceProvider_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoServiceProvider *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::RoutingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::RoutingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::RoutingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::RoutingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::RoutingFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoServiceProvider::RoutingFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::GeocodingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::GeocodingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::GeocodingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::GeocodingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::GeocodingFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoServiceProvider::GeocodingFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::MappingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::MappingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::MappingFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::MappingFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::MappingFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoServiceProvider::MappingFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::PlacesFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::PlacesFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::PlacesFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::PlacesFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::PlacesFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoServiceProvider::PlacesFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::NavigationFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::NavigationFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::NavigationFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGeoServiceProvider::NavigationFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGeoServiceProvider::NavigationFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, self, &cppSelf);
    ::QGeoServiceProvider::NavigationFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoServiceProvider_Error_PythonToCpp_QGeoServiceProvider_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::Error *>(cppOut) =
        static_cast<::QGeoServiceProvider::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_Error_PythonToCpp_QGeoServiceProvider_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX]))
        return QGeoServiceProvider_Error_PythonToCpp_QGeoServiceProvider_Error;
    return {};
}
static PyObject *QGeoServiceProvider_Error_CppToPython_QGeoServiceProvider_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX], castCppIn);

}

static void QGeoServiceProvider_RoutingFeature_PythonToCpp_QGeoServiceProvider_RoutingFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::RoutingFeature *>(cppOut) =
        static_cast<::QGeoServiceProvider::RoutingFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_RoutingFeature_PythonToCpp_QGeoServiceProvider_RoutingFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]))
        return QGeoServiceProvider_RoutingFeature_PythonToCpp_QGeoServiceProvider_RoutingFeature;
    return {};
}
static PyObject *QGeoServiceProvider_RoutingFeature_CppToPython_QGeoServiceProvider_RoutingFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::RoutingFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoServiceProvider_RoutingFeature__PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::RoutingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::RoutingFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoServiceProvider_RoutingFeature__PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]))
        return QFlags_QGeoServiceProvider_RoutingFeature__PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_;
    return {};
}
static PyObject *QFlags_QGeoServiceProvider_RoutingFeature__CppToPython_QFlags_QGeoServiceProvider_RoutingFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoServiceProvider::RoutingFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]));

}

static void QGeoServiceProvider_RoutingFeature_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::RoutingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::RoutingFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoServiceProvider_RoutingFeature_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]))
        return QGeoServiceProvider_RoutingFeature_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoServiceProvider::RoutingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::RoutingFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_;
    return {};
}
static void QGeoServiceProvider_GeocodingFeature_PythonToCpp_QGeoServiceProvider_GeocodingFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::GeocodingFeature *>(cppOut) =
        static_cast<::QGeoServiceProvider::GeocodingFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_GeocodingFeature_PythonToCpp_QGeoServiceProvider_GeocodingFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]))
        return QGeoServiceProvider_GeocodingFeature_PythonToCpp_QGeoServiceProvider_GeocodingFeature;
    return {};
}
static PyObject *QGeoServiceProvider_GeocodingFeature_CppToPython_QGeoServiceProvider_GeocodingFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::GeocodingFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoServiceProvider_GeocodingFeature__PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::GeocodingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::GeocodingFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoServiceProvider_GeocodingFeature__PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]))
        return QFlags_QGeoServiceProvider_GeocodingFeature__PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_;
    return {};
}
static PyObject *QFlags_QGeoServiceProvider_GeocodingFeature__CppToPython_QFlags_QGeoServiceProvider_GeocodingFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoServiceProvider::GeocodingFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]));

}

static void QGeoServiceProvider_GeocodingFeature_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::GeocodingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::GeocodingFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoServiceProvider_GeocodingFeature_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]))
        return QGeoServiceProvider_GeocodingFeature_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoServiceProvider::GeocodingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::GeocodingFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_;
    return {};
}
static void QGeoServiceProvider_MappingFeature_PythonToCpp_QGeoServiceProvider_MappingFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::MappingFeature *>(cppOut) =
        static_cast<::QGeoServiceProvider::MappingFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_MappingFeature_PythonToCpp_QGeoServiceProvider_MappingFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]))
        return QGeoServiceProvider_MappingFeature_PythonToCpp_QGeoServiceProvider_MappingFeature;
    return {};
}
static PyObject *QGeoServiceProvider_MappingFeature_CppToPython_QGeoServiceProvider_MappingFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::MappingFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoServiceProvider_MappingFeature__PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::MappingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::MappingFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoServiceProvider_MappingFeature__PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]))
        return QFlags_QGeoServiceProvider_MappingFeature__PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_;
    return {};
}
static PyObject *QFlags_QGeoServiceProvider_MappingFeature__CppToPython_QFlags_QGeoServiceProvider_MappingFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoServiceProvider::MappingFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]));

}

static void QGeoServiceProvider_MappingFeature_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::MappingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::MappingFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoServiceProvider_MappingFeature_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]))
        return QGeoServiceProvider_MappingFeature_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoServiceProvider::MappingFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::MappingFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_;
    return {};
}
static void QGeoServiceProvider_PlacesFeature_PythonToCpp_QGeoServiceProvider_PlacesFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::PlacesFeature *>(cppOut) =
        static_cast<::QGeoServiceProvider::PlacesFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_PlacesFeature_PythonToCpp_QGeoServiceProvider_PlacesFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]))
        return QGeoServiceProvider_PlacesFeature_PythonToCpp_QGeoServiceProvider_PlacesFeature;
    return {};
}
static PyObject *QGeoServiceProvider_PlacesFeature_CppToPython_QGeoServiceProvider_PlacesFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::PlacesFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoServiceProvider_PlacesFeature__PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::PlacesFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::PlacesFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoServiceProvider_PlacesFeature__PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]))
        return QFlags_QGeoServiceProvider_PlacesFeature__PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_;
    return {};
}
static PyObject *QFlags_QGeoServiceProvider_PlacesFeature__CppToPython_QFlags_QGeoServiceProvider_PlacesFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoServiceProvider::PlacesFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]));

}

static void QGeoServiceProvider_PlacesFeature_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::PlacesFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::PlacesFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoServiceProvider_PlacesFeature_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]))
        return QGeoServiceProvider_PlacesFeature_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoServiceProvider::PlacesFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::PlacesFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_;
    return {};
}
static void QGeoServiceProvider_NavigationFeature_PythonToCpp_QGeoServiceProvider_NavigationFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoServiceProvider::NavigationFeature *>(cppOut) =
        static_cast<::QGeoServiceProvider::NavigationFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoServiceProvider_NavigationFeature_PythonToCpp_QGeoServiceProvider_NavigationFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]))
        return QGeoServiceProvider_NavigationFeature_PythonToCpp_QGeoServiceProvider_NavigationFeature;
    return {};
}
static PyObject *QGeoServiceProvider_NavigationFeature_CppToPython_QGeoServiceProvider_NavigationFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoServiceProvider::NavigationFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX], castCppIn);

}

static void QFlags_QGeoServiceProvider_NavigationFeature__PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::NavigationFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::NavigationFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGeoServiceProvider_NavigationFeature__PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]))
        return QFlags_QGeoServiceProvider_NavigationFeature__PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_;
    return {};
}
static PyObject *QFlags_QGeoServiceProvider_NavigationFeature__CppToPython_QFlags_QGeoServiceProvider_NavigationFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGeoServiceProvider::NavigationFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]));

}

static void QGeoServiceProvider_NavigationFeature_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGeoServiceProvider::NavigationFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::NavigationFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGeoServiceProvider_NavigationFeature_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]))
        return QGeoServiceProvider_NavigationFeature_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGeoServiceProvider::NavigationFeature> *>(cppOut) =
        ::QFlags<QGeoServiceProvider::NavigationFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoServiceProvider_PythonToCpp_QGeoServiceProvider_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoServiceProvider_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoServiceProvider_PythonToCpp_QGeoServiceProvider_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProvider_TypeF())))
        return QGeoServiceProvider_PythonToCpp_QGeoServiceProvider_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoServiceProvider_PTR_CppToPython_QGeoServiceProvider(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoServiceProvider *>(const_cast<void *>(cppIn)), Sbk_QGeoServiceProvider_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoServiceProvider_SignatureStrings[] = {
    "PySide2.QtLocation.QGeoServiceProvider(self,providerName:QString,parameters:QMap[QString, QVariant]=QVariantMap(),allowExperimental:bool=false)",
    "PySide2.QtLocation.QGeoServiceProvider.availableServiceProviders()->QStringList",
    "PySide2.QtLocation.QGeoServiceProvider.error(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.errorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.geocodingError(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.geocodingErrorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.geocodingFeatures(self)->PySide2.QtLocation.QGeoServiceProvider.GeocodingFeatures",
    "PySide2.QtLocation.QGeoServiceProvider.geocodingManager(self)->PySide2.QtLocation.QGeoCodingManager",
    "PySide2.QtLocation.QGeoServiceProvider.mappingError(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.mappingErrorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.mappingFeatures(self)->PySide2.QtLocation.QGeoServiceProvider.MappingFeatures",
    "PySide2.QtLocation.QGeoServiceProvider.navigationError(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.navigationErrorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.navigationFeatures(self)->PySide2.QtLocation.QGeoServiceProvider.NavigationFeatures",
    "PySide2.QtLocation.QGeoServiceProvider.placeManager(self)->PySide2.QtLocation.QPlaceManager",
    "PySide2.QtLocation.QGeoServiceProvider.placesError(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.placesErrorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.placesFeatures(self)->PySide2.QtLocation.QGeoServiceProvider.PlacesFeatures",
    "PySide2.QtLocation.QGeoServiceProvider.routingError(self)->PySide2.QtLocation.QGeoServiceProvider.Error",
    "PySide2.QtLocation.QGeoServiceProvider.routingErrorString(self)->QString",
    "PySide2.QtLocation.QGeoServiceProvider.routingFeatures(self)->PySide2.QtLocation.QGeoServiceProvider.RoutingFeatures",
    "PySide2.QtLocation.QGeoServiceProvider.routingManager(self)->PySide2.QtLocation.QGeoRoutingManager",
    "PySide2.QtLocation.QGeoServiceProvider.setAllowExperimental(self,allow:bool)",
    "PySide2.QtLocation.QGeoServiceProvider.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtLocation.QGeoServiceProvider.setParameters(self,parameters:QMap[QString, QVariant])",
    nullptr}; // Sentinel

void init_QGeoServiceProvider(PyObject *module)
{
    _Sbk_QGeoServiceProvider_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoServiceProvider",
        "QGeoServiceProvider*",
        &Sbk_QGeoServiceProvider_spec,
        &Shiboken::callCppDestructor< ::QGeoServiceProvider >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProvider_Type);
    InitSignatureStrings(pyType, QGeoServiceProvider_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProvider_Type), Sbk_QGeoServiceProvider_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProvider_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoServiceProvider_TypeF(),
        QGeoServiceProvider_PythonToCpp_QGeoServiceProvider_PTR,
        is_QGeoServiceProvider_PythonToCpp_QGeoServiceProvider_PTR_Convertible,
        QGeoServiceProvider_PTR_CppToPython_QGeoServiceProvider);

    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProvider).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProviderWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoServiceProvider_TypeF(), &Sbk_QGeoServiceProvider_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "Error",
        "2:PySide2.QtLocation.QGeoServiceProvider.Error",
        "QGeoServiceProvider::Error");
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoError", (long) QGeoServiceProvider::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NotSupportedError", (long) QGeoServiceProvider::Error::NotSupportedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "UnknownParameterError", (long) QGeoServiceProvider::Error::UnknownParameterError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "MissingRequiredParameterError", (long) QGeoServiceProvider::Error::MissingRequiredParameterError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "ConnectionError", (long) QGeoServiceProvider::Error::ConnectionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "LoaderError", (long) QGeoServiceProvider::Error::LoaderError))
        return;
    // Register converter for enum 'QGeoServiceProvider::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX],
            QGeoServiceProvider_Error_CppToPython_QGeoServiceProvider_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_Error_PythonToCpp_QGeoServiceProvider_Error,
            is_QGeoServiceProvider_Error_PythonToCpp_QGeoServiceProvider_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'RoutingFeature'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoServiceProvider.RoutingFeatures", SbkPySide2_QtLocation_QGeoServiceProvider_RoutingFeature_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "RoutingFeature",
        "2:PySide2.QtLocation.QGeoServiceProvider.RoutingFeature",
        "QGeoServiceProvider::RoutingFeature",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoRoutingFeatures", (long) QGeoServiceProvider::RoutingFeature::NoRoutingFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OnlineRoutingFeature", (long) QGeoServiceProvider::RoutingFeature::OnlineRoutingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OfflineRoutingFeature", (long) QGeoServiceProvider::RoutingFeature::OfflineRoutingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "LocalizedRoutingFeature", (long) QGeoServiceProvider::RoutingFeature::LocalizedRoutingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "RouteUpdatesFeature", (long) QGeoServiceProvider::RoutingFeature::RouteUpdatesFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AlternativeRoutesFeature", (long) QGeoServiceProvider::RoutingFeature::AlternativeRoutesFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "ExcludeAreasRoutingFeature", (long) QGeoServiceProvider::RoutingFeature::ExcludeAreasRoutingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AnyRoutingFeatures", (long) QGeoServiceProvider::RoutingFeature::AnyRoutingFeatures))
        return;
    // Register converter for enum 'QGeoServiceProvider::RoutingFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
            QGeoServiceProvider_RoutingFeature_CppToPython_QGeoServiceProvider_RoutingFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_RoutingFeature_PythonToCpp_QGeoServiceProvider_RoutingFeature,
            is_QGeoServiceProvider_RoutingFeature_PythonToCpp_QGeoServiceProvider_RoutingFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::RoutingFeature");
        Shiboken::Conversions::registerConverterName(converter, "RoutingFeature");
    }
    // Register converter for flag 'QFlags<QGeoServiceProvider::RoutingFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX],
            QFlags_QGeoServiceProvider_RoutingFeature__CppToPython_QFlags_QGeoServiceProvider_RoutingFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_RoutingFeature_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_,
            is_QGeoServiceProvider_RoutingFeature_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoServiceProvider_RoutingFeature__PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_,
            is_QFlags_QGeoServiceProvider_RoutingFeature__PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature_,
            is_number_PythonToCpp_QFlags_QGeoServiceProvider_RoutingFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_ROUTINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::RoutingFeatures");
        Shiboken::Conversions::registerConverterName(converter, "RoutingFeatures");
    }
    // End of 'RoutingFeature' enum/flags.

    // Initialization of enum 'GeocodingFeature'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoServiceProvider.GeocodingFeatures", SbkPySide2_QtLocation_QGeoServiceProvider_GeocodingFeature_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "GeocodingFeature",
        "2:PySide2.QtLocation.QGeoServiceProvider.GeocodingFeature",
        "QGeoServiceProvider::GeocodingFeature",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoGeocodingFeatures", (long) QGeoServiceProvider::GeocodingFeature::NoGeocodingFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OnlineGeocodingFeature", (long) QGeoServiceProvider::GeocodingFeature::OnlineGeocodingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OfflineGeocodingFeature", (long) QGeoServiceProvider::GeocodingFeature::OfflineGeocodingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "ReverseGeocodingFeature", (long) QGeoServiceProvider::GeocodingFeature::ReverseGeocodingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "LocalizedGeocodingFeature", (long) QGeoServiceProvider::GeocodingFeature::LocalizedGeocodingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AnyGeocodingFeatures", (long) QGeoServiceProvider::GeocodingFeature::AnyGeocodingFeatures))
        return;
    // Register converter for enum 'QGeoServiceProvider::GeocodingFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
            QGeoServiceProvider_GeocodingFeature_CppToPython_QGeoServiceProvider_GeocodingFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_GeocodingFeature_PythonToCpp_QGeoServiceProvider_GeocodingFeature,
            is_QGeoServiceProvider_GeocodingFeature_PythonToCpp_QGeoServiceProvider_GeocodingFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::GeocodingFeature");
        Shiboken::Conversions::registerConverterName(converter, "GeocodingFeature");
    }
    // Register converter for flag 'QFlags<QGeoServiceProvider::GeocodingFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX],
            QFlags_QGeoServiceProvider_GeocodingFeature__CppToPython_QFlags_QGeoServiceProvider_GeocodingFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_GeocodingFeature_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_,
            is_QGeoServiceProvider_GeocodingFeature_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoServiceProvider_GeocodingFeature__PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_,
            is_QFlags_QGeoServiceProvider_GeocodingFeature__PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature_,
            is_number_PythonToCpp_QFlags_QGeoServiceProvider_GeocodingFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_GEOCODINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::GeocodingFeatures");
        Shiboken::Conversions::registerConverterName(converter, "GeocodingFeatures");
    }
    // End of 'GeocodingFeature' enum/flags.

    // Initialization of enum 'MappingFeature'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoServiceProvider.MappingFeatures", SbkPySide2_QtLocation_QGeoServiceProvider_MappingFeature_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "MappingFeature",
        "2:PySide2.QtLocation.QGeoServiceProvider.MappingFeature",
        "QGeoServiceProvider::MappingFeature",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoMappingFeatures", (long) QGeoServiceProvider::MappingFeature::NoMappingFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OnlineMappingFeature", (long) QGeoServiceProvider::MappingFeature::OnlineMappingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OfflineMappingFeature", (long) QGeoServiceProvider::MappingFeature::OfflineMappingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "LocalizedMappingFeature", (long) QGeoServiceProvider::MappingFeature::LocalizedMappingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AnyMappingFeatures", (long) QGeoServiceProvider::MappingFeature::AnyMappingFeatures))
        return;
    // Register converter for enum 'QGeoServiceProvider::MappingFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
            QGeoServiceProvider_MappingFeature_CppToPython_QGeoServiceProvider_MappingFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_MappingFeature_PythonToCpp_QGeoServiceProvider_MappingFeature,
            is_QGeoServiceProvider_MappingFeature_PythonToCpp_QGeoServiceProvider_MappingFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::MappingFeature");
        Shiboken::Conversions::registerConverterName(converter, "MappingFeature");
    }
    // Register converter for flag 'QFlags<QGeoServiceProvider::MappingFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX],
            QFlags_QGeoServiceProvider_MappingFeature__CppToPython_QFlags_QGeoServiceProvider_MappingFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_MappingFeature_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_,
            is_QGeoServiceProvider_MappingFeature_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoServiceProvider_MappingFeature__PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_,
            is_QFlags_QGeoServiceProvider_MappingFeature__PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature_,
            is_number_PythonToCpp_QFlags_QGeoServiceProvider_MappingFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_MAPPINGFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::MappingFeatures");
        Shiboken::Conversions::registerConverterName(converter, "MappingFeatures");
    }
    // End of 'MappingFeature' enum/flags.

    // Initialization of enum 'PlacesFeature'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoServiceProvider.PlacesFeatures", SbkPySide2_QtLocation_QGeoServiceProvider_PlacesFeature_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "PlacesFeature",
        "2:PySide2.QtLocation.QGeoServiceProvider.PlacesFeature",
        "QGeoServiceProvider::PlacesFeature",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoPlacesFeatures", (long) QGeoServiceProvider::PlacesFeature::NoPlacesFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OnlinePlacesFeature", (long) QGeoServiceProvider::PlacesFeature::OnlinePlacesFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OfflinePlacesFeature", (long) QGeoServiceProvider::PlacesFeature::OfflinePlacesFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "SavePlaceFeature", (long) QGeoServiceProvider::PlacesFeature::SavePlaceFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "RemovePlaceFeature", (long) QGeoServiceProvider::PlacesFeature::RemovePlaceFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "SaveCategoryFeature", (long) QGeoServiceProvider::PlacesFeature::SaveCategoryFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "RemoveCategoryFeature", (long) QGeoServiceProvider::PlacesFeature::RemoveCategoryFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "PlaceRecommendationsFeature", (long) QGeoServiceProvider::PlacesFeature::PlaceRecommendationsFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "SearchSuggestionsFeature", (long) QGeoServiceProvider::PlacesFeature::SearchSuggestionsFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "LocalizedPlacesFeature", (long) QGeoServiceProvider::PlacesFeature::LocalizedPlacesFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NotificationsFeature", (long) QGeoServiceProvider::PlacesFeature::NotificationsFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "PlaceMatchingFeature", (long) QGeoServiceProvider::PlacesFeature::PlaceMatchingFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AnyPlacesFeatures", (long) QGeoServiceProvider::PlacesFeature::AnyPlacesFeatures))
        return;
    // Register converter for enum 'QGeoServiceProvider::PlacesFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
            QGeoServiceProvider_PlacesFeature_CppToPython_QGeoServiceProvider_PlacesFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_PlacesFeature_PythonToCpp_QGeoServiceProvider_PlacesFeature,
            is_QGeoServiceProvider_PlacesFeature_PythonToCpp_QGeoServiceProvider_PlacesFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::PlacesFeature");
        Shiboken::Conversions::registerConverterName(converter, "PlacesFeature");
    }
    // Register converter for flag 'QFlags<QGeoServiceProvider::PlacesFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX],
            QFlags_QGeoServiceProvider_PlacesFeature__CppToPython_QFlags_QGeoServiceProvider_PlacesFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_PlacesFeature_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_,
            is_QGeoServiceProvider_PlacesFeature_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoServiceProvider_PlacesFeature__PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_,
            is_QFlags_QGeoServiceProvider_PlacesFeature__PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature_,
            is_number_PythonToCpp_QFlags_QGeoServiceProvider_PlacesFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_PLACESFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::PlacesFeatures");
        Shiboken::Conversions::registerConverterName(converter, "PlacesFeatures");
    }
    // End of 'PlacesFeature' enum/flags.

    // Initialization of enum 'NavigationFeature'.
    SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtLocation.QGeoServiceProvider.NavigationFeatures", SbkPySide2_QtLocation_QGeoServiceProvider_NavigationFeature_number_slots);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoServiceProvider_TypeF(),
        "NavigationFeature",
        "2:PySide2.QtLocation.QGeoServiceProvider.NavigationFeature",
        "QGeoServiceProvider::NavigationFeature",
        SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX]);
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "NoNavigationFeatures", (long) QGeoServiceProvider::NavigationFeature::NoNavigationFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OnlineNavigationFeature", (long) QGeoServiceProvider::NavigationFeature::OnlineNavigationFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "OfflineNavigationFeature", (long) QGeoServiceProvider::NavigationFeature::OfflineNavigationFeature))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
        Sbk_QGeoServiceProvider_TypeF(), "AnyNavigationFeatures", (long) QGeoServiceProvider::NavigationFeature::AnyNavigationFeatures))
        return;
    // Register converter for enum 'QGeoServiceProvider::NavigationFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
            QGeoServiceProvider_NavigationFeature_CppToPython_QGeoServiceProvider_NavigationFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_NavigationFeature_PythonToCpp_QGeoServiceProvider_NavigationFeature,
            is_QGeoServiceProvider_NavigationFeature_PythonToCpp_QGeoServiceProvider_NavigationFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::NavigationFeature");
        Shiboken::Conversions::registerConverterName(converter, "NavigationFeature");
    }
    // Register converter for flag 'QFlags<QGeoServiceProvider::NavigationFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX],
            QFlags_QGeoServiceProvider_NavigationFeature__CppToPython_QFlags_QGeoServiceProvider_NavigationFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoServiceProvider_NavigationFeature_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_,
            is_QGeoServiceProvider_NavigationFeature_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGeoServiceProvider_NavigationFeature__PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_,
            is_QFlags_QGeoServiceProvider_NavigationFeature__PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature_,
            is_number_PythonToCpp_QFlags_QGeoServiceProvider_NavigationFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOSERVICEPROVIDER_NAVIGATIONFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProvider::NavigationFeatures");
        Shiboken::Conversions::registerConverterName(converter, "NavigationFeatures");
    }
    // End of 'NavigationFeature' enum/flags.

    PySide::Signal::registerSignals(Sbk_QGeoServiceProvider_TypeF(), &::QGeoServiceProvider::staticMetaObject);
    qRegisterMetaType< ::QGeoServiceProvider::Error >("QGeoServiceProvider::Error");
    qRegisterMetaType< ::QGeoServiceProvider::RoutingFeature >("QGeoServiceProvider::RoutingFeature");
    qRegisterMetaType< ::QGeoServiceProvider::RoutingFeatures >("QGeoServiceProvider::RoutingFeatures");
    qRegisterMetaType< ::QGeoServiceProvider::GeocodingFeature >("QGeoServiceProvider::GeocodingFeature");
    qRegisterMetaType< ::QGeoServiceProvider::GeocodingFeatures >("QGeoServiceProvider::GeocodingFeatures");
    qRegisterMetaType< ::QGeoServiceProvider::MappingFeature >("QGeoServiceProvider::MappingFeature");
    qRegisterMetaType< ::QGeoServiceProvider::MappingFeatures >("QGeoServiceProvider::MappingFeatures");
    qRegisterMetaType< ::QGeoServiceProvider::PlacesFeature >("QGeoServiceProvider::PlacesFeature");
    qRegisterMetaType< ::QGeoServiceProvider::PlacesFeatures >("QGeoServiceProvider::PlacesFeatures");
    qRegisterMetaType< ::QGeoServiceProvider::NavigationFeature >("QGeoServiceProvider::NavigationFeature");
    qRegisterMetaType< ::QGeoServiceProvider::NavigationFeatures >("QGeoServiceProvider::NavigationFeatures");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoServiceProvider_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoServiceProvider_TypeF(), &::QGeoServiceProvider::staticMetaObject, sizeof(QGeoServiceProviderWrapper));
}
