/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeoserviceproviderfactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoServiceProviderFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoServiceProviderFactoryWrapper::QGeoServiceProviderFactoryWrapper() : QGeoServiceProviderFactory()
{
    resetPyMethodCache();
    // ... middle
}

::QGeoCodingManagerEngine * QGeoServiceProviderFactoryWrapper::createGeocodingManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[0])
        return this->::QGeoServiceProviderFactory::createGeocodingManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createGeocodingManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGeoServiceProviderFactory::createGeocodingManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOCODINGMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactory.createGeocodingManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoCodingManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoCodingManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPlaceManagerEngine * QGeoServiceProviderFactoryWrapper::createPlaceManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[1])
        return this->::QGeoServiceProviderFactory::createPlaceManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createPlaceManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGeoServiceProviderFactory::createPlaceManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactory.createPlaceManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPlaceManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPlaceManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QGeoRoutingManagerEngine * QGeoServiceProviderFactoryWrapper::createRoutingManagerEngine(const ::QMap<QString,QVariant > & parameters, ::QGeoServiceProvider::Error * error, ::QString * errorString) const
{
    if (m_PyMethodCache[2])
        return this->::QGeoServiceProviderFactory::createRoutingManagerEngine(parameters, error, errorString);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createRoutingManagerEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGeoServiceProviderFactory::createRoutingManagerEngine(parameters, error, errorString);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], &parameters),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, &error),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &errorString)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoServiceProviderFactory.createRoutingManagerEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoRoutingManagerEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoRoutingManagerEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QGeoServiceProviderFactoryWrapper::~QGeoServiceProviderFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoServiceProviderFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoServiceProviderFactory >()))
        return -1;

    ::QGeoServiceProviderFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProviderFactory.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QGeoServiceProviderFactory()
            cptr = new ::QGeoServiceProviderFactoryWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoServiceProviderFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QGeoServiceProviderFactoryFunc_createGeocodingManagerEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProviderFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProviderFactory.createGeocodingManagerEngine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createGeocodingManagerEngine", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGeoServiceProviderFactory::createGeocodingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // createGeocodingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFactoryFunc_createGeocodingManagerEngine_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QGeoServiceProvider::Error *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createGeocodingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
            QGeoCodingManagerEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->::QGeoServiceProviderFactory::createGeocodingManagerEngine(cppArg0, cppArg1, cppArg2)
                : const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->createGeocodingManagerEngine(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOCODINGMANAGERENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoServiceProviderFactoryFunc_createGeocodingManagerEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoServiceProviderFactoryFunc_createPlaceManagerEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProviderFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProviderFactory.createPlaceManagerEngine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createPlaceManagerEngine", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGeoServiceProviderFactory::createPlaceManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // createPlaceManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFactoryFunc_createPlaceManagerEngine_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QGeoServiceProvider::Error *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createPlaceManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
            QPlaceManagerEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->::QGeoServiceProviderFactory::createPlaceManagerEngine(cppArg0, cppArg1, cppArg2)
                : const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->createPlaceManagerEngine(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEMANAGERENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoServiceProviderFactoryFunc_createPlaceManagerEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoServiceProviderFactoryFunc_createRoutingManagerEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoServiceProviderFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoServiceProviderFactory.createRoutingManagerEngine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createRoutingManagerEngine", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGeoServiceProviderFactory::createRoutingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDER_ERROR_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        overloadId = 0; // createRoutingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoServiceProviderFactoryFunc_createRoutingManagerEngine_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QGeoServiceProvider::Error *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createRoutingManagerEngine(QMap<QString,QVariant>,QGeoServiceProvider::Error*,QString*)const
            QGeoRoutingManagerEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->::QGeoServiceProviderFactory::createRoutingManagerEngine(cppArg0, cppArg1, cppArg2)
                : const_cast<const ::QGeoServiceProviderFactory *>(cppSelf)->createRoutingManagerEngine(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoServiceProviderFactoryFunc_createRoutingManagerEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGeoServiceProviderFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoServiceProviderFactory_methods[] = {
    {"createGeocodingManagerEngine", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFactoryFunc_createGeocodingManagerEngine), METH_VARARGS},
    {"createPlaceManagerEngine", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFactoryFunc_createPlaceManagerEngine), METH_VARARGS},
    {"createRoutingManagerEngine", reinterpret_cast<PyCFunction>(Sbk_QGeoServiceProviderFactoryFunc_createRoutingManagerEngine), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoServiceProviderFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoServiceProviderFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoServiceProviderFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoServiceProviderFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoServiceProviderFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoServiceProviderFactory_Type = nullptr;
static SbkObjectType *Sbk_QGeoServiceProviderFactory_TypeF(void)
{
    return _Sbk_QGeoServiceProviderFactory_Type;
}

static PyType_Slot Sbk_QGeoServiceProviderFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoServiceProviderFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoServiceProviderFactory_spec = {
    "2:PySide2.QtLocation.QGeoServiceProviderFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoServiceProviderFactory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoServiceProviderFactory_PythonToCpp_QGeoServiceProviderFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoServiceProviderFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoServiceProviderFactory_PythonToCpp_QGeoServiceProviderFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProviderFactory_TypeF())))
        return QGeoServiceProviderFactory_PythonToCpp_QGeoServiceProviderFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoServiceProviderFactory_PTR_CppToPython_QGeoServiceProviderFactory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoServiceProviderFactory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoServiceProviderFactory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoServiceProviderFactory_SignatureStrings[] = {
    "PySide2.QtLocation.QGeoServiceProviderFactory(self)",
    "PySide2.QtLocation.QGeoServiceProviderFactory.createGeocodingManagerEngine(self,parameters:QMap[QString, QVariant],error:PySide2.QtLocation.QGeoServiceProvider.Error,errorString:QString*)->PySide2.QtLocation.QGeoCodingManagerEngine",
    "PySide2.QtLocation.QGeoServiceProviderFactory.createPlaceManagerEngine(self,parameters:QMap[QString, QVariant],error:PySide2.QtLocation.QGeoServiceProvider.Error,errorString:QString*)->PySide2.QtLocation.QPlaceManagerEngine",
    "PySide2.QtLocation.QGeoServiceProviderFactory.createRoutingManagerEngine(self,parameters:QMap[QString, QVariant],error:PySide2.QtLocation.QGeoServiceProvider.Error,errorString:QString*)->PySide2.QtLocation.QGeoRoutingManagerEngine",
    nullptr}; // Sentinel

void init_QGeoServiceProviderFactory(PyObject *module)
{
    _Sbk_QGeoServiceProviderFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoServiceProviderFactory",
        "QGeoServiceProviderFactory*",
        &Sbk_QGeoServiceProviderFactory_spec,
        &Shiboken::callCppDestructor< ::QGeoServiceProviderFactory >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProviderFactory_Type);
    InitSignatureStrings(pyType, QGeoServiceProviderFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoServiceProviderFactory_Type), Sbk_QGeoServiceProviderFactory_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOSERVICEPROVIDERFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoServiceProviderFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoServiceProviderFactory_TypeF(),
        QGeoServiceProviderFactory_PythonToCpp_QGeoServiceProviderFactory_PTR,
        is_QGeoServiceProviderFactory_PythonToCpp_QGeoServiceProviderFactory_PTR_Convertible,
        QGeoServiceProviderFactory_PTR_CppToPython_QGeoServiceProviderFactory);

    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactory");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoServiceProviderFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProviderFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoServiceProviderFactoryWrapper).name());


}
