/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplaceattribute_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPlaceAttributeWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPlaceAttributeWrapper::QPlaceAttributeWrapper() : QPlaceAttribute()
{
    resetPyMethodCache();
    // ... middle
}

QPlaceAttributeWrapper::~QPlaceAttributeWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceAttribute_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceAttribute >()))
        return -1;

    ::QPlaceAttributeWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceAttribute", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceAttribute::QPlaceAttribute()
    // 1: QPlaceAttribute::QPlaceAttribute(QPlaceAttribute)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceAttribute()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceAttribute(QPlaceAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceAttribute_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceAttribute()
        {

            if (!PyErr_Occurred()) {
                // QPlaceAttribute()
                cptr = new ::QPlaceAttributeWrapper();
            }
            break;
        }
        case 1: // QPlaceAttribute(const QPlaceAttribute & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceAttribute cppArg0_local;
            ::QPlaceAttribute *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPlaceAttribute(QPlaceAttribute)
                cptr = new ::QPlaceAttributeWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceAttribute >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceAttribute_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceAttribute_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceAttributeFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QPlaceAttribute *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceAttributeFunc_label(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.label";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // label()const
            QString cppResult = const_cast<const ::QPlaceAttribute *>(cppSelf)->label();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceAttributeFunc_setLabel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.setLabel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceAttribute::setLabel(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setLabel(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceAttributeFunc_setLabel_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLabel(QString)
            cppSelf->setLabel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceAttributeFunc_setLabel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceAttributeFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceAttribute::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceAttributeFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceAttributeFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceAttributeFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceAttribute.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QPlaceAttribute *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceAttribute___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPlaceAttribute_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceAttribute_methods[] = {
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttributeFunc_isEmpty), METH_NOARGS},
    {"label", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttributeFunc_label), METH_NOARGS},
    {"setLabel", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttributeFunc_setLabel), METH_O},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttributeFunc_setText), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttributeFunc_text), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPlaceAttribute___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPlaceAttribute_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPlaceAttributeWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

// Rich comparison
static PyObject * Sbk_QPlaceAttribute_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), (pyArg)))) {
                // operator!=(const QPlaceAttribute & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceAttribute cppArg0_local;
                ::QPlaceAttribute *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), (pyArg)))) {
                // operator==(const QPlaceAttribute & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceAttribute cppArg0_local;
                ::QPlaceAttribute *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPlaceAttribute_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPlaceAttribute_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPlaceAttribute_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceAttribute_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceAttribute_Type = nullptr;
static SbkObjectType *Sbk_QPlaceAttribute_TypeF(void)
{
    return _Sbk_QPlaceAttribute_Type;
}

static PyType_Slot Sbk_QPlaceAttribute_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPlaceAttribute_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceAttribute_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceAttribute_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPlaceAttribute_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceAttribute_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceAttribute_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceAttribute_spec = {
    "2:PySide2.QtLocation.QPlaceAttribute",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceAttribute_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceAttribute_PythonToCpp_QPlaceAttribute_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceAttribute_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceAttribute_PythonToCpp_QPlaceAttribute_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceAttribute_TypeF())))
        return QPlaceAttribute_PythonToCpp_QPlaceAttribute_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceAttribute_PTR_CppToPython_QPlaceAttribute(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceAttribute *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceAttribute_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPlaceAttribute_COPY_CppToPython_QPlaceAttribute(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPlaceAttribute_TypeF(), new ::QPlaceAttributeWrapper(*reinterpret_cast<const ::QPlaceAttribute *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPlaceAttribute_PythonToCpp_QPlaceAttribute_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPlaceAttribute *>(cppOut) = *reinterpret_cast< ::QPlaceAttribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPlaceAttribute_PythonToCpp_QPlaceAttribute_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceAttribute_TypeF())))
        return QPlaceAttribute_PythonToCpp_QPlaceAttribute_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceAttribute_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceAttribute(self)",
    "0:PySide2.QtLocation.QPlaceAttribute(self,other:PySide2.QtLocation.QPlaceAttribute)",
    "PySide2.QtLocation.QPlaceAttribute.isEmpty(self)->bool",
    "PySide2.QtLocation.QPlaceAttribute.label(self)->QString",
    "PySide2.QtLocation.QPlaceAttribute.setLabel(self,label:QString)",
    "PySide2.QtLocation.QPlaceAttribute.setText(self,text:QString)",
    "PySide2.QtLocation.QPlaceAttribute.text(self)->QString",
    "PySide2.QtLocation.QPlaceAttribute.__copy__()",
    nullptr}; // Sentinel

void init_QPlaceAttribute(PyObject *module)
{
    _Sbk_QPlaceAttribute_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceAttribute",
        "QPlaceAttribute",
        &Sbk_QPlaceAttribute_spec,
        &Shiboken::callCppDestructor< ::QPlaceAttributeWrapper >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceAttribute_Type);
    InitSignatureStrings(pyType, QPlaceAttribute_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceAttribute_Type), Sbk_QPlaceAttribute_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACEATTRIBUTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceAttribute_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceAttribute_TypeF(),
        QPlaceAttribute_PythonToCpp_QPlaceAttribute_PTR,
        is_QPlaceAttribute_PythonToCpp_QPlaceAttribute_PTR_Convertible,
        QPlaceAttribute_PTR_CppToPython_QPlaceAttribute,
        QPlaceAttribute_COPY_CppToPython_QPlaceAttribute);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceAttribute");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceAttribute*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceAttribute&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceAttribute).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceAttributeWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPlaceAttribute_PythonToCpp_QPlaceAttribute_COPY,
        is_QPlaceAttribute_PythonToCpp_QPlaceAttribute_COPY_Convertible);

    qRegisterMetaType< ::QPlaceAttribute >("QPlaceAttribute");
}

void init_QPlaceAttributeStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceAttribute_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "OpeningHours",
                         Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &QPlaceAttribute::OpeningHours));
    PyDict_SetItemString(dict, "Payment",
                         Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &QPlaceAttribute::Payment));
    PyDict_SetItemString(dict, "Provider",
                         Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &QPlaceAttribute::Provider));

}
