/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudiorolecontrol_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAudioRoleControlWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAudioRoleControlWrapper::QAudioRoleControlWrapper(::QObject * parent) : QAudioRoleControl(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QAudio::Role QAudioRoleControlWrapper::audioRole() const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.audioRole()' not implemented.");
        return QAudio::UnknownRole;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QAudio::UnknownRole;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "audioRole";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.audioRole()' not implemented.");
        return QAudio::UnknownRole;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QAudio::UnknownRole;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAudioRoleControl.audioRole", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QAudio::Role >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QAudio::UnknownRole;
    }
    ::QAudio::Role cppResult{QAudio::UnknownRole};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAudioRoleControlWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAudioRoleControlWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAudioRoleControlWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAudioRoleControlWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QAudioRoleControlWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAudioRoleControl.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAudioRoleControlWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAudioRoleControl.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QAudioRoleControlWrapper::setAudioRole(::QAudio::Role role)
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.setAudioRole()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setAudioRole";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.setAudioRole()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, &role)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QList<QAudio::Role > QAudioRoleControlWrapper::supportedAudioRoles() const
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.supportedAudioRoles()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportedAudioRoles";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.supportedAudioRoles()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAudioRoleControl.supportedAudioRoles", "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QAudio::Role > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAudioRoleControlWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAudioRoleControlWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAudioRoleControl::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAudioRoleControlWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAudioRoleControl::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAudioRoleControlWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAudioRoleControlWrapper *>(this));
        return QAudioRoleControl::qt_metacast(_clname);
}

QAudioRoleControlWrapper::~QAudioRoleControlWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAudioRoleControl_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QAudioRoleControl' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAudioRoleControl >()))
        return -1;

    ::QAudioRoleControlWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioRoleControl.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QAudioRoleControl", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAudioRoleControl::QAudioRoleControl(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QAudioRoleControl(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QAudioRoleControl(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioRoleControl_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAudioRoleControl_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QAudioRoleControl_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QAudioRoleControl(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAudioRoleControlWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAudioRoleControlWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAudioRoleControl >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAudioRoleControl_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAudioRoleControl_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAudioRoleControl_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAudioRoleControlFunc_audioRole(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioRoleControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioRoleControl.audioRole";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // audioRole()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.audioRole()' not implemented.");
                return {};
            }
            QAudio::Role cppResult = const_cast<const ::QAudioRoleControl *>(cppSelf)->audioRole();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioRoleControlFunc_setAudioRole(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioRoleControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioRoleControl.setAudioRole";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioRoleControl::setAudioRole(QAudio::Role)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAudioRole(QAudio::Role)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioRoleControlFunc_setAudioRole_TypeError;

    // Call function/method
    {
        ::QAudio::Role cppArg0{QAudio::UnknownRole};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAudioRole(QAudio::Role)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.setAudioRole()' not implemented.");
                return {};
            }
            cppSelf->setAudioRole(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioRoleControlFunc_setAudioRole_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioRoleControlFunc_supportedAudioRoles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioRoleControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioRoleControl.supportedAudioRoles";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedAudioRoles()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QAudioRoleControl.supportedAudioRoles()' not implemented.");
                return {};
            }
            QList<QAudio::Role > cppResult = const_cast<const ::QAudioRoleControl *>(cppSelf)->supportedAudioRoles();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAudioRoleControl_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudioRoleControl_methods[] = {
    {"audioRole", reinterpret_cast<PyCFunction>(Sbk_QAudioRoleControlFunc_audioRole), METH_NOARGS},
    {"setAudioRole", reinterpret_cast<PyCFunction>(Sbk_QAudioRoleControlFunc_setAudioRole), METH_O},
    {"supportedAudioRoles", reinterpret_cast<PyCFunction>(Sbk_QAudioRoleControlFunc_supportedAudioRoles), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAudioRoleControl_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAudioRoleControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAudioRoleControlWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAudioRoleControl_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudioRoleControl_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudioRoleControl_Type = nullptr;
static SbkObjectType *Sbk_QAudioRoleControl_TypeF(void)
{
    return _Sbk_QAudioRoleControl_Type;
}

static PyType_Slot Sbk_QAudioRoleControl_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAudioRoleControl_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudioRoleControl_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudioRoleControl_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudioRoleControl_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAudioRoleControl_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAudioRoleControl_spec = {
    "2:PySide2.QtMultimedia.QAudioRoleControl",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudioRoleControl_slots
};

} //extern "C"

static void *Sbk_QAudioRoleControl_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAudioRoleControl *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAudioRoleControl_PythonToCpp_QAudioRoleControl_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAudioRoleControl_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAudioRoleControl_PythonToCpp_QAudioRoleControl_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioRoleControl_TypeF())))
        return QAudioRoleControl_PythonToCpp_QAudioRoleControl_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAudioRoleControl_PTR_CppToPython_QAudioRoleControl(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAudioRoleControl *>(const_cast<void *>(cppIn)), Sbk_QAudioRoleControl_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAudioRoleControl_SignatureStrings[] = {
    "PySide2.QtMultimedia.QAudioRoleControl(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QAudioRoleControl.audioRole(self)->PySide2.QtMultimedia.QAudio.Role",
    "PySide2.QtMultimedia.QAudioRoleControl.setAudioRole(self,role:PySide2.QtMultimedia.QAudio.Role)",
    "PySide2.QtMultimedia.QAudioRoleControl.supportedAudioRoles(self)->QList[PySide2.QtMultimedia.QAudio.Role]",
    nullptr}; // Sentinel

void init_QAudioRoleControl(PyObject *module)
{
    _Sbk_QAudioRoleControl_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudioRoleControl",
        "QAudioRoleControl*",
        &Sbk_QAudioRoleControl_spec,
        &Shiboken::callCppDestructor< ::QAudioRoleControl >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTROL_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudioRoleControl_Type);
    InitSignatureStrings(pyType, QAudioRoleControl_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudioRoleControl_Type), Sbk_QAudioRoleControl_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOROLECONTROL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudioRoleControl_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAudioRoleControl_TypeF(),
        QAudioRoleControl_PythonToCpp_QAudioRoleControl_PTR,
        is_QAudioRoleControl_PythonToCpp_QAudioRoleControl_PTR_Convertible,
        QAudioRoleControl_PTR_CppToPython_QAudioRoleControl);

    Shiboken::Conversions::registerConverterName(converter, "QAudioRoleControl");
    Shiboken::Conversions::registerConverterName(converter, "QAudioRoleControl*");
    Shiboken::Conversions::registerConverterName(converter, "QAudioRoleControl&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioRoleControl).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioRoleControlWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAudioRoleControl_TypeF(), &Sbk_QAudioRoleControl_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QAudioRoleControl_TypeF(), &::QAudioRoleControl::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAudioRoleControl_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAudioRoleControl_TypeF(), &::QAudioRoleControl::staticMetaObject, sizeof(QAudioRoleControlWrapper));
}
