/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediagaplessplaybackcontrol_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMediaGaplessPlaybackControlWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMediaGaplessPlaybackControlWrapper::QMediaGaplessPlaybackControlWrapper(::QObject * parent) : QMediaGaplessPlaybackControl(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QMediaGaplessPlaybackControlWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaGaplessPlaybackControlWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

qreal QMediaGaplessPlaybackControlWrapper::crossfadeTime() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.crossfadeTime()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "crossfadeTime";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.crossfadeTime()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaGaplessPlaybackControl.crossfadeTime", "qreal", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qreal cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QMediaGaplessPlaybackControlWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaGaplessPlaybackControlWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMediaGaplessPlaybackControlWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaGaplessPlaybackControl.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMediaGaplessPlaybackControlWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaGaplessPlaybackControl.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QMediaGaplessPlaybackControlWrapper::isCrossfadeSupported() const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.isCrossfadeSupported()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isCrossfadeSupported";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.isCrossfadeSupported()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaGaplessPlaybackControl.isCrossfadeSupported", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMediaContent QMediaGaplessPlaybackControlWrapper::nextMedia() const
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.nextMedia()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nextMedia";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.nextMedia()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaGaplessPlaybackControl.nextMedia", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaContent >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QMediaContent cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QMediaGaplessPlaybackControlWrapper::setCrossfadeTime(qreal crossfadeTime)
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setCrossfadeTime()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setCrossfadeTime";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setCrossfadeTime()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(d)",
    crossfadeTime
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMediaGaplessPlaybackControlWrapper::setNextMedia(const ::QMediaContent & media)
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setNextMedia()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setNextMedia";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setNextMedia()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &media)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMediaGaplessPlaybackControlWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QMediaGaplessPlaybackControlWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QMediaGaplessPlaybackControl::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMediaGaplessPlaybackControlWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QMediaGaplessPlaybackControl::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMediaGaplessPlaybackControlWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMediaGaplessPlaybackControlWrapper *>(this));
        return QMediaGaplessPlaybackControl::qt_metacast(_clname);
}

QMediaGaplessPlaybackControlWrapper::~QMediaGaplessPlaybackControlWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaGaplessPlaybackControl_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QMediaGaplessPlaybackControl' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaGaplessPlaybackControl >()))
        return -1;

    ::QMediaGaplessPlaybackControlWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QMediaGaplessPlaybackControl", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaGaplessPlaybackControl::QMediaGaplessPlaybackControl(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QMediaGaplessPlaybackControl(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QMediaGaplessPlaybackControl(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaGaplessPlaybackControl_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaGaplessPlaybackControl_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QMediaGaplessPlaybackControl_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QMediaGaplessPlaybackControl(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMediaGaplessPlaybackControlWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMediaGaplessPlaybackControlWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaGaplessPlaybackControl >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaGaplessPlaybackControl_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QMediaGaplessPlaybackControl_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QMediaGaplessPlaybackControl_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaGaplessPlaybackControlFunc_crossfadeTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.crossfadeTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // crossfadeTime()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.crossfadeTime()' not implemented.");
                return {};
            }
            qreal cppResult = const_cast<const ::QMediaGaplessPlaybackControl *>(cppSelf)->crossfadeTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaGaplessPlaybackControlFunc_isCrossfadeSupported(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.isCrossfadeSupported";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCrossfadeSupported()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.isCrossfadeSupported()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QMediaGaplessPlaybackControl *>(cppSelf)->isCrossfadeSupported();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaGaplessPlaybackControlFunc_nextMedia(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.nextMedia";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextMedia()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.nextMedia()' not implemented.");
                return {};
            }
            QMediaContent cppResult = const_cast<const ::QMediaGaplessPlaybackControl *>(cppSelf)->nextMedia();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaGaplessPlaybackControlFunc_setCrossfadeTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.setCrossfadeTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaGaplessPlaybackControl::setCrossfadeTime(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setCrossfadeTime(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaGaplessPlaybackControlFunc_setCrossfadeTime_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCrossfadeTime(qreal)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setCrossfadeTime()' not implemented.");
                return {};
            }
            cppSelf->setCrossfadeTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaGaplessPlaybackControlFunc_setCrossfadeTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaGaplessPlaybackControlFunc_setNextMedia(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.setNextMedia";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaGaplessPlaybackControl::setNextMedia(QMediaContent)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), (pyArg)))) {
        overloadId = 0; // setNextMedia(QMediaContent)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaGaplessPlaybackControlFunc_setNextMedia_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaContent cppArg0_local;
        ::QMediaContent *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNextMedia(QMediaContent)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QMediaGaplessPlaybackControl.setNextMedia()' not implemented.");
                return {};
            }
            cppSelf->setNextMedia(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaGaplessPlaybackControlFunc_setNextMedia_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QMediaGaplessPlaybackControl_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaGaplessPlaybackControl_methods[] = {
    {"crossfadeTime", reinterpret_cast<PyCFunction>(Sbk_QMediaGaplessPlaybackControlFunc_crossfadeTime), METH_NOARGS},
    {"isCrossfadeSupported", reinterpret_cast<PyCFunction>(Sbk_QMediaGaplessPlaybackControlFunc_isCrossfadeSupported), METH_NOARGS},
    {"nextMedia", reinterpret_cast<PyCFunction>(Sbk_QMediaGaplessPlaybackControlFunc_nextMedia), METH_NOARGS},
    {"setCrossfadeTime", reinterpret_cast<PyCFunction>(Sbk_QMediaGaplessPlaybackControlFunc_setCrossfadeTime), METH_O},
    {"setNextMedia", reinterpret_cast<PyCFunction>(Sbk_QMediaGaplessPlaybackControlFunc_setNextMedia), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaGaplessPlaybackControl_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QMediaGaplessPlaybackControl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMediaGaplessPlaybackControlWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QMediaGaplessPlaybackControl_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaGaplessPlaybackControl_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaGaplessPlaybackControl_Type = nullptr;
static SbkObjectType *Sbk_QMediaGaplessPlaybackControl_TypeF(void)
{
    return _Sbk_QMediaGaplessPlaybackControl_Type;
}

static PyType_Slot Sbk_QMediaGaplessPlaybackControl_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QMediaGaplessPlaybackControl_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaGaplessPlaybackControl_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaGaplessPlaybackControl_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaGaplessPlaybackControl_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaGaplessPlaybackControl_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaGaplessPlaybackControl_spec = {
    "2:PySide2.QtMultimedia.QMediaGaplessPlaybackControl",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaGaplessPlaybackControl_slots
};

} //extern "C"

static void *Sbk_QMediaGaplessPlaybackControl_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QMediaGaplessPlaybackControl *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaGaplessPlaybackControl_PythonToCpp_QMediaGaplessPlaybackControl_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaGaplessPlaybackControl_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaGaplessPlaybackControl_PythonToCpp_QMediaGaplessPlaybackControl_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaGaplessPlaybackControl_TypeF())))
        return QMediaGaplessPlaybackControl_PythonToCpp_QMediaGaplessPlaybackControl_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaGaplessPlaybackControl_PTR_CppToPython_QMediaGaplessPlaybackControl(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QMediaGaplessPlaybackControl *>(const_cast<void *>(cppIn)), Sbk_QMediaGaplessPlaybackControl_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaGaplessPlaybackControl_SignatureStrings[] = {
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.crossfadeTime(self)->qreal",
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.isCrossfadeSupported(self)->bool",
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.nextMedia(self)->PySide2.QtMultimedia.QMediaContent",
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.setCrossfadeTime(self,crossfadeTime:qreal)",
    "PySide2.QtMultimedia.QMediaGaplessPlaybackControl.setNextMedia(self,media:PySide2.QtMultimedia.QMediaContent)",
    nullptr}; // Sentinel

void init_QMediaGaplessPlaybackControl(PyObject *module)
{
    _Sbk_QMediaGaplessPlaybackControl_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaGaplessPlaybackControl",
        "QMediaGaplessPlaybackControl*",
        &Sbk_QMediaGaplessPlaybackControl_spec,
        &Shiboken::callCppDestructor< ::QMediaGaplessPlaybackControl >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTROL_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaGaplessPlaybackControl_Type);
    InitSignatureStrings(pyType, QMediaGaplessPlaybackControl_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaGaplessPlaybackControl_Type), Sbk_QMediaGaplessPlaybackControl_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIAGAPLESSPLAYBACKCONTROL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaGaplessPlaybackControl_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaGaplessPlaybackControl_TypeF(),
        QMediaGaplessPlaybackControl_PythonToCpp_QMediaGaplessPlaybackControl_PTR,
        is_QMediaGaplessPlaybackControl_PythonToCpp_QMediaGaplessPlaybackControl_PTR_Convertible,
        QMediaGaplessPlaybackControl_PTR_CppToPython_QMediaGaplessPlaybackControl);

    Shiboken::Conversions::registerConverterName(converter, "QMediaGaplessPlaybackControl");
    Shiboken::Conversions::registerConverterName(converter, "QMediaGaplessPlaybackControl*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaGaplessPlaybackControl&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaGaplessPlaybackControl).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaGaplessPlaybackControlWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QMediaGaplessPlaybackControl_TypeF(), &Sbk_QMediaGaplessPlaybackControl_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QMediaGaplessPlaybackControl_TypeF(), &::QMediaGaplessPlaybackControl::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QMediaGaplessPlaybackControl_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QMediaGaplessPlaybackControl_TypeF(), &::QMediaGaplessPlaybackControl::staticMetaObject, sizeof(QMediaGaplessPlaybackControlWrapper));
}
