/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediaserviceproviderhint_wrapper.h"

// inner classes

// Extra includes
#include <QtMultimedia/qmediaserviceproviderplugin.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaServiceProviderHint_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaServiceProviderHint >()))
        return -1;

    ::QMediaServiceProviderHint *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMediaServiceProviderHint", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaServiceProviderHint::QMediaServiceProviderHint()
    // 1: QMediaServiceProviderHint::QMediaServiceProviderHint(QCamera::Position)
    // 2: QMediaServiceProviderHint::QMediaServiceProviderHint(QFlags<QMediaServiceProviderHint::Feature>)
    // 3: QMediaServiceProviderHint::QMediaServiceProviderHint(QByteArray)
    // 4: QMediaServiceProviderHint::QMediaServiceProviderHint(QMediaServiceProviderHint)
    // 5: QMediaServiceProviderHint::QMediaServiceProviderHint(QString,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // QMediaServiceProviderHint()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[1])))) {
        overloadId = 5; // QMediaServiceProviderHint(QString,QStringList)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QMediaServiceProviderHint(QByteArray)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 2; // QMediaServiceProviderHint(QFlags<QMediaServiceProviderHint::Feature>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QMediaServiceProviderHint(QCamera::Position)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QMediaServiceProviderHint(QMediaServiceProviderHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaServiceProviderHint_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMediaServiceProviderHint()
        {

            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint()
                cptr = new ::QMediaServiceProviderHint();
            }
            break;
        }
        case 1: // QMediaServiceProviderHint(QCamera::Position position)
        {
            ::QCamera::Position cppArg0{QCamera::UnspecifiedPosition};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint(QCamera::Position)
                cptr = new ::QMediaServiceProviderHint(cppArg0);
            }
            break;
        }
        case 2: // QMediaServiceProviderHint(QFlags<QMediaServiceProviderHint::Feature> features)
        {
            ::QFlags<QMediaServiceProviderHint::Feature> cppArg0 = QFlags<QMediaServiceProviderHint::Feature>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint(QFlags<QMediaServiceProviderHint::Feature>)
                cptr = new ::QMediaServiceProviderHint(cppArg0);
            }
            break;
        }
        case 3: // QMediaServiceProviderHint(const QByteArray & device)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint(QByteArray)
                cptr = new ::QMediaServiceProviderHint(*cppArg0);
            }
            break;
        }
        case 4: // QMediaServiceProviderHint(const QMediaServiceProviderHint & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaServiceProviderHint cppArg0_local;
            ::QMediaServiceProviderHint *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint(QMediaServiceProviderHint)
                cptr = new ::QMediaServiceProviderHint(*cppArg0);
            }
            break;
        }
        case 5: // QMediaServiceProviderHint(const QString & mimeType, const QStringList & codecs)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QMediaServiceProviderHint(QString,QStringList)
                cptr = new ::QMediaServiceProviderHint(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaServiceProviderHint >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaServiceProviderHint_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMediaServiceProviderHint_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_cameraPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.cameraPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cameraPosition()const
            QCamera::Position cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->cameraPosition();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_codecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.codecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codecs()const
            QStringList cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->codecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QByteArray cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_features(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.features";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // features()const
            QFlags<QMediaServiceProviderHint::Feature> cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->features();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_mimeType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.mimeType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeType()const
            QString cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->mimeType();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHintFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaServiceProviderHint.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QMediaServiceProviderHint::Type cppResult = const_cast<const ::QMediaServiceProviderHint *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaServiceProviderHint___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaServiceProviderHint_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaServiceProviderHint_methods[] = {
    {"cameraPosition", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_cameraPosition), METH_NOARGS},
    {"codecs", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_codecs), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_device), METH_NOARGS},
    {"features", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_features), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_isNull), METH_NOARGS},
    {"mimeType", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_mimeType), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHintFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMediaServiceProviderHint___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaServiceProviderHint___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QMediaServiceProviderHint_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), (pyArg)))) {
                // operator!=(const QMediaServiceProviderHint & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaServiceProviderHint cppArg0_local;
                ::QMediaServiceProviderHint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), (pyArg)))) {
                // operator==(const QMediaServiceProviderHint & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaServiceProviderHint cppArg0_local;
                ::QMediaServiceProviderHint *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMediaServiceProviderHint_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMediaServiceProviderHint_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMediaServiceProviderHint_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaServiceProviderHint_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaServiceProviderHint_Type = nullptr;
static SbkObjectType *Sbk_QMediaServiceProviderHint_TypeF(void)
{
    return _Sbk_QMediaServiceProviderHint_Type;
}

static PyType_Slot Sbk_QMediaServiceProviderHint_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaServiceProviderHint_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaServiceProviderHint_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMediaServiceProviderHint_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaServiceProviderHint_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaServiceProviderHint_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QMediaServiceProviderHint___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QMediaServiceProviderHint___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaServiceProviderHint_spec = {
    "2:PySide2.QtMultimedia.QMediaServiceProviderHint",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaServiceProviderHint_slots
};

} //extern "C"

PyObject *SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___and__(PyObject *self, PyObject *pyArg)
{
    ::QMediaServiceProviderHint::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___or__(PyObject *self, PyObject *pyArg)
{
    ::QMediaServiceProviderHint::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QMediaServiceProviderHint::Features cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QMediaServiceProviderHint::Features>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QMediaServiceProviderHint::Features>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QMediaServiceProviderHint::Features cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, self, &cppSelf);
    ::QMediaServiceProviderHint::Features cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QMediaServiceProviderHint_Type_PythonToCpp_QMediaServiceProviderHint_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaServiceProviderHint::Type *>(cppOut) =
        static_cast<::QMediaServiceProviderHint::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaServiceProviderHint_Type_PythonToCpp_QMediaServiceProviderHint_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX]))
        return QMediaServiceProviderHint_Type_PythonToCpp_QMediaServiceProviderHint_Type;
    return {};
}
static PyObject *QMediaServiceProviderHint_Type_CppToPython_QMediaServiceProviderHint_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaServiceProviderHint::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX], castCppIn);

}

static void QMediaServiceProviderHint_Feature_PythonToCpp_QMediaServiceProviderHint_Feature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaServiceProviderHint::Feature *>(cppOut) =
        static_cast<::QMediaServiceProviderHint::Feature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaServiceProviderHint_Feature_PythonToCpp_QMediaServiceProviderHint_Feature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]))
        return QMediaServiceProviderHint_Feature_PythonToCpp_QMediaServiceProviderHint_Feature;
    return {};
}
static PyObject *QMediaServiceProviderHint_Feature_CppToPython_QMediaServiceProviderHint_Feature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaServiceProviderHint::Feature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX], castCppIn);

}

static void QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QMediaServiceProviderHint::Feature> *>(cppOut) =
        ::QFlags<QMediaServiceProviderHint::Feature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]))
        return QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_;
    return {};
}
static PyObject *QFlags_QMediaServiceProviderHint_Feature__CppToPython_QFlags_QMediaServiceProviderHint_Feature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QMediaServiceProviderHint::Feature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]));

}

static void QMediaServiceProviderHint_Feature_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QMediaServiceProviderHint::Feature> *>(cppOut) =
        ::QFlags<QMediaServiceProviderHint::Feature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QMediaServiceProviderHint_Feature_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]))
        return QMediaServiceProviderHint_Feature_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_;
    return {};
}
static void number_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QMediaServiceProviderHint::Feature> *>(cppOut) =
        ::QFlags<QMediaServiceProviderHint::Feature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]))
        return number_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaServiceProviderHint_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaServiceProviderHint_TypeF())))
        return QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaServiceProviderHint_PTR_CppToPython_QMediaServiceProviderHint(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMediaServiceProviderHint *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMediaServiceProviderHint_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMediaServiceProviderHint_COPY_CppToPython_QMediaServiceProviderHint(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMediaServiceProviderHint_TypeF(), new ::QMediaServiceProviderHint(*reinterpret_cast<const ::QMediaServiceProviderHint *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaServiceProviderHint *>(cppOut) = *reinterpret_cast< ::QMediaServiceProviderHint *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaServiceProviderHint_TypeF())))
        return QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_COPY;
    return {};
}

// Implicit conversions.
static void QCamera_Position_PythonToCpp_QMediaServiceProviderHint(PyObject *pyIn, void *cppOut) {
    ::QCamera::Position cppIn{QCamera::UnspecifiedPosition};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QMediaServiceProviderHint *>(cppOut) = ::QMediaServiceProviderHint(cppIn);
}
static PythonToCppFunc is_QCamera_Position_PythonToCpp_QMediaServiceProviderHint_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX], pyIn))
        return QCamera_Position_PythonToCpp_QMediaServiceProviderHint;
    return {};
}

static void QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QMediaServiceProviderHint(PyObject *pyIn, void *cppOut) {
    ::QFlags<QMediaServiceProviderHint::Feature> cppIn = QFlags<QMediaServiceProviderHint::Feature>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QMediaServiceProviderHint *>(cppOut) = ::QMediaServiceProviderHint(cppIn);
}
static PythonToCppFunc is_QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QMediaServiceProviderHint_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX], pyIn))
        return QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QMediaServiceProviderHint;
    return {};
}

static void PySide2_QtCore_constQByteArrayREF_PythonToCpp_QMediaServiceProviderHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaServiceProviderHint *>(cppOut) = ::QMediaServiceProviderHint( *reinterpret_cast< ::QByteArray *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQByteArrayREF_PythonToCpp_QMediaServiceProviderHint_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX], pyIn))
        return PySide2_QtCore_constQByteArrayREF_PythonToCpp_QMediaServiceProviderHint;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaServiceProviderHint_SignatureStrings[] = {
    "5:PySide2.QtMultimedia.QMediaServiceProviderHint(self)",
    "4:PySide2.QtMultimedia.QMediaServiceProviderHint(self,position:PySide2.QtMultimedia.QCamera.Position)",
    "3:PySide2.QtMultimedia.QMediaServiceProviderHint(self,features:PySide2.QtMultimedia.QMediaServiceProviderHint.Features)",
    "2:PySide2.QtMultimedia.QMediaServiceProviderHint(self,device:PySide2.QtCore.QByteArray)",
    "1:PySide2.QtMultimedia.QMediaServiceProviderHint(self,other:PySide2.QtMultimedia.QMediaServiceProviderHint)",
    "0:PySide2.QtMultimedia.QMediaServiceProviderHint(self,mimeType:QString,codecs:QStringList)",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.cameraPosition(self)->PySide2.QtMultimedia.QCamera.Position",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.codecs(self)->QStringList",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.device(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.features(self)->PySide2.QtMultimedia.QMediaServiceProviderHint.Features",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.isNull(self)->bool",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.mimeType(self)->QString",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.type(self)->PySide2.QtMultimedia.QMediaServiceProviderHint.Type",
    "PySide2.QtMultimedia.QMediaServiceProviderHint.__copy__()",
    nullptr}; // Sentinel

void init_QMediaServiceProviderHint(PyObject *module)
{
    _Sbk_QMediaServiceProviderHint_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaServiceProviderHint",
        "QMediaServiceProviderHint",
        &Sbk_QMediaServiceProviderHint_spec,
        &Shiboken::callCppDestructor< ::QMediaServiceProviderHint >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaServiceProviderHint_Type);
    InitSignatureStrings(pyType, QMediaServiceProviderHint_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaServiceProviderHint_Type), Sbk_QMediaServiceProviderHint_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaServiceProviderHint_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaServiceProviderHint_TypeF(),
        QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_PTR,
        is_QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_PTR_Convertible,
        QMediaServiceProviderHint_PTR_CppToPython_QMediaServiceProviderHint,
        QMediaServiceProviderHint_COPY_CppToPython_QMediaServiceProviderHint);

    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint");
    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaServiceProviderHint).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_COPY,
        is_QMediaServiceProviderHint_PythonToCpp_QMediaServiceProviderHint_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QCamera_Position_PythonToCpp_QMediaServiceProviderHint,
        is_QCamera_Position_PythonToCpp_QMediaServiceProviderHint_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QMediaServiceProviderHint,
        is_QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QMediaServiceProviderHint_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQByteArrayREF_PythonToCpp_QMediaServiceProviderHint,
        is_PySide2_QtCore_constQByteArrayREF_PythonToCpp_QMediaServiceProviderHint_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Type'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaServiceProviderHint_TypeF(),
        "Type",
        "2:PySide2.QtMultimedia.QMediaServiceProviderHint.Type",
        "QMediaServiceProviderHint::Type");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "Null", (long) QMediaServiceProviderHint::Type::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "ContentType", (long) QMediaServiceProviderHint::Type::ContentType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "Device", (long) QMediaServiceProviderHint::Type::Device))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "SupportedFeatures", (long) QMediaServiceProviderHint::Type::SupportedFeatures))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "CameraPosition", (long) QMediaServiceProviderHint::Type::CameraPosition))
        return;
    // Register converter for enum 'QMediaServiceProviderHint::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX],
            QMediaServiceProviderHint_Type_CppToPython_QMediaServiceProviderHint_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaServiceProviderHint_Type_PythonToCpp_QMediaServiceProviderHint_Type,
            is_QMediaServiceProviderHint_Type_PythonToCpp_QMediaServiceProviderHint_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    // Initialization of enum 'Feature'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QMediaServiceProviderHint.Features", SbkPySide2_QtMultimedia_QMediaServiceProviderHint_Feature_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaServiceProviderHint_TypeF(),
        "Feature",
        "2:PySide2.QtMultimedia.QMediaServiceProviderHint.Feature",
        "QMediaServiceProviderHint::Feature",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "LowLatencyPlayback", (long) QMediaServiceProviderHint::Feature::LowLatencyPlayback))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "RecordingSupport", (long) QMediaServiceProviderHint::Feature::RecordingSupport))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "StreamPlayback", (long) QMediaServiceProviderHint::Feature::StreamPlayback))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
        Sbk_QMediaServiceProviderHint_TypeF(), "VideoSurface", (long) QMediaServiceProviderHint::Feature::VideoSurface))
        return;
    // Register converter for enum 'QMediaServiceProviderHint::Feature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
            QMediaServiceProviderHint_Feature_CppToPython_QMediaServiceProviderHint_Feature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaServiceProviderHint_Feature_PythonToCpp_QMediaServiceProviderHint_Feature,
            is_QMediaServiceProviderHint_Feature_PythonToCpp_QMediaServiceProviderHint_Feature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint::Feature");
        Shiboken::Conversions::registerConverterName(converter, "Feature");
    }
    // Register converter for flag 'QFlags<QMediaServiceProviderHint::Feature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX],
            QFlags_QMediaServiceProviderHint_Feature__CppToPython_QFlags_QMediaServiceProviderHint_Feature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaServiceProviderHint_Feature_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_,
            is_QMediaServiceProviderHint_Feature_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_,
            is_QFlags_QMediaServiceProviderHint_Feature__PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature_,
            is_number_PythonToCpp_QFlags_QMediaServiceProviderHint_Feature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QMEDIASERVICEPROVIDERHINT_FEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaServiceProviderHint::Features");
        Shiboken::Conversions::registerConverterName(converter, "Features");
    }
    // End of 'Feature' enum/flags.

    qRegisterMetaType< ::QMediaServiceProviderHint >("QMediaServiceProviderHint");
    qRegisterMetaType< ::QMediaServiceProviderHint::Type >("QMediaServiceProviderHint::Type");
    qRegisterMetaType< ::QMediaServiceProviderHint::Feature >("QMediaServiceProviderHint::Feature");
    qRegisterMetaType< ::QMediaServiceProviderHint::Features >("QMediaServiceProviderHint::Features");
}
