/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qradiodata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRadioDataWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QRadioDataWrapper::QRadioDataWrapper(::QMediaObject * mediaObject, ::QObject * parent) : QRadioData(mediaObject, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QRadioDataWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRadioDataWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRadioDataWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRadioDataWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRadioDataWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioData.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRadioDataWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioData.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QMediaObject * QRadioDataWrapper::mediaObject() const
{
    if (m_PyMethodCache[6])
        return this->::QRadioData::mediaObject();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QRadioData::mediaObject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioData.mediaObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QRadioDataWrapper::setMediaObject(::QMediaObject * arg__1)
{
    if (m_PyMethodCache[8])
        return this->::QRadioData::setMediaObject(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setMediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QRadioData::setMediaObject(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioData.setMediaObject", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRadioDataWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QRadioDataWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QRadioData::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRadioDataWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QRadioData::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRadioDataWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRadioDataWrapper *>(this));
        return QRadioData::qt_metacast(_clname);
}

QRadioDataWrapper::~QRadioDataWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRadioData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRadioData >()))
        return -1;

    ::QRadioDataWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRadioData_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QRadioData", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QRadioData::QRadioData(QMediaObject*,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QRadioData(QMediaObject*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QRadioData(QMediaObject*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioData_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QRadioData_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QRadioData_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QMediaObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QRadioData(QMediaObject*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QRadioDataWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QRadioDataWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRadioData >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRadioData_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QRadioData_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QRadioData_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRadioDataFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = const_cast<const ::QRadioData *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QRadioData::Error cppResult = const_cast<const ::QRadioData *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QRadioData *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_isAlternativeFrequenciesEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.isAlternativeFrequenciesEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAlternativeFrequenciesEnabled()const
            bool cppResult = const_cast<const ::QRadioData *>(cppSelf)->isAlternativeFrequenciesEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_mediaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.mediaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaObject()const
            QMediaObject * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QRadioData *>(cppSelf)->::QRadioData::mediaObject()
                : const_cast<const ::QRadioData *>(cppSelf)->mediaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_programType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.programType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // programType()const
            QRadioData::ProgramType cppResult = const_cast<const ::QRadioData *>(cppSelf)->programType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_programTypeName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.programTypeName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // programTypeName()const
            QString cppResult = const_cast<const ::QRadioData *>(cppSelf)->programTypeName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_radioText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.radioText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radioText()const
            QString cppResult = const_cast<const ::QRadioData *>(cppSelf)->radioText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_setAlternativeFrequenciesEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.setAlternativeFrequenciesEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioData::setAlternativeFrequenciesEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAlternativeFrequenciesEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioDataFunc_setAlternativeFrequenciesEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlternativeFrequenciesEnabled(bool)
            cppSelf->setAlternativeFrequenciesEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioDataFunc_setAlternativeFrequenciesEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioDataFunc_setMediaObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.setMediaObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaBindableInterface::setMediaObject(QMediaObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setMediaObject(QMediaObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioDataFunc_setMediaObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMediaObject(QMediaObject*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRadioData::setMediaObject(cppArg0)
                : cppSelf->setMediaObject(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRadioDataFunc_setMediaObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioDataFunc_stationId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.stationId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stationId()const
            QString cppResult = const_cast<const ::QRadioData *>(cppSelf)->stationId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioDataFunc_stationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioData.stationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stationName()const
            QString cppResult = const_cast<const ::QRadioData *>(cppSelf)->stationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRadioData_PropertyStrings[] = {
    "alternativeFrequenciesEnabled:isAlternativeFrequenciesEnabled:",
    "programType:",
    "programTypeName:",
    "radioText:",
    "stationId:",
    "stationName:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRadioData_methods[] = {
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_availability), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_errorString), METH_NOARGS},
    {"isAlternativeFrequenciesEnabled", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_isAlternativeFrequenciesEnabled), METH_NOARGS},
    {"mediaObject", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_mediaObject), METH_NOARGS},
    {"programType", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_programType), METH_NOARGS},
    {"programTypeName", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_programTypeName), METH_NOARGS},
    {"radioText", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_radioText), METH_NOARGS},
    {"setAlternativeFrequenciesEnabled", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_setAlternativeFrequenciesEnabled), METH_O},
    {"setMediaObject", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_setMediaObject), METH_O},
    {"stationId", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_stationId), METH_NOARGS},
    {"stationName", reinterpret_cast<PyCFunction>(Sbk_QRadioDataFunc_stationName), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QRadioData_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QRadioData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRadioDataWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QRadioData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRadioData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QRadioData_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QRadioData *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QRadioData *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(static_cast<const QRadioData *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QRadioDataSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QRadioData *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]))
        return static_cast< ::QMediaBindableInterface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRadioData_Type = nullptr;
static SbkObjectType *Sbk_QRadioData_TypeF(void)
{
    return _Sbk_QRadioData_Type;
}

static PyType_Slot Sbk_QRadioData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QRadioData_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRadioData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRadioData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRadioData_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRadioData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRadioData_spec = {
    "2:PySide2.QtMultimedia.QRadioData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRadioData_slots
};

} //extern "C"

static void *Sbk_QRadioData_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QRadioData *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QMediaBindableInterface >()))
        return dynamic_cast< ::QRadioData *>(reinterpret_cast< ::QMediaBindableInterface *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QRadioData_Error_PythonToCpp_QRadioData_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioData::Error *>(cppOut) =
        static_cast<::QRadioData::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioData_Error_PythonToCpp_QRadioData_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX]))
        return QRadioData_Error_PythonToCpp_QRadioData_Error;
    return {};
}
static PyObject *QRadioData_Error_CppToPython_QRadioData_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioData::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX], castCppIn);

}

static void QRadioData_ProgramType_PythonToCpp_QRadioData_ProgramType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioData::ProgramType *>(cppOut) =
        static_cast<::QRadioData::ProgramType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioData_ProgramType_PythonToCpp_QRadioData_ProgramType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX]))
        return QRadioData_ProgramType_PythonToCpp_QRadioData_ProgramType;
    return {};
}
static PyObject *QRadioData_ProgramType_CppToPython_QRadioData_ProgramType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioData::ProgramType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRadioData_PythonToCpp_QRadioData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRadioData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRadioData_PythonToCpp_QRadioData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRadioData_TypeF())))
        return QRadioData_PythonToCpp_QRadioData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRadioData_PTR_CppToPython_QRadioData(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QRadioData *>(const_cast<void *>(cppIn)), Sbk_QRadioData_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRadioData_SignatureStrings[] = {
    "PySide2.QtMultimedia.QRadioData(self,mediaObject:PySide2.QtMultimedia.QMediaObject,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QRadioData.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QRadioData.error(self)->PySide2.QtMultimedia.QRadioData.Error",
    "PySide2.QtMultimedia.QRadioData.errorString(self)->QString",
    "PySide2.QtMultimedia.QRadioData.isAlternativeFrequenciesEnabled(self)->bool",
    "PySide2.QtMultimedia.QRadioData.mediaObject(self)->PySide2.QtMultimedia.QMediaObject",
    "PySide2.QtMultimedia.QRadioData.programType(self)->PySide2.QtMultimedia.QRadioData.ProgramType",
    "PySide2.QtMultimedia.QRadioData.programTypeName(self)->QString",
    "PySide2.QtMultimedia.QRadioData.radioText(self)->QString",
    "PySide2.QtMultimedia.QRadioData.setAlternativeFrequenciesEnabled(self,enabled:bool)",
    "PySide2.QtMultimedia.QRadioData.setMediaObject(self,arg__1:PySide2.QtMultimedia.QMediaObject)->bool",
    "PySide2.QtMultimedia.QRadioData.stationId(self)->QString",
    "PySide2.QtMultimedia.QRadioData.stationName(self)->QString",
    nullptr}; // Sentinel

void init_QRadioData(PyObject *module)
{
    PyObject *Sbk_QRadioData_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]));

    _Sbk_QRadioData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRadioData",
        "QRadioData*",
        &Sbk_QRadioData_spec,
        &Shiboken::callCppDestructor< ::QRadioData >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QRadioData_Type_bases,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRadioData_Type);
    InitSignatureStrings(pyType, QRadioData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRadioData_Type), Sbk_QRadioData_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRadioData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRadioData_TypeF(),
        QRadioData_PythonToCpp_QRadioData_PTR,
        is_QRadioData_PythonToCpp_QRadioData_PTR_Convertible,
        QRadioData_PTR_CppToPython_QRadioData);

    Shiboken::Conversions::registerConverterName(converter, "QRadioData");
    Shiboken::Conversions::registerConverterName(converter, "QRadioData*");
    Shiboken::Conversions::registerConverterName(converter, "QRadioData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRadioData).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRadioDataWrapper).name());


    MultipleInheritanceInitFunction func = Sbk_QRadioData_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QRadioData_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QRadioData_TypeF(), &Sbk_QRadioDataSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QRadioData_TypeF(), &Sbk_QRadioData_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioData_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QRadioData.Error",
        "QRadioData::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX],
        Sbk_QRadioData_TypeF(), "NoError", (long) QRadioData::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX],
        Sbk_QRadioData_TypeF(), "ResourceError", (long) QRadioData::Error::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX],
        Sbk_QRadioData_TypeF(), "OpenError", (long) QRadioData::Error::OpenError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX],
        Sbk_QRadioData_TypeF(), "OutOfRangeError", (long) QRadioData::Error::OutOfRangeError))
        return;
    // Register converter for enum 'QRadioData::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX],
            QRadioData_Error_CppToPython_QRadioData_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioData_Error_PythonToCpp_QRadioData_Error,
            is_QRadioData_Error_PythonToCpp_QRadioData_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioData::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'ProgramType'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioData_TypeF(),
        "ProgramType",
        "2:PySide2.QtMultimedia.QRadioData.ProgramType",
        "QRadioData::ProgramType");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Undefined", (long) QRadioData::ProgramType::Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "News", (long) QRadioData::ProgramType::News))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "CurrentAffairs", (long) QRadioData::ProgramType::CurrentAffairs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Information", (long) QRadioData::ProgramType::Information))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Sport", (long) QRadioData::ProgramType::Sport))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Education", (long) QRadioData::ProgramType::Education))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Drama", (long) QRadioData::ProgramType::Drama))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Culture", (long) QRadioData::ProgramType::Culture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Science", (long) QRadioData::ProgramType::Science))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Varied", (long) QRadioData::ProgramType::Varied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "PopMusic", (long) QRadioData::ProgramType::PopMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "RockMusic", (long) QRadioData::ProgramType::RockMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "EasyListening", (long) QRadioData::ProgramType::EasyListening))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "LightClassical", (long) QRadioData::ProgramType::LightClassical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "SeriousClassical", (long) QRadioData::ProgramType::SeriousClassical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "OtherMusic", (long) QRadioData::ProgramType::OtherMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Weather", (long) QRadioData::ProgramType::Weather))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Finance", (long) QRadioData::ProgramType::Finance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "ChildrensProgrammes", (long) QRadioData::ProgramType::ChildrensProgrammes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "SocialAffairs", (long) QRadioData::ProgramType::SocialAffairs))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Religion", (long) QRadioData::ProgramType::Religion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "PhoneIn", (long) QRadioData::ProgramType::PhoneIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Travel", (long) QRadioData::ProgramType::Travel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Leisure", (long) QRadioData::ProgramType::Leisure))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "JazzMusic", (long) QRadioData::ProgramType::JazzMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "CountryMusic", (long) QRadioData::ProgramType::CountryMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "NationalMusic", (long) QRadioData::ProgramType::NationalMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "OldiesMusic", (long) QRadioData::ProgramType::OldiesMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "FolkMusic", (long) QRadioData::ProgramType::FolkMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Documentary", (long) QRadioData::ProgramType::Documentary))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "AlarmTest", (long) QRadioData::ProgramType::AlarmTest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Alarm", (long) QRadioData::ProgramType::Alarm))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Talk", (long) QRadioData::ProgramType::Talk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "ClassicRock", (long) QRadioData::ProgramType::ClassicRock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "AdultHits", (long) QRadioData::ProgramType::AdultHits))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "SoftRock", (long) QRadioData::ProgramType::SoftRock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Top40", (long) QRadioData::ProgramType::Top40))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Soft", (long) QRadioData::ProgramType::Soft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Nostalgia", (long) QRadioData::ProgramType::Nostalgia))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Classical", (long) QRadioData::ProgramType::Classical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "RhythmAndBlues", (long) QRadioData::ProgramType::RhythmAndBlues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "SoftRhythmAndBlues", (long) QRadioData::ProgramType::SoftRhythmAndBlues))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Language", (long) QRadioData::ProgramType::Language))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "ReligiousMusic", (long) QRadioData::ProgramType::ReligiousMusic))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "ReligiousTalk", (long) QRadioData::ProgramType::ReligiousTalk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Personality", (long) QRadioData::ProgramType::Personality))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "Public", (long) QRadioData::ProgramType::Public))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
        Sbk_QRadioData_TypeF(), "College", (long) QRadioData::ProgramType::College))
        return;
    // Register converter for enum 'QRadioData::ProgramType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX],
            QRadioData_ProgramType_CppToPython_QRadioData_ProgramType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioData_ProgramType_PythonToCpp_QRadioData_ProgramType,
            is_QRadioData_ProgramType_PythonToCpp_QRadioData_ProgramType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_PROGRAMTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioData::ProgramType");
        Shiboken::Conversions::registerConverterName(converter, "ProgramType");
    }
    // End of 'ProgramType' enum.

    PySide::Signal::registerSignals(Sbk_QRadioData_TypeF(), &::QRadioData::staticMetaObject);
    qRegisterMetaType< ::QRadioData::Error >("QRadioData::Error");
    qRegisterMetaType< ::QRadioData::ProgramType >("QRadioData::ProgramType");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QRadioData_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QRadioData_TypeF(), &::QRadioData::staticMetaObject, sizeof(QRadioDataWrapper));
}
