/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qradiotuner_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRadioTunerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QRadioTunerWrapper::QRadioTunerWrapper(::QObject * parent) : QRadioTuner(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QMultimedia::AvailabilityStatus QRadioTunerWrapper::availability() const
{
    if (m_PyMethodCache[0])
        return this->::QRadioTuner::availability();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QMultimedia::Available;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "availability";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QRadioTuner::availability();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMultimedia::Available;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.availability", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMultimedia::AvailabilityStatus >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QMultimedia::Available;
    }
    ::QMultimedia::AvailabilityStatus cppResult{QMultimedia::Available};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QRadioTunerWrapper::bind(::QObject * arg__1)
{
    if (m_PyMethodCache[1])
        return this->::QMediaObject::bind(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QMediaObject::bind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.bind", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRadioTunerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRadioTunerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRadioTunerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRadioTunerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRadioTunerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRadioTunerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QRadioTunerWrapper::isAvailable() const
{
    if (m_PyMethodCache[8])
        return this->::QMediaObject::isAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QMediaObject::isAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.isAvailable", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMediaService * QRadioTunerWrapper::service() const
{
    if (m_PyMethodCache[10])
        return this->::QMediaObject::service();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "service";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QMediaObject::service();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRadioTuner.service", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaService >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaService *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QRadioTunerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRadioTunerWrapper::unbind(::QObject * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QMediaObject::unbind(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unbind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QMediaObject::unbind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QRadioTunerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QRadioTuner::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRadioTunerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QRadioTuner::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRadioTunerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRadioTunerWrapper *>(this));
        return QRadioTuner::qt_metacast(_clname);
}

QRadioTunerWrapper::~QRadioTunerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRadioTuner_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRadioTuner >()))
        return -1;

    ::QRadioTunerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QRadioTuner", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QRadioTuner::QRadioTuner(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QRadioTuner(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QRadioTuner(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTuner_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QRadioTuner_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QRadioTuner_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QRadioTuner(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QRadioTunerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QRadioTunerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRadioTuner >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRadioTuner_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QRadioTuner_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QRadioTuner_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRadioTunerFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QRadioTuner *>(cppSelf)->::QRadioTuner::availability()
                : const_cast<const ::QRadioTuner *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_band(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.band";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // band()const
            QRadioTuner::Band cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->band();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_cancelSearch(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.cancelSearch";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cancelSearch()
            cppSelf->cancelSearch();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRadioTunerFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QRadioTuner::Error cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_frequency(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.frequency";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frequency()const
            int cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->frequency();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_frequencyRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.frequencyRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::frequencyRange(QRadioTuner::Band)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])->converter, (pyArg)))) {
        overloadId = 0; // frequencyRange(QRadioTuner::Band)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_frequencyRange_TypeError;

    // Call function/method
    {
        ::QRadioTuner::Band cppArg0{QRadioTuner::AM};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // frequencyRange(QRadioTuner::Band)const
            QPair<int,int > cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->frequencyRange(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRadioTunerFunc_frequencyRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_frequencyStep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.frequencyStep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::frequencyStep(QRadioTuner::Band)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])->converter, (pyArg)))) {
        overloadId = 0; // frequencyStep(QRadioTuner::Band)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_frequencyStep_TypeError;

    // Call function/method
    {
        ::QRadioTuner::Band cppArg0{QRadioTuner::AM};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // frequencyStep(QRadioTuner::Band)const
            int cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->frequencyStep(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRadioTunerFunc_frequencyStep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_isAntennaConnected(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.isAntennaConnected";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAntennaConnected()const
            bool cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->isAntennaConnected();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_isBandSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.isBandSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::isBandSupported(QRadioTuner::Band)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isBandSupported(QRadioTuner::Band)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_isBandSupported_TypeError;

    // Call function/method
    {
        ::QRadioTuner::Band cppArg0{QRadioTuner::AM};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isBandSupported(QRadioTuner::Band)const
            bool cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->isBandSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRadioTunerFunc_isBandSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_isMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.isMuted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMuted()const
            bool cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->isMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_isSearching(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.isSearching";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSearching()const
            bool cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->isSearching();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_isStereo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.isStereo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStereo()const
            bool cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->isStereo();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_radioData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.radioData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // radioData()const
            QRadioData * cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->radioData();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QRADIODATA_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_searchAllStations(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.searchAllStations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRadioTunerFunc_searchAllStations_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:searchAllStations", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRadioTuner::searchAllStations(QRadioTuner::SearchMode)
    if (numArgs == 0) {
        overloadId = 0; // searchAllStations(QRadioTuner::SearchMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // searchAllStations(QRadioTuner::SearchMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_searchAllStations_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_searchMode = Shiboken::String::createStaticString("searchMode");
            if (PyDict_Contains(kwds, key_searchMode)) {
                value = PyDict_GetItem(kwds, key_searchMode);
                if (value && pyArgs[0]) {
                    errInfo = key_searchMode;
                    Py_INCREF(errInfo);
                    goto Sbk_QRadioTunerFunc_searchAllStations_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QRadioTunerFunc_searchAllStations_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_searchMode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRadioTunerFunc_searchAllStations_TypeError;
            }
        }
        ::QRadioTuner::SearchMode cppArg0 = QRadioTuner::SearchFast;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // searchAllStations(QRadioTuner::SearchMode)
            cppSelf->searchAllStations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_searchAllStations_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_searchBackward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.searchBackward";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchBackward()
            cppSelf->searchBackward();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRadioTunerFunc_searchForward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.searchForward";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchForward()
            cppSelf->searchForward();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRadioTunerFunc_setBand(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.setBand";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::setBand(QRadioTuner::Band)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setBand(QRadioTuner::Band)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_setBand_TypeError;

    // Call function/method
    {
        ::QRadioTuner::Band cppArg0{QRadioTuner::AM};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBand(QRadioTuner::Band)
            cppSelf->setBand(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_setBand_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_setFrequency(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.setFrequency";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::setFrequency(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFrequency(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_setFrequency_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFrequency(int)
            cppSelf->setFrequency(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_setFrequency_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_setMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.setMuted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::setMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_setMuted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMuted(bool)
            cppSelf->setMuted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_setMuted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_setStereoMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.setStereoMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::setStereoMode(QRadioTuner::StereoMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStereoMode(QRadioTuner::StereoMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_setStereoMode_TypeError;

    // Call function/method
    {
        ::QRadioTuner::StereoMode cppArg0{QRadioTuner::ForceStereo};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStereoMode(QRadioTuner::StereoMode)
            cppSelf->setStereoMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_setStereoMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRadioTuner::setVolume(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setVolume(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRadioTunerFunc_setVolume_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(int)
            cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRadioTunerFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRadioTunerFunc_signalStrength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.signalStrength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // signalStrength()const
            int cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->signalStrength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRadioTunerFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QRadioTuner::State cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_stereoMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.stereoMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stereoMode()const
            QRadioTuner::StereoMode cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->stereoMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRadioTunerFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRadioTunerFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QRadioTuner.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            int cppResult = const_cast<const ::QRadioTuner *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRadioTuner_PropertyStrings[] = {
    "antennaConnected:isAntennaConnected",
    "band::",
    "frequency::",
    "muted:isMuted:",
    "radioData:",
    "searching:isSearching",
    "signalStrength:",
    "state:",
    "stereo:isStereo",
    "stereoMode::",
    "volume::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRadioTuner_methods[] = {
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_availability), METH_NOARGS},
    {"band", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_band), METH_NOARGS},
    {"cancelSearch", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_cancelSearch), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_errorString), METH_NOARGS},
    {"frequency", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_frequency), METH_NOARGS},
    {"frequencyRange", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_frequencyRange), METH_O},
    {"frequencyStep", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_frequencyStep), METH_O},
    {"isAntennaConnected", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_isAntennaConnected), METH_NOARGS},
    {"isBandSupported", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_isBandSupported), METH_O},
    {"isMuted", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_isMuted), METH_NOARGS},
    {"isSearching", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_isSearching), METH_NOARGS},
    {"isStereo", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_isStereo), METH_NOARGS},
    {"radioData", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_radioData), METH_NOARGS},
    {"searchAllStations", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_searchAllStations), METH_VARARGS|METH_KEYWORDS},
    {"searchBackward", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_searchBackward), METH_NOARGS},
    {"searchForward", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_searchForward), METH_NOARGS},
    {"setBand", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_setBand), METH_O},
    {"setFrequency", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_setFrequency), METH_O},
    {"setMuted", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_setMuted), METH_O},
    {"setStereoMode", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_setStereoMode), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_setVolume), METH_O},
    {"signalStrength", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_signalStrength), METH_NOARGS},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_start), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_state), METH_NOARGS},
    {"stereoMode", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_stereoMode), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_stop), METH_NOARGS},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QRadioTunerFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QRadioTuner_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QRadioTuner *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRadioTunerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QRadioTuner_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRadioTuner_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRadioTuner_Type = nullptr;
static SbkObjectType *Sbk_QRadioTuner_TypeF(void)
{
    return _Sbk_QRadioTuner_Type;
}

static PyType_Slot Sbk_QRadioTuner_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QRadioTuner_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRadioTuner_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRadioTuner_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRadioTuner_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRadioTuner_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRadioTuner_spec = {
    "2:PySide2.QtMultimedia.QRadioTuner",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRadioTuner_slots
};

} //extern "C"

static void *Sbk_QRadioTuner_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QRadioTuner *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QRadioTuner_State_PythonToCpp_QRadioTuner_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioTuner::State *>(cppOut) =
        static_cast<::QRadioTuner::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioTuner_State_PythonToCpp_QRadioTuner_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX]))
        return QRadioTuner_State_PythonToCpp_QRadioTuner_State;
    return {};
}
static PyObject *QRadioTuner_State_CppToPython_QRadioTuner_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioTuner::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX], castCppIn);

}

static void QRadioTuner_Band_PythonToCpp_QRadioTuner_Band(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioTuner::Band *>(cppOut) =
        static_cast<::QRadioTuner::Band>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioTuner_Band_PythonToCpp_QRadioTuner_Band_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX]))
        return QRadioTuner_Band_PythonToCpp_QRadioTuner_Band;
    return {};
}
static PyObject *QRadioTuner_Band_CppToPython_QRadioTuner_Band(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioTuner::Band *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX], castCppIn);

}

static void QRadioTuner_Error_PythonToCpp_QRadioTuner_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioTuner::Error *>(cppOut) =
        static_cast<::QRadioTuner::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioTuner_Error_PythonToCpp_QRadioTuner_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX]))
        return QRadioTuner_Error_PythonToCpp_QRadioTuner_Error;
    return {};
}
static PyObject *QRadioTuner_Error_CppToPython_QRadioTuner_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioTuner::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX], castCppIn);

}

static void QRadioTuner_StereoMode_PythonToCpp_QRadioTuner_StereoMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioTuner::StereoMode *>(cppOut) =
        static_cast<::QRadioTuner::StereoMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioTuner_StereoMode_PythonToCpp_QRadioTuner_StereoMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX]))
        return QRadioTuner_StereoMode_PythonToCpp_QRadioTuner_StereoMode;
    return {};
}
static PyObject *QRadioTuner_StereoMode_CppToPython_QRadioTuner_StereoMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioTuner::StereoMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX], castCppIn);

}

static void QRadioTuner_SearchMode_PythonToCpp_QRadioTuner_SearchMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRadioTuner::SearchMode *>(cppOut) =
        static_cast<::QRadioTuner::SearchMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRadioTuner_SearchMode_PythonToCpp_QRadioTuner_SearchMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX]))
        return QRadioTuner_SearchMode_PythonToCpp_QRadioTuner_SearchMode;
    return {};
}
static PyObject *QRadioTuner_SearchMode_CppToPython_QRadioTuner_SearchMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRadioTuner::SearchMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRadioTuner_PythonToCpp_QRadioTuner_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRadioTuner_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRadioTuner_PythonToCpp_QRadioTuner_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRadioTuner_TypeF())))
        return QRadioTuner_PythonToCpp_QRadioTuner_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRadioTuner_PTR_CppToPython_QRadioTuner(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QRadioTuner *>(const_cast<void *>(cppIn)), Sbk_QRadioTuner_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRadioTuner_SignatureStrings[] = {
    "PySide2.QtMultimedia.QRadioTuner(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QRadioTuner.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QRadioTuner.band(self)->PySide2.QtMultimedia.QRadioTuner.Band",
    "PySide2.QtMultimedia.QRadioTuner.cancelSearch(self)",
    "PySide2.QtMultimedia.QRadioTuner.error(self)->PySide2.QtMultimedia.QRadioTuner.Error",
    "PySide2.QtMultimedia.QRadioTuner.errorString(self)->QString",
    "PySide2.QtMultimedia.QRadioTuner.frequency(self)->int",
    "PySide2.QtMultimedia.QRadioTuner.frequencyRange(self,band:PySide2.QtMultimedia.QRadioTuner.Band)->QPair[int, int]",
    "PySide2.QtMultimedia.QRadioTuner.frequencyStep(self,band:PySide2.QtMultimedia.QRadioTuner.Band)->int",
    "PySide2.QtMultimedia.QRadioTuner.isAntennaConnected(self)->bool",
    "PySide2.QtMultimedia.QRadioTuner.isBandSupported(self,b:PySide2.QtMultimedia.QRadioTuner.Band)->bool",
    "PySide2.QtMultimedia.QRadioTuner.isMuted(self)->bool",
    "PySide2.QtMultimedia.QRadioTuner.isSearching(self)->bool",
    "PySide2.QtMultimedia.QRadioTuner.isStereo(self)->bool",
    "PySide2.QtMultimedia.QRadioTuner.radioData(self)->PySide2.QtMultimedia.QRadioData",
    "PySide2.QtMultimedia.QRadioTuner.searchAllStations(self,searchMode:PySide2.QtMultimedia.QRadioTuner.SearchMode=QRadioTuner.SearchFast)",
    "PySide2.QtMultimedia.QRadioTuner.searchBackward(self)",
    "PySide2.QtMultimedia.QRadioTuner.searchForward(self)",
    "PySide2.QtMultimedia.QRadioTuner.setBand(self,band:PySide2.QtMultimedia.QRadioTuner.Band)",
    "PySide2.QtMultimedia.QRadioTuner.setFrequency(self,frequency:int)",
    "PySide2.QtMultimedia.QRadioTuner.setMuted(self,muted:bool)",
    "PySide2.QtMultimedia.QRadioTuner.setStereoMode(self,mode:PySide2.QtMultimedia.QRadioTuner.StereoMode)",
    "PySide2.QtMultimedia.QRadioTuner.setVolume(self,volume:int)",
    "PySide2.QtMultimedia.QRadioTuner.signalStrength(self)->int",
    "PySide2.QtMultimedia.QRadioTuner.start(self)",
    "PySide2.QtMultimedia.QRadioTuner.state(self)->PySide2.QtMultimedia.QRadioTuner.State",
    "PySide2.QtMultimedia.QRadioTuner.stereoMode(self)->PySide2.QtMultimedia.QRadioTuner.StereoMode",
    "PySide2.QtMultimedia.QRadioTuner.stop(self)",
    "PySide2.QtMultimedia.QRadioTuner.volume(self)->int",
    nullptr}; // Sentinel

void init_QRadioTuner(PyObject *module)
{
    _Sbk_QRadioTuner_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRadioTuner",
        "QRadioTuner*",
        &Sbk_QRadioTuner_spec,
        &Shiboken::callCppDestructor< ::QRadioTuner >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRadioTuner_Type);
    InitSignatureStrings(pyType, QRadioTuner_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRadioTuner_Type), Sbk_QRadioTuner_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRadioTuner_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRadioTuner_TypeF(),
        QRadioTuner_PythonToCpp_QRadioTuner_PTR,
        is_QRadioTuner_PythonToCpp_QRadioTuner_PTR_Convertible,
        QRadioTuner_PTR_CppToPython_QRadioTuner);

    Shiboken::Conversions::registerConverterName(converter, "QRadioTuner");
    Shiboken::Conversions::registerConverterName(converter, "QRadioTuner*");
    Shiboken::Conversions::registerConverterName(converter, "QRadioTuner&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRadioTuner).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRadioTunerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QRadioTuner_TypeF(), &Sbk_QRadioTuner_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioTuner_TypeF(),
        "State",
        "2:PySide2.QtMultimedia.QRadioTuner.State",
        "QRadioTuner::State");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX],
        Sbk_QRadioTuner_TypeF(), "ActiveState", (long) QRadioTuner::State::ActiveState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX],
        Sbk_QRadioTuner_TypeF(), "StoppedState", (long) QRadioTuner::State::StoppedState))
        return;
    // Register converter for enum 'QRadioTuner::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX],
            QRadioTuner_State_CppToPython_QRadioTuner_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioTuner_State_PythonToCpp_QRadioTuner_State,
            is_QRadioTuner_State_PythonToCpp_QRadioTuner_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioTuner::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'Band'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioTuner_TypeF(),
        "Band",
        "2:PySide2.QtMultimedia.QRadioTuner.Band",
        "QRadioTuner::Band");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
        Sbk_QRadioTuner_TypeF(), "AM", (long) QRadioTuner::Band::AM))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
        Sbk_QRadioTuner_TypeF(), "FM", (long) QRadioTuner::Band::FM))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
        Sbk_QRadioTuner_TypeF(), "SW", (long) QRadioTuner::Band::SW))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
        Sbk_QRadioTuner_TypeF(), "LW", (long) QRadioTuner::Band::LW))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
        Sbk_QRadioTuner_TypeF(), "FM2", (long) QRadioTuner::Band::FM2))
        return;
    // Register converter for enum 'QRadioTuner::Band'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX],
            QRadioTuner_Band_CppToPython_QRadioTuner_Band);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioTuner_Band_PythonToCpp_QRadioTuner_Band,
            is_QRadioTuner_Band_PythonToCpp_QRadioTuner_Band_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_BAND_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioTuner::Band");
        Shiboken::Conversions::registerConverterName(converter, "Band");
    }
    // End of 'Band' enum.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioTuner_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QRadioTuner.Error",
        "QRadioTuner::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX],
        Sbk_QRadioTuner_TypeF(), "NoError", (long) QRadioTuner::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX],
        Sbk_QRadioTuner_TypeF(), "ResourceError", (long) QRadioTuner::Error::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX],
        Sbk_QRadioTuner_TypeF(), "OpenError", (long) QRadioTuner::Error::OpenError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX],
        Sbk_QRadioTuner_TypeF(), "OutOfRangeError", (long) QRadioTuner::Error::OutOfRangeError))
        return;
    // Register converter for enum 'QRadioTuner::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX],
            QRadioTuner_Error_CppToPython_QRadioTuner_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioTuner_Error_PythonToCpp_QRadioTuner_Error,
            is_QRadioTuner_Error_PythonToCpp_QRadioTuner_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioTuner::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'StereoMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioTuner_TypeF(),
        "StereoMode",
        "2:PySide2.QtMultimedia.QRadioTuner.StereoMode",
        "QRadioTuner::StereoMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX],
        Sbk_QRadioTuner_TypeF(), "ForceStereo", (long) QRadioTuner::StereoMode::ForceStereo))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX],
        Sbk_QRadioTuner_TypeF(), "ForceMono", (long) QRadioTuner::StereoMode::ForceMono))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX],
        Sbk_QRadioTuner_TypeF(), "Auto", (long) QRadioTuner::StereoMode::Auto))
        return;
    // Register converter for enum 'QRadioTuner::StereoMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX],
            QRadioTuner_StereoMode_CppToPython_QRadioTuner_StereoMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioTuner_StereoMode_PythonToCpp_QRadioTuner_StereoMode,
            is_QRadioTuner_StereoMode_PythonToCpp_QRadioTuner_StereoMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_STEREOMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioTuner::StereoMode");
        Shiboken::Conversions::registerConverterName(converter, "StereoMode");
    }
    // End of 'StereoMode' enum.

    // Initialization of enum 'SearchMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRadioTuner_TypeF(),
        "SearchMode",
        "2:PySide2.QtMultimedia.QRadioTuner.SearchMode",
        "QRadioTuner::SearchMode");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX],
        Sbk_QRadioTuner_TypeF(), "SearchFast", (long) QRadioTuner::SearchMode::SearchFast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX],
        Sbk_QRadioTuner_TypeF(), "SearchGetStationId", (long) QRadioTuner::SearchMode::SearchGetStationId))
        return;
    // Register converter for enum 'QRadioTuner::SearchMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX],
            QRadioTuner_SearchMode_CppToPython_QRadioTuner_SearchMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRadioTuner_SearchMode_PythonToCpp_QRadioTuner_SearchMode,
            is_QRadioTuner_SearchMode_PythonToCpp_QRadioTuner_SearchMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QRADIOTUNER_SEARCHMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRadioTuner::SearchMode");
        Shiboken::Conversions::registerConverterName(converter, "SearchMode");
    }
    // End of 'SearchMode' enum.

    PySide::Signal::registerSignals(Sbk_QRadioTuner_TypeF(), &::QRadioTuner::staticMetaObject);
    qRegisterMetaType< ::QRadioTuner::State >("QRadioTuner::State");
    qRegisterMetaType< ::QRadioTuner::Band >("QRadioTuner::Band");
    qRegisterMetaType< ::QRadioTuner::Error >("QRadioTuner::Error");
    qRegisterMetaType< ::QRadioTuner::StereoMode >("QRadioTuner::StereoMode");
    qRegisterMetaType< ::QRadioTuner::SearchMode >("QRadioTuner::SearchMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QRadioTuner_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QRadioTuner_TypeF(), &::QRadioTuner::staticMetaObject, sizeof(QRadioTunerWrapper));
}
