/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qlocalserver_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QLocalServerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QLocalServerWrapper::QLocalServerWrapper(::QObject * parent) : QLocalServer(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QLocalServerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QLocalServerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QLocalServerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QLocalServerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QLocalServerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLocalServer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QLocalServerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLocalServer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QLocalServerWrapper::hasPendingConnections() const
{
    if (m_PyMethodCache[6])
        return this->::QLocalServer::hasPendingConnections();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasPendingConnections";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QLocalServer::hasPendingConnections();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLocalServer.hasPendingConnections", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLocalServerWrapper::incomingConnection(::quintptr socketDescriptor)
{
    if (m_PyMethodCache[7]) {
        return this->::QLocalServer::incomingConnection(socketDescriptor);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "incomingConnection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QLocalServer::incomingConnection(socketDescriptor);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], &socketDescriptor)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QLocalSocket * QLocalServerWrapper::nextPendingConnection()
{
    if (m_PyMethodCache[9])
        return this->::QLocalServer::nextPendingConnection();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nextPendingConnection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QLocalServer::nextPendingConnection();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QLOCALSOCKET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLocalServer.nextPendingConnection", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLocalSocket >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLocalSocket *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLocalServerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[10]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QLocalServerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QLocalServer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QLocalServerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QLocalServer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QLocalServerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QLocalServerWrapper *>(this));
        return QLocalServer::qt_metacast(_clname);
}

QLocalServerWrapper::~QLocalServerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLocalServer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLocalServer >()))
        return -1;

    ::QLocalServerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QLocalServer", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QLocalServer::QLocalServer(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QLocalServer(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QLocalServer(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QLocalServer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QLocalServer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QLocalServer(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QLocalServerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QLocalServerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLocalServer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLocalServer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QLocalServer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QLocalServer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLocalServerFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QLocalServerFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QLocalServer *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_fullServerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.fullServerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fullServerName()const
            QString cppResult = const_cast<const ::QLocalServer *>(cppSelf)->fullServerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_hasPendingConnections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.hasPendingConnections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasPendingConnections()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLocalServer *>(cppSelf)->::QLocalServer::hasPendingConnections()
                : const_cast<const ::QLocalServer *>(cppSelf)->hasPendingConnections();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_incomingConnection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.incomingConnection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocalServer::incomingConnection(quintptr)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], (pyArg)))) {
        overloadId = 0; // incomingConnection(quintptr)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_incomingConnection_TypeError;

    // Call function/method
    {
        ::quintptr cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // incomingConnection(quintptr)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLocalServer::incomingConnection(cppArg0)
                : cppSelf->incomingConnection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocalServerFunc_incomingConnection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocalServerFunc_isListening(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.isListening";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isListening()const
            bool cppResult = const_cast<const ::QLocalServer *>(cppSelf)->isListening();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_listen(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.listen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocalServer::listen(QString)
    // 1: QLocalServer::listen(qintptr)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], (pyArg)))) {
        overloadId = 1; // listen(qintptr)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // listen(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_listen_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // listen(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // listen(QString)
                bool cppResult = cppSelf->listen(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // listen(qintptr socketDescriptor)
        {
            ::qintptr cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // listen(qintptr)
                bool cppResult = cppSelf->listen(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocalServerFunc_listen_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocalServerFunc_maxPendingConnections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.maxPendingConnections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxPendingConnections()const
            int cppResult = const_cast<const ::QLocalServer *>(cppSelf)->maxPendingConnections();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_nextPendingConnection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.nextPendingConnection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextPendingConnection()
            QLocalSocket * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLocalServer::nextPendingConnection()
                : cppSelf->nextPendingConnection();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QLOCALSOCKET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_removeServer(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.removeServer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QLocalServer::removeServer(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // removeServer(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_removeServer_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeServer(QString)
            bool cppResult = ::QLocalServer::removeServer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocalServerFunc_removeServer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocalServerFunc_serverError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.serverError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverError()const
            QAbstractSocket::SocketError cppResult = const_cast<const ::QLocalServer *>(cppSelf)->serverError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_SOCKETERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_serverName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.serverName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverName()const
            QString cppResult = const_cast<const ::QLocalServer *>(cppSelf)->serverName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_setMaxPendingConnections(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.setMaxPendingConnections";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocalServer::setMaxPendingConnections(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxPendingConnections(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_setMaxPendingConnections_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxPendingConnections(int)
            cppSelf->setMaxPendingConnections(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocalServerFunc_setMaxPendingConnections_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocalServerFunc_setSocketOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.setSocketOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocalServer::setSocketOptions(QFlags<QLocalServer::SocketOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSocketOptions(QFlags<QLocalServer::SocketOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_setSocketOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QLocalServer::SocketOption> cppArg0 = QFlags<QLocalServer::SocketOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSocketOptions(QFlags<QLocalServer::SocketOption>)
            cppSelf->setSocketOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLocalServerFunc_setSocketOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLocalServerFunc_socketDescriptor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.socketDescriptor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // socketDescriptor()const
            qintptr cppResult = const_cast<const ::QLocalServer *>(cppSelf)->socketDescriptor();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_socketOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.socketOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // socketOptions()const
            QFlags<QLocalServer::SocketOption> cppResult = const_cast<const ::QLocalServer *>(cppSelf)->socketOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLocalServerFunc_waitForNewConnection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QLocalServer.waitForNewConnection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLocalServer::waitForNewConnection(int,bool*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // waitForNewConnection(int,bool*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLocalServerFunc_waitForNewConnection_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForNewConnection(int,bool*)
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            bool retval_ = cppSelf->waitForNewConnection(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLocalServerFunc_waitForNewConnection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QLocalServer_PropertyStrings[] = {
    "socketOptions::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLocalServer_methods[] = {
    {"close", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_close), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_errorString), METH_NOARGS},
    {"fullServerName", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_fullServerName), METH_NOARGS},
    {"hasPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_hasPendingConnections), METH_NOARGS},
    {"incomingConnection", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_incomingConnection), METH_O},
    {"isListening", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_isListening), METH_NOARGS},
    {"listen", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_listen), METH_O},
    {"maxPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_maxPendingConnections), METH_NOARGS},
    {"nextPendingConnection", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_nextPendingConnection), METH_NOARGS},
    {"removeServer", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_removeServer), METH_O|METH_STATIC},
    {"serverError", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_serverError), METH_NOARGS},
    {"serverName", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_serverName), METH_NOARGS},
    {"setMaxPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_setMaxPendingConnections), METH_O},
    {"setSocketOptions", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_setSocketOptions), METH_O},
    {"socketDescriptor", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_socketDescriptor), METH_NOARGS},
    {"socketOptions", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_socketOptions), METH_NOARGS},
    {"waitForNewConnection", reinterpret_cast<PyCFunction>(Sbk_QLocalServerFunc_waitForNewConnection), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QLocalServer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QLocalServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QLocalServerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QLocalServer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLocalServer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLocalServer_Type = nullptr;
static SbkObjectType *Sbk_QLocalServer_TypeF(void)
{
    return _Sbk_QLocalServer_Type;
}

static PyType_Slot Sbk_QLocalServer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QLocalServer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLocalServer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLocalServer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLocalServer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLocalServer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLocalServer_spec = {
    "2:PySide2.QtNetwork.QLocalServer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLocalServer_slots
};

} //extern "C"

static void *Sbk_QLocalServer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QLocalServer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtNetwork_QLocalServer_SocketOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QLocalServer::SocketOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QLocalServer_SocketOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QLocalServer::SocketOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QLocalServer_SocketOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QLocalServer::SocketOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QLocalServer::SocketOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QLocalServer::SocketOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QLocalServer_SocketOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QLocalServer::SocketOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, self, &cppSelf);
    ::QLocalServer::SocketOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QLocalServer_SocketOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QLocalServer_SocketOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QLocalServer_SocketOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QLocalServer_SocketOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QLocalServer_SocketOption_PythonToCpp_QLocalServer_SocketOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLocalServer::SocketOption *>(cppOut) =
        static_cast<::QLocalServer::SocketOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLocalServer_SocketOption_PythonToCpp_QLocalServer_SocketOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX]))
        return QLocalServer_SocketOption_PythonToCpp_QLocalServer_SocketOption;
    return {};
}
static PyObject *QLocalServer_SocketOption_CppToPython_QLocalServer_SocketOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLocalServer::SocketOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX], castCppIn);

}

static void QFlags_QLocalServer_SocketOption__PythonToCpp_QFlags_QLocalServer_SocketOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocalServer::SocketOption> *>(cppOut) =
        ::QFlags<QLocalServer::SocketOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QLocalServer_SocketOption__PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX]))
        return QFlags_QLocalServer_SocketOption__PythonToCpp_QFlags_QLocalServer_SocketOption_;
    return {};
}
static PyObject *QFlags_QLocalServer_SocketOption__CppToPython_QFlags_QLocalServer_SocketOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QLocalServer::SocketOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX]));

}

static void QLocalServer_SocketOption_PythonToCpp_QFlags_QLocalServer_SocketOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QLocalServer::SocketOption> *>(cppOut) =
        ::QFlags<QLocalServer::SocketOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QLocalServer_SocketOption_PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX]))
        return QLocalServer_SocketOption_PythonToCpp_QFlags_QLocalServer_SocketOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QLocalServer_SocketOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QLocalServer::SocketOption> *>(cppOut) =
        ::QFlags<QLocalServer::SocketOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX]))
        return number_PythonToCpp_QFlags_QLocalServer_SocketOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLocalServer_PythonToCpp_QLocalServer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLocalServer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLocalServer_PythonToCpp_QLocalServer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLocalServer_TypeF())))
        return QLocalServer_PythonToCpp_QLocalServer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLocalServer_PTR_CppToPython_QLocalServer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QLocalServer *>(const_cast<void *>(cppIn)), Sbk_QLocalServer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLocalServer_SignatureStrings[] = {
    "PySide2.QtNetwork.QLocalServer(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QLocalServer.close(self)",
    "PySide2.QtNetwork.QLocalServer.errorString(self)->QString",
    "PySide2.QtNetwork.QLocalServer.fullServerName(self)->QString",
    "PySide2.QtNetwork.QLocalServer.hasPendingConnections(self)->bool",
    "PySide2.QtNetwork.QLocalServer.incomingConnection(self,socketDescriptor:quintptr)",
    "PySide2.QtNetwork.QLocalServer.isListening(self)->bool",
    "1:PySide2.QtNetwork.QLocalServer.listen(self,name:QString)->bool",
    "0:PySide2.QtNetwork.QLocalServer.listen(self,socketDescriptor:qintptr)->bool",
    "PySide2.QtNetwork.QLocalServer.maxPendingConnections(self)->int",
    "PySide2.QtNetwork.QLocalServer.nextPendingConnection(self)->PySide2.QtNetwork.QLocalSocket",
    "PySide2.QtNetwork.QLocalServer.removeServer(name:QString)->bool",
    "PySide2.QtNetwork.QLocalServer.serverError(self)->PySide2.QtNetwork.QAbstractSocket.SocketError",
    "PySide2.QtNetwork.QLocalServer.serverName(self)->QString",
    "PySide2.QtNetwork.QLocalServer.setMaxPendingConnections(self,numConnections:int)",
    "PySide2.QtNetwork.QLocalServer.setSocketOptions(self,options:PySide2.QtNetwork.QLocalServer.SocketOptions)",
    "PySide2.QtNetwork.QLocalServer.socketDescriptor(self)->qintptr",
    "PySide2.QtNetwork.QLocalServer.socketOptions(self)->PySide2.QtNetwork.QLocalServer.SocketOptions",
    "PySide2.QtNetwork.QLocalServer.waitForNewConnection(self,msec:int,timedOut:bool*)->bool",
    nullptr}; // Sentinel

void init_QLocalServer(PyObject *module)
{
    _Sbk_QLocalServer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLocalServer",
        "QLocalServer*",
        &Sbk_QLocalServer_spec,
        &Shiboken::callCppDestructor< ::QLocalServer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLocalServer_Type);
    InitSignatureStrings(pyType, QLocalServer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLocalServer_Type), Sbk_QLocalServer_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLocalServer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLocalServer_TypeF(),
        QLocalServer_PythonToCpp_QLocalServer_PTR,
        is_QLocalServer_PythonToCpp_QLocalServer_PTR_Convertible,
        QLocalServer_PTR_CppToPython_QLocalServer);

    Shiboken::Conversions::registerConverterName(converter, "QLocalServer");
    Shiboken::Conversions::registerConverterName(converter, "QLocalServer*");
    Shiboken::Conversions::registerConverterName(converter, "QLocalServer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLocalServer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLocalServerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QLocalServer_TypeF(), &Sbk_QLocalServer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SocketOption'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QLocalServer.SocketOptions", SbkPySide2_QtNetwork_QLocalServer_SocketOption_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLocalServer_TypeF(),
        "SocketOption",
        "2:PySide2.QtNetwork.QLocalServer.SocketOption",
        "QLocalServer::SocketOption",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
        Sbk_QLocalServer_TypeF(), "NoOptions", (long) QLocalServer::SocketOption::NoOptions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
        Sbk_QLocalServer_TypeF(), "UserAccessOption", (long) QLocalServer::SocketOption::UserAccessOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
        Sbk_QLocalServer_TypeF(), "GroupAccessOption", (long) QLocalServer::SocketOption::GroupAccessOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
        Sbk_QLocalServer_TypeF(), "OtherAccessOption", (long) QLocalServer::SocketOption::OtherAccessOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
        Sbk_QLocalServer_TypeF(), "WorldAccessOption", (long) QLocalServer::SocketOption::WorldAccessOption))
        return;
    // Register converter for enum 'QLocalServer::SocketOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX],
            QLocalServer_SocketOption_CppToPython_QLocalServer_SocketOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocalServer_SocketOption_PythonToCpp_QLocalServer_SocketOption,
            is_QLocalServer_SocketOption_PythonToCpp_QLocalServer_SocketOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QLOCALSERVER_SOCKETOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocalServer::SocketOption");
        Shiboken::Conversions::registerConverterName(converter, "SocketOption");
    }
    // Register converter for flag 'QFlags<QLocalServer::SocketOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX],
            QFlags_QLocalServer_SocketOption__CppToPython_QFlags_QLocalServer_SocketOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLocalServer_SocketOption_PythonToCpp_QFlags_QLocalServer_SocketOption_,
            is_QLocalServer_SocketOption_PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QLocalServer_SocketOption__PythonToCpp_QFlags_QLocalServer_SocketOption_,
            is_QFlags_QLocalServer_SocketOption__PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QLocalServer_SocketOption_,
            is_number_PythonToCpp_QFlags_QLocalServer_SocketOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QLOCALSERVER_SOCKETOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLocalServer::SocketOptions");
        Shiboken::Conversions::registerConverterName(converter, "SocketOptions");
    }
    // End of 'SocketOption' enum/flags.

    PySide::Signal::registerSignals(Sbk_QLocalServer_TypeF(), &::QLocalServer::staticMetaObject);
    qRegisterMetaType< ::QLocalServer::SocketOption >("QLocalServer::SocketOption");
    qRegisterMetaType< ::QLocalServer::SocketOptions >("QLocalServer::SocketOptions");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QLocalServer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QLocalServer_TypeF(), &::QLocalServer::staticMetaObject, sizeof(QLocalServerWrapper));
}
