/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QLOCALSOCKETWRAPPER_H
#define SBK_QLOCALSOCKETWRAPPER_H

#define protected public

#include <QtNetwork/qlocalsocket.h>


// Extra includes
#include <qobject.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
namespace PySide { class DynamicQMetaObject; }

class QLocalSocketWrapper : public QLocalSocket
{
public:
    QLocalSocketWrapper(::QObject * parent = nullptr);
    bool atEnd() const override;
    qint64 bytesAvailable() const override;
    qint64 bytesToWrite() const override;
    bool canReadLine() const override;
    void childEvent(::QChildEvent * event) override;
    void close() override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool isSequential() const override;
    const ::QMetaObject * metaObject() const override;
    bool open(::QFlags<QIODevice::OpenModeFlag> openMode = QIODevice::ReadWrite) override;
    qint64 pos() const override;
    qint64 readData(char * arg__1, qint64 arg__2) override;
    qint64 readLineData(char * data, qint64 maxlen) override;
    bool reset() override;
    bool seek(qint64 pos) override;
    qint64 size() const override;
    void timerEvent(::QTimerEvent * event) override;
    bool waitForBytesWritten(int msecs = 30000) override;
    bool waitForReadyRead(int msecs = 30000) override;
    qint64 writeData(const char * arg__1, qint64 arg__2) override;
    ~QLocalSocketWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[24];
};

#endif // SBK_QLOCALSOCKETWRAPPER_H

