/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkconfigurationmanager_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNetworkConfigurationManagerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNetworkConfigurationManagerWrapper::QNetworkConfigurationManagerWrapper(::QObject * parent) : QNetworkConfigurationManager(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QNetworkConfigurationManagerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkConfigurationManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNetworkConfigurationManagerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkConfigurationManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QNetworkConfigurationManagerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkConfigurationManager.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QNetworkConfigurationManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkConfigurationManager.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QNetworkConfigurationManagerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QNetworkConfigurationManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QNetworkConfigurationManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QNetworkConfigurationManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QNetworkConfigurationManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QNetworkConfigurationManagerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QNetworkConfigurationManagerWrapper *>(this));
        return QNetworkConfigurationManager::qt_metacast(_clname);
}

QNetworkConfigurationManagerWrapper::~QNetworkConfigurationManagerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkConfigurationManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkConfigurationManager >()))
        return -1;

    ::QNetworkConfigurationManagerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QNetworkConfigurationManager", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkConfigurationManager::QNetworkConfigurationManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkConfigurationManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QNetworkConfigurationManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfigurationManager_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkConfigurationManager_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QNetworkConfigurationManager_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QNetworkConfigurationManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QNetworkConfigurationManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QNetworkConfigurationManagerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkConfigurationManager >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkConfigurationManager_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QNetworkConfigurationManager_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QNetworkConfigurationManager_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_allConfigurations(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.allConfigurations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:allConfigurations", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkConfigurationManager::allConfigurations(QFlags<QNetworkConfiguration::StateFlag>)const
    if (numArgs == 0) {
        overloadId = 0; // allConfigurations(QFlags<QNetworkConfiguration::StateFlag>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // allConfigurations(QFlags<QNetworkConfiguration::StateFlag>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_flags = Shiboken::String::createStaticString("flags");
            if (PyDict_Contains(kwds, key_flags)) {
                value = PyDict_GetItem(kwds, key_flags);
                if (value && pyArgs[0]) {
                    errInfo = key_flags;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATION_STATEFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_flags);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError;
            }
        }
        ::QFlags<QNetworkConfiguration::StateFlag> cppArg0 = QNetworkConfiguration::StateFlags();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // allConfigurations(QFlags<QNetworkConfiguration::StateFlag>)const
            QList<QNetworkConfiguration > cppResult = const_cast<const ::QNetworkConfigurationManager *>(cppSelf)->allConfigurations(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCONFIGURATION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkConfigurationManagerFunc_allConfigurations_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_capabilities(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.capabilities";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capabilities()const
            QFlags<QNetworkConfigurationManager::Capability> cppResult = const_cast<const ::QNetworkConfigurationManager *>(cppSelf)->capabilities();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_configurationFromIdentifier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.configurationFromIdentifier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkConfigurationManager::configurationFromIdentifier(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // configurationFromIdentifier(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkConfigurationManagerFunc_configurationFromIdentifier_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // configurationFromIdentifier(QString)const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkConfigurationManager *>(cppSelf)->configurationFromIdentifier(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkConfigurationManagerFunc_configurationFromIdentifier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_defaultConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.defaultConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultConfiguration()const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkConfigurationManager *>(cppSelf)->defaultConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_isOnline(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.isOnline";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOnline()const
            bool cppResult = const_cast<const ::QNetworkConfigurationManager *>(cppSelf)->isOnline();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkConfigurationManagerFunc_updateConfigurations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkConfigurationManager.updateConfigurations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateConfigurations()
            cppSelf->updateConfigurations();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QNetworkConfigurationManager_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkConfigurationManager_methods[] = {
    {"allConfigurations", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_allConfigurations), METH_VARARGS|METH_KEYWORDS},
    {"capabilities", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_capabilities), METH_NOARGS},
    {"configurationFromIdentifier", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_configurationFromIdentifier), METH_O},
    {"defaultConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_defaultConfiguration), METH_NOARGS},
    {"isOnline", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_isOnline), METH_NOARGS},
    {"updateConfigurations", reinterpret_cast<PyCFunction>(Sbk_QNetworkConfigurationManagerFunc_updateConfigurations), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNetworkConfigurationManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QNetworkConfigurationManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNetworkConfigurationManagerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QNetworkConfigurationManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkConfigurationManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkConfigurationManager_Type = nullptr;
static SbkObjectType *Sbk_QNetworkConfigurationManager_TypeF(void)
{
    return _Sbk_QNetworkConfigurationManager_Type;
}

static PyType_Slot Sbk_QNetworkConfigurationManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QNetworkConfigurationManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkConfigurationManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkConfigurationManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkConfigurationManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkConfigurationManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkConfigurationManager_spec = {
    "2:PySide2.QtNetwork.QNetworkConfigurationManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkConfigurationManager_slots
};

} //extern "C"

static void *Sbk_QNetworkConfigurationManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QNetworkConfigurationManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___and__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfigurationManager::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___or__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfigurationManager::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___xor__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfigurationManager::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkConfigurationManager::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___invert__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkConfigurationManager::Capabilities cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, self, &cppSelf);
    ::QNetworkConfigurationManager::Capabilities cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkConfigurationManager_Capability_PythonToCpp_QNetworkConfigurationManager_Capability(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkConfigurationManager::Capability *>(cppOut) =
        static_cast<::QNetworkConfigurationManager::Capability>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkConfigurationManager_Capability_PythonToCpp_QNetworkConfigurationManager_Capability_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]))
        return QNetworkConfigurationManager_Capability_PythonToCpp_QNetworkConfigurationManager_Capability;
    return {};
}
static PyObject *QNetworkConfigurationManager_Capability_CppToPython_QNetworkConfigurationManager_Capability(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkConfigurationManager::Capability *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX], castCppIn);

}

static void QFlags_QNetworkConfigurationManager_Capability__PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkConfigurationManager::Capability> *>(cppOut) =
        ::QFlags<QNetworkConfigurationManager::Capability>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QNetworkConfigurationManager_Capability__PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]))
        return QFlags_QNetworkConfigurationManager_Capability__PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_;
    return {};
}
static PyObject *QFlags_QNetworkConfigurationManager_Capability__CppToPython_QFlags_QNetworkConfigurationManager_Capability_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QNetworkConfigurationManager::Capability> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]));

}

static void QNetworkConfigurationManager_Capability_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkConfigurationManager::Capability> *>(cppOut) =
        ::QFlags<QNetworkConfigurationManager::Capability>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QNetworkConfigurationManager_Capability_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]))
        return QNetworkConfigurationManager_Capability_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_;
    return {};
}
static void number_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QNetworkConfigurationManager::Capability> *>(cppOut) =
        ::QFlags<QNetworkConfigurationManager::Capability>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]))
        return number_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkConfigurationManager_PythonToCpp_QNetworkConfigurationManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkConfigurationManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkConfigurationManager_PythonToCpp_QNetworkConfigurationManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkConfigurationManager_TypeF())))
        return QNetworkConfigurationManager_PythonToCpp_QNetworkConfigurationManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkConfigurationManager_PTR_CppToPython_QNetworkConfigurationManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QNetworkConfigurationManager *>(const_cast<void *>(cppIn)), Sbk_QNetworkConfigurationManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkConfigurationManager_SignatureStrings[] = {
    "PySide2.QtNetwork.QNetworkConfigurationManager(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QNetworkConfigurationManager.allConfigurations(self,flags:PySide2.QtNetwork.QNetworkConfiguration.StateFlags=QNetworkConfiguration.StateFlags())->QList[PySide2.QtNetwork.QNetworkConfiguration]",
    "PySide2.QtNetwork.QNetworkConfigurationManager.capabilities(self)->PySide2.QtNetwork.QNetworkConfigurationManager.Capabilities",
    "PySide2.QtNetwork.QNetworkConfigurationManager.configurationFromIdentifier(self,identifier:QString)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkConfigurationManager.defaultConfiguration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkConfigurationManager.isOnline(self)->bool",
    "PySide2.QtNetwork.QNetworkConfigurationManager.updateConfigurations(self)",
    nullptr}; // Sentinel

void init_QNetworkConfigurationManager(PyObject *module)
{
    _Sbk_QNetworkConfigurationManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkConfigurationManager",
        "QNetworkConfigurationManager*",
        &Sbk_QNetworkConfigurationManager_spec,
        &Shiboken::callCppDestructor< ::QNetworkConfigurationManager >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkConfigurationManager_Type);
    InitSignatureStrings(pyType, QNetworkConfigurationManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkConfigurationManager_Type), Sbk_QNetworkConfigurationManager_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkConfigurationManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkConfigurationManager_TypeF(),
        QNetworkConfigurationManager_PythonToCpp_QNetworkConfigurationManager_PTR,
        is_QNetworkConfigurationManager_PythonToCpp_QNetworkConfigurationManager_PTR_Convertible,
        QNetworkConfigurationManager_PTR_CppToPython_QNetworkConfigurationManager);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfigurationManager");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfigurationManager*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkConfigurationManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkConfigurationManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkConfigurationManagerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QNetworkConfigurationManager_TypeF(), &Sbk_QNetworkConfigurationManager_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Capability'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QNetworkConfigurationManager.Capabilities", SbkPySide2_QtNetwork_QNetworkConfigurationManager_Capability_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkConfigurationManager_TypeF(),
        "Capability",
        "2:PySide2.QtNetwork.QNetworkConfigurationManager.Capability",
        "QNetworkConfigurationManager::Capability",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "CanStartAndStopInterfaces", (long) QNetworkConfigurationManager::Capability::CanStartAndStopInterfaces))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "DirectConnectionRouting", (long) QNetworkConfigurationManager::Capability::DirectConnectionRouting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "SystemSessionSupport", (long) QNetworkConfigurationManager::Capability::SystemSessionSupport))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "ApplicationLevelRoaming", (long) QNetworkConfigurationManager::Capability::ApplicationLevelRoaming))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "ForcedRoaming", (long) QNetworkConfigurationManager::Capability::ForcedRoaming))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "DataStatistics", (long) QNetworkConfigurationManager::Capability::DataStatistics))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
        Sbk_QNetworkConfigurationManager_TypeF(), "NetworkSessionRequired", (long) QNetworkConfigurationManager::Capability::NetworkSessionRequired))
        return;
    // Register converter for enum 'QNetworkConfigurationManager::Capability'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
            QNetworkConfigurationManager_Capability_CppToPython_QNetworkConfigurationManager_Capability);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfigurationManager_Capability_PythonToCpp_QNetworkConfigurationManager_Capability,
            is_QNetworkConfigurationManager_Capability_PythonToCpp_QNetworkConfigurationManager_Capability_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfigurationManager::Capability");
        Shiboken::Conversions::registerConverterName(converter, "Capability");
    }
    // Register converter for flag 'QFlags<QNetworkConfigurationManager::Capability>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX],
            QFlags_QNetworkConfigurationManager_Capability__CppToPython_QFlags_QNetworkConfigurationManager_Capability_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkConfigurationManager_Capability_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_,
            is_QNetworkConfigurationManager_Capability_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QNetworkConfigurationManager_Capability__PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_,
            is_QFlags_QNetworkConfigurationManager_Capability__PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability_,
            is_number_PythonToCpp_QFlags_QNetworkConfigurationManager_Capability__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKCONFIGURATIONMANAGER_CAPABILITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkConfigurationManager::Capabilities");
        Shiboken::Conversions::registerConverterName(converter, "Capabilities");
    }
    // End of 'Capability' enum/flags.

    PySide::Signal::registerSignals(Sbk_QNetworkConfigurationManager_TypeF(), &::QNetworkConfigurationManager::staticMetaObject);
    qRegisterMetaType< ::QNetworkConfigurationManager::Capability >("QNetworkConfigurationManager::Capability");
    qRegisterMetaType< ::QNetworkConfigurationManager::Capabilities >("QNetworkConfigurationManager::Capabilities");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QNetworkConfigurationManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QNetworkConfigurationManager_TypeF(), &::QNetworkConfigurationManager::staticMetaObject, sizeof(QNetworkConfigurationManagerWrapper));
}
