/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkproxyfactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNetworkProxyFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNetworkProxyFactoryWrapper::QNetworkProxyFactoryWrapper() : QNetworkProxyFactory()
{
    resetPyMethodCache();
    // ... middle
}

::QList<QNetworkProxy > QNetworkProxyFactoryWrapper::queryProxy(const ::QNetworkProxyQuery & query)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkProxyFactory.queryProxy()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "queryProxy";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkProxyFactory.queryProxy()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkProxyFactory.queryProxy", "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<QNetworkProxy > cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QNetworkProxyFactoryWrapper::~QNetworkProxyFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkProxyFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QNetworkProxyFactory' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkProxyFactory >()))
        return -1;

    ::QNetworkProxyFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QNetworkProxyFactory()
            cptr = new ::QNetworkProxyFactoryWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkProxyFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_proxyForQuery(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.proxyForQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkProxyFactory::proxyForQuery(QNetworkProxyQuery)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArg)))) {
        overloadId = 0; // proxyForQuery(QNetworkProxyQuery)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFactoryFunc_proxyForQuery_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxyQuery cppArg0_local;
        ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // proxyForQuery(QNetworkProxyQuery)
            QList<QNetworkProxy > cppResult = ::QNetworkProxyFactory::proxyForQuery(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFactoryFunc_proxyForQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_queryProxy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.queryProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:queryProxy", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkProxyFactory::queryProxy(QNetworkProxyQuery)
    if (numArgs == 0) {
        overloadId = 0; // queryProxy(QNetworkProxyQuery)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // queryProxy(QNetworkProxyQuery)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_query = Shiboken::String::createStaticString("query");
            if (PyDict_Contains(kwds, key_query)) {
                value = PyDict_GetItem(kwds, key_query);
                if (value && pyArgs[0]) {
                    errInfo = key_query;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArgs[0]))))
                        goto Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_query);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QNetworkProxyQuery cppArg0_local = QNetworkProxyQuery();
        ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // queryProxy(QNetworkProxyQuery)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QNetworkProxyFactory.queryProxy()' not implemented.");
                return {};
            }
            QList<QNetworkProxy > cppResult = cppSelf->queryProxy(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFactoryFunc_queryProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_setApplicationProxyFactory(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.setApplicationProxyFactory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkProxyFactory::setApplicationProxyFactory(QNetworkProxyFactory*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX]), (pyArg)))) {
        overloadId = 0; // setApplicationProxyFactory(QNetworkProxyFactory*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFactoryFunc_setApplicationProxyFactory_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxyFactory *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setApplicationProxyFactory(QNetworkProxyFactory*)
            ::QNetworkProxyFactory::setApplicationProxyFactory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFactoryFunc_setApplicationProxyFactory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_setUseSystemConfiguration(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.setUseSystemConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkProxyFactory::setUseSystemConfiguration(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setUseSystemConfiguration(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFactoryFunc_setUseSystemConfiguration_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUseSystemConfiguration(bool)
            ::QNetworkProxyFactory::setUseSystemConfiguration(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFactoryFunc_setUseSystemConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.systemProxyForQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:systemProxyForQuery", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: static QNetworkProxyFactory::systemProxyForQuery(QNetworkProxyQuery)
    if (numArgs == 0) {
        overloadId = 0; // systemProxyForQuery(QNetworkProxyQuery)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 0; // systemProxyForQuery(QNetworkProxyQuery)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_query = Shiboken::String::createStaticString("query");
            if (PyDict_Contains(kwds, key_query)) {
                value = PyDict_GetItem(kwds, key_query);
                if (value && pyArgs[0]) {
                    errInfo = key_query;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArgs[0]))))
                        goto Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_query);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QNetworkProxyQuery cppArg0_local = QNetworkProxyQuery();
        ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // systemProxyForQuery(QNetworkProxyQuery)
            QList<QNetworkProxy > cppResult = ::QNetworkProxyFactory::systemProxyForQuery(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFactoryFunc_usesSystemConfiguration(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyFactory.usesSystemConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usesSystemConfiguration()
            bool cppResult = ::QNetworkProxyFactory::usesSystemConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkProxyFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkProxyFactory_methods[] = {
    {"proxyForQuery", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_proxyForQuery), METH_O|METH_STATIC},
    {"queryProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_queryProxy), METH_VARARGS|METH_KEYWORDS},
    {"setApplicationProxyFactory", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_setApplicationProxyFactory), METH_O|METH_STATIC},
    {"setUseSystemConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_setUseSystemConfiguration), METH_O|METH_STATIC},
    {"systemProxyForQuery", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_systemProxyForQuery), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"usesSystemConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFactoryFunc_usesSystemConfiguration), METH_NOARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNetworkProxyFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QNetworkProxyFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNetworkProxyFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QNetworkProxyFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkProxyFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkProxyFactory_Type = nullptr;
static SbkObjectType *Sbk_QNetworkProxyFactory_TypeF(void)
{
    return _Sbk_QNetworkProxyFactory_Type;
}

static PyType_Slot Sbk_QNetworkProxyFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QNetworkProxyFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkProxyFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkProxyFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkProxyFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkProxyFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkProxyFactory_spec = {
    "2:PySide2.QtNetwork.QNetworkProxyFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkProxyFactory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkProxyFactory_PythonToCpp_QNetworkProxyFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkProxyFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkProxyFactory_PythonToCpp_QNetworkProxyFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxyFactory_TypeF())))
        return QNetworkProxyFactory_PythonToCpp_QNetworkProxyFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkProxyFactory_PTR_CppToPython_QNetworkProxyFactory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkProxyFactory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkProxyFactory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkProxyFactory_SignatureStrings[] = {
    "PySide2.QtNetwork.QNetworkProxyFactory(self)",
    "PySide2.QtNetwork.QNetworkProxyFactory.proxyForQuery(query:PySide2.QtNetwork.QNetworkProxyQuery)->QList[PySide2.QtNetwork.QNetworkProxy]",
    "PySide2.QtNetwork.QNetworkProxyFactory.queryProxy(self,query:PySide2.QtNetwork.QNetworkProxyQuery=QNetworkProxyQuery())->QList[PySide2.QtNetwork.QNetworkProxy]",
    "PySide2.QtNetwork.QNetworkProxyFactory.setApplicationProxyFactory(factory:PySide2.QtNetwork.QNetworkProxyFactory)",
    "PySide2.QtNetwork.QNetworkProxyFactory.setUseSystemConfiguration(enable:bool)",
    "PySide2.QtNetwork.QNetworkProxyFactory.systemProxyForQuery(query:PySide2.QtNetwork.QNetworkProxyQuery=QNetworkProxyQuery())->QList[PySide2.QtNetwork.QNetworkProxy]",
    "PySide2.QtNetwork.QNetworkProxyFactory.usesSystemConfiguration()->bool",
    nullptr}; // Sentinel

void init_QNetworkProxyFactory(PyObject *module)
{
    _Sbk_QNetworkProxyFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkProxyFactory",
        "QNetworkProxyFactory*",
        &Sbk_QNetworkProxyFactory_spec,
        &Shiboken::callCppDestructor< ::QNetworkProxyFactory >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxyFactory_Type);
    InitSignatureStrings(pyType, QNetworkProxyFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxyFactory_Type), Sbk_QNetworkProxyFactory_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxyFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkProxyFactory_TypeF(),
        QNetworkProxyFactory_PythonToCpp_QNetworkProxyFactory_PTR,
        is_QNetworkProxyFactory_PythonToCpp_QNetworkProxyFactory_PTR_Convertible,
        QNetworkProxyFactory_PTR_CppToPython_QNetworkProxyFactory);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyFactory");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkProxyFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkProxyFactoryWrapper).name());


}
