/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qsslcertificate_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QMultiMap>
#include <QtNetwork/qsslcertificate.h>
#include <QtNetwork/qsslcertificateextension.h>
#include <QtNetwork/qsslerror.h>
#include <QtNetwork/qsslkey.h>
#include <qbytearray.h>
#include <qdatetime.h>
#include <qiodevice.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslCertificate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslCertificate >()))
        return -1;

    ::QSslCertificate *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificate_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QSslCertificate", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSslCertificate::QSslCertificate(QIODevice*,QSsl::EncodingFormat)
    // 1: QSslCertificate::QSslCertificate(QByteArray,QSsl::EncodingFormat)
    // 2: QSslCertificate::QSslCertificate(QSslCertificate)
    if (numArgs == 0) {
        overloadId = 1; // QSslCertificate(QByteArray,QSsl::EncodingFormat)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QSslCertificate(QByteArray,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QSslCertificate(QByteArray,QSsl::EncodingFormat)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QSslCertificate(QIODevice*,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QSslCertificate(QIODevice*,QSsl::EncodingFormat)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QSslCertificate(QSslCertificate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificate_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslCertificate(QIODevice * device, QSsl::EncodingFormat format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslCertificate_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSslCertificate(QIODevice*,QSsl::EncodingFormat)
                cptr = new ::QSslCertificate(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QSslCertificate(const QByteArray & data, QSsl::EncodingFormat format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_data = Shiboken::String::createStaticString("data");
                if (PyDict_Contains(kwds, key_data)) {
                    value = PyDict_GetItem(kwds, key_data);
                    if (value && pyArgs[0]) {
                        errInfo = key_data;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0]))))
                            goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_data);
                }
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslCertificate_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslCertificate_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local = QByteArray();
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }
            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSslCertificate(QByteArray,QSsl::EncodingFormat)
                cptr = new ::QSslCertificate(*cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QSslCertificate(const QSslCertificate & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSslCertificate_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslCertificate cppArg0_local;
            ::QSslCertificate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslCertificate(QSslCertificate)
                cptr = new ::QSslCertificate(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslCertificate >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslCertificate_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslCertificate_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslCertificateFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSslCertificateFunc_digest(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.digest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_digest_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:digest", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSslCertificate::digest(QCryptographicHash::Algorithm)const
    if (numArgs == 0) {
        overloadId = 0; // digest(QCryptographicHash::Algorithm)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // digest(QCryptographicHash::Algorithm)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_digest_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_algorithm = Shiboken::String::createStaticString("algorithm");
            if (PyDict_Contains(kwds, key_algorithm)) {
                value = PyDict_GetItem(kwds, key_algorithm);
                if (value && pyArgs[0]) {
                    errInfo = key_algorithm;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_digest_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QCRYPTOGRAPHICHASH_ALGORITHM_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QSslCertificateFunc_digest_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_algorithm);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslCertificateFunc_digest_TypeError;
            }
        }
        ::QCryptographicHash::Algorithm cppArg0 = QCryptographicHash::Md5;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // digest(QCryptographicHash::Algorithm)const
            QByteArray cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->digest(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_digest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_effectiveDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.effectiveDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // effectiveDate()const
            QDateTime cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->effectiveDate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_expiryDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.expiryDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expiryDate()const
            QDateTime cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->expiryDate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_extensions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.extensions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // extensions()const
            QList<QSslCertificateExtension > cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->extensions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATEEXTENSION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_fromData(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.fromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromData_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromData_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromData", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSslCertificate::fromData(QByteArray,QSsl::EncodingFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromData(QByteArray,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromData(QByteArray,QSsl::EncodingFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_fromData_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_fromData_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QSslCertificateFunc_fromData_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslCertificateFunc_fromData_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromData(QByteArray,QSsl::EncodingFormat)
            QList<QSslCertificate > cppResult = ::QSslCertificate::fromData(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_fromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_fromDevice(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.fromDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromDevice_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromDevice_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromDevice", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSslCertificate::fromDevice(QIODevice*,QSsl::EncodingFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromDevice(QIODevice*,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromDevice(QIODevice*,QSsl::EncodingFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_fromDevice_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_format = Shiboken::String::createStaticString("format");
            if (PyDict_Contains(kwds, key_format)) {
                value = PyDict_GetItem(kwds, key_format);
                if (value && pyArgs[1]) {
                    errInfo = key_format;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_fromDevice_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QSslCertificateFunc_fromDevice_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_format);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslCertificateFunc_fromDevice_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromDevice(QIODevice*,QSsl::EncodingFormat)
            QList<QSslCertificate > cppResult = ::QSslCertificate::fromDevice(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_fromDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_fromPath(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.fromPath";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromPath_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_fromPath_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:fromPath", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QSslCertificate::fromPath(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
    // 1: static QSslCertificate::fromPath(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // fromPath(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // fromPath(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // fromPath(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
            } else if (numArgs == 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QREGEXP_PATTERNSYNTAX_IDX])->converter, (pyArgs[2])))) {
                overloadId = 0; // fromPath(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_fromPath_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromPath(const QString & path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSslCertificateFunc_fromPath_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::EncodingFormat cppArg1{QSsl::Pem};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QRegExp::PatternSyntax cppArg2{QRegExp::RegExp};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromPath(QString,QSsl::EncodingFormat,QRegExp::PatternSyntax)
                QList<QSslCertificate > cppResult = ::QSslCertificate::fromPath(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QSslCertificate.fromPath(const QString & path, QSsl::EncodingFormat format, QRegExp::PatternSyntax syntax) is deprecated", 1);
            break;
        }
        case 1: // fromPath(const QString & path, QSsl::EncodingFormat format, QSslCertificate::PatternSyntax syntax)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslCertificateFunc_fromPath_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslCertificateFunc_fromPath_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_syntax = Shiboken::String::createStaticString("syntax");
                if (PyDict_Contains(kwds, key_syntax)) {
                    value = PyDict_GetItem(kwds, key_syntax);
                    if (value && pyArgs[2]) {
                        errInfo = key_syntax;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslCertificateFunc_fromPath_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QSslCertificateFunc_fromPath_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_syntax);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslCertificateFunc_fromPath_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSslCertificate::PatternSyntax cppArg2 = QSslCertificate::PatternSyntax::FixedString;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // fromPath(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
                QList<QSslCertificate > cppResult = ::QSslCertificate::fromPath(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_fromPath_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            Qt::HANDLE cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<Qt::HANDLE>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_importPkcs12(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.importPkcs12";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:importPkcs12", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QSslCertificate::importPkcs12(QIODevice*,QSslKey*,QSslCertificate*,QList<QSslCertificate>*,QByteArray)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // importPkcs12(QIODevice*,QSslKey*,QSslCertificate*,QList<QSslCertificate>*,QByteArray)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // importPkcs12(QIODevice*,QSslKey*,QSslCertificate*,QList<QSslCertificate>*,QByteArray)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[4])))) {
                overloadId = 0; // importPkcs12(QIODevice*,QSslKey*,QSslCertificate*,QList<QSslCertificate>*,QByteArray)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_caCertificates = Shiboken::String::createStaticString("caCertificates");
            if (PyDict_Contains(kwds, key_caCertificates)) {
                value = PyDict_GetItem(kwds, key_caCertificates);
                if (value && pyArgs[3]) {
                    errInfo = key_caCertificates;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArgs[3]))))
                        goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caCertificates);
            }
            static PyObject *const key_passPhrase = Shiboken::String::createStaticString("passPhrase");
            if (PyDict_Contains(kwds, key_passPhrase)) {
                value = PyDict_GetItem(kwds, key_passPhrase);
                if (value && pyArgs[4]) {
                    errInfo = key_passPhrase;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[4]))))
                        goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_passPhrase);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslCertificateFunc_importPkcs12_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIODevice *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSslKey *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QSslCertificate *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QList<QSslCertificate > *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QByteArray cppArg4_local = QByteArray();
        ::QByteArray *cppArg4 = &cppArg4_local;
        if (pythonToCpp[4]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[4]))
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);
        }

        if (!PyErr_Occurred()) {
            // importPkcs12(QIODevice*,QSslKey*,QSslCertificate*,QList<QSslCertificate>*,QByteArray)
            bool cppResult = ::QSslCertificate::importPkcs12(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_importPkcs12_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_isBlacklisted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.isBlacklisted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBlacklisted()const
            bool cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->isBlacklisted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_isSelfSigned(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.isSelfSigned";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSelfSigned()const
            bool cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->isSelfSigned();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_issuerDisplayName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.issuerDisplayName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // issuerDisplayName()const
            QString cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->issuerDisplayName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_issuerInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.issuerInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslCertificate::issuerInfo(QSslCertificate::SubjectInfo)const
    // 1: QSslCertificate::issuerInfo(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // issuerInfo(QByteArray)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX])->converter, (pyArg)))) {
        overloadId = 0; // issuerInfo(QSslCertificate::SubjectInfo)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_issuerInfo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // issuerInfo(QSslCertificate::SubjectInfo info) const
        {
            ::QSslCertificate::SubjectInfo cppArg0{QSslCertificate::Organization};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // issuerInfo(QSslCertificate::SubjectInfo)const
                QStringList cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->issuerInfo(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
        case 1: // issuerInfo(const QByteArray & attribute) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // issuerInfo(QByteArray)const
                QStringList cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->issuerInfo(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_issuerInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_issuerInfoAttributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.issuerInfoAttributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // issuerInfoAttributes()const
            QList<QByteArray > cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->issuerInfoAttributes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_publicKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.publicKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // publicKey()const
            QSslKey cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->publicKey();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_serialNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.serialNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serialNumber()const
            QByteArray cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->serialNumber();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_subjectAlternativeNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.subjectAlternativeNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subjectAlternativeNames()const
            QMultiMap<QSsl::AlternativeNameEntryType,QString > cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->subjectAlternativeNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMULTIMAP_QSSL_ALTERNATIVENAMEENTRYTYPE_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_subjectDisplayName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.subjectDisplayName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subjectDisplayName()const
            QString cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->subjectDisplayName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_subjectInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.subjectInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslCertificate::subjectInfo(QSslCertificate::SubjectInfo)const
    // 1: QSslCertificate::subjectInfo(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 1; // subjectInfo(QByteArray)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX])->converter, (pyArg)))) {
        overloadId = 0; // subjectInfo(QSslCertificate::SubjectInfo)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_subjectInfo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // subjectInfo(QSslCertificate::SubjectInfo info) const
        {
            ::QSslCertificate::SubjectInfo cppArg0{QSslCertificate::Organization};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // subjectInfo(QSslCertificate::SubjectInfo)const
                QStringList cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->subjectInfo(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
        case 1: // subjectInfo(const QByteArray & attribute) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // subjectInfo(QByteArray)const
                QStringList cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->subjectInfo(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_subjectInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_subjectInfoAttributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.subjectInfoAttributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subjectInfoAttributes()const
            QList<QByteArray > cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->subjectInfoAttributes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslCertificate::swap(QSslCertificate&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslCertificate&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslCertificate cppArg0_local;
        ::QSslCertificate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslCertificate&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslCertificateFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_toDer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.toDer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDer()const
            QByteArray cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->toDer();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_toPem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.toPem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPem()const
            QByteArray cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->toPem();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_toText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.toText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toText()const
            QString cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->toText();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateFunc_verify(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.verify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_verify_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslCertificateFunc_verify_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:verify", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSslCertificate::verify(QList<QSslCertificate>,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // verify(QList<QSslCertificate>,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // verify(QList<QSslCertificate>,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateFunc_verify_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_hostName = Shiboken::String::createStaticString("hostName");
            if (PyDict_Contains(kwds, key_hostName)) {
                value = PyDict_GetItem(kwds, key_hostName);
                if (value && pyArgs[1]) {
                    errInfo = key_hostName;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslCertificateFunc_verify_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QSslCertificateFunc_verify_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_hostName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslCertificateFunc_verify_TypeError;
            }
        }
        ::QList<QSslCertificate > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // verify(QList<QSslCertificate>,QString)
            QList<QSslError > cppResult = ::QSslCertificate::verify(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLERROR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslCertificateFunc_verify_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificate.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QByteArray cppResult = const_cast<const ::QSslCertificate *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificate___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslCertificate_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslCertificate_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_clear), METH_NOARGS},
    {"digest", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_digest), METH_VARARGS|METH_KEYWORDS},
    {"effectiveDate", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_effectiveDate), METH_NOARGS},
    {"expiryDate", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_expiryDate), METH_NOARGS},
    {"extensions", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_extensions), METH_NOARGS},
    {"fromData", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_fromData), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromDevice", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_fromDevice), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"fromPath", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_fromPath), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_handle), METH_NOARGS},
    {"importPkcs12", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_importPkcs12), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isBlacklisted", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_isBlacklisted), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_isNull), METH_NOARGS},
    {"isSelfSigned", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_isSelfSigned), METH_NOARGS},
    {"issuerDisplayName", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_issuerDisplayName), METH_NOARGS},
    {"issuerInfo", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_issuerInfo), METH_O},
    {"issuerInfoAttributes", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_issuerInfoAttributes), METH_NOARGS},
    {"publicKey", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_publicKey), METH_NOARGS},
    {"serialNumber", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_serialNumber), METH_NOARGS},
    {"subjectAlternativeNames", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_subjectAlternativeNames), METH_NOARGS},
    {"subjectDisplayName", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_subjectDisplayName), METH_NOARGS},
    {"subjectInfo", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_subjectInfo), METH_O},
    {"subjectInfoAttributes", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_subjectInfoAttributes), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_swap), METH_O},
    {"toDer", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_toDer), METH_NOARGS},
    {"toPem", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_toPem), METH_NOARGS},
    {"toText", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_toText), METH_NOARGS},
    {"verify", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_verify), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateFunc_version), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslCertificate___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSslCertificate___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QSslCertificate_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArg)))) {
                // operator!=(const QSslCertificate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslCertificate cppArg0_local;
                ::QSslCertificate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArg)))) {
                // operator==(const QSslCertificate & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslCertificate cppArg0_local;
                ::QSslCertificate *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSslCertificate_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSslCertificate_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSslCertificate_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslCertificate_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSslCertificate__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslCertificate_Type = nullptr;
static SbkObjectType *Sbk_QSslCertificate_TypeF(void)
{
    return _Sbk_QSslCertificate_Type;
}

static PyType_Slot Sbk_QSslCertificate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSslCertificate__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslCertificate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslCertificate_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSslCertificate_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslCertificate_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslCertificate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QSslCertificate___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QSslCertificate___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QSslCertificate_spec = {
    "2:PySide2.QtNetwork.QSslCertificate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslCertificate_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSslCertificate_SubjectInfo_PythonToCpp_QSslCertificate_SubjectInfo(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCertificate::SubjectInfo *>(cppOut) =
        static_cast<::QSslCertificate::SubjectInfo>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSslCertificate_SubjectInfo_PythonToCpp_QSslCertificate_SubjectInfo_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX]))
        return QSslCertificate_SubjectInfo_PythonToCpp_QSslCertificate_SubjectInfo;
    return {};
}
static PyObject *QSslCertificate_SubjectInfo_CppToPython_QSslCertificate_SubjectInfo(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSslCertificate::SubjectInfo *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX], castCppIn);

}

static void QSslCertificate_PatternSyntax_PythonToCpp_QSslCertificate_PatternSyntax(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCertificate::PatternSyntax *>(cppOut) =
        static_cast<::QSslCertificate::PatternSyntax>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSslCertificate_PatternSyntax_PythonToCpp_QSslCertificate_PatternSyntax_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX]))
        return QSslCertificate_PatternSyntax_PythonToCpp_QSslCertificate_PatternSyntax;
    return {};
}
static PyObject *QSslCertificate_PatternSyntax_CppToPython_QSslCertificate_PatternSyntax(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSslCertificate::PatternSyntax *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslCertificate_PythonToCpp_QSslCertificate_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslCertificate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslCertificate_PythonToCpp_QSslCertificate_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificate_TypeF())))
        return QSslCertificate_PythonToCpp_QSslCertificate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslCertificate_PTR_CppToPython_QSslCertificate(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslCertificate *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslCertificate_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslCertificate_COPY_CppToPython_QSslCertificate(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslCertificate_TypeF(), new ::QSslCertificate(*reinterpret_cast<const ::QSslCertificate *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslCertificate_PythonToCpp_QSslCertificate_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCertificate *>(cppOut) = *reinterpret_cast< ::QSslCertificate *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslCertificate_PythonToCpp_QSslCertificate_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificate_TypeF())))
        return QSslCertificate_PythonToCpp_QSslCertificate_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_QIODevicePTR_PythonToCpp_QSslCertificate(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCertificate *>(cppOut) = ::QSslCertificate(reinterpret_cast< ::QIODevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_QIODevicePTR_PythonToCpp_QSslCertificate_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX], pyIn))
        return PySide2_QtCore_QIODevicePTR_PythonToCpp_QSslCertificate;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslCertificate_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QSslCertificate(self,device:PySide2.QtCore.QIODevice,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)",
    "1:PySide2.QtNetwork.QSslCertificate(self,data:PySide2.QtCore.QByteArray=QByteArray(),format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)",
    "0:PySide2.QtNetwork.QSslCertificate(self,other:PySide2.QtNetwork.QSslCertificate)",
    "PySide2.QtNetwork.QSslCertificate.clear(self)",
    "PySide2.QtNetwork.QSslCertificate.digest(self,algorithm:PySide2.QtCore.QCryptographicHash.Algorithm=QCryptographicHash.Md5)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslCertificate.effectiveDate(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtNetwork.QSslCertificate.expiryDate(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtNetwork.QSslCertificate.extensions(self)->QList[PySide2.QtNetwork.QSslCertificateExtension]",
    "PySide2.QtNetwork.QSslCertificate.fromData(data:PySide2.QtCore.QByteArray,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslCertificate.fromDevice(device:PySide2.QtCore.QIODevice,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)->QList[PySide2.QtNetwork.QSslCertificate]",
    "1:PySide2.QtNetwork.QSslCertificate.fromPath(path:QString,format:PySide2.QtNetwork.QSsl.EncodingFormat,syntax:PySide2.QtCore.QRegExp.PatternSyntax)->QList[PySide2.QtNetwork.QSslCertificate]",
    "0:PySide2.QtNetwork.QSslCertificate.fromPath(path:QString,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem,syntax:PySide2.QtNetwork.QSslCertificate.PatternSyntax=PatternSyntax.FixedString)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslCertificate.handle(self)->Qt.HANDLE",
    "PySide2.QtNetwork.QSslCertificate.importPkcs12(device:PySide2.QtCore.QIODevice,key:PySide2.QtNetwork.QSslKey,cert:PySide2.QtNetwork.QSslCertificate,caCertificates:QList[PySide2.QtNetwork.QSslCertificate]=nullptr,passPhrase:PySide2.QtCore.QByteArray=QByteArray())->bool",
    "PySide2.QtNetwork.QSslCertificate.isBlacklisted(self)->bool",
    "PySide2.QtNetwork.QSslCertificate.isNull(self)->bool",
    "PySide2.QtNetwork.QSslCertificate.isSelfSigned(self)->bool",
    "PySide2.QtNetwork.QSslCertificate.issuerDisplayName(self)->QString",
    "1:PySide2.QtNetwork.QSslCertificate.issuerInfo(self,info:PySide2.QtNetwork.QSslCertificate.SubjectInfo)->QStringList",
    "0:PySide2.QtNetwork.QSslCertificate.issuerInfo(self,attribute:PySide2.QtCore.QByteArray)->QStringList",
    "PySide2.QtNetwork.QSslCertificate.issuerInfoAttributes(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtNetwork.QSslCertificate.publicKey(self)->PySide2.QtNetwork.QSslKey",
    "PySide2.QtNetwork.QSslCertificate.serialNumber(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslCertificate.subjectAlternativeNames(self)->QMultiMap[PySide2.QtNetwork.QSsl.AlternativeNameEntryType, QString]",
    "PySide2.QtNetwork.QSslCertificate.subjectDisplayName(self)->QString",
    "1:PySide2.QtNetwork.QSslCertificate.subjectInfo(self,info:PySide2.QtNetwork.QSslCertificate.SubjectInfo)->QStringList",
    "0:PySide2.QtNetwork.QSslCertificate.subjectInfo(self,attribute:PySide2.QtCore.QByteArray)->QStringList",
    "PySide2.QtNetwork.QSslCertificate.subjectInfoAttributes(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtNetwork.QSslCertificate.swap(self,other:PySide2.QtNetwork.QSslCertificate)",
    "PySide2.QtNetwork.QSslCertificate.toDer(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslCertificate.toPem(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslCertificate.toText(self)->QString",
    "PySide2.QtNetwork.QSslCertificate.verify(certificateChain:QList[PySide2.QtNetwork.QSslCertificate],hostName:QString=QString())->QList[PySide2.QtNetwork.QSslError]",
    "PySide2.QtNetwork.QSslCertificate.version(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslCertificate.__copy__()",
    nullptr}; // Sentinel

void init_QSslCertificate(PyObject *module)
{
    _Sbk_QSslCertificate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslCertificate",
        "QSslCertificate",
        &Sbk_QSslCertificate_spec,
        &Shiboken::callCppDestructor< ::QSslCertificate >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslCertificate_Type);
    InitSignatureStrings(pyType, QSslCertificate_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslCertificate_Type), Sbk_QSslCertificate_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificate_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslCertificate_TypeF(),
        QSslCertificate_PythonToCpp_QSslCertificate_PTR,
        is_QSslCertificate_PythonToCpp_QSslCertificate_PTR_Convertible,
        QSslCertificate_PTR_CppToPython_QSslCertificate,
        QSslCertificate_COPY_CppToPython_QSslCertificate);

    Shiboken::Conversions::registerConverterName(converter, "QSslCertificate");
    Shiboken::Conversions::registerConverterName(converter, "QSslCertificate*");
    Shiboken::Conversions::registerConverterName(converter, "QSslCertificate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslCertificate).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslCertificate_PythonToCpp_QSslCertificate_COPY,
        is_QSslCertificate_PythonToCpp_QSslCertificate_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_QIODevicePTR_PythonToCpp_QSslCertificate,
        is_PySide2_QtCore_QIODevicePTR_PythonToCpp_QSslCertificate_Convertible);

    // Initialization of enums.

    // Initialization of enum 'SubjectInfo'.
    SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSslCertificate_TypeF(),
        "SubjectInfo",
        "2:PySide2.QtNetwork.QSslCertificate.SubjectInfo",
        "QSslCertificate::SubjectInfo");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "Organization", (long) QSslCertificate::SubjectInfo::Organization))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "CommonName", (long) QSslCertificate::SubjectInfo::CommonName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "LocalityName", (long) QSslCertificate::SubjectInfo::LocalityName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "OrganizationalUnitName", (long) QSslCertificate::SubjectInfo::OrganizationalUnitName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "CountryName", (long) QSslCertificate::SubjectInfo::CountryName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "StateOrProvinceName", (long) QSslCertificate::SubjectInfo::StateOrProvinceName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "DistinguishedNameQualifier", (long) QSslCertificate::SubjectInfo::DistinguishedNameQualifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "SerialNumber", (long) QSslCertificate::SubjectInfo::SerialNumber))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
        Sbk_QSslCertificate_TypeF(), "EmailAddress", (long) QSslCertificate::SubjectInfo::EmailAddress))
        return;
    // Register converter for enum 'QSslCertificate::SubjectInfo'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX],
            QSslCertificate_SubjectInfo_CppToPython_QSslCertificate_SubjectInfo);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSslCertificate_SubjectInfo_PythonToCpp_QSslCertificate_SubjectInfo,
            is_QSslCertificate_SubjectInfo_PythonToCpp_QSslCertificate_SubjectInfo_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_SUBJECTINFO_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSslCertificate::SubjectInfo");
        Shiboken::Conversions::registerConverterName(converter, "SubjectInfo");
    }
    // End of 'SubjectInfo' enum.

    // Initialization of enum 'PatternSyntax'.
    SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSslCertificate_TypeF(),
        "PatternSyntax",
        "2:PySide2.QtNetwork.QSslCertificate.PatternSyntax",
        "QSslCertificate::PatternSyntax");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX], "RegularExpression", (long) QSslCertificate::PatternSyntax::RegularExpression))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX], "Wildcard", (long) QSslCertificate::PatternSyntax::Wildcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX], "FixedString", (long) QSslCertificate::PatternSyntax::FixedString))
        return;
    // Register converter for enum 'QSslCertificate::PatternSyntax'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX],
            QSslCertificate_PatternSyntax_CppToPython_QSslCertificate_PatternSyntax);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSslCertificate_PatternSyntax_PythonToCpp_QSslCertificate_PatternSyntax,
            is_QSslCertificate_PatternSyntax_PythonToCpp_QSslCertificate_PatternSyntax_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSslCertificate::PatternSyntax");
        Shiboken::Conversions::registerConverterName(converter, "PatternSyntax");
    }
    // End of 'PatternSyntax' enum.

    qRegisterMetaType< ::QSslCertificate::SubjectInfo >("QSslCertificate::SubjectInfo");
    qRegisterMetaType< ::QSslCertificate::PatternSyntax >("QSslCertificate::PatternSyntax");
}
