/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qsslcertificateextension_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qsslcertificateextension.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslCertificateExtension_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslCertificateExtension >()))
        return -1;

    ::QSslCertificateExtension *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSslCertificateExtension", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSslCertificateExtension::QSslCertificateExtension()
    // 1: QSslCertificateExtension::QSslCertificateExtension(QSslCertificateExtension)
    if (numArgs == 0) {
        overloadId = 0; // QSslCertificateExtension()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSslCertificateExtension(QSslCertificateExtension)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateExtension_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslCertificateExtension()
        {

            if (!PyErr_Occurred()) {
                // QSslCertificateExtension()
                cptr = new ::QSslCertificateExtension();
            }
            break;
        }
        case 1: // QSslCertificateExtension(const QSslCertificateExtension & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslCertificateExtension cppArg0_local;
            ::QSslCertificateExtension *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslCertificateExtension(QSslCertificateExtension)
                cptr = new ::QSslCertificateExtension(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslCertificateExtension >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslCertificateExtension_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslCertificateExtension_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslCertificateExtensionFunc_isCritical(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.isCritical";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCritical()const
            bool cppResult = const_cast<const ::QSslCertificateExtension *>(cppSelf)->isCritical();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateExtensionFunc_isSupported(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.isSupported";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSupported()const
            bool cppResult = const_cast<const ::QSslCertificateExtension *>(cppSelf)->isSupported();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateExtensionFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QSslCertificateExtension *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateExtensionFunc_oid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.oid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // oid()const
            QString cppResult = const_cast<const ::QSslCertificateExtension *>(cppSelf)->oid();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateExtensionFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslCertificateExtension::swap(QSslCertificateExtension&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslCertificateExtension&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCertificateExtensionFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslCertificateExtension cppArg0_local;
        ::QSslCertificateExtension *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslCertificateExtension&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslCertificateExtensionFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCertificateExtensionFunc_value(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCertificateExtension.value";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // value()const
            QVariant cppResult = const_cast<const ::QSslCertificateExtension *>(cppSelf)->value();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCertificateExtension___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslCertificateExtension_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslCertificateExtension_methods[] = {
    {"isCritical", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_isCritical), METH_NOARGS},
    {"isSupported", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_isSupported), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_name), METH_NOARGS},
    {"oid", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_oid), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_swap), METH_O},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtensionFunc_value), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslCertificateExtension___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSslCertificateExtension_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslCertificateExtension_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslCertificateExtension_Type = nullptr;
static SbkObjectType *Sbk_QSslCertificateExtension_TypeF(void)
{
    return _Sbk_QSslCertificateExtension_Type;
}

static PyType_Slot Sbk_QSslCertificateExtension_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslCertificateExtension_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslCertificateExtension_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslCertificateExtension_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslCertificateExtension_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSslCertificateExtension_spec = {
    "2:PySide2.QtNetwork.QSslCertificateExtension",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslCertificateExtension_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslCertificateExtension_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificateExtension_TypeF())))
        return QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslCertificateExtension_PTR_CppToPython_QSslCertificateExtension(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslCertificateExtension *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslCertificateExtension_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslCertificateExtension_COPY_CppToPython_QSslCertificateExtension(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslCertificateExtension_TypeF(), new ::QSslCertificateExtension(*reinterpret_cast<const ::QSslCertificateExtension *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCertificateExtension *>(cppOut) = *reinterpret_cast< ::QSslCertificateExtension *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificateExtension_TypeF())))
        return QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslCertificateExtension_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QSslCertificateExtension(self)",
    "0:PySide2.QtNetwork.QSslCertificateExtension(self,other:PySide2.QtNetwork.QSslCertificateExtension)",
    "PySide2.QtNetwork.QSslCertificateExtension.isCritical(self)->bool",
    "PySide2.QtNetwork.QSslCertificateExtension.isSupported(self)->bool",
    "PySide2.QtNetwork.QSslCertificateExtension.name(self)->QString",
    "PySide2.QtNetwork.QSslCertificateExtension.oid(self)->QString",
    "PySide2.QtNetwork.QSslCertificateExtension.swap(self,other:PySide2.QtNetwork.QSslCertificateExtension)",
    "PySide2.QtNetwork.QSslCertificateExtension.value(self)->QVariant",
    "PySide2.QtNetwork.QSslCertificateExtension.__copy__()",
    nullptr}; // Sentinel

void init_QSslCertificateExtension(PyObject *module)
{
    _Sbk_QSslCertificateExtension_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslCertificateExtension",
        "QSslCertificateExtension",
        &Sbk_QSslCertificateExtension_spec,
        &Shiboken::callCppDestructor< ::QSslCertificateExtension >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslCertificateExtension_Type);
    InitSignatureStrings(pyType, QSslCertificateExtension_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslCertificateExtension_Type), Sbk_QSslCertificateExtension_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslCertificateExtension_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslCertificateExtension_TypeF(),
        QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_PTR,
        is_QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_PTR_Convertible,
        QSslCertificateExtension_PTR_CppToPython_QSslCertificateExtension,
        QSslCertificateExtension_COPY_CppToPython_QSslCertificateExtension);

    Shiboken::Conversions::registerConverterName(converter, "QSslCertificateExtension");
    Shiboken::Conversions::registerConverterName(converter, "QSslCertificateExtension*");
    Shiboken::Conversions::registerConverterName(converter, "QSslCertificateExtension&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslCertificateExtension).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_COPY,
        is_QSslCertificateExtension_PythonToCpp_QSslCertificateExtension_COPY_Convertible);

    qRegisterMetaType< ::QSslCertificateExtension >("QSslCertificateExtension");
}
