/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qsslconfiguration_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QMap>
#include <QtNetwork/qsslcertificate.h>
#include <QtNetwork/qsslcipher.h>
#include <QtNetwork/qsslconfiguration.h>
#include <QtNetwork/qssldiffiehellmanparameters.h>
#include <QtNetwork/qsslkey.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslConfiguration_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslConfiguration >()))
        return -1;

    ::QSslConfiguration *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSslConfiguration", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSslConfiguration::QSslConfiguration()
    // 1: QSslConfiguration::QSslConfiguration(QSslConfiguration)
    if (numArgs == 0) {
        overloadId = 0; // QSslConfiguration()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSslConfiguration(QSslConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfiguration_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslConfiguration()
        {

            if (!PyErr_Occurred()) {
                // QSslConfiguration()
                cptr = new ::QSslConfiguration();
            }
            break;
        }
        case 1: // QSslConfiguration(const QSslConfiguration & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslConfiguration cppArg0_local;
            ::QSslConfiguration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslConfiguration(QSslConfiguration)
                cptr = new ::QSslConfiguration(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslConfiguration >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslConfiguration_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslConfiguration_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslConfigurationFunc_addCaCertificate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.addCaCertificate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::addCaCertificate(QSslCertificate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArg)))) {
        overloadId = 0; // addCaCertificate(QSslCertificate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_addCaCertificate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslCertificate cppArg0_local;
        ::QSslCertificate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addCaCertificate(QSslCertificate)
            cppSelf->addCaCertificate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_addCaCertificate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_addCaCertificates(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.addCaCertificates";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:addCaCertificates", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QSslConfiguration::addCaCertificates(QList<QSslCertificate>)
    // 1: QSslConfiguration::addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX])->converter, (pyArgs[2])))) {
                overloadId = 1; // addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArgs[0])))) {
        overloadId = 0; // addCaCertificates(QList<QSslCertificate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addCaCertificates(const QList<QSslCertificate > & certificates)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
            }
            ::QList<QSslCertificate > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // addCaCertificates(QList<QSslCertificate>)
                cppSelf->addCaCertificates(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // addCaCertificates(const QString & path, QSsl::EncodingFormat format, QSslCertificate::PatternSyntax syntax)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                static PyObject *const key_syntax = Shiboken::String::createStaticString("syntax");
                if (PyDict_Contains(kwds, key_syntax)) {
                    value = PyDict_GetItem(kwds, key_syntax);
                    if (value && pyArgs[2]) {
                        errInfo = key_syntax;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_PATTERNSYNTAX_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_syntax);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslConfigurationFunc_addCaCertificates_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSslCertificate::PatternSyntax cppArg2 = QSslCertificate::PatternSyntax::FixedString;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // addCaCertificates(QString,QSsl::EncodingFormat,QSslCertificate::PatternSyntax)
                bool cppResult = cppSelf->addCaCertificates(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslConfigurationFunc_addCaCertificates_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_allowedNextProtocols(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.allowedNextProtocols";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allowedNextProtocols()const
            QList<QByteArray > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->allowedNextProtocols();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_backendConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.backendConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backendConfiguration()const
            QMap<QByteArray,QVariant > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->backendConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_caCertificates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.caCertificates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // caCertificates()const
            QList<QSslCertificate > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->caCertificates();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_ciphers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.ciphers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ciphers()const
            QList<QSslCipher > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->ciphers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_defaultConfiguration(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.defaultConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultConfiguration()
            QSslConfiguration cppResult = ::QSslConfiguration::defaultConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_defaultDtlsConfiguration(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.defaultDtlsConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultDtlsConfiguration()
            QSslConfiguration cppResult = ::QSslConfiguration::defaultDtlsConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_diffieHellmanParameters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.diffieHellmanParameters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // diffieHellmanParameters()const
            QSslDiffieHellmanParameters cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->diffieHellmanParameters();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_dtlsCookieVerificationEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.dtlsCookieVerificationEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtlsCookieVerificationEnabled()const
            bool cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->dtlsCookieVerificationEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_ephemeralServerKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.ephemeralServerKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ephemeralServerKey()const
            QSslKey cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->ephemeralServerKey();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_localCertificate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.localCertificate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localCertificate()const
            QSslCertificate cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->localCertificate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_localCertificateChain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.localCertificateChain";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localCertificateChain()const
            QList<QSslCertificate > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->localCertificateChain();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_nextNegotiatedProtocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.nextNegotiatedProtocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextNegotiatedProtocol()const
            QByteArray cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->nextNegotiatedProtocol();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_nextProtocolNegotiationStatus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.nextProtocolNegotiationStatus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextProtocolNegotiationStatus()const
            QSslConfiguration::NextProtocolNegotiationStatus cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->nextProtocolNegotiationStatus();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_ocspStaplingEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.ocspStaplingEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ocspStaplingEnabled()const
            bool cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->ocspStaplingEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_peerCertificate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.peerCertificate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerCertificate()const
            QSslCertificate cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->peerCertificate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_peerCertificateChain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.peerCertificateChain";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerCertificateChain()const
            QList<QSslCertificate > cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->peerCertificateChain();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_peerVerifyDepth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.peerVerifyDepth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerVerifyDepth()const
            int cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->peerVerifyDepth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_peerVerifyMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.peerVerifyMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerVerifyMode()const
            QSslSocket::PeerVerifyMode cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->peerVerifyMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_preSharedKeyIdentityHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.preSharedKeyIdentityHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preSharedKeyIdentityHint()const
            QByteArray cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->preSharedKeyIdentityHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_privateKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.privateKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // privateKey()const
            QSslKey cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->privateKey();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_protocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.protocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocol()const
            QSsl::SslProtocol cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->protocol();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_sessionCipher(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.sessionCipher";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionCipher()const
            QSslCipher cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->sessionCipher();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_sessionProtocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.sessionProtocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionProtocol()const
            QSsl::SslProtocol cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->sessionProtocol();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_sessionTicket(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.sessionTicket";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionTicket()const
            QByteArray cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->sessionTicket();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_sessionTicketLifeTimeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.sessionTicketLifeTimeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionTicketLifeTimeHint()const
            int cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->sessionTicketLifeTimeHint();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_setAllowedNextProtocols(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setAllowedNextProtocols";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setAllowedNextProtocols(QList<QByteArray>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], (pyArg)))) {
        overloadId = 0; // setAllowedNextProtocols(QList<QByteArray>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setAllowedNextProtocols_TypeError;

    // Call function/method
    {
        ::QList<QByteArray > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAllowedNextProtocols(QList<QByteArray>)
            cppSelf->setAllowedNextProtocols(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setAllowedNextProtocols_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setBackendConfiguration(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setBackendConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setBackendConfiguration", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSslConfiguration::setBackendConfiguration(QMap<QByteArray,QVariant>)
    if (numArgs == 0) {
        overloadId = 0; // setBackendConfiguration(QMap<QByteArray,QVariant>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX], (pyArgs[0])))) {
        overloadId = 0; // setBackendConfiguration(QMap<QByteArray,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_backendConfiguration = Shiboken::String::createStaticString("backendConfiguration");
            if (PyDict_Contains(kwds, key_backendConfiguration)) {
                value = PyDict_GetItem(kwds, key_backendConfiguration);
                if (value && pyArgs[0]) {
                    errInfo = key_backendConfiguration;
                    Py_INCREF(errInfo);
                    goto Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX], (pyArgs[0]))))
                        goto Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_backendConfiguration);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError;
            }
        }
        ::QMap<QByteArray,QVariant > cppArg0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setBackendConfiguration(QMap<QByteArray,QVariant>)
            cppSelf->setBackendConfiguration(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setBackendConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setBackendConfigurationOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setBackendConfigurationOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setBackendConfigurationOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSslConfiguration::setBackendConfigurationOption(QByteArray,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setBackendConfigurationOption(QByteArray,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setBackendConfigurationOption_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setBackendConfigurationOption(QByteArray,QVariant)
            cppSelf->setBackendConfigurationOption(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setBackendConfigurationOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setCaCertificates(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setCaCertificates";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setCaCertificates(QList<QSslCertificate>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArg)))) {
        overloadId = 0; // setCaCertificates(QList<QSslCertificate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setCaCertificates_TypeError;

    // Call function/method
    {
        ::QList<QSslCertificate > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaCertificates(QList<QSslCertificate>)
            cppSelf->setCaCertificates(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setCaCertificates_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setCiphers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setCiphers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setCiphers(QList<QSslCipher>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX], (pyArg)))) {
        overloadId = 0; // setCiphers(QList<QSslCipher>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setCiphers_TypeError;

    // Call function/method
    {
        ::QList<QSslCipher > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCiphers(QList<QSslCipher>)
            cppSelf->setCiphers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setCiphers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setDefaultConfiguration(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setDefaultConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSslConfiguration::setDefaultConfiguration(QSslConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultConfiguration(QSslConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setDefaultConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslConfiguration cppArg0_local;
        ::QSslConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultConfiguration(QSslConfiguration)
            ::QSslConfiguration::setDefaultConfiguration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setDefaultConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setDefaultDtlsConfiguration(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setDefaultDtlsConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSslConfiguration::setDefaultDtlsConfiguration(QSslConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultDtlsConfiguration(QSslConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setDefaultDtlsConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslConfiguration cppArg0_local;
        ::QSslConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultDtlsConfiguration(QSslConfiguration)
            ::QSslConfiguration::setDefaultDtlsConfiguration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setDefaultDtlsConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setDiffieHellmanParameters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setDiffieHellmanParameters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setDiffieHellmanParameters(QSslDiffieHellmanParameters)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), (pyArg)))) {
        overloadId = 0; // setDiffieHellmanParameters(QSslDiffieHellmanParameters)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setDiffieHellmanParameters_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslDiffieHellmanParameters cppArg0_local;
        ::QSslDiffieHellmanParameters *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDiffieHellmanParameters(QSslDiffieHellmanParameters)
            cppSelf->setDiffieHellmanParameters(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setDiffieHellmanParameters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setDtlsCookieVerificationEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setDtlsCookieVerificationEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setDtlsCookieVerificationEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDtlsCookieVerificationEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setDtlsCookieVerificationEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDtlsCookieVerificationEnabled(bool)
            cppSelf->setDtlsCookieVerificationEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setDtlsCookieVerificationEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setLocalCertificate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setLocalCertificate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setLocalCertificate(QSslCertificate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocalCertificate(QSslCertificate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setLocalCertificate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslCertificate cppArg0_local;
        ::QSslCertificate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocalCertificate(QSslCertificate)
            cppSelf->setLocalCertificate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setLocalCertificate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setLocalCertificateChain(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setLocalCertificateChain";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setLocalCertificateChain(QList<QSslCertificate>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], (pyArg)))) {
        overloadId = 0; // setLocalCertificateChain(QList<QSslCertificate>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setLocalCertificateChain_TypeError;

    // Call function/method
    {
        ::QList<QSslCertificate > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLocalCertificateChain(QList<QSslCertificate>)
            cppSelf->setLocalCertificateChain(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setLocalCertificateChain_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setOcspStaplingEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setOcspStaplingEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setOcspStaplingEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOcspStaplingEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setOcspStaplingEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOcspStaplingEnabled(bool)
            cppSelf->setOcspStaplingEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setOcspStaplingEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setPeerVerifyDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setPeerVerifyDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setPeerVerifyDepth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPeerVerifyDepth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setPeerVerifyDepth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerVerifyDepth(int)
            cppSelf->setPeerVerifyDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setPeerVerifyDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setPeerVerifyMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setPeerVerifyMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setPeerVerifyMode(QSslSocket::PeerVerifyMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLSOCKET_PEERVERIFYMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPeerVerifyMode(QSslSocket::PeerVerifyMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setPeerVerifyMode_TypeError;

    // Call function/method
    {
        ::QSslSocket::PeerVerifyMode cppArg0{QSslSocket::VerifyNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerVerifyMode(QSslSocket::PeerVerifyMode)
            cppSelf->setPeerVerifyMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setPeerVerifyMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setPreSharedKeyIdentityHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setPreSharedKeyIdentityHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setPreSharedKeyIdentityHint(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setPreSharedKeyIdentityHint(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setPreSharedKeyIdentityHint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPreSharedKeyIdentityHint(QByteArray)
            cppSelf->setPreSharedKeyIdentityHint(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setPreSharedKeyIdentityHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setPrivateKey(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setPrivateKey";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setPrivateKey(QSslKey)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), (pyArg)))) {
        overloadId = 0; // setPrivateKey(QSslKey)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setPrivateKey_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslKey cppArg0_local;
        ::QSslKey *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLKEY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPrivateKey(QSslKey)
            cppSelf->setPrivateKey(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setPrivateKey_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setProtocol(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setProtocol";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setProtocol(QSsl::SslProtocol)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProtocol(QSsl::SslProtocol)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setProtocol_TypeError;

    // Call function/method
    {
        ::QSsl::SslProtocol cppArg0{QSsl::SslV3};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProtocol(QSsl::SslProtocol)
            cppSelf->setProtocol(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setProtocol_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setSessionTicket(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setSessionTicket";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::setSessionTicket(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // setSessionTicket(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setSessionTicket_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSessionTicket(QByteArray)
            cppSelf->setSessionTicket(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setSessionTicket_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_setSslOption(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.setSslOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSslOption", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSslConfiguration::setSslOption(QSsl::SslOption,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setSslOption(QSsl::SslOption,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_setSslOption_TypeError;

    // Call function/method
    {
        ::QSsl::SslOption cppArg0 = static_cast< ::QSsl::SslOption>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSslOption(QSsl::SslOption,bool)
            cppSelf->setSslOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_setSslOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_supportedCiphers(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.supportedCiphers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedCiphers()
            QList<QSslCipher > cppResult = ::QSslConfiguration::supportedCiphers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::swap(QSslConfiguration&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslConfiguration&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslConfiguration cppArg0_local;
        ::QSslConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslConfiguration&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslConfigurationFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfigurationFunc_systemCaCertificates(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.systemCaCertificates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // systemCaCertificates()
            QList<QSslCertificate > cppResult = ::QSslConfiguration::systemCaCertificates();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslConfigurationFunc_testSslOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslConfiguration.testSslOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslConfiguration::testSslOption(QSsl::SslOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testSslOption(QSsl::SslOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslConfigurationFunc_testSslOption_TypeError;

    // Call function/method
    {
        ::QSsl::SslOption cppArg0 = static_cast< ::QSsl::SslOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testSslOption(QSsl::SslOption)const
            bool cppResult = const_cast<const ::QSslConfiguration *>(cppSelf)->testSslOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslConfigurationFunc_testSslOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslConfiguration___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslConfiguration_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslConfiguration_methods[] = {
    {"addCaCertificate", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_addCaCertificate), METH_O},
    {"addCaCertificates", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_addCaCertificates), METH_VARARGS|METH_KEYWORDS},
    {"allowedNextProtocols", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_allowedNextProtocols), METH_NOARGS},
    {"backendConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_backendConfiguration), METH_NOARGS},
    {"caCertificates", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_caCertificates), METH_NOARGS},
    {"ciphers", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_ciphers), METH_NOARGS},
    {"defaultConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_defaultConfiguration), METH_NOARGS|METH_STATIC},
    {"defaultDtlsConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_defaultDtlsConfiguration), METH_NOARGS|METH_STATIC},
    {"diffieHellmanParameters", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_diffieHellmanParameters), METH_NOARGS},
    {"dtlsCookieVerificationEnabled", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_dtlsCookieVerificationEnabled), METH_NOARGS},
    {"ephemeralServerKey", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_ephemeralServerKey), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_isNull), METH_NOARGS},
    {"localCertificate", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_localCertificate), METH_NOARGS},
    {"localCertificateChain", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_localCertificateChain), METH_NOARGS},
    {"nextNegotiatedProtocol", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_nextNegotiatedProtocol), METH_NOARGS},
    {"nextProtocolNegotiationStatus", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_nextProtocolNegotiationStatus), METH_NOARGS},
    {"ocspStaplingEnabled", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_ocspStaplingEnabled), METH_NOARGS},
    {"peerCertificate", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_peerCertificate), METH_NOARGS},
    {"peerCertificateChain", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_peerCertificateChain), METH_NOARGS},
    {"peerVerifyDepth", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_peerVerifyDepth), METH_NOARGS},
    {"peerVerifyMode", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_peerVerifyMode), METH_NOARGS},
    {"preSharedKeyIdentityHint", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_preSharedKeyIdentityHint), METH_NOARGS},
    {"privateKey", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_privateKey), METH_NOARGS},
    {"protocol", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_protocol), METH_NOARGS},
    {"sessionCipher", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_sessionCipher), METH_NOARGS},
    {"sessionProtocol", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_sessionProtocol), METH_NOARGS},
    {"sessionTicket", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_sessionTicket), METH_NOARGS},
    {"sessionTicketLifeTimeHint", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_sessionTicketLifeTimeHint), METH_NOARGS},
    {"setAllowedNextProtocols", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setAllowedNextProtocols), METH_O},
    {"setBackendConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setBackendConfiguration), METH_VARARGS|METH_KEYWORDS},
    {"setBackendConfigurationOption", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setBackendConfigurationOption), METH_VARARGS},
    {"setCaCertificates", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setCaCertificates), METH_O},
    {"setCiphers", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setCiphers), METH_O},
    {"setDefaultConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setDefaultConfiguration), METH_O|METH_STATIC},
    {"setDefaultDtlsConfiguration", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setDefaultDtlsConfiguration), METH_O|METH_STATIC},
    {"setDiffieHellmanParameters", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setDiffieHellmanParameters), METH_O},
    {"setDtlsCookieVerificationEnabled", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setDtlsCookieVerificationEnabled), METH_O},
    {"setLocalCertificate", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setLocalCertificate), METH_O},
    {"setLocalCertificateChain", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setLocalCertificateChain), METH_O},
    {"setOcspStaplingEnabled", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setOcspStaplingEnabled), METH_O},
    {"setPeerVerifyDepth", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setPeerVerifyDepth), METH_O},
    {"setPeerVerifyMode", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setPeerVerifyMode), METH_O},
    {"setPreSharedKeyIdentityHint", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setPreSharedKeyIdentityHint), METH_O},
    {"setPrivateKey", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setPrivateKey), METH_O},
    {"setProtocol", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setProtocol), METH_O},
    {"setSessionTicket", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setSessionTicket), METH_O},
    {"setSslOption", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_setSslOption), METH_VARARGS},
    {"supportedCiphers", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_supportedCiphers), METH_NOARGS|METH_STATIC},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_swap), METH_O},
    {"systemCaCertificates", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_systemCaCertificates), METH_NOARGS|METH_STATIC},
    {"testSslOption", reinterpret_cast<PyCFunction>(Sbk_QSslConfigurationFunc_testSslOption), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslConfiguration___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSslConfiguration___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QSslConfiguration_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
                // operator!=(const QSslConfiguration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslConfiguration cppArg0_local;
                ::QSslConfiguration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
                // operator==(const QSslConfiguration & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslConfiguration cppArg0_local;
                ::QSslConfiguration *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSslConfiguration_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSslConfiguration_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSslConfiguration_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslConfiguration_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslConfiguration_Type = nullptr;
static SbkObjectType *Sbk_QSslConfiguration_TypeF(void)
{
    return _Sbk_QSslConfiguration_Type;
}

static PyType_Slot Sbk_QSslConfiguration_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslConfiguration_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslConfiguration_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSslConfiguration_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslConfiguration_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslConfiguration_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QSslConfiguration___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QSslConfiguration___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QSslConfiguration_spec = {
    "2:PySide2.QtNetwork.QSslConfiguration",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslConfiguration_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSslConfiguration_NextProtocolNegotiationStatus_PythonToCpp_QSslConfiguration_NextProtocolNegotiationStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslConfiguration::NextProtocolNegotiationStatus *>(cppOut) =
        static_cast<::QSslConfiguration::NextProtocolNegotiationStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSslConfiguration_NextProtocolNegotiationStatus_PythonToCpp_QSslConfiguration_NextProtocolNegotiationStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX]))
        return QSslConfiguration_NextProtocolNegotiationStatus_PythonToCpp_QSslConfiguration_NextProtocolNegotiationStatus;
    return {};
}
static PyObject *QSslConfiguration_NextProtocolNegotiationStatus_CppToPython_QSslConfiguration_NextProtocolNegotiationStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSslConfiguration::NextProtocolNegotiationStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslConfiguration_PythonToCpp_QSslConfiguration_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslConfiguration_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslConfiguration_PythonToCpp_QSslConfiguration_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslConfiguration_TypeF())))
        return QSslConfiguration_PythonToCpp_QSslConfiguration_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslConfiguration_PTR_CppToPython_QSslConfiguration(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslConfiguration *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslConfiguration_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslConfiguration_COPY_CppToPython_QSslConfiguration(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslConfiguration_TypeF(), new ::QSslConfiguration(*reinterpret_cast<const ::QSslConfiguration *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslConfiguration_PythonToCpp_QSslConfiguration_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslConfiguration *>(cppOut) = *reinterpret_cast< ::QSslConfiguration *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslConfiguration_PythonToCpp_QSslConfiguration_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslConfiguration_TypeF())))
        return QSslConfiguration_PythonToCpp_QSslConfiguration_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslConfiguration_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QSslConfiguration(self)",
    "0:PySide2.QtNetwork.QSslConfiguration(self,other:PySide2.QtNetwork.QSslConfiguration)",
    "PySide2.QtNetwork.QSslConfiguration.addCaCertificate(self,certificate:PySide2.QtNetwork.QSslCertificate)",
    "1:PySide2.QtNetwork.QSslConfiguration.addCaCertificates(self,certificates:QList[PySide2.QtNetwork.QSslCertificate])",
    "0:PySide2.QtNetwork.QSslConfiguration.addCaCertificates(self,path:QString,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem,syntax:PySide2.QtNetwork.QSslCertificate.PatternSyntax=QSslCertificate.PatternSyntax.FixedString)->bool",
    "PySide2.QtNetwork.QSslConfiguration.allowedNextProtocols(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtNetwork.QSslConfiguration.backendConfiguration(self)->QMap[PySide2.QtCore.QByteArray, QVariant]",
    "PySide2.QtNetwork.QSslConfiguration.caCertificates(self)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslConfiguration.ciphers(self)->QList[PySide2.QtNetwork.QSslCipher]",
    "PySide2.QtNetwork.QSslConfiguration.defaultConfiguration()->PySide2.QtNetwork.QSslConfiguration",
    "PySide2.QtNetwork.QSslConfiguration.defaultDtlsConfiguration()->PySide2.QtNetwork.QSslConfiguration",
    "PySide2.QtNetwork.QSslConfiguration.diffieHellmanParameters(self)->PySide2.QtNetwork.QSslDiffieHellmanParameters",
    "PySide2.QtNetwork.QSslConfiguration.dtlsCookieVerificationEnabled(self)->bool",
    "PySide2.QtNetwork.QSslConfiguration.ephemeralServerKey(self)->PySide2.QtNetwork.QSslKey",
    "PySide2.QtNetwork.QSslConfiguration.isNull(self)->bool",
    "PySide2.QtNetwork.QSslConfiguration.localCertificate(self)->PySide2.QtNetwork.QSslCertificate",
    "PySide2.QtNetwork.QSslConfiguration.localCertificateChain(self)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslConfiguration.nextNegotiatedProtocol(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslConfiguration.nextProtocolNegotiationStatus(self)->PySide2.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus",
    "PySide2.QtNetwork.QSslConfiguration.ocspStaplingEnabled(self)->bool",
    "PySide2.QtNetwork.QSslConfiguration.peerCertificate(self)->PySide2.QtNetwork.QSslCertificate",
    "PySide2.QtNetwork.QSslConfiguration.peerCertificateChain(self)->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslConfiguration.peerVerifyDepth(self)->int",
    "PySide2.QtNetwork.QSslConfiguration.peerVerifyMode(self)->PySide2.QtNetwork.QSslSocket.PeerVerifyMode",
    "PySide2.QtNetwork.QSslConfiguration.preSharedKeyIdentityHint(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslConfiguration.privateKey(self)->PySide2.QtNetwork.QSslKey",
    "PySide2.QtNetwork.QSslConfiguration.protocol(self)->PySide2.QtNetwork.QSsl.SslProtocol",
    "PySide2.QtNetwork.QSslConfiguration.sessionCipher(self)->PySide2.QtNetwork.QSslCipher",
    "PySide2.QtNetwork.QSslConfiguration.sessionProtocol(self)->PySide2.QtNetwork.QSsl.SslProtocol",
    "PySide2.QtNetwork.QSslConfiguration.sessionTicket(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QSslConfiguration.sessionTicketLifeTimeHint(self)->int",
    "PySide2.QtNetwork.QSslConfiguration.setAllowedNextProtocols(self,protocols:QList[PySide2.QtCore.QByteArray])",
    "PySide2.QtNetwork.QSslConfiguration.setBackendConfiguration(self,backendConfiguration:QMap[PySide2.QtCore.QByteArray, QVariant]=QMap< QByteArray,QVariant >())",
    "PySide2.QtNetwork.QSslConfiguration.setBackendConfigurationOption(self,name:PySide2.QtCore.QByteArray,value:QVariant)",
    "PySide2.QtNetwork.QSslConfiguration.setCaCertificates(self,certificates:QList[PySide2.QtNetwork.QSslCertificate])",
    "PySide2.QtNetwork.QSslConfiguration.setCiphers(self,ciphers:QList[PySide2.QtNetwork.QSslCipher])",
    "PySide2.QtNetwork.QSslConfiguration.setDefaultConfiguration(configuration:PySide2.QtNetwork.QSslConfiguration)",
    "PySide2.QtNetwork.QSslConfiguration.setDefaultDtlsConfiguration(configuration:PySide2.QtNetwork.QSslConfiguration)",
    "PySide2.QtNetwork.QSslConfiguration.setDiffieHellmanParameters(self,dhparams:PySide2.QtNetwork.QSslDiffieHellmanParameters)",
    "PySide2.QtNetwork.QSslConfiguration.setDtlsCookieVerificationEnabled(self,enable:bool)",
    "PySide2.QtNetwork.QSslConfiguration.setLocalCertificate(self,certificate:PySide2.QtNetwork.QSslCertificate)",
    "PySide2.QtNetwork.QSslConfiguration.setLocalCertificateChain(self,localChain:QList[PySide2.QtNetwork.QSslCertificate])",
    "PySide2.QtNetwork.QSslConfiguration.setOcspStaplingEnabled(self,enable:bool)",
    "PySide2.QtNetwork.QSslConfiguration.setPeerVerifyDepth(self,depth:int)",
    "PySide2.QtNetwork.QSslConfiguration.setPeerVerifyMode(self,mode:PySide2.QtNetwork.QSslSocket.PeerVerifyMode)",
    "PySide2.QtNetwork.QSslConfiguration.setPreSharedKeyIdentityHint(self,hint:PySide2.QtCore.QByteArray)",
    "PySide2.QtNetwork.QSslConfiguration.setPrivateKey(self,key:PySide2.QtNetwork.QSslKey)",
    "PySide2.QtNetwork.QSslConfiguration.setProtocol(self,protocol:PySide2.QtNetwork.QSsl.SslProtocol)",
    "PySide2.QtNetwork.QSslConfiguration.setSessionTicket(self,sessionTicket:PySide2.QtCore.QByteArray)",
    "PySide2.QtNetwork.QSslConfiguration.setSslOption(self,option:PySide2.QtNetwork.QSsl.SslOption,on:bool)",
    "PySide2.QtNetwork.QSslConfiguration.supportedCiphers()->QList[PySide2.QtNetwork.QSslCipher]",
    "PySide2.QtNetwork.QSslConfiguration.swap(self,other:PySide2.QtNetwork.QSslConfiguration)",
    "PySide2.QtNetwork.QSslConfiguration.systemCaCertificates()->QList[PySide2.QtNetwork.QSslCertificate]",
    "PySide2.QtNetwork.QSslConfiguration.testSslOption(self,option:PySide2.QtNetwork.QSsl.SslOption)->bool",
    "PySide2.QtNetwork.QSslConfiguration.__copy__()",
    nullptr}; // Sentinel

void init_QSslConfiguration(PyObject *module)
{
    _Sbk_QSslConfiguration_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslConfiguration",
        "QSslConfiguration",
        &Sbk_QSslConfiguration_spec,
        &Shiboken::callCppDestructor< ::QSslConfiguration >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslConfiguration_Type);
    InitSignatureStrings(pyType, QSslConfiguration_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslConfiguration_Type), Sbk_QSslConfiguration_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslConfiguration_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslConfiguration_TypeF(),
        QSslConfiguration_PythonToCpp_QSslConfiguration_PTR,
        is_QSslConfiguration_PythonToCpp_QSslConfiguration_PTR_Convertible,
        QSslConfiguration_PTR_CppToPython_QSslConfiguration,
        QSslConfiguration_COPY_CppToPython_QSslConfiguration);

    Shiboken::Conversions::registerConverterName(converter, "QSslConfiguration");
    Shiboken::Conversions::registerConverterName(converter, "QSslConfiguration*");
    Shiboken::Conversions::registerConverterName(converter, "QSslConfiguration&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslConfiguration).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslConfiguration_PythonToCpp_QSslConfiguration_COPY,
        is_QSslConfiguration_PythonToCpp_QSslConfiguration_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'NextProtocolNegotiationStatus'.
    SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSslConfiguration_TypeF(),
        "NextProtocolNegotiationStatus",
        "2:PySide2.QtNetwork.QSslConfiguration.NextProtocolNegotiationStatus",
        "QSslConfiguration::NextProtocolNegotiationStatus");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX],
        Sbk_QSslConfiguration_TypeF(), "NextProtocolNegotiationNone", (long) QSslConfiguration::NextProtocolNegotiationStatus::NextProtocolNegotiationNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX],
        Sbk_QSslConfiguration_TypeF(), "NextProtocolNegotiationNegotiated", (long) QSslConfiguration::NextProtocolNegotiationStatus::NextProtocolNegotiationNegotiated))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX],
        Sbk_QSslConfiguration_TypeF(), "NextProtocolNegotiationUnsupported", (long) QSslConfiguration::NextProtocolNegotiationStatus::NextProtocolNegotiationUnsupported))
        return;
    // Register converter for enum 'QSslConfiguration::NextProtocolNegotiationStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX],
            QSslConfiguration_NextProtocolNegotiationStatus_CppToPython_QSslConfiguration_NextProtocolNegotiationStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSslConfiguration_NextProtocolNegotiationStatus_PythonToCpp_QSslConfiguration_NextProtocolNegotiationStatus,
            is_QSslConfiguration_NextProtocolNegotiationStatus_PythonToCpp_QSslConfiguration_NextProtocolNegotiationStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_NEXTPROTOCOLNEGOTIATIONSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSslConfiguration::NextProtocolNegotiationStatus");
        Shiboken::Conversions::registerConverterName(converter, "NextProtocolNegotiationStatus");
    }
    // End of 'NextProtocolNegotiationStatus' enum.

    qRegisterMetaType< ::QSslConfiguration >("QSslConfiguration");
    qRegisterMetaType< ::QSslConfiguration::NextProtocolNegotiationStatus >("QSslConfiguration::NextProtocolNegotiationStatus");
}

void init_QSslConfigurationStaticFields()
{
    auto dict = reinterpret_cast<PyTypeObject *>(Sbk_QSslConfiguration_TypeF())->tp_dict;
    PyDict_SetItemString(dict, "ALPNProtocolHTTP2",
                         Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), QSslConfiguration::ALPNProtocolHTTP2));
    PyDict_SetItemString(dict, "NextProtocolSpdy3_0",
                         Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), QSslConfiguration::NextProtocolSpdy3_0));
    PyDict_SetItemString(dict, "NextProtocolHttp1_1",
                         Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), QSslConfiguration::NextProtocolHttp1_1));

}
