/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qssldiffiehellmanparameters_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qssldiffiehellmanparameters.h>
#include <qbytearray.h>
#include <qiodevice.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslDiffieHellmanParameters_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslDiffieHellmanParameters >()))
        return -1;

    ::QSslDiffieHellmanParameters *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSslDiffieHellmanParameters", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSslDiffieHellmanParameters::QSslDiffieHellmanParameters()
    // 1: QSslDiffieHellmanParameters::QSslDiffieHellmanParameters(QSslDiffieHellmanParameters)
    if (numArgs == 0) {
        overloadId = 0; // QSslDiffieHellmanParameters()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSslDiffieHellmanParameters(QSslDiffieHellmanParameters)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslDiffieHellmanParameters_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslDiffieHellmanParameters()
        {

            if (!PyErr_Occurred()) {
                // QSslDiffieHellmanParameters()
                cptr = new ::QSslDiffieHellmanParameters();
            }
            break;
        }
        case 1: // QSslDiffieHellmanParameters(const QSslDiffieHellmanParameters & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslDiffieHellmanParameters cppArg0_local;
            ::QSslDiffieHellmanParameters *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslDiffieHellmanParameters(QSslDiffieHellmanParameters)
                cptr = new ::QSslDiffieHellmanParameters(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslDiffieHellmanParameters >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslDiffieHellmanParameters_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslDiffieHellmanParameters_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_defaultParameters(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.defaultParameters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultParameters()
            QSslDiffieHellmanParameters cppResult = ::QSslDiffieHellmanParameters::defaultParameters();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QSslDiffieHellmanParameters::Error cppResult = const_cast<const ::QSslDiffieHellmanParameters *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QSslDiffieHellmanParameters *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_fromEncoded(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.fromEncoded";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromEncoded", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSslDiffieHellmanParameters::fromEncoded(QIODevice*,QSsl::EncodingFormat)
    // 1: static QSslDiffieHellmanParameters::fromEncoded(QByteArray,QSsl::EncodingFormat)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // fromEncoded(QByteArray,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // fromEncoded(QByteArray,QSsl::EncodingFormat)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromEncoded(QIODevice*,QSsl::EncodingFormat)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromEncoded(QIODevice*,QSsl::EncodingFormat)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fromEncoded(QIODevice * device, QSsl::EncodingFormat format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromEncoded(QIODevice*,QSsl::EncodingFormat)
                QSslDiffieHellmanParameters cppResult = ::QSslDiffieHellmanParameters::fromEncoded(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fromEncoded(const QByteArray & encoded, QSsl::EncodingFormat format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[1]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ENCODINGFORMAT_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QSsl::EncodingFormat cppArg1 = QSsl::Pem;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // fromEncoded(QByteArray,QSsl::EncodingFormat)
                QSslDiffieHellmanParameters cppResult = ::QSslDiffieHellmanParameters::fromEncoded(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSslDiffieHellmanParametersFunc_fromEncoded_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QSslDiffieHellmanParameters *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QSslDiffieHellmanParameters *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslDiffieHellmanParametersFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslDiffieHellmanParameters.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslDiffieHellmanParameters::swap(QSslDiffieHellmanParameters&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslDiffieHellmanParameters&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslDiffieHellmanParametersFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslDiffieHellmanParameters cppArg0_local;
        ::QSslDiffieHellmanParameters *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslDiffieHellmanParameters&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslDiffieHellmanParametersFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslDiffieHellmanParameters___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslDiffieHellmanParameters_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslDiffieHellmanParameters_methods[] = {
    {"defaultParameters", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_defaultParameters), METH_NOARGS|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_errorString), METH_NOARGS},
    {"fromEncoded", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_fromEncoded), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_isEmpty), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_isValid), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParametersFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslDiffieHellmanParameters___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QSslDiffieHellmanParameters_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), (pyArg)))) {
                // operator!=(const QSslDiffieHellmanParameters & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslDiffieHellmanParameters cppArg0_local;
                ::QSslDiffieHellmanParameters *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), (pyArg)))) {
                // operator==(const QSslDiffieHellmanParameters & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslDiffieHellmanParameters cppArg0_local;
                ::QSslDiffieHellmanParameters *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSslDiffieHellmanParameters_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSslDiffieHellmanParameters_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSslDiffieHellmanParameters_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslDiffieHellmanParameters_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSslDiffieHellmanParameters__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslDiffieHellmanParameters_Type = nullptr;
static SbkObjectType *Sbk_QSslDiffieHellmanParameters_TypeF(void)
{
    return _Sbk_QSslDiffieHellmanParameters_Type;
}

static PyType_Slot Sbk_QSslDiffieHellmanParameters_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslDiffieHellmanParameters_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSslDiffieHellmanParameters_spec = {
    "2:PySide2.QtNetwork.QSslDiffieHellmanParameters",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslDiffieHellmanParameters_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSslDiffieHellmanParameters_Error_PythonToCpp_QSslDiffieHellmanParameters_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslDiffieHellmanParameters::Error *>(cppOut) =
        static_cast<::QSslDiffieHellmanParameters::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSslDiffieHellmanParameters_Error_PythonToCpp_QSslDiffieHellmanParameters_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX]))
        return QSslDiffieHellmanParameters_Error_PythonToCpp_QSslDiffieHellmanParameters_Error;
    return {};
}
static PyObject *QSslDiffieHellmanParameters_Error_CppToPython_QSslDiffieHellmanParameters_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSslDiffieHellmanParameters::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslDiffieHellmanParameters_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslDiffieHellmanParameters_TypeF())))
        return QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslDiffieHellmanParameters_PTR_CppToPython_QSslDiffieHellmanParameters(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslDiffieHellmanParameters *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslDiffieHellmanParameters_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslDiffieHellmanParameters_COPY_CppToPython_QSslDiffieHellmanParameters(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslDiffieHellmanParameters_TypeF(), new ::QSslDiffieHellmanParameters(*reinterpret_cast<const ::QSslDiffieHellmanParameters *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslDiffieHellmanParameters *>(cppOut) = *reinterpret_cast< ::QSslDiffieHellmanParameters *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslDiffieHellmanParameters_TypeF())))
        return QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslDiffieHellmanParameters_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QSslDiffieHellmanParameters(self)",
    "0:PySide2.QtNetwork.QSslDiffieHellmanParameters(self,other:PySide2.QtNetwork.QSslDiffieHellmanParameters)",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.defaultParameters()->PySide2.QtNetwork.QSslDiffieHellmanParameters",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.error(self)->PySide2.QtNetwork.QSslDiffieHellmanParameters.Error",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.errorString(self)->QString",
    "1:PySide2.QtNetwork.QSslDiffieHellmanParameters.fromEncoded(device:PySide2.QtCore.QIODevice,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)->PySide2.QtNetwork.QSslDiffieHellmanParameters",
    "0:PySide2.QtNetwork.QSslDiffieHellmanParameters.fromEncoded(encoded:PySide2.QtCore.QByteArray,format:PySide2.QtNetwork.QSsl.EncodingFormat=QSsl.Pem)->PySide2.QtNetwork.QSslDiffieHellmanParameters",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.isEmpty(self)->bool",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.isValid(self)->bool",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.swap(self,other:PySide2.QtNetwork.QSslDiffieHellmanParameters)",
    "PySide2.QtNetwork.QSslDiffieHellmanParameters.__copy__()",
    nullptr}; // Sentinel

void init_QSslDiffieHellmanParameters(PyObject *module)
{
    _Sbk_QSslDiffieHellmanParameters_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslDiffieHellmanParameters",
        "QSslDiffieHellmanParameters",
        &Sbk_QSslDiffieHellmanParameters_spec,
        &Shiboken::callCppDestructor< ::QSslDiffieHellmanParameters >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslDiffieHellmanParameters_Type);
    InitSignatureStrings(pyType, QSslDiffieHellmanParameters_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslDiffieHellmanParameters_Type), Sbk_QSslDiffieHellmanParameters_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslDiffieHellmanParameters_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslDiffieHellmanParameters_TypeF(),
        QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_PTR,
        is_QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_PTR_Convertible,
        QSslDiffieHellmanParameters_PTR_CppToPython_QSslDiffieHellmanParameters,
        QSslDiffieHellmanParameters_COPY_CppToPython_QSslDiffieHellmanParameters);

    Shiboken::Conversions::registerConverterName(converter, "QSslDiffieHellmanParameters");
    Shiboken::Conversions::registerConverterName(converter, "QSslDiffieHellmanParameters*");
    Shiboken::Conversions::registerConverterName(converter, "QSslDiffieHellmanParameters&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslDiffieHellmanParameters).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_COPY,
        is_QSslDiffieHellmanParameters_PythonToCpp_QSslDiffieHellmanParameters_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSslDiffieHellmanParameters_TypeF(),
        "Error",
        "2:PySide2.QtNetwork.QSslDiffieHellmanParameters.Error",
        "QSslDiffieHellmanParameters::Error");
    if (!SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX],
        Sbk_QSslDiffieHellmanParameters_TypeF(), "NoError", (long) QSslDiffieHellmanParameters::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX],
        Sbk_QSslDiffieHellmanParameters_TypeF(), "InvalidInputDataError", (long) QSslDiffieHellmanParameters::Error::InvalidInputDataError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX],
        Sbk_QSslDiffieHellmanParameters_TypeF(), "UnsafeParametersError", (long) QSslDiffieHellmanParameters::Error::UnsafeParametersError))
        return;
    // Register converter for enum 'QSslDiffieHellmanParameters::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX],
            QSslDiffieHellmanParameters_Error_CppToPython_QSslDiffieHellmanParameters_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSslDiffieHellmanParameters_Error_PythonToCpp_QSslDiffieHellmanParameters_Error,
            is_QSslDiffieHellmanParameters_Error_PythonToCpp_QSslDiffieHellmanParameters_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QSSLDIFFIEHELLMANPARAMETERS_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSslDiffieHellmanParameters::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::QSslDiffieHellmanParameters >("QSslDiffieHellmanParameters");
    qRegisterMetaType< ::QSslDiffieHellmanParameters::Error >("QSslDiffieHellmanParameters::Error");
}
