/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtnetwork_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtNetworkTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtNetworkModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtNetworkTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtNetwork_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtNetworkTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtNetwork_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QSslPreSharedKeyAuthenticator(PyObject *module);
void init_QSslError(PyObject *module);
void init_QSslDiffieHellmanParameters(PyObject *module);
void init_QSslConfiguration(PyObject *module);
void init_QSslConfigurationStaticFields();
void init_QSslCipher(PyObject *module);
void init_QSslCertificateExtension(PyObject *module);
void init_QtNetworkQSsl(PyObject *module);
void init_QtNetworkQPasswordDigestor(PyObject *module);
void init_QOcspResponse(PyObject *module);
void init_QNetworkRequest(PyObject *module);
void init_QNetworkProxyQuery(PyObject *module);
void init_QNetworkProxyFactory(PyObject *module);
void init_QNetworkProxy(PyObject *module);
void init_QNetworkInterface(PyObject *module);
void init_QNetworkConfiguration(PyObject *module);
void init_QNetworkCacheMetaData(PyObject *module);
void init_QNetworkAddressEntry(PyObject *module);
void init_QIPv6Address(PyObject *module);
void init_QHttpPart(PyObject *module);
void init_QHstsPolicy(PyObject *module);
void init_QHostInfo(PyObject *module);
void init_QHostAddress(PyObject *module);
void init_QNetworkDatagram(PyObject *module);
void init_QDnsTextRecord(PyObject *module);
void init_QDnsServiceRecord(PyObject *module);
void init_QDnsMailExchangeRecord(PyObject *module);
void init_QDnsHostAddressRecord(PyObject *module);
void init_QDnsDomainNameRecord(PyObject *module);
void init_QAuthenticator(PyObject *module);
void init_QDnsLookup(PyObject *module);
void init_QAbstractNetworkCache(PyObject *module);
void init_QNetworkDiskCache(PyObject *module);
void init_QAbstractSocket(PyObject *module);
void init_QUdpSocket(PyObject *module);
void init_QTcpSocket(PyObject *module);
void init_QLocalSocket(PyObject *module);
void init_QNetworkReply(PyObject *module);
void init_QNetworkSession(PyObject *module);
void init_QNetworkCookieJar(PyObject *module);
void init_QNetworkConfigurationManager(PyObject *module);
void init_QNetworkAccessManager(PyObject *module);
void init_QLocalServer(PyObject *module);
void init_QHttpMultiPart(PyObject *module);
void init_QTcpServer(PyObject *module);
void init_QSslKey(PyObject *module);
void init_QDtls(PyObject *module);
void init_QNetworkCookie(PyObject *module);
void init_QSslCertificate(PyObject *module);
void init_QSslSocket(PyObject *module);

// Enum definitions ------------------------------------------------------------
static void QDtlsError_PythonToCpp_QDtlsError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDtlsError *>(cppOut) =
        static_cast<::QDtlsError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDtlsError_PythonToCpp_QDtlsError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX]))
        return QDtlsError_PythonToCpp_QDtlsError;
    return {};
}
static PyObject *QDtlsError_CppToPython_QDtlsError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDtlsError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], castCppIn);

}


static void QOcspCertificateStatus_PythonToCpp_QOcspCertificateStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOcspCertificateStatus *>(cppOut) =
        static_cast<::QOcspCertificateStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOcspCertificateStatus_PythonToCpp_QOcspCertificateStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX]))
        return QOcspCertificateStatus_PythonToCpp_QOcspCertificateStatus;
    return {};
}
static PyObject *QOcspCertificateStatus_CppToPython_QOcspCertificateStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOcspCertificateStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX], castCppIn);

}


static void QOcspRevocationReason_PythonToCpp_QOcspRevocationReason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOcspRevocationReason *>(cppOut) =
        static_cast<::QOcspRevocationReason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOcspRevocationReason_PythonToCpp_QOcspRevocationReason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX]))
        return QOcspRevocationReason_PythonToCpp_QOcspRevocationReason;
    return {};
}
static PyObject *QOcspRevocationReason_CppToPython_QOcspRevocationReason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOcspRevocationReason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], castCppIn);

}



// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QHash<QString,QVariant >'.
static PyObject *_QHash_QString_QVariant__CppToPython__QHash_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QHash_QString_QVariant__PythonToCpp__QHash_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QHash_QString_QVariant__PythonToCpp__QHash_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QHash_QString_QVariant__PythonToCpp__QHash_QString_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QDnsDomainNameRecord >'.
static PyObject *_QList_QDnsDomainNameRecord__CppToPython__QList_QDnsDomainNameRecord_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDnsDomainNameRecord > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDnsDomainNameRecord >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDnsDomainNameRecord cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSDOMAINNAMERECORD_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QDnsDomainNameRecord__PythonToCpp__QList_QDnsDomainNameRecord_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDnsDomainNameRecord > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDnsDomainNameRecord cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSDOMAINNAMERECORD_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QDnsDomainNameRecord__PythonToCpp__QList_QDnsDomainNameRecord__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSDOMAINNAMERECORD_IDX]), pyIn))
        return _QList_QDnsDomainNameRecord__PythonToCpp__QList_QDnsDomainNameRecord_;
    return {};
}

// C++ to Python conversion for type 'QList<QDnsHostAddressRecord >'.
static PyObject *_QList_QDnsHostAddressRecord__CppToPython__QList_QDnsHostAddressRecord_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDnsHostAddressRecord > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDnsHostAddressRecord >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDnsHostAddressRecord cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QDnsHostAddressRecord__PythonToCpp__QList_QDnsHostAddressRecord_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDnsHostAddressRecord > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDnsHostAddressRecord cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QDnsHostAddressRecord__PythonToCpp__QList_QDnsHostAddressRecord__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSHOSTADDRESSRECORD_IDX]), pyIn))
        return _QList_QDnsHostAddressRecord__PythonToCpp__QList_QDnsHostAddressRecord_;
    return {};
}

// C++ to Python conversion for type 'QList<QDnsMailExchangeRecord >'.
static PyObject *_QList_QDnsMailExchangeRecord__CppToPython__QList_QDnsMailExchangeRecord_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDnsMailExchangeRecord > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDnsMailExchangeRecord >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDnsMailExchangeRecord cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSMAILEXCHANGERECORD_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QDnsMailExchangeRecord__PythonToCpp__QList_QDnsMailExchangeRecord_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDnsMailExchangeRecord > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDnsMailExchangeRecord cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSMAILEXCHANGERECORD_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QDnsMailExchangeRecord__PythonToCpp__QList_QDnsMailExchangeRecord__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSMAILEXCHANGERECORD_IDX]), pyIn))
        return _QList_QDnsMailExchangeRecord__PythonToCpp__QList_QDnsMailExchangeRecord_;
    return {};
}

// C++ to Python conversion for type 'QList<QDnsServiceRecord >'.
static PyObject *_QList_QDnsServiceRecord__CppToPython__QList_QDnsServiceRecord_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDnsServiceRecord > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDnsServiceRecord >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDnsServiceRecord cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSSERVICERECORD_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QDnsServiceRecord__PythonToCpp__QList_QDnsServiceRecord_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDnsServiceRecord > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDnsServiceRecord cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSSERVICERECORD_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QDnsServiceRecord__PythonToCpp__QList_QDnsServiceRecord__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSSERVICERECORD_IDX]), pyIn))
        return _QList_QDnsServiceRecord__PythonToCpp__QList_QDnsServiceRecord_;
    return {};
}

// C++ to Python conversion for type 'QList<QDnsTextRecord >'.
static PyObject *_QList_QDnsTextRecord__CppToPython__QList_QDnsTextRecord_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QDnsTextRecord > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QDnsTextRecord >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QDnsTextRecord cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSTEXTRECORD_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QDnsTextRecord__PythonToCpp__QList_QDnsTextRecord_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QDnsTextRecord > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QDnsTextRecord cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSTEXTRECORD_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QDnsTextRecord__PythonToCpp__QList_QDnsTextRecord__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QDNSTEXTRECORD_IDX]), pyIn))
        return _QList_QDnsTextRecord__PythonToCpp__QList_QDnsTextRecord_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QSslError > &'.
static PyObject *_constQVector_QSslError_REF_CppToPython__constQVector_QSslError_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QSslError > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QSslError >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QSslError >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QSslError cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QSslError_REF_PythonToCpp__constQVector_QSslError_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QSslError > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslError cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QSslError_REF_PythonToCpp__constQVector_QSslError_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyIn))
        return _constQVector_QSslError_REF_PythonToCpp__constQVector_QSslError_REF;
    return {};
}

// C++ to Python conversion for type 'const QPair<QHostAddress,int > &'.
static PyObject *_constQPair_QHostAddress_int_REF_CppToPython__constQPair_QHostAddress_int_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QHostAddress,int > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _constQPair_QHostAddress_int_REF_PythonToCpp__constQPair_QHostAddress_int_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QHostAddress,int > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__constQPair_QHostAddress_int_REF_PythonToCpp__constQPair_QHostAddress_int_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX])->converter, false, Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, pyIn))
        return _constQPair_QHostAddress_int_REF_PythonToCpp__constQPair_QHostAddress_int_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QHostAddress >'.
static PyObject *_QList_QHostAddress__CppToPython__QList_QHostAddress_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QHostAddress > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QHostAddress >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QHostAddress cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QHostAddress__PythonToCpp__QList_QHostAddress_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QHostAddress > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QHostAddress cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QHostAddress__PythonToCpp__QList_QHostAddress__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pyIn))
        return _QList_QHostAddress__PythonToCpp__QList_QHostAddress_;
    return {};
}

// C++ to Python conversion for type 'const QVector<QHstsPolicy > &'.
static PyObject *_constQVector_QHstsPolicy_REF_CppToPython__constQVector_QHstsPolicy_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QHstsPolicy > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QHstsPolicy >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QHstsPolicy >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QHstsPolicy cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QHstsPolicy > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QHstsPolicy cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pyIn))
        return _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QSslError > &'.
static PyObject *_constQList_QSslError_REF_CppToPython__constQList_QSslError_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSslError > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSslError >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSslError cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSslError > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslError cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLERROR_IDX]), pyIn))
        return _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF;
    return {};
}

// C++ to Python conversion for type 'QHash<QNetworkRequest::Attribute,QVariant >'.
static PyObject *_QHash_QNetworkRequest_Attribute_QVariant__CppToPython__QHash_QNetworkRequest_Attribute_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QHash<QNetworkRequest::Attribute,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QHash<QNetworkRequest::Attribute,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QNetworkRequest::Attribute key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])->converter, &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QHash_QNetworkRequest_Attribute_QVariant__PythonToCpp__QHash_QNetworkRequest_Attribute_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QHash<QNetworkRequest::Attribute,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QNetworkRequest::Attribute cppKey{QNetworkRequest::HttpStatusCodeAttribute};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])->converter, key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QHash_QNetworkRequest_Attribute_QVariant__PythonToCpp__QHash_QNetworkRequest_Attribute_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_ATTRIBUTE_IDX])->converter, false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QHash_QNetworkRequest_Attribute_QVariant__PythonToCpp__QHash_QNetworkRequest_Attribute_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QPair<QByteArray,QByteArray >'.
static PyObject *_QPair_QByteArray_QByteArray__CppToPython__QPair_QByteArray_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QByteArray,QByteArray > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_QByteArray_QByteArray__PythonToCpp__QPair_QByteArray_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QByteArray,QByteArray > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_QByteArray_QByteArray__PythonToCpp__QPair_QByteArray_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, pyIn))
        return _QPair_QByteArray_QByteArray__PythonToCpp__QPair_QByteArray_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< QByteArray,QByteArray > >'.
static PyObject *_QList_QPair_QByteArray_QByteArray___CppToPython__QList_QPair_QByteArray_QByteArray__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< QByteArray,QByteArray > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< QByteArray,QByteArray > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<QByteArray,QByteArray > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPair_QByteArray_QByteArray___PythonToCpp__QList_QPair_QByteArray_QByteArray__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< QByteArray,QByteArray > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<QByteArray,QByteArray > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPair_QByteArray_QByteArray___PythonToCpp__QList_QPair_QByteArray_QByteArray___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX], pyIn))
        return _QList_QPair_QByteArray_QByteArray___PythonToCpp__QList_QPair_QByteArray_QByteArray__;
    return {};
}

// C++ to Python conversion for type 'QList<QNetworkConfiguration >'.
static PyObject *_QList_QNetworkConfiguration__CppToPython__QList_QNetworkConfiguration_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkConfiguration > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkConfiguration >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkConfiguration cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QNetworkConfiguration__PythonToCpp__QList_QNetworkConfiguration_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkConfiguration > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkConfiguration cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QNetworkConfiguration__PythonToCpp__QList_QNetworkConfiguration__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pyIn))
        return _QList_QNetworkConfiguration__PythonToCpp__QList_QNetworkConfiguration_;
    return {};
}

// C++ to Python conversion for type 'QList<QNetworkCookie >'.
static PyObject *_QList_QNetworkCookie__CppToPython__QList_QNetworkCookie_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkCookie > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkCookie >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkCookie cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QNetworkCookie__PythonToCpp__QList_QNetworkCookie_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkCookie > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkCookie cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QNetworkCookie__PythonToCpp__QList_QNetworkCookie__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIE_IDX]), pyIn))
        return _QList_QNetworkCookie__PythonToCpp__QList_QNetworkCookie_;
    return {};
}

// C++ to Python conversion for type 'QList<QNetworkAddressEntry >'.
static PyObject *_QList_QNetworkAddressEntry__CppToPython__QList_QNetworkAddressEntry_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkAddressEntry > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkAddressEntry >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkAddressEntry cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QNetworkAddressEntry__PythonToCpp__QList_QNetworkAddressEntry_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkAddressEntry > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkAddressEntry cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QNetworkAddressEntry__PythonToCpp__QList_QNetworkAddressEntry__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKADDRESSENTRY_IDX]), pyIn))
        return _QList_QNetworkAddressEntry__PythonToCpp__QList_QNetworkAddressEntry_;
    return {};
}

// C++ to Python conversion for type 'QList<QNetworkInterface >'.
static PyObject *_QList_QNetworkInterface__CppToPython__QList_QNetworkInterface_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkInterface > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkInterface >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkInterface cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QNetworkInterface__PythonToCpp__QList_QNetworkInterface_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkInterface > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkInterface cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QNetworkInterface__PythonToCpp__QList_QNetworkInterface__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), pyIn))
        return _QList_QNetworkInterface__PythonToCpp__QList_QNetworkInterface_;
    return {};
}

// C++ to Python conversion for type 'QList<QNetworkProxy >'.
static PyObject *_QList_QNetworkProxy__CppToPython__QList_QNetworkProxy_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkProxy > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkProxy >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkProxy cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QNetworkProxy__PythonToCpp__QList_QNetworkProxy_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkProxy > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkProxy cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QNetworkProxy__PythonToCpp__QList_QNetworkProxy__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pyIn))
        return _QList_QNetworkProxy__PythonToCpp__QList_QNetworkProxy_;
    return {};
}

// C++ to Python conversion for type 'QList<QSslCertificateExtension >'.
static PyObject *_QList_QSslCertificateExtension__CppToPython__QList_QSslCertificateExtension_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSslCertificateExtension > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSslCertificateExtension >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSslCertificateExtension cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSslCertificateExtension__PythonToCpp__QList_QSslCertificateExtension_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSslCertificateExtension > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslCertificateExtension cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSslCertificateExtension__PythonToCpp__QList_QSslCertificateExtension__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATEEXTENSION_IDX]), pyIn))
        return _QList_QSslCertificateExtension__PythonToCpp__QList_QSslCertificateExtension_;
    return {};
}

// C++ to Python conversion for type 'QList<QSslCertificate >'.
static PyObject *_QList_QSslCertificate__CppToPython__QList_QSslCertificate_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSslCertificate > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSslCertificate >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSslCertificate cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSslCertificate__PythonToCpp__QList_QSslCertificate_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSslCertificate > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslCertificate cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSslCertificate__PythonToCpp__QList_QSslCertificate__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCERTIFICATE_IDX]), pyIn))
        return _QList_QSslCertificate__PythonToCpp__QList_QSslCertificate_;
    return {};
}

// C++ to Python conversion for type 'QMultiMap<QSsl::AlternativeNameEntryType,QString >'.
static PyObject *_QMultiMap_QSsl_AlternativeNameEntryType_QString__CppToPython__QMultiMap_QSsl_AlternativeNameEntryType_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMultiMap<QSsl::AlternativeNameEntryType,QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMultiMap<QSsl::AlternativeNameEntryType,QString >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QSsl::AlternativeNameEntryType key = it.key();
        ::QString value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX])->converter, &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMultiMap_QSsl_AlternativeNameEntryType_QString__PythonToCpp__QMultiMap_QSsl_AlternativeNameEntryType_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMultiMap<QSsl::AlternativeNameEntryType,QString > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QSsl::AlternativeNameEntryType cppKey{QSsl::EmailEntry};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX])->converter, key, &(cppKey));
        ::QString cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMultiMap_QSsl_AlternativeNameEntryType_QString__PythonToCpp__QMultiMap_QSsl_AlternativeNameEntryType_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_ALTERNATIVENAMEENTRYTYPE_IDX])->converter, false, SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, pyIn))
        return _QMultiMap_QSsl_AlternativeNameEntryType_QString__PythonToCpp__QMultiMap_QSsl_AlternativeNameEntryType_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QByteArray,QVariant >'.
static PyObject *_QMap_QByteArray_QVariant__CppToPython__QMap_QByteArray_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QByteArray,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QByteArray,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QByteArray key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QByteArray_QVariant__PythonToCpp__QMap_QByteArray_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QByteArray,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QByteArray cppKey;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QByteArray_QVariant__PythonToCpp__QMap_QByteArray_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX])->converter, false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QByteArray_QVariant__PythonToCpp__QMap_QByteArray_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QSslCipher >'.
static PyObject *_QList_QSslCipher__CppToPython__QList_QSslCipher_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSslCipher > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSslCipher >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSslCipher cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSslCipher__PythonToCpp__QList_QSslCipher_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSslCipher > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSslCipher cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSslCipher__PythonToCpp__QList_QSslCipher__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pyIn))
        return _QList_QSslCipher__PythonToCpp__QList_QSslCipher_;
    return {};
}

// C++ to Python conversion for type 'QVector<QOcspResponse >'.
static PyObject *_QVector_QOcspResponse__CppToPython__QVector_QOcspResponse_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QOcspResponse > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QOcspResponse >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QOcspResponse >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QOcspResponse cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _QVector_QOcspResponse__PythonToCpp__QVector_QOcspResponse_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QOcspResponse > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QOcspResponse cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__QVector_QOcspResponse__PythonToCpp__QVector_QOcspResponse__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QOCSPRESPONSE_IDX]), pyIn))
        return _QVector_QOcspResponse__PythonToCpp__QVector_QOcspResponse_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtNetwork",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtNetwork_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtNetwork_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtNetwork)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtNetwork_IDX_COUNT];
    SbkPySide2_QtNetworkTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtNetwork_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtNetworkTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtNetwork", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtNetwork", QtNetwork_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtNetworkModuleObject = module;

    // Initialize classes in the type system
    init_QSslPreSharedKeyAuthenticator(module);
    init_QSslError(module);
    init_QSslDiffieHellmanParameters(module);
    init_QSslConfiguration(module);
    init_QSslCipher(module);
    init_QSslCertificateExtension(module);
    init_QtNetworkQSsl(module);
    init_QtNetworkQPasswordDigestor(module);
    init_QOcspResponse(module);
    init_QNetworkRequest(module);
    init_QNetworkProxyQuery(module);
    init_QNetworkProxyFactory(module);
    init_QNetworkProxy(module);
    init_QNetworkInterface(module);
    init_QNetworkConfiguration(module);
    init_QNetworkCacheMetaData(module);
    init_QNetworkAddressEntry(module);
    init_QIPv6Address(module);
    init_QHttpPart(module);
    init_QHstsPolicy(module);
    init_QHostInfo(module);
    init_QHostAddress(module);
    init_QNetworkDatagram(module);
    init_QDnsTextRecord(module);
    init_QDnsServiceRecord(module);
    init_QDnsMailExchangeRecord(module);
    init_QDnsHostAddressRecord(module);
    init_QDnsDomainNameRecord(module);
    init_QAuthenticator(module);
    init_QDnsLookup(module);
    init_QAbstractNetworkCache(module);
    init_QNetworkDiskCache(module);
    init_QAbstractSocket(module);
    init_QUdpSocket(module);
    init_QTcpSocket(module);
    init_QLocalSocket(module);
    init_QNetworkReply(module);
    init_QNetworkSession(module);
    init_QNetworkCookieJar(module);
    init_QNetworkConfigurationManager(module);
    init_QNetworkAccessManager(module);
    init_QLocalServer(module);
    init_QHttpMultiPart(module);
    init_QTcpServer(module);
    init_QSslKey(module);
    init_QDtls(module);
    init_QNetworkCookie(module);
    init_QSslCertificate(module);
    init_QSslSocket(module);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QHash<QString,QVariant>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QString_QVariant__CppToPython__QHash_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QSTRING_QVARIANT_IDX], "QHash<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QSTRING_QVARIANT_IDX],
        _QHash_QString_QVariant__PythonToCpp__QHash_QString_QVariant_,
        is__QHash_QString_QVariant__PythonToCpp__QHash_QString_QVariant__Convertible);

    // Register converter for type 'QList<QDnsDomainNameRecord>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QDnsDomainNameRecord__CppToPython__QList_QDnsDomainNameRecord_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX], "QList<QDnsDomainNameRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX],
        _QList_QDnsDomainNameRecord__PythonToCpp__QList_QDnsDomainNameRecord_,
        is__QList_QDnsDomainNameRecord__PythonToCpp__QList_QDnsDomainNameRecord__Convertible);

    // Register converter for type 'QList<QDnsHostAddressRecord>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSHOSTADDRESSRECORD_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QDnsHostAddressRecord__CppToPython__QList_QDnsHostAddressRecord_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSHOSTADDRESSRECORD_IDX], "QList<QDnsHostAddressRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSHOSTADDRESSRECORD_IDX],
        _QList_QDnsHostAddressRecord__PythonToCpp__QList_QDnsHostAddressRecord_,
        is__QList_QDnsHostAddressRecord__PythonToCpp__QList_QDnsHostAddressRecord__Convertible);

    // Register converter for type 'QList<QDnsMailExchangeRecord>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSMAILEXCHANGERECORD_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QDnsMailExchangeRecord__CppToPython__QList_QDnsMailExchangeRecord_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSMAILEXCHANGERECORD_IDX], "QList<QDnsMailExchangeRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSMAILEXCHANGERECORD_IDX],
        _QList_QDnsMailExchangeRecord__PythonToCpp__QList_QDnsMailExchangeRecord_,
        is__QList_QDnsMailExchangeRecord__PythonToCpp__QList_QDnsMailExchangeRecord__Convertible);

    // Register converter for type 'QList<QDnsServiceRecord>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSSERVICERECORD_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QDnsServiceRecord__CppToPython__QList_QDnsServiceRecord_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSSERVICERECORD_IDX], "QList<QDnsServiceRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSSERVICERECORD_IDX],
        _QList_QDnsServiceRecord__PythonToCpp__QList_QDnsServiceRecord_,
        is__QList_QDnsServiceRecord__PythonToCpp__QList_QDnsServiceRecord__Convertible);

    // Register converter for type 'QList<QDnsTextRecord>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSTEXTRECORD_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QDnsTextRecord__CppToPython__QList_QDnsTextRecord_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSTEXTRECORD_IDX], "QList<QDnsTextRecord>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSTEXTRECORD_IDX],
        _QList_QDnsTextRecord__PythonToCpp__QList_QDnsTextRecord_,
        is__QList_QDnsTextRecord__PythonToCpp__QList_QDnsTextRecord__Convertible);

    // Register converter for type 'const QVector<QSslError>&'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QSslError_REF_CppToPython__constQVector_QSslError_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX], "const QVector<QSslError>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX], "QVector<QSslError>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX],
        _constQVector_QSslError_REF_PythonToCpp__constQVector_QSslError_REF,
        is__constQVector_QSslError_REF_PythonToCpp__constQVector_QSslError_REF_Convertible);

    // Register converter for type 'const QPair<QHostAddress,int>&'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQPair_QHostAddress_int_REF_CppToPython__constQPair_QHostAddress_int_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX], "const QPair<QHostAddress,int>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX], "QPair<QHostAddress,int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX],
        _constQPair_QHostAddress_int_REF_PythonToCpp__constQPair_QHostAddress_int_REF,
        is__constQPair_QHostAddress_int_REF_PythonToCpp__constQPair_QHostAddress_int_REF_Convertible);

    // Register converter for type 'QList<QHostAddress>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QHostAddress__CppToPython__QList_QHostAddress_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX], "QList<QHostAddress>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX],
        _QList_QHostAddress__PythonToCpp__QList_QHostAddress_,
        is__QList_QHostAddress__PythonToCpp__QList_QHostAddress__Convertible);

    // Register converter for type 'const QVector<QHstsPolicy>&'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QHstsPolicy_REF_CppToPython__constQVector_QHstsPolicy_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX], "const QVector<QHstsPolicy>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX], "QVector<QHstsPolicy>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX],
        _constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF,
        is__constQVector_QHstsPolicy_REF_PythonToCpp__constQVector_QHstsPolicy_REF_Convertible);

    // Register converter for type 'const QList<QSslError>&'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLERROR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QSslError_REF_CppToPython__constQList_QSslError_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLERROR_IDX], "const QList<QSslError>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLERROR_IDX], "QList<QSslError>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLERROR_IDX],
        _constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF,
        is__constQList_QSslError_REF_PythonToCpp__constQList_QSslError_REF_Convertible);

    // Register converter for type 'QHash<QNetworkRequest::Attribute,QVariant>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QNETWORKREQUEST_ATTRIBUTE_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QHash_QNetworkRequest_Attribute_QVariant__CppToPython__QHash_QNetworkRequest_Attribute_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QNETWORKREQUEST_ATTRIBUTE_QVARIANT_IDX], "QHash<QNetworkRequest::Attribute,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QHASH_QNETWORKREQUEST_ATTRIBUTE_QVARIANT_IDX],
        _QHash_QNetworkRequest_Attribute_QVariant__PythonToCpp__QHash_QNetworkRequest_Attribute_QVariant_,
        is__QHash_QNetworkRequest_Attribute_QVariant__PythonToCpp__QHash_QNetworkRequest_Attribute_QVariant__Convertible);

    // Register converter for type 'QPair<QByteArray,QByteArray>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_QByteArray_QByteArray__CppToPython__QPair_QByteArray_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX], "QPair<QByteArray,QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX],
        _QPair_QByteArray_QByteArray__PythonToCpp__QPair_QByteArray_QByteArray_,
        is__QPair_QByteArray_QByteArray__PythonToCpp__QPair_QByteArray_QByteArray__Convertible);

    // Register converter for type 'QList<QPair<QByteArray,QByteArray>>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPair_QByteArray_QByteArray___CppToPython__QList_QPair_QByteArray_QByteArray__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX], "QList<QPair<QByteArray,QByteArray>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QPAIR_QBYTEARRAY_QBYTEARRAY_IDX],
        _QList_QPair_QByteArray_QByteArray___PythonToCpp__QList_QPair_QByteArray_QByteArray__,
        is__QList_QPair_QByteArray_QByteArray___PythonToCpp__QList_QPair_QByteArray_QByteArray___Convertible);

    // Register converter for type 'QList<QNetworkConfiguration>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCONFIGURATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkConfiguration__CppToPython__QList_QNetworkConfiguration_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCONFIGURATION_IDX], "QList<QNetworkConfiguration>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCONFIGURATION_IDX],
        _QList_QNetworkConfiguration__PythonToCpp__QList_QNetworkConfiguration_,
        is__QList_QNetworkConfiguration__PythonToCpp__QList_QNetworkConfiguration__Convertible);

    // Register converter for type 'QList<QNetworkCookie>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCOOKIE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkCookie__CppToPython__QList_QNetworkCookie_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCOOKIE_IDX], "QList<QNetworkCookie>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKCOOKIE_IDX],
        _QList_QNetworkCookie__PythonToCpp__QList_QNetworkCookie_,
        is__QList_QNetworkCookie__PythonToCpp__QList_QNetworkCookie__Convertible);

    // Register converter for type 'QList<QNetworkAddressEntry>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKADDRESSENTRY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkAddressEntry__CppToPython__QList_QNetworkAddressEntry_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKADDRESSENTRY_IDX], "QList<QNetworkAddressEntry>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKADDRESSENTRY_IDX],
        _QList_QNetworkAddressEntry__PythonToCpp__QList_QNetworkAddressEntry_,
        is__QList_QNetworkAddressEntry__PythonToCpp__QList_QNetworkAddressEntry__Convertible);

    // Register converter for type 'QList<QNetworkInterface>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKINTERFACE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkInterface__CppToPython__QList_QNetworkInterface_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKINTERFACE_IDX], "QList<QNetworkInterface>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKINTERFACE_IDX],
        _QList_QNetworkInterface__PythonToCpp__QList_QNetworkInterface_,
        is__QList_QNetworkInterface__PythonToCpp__QList_QNetworkInterface__Convertible);

    // Register converter for type 'QList<QNetworkProxy>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QNetworkProxy__CppToPython__QList_QNetworkProxy_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX], "QList<QNetworkProxy>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKPROXY_IDX],
        _QList_QNetworkProxy__PythonToCpp__QList_QNetworkProxy_,
        is__QList_QNetworkProxy__PythonToCpp__QList_QNetworkProxy__Convertible);

    // Register converter for type 'QList<QSslCertificateExtension>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATEEXTENSION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSslCertificateExtension__CppToPython__QList_QSslCertificateExtension_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATEEXTENSION_IDX], "QList<QSslCertificateExtension>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATEEXTENSION_IDX],
        _QList_QSslCertificateExtension__PythonToCpp__QList_QSslCertificateExtension_,
        is__QList_QSslCertificateExtension__PythonToCpp__QList_QSslCertificateExtension__Convertible);

    // Register converter for type 'QList<QSslCertificate>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSslCertificate__CppToPython__QList_QSslCertificate_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX], "QList<QSslCertificate>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCERTIFICATE_IDX],
        _QList_QSslCertificate__PythonToCpp__QList_QSslCertificate_,
        is__QList_QSslCertificate__PythonToCpp__QList_QSslCertificate__Convertible);

    // Register converter for type 'QMultiMap<QSsl::AlternativeNameEntryType,QString>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMULTIMAP_QSSL_ALTERNATIVENAMEENTRYTYPE_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMultiMap_QSsl_AlternativeNameEntryType_QString__CppToPython__QMultiMap_QSsl_AlternativeNameEntryType_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMULTIMAP_QSSL_ALTERNATIVENAMEENTRYTYPE_QSTRING_IDX], "QMultiMap<QSsl::AlternativeNameEntryType,QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMULTIMAP_QSSL_ALTERNATIVENAMEENTRYTYPE_QSTRING_IDX],
        _QMultiMap_QSsl_AlternativeNameEntryType_QString__PythonToCpp__QMultiMap_QSsl_AlternativeNameEntryType_QString_,
        is__QMultiMap_QSsl_AlternativeNameEntryType_QString__PythonToCpp__QMultiMap_QSsl_AlternativeNameEntryType_QString__Convertible);

    // Register converter for type 'QMap<QByteArray,QVariant>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QByteArray_QVariant__CppToPython__QMap_QByteArray_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX], "QMap<QByteArray,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QBYTEARRAY_QVARIANT_IDX],
        _QMap_QByteArray_QVariant__PythonToCpp__QMap_QByteArray_QVariant_,
        is__QMap_QByteArray_QVariant__PythonToCpp__QMap_QByteArray_QVariant__Convertible);

    // Register converter for type 'QList<QSslCipher>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSslCipher__CppToPython__QList_QSslCipher_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX], "QList<QSslCipher>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSSLCIPHER_IDX],
        _QList_QSslCipher__PythonToCpp__QList_QSslCipher_,
        is__QList_QSslCipher__PythonToCpp__QList_QSslCipher__Convertible);

    // Register converter for type 'QVector<QOcspResponse>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QOCSPRESPONSE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QVector_QOcspResponse__CppToPython__QVector_QOcspResponse_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QOCSPRESPONSE_IDX], "QVector<QOcspResponse>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QOCSPRESPONSE_IDX],
        _QVector_QOcspResponse__PythonToCpp__QVector_QOcspResponse_,
        is__QVector_QOcspResponse__PythonToCpp__QVector_QOcspResponse__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Initialization of enums.

    // Initialization of enum 'QDtlsError'.
    SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QDtlsError",
        "2:PySide2.QtNetwork.QDtlsError",
        "QDtlsError");
    if (!SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "NoError", (long) QDtlsError::NoError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "InvalidInputParameters", (long) QDtlsError::InvalidInputParameters))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "InvalidOperation", (long) QDtlsError::InvalidOperation))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "UnderlyingSocketError", (long) QDtlsError::UnderlyingSocketError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "RemoteClosedConnectionError", (long) QDtlsError::RemoteClosedConnectionError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "PeerVerificationError", (long) QDtlsError::PeerVerificationError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "TlsInitializationError", (long) QDtlsError::TlsInitializationError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "TlsFatalError", (long) QDtlsError::TlsFatalError))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], "TlsNonFatalError", (long) QDtlsError::TlsNonFatalError))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QDtlsError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX],
            QDtlsError_CppToPython_QDtlsError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDtlsError_PythonToCpp_QDtlsError,
            is_QDtlsError_PythonToCpp_QDtlsError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDtlsError");
    }
    // End of 'QDtlsError' enum.

    // Initialization of enum 'QOcspCertificateStatus'.
    SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QOcspCertificateStatus",
        "2:PySide2.QtNetwork.QOcspCertificateStatus",
        "QOcspCertificateStatus");
    if (!SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX], "Good", (long) QOcspCertificateStatus::Good))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX], "Revoked", (long) QOcspCertificateStatus::Revoked))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX], "Unknown", (long) QOcspCertificateStatus::Unknown))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QOcspCertificateStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX],
            QOcspCertificateStatus_CppToPython_QOcspCertificateStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOcspCertificateStatus_PythonToCpp_QOcspCertificateStatus,
            is_QOcspCertificateStatus_PythonToCpp_QOcspCertificateStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QOCSPCERTIFICATESTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOcspCertificateStatus");
    }
    // End of 'QOcspCertificateStatus' enum.

    // Initialization of enum 'QOcspRevocationReason'.
    SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX] = Shiboken::Enum::createGlobalEnum(module,
        "QOcspRevocationReason",
        "2:PySide2.QtNetwork.QOcspRevocationReason",
        "QOcspRevocationReason");
    if (!SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX])
        return SBK_MODULE_INIT_ERROR;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "None_", (long) QOcspRevocationReason::None))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "Unspecified", (long) QOcspRevocationReason::Unspecified))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "KeyCompromise", (long) QOcspRevocationReason::KeyCompromise))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "CACompromise", (long) QOcspRevocationReason::CACompromise))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "AffiliationChanged", (long) QOcspRevocationReason::AffiliationChanged))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "Superseded", (long) QOcspRevocationReason::Superseded))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "CessationOfOperation", (long) QOcspRevocationReason::CessationOfOperation))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "CertificateHold", (long) QOcspRevocationReason::CertificateHold))
        return SBK_MODULE_INIT_ERROR;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
        SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], "RemoveFromCRL", (long) QOcspRevocationReason::RemoveFromCRL))
        return SBK_MODULE_INIT_ERROR;
    // Register converter for enum 'QOcspRevocationReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX],
            QOcspRevocationReason_CppToPython_QOcspRevocationReason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOcspRevocationReason_PythonToCpp_QOcspRevocationReason,
            is_QOcspRevocationReason_PythonToCpp_QOcspRevocationReason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QOCSPREVOCATIONREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOcspRevocationReason");
    }
    // End of 'QOcspRevocationReason' enum.

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtNetworkTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtNetworkTypeConverters);

// Static field initialization
init_QSslConfigurationStaticFields();

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtNetwork");
    }
    qRegisterMetaType< ::QDtlsError >("QDtlsError");
    qRegisterMetaType< ::QOcspCertificateStatus >("QOcspCertificateStatus");
    qRegisterMetaType< ::QOcspRevocationReason >("QOcspRevocationReason");
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtNetwork_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
