/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglcolormap_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qcolor.h>
#include <QtOpenGL/qglcolormap.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLColormap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLColormap >()))
        return -1;

    ::QGLColormap *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGLColormap", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGLColormap::QGLColormap()
    // 1: QGLColormap::QGLColormap(QGLColormap)
    if (numArgs == 0) {
        overloadId = 0; // QGLColormap()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGLColormap(QGLColormap)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormap_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLColormap()
        {

            if (!PyErr_Occurred()) {
                // QGLColormap()
                cptr = new ::QGLColormap();
            }
            break;
        }
        case 1: // QGLColormap(const QGLColormap & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGLColormap cppArg0_local;
            ::QGLColormap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGLColormap(QGLColormap)
                cptr = new ::QGLColormap(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLColormap >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLColormap_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLColormap_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLColormapFunc_entryColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.entryColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLColormap::entryColor(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // entryColor(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_entryColor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // entryColor(int)const
            QColor cppResult = const_cast<const ::QGLColormap *>(cppSelf)->entryColor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLColormapFunc_entryColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_entryRgb(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.entryRgb";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLColormap::entryRgb(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // entryRgb(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_entryRgb_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // entryRgb(int)const
            unsigned int cppResult = const_cast<const ::QGLColormap *>(cppSelf)->entryRgb(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLColormapFunc_entryRgb_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_find(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.find";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLColormap::find(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // find(uint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_find_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // find(uint)const
            int cppResult = const_cast<const ::QGLColormap *>(cppSelf)->find(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLColormapFunc_find_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_findNearest(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.findNearest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLColormap::findNearest(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // findNearest(uint)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_findNearest_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // findNearest(uint)const
            int cppResult = const_cast<const ::QGLColormap *>(cppSelf)->findNearest(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLColormapFunc_findNearest_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()
            Qt::HANDLE cppResult = cppSelf->handle();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<Qt::HANDLE>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLColormapFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QGLColormap *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLColormapFunc_setEntry(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.setEntry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setEntry", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLColormap::setEntry(int,QColor)
    // 1: QGLColormap::setEntry(int,uint)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
            overloadId = 1; // setEntry(int,uint)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setEntry(int,QColor)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_setEntry_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setEntry(int idx, const QColor & color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setEntry(int,QColor)
                cppSelf->setEntry(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setEntry(int idx, unsigned int color)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setEntry(int,uint)
                cppSelf->setEntry(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLColormapFunc_setEntry_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_setHandle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.setHandle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLColormap::setHandle(Qt::HANDLE)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<Qt::HANDLE>(), (pyArg)))) {
        overloadId = 0; // setHandle(Qt::HANDLE)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLColormapFunc_setHandle_TypeError;

    // Call function/method
    {
        ::Qt::HANDLE cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHandle(Qt::HANDLE)
            cppSelf->setHandle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLColormapFunc_setHandle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLColormapFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLColormap.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            int cppResult = const_cast<const ::QGLColormap *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLColormap___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGLColormap_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLColormap_methods[] = {
    {"entryColor", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_entryColor), METH_O},
    {"entryRgb", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_entryRgb), METH_O},
    {"find", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_find), METH_O},
    {"findNearest", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_findNearest), METH_O},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_handle), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_isEmpty), METH_NOARGS},
    {"setEntry", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_setEntry), METH_VARARGS},
    {"setHandle", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_setHandle), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QGLColormapFunc_size), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGLColormap___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QGLColormap_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLColormap_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLColormap_Type = nullptr;
static SbkObjectType *Sbk_QGLColormap_TypeF(void)
{
    return _Sbk_QGLColormap_Type;
}

static PyType_Slot Sbk_QGLColormap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLColormap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLColormap_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLColormap_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLColormap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLColormap_spec = {
    "2:PySide2.QtOpenGL.QGLColormap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLColormap_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLColormap_PythonToCpp_QGLColormap_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLColormap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLColormap_PythonToCpp_QGLColormap_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLColormap_TypeF())))
        return QGLColormap_PythonToCpp_QGLColormap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLColormap_PTR_CppToPython_QGLColormap(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLColormap *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLColormap_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGLColormap_COPY_CppToPython_QGLColormap(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGLColormap_TypeF(), new ::QGLColormap(*reinterpret_cast<const ::QGLColormap *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGLColormap_PythonToCpp_QGLColormap_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLColormap *>(cppOut) = *reinterpret_cast< ::QGLColormap *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGLColormap_PythonToCpp_QGLColormap_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLColormap_TypeF())))
        return QGLColormap_PythonToCpp_QGLColormap_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLColormap_SignatureStrings[] = {
    "1:PySide2.QtOpenGL.QGLColormap(self)",
    "0:PySide2.QtOpenGL.QGLColormap(self,arg__1:PySide2.QtOpenGL.QGLColormap)",
    "PySide2.QtOpenGL.QGLColormap.entryColor(self,idx:int)->PySide2.QtGui.QColor",
    "PySide2.QtOpenGL.QGLColormap.entryRgb(self,idx:int)->unsigned int",
    "PySide2.QtOpenGL.QGLColormap.find(self,color:unsigned int)->int",
    "PySide2.QtOpenGL.QGLColormap.findNearest(self,color:unsigned int)->int",
    "PySide2.QtOpenGL.QGLColormap.handle(self)->Qt.HANDLE",
    "PySide2.QtOpenGL.QGLColormap.isEmpty(self)->bool",
    "1:PySide2.QtOpenGL.QGLColormap.setEntry(self,idx:int,color:PySide2.QtGui.QColor)",
    "0:PySide2.QtOpenGL.QGLColormap.setEntry(self,idx:int,color:unsigned int)",
    "PySide2.QtOpenGL.QGLColormap.setHandle(self,ahandle:Qt.HANDLE)",
    "PySide2.QtOpenGL.QGLColormap.size(self)->int",
    "PySide2.QtOpenGL.QGLColormap.__copy__()",
    nullptr}; // Sentinel

void init_QGLColormap(PyObject *module)
{
    _Sbk_QGLColormap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLColormap",
        "QGLColormap",
        &Sbk_QGLColormap_spec,
        &Shiboken::callCppDestructor< ::QGLColormap >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLColormap_Type);
    InitSignatureStrings(pyType, QGLColormap_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLColormap_Type), Sbk_QGLColormap_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLCOLORMAP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLColormap_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLColormap_TypeF(),
        QGLColormap_PythonToCpp_QGLColormap_PTR,
        is_QGLColormap_PythonToCpp_QGLColormap_PTR_Convertible,
        QGLColormap_PTR_CppToPython_QGLColormap,
        QGLColormap_COPY_CppToPython_QGLColormap);

    Shiboken::Conversions::registerConverterName(converter, "QGLColormap");
    Shiboken::Conversions::registerConverterName(converter, "QGLColormap*");
    Shiboken::Conversions::registerConverterName(converter, "QGLColormap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLColormap).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGLColormap_PythonToCpp_QGLColormap_COPY,
        is_QGLColormap_PythonToCpp_QGLColormap_COPY_Convertible);

    qRegisterMetaType< ::QGLColormap >("QGLColormap");
}
