/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopenglfunctions_python.h"

// main header
#include "qopenglfunctions_4_3_core_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QOpenGLFunctions_4_3_CoreWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QOpenGLFunctions_4_3_CoreWrapper::QOpenGLFunctions_4_3_CoreWrapper() : QOpenGLFunctions_4_3_Core()
{
    resetPyMethodCache();
    // ... middle
}

bool QOpenGLFunctions_4_3_CoreWrapper::initializeOpenGLFunctions()
{
    if (m_PyMethodCache[0])
        return this->::QOpenGLFunctions_4_3_Core::initializeOpenGLFunctions();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initializeOpenGLFunctions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QOpenGLFunctions_4_3_Core::initializeOpenGLFunctions();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QOpenGLFunctions_4_3_Core.initializeOpenGLFunctions", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QOpenGLFunctions_4_3_CoreWrapper::~QOpenGLFunctions_4_3_CoreWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLFunctions_4_3_Core_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLFunctions_4_3_Core >()))
        return -1;

    ::QOpenGLFunctions_4_3_CoreWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QOpenGLFunctions_4_3_Core()
            cptr = new ::QOpenGLFunctions_4_3_CoreWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLFunctions_4_3_Core >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveShaderProgram(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glActiveShaderProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glActiveShaderProgram", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glActiveShaderProgram(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glActiveShaderProgram(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveShaderProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glActiveShaderProgram(uint,uint)
            cppSelf->glActiveShaderProgram(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveShaderProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glActiveTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glActiveTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glActiveTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glActiveTexture(uint)
            cppSelf->glActiveTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glAttachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glAttachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glAttachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glAttachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glAttachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glAttachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glAttachShader(uint,uint)
            cppSelf->glAttachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glAttachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginConditionalRender(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBeginConditionalRender";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginConditionalRender", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBeginConditionalRender(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginConditionalRender(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginConditionalRender_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginConditionalRender(uint,uint)
            cppSelf->glBeginConditionalRender(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginConditionalRender_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQuery(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBeginQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginQuery", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBeginQuery(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBeginQuery(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBeginQuery(uint,uint)
            cppSelf->glBeginQuery(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQueryIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBeginQueryIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBeginQueryIndexed", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBeginQueryIndexed(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBeginQueryIndexed(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQueryIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBeginQueryIndexed(uint,uint,uint)
            cppSelf->glBeginQueryIndexed(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQueryIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBeginTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBeginTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBeginTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBeginTransformFeedback(uint)
            cppSelf->glBeginTransformFeedback(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindAttribLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindAttribLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindAttribLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindAttribLocation(uint,uint,const char*)
            cppSelf->glBindAttribLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindBuffer(uint,uint)
            cppSelf->glBindBuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBufferBase(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindBufferBase";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindBufferBase", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindBufferBase(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBindBufferBase(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBufferBase_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindBufferBase(uint,uint,uint)
            cppSelf->glBindBufferBase(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBufferBase_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFragDataLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindFragDataLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glBindFragDataLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBindFragDataLocation(uint,uint,const char*)
            cppSelf->glBindFragDataLocation(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocationIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindFragDataLocationIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFragDataLocationIndexed", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindFragDataLocationIndexed(uint,uint,uint,const char*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && Shiboken::String::check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[3])))) {
        overloadId = 0; // glBindFragDataLocationIndexed(uint,uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocationIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        const char* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBindFragDataLocationIndexed(uint,uint,uint,const char*)
            cppSelf->glBindFragDataLocationIndexed(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocationIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindFramebuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindFramebuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindFramebuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindFramebuffer(uint,uint)
            cppSelf->glBindFramebuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindImageTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindImageTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindImageTexture", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))) {
        overloadId = 0; // glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindImageTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glBindImageTexture(uint,uint,int,unsigned char,int,uint,uint)
            cppSelf->glBindImageTexture(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindImageTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindProgramPipeline(uint)
            cppSelf->glBindProgramPipeline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindRenderbuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindRenderbuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindRenderbuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindRenderbuffer(uint,uint)
            cppSelf->glBindRenderbuffer(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindSampler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindSampler", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindSampler(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindSampler(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindSampler(uint,uint)
            cppSelf->glBindSampler(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindTexture", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindTexture(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindTexture(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindTexture(uint,uint)
            cppSelf->glBindTexture(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTransformFeedback(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBindTransformFeedback", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindTransformFeedback(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBindTransformFeedback(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBindTransformFeedback(uint,uint)
            cppSelf->glBindTransformFeedback(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBindVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBindVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBindVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBindVertexArray(uint)
            cppSelf->glBindVertexArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendColor(float,float,float,float)
            cppSelf->glBlendColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendEquation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendEquation(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glBlendEquation(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glBlendEquation(uint)
            cppSelf->glBlendEquation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendEquationSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendEquationSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendEquationSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendEquationSeparate(uint,uint)
            cppSelf->glBlendEquationSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparatei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendEquationSeparatei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationSeparatei", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendEquationSeparatei(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBlendEquationSeparatei(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparatei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBlendEquationSeparatei(uint,uint,uint)
            cppSelf->glBlendEquationSeparatei(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparatei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendEquationi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendEquationi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendEquationi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendEquationi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendEquationi(uint,uint)
            cppSelf->glBlendEquationi(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFunc", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendFunc(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glBlendFunc(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glBlendFunc(uint,uint)
            cppSelf->glBlendFunc(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendFuncSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glBlendFuncSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glBlendFuncSeparate(uint,uint,uint,uint)
            cppSelf->glBlendFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparatei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendFuncSeparatei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFuncSeparatei", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendFuncSeparatei(uint,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glBlendFuncSeparatei(uint,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparatei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glBlendFuncSeparatei(uint,uint,uint,uint,uint)
            cppSelf->glBlendFuncSeparatei(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparatei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunci(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlendFunci";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlendFunci", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlendFunci(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glBlendFunci(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunci_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glBlendFunci(uint,uint,uint)
            cppSelf->glBlendFunci(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunci_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlitFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glBlitFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glBlitFramebuffer", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))) {
        overloadId = 0; // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlitFramebuffer_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glBlitFramebuffer(int,int,int,int,int,int,int,int,uint,uint)
            cppSelf->glBlitFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlitFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCheckFramebufferStatus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCheckFramebufferStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCheckFramebufferStatus(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCheckFramebufferStatus(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCheckFramebufferStatus_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCheckFramebufferStatus(uint)
            unsigned int cppResult = cppSelf->glCheckFramebufferStatus(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCheckFramebufferStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClampColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClampColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClampColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClampColor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glClampColor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClampColor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glClampColor(uint,uint)
            cppSelf->glClampColor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClampColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClear(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClear";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClear(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glClear(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClear_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClear(uint)
            cppSelf->glClear(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClear_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearBufferData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferData", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearBufferData(uint,uint,uint,uint,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glClearBufferData(uint,uint,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferData_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glClearBufferData(uint,uint,uint,uint,const void*)
            cppSelf->glClearBufferData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearBufferfi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfi", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearBufferfi(uint,int,float,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glClearBufferfi(uint,int,float,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearBufferfi(uint,int,float,int)
            cppSelf->glClearBufferfi(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearBufferfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearBufferfv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferfv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferfv(uint,int,const float*)
            cppSelf->glClearBufferfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearBufferiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearBufferiv(uint,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferiv(uint,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferiv(uint,int,const int*)
            cppSelf->glClearBufferiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearBufferuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearBufferuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearBufferuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glClearBufferuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glClearBufferuiv(uint,int,const uint*)
            cppSelf->glClearBufferuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glClearColor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearColor(float,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glClearColor(float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearColor_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glClearColor(float,float,float,float)
            cppSelf->glClearColor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearDepth(double)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArg)))) {
        overloadId = 0; // glClearDepth(double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepth_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearDepth(double)
            cppSelf->glClearDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepthf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearDepthf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearDepthf(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glClearDepthf(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepthf_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearDepthf(float)
            cppSelf->glClearDepthf(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepthf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearStencil(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glClearStencil";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glClearStencil(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // glClearStencil(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearStencil_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glClearStencil(int)
            cppSelf->glClearStencil(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearStencil_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMask(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMask", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 4
        && SbkChar_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))) {
        overloadId = 0; // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glColorMask(unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMask(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorMaski", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[4])))) {
        overloadId = 0; // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned char cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glColorMaski(uint,unsigned char,unsigned char,unsigned char,unsigned char)
            cppSelf->glColorMaski(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glColorP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP3ui(uint,uint)
            cppSelf->glColorP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glColorP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP3uiv(uint,const uint*)
            cppSelf->glColorP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP4ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorP4ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glColorP4ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP4ui(uint,uint)
            cppSelf->glColorP4ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glColorP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glColorP4uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glColorP4uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glColorP4uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glColorP4uiv(uint,const uint*)
            cppSelf->glColorP4uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompileShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompileShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompileShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCompileShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompileShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCompileShader(uint)
            cppSelf->glCompileShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompileShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage1D(uint,int,uint,int,int,int,const void*)
            cppSelf->glCompressedTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage2D(uint,int,uint,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexImage3D(uint,int,uint,int,int,int,int,int,const void*)
            cppSelf->glCompressedTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage1D(uint,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage2D(uint,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCompressedTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCompressedTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glCompressedTexSubImage3D(uint,int,int,int,int,int,int,int,uint,int,const void*)
            cppSelf->glCompressedTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyImageSubData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyImageSubData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyImageSubData", 15, 15, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13]), &(pyArgs[14])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
    if (numArgs == 15
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[10])))
        && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[11])))
        && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[12])))
        && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[13])))
        && (pythonToCpp[14] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[14])))) {
        overloadId = 0; // glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyImageSubData_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        int cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);
        int cppArg11;
        pythonToCpp[11](pyArgs[11], &cppArg11);
        int cppArg12;
        pythonToCpp[12](pyArgs[12], &cppArg12);
        int cppArg13;
        pythonToCpp[13](pyArgs[13], &cppArg13);
        int cppArg14;
        pythonToCpp[14](pyArgs[14], &cppArg14);

        if (!PyErr_Occurred()) {
            // glCopyImageSubData(uint,uint,int,int,int,int,uint,uint,int,int,int,int,int,int,int)
            cppSelf->glCopyImageSubData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13, cppArg14);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyImageSubData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyTexImage1D(uint,int,uint,int,int,int,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glCopyTexImage1D(uint,int,uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glCopyTexImage1D(uint,int,uint,int,int,int,int)
            cppSelf->glCopyTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexImage2D(uint,int,uint,int,int,int,int,int)
            cppSelf->glCopyTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage1D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyTexSubImage1D(uint,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glCopyTexSubImage1D(uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage1D(uint,int,int,int,int,int)
            cppSelf->glCopyTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage2D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage2D(uint,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCopyTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glCopyTexSubImage3D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[8])))) {
        overloadId = 0; // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glCopyTexSubImage3D(uint,int,int,int,int,int,int,int,int)
            cppSelf->glCopyTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateProgram(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCreateProgram";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glCreateProgram()
            unsigned int cppResult = cppSelf->glCreateProgram();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCreateShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCreateShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCreateShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCreateShader(uint)
            unsigned int cppResult = cppSelf->glCreateShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glCullFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glCullFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glCullFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glCullFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glCullFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glCullFace(uint)
            cppSelf->glCullFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glCullFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteBuffers(int,const uint*)
            cppSelf->glDeleteBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteFramebuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteFramebuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteFramebuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteFramebuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteFramebuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteFramebuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteFramebuffers(int,const uint*)
            cppSelf->glDeleteFramebuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteFramebuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteProgram(uint)
            cppSelf->glDeleteProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgramPipelines(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteProgramPipelines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteProgramPipelines", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteProgramPipelines(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteProgramPipelines(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgramPipelines_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteProgramPipelines(int,const uint*)
            cppSelf->glDeleteProgramPipelines(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgramPipelines_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteQueries(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteQueries";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteQueries", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteQueries(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteQueries(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteQueries_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteQueries(int,const uint*)
            cppSelf->glDeleteQueries(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteQueries_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteRenderbuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteRenderbuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteRenderbuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteRenderbuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteRenderbuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteRenderbuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteRenderbuffers(int,const uint*)
            cppSelf->glDeleteRenderbuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteRenderbuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteSamplers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteSamplers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteSamplers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteSamplers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteSamplers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteSamplers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteSamplers(int,const uint*)
            cppSelf->glDeleteSamplers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteSamplers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDeleteShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDeleteShader(uint)
            cppSelf->glDeleteShader(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTextures(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteTextures";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteTextures", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteTextures(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteTextures(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTextures_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteTextures(int,const uint*)
            cppSelf->glDeleteTextures(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTextures_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTransformFeedbacks(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteTransformFeedbacks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteTransformFeedbacks", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteTransformFeedbacks(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteTransformFeedbacks(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTransformFeedbacks_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteTransformFeedbacks(int,const uint*)
            cppSelf->glDeleteTransformFeedbacks(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTransformFeedbacks_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteVertexArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDeleteVertexArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDeleteVertexArrays", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDeleteVertexArrays(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDeleteVertexArrays(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteVertexArrays_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDeleteVertexArrays(int,const uint*)
            cppSelf->glDeleteVertexArrays(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteVertexArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthFunc(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthFunc(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDepthFunc(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthFunc(uint)
            cppSelf->glDepthFunc(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthMask(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glDepthMask(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthMask_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDepthMask(unsigned char)
            cppSelf->glDepthMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRange(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRange", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthRange(double,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glDepthRange(double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRange_TypeError;

    // Call function/method
    {
        double cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDepthRange(double,double)
            cppSelf->glDepthRange(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeArrayv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthRangeArrayv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRangeArrayv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthRangeArrayv(uint,int,const double*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glDepthRangeArrayv(uint,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeArrayv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<double> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDepthRangeArrayv(uint,int,const double*)
            cppSelf->glDepthRangeArrayv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeArrayv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthRangeIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRangeIndexed", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthRangeIndexed(uint,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glDepthRangeIndexed(uint,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDepthRangeIndexed(uint,double,double)
            cppSelf->glDepthRangeIndexed(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangef(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDepthRangef";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDepthRangef", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDepthRangef(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glDepthRangef(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangef_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDepthRangef(float,float)
            cppSelf->glDepthRangef(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangef_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDetachShader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDetachShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDetachShader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDetachShader(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDetachShader(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDetachShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDetachShader(uint,uint)
            cppSelf->glDetachShader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDetachShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDisable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDisable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisable(uint)
            cppSelf->glDisable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDisableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDisableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDisableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDisableVertexAttribArray(uint)
            cppSelf->glDisableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDisablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDisablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDisablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDisablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDisablei(uint,uint)
            cppSelf->glDisablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDispatchCompute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDispatchCompute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDispatchCompute", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDispatchCompute(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glDispatchCompute(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDispatchCompute_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDispatchCompute(uint,uint,uint)
            cppSelf->glDispatchCompute(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDispatchCompute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArrays", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawArrays(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawArrays(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawArrays(uint,int,int)
            cppSelf->glDrawArrays(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysIndirect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawArraysIndirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysIndirect", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawArraysIndirect(uint,const void*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
        overloadId = 0; // glDrawArraysIndirect(uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysIndirect_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawArraysIndirect(uint,const void*)
            cppSelf->glDrawArraysIndirect(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysIndirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawArraysInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysInstanced", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawArraysInstanced(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawArraysInstanced(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawArraysInstanced(uint,int,int,int)
            cppSelf->glDrawArraysInstanced(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstancedBaseInstance(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawArraysInstancedBaseInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawArraysInstancedBaseInstance", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawArraysInstancedBaseInstance(uint,int,int,int,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawArraysInstancedBaseInstance(uint,int,int,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstancedBaseInstance_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawArraysInstancedBaseInstance(uint,int,int,int,uint)
            cppSelf->glDrawArraysInstancedBaseInstance(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstancedBaseInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glDrawBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glDrawBuffer(uint)
            cppSelf->glDrawBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffers(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawBuffers", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawBuffers(int,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glDrawBuffers(int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffers_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawBuffers(int,const uint*)
            cppSelf->glDrawBuffers(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElements", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElements(uint,int,uint,const void*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawElements(uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawElements(uint,int,uint,const void*)
            cppSelf->glDrawElements(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsBaseVertex", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsBaseVertex(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsIndirect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsIndirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsIndirect", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsIndirect(uint,uint,const void*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawElementsIndirect(uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsIndirect_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawElementsIndirect(uint,uint,const void*)
            cppSelf->glDrawElementsIndirect(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsIndirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstanced", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsInstanced(uint,int,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glDrawElementsInstanced(uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstanced(uint,int,uint,const void*,int)
            cppSelf->glDrawElementsInstanced(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseInstance(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsInstancedBaseInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstancedBaseInstance", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsInstancedBaseInstance(uint,int,uint,const void*,int,uint)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawElementsInstancedBaseInstance(uint,int,uint,const void*,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseInstance_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstancedBaseInstance(uint,int,uint,const void*,int,uint)
            cppSelf->glDrawElementsInstancedBaseInstance(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsInstancedBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstancedBaseVertex", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstancedBaseVertex(uint,int,uint,const void*,int,int)
            cppSelf->glDrawElementsInstancedBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertexBaseInstance(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawElementsInstancedBaseVertexBaseInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawElementsInstancedBaseVertexBaseInstance", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawElementsInstancedBaseVertexBaseInstance(uint,int,uint,const void*,int,int,uint)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))) {
        overloadId = 0; // glDrawElementsInstancedBaseVertexBaseInstance(uint,int,uint,const void*,int,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertexBaseInstance_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glDrawElementsInstancedBaseVertexBaseInstance(uint,int,uint,const void*,int,int,uint)
            cppSelf->glDrawElementsInstancedBaseVertexBaseInstance(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertexBaseInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElements(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawRangeElements";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElements", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElements_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glDrawRangeElements(uint,uint,uint,int,uint,const void*)
            cppSelf->glDrawRangeElements(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElements_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElementsBaseVertex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawRangeElementsBaseVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawRangeElementsBaseVertex", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElementsBaseVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glDrawRangeElementsBaseVertex(uint,uint,uint,int,uint,const void*,int)
            cppSelf->glDrawRangeElementsBaseVertex(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawRangeElementsBaseVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedback(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawTransformFeedback", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawTransformFeedback(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glDrawTransformFeedback(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glDrawTransformFeedback(uint,uint)
            cppSelf->glDrawTransformFeedback(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawTransformFeedbackInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawTransformFeedbackInstanced", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawTransformFeedbackInstanced(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawTransformFeedbackInstanced(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawTransformFeedbackInstanced(uint,uint,int)
            cppSelf->glDrawTransformFeedbackInstanced(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStream(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawTransformFeedbackStream";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawTransformFeedbackStream", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawTransformFeedbackStream(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glDrawTransformFeedbackStream(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStream_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glDrawTransformFeedbackStream(uint,uint,uint)
            cppSelf->glDrawTransformFeedbackStream(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStream_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStreamInstanced(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glDrawTransformFeedbackStreamInstanced";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glDrawTransformFeedbackStreamInstanced", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glDrawTransformFeedbackStreamInstanced(uint,uint,uint,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glDrawTransformFeedbackStreamInstanced(uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStreamInstanced_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glDrawTransformFeedbackStreamInstanced(uint,uint,uint,int)
            cppSelf->glDrawTransformFeedbackStreamInstanced(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawTransformFeedbackStreamInstanced_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEnable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glEnable(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnable(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnable_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnable(uint)
            cppSelf->glEnable(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnableVertexAttribArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEnableVertexAttribArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glEnableVertexAttribArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEnableVertexAttribArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnableVertexAttribArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEnableVertexAttribArray(uint)
            cppSelf->glEnableVertexAttribArray(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnableVertexAttribArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnablei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEnablei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEnablei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glEnablei(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glEnablei(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnablei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEnablei(uint,uint)
            cppSelf->glEnablei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glEnablei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndConditionalRender(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEndConditionalRender";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndConditionalRender()
            cppSelf->glEndConditionalRender();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEndQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glEndQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glEndQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glEndQuery(uint)
            cppSelf->glEndQuery(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQueryIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEndQueryIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glEndQueryIndexed", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glEndQueryIndexed(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glEndQueryIndexed(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQueryIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glEndQueryIndexed(uint,uint)
            cppSelf->glEndQueryIndexed(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndQueryIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glEndTransformFeedback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glEndTransformFeedback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glEndTransformFeedback()
            cppSelf->glEndTransformFeedback();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFinish(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFinish";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFinish()
            cppSelf->glFinish();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFlush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFlush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glFlush()
            cppSelf->glFlush();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glFramebufferParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glFramebufferParameteri(uint,uint,int)
            cppSelf->glFramebufferParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferRenderbuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferRenderbuffer", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferRenderbuffer(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferRenderbuffer(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferRenderbuffer(uint,uint,uint,uint)
            cppSelf->glFramebufferRenderbuffer(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferTexture(uint,uint,uint,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glFramebufferTexture(uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture(uint,uint,uint,int)
            cppSelf->glFramebufferTexture(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferTexture1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture1D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferTexture1D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture1D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture1D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferTexture2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture2D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferTexture2D(uint,uint,uint,uint,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTexture2D(uint,uint,uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture2D(uint,uint,uint,uint,int)
            cppSelf->glFramebufferTexture2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferTexture3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTexture3D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glFramebufferTexture3D(uint,uint,uint,uint,int,int)
            cppSelf->glFramebufferTexture3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTexture3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTextureLayer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFramebufferTextureLayer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glFramebufferTextureLayer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFramebufferTextureLayer(uint,uint,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glFramebufferTextureLayer(uint,uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTextureLayer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glFramebufferTextureLayer(uint,uint,uint,int,int)
            cppSelf->glFramebufferTextureLayer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFramebufferTextureLayer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glFrontFace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glFrontFace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glFrontFace(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glFrontFace(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glFrontFace_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glFrontFace(uint)
            cppSelf->glFrontFace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glFrontFace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGenerateMipmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGenerateMipmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGenerateMipmap(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGenerateMipmap(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGenerateMipmap_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGenerateMipmap(uint)
            cppSelf->glGenerateMipmap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGenerateMipmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetAttribLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetAttribLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetAttribLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetAttribLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetAttribLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetAttribLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetAttribLocation(uint,const char*)
            int cppResult = cppSelf->glGetAttribLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetAttribLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glGetError()
            unsigned int cppResult = cppSelf->glGetError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetFragDataIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetFragDataIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataIndex(uint,const char*)
            int cppResult = cppSelf->glGetFragDataIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetFragDataLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetFragDataLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetFragDataLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetFragDataLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetFragDataLocation(uint,const char*)
            int cppResult = cppSelf->glGetFragDataLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetFragDataLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetProgramResourceIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceIndex", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetProgramResourceIndex(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetProgramResourceIndex(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceIndex(uint,uint,const char*)
            unsigned int cppResult = cppSelf->glGetProgramResourceIndex(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetProgramResourceLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetProgramResourceLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetProgramResourceLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceLocation(uint,uint,const char*)
            int cppResult = cppSelf->glGetProgramResourceLocation(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocationIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetProgramResourceLocationIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetProgramResourceLocationIndex", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetProgramResourceLocationIndex(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetProgramResourceLocationIndex(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocationIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetProgramResourceLocationIndex(uint,uint,const char*)
            int cppResult = cppSelf->glGetProgramResourceLocationIndex(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetProgramResourceLocationIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetString(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glGetString(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetString_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glGetString(uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetString(cppArg0);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetStringi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetStringi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetStringi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetStringi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glGetStringi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetStringi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetStringi(uint,uint)
            // Begin code injection
            // TEMPLATE - glGetString_return_QString - START
            const GLubyte *us = cppSelf->glGetStringi(cppArg0, cppArg1);
            const QString s = QString::fromLocal8Bit(reinterpret_cast<const char *>(us));
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &s);
            // TEMPLATE - glGetString_return_QString - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetStringi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetSubroutineIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSubroutineIndex", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetSubroutineIndex(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetSubroutineIndex(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSubroutineIndex(uint,uint,const char*)
            unsigned int cppResult = cppSelf->glGetSubroutineIndex(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineUniformLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetSubroutineUniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetSubroutineUniformLocation", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetSubroutineUniformLocation(uint,uint,const char*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && Shiboken::String::check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[2])))) {
        overloadId = 0; // glGetSubroutineUniformLocation(uint,uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineUniformLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        const char* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glGetSubroutineUniformLocation(uint,uint,const char*)
            int cppResult = cppSelf->glGetSubroutineUniformLocation(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetSubroutineUniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformBlockIndex(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetUniformBlockIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformBlockIndex", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetUniformBlockIndex(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformBlockIndex(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformBlockIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformBlockIndex(uint,const char*)
            unsigned int cppResult = cppSelf->glGetUniformBlockIndex(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformBlockIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformLocation(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glGetUniformLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glGetUniformLocation", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glGetUniformLocation(uint,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // glGetUniformLocation(uint,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformLocation_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glGetUniformLocation(uint,const char*)
            int cppResult = cppSelf->glGetUniformLocation(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glGetUniformLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glHint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glHint", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glHint(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glHint(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glHint_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glHint(uint,uint)
            cppSelf->glHint(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexub(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIndexub";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIndexub(unsigned char)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexub(unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexub_TypeError;

    // Call function/method
    {
        unsigned char cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexub(unsigned char)
            cppSelf->glIndexub(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexub_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexubv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIndexubv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIndexubv(const unsigned char*)
    if (SbkChar_Check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArg)))) {
        overloadId = 0; // glIndexubv(const unsigned char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexubv_TypeError;

    // Call function/method
    {
        unsigned char *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIndexubv(const unsigned char*)
            cppSelf->glIndexubv(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIndexubv_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateBufferData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glInvalidateBufferData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glInvalidateBufferData(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glInvalidateBufferData(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateBufferData_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glInvalidateBufferData(uint)
            cppSelf->glInvalidateBufferData(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateBufferData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glInvalidateFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateFramebuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glInvalidateFramebuffer(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glInvalidateFramebuffer(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glInvalidateFramebuffer(uint,int,const uint*)
            cppSelf->glInvalidateFramebuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateSubFramebuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glInvalidateSubFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateSubFramebuffer", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))) {
        overloadId = 0; // glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateSubFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glInvalidateSubFramebuffer(uint,int,const uint*,int,int,int,int)
            cppSelf->glInvalidateSubFramebuffer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateSubFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexImage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glInvalidateTexImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateTexImage", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glInvalidateTexImage(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glInvalidateTexImage(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexImage_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glInvalidateTexImage(uint,int)
            cppSelf->glInvalidateTexImage(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexSubImage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glInvalidateTexSubImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glInvalidateTexSubImage", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glInvalidateTexSubImage(uint,int,int,int,int,int,int,int)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))) {
        overloadId = 0; // glInvalidateTexSubImage(uint,int,int,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexSubImage_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glInvalidateTexSubImage(uint,int,int,int,int,int,int,int)
            cppSelf->glInvalidateTexSubImage(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glInvalidateTexSubImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsBuffer(uint)
            unsigned char cppResult = cppSelf->glIsBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsEnabled(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsEnabled(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabled_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsEnabled(uint)
            unsigned char cppResult = cppSelf->glIsEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabledi(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsEnabledi";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glIsEnabledi", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsEnabledi(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glIsEnabledi(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabledi_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glIsEnabledi(uint,uint)
            unsigned char cppResult = cppSelf->glIsEnabledi(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsEnabledi_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsFramebuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsFramebuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsFramebuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsFramebuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsFramebuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsFramebuffer(uint)
            unsigned char cppResult = cppSelf->glIsFramebuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsFramebuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsProgram(uint)
            unsigned char cppResult = cppSelf->glIsProgram(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsProgramPipeline(uint)
            unsigned char cppResult = cppSelf->glIsProgramPipeline(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsQuery(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsQuery(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsQuery_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsQuery(uint)
            unsigned char cppResult = cppSelf->glIsQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsRenderbuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsRenderbuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsRenderbuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsRenderbuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsRenderbuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsRenderbuffer(uint)
            unsigned char cppResult = cppSelf->glIsRenderbuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsRenderbuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsSampler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsSampler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsSampler(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsSampler(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsSampler_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsSampler(uint)
            unsigned char cppResult = cppSelf->glIsSampler(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsSampler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsShader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsShader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsShader(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsShader(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsShader_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsShader(uint)
            unsigned char cppResult = cppSelf->glIsShader(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsShader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsTexture(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsTexture(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTexture_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsTexture(uint)
            unsigned char cppResult = cppSelf->glIsTexture(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTransformFeedback(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsTransformFeedback";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsTransformFeedback(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsTransformFeedback(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTransformFeedback_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsTransformFeedback(uint)
            unsigned char cppResult = cppSelf->glIsTransformFeedback(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsTransformFeedback_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsVertexArray(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glIsVertexArray";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glIsVertexArray(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glIsVertexArray(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsVertexArray_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glIsVertexArray(uint)
            unsigned char cppResult = cppSelf->glIsVertexArray(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glIsVertexArray_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glLineWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glLineWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glLineWidth(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glLineWidth(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glLineWidth_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLineWidth(float)
            cppSelf->glLineWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glLineWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glLinkProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glLinkProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glLinkProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLinkProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glLinkProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLinkProgram(uint)
            cppSelf->glLinkProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glLinkProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glLogicOp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glLogicOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glLogicOp(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glLogicOp(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glLogicOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glLogicOp(uint)
            cppSelf->glLogicOp(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glLogicOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMapBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMapBuffer", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMapBuffer(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glMapBuffer(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glMapBuffer(uint,uint)
            void * cppResult = cppSelf->glMapBuffer(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMemoryBarrier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMemoryBarrier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMemoryBarrier(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glMemoryBarrier(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMemoryBarrier_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMemoryBarrier(uint)
            cppSelf->glMemoryBarrier(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMemoryBarrier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMinSampleShading(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMinSampleShading";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMinSampleShading(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glMinSampleShading(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMinSampleShading_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glMinSampleShading(float)
            cppSelf->glMinSampleShading(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMinSampleShading_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArrays(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiDrawArrays";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiDrawArrays", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiDrawArrays(uint,const int*,const int*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiDrawArrays(uint,const int*,const int*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArrays_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiDrawArrays(uint,const int*,const int*,int)
            cppSelf->glMultiDrawArrays(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArrays_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArraysIndirect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiDrawArraysIndirect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiDrawArraysIndirect", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiDrawArraysIndirect(uint,const void*,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glMultiDrawArraysIndirect(uint,const void*,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArraysIndirect_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glMultiDrawArraysIndirect(uint,const void*,int,int)
            cppSelf->glMultiDrawArraysIndirect(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiDrawArraysIndirect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP1ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP1ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP1ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP1ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP1ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP1uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP1uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP1uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP1uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP1uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP2ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP2ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP2ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP2ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP2ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP2uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP2uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP2uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP2uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP2uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP3ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP3ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP3ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP3ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP3ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP3uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP3uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP3uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP3uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP3uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP4ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP4ui(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP4ui(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP4ui(uint,uint,uint)
            cppSelf->glMultiTexCoordP4ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glMultiTexCoordP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glMultiTexCoordP4uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glMultiTexCoordP4uiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glMultiTexCoordP4uiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glMultiTexCoordP4uiv(uint,uint,const uint*)
            cppSelf->glMultiTexCoordP4uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glMultiTexCoordP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glNormalP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormalP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glNormalP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glNormalP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glNormalP3ui(uint,uint)
            cppSelf->glNormalP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glNormalP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glNormalP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glNormalP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glNormalP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glNormalP3uiv(uint,const uint*)
            cppSelf->glNormalP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glNormalP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPatchParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPatchParameterfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPatchParameterfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPatchParameterfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPatchParameterfv(uint,const float*)
            cppSelf->glPatchParameterfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPatchParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPatchParameteri", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPatchParameteri(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPatchParameteri(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPatchParameteri(uint,int)
            cppSelf->glPatchParameteri(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPatchParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPauseTransformFeedback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPauseTransformFeedback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glPauseTransformFeedback()
            cppSelf->glPauseTransformFeedback();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStoref(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPixelStoref";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStoref", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPixelStoref(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStoref(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStoref_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStoref(uint,float)
            cppSelf->glPixelStoref(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStoref_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStorei(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPixelStorei";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPixelStorei", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPixelStorei(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPixelStorei(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStorei_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPixelStorei(uint,int)
            cppSelf->glPixelStorei(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPixelStorei_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPointParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterf", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPointParameterf(uint,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameterf(uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterf(uint,float)
            cppSelf->glPointParameterf(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPointParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameterfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPointParameterfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameterfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameterfv(uint,const float*)
            cppSelf->glPointParameterfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPointParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteri", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPointParameteri(uint,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glPointParameteri(uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteri(uint,int)
            cppSelf->glPointParameteri(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPointParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPointParameteriv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPointParameteriv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glPointParameteriv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPointParameteriv(uint,const int*)
            cppSelf->glPointParameteriv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPointSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPointSize(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // glPointSize(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointSize_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPointSize(float)
            cppSelf->glPointSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPointSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonMode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPolygonMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonMode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPolygonMode(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonMode(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonMode(uint,uint)
            cppSelf->glPolygonMode(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonOffset(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPolygonOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glPolygonOffset", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPolygonOffset(float,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glPolygonOffset(float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonOffset_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glPolygonOffset(float,float)
            cppSelf->glPolygonOffset(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPolygonOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glPrimitiveRestartIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glPrimitiveRestartIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glPrimitiveRestartIndex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glPrimitiveRestartIndex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glPrimitiveRestartIndex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glPrimitiveRestartIndex(uint)
            cppSelf->glPrimitiveRestartIndex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glPrimitiveRestartIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramBinary(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramBinary";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramBinary", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramBinary(uint,uint,const void*,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramBinary(uint,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramBinary_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        void* cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramBinary(uint,uint,const void*,int)
            cppSelf->glProgramBinary(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramBinary_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramParameteri(uint,uint,int)
            cppSelf->glProgramParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1d(uint,int,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1d(uint,int,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1d(uint,int,double)
            cppSelf->glProgramUniform1d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1dv(uint,int,int,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1dv(uint,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1dv(uint,int,int,const double*)
            cppSelf->glProgramUniform1dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1f(uint,int,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1f(uint,int,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1f(uint,int,float)
            cppSelf->glProgramUniform1f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1fv(uint,int,int,const float*)
            cppSelf->glProgramUniform1fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1i(uint,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1i(uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1i(uint,int,int)
            cppSelf->glProgramUniform1i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1iv(uint,int,int,const int*)
            cppSelf->glProgramUniform1iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1ui(uint,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glProgramUniform1ui(uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glProgramUniform1ui(uint,int,uint)
            cppSelf->glProgramUniform1ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform1uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform1uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform1uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform1uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform1uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2d(uint,int,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2d(uint,int,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2d(uint,int,double,double)
            cppSelf->glProgramUniform2d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2dv(uint,int,int,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2dv(uint,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2dv(uint,int,int,const double*)
            cppSelf->glProgramUniform2dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2f(uint,int,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2f(uint,int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2f(uint,int,float,float)
            cppSelf->glProgramUniform2f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2fv(uint,int,int,const float*)
            cppSelf->glProgramUniform2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2i(uint,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2i(uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2i(uint,int,int,int)
            cppSelf->glProgramUniform2i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2iv(uint,int,int,const int*)
            cppSelf->glProgramUniform2iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2ui(uint,int,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2ui(uint,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2ui(uint,int,uint,uint)
            cppSelf->glProgramUniform2ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform2uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform2uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform2uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform2uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform2uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3d", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3d(uint,int,double,double,double)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3d(uint,int,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3d(uint,int,double,double,double)
            cppSelf->glProgramUniform3d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3dv(uint,int,int,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3dv(uint,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3dv(uint,int,int,const double*)
            cppSelf->glProgramUniform3dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3f", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3f(uint,int,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3f(uint,int,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3f(uint,int,float,float,float)
            cppSelf->glProgramUniform3f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3fv(uint,int,int,const float*)
            cppSelf->glProgramUniform3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3i(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3i(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3i(uint,int,int,int,int)
            cppSelf->glProgramUniform3i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3iv(uint,int,int,const int*)
            cppSelf->glProgramUniform3iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3ui(uint,int,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glProgramUniform3ui(uint,int,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniform3ui(uint,int,uint,uint,uint)
            cppSelf->glProgramUniform3ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform3uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform3uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform3uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform3uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform3uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4d", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4d(uint,int,double,double,double,double)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4d(uint,int,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        double cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4d(uint,int,double,double,double,double)
            cppSelf->glProgramUniform4d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4dv(uint,int,int,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4dv(uint,int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4dv(uint,int,int,const double*)
            cppSelf->glProgramUniform4dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4f", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4f(uint,int,float,float,float,float)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4f(uint,int,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4f_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        float cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4f(uint,int,float,float,float,float)
            cppSelf->glProgramUniform4f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4fv(uint,int,int,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4fv(uint,int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4fv(uint,int,int,const float*)
            cppSelf->glProgramUniform4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4i", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4i(uint,int,int,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4i(uint,int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4i_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4i(uint,int,int,int,int,int)
            cppSelf->glProgramUniform4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4iv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4iv(uint,int,int,const int*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4iv(uint,int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4iv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4iv(uint,int,int,const int*)
            cppSelf->glProgramUniform4iv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4ui", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4ui(uint,int,uint,uint,uint,uint)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))) {
        overloadId = 0; // glProgramUniform4ui(uint,int,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glProgramUniform4ui(uint,int,uint,uint,uint,uint)
            cppSelf->glProgramUniform4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniform4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniform4uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniform4uiv(uint,int,int,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glProgramUniform4uiv(uint,int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glProgramUniform4uiv(uint,int,int,const uint*)
            cppSelf->glProgramUniform4uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniform4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix2dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2x3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x3dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2x3dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x3dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x3dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix2x3dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2x3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2x4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x4dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2x4dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x4dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x4dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix2x4dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix2x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix2x4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix2x4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix2x4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix2x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix3dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3x2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x2dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3x2dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x2dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x2dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix3x2dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3x2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3x4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x4dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3x4dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x4dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x4dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix3x4dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix3x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix3x4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix3x4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix3x4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix3x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix4dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4x2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x2dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4x2dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x2dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x2dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix4x2dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x2fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x2fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4x2fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4x3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x3dv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4x3dv(uint,int,int,unsigned char,const double*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x3dv(uint,int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<double> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x3dv(uint,int,int,unsigned char,const double*)
            cppSelf->glProgramUniformMatrix4x3dv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProgramUniformMatrix4x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glProgramUniformMatrix4x3fv", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && PyFloat_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[4])))) {
        overloadId = 0; // glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3fv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        Shiboken::Conversions::ArrayHandle<float> cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glProgramUniformMatrix4x3fv(uint,int,int,unsigned char,const float*)
            cppSelf->glProgramUniformMatrix4x3fv(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProgramUniformMatrix4x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glProvokingVertex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glProvokingVertex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glProvokingVertex(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glProvokingVertex(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glProvokingVertex_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glProvokingVertex(uint)
            cppSelf->glProvokingVertex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glProvokingVertex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glQueryCounter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glQueryCounter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glQueryCounter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glQueryCounter(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glQueryCounter(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glQueryCounter_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glQueryCounter(uint,uint)
            cppSelf->glQueryCounter(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glQueryCounter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glReadBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glReadBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glReadBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glReadBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glReadBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glReadBuffer(uint)
            cppSelf->glReadBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glReadBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glReleaseShaderCompiler(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glReleaseShaderCompiler";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glReleaseShaderCompiler()
            cppSelf->glReleaseShaderCompiler();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glRenderbufferStorage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorage", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glRenderbufferStorage(uint,uint,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glRenderbufferStorage(uint,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorage_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorage(uint,uint,int,int)
            cppSelf->glRenderbufferStorage(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorageMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glRenderbufferStorageMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glRenderbufferStorageMultisample", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glRenderbufferStorageMultisample(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glRenderbufferStorageMultisample(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorageMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glRenderbufferStorageMultisample(uint,int,uint,int,int)
            cppSelf->glRenderbufferStorageMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glRenderbufferStorageMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glResumeTransformFeedback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glResumeTransformFeedback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // glResumeTransformFeedback()
            cppSelf->glResumeTransformFeedback();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleCoverage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSampleCoverage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleCoverage", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSampleCoverage(float,unsigned char)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleCoverage(float,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleCoverage_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned char cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleCoverage(float,unsigned char)
            cppSelf->glSampleCoverage(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleCoverage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleMaski(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSampleMaski";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSampleMaski", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSampleMaski(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glSampleMaski(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleMaski_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSampleMaski(uint,uint)
            cppSelf->glSampleMaski(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSampleMaski_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIiv(uint,uint,const int*)
            cppSelf->glSamplerParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterIuiv(uint,uint,const uint*)
            cppSelf->glSamplerParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterf(uint,uint,float)
            cppSelf->glSamplerParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameterfv(uint,uint,const float*)
            cppSelf->glSamplerParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteri(uint,uint,int)
            cppSelf->glSamplerParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSamplerParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSamplerParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSamplerParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glSamplerParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glSamplerParameteriv(uint,uint,const int*)
            cppSelf->glSamplerParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSamplerParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glScissor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissor", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glScissor(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glScissor(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glScissor(int,int,int,int)
            cppSelf->glScissor(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorArrayv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glScissorArrayv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissorArrayv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glScissorArrayv(uint,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glScissorArrayv(uint,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorArrayv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glScissorArrayv(uint,int,const int*)
            cppSelf->glScissorArrayv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorArrayv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glScissorIndexed";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissorIndexed", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glScissorIndexed(uint,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glScissorIndexed(uint,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexed_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glScissorIndexed(uint,int,int,int,int)
            cppSelf->glScissorIndexed(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexed_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexedv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glScissorIndexedv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glScissorIndexedv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glScissorIndexedv(uint,const int*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glScissorIndexedv(uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexedv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glScissorIndexedv(uint,const int*)
            cppSelf->glScissorIndexedv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glScissorIndexedv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSecondaryColorP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColorP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSecondaryColorP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glSecondaryColorP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSecondaryColorP3ui(uint,uint)
            cppSelf->glSecondaryColorP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glSecondaryColorP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glSecondaryColorP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glSecondaryColorP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glSecondaryColorP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glSecondaryColorP3uiv(uint,const uint*)
            cppSelf->glSecondaryColorP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glSecondaryColorP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderBinary(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glShaderBinary";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glShaderBinary", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glShaderBinary(int,const uint*,uint,const void*,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glShaderBinary(int,const uint*,uint,const void*,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderBinary_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        void* cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glShaderBinary(int,const uint*,uint,const void*,int)
            cppSelf->glShaderBinary(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderBinary_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderStorageBlockBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glShaderStorageBlockBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glShaderStorageBlockBinding", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glShaderStorageBlockBinding(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glShaderStorageBlockBinding(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderStorageBlockBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glShaderStorageBlockBinding(uint,uint,uint)
            cppSelf->glShaderStorageBlockBinding(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glShaderStorageBlockBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFunc(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilFunc";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFunc", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilFunc(uint,int,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilFunc(uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFunc_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilFunc(uint,int,uint)
            cppSelf->glStencilFunc(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFunc_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFuncSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilFuncSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilFuncSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilFuncSeparate(uint,uint,int,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilFuncSeparate(uint,uint,int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFuncSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilFuncSeparate(uint,uint,int,uint)
            cppSelf->glStencilFuncSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilFuncSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilMask(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glStencilMask(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMask_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glStencilMask(uint)
            cppSelf->glStencilMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMaskSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilMaskSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilMaskSeparate", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilMaskSeparate(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glStencilMaskSeparate(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMaskSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glStencilMaskSeparate(uint,uint)
            cppSelf->glStencilMaskSeparate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilMaskSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOp(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilOp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOp", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilOp(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glStencilOp(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOp_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glStencilOp(uint,uint,uint)
            cppSelf->glStencilOp(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOp_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOpSeparate(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glStencilOpSeparate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glStencilOpSeparate", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glStencilOpSeparate(uint,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glStencilOpSeparate(uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOpSeparate_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glStencilOpSeparate(uint,uint,uint,uint)
            cppSelf->glStencilOpSeparate(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glStencilOpSeparate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexBuffer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexBuffer", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexBuffer(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexBuffer(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexBuffer(uint,uint,uint)
            cppSelf->glTexBuffer(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP1ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP1ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP1ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP1ui(uint,uint)
            cppSelf->glTexCoordP1ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP1uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP1uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP1uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP1uiv(uint,const uint*)
            cppSelf->glTexCoordP1uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP2ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP2ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP2ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP2ui(uint,uint)
            cppSelf->glTexCoordP2ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP2uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP2uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP2uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP2uiv(uint,const uint*)
            cppSelf->glTexCoordP2uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP3ui(uint,uint)
            cppSelf->glTexCoordP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP3uiv(uint,const uint*)
            cppSelf->glTexCoordP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP4ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP4ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP4ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP4ui(uint,uint)
            cppSelf->glTexCoordP4ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexCoordP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexCoordP4uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexCoordP4uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glTexCoordP4uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glTexCoordP4uiv(uint,const uint*)
            cppSelf->glTexCoordP4uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexCoordP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage1D", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[7])))) {
        overloadId = 0; // glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        void* cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glTexImage1D(uint,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glTexImage2D(uint,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexImage2DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage2DMultisample", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexImage2DMultisample(uint,int,int,int,int,unsigned char)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[5])))) {
        overloadId = 0; // glTexImage2DMultisample(uint,int,int,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned char cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glTexImage2DMultisample(uint,int,int,int,int,unsigned char)
            cppSelf->glTexImage2DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage2DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage3D", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[9])))) {
        overloadId = 0; // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        void* cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);

        if (!PyErr_Occurred()) {
            // glTexImage3D(uint,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexImage3DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexImage3DMultisample", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexImage3DMultisample(uint,int,int,int,int,int,unsigned char)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && SbkChar_Check(pyArgs[6]) && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[6])))) {
        overloadId = 0; // glTexImage3DMultisample(uint,int,int,int,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned char cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glTexImage3DMultisample(uint,int,int,int,int,int,unsigned char)
            cppSelf->glTexImage3DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexImage3DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameterIiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameterIiv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIiv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIiv(uint,uint,const int*)
            cppSelf->glTexParameterIiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameterIuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterIuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameterIuiv(uint,uint,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterIuiv(uint,uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterIuiv(uint,uint,const uint*)
            cppSelf->glTexParameterIuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterIuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameterf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterf", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameterf(uint,uint,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glTexParameterf(uint,uint,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterf(uint,uint,float)
            cppSelf->glTexParameterf(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameterfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameterfv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameterfv(uint,uint,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameterfv(uint,uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameterfv(uint,uint,const float*)
            cppSelf->glTexParameterfv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameterfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteri(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameteri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameteri", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameteri(uint,uint,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glTexParameteri(uint,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteri_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameteri(uint,uint,int)
            cppSelf->glTexParameteri(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteri_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteriv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexParameteriv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexParameteriv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexParameteriv(uint,uint,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glTexParameteriv(uint,uint,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteriv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glTexParameteriv(uint,uint,const int*)
            cppSelf->glTexParameteriv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexParameteriv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexStorage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage1D", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexStorage1D(uint,int,uint,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glTexStorage1D(uint,int,uint,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glTexStorage1D(uint,int,uint,int)
            cppSelf->glTexStorage1D(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexStorage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage2D", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexStorage2D(uint,int,uint,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glTexStorage2D(uint,int,uint,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glTexStorage2D(uint,int,uint,int,int)
            cppSelf->glTexStorage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexStorage2DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage2DMultisample", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[5])))) {
        overloadId = 0; // glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned char cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glTexStorage2DMultisample(uint,int,uint,int,int,unsigned char)
            cppSelf->glTexStorage2DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage2DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexStorage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage3D", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexStorage3D(uint,int,uint,int,int,int)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))) {
        overloadId = 0; // glTexStorage3D(uint,int,uint,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glTexStorage3D(uint,int,uint,int,int,int)
            cppSelf->glTexStorage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3DMultisample(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexStorage3DMultisample";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexStorage3DMultisample", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && SbkChar_Check(pyArgs[6]) && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[6])))) {
        overloadId = 0; // glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3DMultisample_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned char cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glTexStorage3DMultisample(uint,int,uint,int,int,int,unsigned char)
            cppSelf->glTexStorage3DMultisample(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexStorage3DMultisample_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage1D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexSubImage1D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage1D", 7, 7, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
    if (numArgs == 7
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[6])))) {
        overloadId = 0; // glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage1D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        void* cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // glTexSubImage1D(uint,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage1D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage1D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage2D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexSubImage2D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage2D", 9, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[8])))) {
        overloadId = 0; // glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage2D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        void* cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!PyErr_Occurred()) {
            // glTexSubImage2D(uint,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage2D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage2D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage3D(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTexSubImage3D";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTexSubImage3D", 11, 11, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    if (numArgs == 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[10])))) {
        overloadId = 0; // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage3D_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);
        unsigned int cppArg8;
        pythonToCpp[8](pyArgs[8], &cppArg8);
        unsigned int cppArg9;
        pythonToCpp[9](pyArgs[9], &cppArg9);
        void* cppArg10;
        pythonToCpp[10](pyArgs[10], &cppArg10);

        if (!PyErr_Occurred()) {
            // glTexSubImage3D(uint,int,int,int,int,int,int,int,uint,uint,const void*)
            cppSelf->glTexSubImage3D(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTexSubImage3D_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glTextureView(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glTextureView";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glTextureView", 8, 8, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glTextureView(uint,uint,uint,uint,uint,uint,uint,uint)
    if (numArgs == 8
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[7])))) {
        overloadId = 0; // glTextureView(uint,uint,uint,uint,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glTextureView_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        unsigned int cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        unsigned int cppArg6;
        pythonToCpp[6](pyArgs[6], &cppArg6);
        unsigned int cppArg7;
        pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!PyErr_Occurred()) {
            // glTextureView(uint,uint,uint,uint,uint,uint,uint,uint)
            cppSelf->glTextureView(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glTextureView_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1d(int,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1d(int,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1d(int,double)
            cppSelf->glUniform1d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1dv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1dv(int,int,const double*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1dv(int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<double> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1dv(int,int,const double*)
            cppSelf->glUniform1dv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1f", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1f(int,float)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1f(int,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1f(int,float)
            cppSelf->glUniform1f(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1fv(int,int,const float*)
            cppSelf->glUniform1fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1i", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1i(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1i(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1i(int,int)
            cppSelf->glUniform1i(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1iv(int,int,const int*)
            cppSelf->glUniform1iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1ui(int,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glUniform1ui(int,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glUniform1ui(int,uint)
            cppSelf->glUniform1ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform1uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform1uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform1uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform1uiv(int,int,const uint*)
            cppSelf->glUniform1uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2d(int,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2d(int,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2d(int,double,double)
            cppSelf->glUniform2d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2dv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2dv(int,int,const double*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2dv(int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<double> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2dv(int,int,const double*)
            cppSelf->glUniform2dv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2f", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2f(int,float,float)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2f(int,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2f(int,float,float)
            cppSelf->glUniform2f(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2fv(int,int,const float*)
            cppSelf->glUniform2fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2i", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2i(int,int,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2i(int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2i(int,int,int)
            cppSelf->glUniform2i(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2iv(int,int,const int*)
            cppSelf->glUniform2iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2ui", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2ui(int,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniform2ui(int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2ui(int,uint,uint)
            cppSelf->glUniform2ui(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform2uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform2uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform2uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform2uiv(int,int,const uint*)
            cppSelf->glUniform2uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3d(int,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3d(int,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3d(int,double,double,double)
            cppSelf->glUniform3d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3dv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3dv(int,int,const double*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3dv(int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<double> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3dv(int,int,const double*)
            cppSelf->glUniform3dv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3f", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3f(int,float,float,float)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3f(int,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3f(int,float,float,float)
            cppSelf->glUniform3f(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3fv(int,int,const float*)
            cppSelf->glUniform3fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3i", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3i(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3i(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3i(int,int,int,int)
            cppSelf->glUniform3i(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3iv(int,int,const int*)
            cppSelf->glUniform3iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3ui(int,uint,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glUniform3ui(int,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniform3ui(int,uint,uint,uint)
            cppSelf->glUniform3ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform3uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform3uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform3uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform3uiv(int,int,const uint*)
            cppSelf->glUniform3uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4d", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4d(int,double,double,double,double)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4d(int,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4d_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4d(int,double,double,double,double)
            cppSelf->glUniform4d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4dv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4dv(int,int,const double*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4dv(int,int,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<double> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4dv(int,int,const double*)
            cppSelf->glUniform4dv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4f(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4f";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4f", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4f(int,float,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4f(int,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4f_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4f(int,float,float,float,float)
            cppSelf->glUniform4f(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4f_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4fv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4fv(int,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4fv(int,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4fv(int,int,const float*)
            cppSelf->glUniform4fv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4i(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4i";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4i", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4i(int,int,int,int,int)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4i(int,int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4i_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4i(int,int,int,int,int)
            cppSelf->glUniform4i(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4i_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4iv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4iv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4iv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4iv(int,int,const int*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4iv(int,int,const int*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4iv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4iv(int,int,const int*)
            cppSelf->glUniform4iv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4iv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4ui", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4ui(int,uint,uint,uint,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glUniform4ui(int,uint,uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4ui_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glUniform4ui(int,uint,uint,uint,uint)
            cppSelf->glUniform4ui(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniform4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniform4uiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniform4uiv(int,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniform4uiv(int,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4uiv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniform4uiv(int,int,const uint*)
            cppSelf->glUniform4uiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniform4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformBlockBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformBlockBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformBlockBinding", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformBlockBinding(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUniformBlockBinding(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformBlockBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniformBlockBinding(uint,uint,uint)
            cppSelf->glUniformBlockBinding(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformBlockBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix2dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2x3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x3dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2x3dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x3dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x3dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix2x3dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2x4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x4dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2x4dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x4dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x4dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix2x4dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix2x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix2x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix2x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix2x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix2x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix3dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3x2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x2dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3x2dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x2dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x2dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix3x2dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3x4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x4dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3x4dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x4dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x4dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix3x4dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix3x4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix3x4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix3x4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix3x4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix3x4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix4dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4x2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x2dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4x2dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x2dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x2dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix4x2dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4x2fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x2fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x2fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x2fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x2fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4x3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x3dv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4x3dv(int,int,unsigned char,const double*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x3dv(int,int,unsigned char,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3dv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<double> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x3dv(int,int,unsigned char,const double*)
            cppSelf->glUniformMatrix4x3dv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3fv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformMatrix4x3fv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformMatrix4x3fv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && PyFloat_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3fv_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<float> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glUniformMatrix4x3fv(int,int,unsigned char,const float*)
            cppSelf->glUniformMatrix4x3fv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformMatrix4x3fv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformSubroutinesuiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUniformSubroutinesuiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUniformSubroutinesuiv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUniformSubroutinesuiv(uint,int,const uint*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glUniformSubroutinesuiv(uint,int,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformSubroutinesuiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUniformSubroutinesuiv(uint,int,const uint*)
            cppSelf->glUniformSubroutinesuiv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUniformSubroutinesuiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUnmapBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUnmapBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUnmapBuffer(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glUnmapBuffer(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUnmapBuffer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glUnmapBuffer(uint)
            unsigned char cppResult = cppSelf->glUnmapBuffer(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUnmapBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUseProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUseProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glUseProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glUseProgram(uint)
            cppSelf->glUseProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgramStages(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glUseProgramStages";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glUseProgramStages", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glUseProgramStages(uint,uint,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))) {
        overloadId = 0; // glUseProgramStages(uint,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgramStages_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glUseProgramStages(uint,uint,uint)
            cppSelf->glUseProgramStages(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glUseProgramStages_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glValidateProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glValidateProgram(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glValidateProgram(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgram_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glValidateProgram(uint)
            cppSelf->glValidateProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgramPipeline(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glValidateProgramPipeline";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glValidateProgramPipeline(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // glValidateProgramPipeline(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgramPipeline_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glValidateProgramPipeline(uint)
            cppSelf->glValidateProgramPipeline(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glValidateProgramPipeline_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribBinding(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribBinding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribBinding", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribBinding(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribBinding(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribBinding_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribBinding(uint,uint)
            cppSelf->glVertexAttribBinding(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribBinding_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribDivisor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribDivisor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribDivisor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribDivisor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribDivisor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribDivisor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribDivisor(uint,uint)
            cppSelf->glVertexAttribDivisor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribDivisor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribFormat", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribFormat(uint,int,uint,unsigned char,uint)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribFormat(uint,int,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribFormat_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        unsigned int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribFormat(uint,int,uint,unsigned char,uint)
            cppSelf->glVertexAttribFormat(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribIFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribIFormat", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribIFormat(uint,int,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribIFormat(uint,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIFormat_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribIFormat(uint,int,uint,uint)
            cppSelf->glVertexAttribIFormat(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribIPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribIPointer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribIPointer(uint,int,uint,int,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribIPointer(uint,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribIPointer(uint,int,uint,int,const void*)
            cppSelf->glVertexAttribIPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribIPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL1d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL1d", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL1d(uint,double)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribL1d(uint,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribL1d(uint,double)
            cppSelf->glVertexAttribL1d(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL1dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL1dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL1dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribL1dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribL1dv(uint,const double*)
            cppSelf->glVertexAttribL1dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL1dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL2d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL2d", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL2d(uint,double,double)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))) {
        overloadId = 0; // glVertexAttribL2d(uint,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glVertexAttribL2d(uint,double,double)
            cppSelf->glVertexAttribL2d(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL2dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL2dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL2dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribL2dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribL2dv(uint,const double*)
            cppSelf->glVertexAttribL2dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL2dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL3d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL3d", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL3d(uint,double,double,double)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribL3d(uint,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribL3d(uint,double,double,double)
            cppSelf->glVertexAttribL3d(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL3dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL3dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL3dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribL3dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribL3dv(uint,const double*)
            cppSelf->glVertexAttribL3dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL3dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4d(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL4d";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL4d", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL4d(uint,double,double,double,double)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribL4d(uint,double,double,double,double)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4d_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        double cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        double cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        double cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        double cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribL4d(uint,double,double,double,double)
            cppSelf->glVertexAttribL4d(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4d_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4dv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribL4dv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribL4dv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribL4dv(uint,const double*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<double>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexAttribL4dv(uint,const double*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4dv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<double> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexAttribL4dv(uint,const double*)
            cppSelf->glVertexAttribL4dv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribL4dv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLFormat(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribLFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribLFormat", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribLFormat(uint,int,uint,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribLFormat(uint,int,uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLFormat_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribLFormat(uint,int,uint,uint)
            cppSelf->glVertexAttribLFormat(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribLPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribLPointer", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribLPointer(uint,int,uint,int,const void*)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[4])))) {
        overloadId = 0; // glVertexAttribLPointer(uint,int,uint,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        void* cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glVertexAttribLPointer(uint,int,uint,int,const void*)
            cppSelf->glVertexAttribLPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribLPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP1ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP1ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP1ui(uint,uint,unsigned char,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP1ui(uint,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP1ui(uint,uint,unsigned char,uint)
            cppSelf->glVertexAttribP1ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP1uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP1uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP1uiv(uint,uint,unsigned char,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP1uiv(uint,uint,unsigned char,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP1uiv(uint,uint,unsigned char,const uint*)
            cppSelf->glVertexAttribP1uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP1uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP2ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP2ui(uint,uint,unsigned char,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP2ui(uint,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP2ui(uint,uint,unsigned char,uint)
            cppSelf->glVertexAttribP2ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP2uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP2uiv(uint,uint,unsigned char,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP2uiv(uint,uint,unsigned char,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP2uiv(uint,uint,unsigned char,const uint*)
            cppSelf->glVertexAttribP2uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP3ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP3ui(uint,uint,unsigned char,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP3ui(uint,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP3ui(uint,uint,unsigned char,uint)
            cppSelf->glVertexAttribP3ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP3uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP3uiv(uint,uint,unsigned char,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP3uiv(uint,uint,unsigned char,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP3uiv(uint,uint,unsigned char,const uint*)
            cppSelf->glVertexAttribP3uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP4ui", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP4ui(uint,uint,unsigned char,uint)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP4ui(uint,uint,unsigned char,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP4ui(uint,uint,unsigned char,uint)
            cppSelf->glVertexAttribP4ui(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribP4uiv", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribP4uiv(uint,uint,unsigned char,const uint*)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[3])))) {
        overloadId = 0; // glVertexAttribP4uiv(uint,uint,unsigned char,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned char cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glVertexAttribP4uiv(uint,uint,unsigned char,const uint*)
            cppSelf->glVertexAttribP4uiv(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribPointer(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexAttribPointer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexAttribPointer", 6, 6, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
    if (numArgs == 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned char>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[5])))) {
        overloadId = 0; // glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribPointer_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        unsigned char cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        void* cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // glVertexAttribPointer(uint,int,uint,unsigned char,int,const void*)
            cppSelf->glVertexAttribPointer(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexAttribPointer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexBindingDivisor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexBindingDivisor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexBindingDivisor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexBindingDivisor(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexBindingDivisor(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexBindingDivisor_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexBindingDivisor(uint,uint)
            cppSelf->glVertexBindingDivisor(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexBindingDivisor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP2ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP2ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP2ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexP2ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP2ui(uint,uint)
            cppSelf->glVertexP2ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP2uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP2uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP2uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexP2uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP2uiv(uint,const uint*)
            cppSelf->glVertexP2uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP2uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP3ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP3ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP3ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexP3ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP3ui(uint,uint)
            cppSelf->glVertexP3ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP3uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP3uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP3uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexP3uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP3uiv(uint,const uint*)
            cppSelf->glVertexP3uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP3uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4ui(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP4ui";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP4ui", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP4ui(uint,uint)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[1])))) {
        overloadId = 0; // glVertexP4ui(uint,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4ui_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP4ui(uint,uint)
            cppSelf->glVertexP4ui(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4ui_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4uiv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glVertexP4uiv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glVertexP4uiv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glVertexP4uiv(uint,const uint*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<unsigned int>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glVertexP4uiv(uint,const uint*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4uiv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<unsigned int> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glVertexP4uiv(uint,const uint*)
            cppSelf->glVertexP4uiv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glVertexP4uiv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewport(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glViewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glViewport", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glViewport(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // glViewport(int,int,int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewport_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // glViewport(int,int,int,int)
            cppSelf->glViewport(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportArrayv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glViewportArrayv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glViewportArrayv", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glViewportArrayv(uint,int,const float*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && PyFloat_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[2])))) {
        overloadId = 0; // glViewportArrayv(uint,int,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportArrayv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        Shiboken::Conversions::ArrayHandle<float> cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // glViewportArrayv(uint,int,const float*)
            cppSelf->glViewportArrayv(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportArrayv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedf(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glViewportIndexedf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glViewportIndexedf", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glViewportIndexedf(uint,float,float,float,float)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArgs[4])))) {
        overloadId = 0; // glViewportIndexedf(uint,float,float,float,float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedf_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        float cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        float cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        float cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        float cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // glViewportIndexedf(uint,float,float,float,float)
            cppSelf->glViewportIndexedf(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedf_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedfv(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.glViewportIndexedfv";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "glViewportIndexedfv", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLFunctions_4_3_Core::glViewportIndexedfv(uint,const float*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && PyFloat_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::ArrayTypeConverter<float>(1), -1, -1, (pyArgs[1])))) {
        overloadId = 0; // glViewportIndexedfv(uint,const float*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedfv_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        Shiboken::Conversions::ArrayHandle<float> cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // glViewportIndexedfv(uint,const float*)
            cppSelf->glViewportIndexedfv(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLFunctions_4_3_CoreFunc_glViewportIndexedfv_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLFunctions_4_3_CoreFunc_initializeOpenGLFunctions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLFunctions_4_3_Core *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLFunctions_4_3_Core.initializeOpenGLFunctions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initializeOpenGLFunctions()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QOpenGLFunctions_4_3_Core::initializeOpenGLFunctions()
                : cppSelf->initializeOpenGLFunctions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLFunctions_4_3_Core_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLFunctions_4_3_Core_methods[] = {
    {"glActiveShaderProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveShaderProgram), METH_VARARGS},
    {"glActiveTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glActiveTexture), METH_O},
    {"glAttachShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glAttachShader), METH_VARARGS},
    {"glBeginConditionalRender", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginConditionalRender), METH_VARARGS},
    {"glBeginQuery", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQuery), METH_VARARGS},
    {"glBeginQueryIndexed", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginQueryIndexed), METH_VARARGS},
    {"glBeginTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBeginTransformFeedback), METH_O},
    {"glBindAttribLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindAttribLocation), METH_VARARGS},
    {"glBindBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBuffer), METH_VARARGS},
    {"glBindBufferBase", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindBufferBase), METH_VARARGS},
    {"glBindFragDataLocation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocation), METH_VARARGS},
    {"glBindFragDataLocationIndexed", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFragDataLocationIndexed), METH_VARARGS},
    {"glBindFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindFramebuffer), METH_VARARGS},
    {"glBindImageTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindImageTexture), METH_VARARGS},
    {"glBindProgramPipeline", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindProgramPipeline), METH_O},
    {"glBindRenderbuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindRenderbuffer), METH_VARARGS},
    {"glBindSampler", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindSampler), METH_VARARGS},
    {"glBindTexture", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTexture), METH_VARARGS},
    {"glBindTransformFeedback", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindTransformFeedback), METH_VARARGS},
    {"glBindVertexArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBindVertexArray), METH_O},
    {"glBlendColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendColor), METH_VARARGS},
    {"glBlendEquation", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquation), METH_O},
    {"glBlendEquationSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparate), METH_VARARGS},
    {"glBlendEquationSeparatei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationSeparatei), METH_VARARGS},
    {"glBlendEquationi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendEquationi), METH_VARARGS},
    {"glBlendFunc", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunc), METH_VARARGS},
    {"glBlendFuncSeparate", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparate), METH_VARARGS},
    {"glBlendFuncSeparatei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFuncSeparatei), METH_VARARGS},
    {"glBlendFunci", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlendFunci), METH_VARARGS},
    {"glBlitFramebuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glBlitFramebuffer), METH_VARARGS},
    {"glCheckFramebufferStatus", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCheckFramebufferStatus), METH_O},
    {"glClampColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClampColor), METH_VARARGS},
    {"glClear", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClear), METH_O},
    {"glClearBufferData", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferData), METH_VARARGS},
    {"glClearBufferfi", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfi), METH_VARARGS},
    {"glClearBufferfv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferfv), METH_VARARGS},
    {"glClearBufferiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferiv), METH_VARARGS},
    {"glClearBufferuiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearBufferuiv), METH_VARARGS},
    {"glClearColor", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearColor), METH_VARARGS},
    {"glClearDepth", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepth), METH_O},
    {"glClearDepthf", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearDepthf), METH_O},
    {"glClearStencil", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glClearStencil), METH_O},
    {"glColorMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMask), METH_VARARGS},
    {"glColorMaski", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorMaski), METH_VARARGS},
    {"glColorP3ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3ui), METH_VARARGS},
    {"glColorP3uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP3uiv), METH_VARARGS},
    {"glColorP4ui", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4ui), METH_VARARGS},
    {"glColorP4uiv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glColorP4uiv), METH_VARARGS},
    {"glCompileShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompileShader), METH_O},
    {"glCompressedTexImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage1D), METH_VARARGS},
    {"glCompressedTexImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage2D), METH_VARARGS},
    {"glCompressedTexImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexImage3D), METH_VARARGS},
    {"glCompressedTexSubImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage1D), METH_VARARGS},
    {"glCompressedTexSubImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage2D), METH_VARARGS},
    {"glCompressedTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCompressedTexSubImage3D), METH_VARARGS},
    {"glCopyImageSubData", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyImageSubData), METH_VARARGS},
    {"glCopyTexImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage1D), METH_VARARGS},
    {"glCopyTexImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexImage2D), METH_VARARGS},
    {"glCopyTexSubImage1D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage1D), METH_VARARGS},
    {"glCopyTexSubImage2D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage2D), METH_VARARGS},
    {"glCopyTexSubImage3D", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCopyTexSubImage3D), METH_VARARGS},
    {"glCreateProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateProgram), METH_NOARGS},
    {"glCreateShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCreateShader), METH_O},
    {"glCullFace", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glCullFace), METH_O},
    {"glDeleteBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteBuffers), METH_VARARGS},
    {"glDeleteFramebuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteFramebuffers), METH_VARARGS},
    {"glDeleteProgram", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgram), METH_O},
    {"glDeleteProgramPipelines", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteProgramPipelines), METH_VARARGS},
    {"glDeleteQueries", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteQueries), METH_VARARGS},
    {"glDeleteRenderbuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteRenderbuffers), METH_VARARGS},
    {"glDeleteSamplers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteSamplers), METH_VARARGS},
    {"glDeleteShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteShader), METH_O},
    {"glDeleteTextures", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTextures), METH_VARARGS},
    {"glDeleteTransformFeedbacks", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteTransformFeedbacks), METH_VARARGS},
    {"glDeleteVertexArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDeleteVertexArrays), METH_VARARGS},
    {"glDepthFunc", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthFunc), METH_O},
    {"glDepthMask", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthMask), METH_O},
    {"glDepthRange", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRange), METH_VARARGS},
    {"glDepthRangeArrayv", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeArrayv), METH_VARARGS},
    {"glDepthRangeIndexed", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangeIndexed), METH_VARARGS},
    {"glDepthRangef", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDepthRangef), METH_VARARGS},
    {"glDetachShader", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDetachShader), METH_VARARGS},
    {"glDisable", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisable), METH_O},
    {"glDisableVertexAttribArray", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisableVertexAttribArray), METH_O},
    {"glDisablei", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDisablei), METH_VARARGS},
    {"glDispatchCompute", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDispatchCompute), METH_VARARGS},
    {"glDrawArrays", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArrays), METH_VARARGS},
    {"glDrawArraysIndirect", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysIndirect), METH_VARARGS},
    {"glDrawArraysInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstanced), METH_VARARGS},
    {"glDrawArraysInstancedBaseInstance", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawArraysInstancedBaseInstance), METH_VARARGS},
    {"glDrawBuffer", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffer), METH_O},
    {"glDrawBuffers", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawBuffers), METH_VARARGS},
    {"glDrawElements", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElements), METH_VARARGS},
    {"glDrawElementsBaseVertex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsBaseVertex), METH_VARARGS},
    {"glDrawElementsIndirect", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsIndirect), METH_VARARGS},
    {"glDrawElementsInstanced", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstanced), METH_VARARGS},
    {"glDrawElementsInstancedBaseInstance", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseInstance), METH_VARARGS},
    {"glDrawElementsInstancedBaseVertex", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertex), METH_VARARGS},
    {"glDrawElementsInstancedBaseVertexBaseInstance", reinterpret_cast<PyCFunction>(Sbk_QOpenGLFunctions_4_3_CoreFunc_glDrawElementsInstancedBaseVertexBaseInstance), METH_VARARGS},