/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopenglfunctions_python.h"

// main header
#include "qopenglversionfunctionsfactory_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qopenglcontext.h>
#include <QtGui/qopenglversionfunctions.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLVersionFunctionsFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLVersionFunctionsFactory >()))
        return -1;

    ::QOpenGLVersionFunctionsFactory *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLVersionFunctionsFactory.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QOpenGLVersionFunctionsFactory()
            cptr = new ::QOpenGLVersionFunctionsFactory();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLVersionFunctionsFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QOpenGLVersionFunctionsFactoryFunc_get(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGLFunctions.QOpenGLVersionFunctionsFactory.get";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "get", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLVersionFunctionsFactory::get(QOpenGLVersionProfile,QOpenGLContext*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // get(QOpenGLVersionProfile,QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLVersionFunctionsFactoryFunc_get_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QOpenGLVersionProfile cppArg0_local;
        ::QOpenGLVersionProfile *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QOpenGLContext *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // get(QOpenGLVersionProfile,QOpenGLContext*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtopenglfunctions.cpp (qopenglversionfunctionsfactory-get)]
            QAbstractOpenGLFunctions *af = QOpenGLVersionFunctionsFactory::get(*cppArg0, cppArg1);
            if (auto *f = dynamic_cast<QOpenGLFunctions_4_5_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_5_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_5_Compatibility *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_5_COMPATIBILITY_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_4_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_4_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_4_Compatibility *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_4_COMPATIBILITY_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_3_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_3_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_2_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_2_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_1_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_1_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_0_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_0_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_4_0_Compatibility *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_4_0_COMPATIBILITY_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_3_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_3_Compatibility *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_3_COMPATIBILITY_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_2_Core *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_2_CORE_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_2_Compatibility *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_2_COMPATIBILITY_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_1 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_1_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_3_0 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_3_0_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_2_1 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_2_1_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_2_0 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_2_0_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_5 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_5_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_4 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_4_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_3 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_3_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_2 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_2_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_1 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_1_IDX]), f);
            } else if (auto *f = dynamic_cast<QOpenGLFunctions_1_0 *>(af)) {
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLFUNCTIONS_1_0_IDX]), f);
            } else {
                QString message;
                QDebug(&message) << "No OpenGL functions could be obtained for" << *cppArg0;
                PyErr_SetString(PyExc_RuntimeError, message.toUtf8().constData());
                pyResult = Py_None;
            }
            // END of custom code block [file: ../glue/qtopenglfunctions.cpp (qopenglversionfunctionsfactory-get)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLVersionFunctionsFactoryFunc_get_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLVersionFunctionsFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLVersionFunctionsFactory_methods[] = {
    {"get", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionFunctionsFactoryFunc_get), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOpenGLVersionFunctionsFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLVersionFunctionsFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLVersionFunctionsFactory_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLVersionFunctionsFactory_TypeF(void)
{
    return _Sbk_QOpenGLVersionFunctionsFactory_Type;
}

static PyType_Slot Sbk_QOpenGLVersionFunctionsFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLVersionFunctionsFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLVersionFunctionsFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLVersionFunctionsFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLVersionFunctionsFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLVersionFunctionsFactory_spec = {
    "2:PySide2.QtOpenGLFunctions.QOpenGLVersionFunctionsFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLVersionFunctionsFactory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLVersionFunctionsFactory_PythonToCpp_QOpenGLVersionFunctionsFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLVersionFunctionsFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLVersionFunctionsFactory_PythonToCpp_QOpenGLVersionFunctionsFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVersionFunctionsFactory_TypeF())))
        return QOpenGLVersionFunctionsFactory_PythonToCpp_QOpenGLVersionFunctionsFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLVersionFunctionsFactory_PTR_CppToPython_QOpenGLVersionFunctionsFactory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLVersionFunctionsFactory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLVersionFunctionsFactory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLVersionFunctionsFactory_SignatureStrings[] = {
    "PySide2.QtOpenGLFunctions.QOpenGLVersionFunctionsFactory(self)",
    "PySide2.QtOpenGLFunctions.QOpenGLVersionFunctionsFactory.get(versionProfile:PySide2.QtGui.QOpenGLVersionProfile,context:PySide2.QtGui.QOpenGLContext)->PySide2.QtGui.QAbstractOpenGLFunctions",
    nullptr}; // Sentinel

void init_QOpenGLVersionFunctionsFactory(PyObject *module)
{
    _Sbk_QOpenGLVersionFunctionsFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLVersionFunctionsFactory",
        "QOpenGLVersionFunctionsFactory*",
        &Sbk_QOpenGLVersionFunctionsFactory_spec,
        &Shiboken::callCppDestructor< ::QOpenGLVersionFunctionsFactory >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVersionFunctionsFactory_Type);
    InitSignatureStrings(pyType, QOpenGLVersionFunctionsFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVersionFunctionsFactory_Type), Sbk_QOpenGLVersionFunctionsFactory_PropertyStrings);
    SbkPySide2_QtOpenGLFunctionsTypes[SBK_QOPENGLVERSIONFUNCTIONSFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVersionFunctionsFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLVersionFunctionsFactory_TypeF(),
        QOpenGLVersionFunctionsFactory_PythonToCpp_QOpenGLVersionFunctionsFactory_PTR,
        is_QOpenGLVersionFunctionsFactory_PythonToCpp_QOpenGLVersionFunctionsFactory_PTR_Convertible,
        QOpenGLVersionFunctionsFactory_PTR_CppToPython_QOpenGLVersionFunctionsFactory);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionFunctionsFactory");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionFunctionsFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionFunctionsFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLVersionFunctionsFactory).name());


}
