/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeoaddress_wrapper.h"

// inner classes

// Extra includes
#include <QtPositioning/qgeoaddress.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoAddress_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoAddress >()))
        return -1;

    ::QGeoAddress *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoAddress", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoAddress::QGeoAddress()
    // 1: QGeoAddress::QGeoAddress(QGeoAddress)
    if (numArgs == 0) {
        overloadId = 0; // QGeoAddress()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoAddress(QGeoAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddress_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoAddress()
        {

            if (!PyErr_Occurred()) {
                // QGeoAddress()
                cptr = new ::QGeoAddress();
            }
            break;
        }
        case 1: // QGeoAddress(const QGeoAddress & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoAddress cppArg0_local;
            ::QGeoAddress *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoAddress(QGeoAddress)
                cptr = new ::QGeoAddress(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoAddress >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoAddress_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoAddress_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoAddressFunc_city(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.city";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // city()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->city();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoAddressFunc_country(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.country";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // country()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->country();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_countryCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.countryCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // countryCode()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->countryCode();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_county(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.county";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // county()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->county();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_district(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.district";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // district()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->district();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_isTextGenerated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.isTextGenerated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTextGenerated()const
            bool cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->isTextGenerated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_postalCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.postalCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // postalCode()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->postalCode();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_setCity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setCity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setCity(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCity(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setCity_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCity(QString)
            cppSelf->setCity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setCity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setCountry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setCountry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setCountry(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCountry(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setCountry_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCountry(QString)
            cppSelf->setCountry(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setCountry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setCountryCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setCountryCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setCountryCode(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCountryCode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setCountryCode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCountryCode(QString)
            cppSelf->setCountryCode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setCountryCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setCounty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setCounty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setCounty(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCounty(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setCounty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCounty(QString)
            cppSelf->setCounty(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setCounty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setDistrict(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setDistrict";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setDistrict(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDistrict(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setDistrict_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDistrict(QString)
            cppSelf->setDistrict(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setDistrict_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setPostalCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setPostalCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setPostalCode(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPostalCode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setPostalCode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPostalCode(QString)
            cppSelf->setPostalCode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setPostalCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setState(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setState(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setState_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setState(QString)
            cppSelf->setState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setStreet(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setStreet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setStreet(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setStreet(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setStreet_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStreet(QString)
            cppSelf->setStreet(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setStreet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoAddress::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoAddressFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoAddressFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoAddressFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_street(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.street";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // street()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->street();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddressFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoAddress.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QGeoAddress *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoAddress___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoAddress_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoAddress_methods[] = {
    {"city", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_city), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_clear), METH_NOARGS},
    {"country", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_country), METH_NOARGS},
    {"countryCode", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_countryCode), METH_NOARGS},
    {"county", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_county), METH_NOARGS},
    {"district", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_district), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_isEmpty), METH_NOARGS},
    {"isTextGenerated", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_isTextGenerated), METH_NOARGS},
    {"postalCode", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_postalCode), METH_NOARGS},
    {"setCity", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setCity), METH_O},
    {"setCountry", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setCountry), METH_O},
    {"setCountryCode", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setCountryCode), METH_O},
    {"setCounty", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setCounty), METH_O},
    {"setDistrict", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setDistrict), METH_O},
    {"setPostalCode", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setPostalCode), METH_O},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setState), METH_O},
    {"setStreet", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setStreet), METH_O},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_setText), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_state), METH_NOARGS},
    {"street", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_street), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QGeoAddressFunc_text), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoAddress___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGeoAddress_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), (pyArg)))) {
                // operator!=(const QGeoAddress & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoAddress cppArg0_local;
                ::QGeoAddress *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), (pyArg)))) {
                // operator==(const QGeoAddress & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoAddress cppArg0_local;
                ::QGeoAddress *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoAddress_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoAddress_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoAddress_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoAddress_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoAddress_Type = nullptr;
static SbkObjectType *Sbk_QGeoAddress_TypeF(void)
{
    return _Sbk_QGeoAddress_Type;
}

static PyType_Slot Sbk_QGeoAddress_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoAddress_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoAddress_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoAddress_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoAddress_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoAddress_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoAddress_spec = {
    "2:PySide2.QtPositioning.QGeoAddress",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoAddress_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoAddress_PythonToCpp_QGeoAddress_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoAddress_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoAddress_PythonToCpp_QGeoAddress_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoAddress_TypeF())))
        return QGeoAddress_PythonToCpp_QGeoAddress_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoAddress_PTR_CppToPython_QGeoAddress(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoAddress *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoAddress_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoAddress_COPY_CppToPython_QGeoAddress(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoAddress_TypeF(), new ::QGeoAddress(*reinterpret_cast<const ::QGeoAddress *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoAddress_PythonToCpp_QGeoAddress_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoAddress *>(cppOut) = *reinterpret_cast< ::QGeoAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoAddress_PythonToCpp_QGeoAddress_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoAddress_TypeF())))
        return QGeoAddress_PythonToCpp_QGeoAddress_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoAddress_SignatureStrings[] = {
    "1:PySide2.QtPositioning.QGeoAddress(self)",
    "0:PySide2.QtPositioning.QGeoAddress(self,other:PySide2.QtPositioning.QGeoAddress)",
    "PySide2.QtPositioning.QGeoAddress.city(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.clear(self)",
    "PySide2.QtPositioning.QGeoAddress.country(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.countryCode(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.county(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.district(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.isEmpty(self)->bool",
    "PySide2.QtPositioning.QGeoAddress.isTextGenerated(self)->bool",
    "PySide2.QtPositioning.QGeoAddress.postalCode(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.setCity(self,city:QString)",
    "PySide2.QtPositioning.QGeoAddress.setCountry(self,country:QString)",
    "PySide2.QtPositioning.QGeoAddress.setCountryCode(self,countryCode:QString)",
    "PySide2.QtPositioning.QGeoAddress.setCounty(self,county:QString)",
    "PySide2.QtPositioning.QGeoAddress.setDistrict(self,district:QString)",
    "PySide2.QtPositioning.QGeoAddress.setPostalCode(self,postalCode:QString)",
    "PySide2.QtPositioning.QGeoAddress.setState(self,state:QString)",
    "PySide2.QtPositioning.QGeoAddress.setStreet(self,street:QString)",
    "PySide2.QtPositioning.QGeoAddress.setText(self,text:QString)",
    "PySide2.QtPositioning.QGeoAddress.state(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.street(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.text(self)->QString",
    "PySide2.QtPositioning.QGeoAddress.__copy__()",
    nullptr}; // Sentinel

void init_QGeoAddress(PyObject *module)
{
    _Sbk_QGeoAddress_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoAddress",
        "QGeoAddress",
        &Sbk_QGeoAddress_spec,
        &Shiboken::callCppDestructor< ::QGeoAddress >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAddress_Type);
    InitSignatureStrings(pyType, QGeoAddress_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoAddress_Type), Sbk_QGeoAddress_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOADDRESS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoAddress_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoAddress_TypeF(),
        QGeoAddress_PythonToCpp_QGeoAddress_PTR,
        is_QGeoAddress_PythonToCpp_QGeoAddress_PTR_Convertible,
        QGeoAddress_PTR_CppToPython_QGeoAddress,
        QGeoAddress_COPY_CppToPython_QGeoAddress);

    Shiboken::Conversions::registerConverterName(converter, "QGeoAddress");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAddress*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoAddress&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoAddress).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoAddress_PythonToCpp_QGeoAddress_COPY,
        is_QGeoAddress_PythonToCpp_QGeoAddress_COPY_Convertible);

    qRegisterMetaType< ::QGeoAddress >("QGeoAddress");
}
