/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeosatelliteinfo_wrapper.h"

// inner classes

// Extra includes
#include <QtPositioning/qgeosatelliteinfo.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoSatelliteInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoSatelliteInfo >()))
        return -1;

    ::QGeoSatelliteInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoSatelliteInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::QGeoSatelliteInfo()
    // 1: QGeoSatelliteInfo::QGeoSatelliteInfo(QGeoSatelliteInfo)
    if (numArgs == 0) {
        overloadId = 0; // QGeoSatelliteInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGeoSatelliteInfo(QGeoSatelliteInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoSatelliteInfo()
        {

            if (!PyErr_Occurred()) {
                // QGeoSatelliteInfo()
                cptr = new ::QGeoSatelliteInfo();
            }
            break;
        }
        case 1: // QGeoSatelliteInfo(const QGeoSatelliteInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoSatelliteInfo cppArg0_local;
            ::QGeoSatelliteInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoSatelliteInfo(QGeoSatelliteInfo)
                cptr = new ::QGeoSatelliteInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoSatelliteInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoSatelliteInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoSatelliteInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_attribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.attribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::attribute(QGeoSatelliteInfo::Attribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // attribute(QGeoSatelliteInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_attribute_TypeError;

    // Call function/method
    {
        ::QGeoSatelliteInfo::Attribute cppArg0{QGeoSatelliteInfo::Elevation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // attribute(QGeoSatelliteInfo::Attribute)const
            qreal cppResult = const_cast<const ::QGeoSatelliteInfo *>(cppSelf)->attribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoFunc_attribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_hasAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.hasAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::hasAttribute(QGeoSatelliteInfo::Attribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hasAttribute(QGeoSatelliteInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_hasAttribute_TypeError;

    // Call function/method
    {
        ::QGeoSatelliteInfo::Attribute cppArg0{QGeoSatelliteInfo::Elevation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasAttribute(QGeoSatelliteInfo::Attribute)const
            bool cppResult = const_cast<const ::QGeoSatelliteInfo *>(cppSelf)->hasAttribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoFunc_hasAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_removeAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.removeAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::removeAttribute(QGeoSatelliteInfo::Attribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // removeAttribute(QGeoSatelliteInfo::Attribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_removeAttribute_TypeError;

    // Call function/method
    {
        ::QGeoSatelliteInfo::Attribute cppArg0{QGeoSatelliteInfo::Elevation};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeAttribute(QGeoSatelliteInfo::Attribute)
            cppSelf->removeAttribute(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoFunc_removeAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_satelliteIdentifier(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.satelliteIdentifier";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // satelliteIdentifier()const
            int cppResult = const_cast<const ::QGeoSatelliteInfo *>(cppSelf)->satelliteIdentifier();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_satelliteSystem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.satelliteSystem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // satelliteSystem()const
            QGeoSatelliteInfo::SatelliteSystem cppResult = const_cast<const ::QGeoSatelliteInfo *>(cppSelf)->satelliteSystem();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_setAttribute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.setAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::setAttribute(QGeoSatelliteInfo::Attribute,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // setAttribute(QGeoSatelliteInfo::Attribute,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_setAttribute_TypeError;

    // Call function/method
    {
        ::QGeoSatelliteInfo::Attribute cppArg0{QGeoSatelliteInfo::Elevation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAttribute(QGeoSatelliteInfo::Attribute,qreal)
            cppSelf->setAttribute(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoFunc_setAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_setSatelliteIdentifier(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.setSatelliteIdentifier";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::setSatelliteIdentifier(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSatelliteIdentifier(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_setSatelliteIdentifier_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSatelliteIdentifier(int)
            cppSelf->setSatelliteIdentifier(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoFunc_setSatelliteIdentifier_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_setSatelliteSystem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.setSatelliteSystem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_setSatelliteSystem_TypeError;

    // Call function/method
    {
        ::QGeoSatelliteInfo::SatelliteSystem cppArg0{QGeoSatelliteInfo::Undefined};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSatelliteSystem(QGeoSatelliteInfo::SatelliteSystem)
            cppSelf->setSatelliteSystem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoFunc_setSatelliteSystem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_setSignalStrength(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.setSignalStrength";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfo::setSignalStrength(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSignalStrength(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc_setSignalStrength_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSignalStrength(int)
            cppSelf->setSignalStrength(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoFunc_setSignalStrength_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc_signalStrength(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.signalStrength";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // signalStrength()const
            int cppResult = const_cast<const ::QGeoSatelliteInfo *>(cppSelf)->signalStrength();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoSatelliteInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoSatelliteInfo_methods[] = {
    {"attribute", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_attribute), METH_O},
    {"hasAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_hasAttribute), METH_O},
    {"removeAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_removeAttribute), METH_O},
    {"satelliteIdentifier", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_satelliteIdentifier), METH_NOARGS},
    {"satelliteSystem", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_satelliteSystem), METH_NOARGS},
    {"setAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_setAttribute), METH_VARARGS},
    {"setSatelliteIdentifier", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_setSatelliteIdentifier), METH_O},
    {"setSatelliteSystem", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_setSatelliteSystem), METH_O},
    {"setSignalStrength", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_setSignalStrength), METH_O},
    {"signalStrength", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoFunc_signalStrength), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QGeoSatelliteInfoFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoSatelliteInfo::operator<<(QDataStream&,QGeoSatelliteInfo)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QGeoSatelliteInfo)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QGeoSatelliteInfo) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfo.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoSatelliteInfo::operator>>(QDataStream&,QGeoSatelliteInfo&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QGeoSatelliteInfo&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoSatelliteInfoFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QGeoSatelliteInfo&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QGeoSatelliteInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), (pyArg)))) {
                // operator!=(const QGeoSatelliteInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoSatelliteInfo cppArg0_local;
                ::QGeoSatelliteInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), (pyArg)))) {
                // operator==(const QGeoSatelliteInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoSatelliteInfo cppArg0_local;
                ::QGeoSatelliteInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoSatelliteInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoSatelliteInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoSatelliteInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoSatelliteInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGeoSatelliteInfo__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoSatelliteInfo_Type = nullptr;
static SbkObjectType *Sbk_QGeoSatelliteInfo_TypeF(void)
{
    return _Sbk_QGeoSatelliteInfo_Type;
}

static PyType_Slot Sbk_QGeoSatelliteInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoSatelliteInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QGeoSatelliteInfoFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QGeoSatelliteInfoFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoSatelliteInfo_spec = {
    "2:PySide2.QtPositioning.QGeoSatelliteInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoSatelliteInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoSatelliteInfo_Attribute_PythonToCpp_QGeoSatelliteInfo_Attribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoSatelliteInfo::Attribute *>(cppOut) =
        static_cast<::QGeoSatelliteInfo::Attribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoSatelliteInfo_Attribute_PythonToCpp_QGeoSatelliteInfo_Attribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX]))
        return QGeoSatelliteInfo_Attribute_PythonToCpp_QGeoSatelliteInfo_Attribute;
    return {};
}
static PyObject *QGeoSatelliteInfo_Attribute_CppToPython_QGeoSatelliteInfo_Attribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoSatelliteInfo::Attribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX], castCppIn);

}

static void QGeoSatelliteInfo_SatelliteSystem_PythonToCpp_QGeoSatelliteInfo_SatelliteSystem(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoSatelliteInfo::SatelliteSystem *>(cppOut) =
        static_cast<::QGeoSatelliteInfo::SatelliteSystem>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoSatelliteInfo_SatelliteSystem_PythonToCpp_QGeoSatelliteInfo_SatelliteSystem_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX]))
        return QGeoSatelliteInfo_SatelliteSystem_PythonToCpp_QGeoSatelliteInfo_SatelliteSystem;
    return {};
}
static PyObject *QGeoSatelliteInfo_SatelliteSystem_CppToPython_QGeoSatelliteInfo_SatelliteSystem(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoSatelliteInfo::SatelliteSystem *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoSatelliteInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoSatelliteInfo_TypeF())))
        return QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoSatelliteInfo_PTR_CppToPython_QGeoSatelliteInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoSatelliteInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoSatelliteInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoSatelliteInfo_COPY_CppToPython_QGeoSatelliteInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoSatelliteInfo_TypeF(), new ::QGeoSatelliteInfo(*reinterpret_cast<const ::QGeoSatelliteInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoSatelliteInfo *>(cppOut) = *reinterpret_cast< ::QGeoSatelliteInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoSatelliteInfo_TypeF())))
        return QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoSatelliteInfo_SignatureStrings[] = {
    "1:PySide2.QtPositioning.QGeoSatelliteInfo(self)",
    "0:PySide2.QtPositioning.QGeoSatelliteInfo(self,other:PySide2.QtPositioning.QGeoSatelliteInfo)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.attribute(self,attribute:PySide2.QtPositioning.QGeoSatelliteInfo.Attribute)->qreal",
    "PySide2.QtPositioning.QGeoSatelliteInfo.hasAttribute(self,attribute:PySide2.QtPositioning.QGeoSatelliteInfo.Attribute)->bool",
    "PySide2.QtPositioning.QGeoSatelliteInfo.removeAttribute(self,attribute:PySide2.QtPositioning.QGeoSatelliteInfo.Attribute)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.satelliteIdentifier(self)->int",
    "PySide2.QtPositioning.QGeoSatelliteInfo.satelliteSystem(self)->PySide2.QtPositioning.QGeoSatelliteInfo.SatelliteSystem",
    "PySide2.QtPositioning.QGeoSatelliteInfo.setAttribute(self,attribute:PySide2.QtPositioning.QGeoSatelliteInfo.Attribute,value:qreal)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.setSatelliteIdentifier(self,satId:int)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.setSatelliteSystem(self,system:PySide2.QtPositioning.QGeoSatelliteInfo.SatelliteSystem)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.setSignalStrength(self,signalStrength:int)",
    "PySide2.QtPositioning.QGeoSatelliteInfo.signalStrength(self)->int",
    "PySide2.QtPositioning.QGeoSatelliteInfo.__copy__()",
    "PySide2.QtPositioning.QGeoSatelliteInfo.__lshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtPositioning.QGeoSatelliteInfo.__rshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QGeoSatelliteInfo(PyObject *module)
{
    _Sbk_QGeoSatelliteInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoSatelliteInfo",
        "QGeoSatelliteInfo",
        &Sbk_QGeoSatelliteInfo_spec,
        &Shiboken::callCppDestructor< ::QGeoSatelliteInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoSatelliteInfo_Type);
    InitSignatureStrings(pyType, QGeoSatelliteInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoSatelliteInfo_Type), Sbk_QGeoSatelliteInfo_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoSatelliteInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoSatelliteInfo_TypeF(),
        QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_PTR,
        is_QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_PTR_Convertible,
        QGeoSatelliteInfo_PTR_CppToPython_QGeoSatelliteInfo,
        QGeoSatelliteInfo_COPY_CppToPython_QGeoSatelliteInfo);

    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfo");
    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoSatelliteInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_COPY,
        is_QGeoSatelliteInfo_PythonToCpp_QGeoSatelliteInfo_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Attribute'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoSatelliteInfo_TypeF(),
        "Attribute",
        "2:PySide2.QtPositioning.QGeoSatelliteInfo.Attribute",
        "QGeoSatelliteInfo::Attribute");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX],
        Sbk_QGeoSatelliteInfo_TypeF(), "Elevation", (long) QGeoSatelliteInfo::Attribute::Elevation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX],
        Sbk_QGeoSatelliteInfo_TypeF(), "Azimuth", (long) QGeoSatelliteInfo::Attribute::Azimuth))
        return;
    // Register converter for enum 'QGeoSatelliteInfo::Attribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX],
            QGeoSatelliteInfo_Attribute_CppToPython_QGeoSatelliteInfo_Attribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoSatelliteInfo_Attribute_PythonToCpp_QGeoSatelliteInfo_Attribute,
            is_QGeoSatelliteInfo_Attribute_PythonToCpp_QGeoSatelliteInfo_Attribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_ATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfo::Attribute");
        Shiboken::Conversions::registerConverterName(converter, "Attribute");
    }
    // End of 'Attribute' enum.

    // Initialization of enum 'SatelliteSystem'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoSatelliteInfo_TypeF(),
        "SatelliteSystem",
        "2:PySide2.QtPositioning.QGeoSatelliteInfo.SatelliteSystem",
        "QGeoSatelliteInfo::SatelliteSystem");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX],
        Sbk_QGeoSatelliteInfo_TypeF(), "Undefined", (long) QGeoSatelliteInfo::SatelliteSystem::Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX],
        Sbk_QGeoSatelliteInfo_TypeF(), "GPS", (long) QGeoSatelliteInfo::SatelliteSystem::GPS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX],
        Sbk_QGeoSatelliteInfo_TypeF(), "GLONASS", (long) QGeoSatelliteInfo::SatelliteSystem::GLONASS))
        return;
    // Register converter for enum 'QGeoSatelliteInfo::SatelliteSystem'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX],
            QGeoSatelliteInfo_SatelliteSystem_CppToPython_QGeoSatelliteInfo_SatelliteSystem);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoSatelliteInfo_SatelliteSystem_PythonToCpp_QGeoSatelliteInfo_SatelliteSystem,
            is_QGeoSatelliteInfo_SatelliteSystem_PythonToCpp_QGeoSatelliteInfo_SatelliteSystem_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFO_SATELLITESYSTEM_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfo::SatelliteSystem");
        Shiboken::Conversions::registerConverterName(converter, "SatelliteSystem");
    }
    // End of 'SatelliteSystem' enum.

    qRegisterMetaType< ::QGeoSatelliteInfo >("QGeoSatelliteInfo");
    qRegisterMetaType< ::QGeoSatelliteInfo::Attribute >("QGeoSatelliteInfo::Attribute");
    qRegisterMetaType< ::QGeoSatelliteInfo::SatelliteSystem >("QGeoSatelliteInfo::SatelliteSystem");
}
