/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeosatelliteinfosource_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoSatelliteInfoSourceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoSatelliteInfoSourceWrapper::QGeoSatelliteInfoSourceWrapper(::QObject * parent) : QGeoSatelliteInfoSource(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGeoSatelliteInfoSourceWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoSatelliteInfoSourceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoSatelliteInfoSourceWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoSatelliteInfoSourceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QGeoSatelliteInfoSource::Error QGeoSatelliteInfoSourceWrapper::error() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.error()' not implemented.");
        return QGeoSatelliteInfoSource::AccessError;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QGeoSatelliteInfoSource::AccessError;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "error";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.error()' not implemented.");
        return QGeoSatelliteInfoSource::AccessError;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QGeoSatelliteInfoSource::AccessError;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.error", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoSatelliteInfoSource::Error >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QGeoSatelliteInfoSource::AccessError;
    }
    ::QGeoSatelliteInfoSource::Error cppResult{QGeoSatelliteInfoSource::AccessError};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QGeoSatelliteInfoSourceWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoSatelliteInfoSourceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

int QGeoSatelliteInfoSourceWrapper::minimumUpdateInterval() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.minimumUpdateInterval()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "1:minimumUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.minimumUpdateInterval()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoSatelliteInfoSource.minimumUpdateInterval", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoSatelliteInfoSourceWrapper::requestUpdate(int timeout)
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.requestUpdate()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "requestUpdate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.requestUpdate()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    timeout
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoSatelliteInfoSourceWrapper::setUpdateInterval(int msec)
{
    if (m_PyMethodCache[10]) {
        return this->::QGeoSatelliteInfoSource::setUpdateInterval(msec);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setUpdateInterval";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QGeoSatelliteInfoSource::setUpdateInterval(msec);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    msec
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoSatelliteInfoSourceWrapper::startUpdates()
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.startUpdates()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "startUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.startUpdates()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoSatelliteInfoSourceWrapper::stopUpdates()
{
    if (m_PyMethodCache[12]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.stopUpdates()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stopUpdates";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.stopUpdates()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoSatelliteInfoSourceWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoSatelliteInfoSourceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoSatelliteInfoSource::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoSatelliteInfoSourceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoSatelliteInfoSource::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoSatelliteInfoSourceWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoSatelliteInfoSourceWrapper *>(this));
        return QGeoSatelliteInfoSource::qt_metacast(_clname);
}

QGeoSatelliteInfoSourceWrapper::~QGeoSatelliteInfoSourceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoSatelliteInfoSource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGeoSatelliteInfoSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoSatelliteInfoSource >()))
        return -1;

    ::QGeoSatelliteInfoSourceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoSatelliteInfoSource", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoSatelliteInfoSource::QGeoSatelliteInfoSource(QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGeoSatelliteInfoSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoSource_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGeoSatelliteInfoSource(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGeoSatelliteInfoSourceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGeoSatelliteInfoSourceWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoSatelliteInfoSource >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoSatelliteInfoSource_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoSatelliteInfoSource_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoSatelliteInfoSource_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_availableSources(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.availableSources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableSources()
            QStringList cppResult = ::QGeoSatelliteInfoSource::availableSources();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_createDefaultSource(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.createDefaultSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createDefaultSource", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QGeoSatelliteInfoSource::createDefaultSource(QObject*)
    // 1: static QGeoSatelliteInfoSource::createDefaultSource(QMap<QString,QVariant>,QObject*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
        overloadId = 1; // createDefaultSource(QMap<QString,QVariant>,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // createDefaultSource(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoSourceFunc_createDefaultSource_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createDefaultSource(QObject * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // createDefaultSource(QObject*)
                QGeoSatelliteInfoSource * cppResult = ::QGeoSatelliteInfoSource::createDefaultSource(cppArg0);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
        case 1: // createDefaultSource(const QMap<QString,QVariant > & parameters, QObject * parent)
        {
            ::QMap<QString,QVariant > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createDefaultSource(QMap<QString,QVariant>,QObject*)
                QGeoSatelliteInfoSource * cppResult = ::QGeoSatelliteInfoSource::createDefaultSource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoSourceFunc_createDefaultSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_createSource(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.createSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createSource", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QGeoSatelliteInfoSource::createSource(QString,QObject*)
    // 1: static QGeoSatelliteInfoSource::createSource(QString,QMap<QString,QVariant>,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPositioningTypeConverters[SBK_QTPOSITIONING_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 1; // createSource(QString,QMap<QString,QVariant>,QObject*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // createSource(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoSourceFunc_createSource_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createSource(const QString & sourceName, QObject * parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // createSource(QString,QObject*)
                QGeoSatelliteInfoSource * cppResult = ::QGeoSatelliteInfoSource::createSource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
        case 1: // createSource(const QString & sourceName, const QMap<QString,QVariant > & parameters, QObject * parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QMap<QString,QVariant > cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // createSource(QString,QMap<QString,QVariant>,QObject*)
                QGeoSatelliteInfoSource * cppResult = ::QGeoSatelliteInfoSource::createSource(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoSatelliteInfoSourceFunc_createSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.error()' not implemented.");
                return {};
            }
            QGeoSatelliteInfoSource::Error cppResult = const_cast<const ::QGeoSatelliteInfoSource *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_minimumUpdateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.minimumUpdateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumUpdateInterval()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.minimumUpdateInterval()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QGeoSatelliteInfoSource *>(cppSelf)->minimumUpdateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.requestUpdate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:requestUpdate", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGeoSatelliteInfoSource::requestUpdate(int)
    if (numArgs == 0) {
        overloadId = 0; // requestUpdate(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // requestUpdate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError;
            }
        }
        int cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // requestUpdate(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.requestUpdate()' not implemented.");
                return {};
            }
            cppSelf->requestUpdate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_setUpdateInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.setUpdateInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoSatelliteInfoSource::setUpdateInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setUpdateInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoSatelliteInfoSourceFunc_setUpdateInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUpdateInterval(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoSatelliteInfoSource::setUpdateInterval(cppArg0)
                : cppSelf->setUpdateInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoSatelliteInfoSourceFunc_setUpdateInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_sourceName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.sourceName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceName()const
            QString cppResult = const_cast<const ::QGeoSatelliteInfoSource *>(cppSelf)->sourceName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_startUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.startUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startUpdates()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.startUpdates()' not implemented.");
                return {};
            }
            cppSelf->startUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_stopUpdates(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.stopUpdates";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stopUpdates()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoSatelliteInfoSource.stopUpdates()' not implemented.");
                return {};
            }
            cppSelf->stopUpdates();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoSatelliteInfoSourceFunc_updateInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoSatelliteInfoSource.updateInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateInterval()const
            int cppResult = const_cast<const ::QGeoSatelliteInfoSource *>(cppSelf)->updateInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoSatelliteInfoSource_PropertyStrings[] = {
    "minimumUpdateInterval:",
    "updateInterval::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoSatelliteInfoSource_methods[] = {
    {"availableSources", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_availableSources), METH_NOARGS|METH_STATIC},
    {"createDefaultSource", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_createDefaultSource), METH_VARARGS|METH_STATIC},
    {"createSource", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_createSource), METH_VARARGS|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_error), METH_NOARGS},
    {"minimumUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_minimumUpdateInterval), METH_NOARGS},
    {"requestUpdate", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_requestUpdate), METH_VARARGS|METH_KEYWORDS},
    {"setUpdateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_setUpdateInterval), METH_O},
    {"sourceName", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_sourceName), METH_NOARGS},
    {"startUpdates", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_startUpdates), METH_NOARGS},
    {"stopUpdates", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_stopUpdates), METH_NOARGS},
    {"updateInterval", reinterpret_cast<PyCFunction>(Sbk_QGeoSatelliteInfoSourceFunc_updateInterval), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoSatelliteInfoSource_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoSatelliteInfoSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoSatelliteInfoSourceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoSatelliteInfoSource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoSatelliteInfoSource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoSatelliteInfoSource_Type = nullptr;
static SbkObjectType *Sbk_QGeoSatelliteInfoSource_TypeF(void)
{
    return _Sbk_QGeoSatelliteInfoSource_Type;
}

static PyType_Slot Sbk_QGeoSatelliteInfoSource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoSatelliteInfoSource_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoSatelliteInfoSource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoSatelliteInfoSource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoSatelliteInfoSource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoSatelliteInfoSource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoSatelliteInfoSource_spec = {
    "2:PySide2.QtPositioning.QGeoSatelliteInfoSource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoSatelliteInfoSource_slots
};

} //extern "C"

static void *Sbk_QGeoSatelliteInfoSource_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoSatelliteInfoSource *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoSatelliteInfoSource_Error_PythonToCpp_QGeoSatelliteInfoSource_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoSatelliteInfoSource::Error *>(cppOut) =
        static_cast<::QGeoSatelliteInfoSource::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoSatelliteInfoSource_Error_PythonToCpp_QGeoSatelliteInfoSource_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX]))
        return QGeoSatelliteInfoSource_Error_PythonToCpp_QGeoSatelliteInfoSource_Error;
    return {};
}
static PyObject *QGeoSatelliteInfoSource_Error_CppToPython_QGeoSatelliteInfoSource_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoSatelliteInfoSource::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoSatelliteInfoSource_PythonToCpp_QGeoSatelliteInfoSource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoSatelliteInfoSource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoSatelliteInfoSource_PythonToCpp_QGeoSatelliteInfoSource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoSatelliteInfoSource_TypeF())))
        return QGeoSatelliteInfoSource_PythonToCpp_QGeoSatelliteInfoSource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoSatelliteInfoSource_PTR_CppToPython_QGeoSatelliteInfoSource(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoSatelliteInfoSource *>(const_cast<void *>(cppIn)), Sbk_QGeoSatelliteInfoSource_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoSatelliteInfoSource_SignatureStrings[] = {
    "PySide2.QtPositioning.QGeoSatelliteInfoSource(self,parent:PySide2.QtCore.QObject)",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.availableSources()->QStringList",
    "1:PySide2.QtPositioning.QGeoSatelliteInfoSource.createDefaultSource(parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoSatelliteInfoSource",
    "0:PySide2.QtPositioning.QGeoSatelliteInfoSource.createDefaultSource(parameters:QMap[QString, QVariant],parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoSatelliteInfoSource",
    "1:PySide2.QtPositioning.QGeoSatelliteInfoSource.createSource(sourceName:QString,parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoSatelliteInfoSource",
    "0:PySide2.QtPositioning.QGeoSatelliteInfoSource.createSource(sourceName:QString,parameters:QMap[QString, QVariant],parent:PySide2.QtCore.QObject)->PySide2.QtPositioning.QGeoSatelliteInfoSource",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.error(self)->PySide2.QtPositioning.QGeoSatelliteInfoSource.Error",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.minimumUpdateInterval(self)->int",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.requestUpdate(self,timeout:int=0)",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.setUpdateInterval(self,msec:int)",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.sourceName(self)->QString",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.startUpdates(self)",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.stopUpdates(self)",
    "PySide2.QtPositioning.QGeoSatelliteInfoSource.updateInterval(self)->int",
    nullptr}; // Sentinel

void init_QGeoSatelliteInfoSource(PyObject *module)
{
    _Sbk_QGeoSatelliteInfoSource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoSatelliteInfoSource",
        "QGeoSatelliteInfoSource*",
        &Sbk_QGeoSatelliteInfoSource_spec,
        &Shiboken::callCppDestructor< ::QGeoSatelliteInfoSource >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoSatelliteInfoSource_Type);
    InitSignatureStrings(pyType, QGeoSatelliteInfoSource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoSatelliteInfoSource_Type), Sbk_QGeoSatelliteInfoSource_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoSatelliteInfoSource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoSatelliteInfoSource_TypeF(),
        QGeoSatelliteInfoSource_PythonToCpp_QGeoSatelliteInfoSource_PTR,
        is_QGeoSatelliteInfoSource_PythonToCpp_QGeoSatelliteInfoSource_PTR_Convertible,
        QGeoSatelliteInfoSource_PTR_CppToPython_QGeoSatelliteInfoSource);

    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfoSource");
    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfoSource*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfoSource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoSatelliteInfoSource).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoSatelliteInfoSourceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoSatelliteInfoSource_TypeF(), &Sbk_QGeoSatelliteInfoSource_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoSatelliteInfoSource_TypeF(),
        "Error",
        "2:PySide2.QtPositioning.QGeoSatelliteInfoSource.Error",
        "QGeoSatelliteInfoSource::Error");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX],
        Sbk_QGeoSatelliteInfoSource_TypeF(), "AccessError", (long) QGeoSatelliteInfoSource::Error::AccessError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX],
        Sbk_QGeoSatelliteInfoSource_TypeF(), "ClosedError", (long) QGeoSatelliteInfoSource::Error::ClosedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX],
        Sbk_QGeoSatelliteInfoSource_TypeF(), "NoError", (long) QGeoSatelliteInfoSource::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX],
        Sbk_QGeoSatelliteInfoSource_TypeF(), "UnknownSourceError", (long) QGeoSatelliteInfoSource::Error::UnknownSourceError))
        return;
    // Register converter for enum 'QGeoSatelliteInfoSource::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX],
            QGeoSatelliteInfoSource_Error_CppToPython_QGeoSatelliteInfoSource_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoSatelliteInfoSource_Error_PythonToCpp_QGeoSatelliteInfoSource_Error,
            is_QGeoSatelliteInfoSource_Error_PythonToCpp_QGeoSatelliteInfoSource_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOSATELLITEINFOSOURCE_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoSatelliteInfoSource::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QGeoSatelliteInfoSource_TypeF(), &::QGeoSatelliteInfoSource::staticMetaObject);
    qRegisterMetaType< ::QGeoSatelliteInfoSource::Error >("QGeoSatelliteInfoSource::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoSatelliteInfoSource_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoSatelliteInfoSource_TypeF(), &::QGeoSatelliteInfoSource::staticMetaObject, sizeof(QGeoSatelliteInfoSourceWrapper));
}
