/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtprintsupport_python.h"

// main header
#include "qabstractprintdialog_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QAbstractPrintDialogWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QAbstractPrintDialogWrapper::QAbstractPrintDialogWrapper(::QPrinter * printer, ::QWidget * parent) : QAbstractPrintDialog(printer, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QAbstractPrintDialogWrapper::accept()
{
    if (m_PyMethodCache[0]) {
        return this->::QDialog::accept();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accept";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QDialog::accept();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::actionEvent(::QActionEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QWidget::actionEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "actionEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QWidget::actionEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACTIONEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::changeEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QWidget::changeEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "changeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QWidget::changeEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    if (m_PyMethodCache[4]) {
        return this->::QDialog::closeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QDialog::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    if (m_PyMethodCache[6]) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractPrintDialogWrapper::devType() const
{
    if (m_PyMethodCache[8])
        return this->::QWidget::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QWidget::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::done(int arg__1)
{
    if (m_PyMethodCache[10]) {
        return this->::QDialog::done(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "done";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QDialog::done(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QWidget::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWidget::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWidget::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QWidget::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QWidget::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::dropEvent(::QDropEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QWidget::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::enterEvent(::QEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QWidget::enterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "enterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QWidget::enterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractPrintDialogWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[16])
        return this->::QWidget::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QWidget::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QAbstractPrintDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[17])
        return this->::QDialog::eventFilter(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

int QAbstractPrintDialogWrapper::exec()
{
    if (m_PyMethodCache[18])
        return this->::QDialog::exec();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exec_";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QDialog::exec();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.exec_", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QWidget::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QWidget::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractPrintDialogWrapper::focusNextPrevChild(bool next)
{
    if (m_PyMethodCache[20])
        return this->::QWidget::focusNextPrevChild(next);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusNextPrevChild";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &next)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.focusNextPrevChild", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QWidget::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QWidget::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractPrintDialogWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[22])
        return this->::QWidget::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QWidget::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QAbstractPrintDialogWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[23])
        return this->::QWidget::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::hideEvent(::QHideEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QWidget::hideEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[25]) {
        return this->::QWidget::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QWidget::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QWidget::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QWidget::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QAbstractPrintDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    if (m_PyMethodCache[27])
        return this->::QWidget::inputMethodQuery(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[28]) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QDialog::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QWidget::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::leaveEvent(::QEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QWidget::leaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "leaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QWidget::leaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QAbstractPrintDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[32])
        return this->::QWidget::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QAbstractPrintDialogWrapper::minimumSizeHint() const
{
    if (m_PyMethodCache[33])
        return this->::QDialog::minimumSizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.minimumSizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[34]) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QWidget::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[35]) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QWidget::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[36]) {
        return this->::QWidget::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QWidget::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QWidget::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::moveEvent(::QMoveEvent * event)
{
    if (m_PyMethodCache[38]) {
        return this->::QWidget::moveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QAbstractPrintDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[39]) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QWidget::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

void QAbstractPrintDialogWrapper::open()
{
    if (m_PyMethodCache[40]) {
        return this->::QDialog::open();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "open";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QDialog::open();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPaintEngine * QAbstractPrintDialogWrapper::paintEngine() const
{
    if (m_PyMethodCache[41])
        return this->::QWidget::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::paintEvent(::QPaintEvent * event)
{
    if (m_PyMethodCache[42]) {
        return this->::QWidget::paintEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QWidget::paintEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QPaintDevice * QAbstractPrintDialogWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[43])
        return this->::QWidget::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QWidget::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::reject()
{
    if (m_PyMethodCache[44]) {
        return this->::QDialog::reject();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QDialog::reject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QAbstractPrintDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    if (m_PyMethodCache[45]) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QDialog::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::setVisible(bool visible)
{
    if (m_PyMethodCache[46]) {
        return this->::QDialog::setVisible(visible);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setVisible";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QDialog::setVisible(visible);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &visible)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QAbstractPrintDialogWrapper::sharedPainter() const
{
    if (m_PyMethodCache[47])
        return this->::QWidget::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[47] = true;
        return this->::QWidget::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    if (m_PyMethodCache[48]) {
        return this->::QDialog::showEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[48] = true;
        return this->::QDialog::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSize QAbstractPrintDialogWrapper::sizeHint() const
{
    if (m_PyMethodCache[49])
        return this->::QDialog::sizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[49] = true;
        return this->::QDialog::sizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QAbstractPrintDialog.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QAbstractPrintDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    if (m_PyMethodCache[50]) {
        return this->::QWidget::tabletEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[50] = true;
        return this->::QWidget::tabletEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[51]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[51] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QAbstractPrintDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[52]) {
        return this->::QWidget::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[52] = true;
        return this->::QWidget::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QAbstractPrintDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QAbstractPrintDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QAbstractPrintDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QAbstractPrintDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QAbstractPrintDialogWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QAbstractPrintDialogWrapper *>(this));
        return QAbstractPrintDialog::qt_metacast(_clname);
}

QAbstractPrintDialogWrapper::~QAbstractPrintDialogWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAbstractPrintDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAbstractPrintDialog >()))
        return -1;

    ::QAbstractPrintDialogWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QAbstractPrintDialog_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QAbstractPrintDialog", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QAbstractPrintDialog::QAbstractPrintDialog(QPrinter*,QWidget*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QAbstractPrintDialog(QPrinter*,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QAbstractPrintDialog(QPrinter*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialog_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QAbstractPrintDialog_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1]))))
                        goto Sbk_QAbstractPrintDialog_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QPrinter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QAbstractPrintDialog(QPrinter*,QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QAbstractPrintDialogWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QAbstractPrintDialogWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAbstractPrintDialog >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAbstractPrintDialog_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QAbstractPrintDialog_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QAbstractPrintDialog_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_addEnabledOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.addEnabledOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractPrintDialog::addEnabledOption(QAbstractPrintDialog::PrintDialogOption)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // addEnabledOption(QAbstractPrintDialog::PrintDialogOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_addEnabledOption_TypeError;

    // Call function/method
    {
        ::QAbstractPrintDialog::PrintDialogOption cppArg0{QAbstractPrintDialog::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addEnabledOption(QAbstractPrintDialog::PrintDialogOption)
            cppSelf->addEnabledOption(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_addEnabledOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_enabledOptions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.enabledOptions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // enabledOptions()const
            QFlags<QAbstractPrintDialog::PrintDialogOption> cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->enabledOptions();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_fromPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.fromPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fromPage()const
            int cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->fromPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_isOptionEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.isOptionEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractPrintDialog::isOptionEnabled(QAbstractPrintDialog::PrintDialogOption)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isOptionEnabled(QAbstractPrintDialog::PrintDialogOption)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_isOptionEnabled_TypeError;

    // Call function/method
    {
        ::QAbstractPrintDialog::PrintDialogOption cppArg0{QAbstractPrintDialog::None};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isOptionEnabled(QAbstractPrintDialog::PrintDialogOption)const
            bool cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->isOptionEnabled(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAbstractPrintDialogFunc_isOptionEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_maxPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.maxPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxPage()const
            int cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->maxPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_minPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.minPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minPage()const
            int cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->minPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_printRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.printRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printRange()const
            QAbstractPrintDialog::PrintRange cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->printRange();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_printer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.printer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printer()const
            QPrinter * cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->printer();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAbstractPrintDialogFunc_setEnabledOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.setEnabledOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractPrintDialog::setEnabledOptions(QFlags<QAbstractPrintDialog::PrintDialogOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setEnabledOptions(QFlags<QAbstractPrintDialog::PrintDialogOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_setEnabledOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QAbstractPrintDialog::PrintDialogOption> cppArg0 = QFlags<QAbstractPrintDialog::PrintDialogOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabledOptions(QFlags<QAbstractPrintDialog::PrintDialogOption>)
            cppSelf->setEnabledOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_setEnabledOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_setFromTo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.setFromTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFromTo", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractPrintDialog::setFromTo(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setFromTo(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_setFromTo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFromTo(int,int)
            cppSelf->setFromTo(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_setFromTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_setMinMax(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.setMinMax";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMinMax", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QAbstractPrintDialog::setMinMax(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setMinMax(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_setMinMax_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMinMax(int,int)
            cppSelf->setMinMax(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_setMinMax_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_setOptionTabs(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.setOptionTabs";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractPrintDialog::setOptionTabs(QList<QWidget*>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QWIDGETPTR_IDX], (pyArg)))) {
        overloadId = 0; // setOptionTabs(QList<QWidget*>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_setOptionTabs_TypeError;

    // Call function/method
    {
        ::QList<QWidget* > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptionTabs(QList<QWidget*>)
            cppSelf->setOptionTabs(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_setOptionTabs_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_setPrintRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.setPrintRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractPrintDialog::setPrintRange(QAbstractPrintDialog::PrintRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPrintRange(QAbstractPrintDialog::PrintRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAbstractPrintDialogFunc_setPrintRange_TypeError;

    // Call function/method
    {
        ::QAbstractPrintDialog::PrintRange cppArg0{QAbstractPrintDialog::AllPages};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrintRange(QAbstractPrintDialog::PrintRange)
            cppSelf->setPrintRange(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAbstractPrintDialogFunc_setPrintRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAbstractPrintDialogFunc_toPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QAbstractPrintDialog.toPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPage()const
            int cppResult = const_cast<const ::QAbstractPrintDialog *>(cppSelf)->toPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAbstractPrintDialog_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAbstractPrintDialog_methods[] = {
    {"addEnabledOption", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_addEnabledOption), METH_O},
    {"enabledOptions", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_enabledOptions), METH_NOARGS},
    {"fromPage", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_fromPage), METH_NOARGS},
    {"isOptionEnabled", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_isOptionEnabled), METH_O},
    {"maxPage", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_maxPage), METH_NOARGS},
    {"minPage", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_minPage), METH_NOARGS},
    {"printRange", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_printRange), METH_NOARGS},
    {"printer", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_printer), METH_NOARGS},
    {"setEnabledOptions", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_setEnabledOptions), METH_O},
    {"setFromTo", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_setFromTo), METH_VARARGS},
    {"setMinMax", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_setMinMax), METH_VARARGS},
    {"setOptionTabs", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_setOptionTabs), METH_O},
    {"setPrintRange", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_setPrintRange), METH_O},
    {"toPage", reinterpret_cast<PyCFunction>(Sbk_QAbstractPrintDialogFunc_toPage), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QAbstractPrintDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QAbstractPrintDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QAbstractPrintDialogWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QAbstractPrintDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAbstractPrintDialog_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QAbstractPrintDialogSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QAbstractPrintDialog *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDIALOG_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAbstractPrintDialog_Type = nullptr;
static SbkObjectType *Sbk_QAbstractPrintDialog_TypeF(void)
{
    return _Sbk_QAbstractPrintDialog_Type;
}

static PyType_Slot Sbk_QAbstractPrintDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QAbstractPrintDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAbstractPrintDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAbstractPrintDialog_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAbstractPrintDialog_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAbstractPrintDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAbstractPrintDialog_spec = {
    "2:PySide2.QtPrintSupport.QAbstractPrintDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAbstractPrintDialog_slots
};

} //extern "C"

static void *Sbk_QAbstractPrintDialog_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QAbstractPrintDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QAbstractPrintDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractPrintDialog::PrintDialogOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractPrintDialog::PrintDialogOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractPrintDialog::PrintDialogOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QAbstractPrintDialog::PrintDialogOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QAbstractPrintDialog::PrintDialogOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, self, &cppSelf);
    ::QAbstractPrintDialog::PrintDialogOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QAbstractPrintDialog_PrintRange_PythonToCpp_QAbstractPrintDialog_PrintRange(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractPrintDialog::PrintRange *>(cppOut) =
        static_cast<::QAbstractPrintDialog::PrintRange>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractPrintDialog_PrintRange_PythonToCpp_QAbstractPrintDialog_PrintRange_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX]))
        return QAbstractPrintDialog_PrintRange_PythonToCpp_QAbstractPrintDialog_PrintRange;
    return {};
}
static PyObject *QAbstractPrintDialog_PrintRange_CppToPython_QAbstractPrintDialog_PrintRange(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractPrintDialog::PrintRange *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX], castCppIn);

}

static void QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QAbstractPrintDialog_PrintDialogOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAbstractPrintDialog::PrintDialogOption *>(cppOut) =
        static_cast<::QAbstractPrintDialog::PrintDialogOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QAbstractPrintDialog_PrintDialogOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]))
        return QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QAbstractPrintDialog_PrintDialogOption;
    return {};
}
static PyObject *QAbstractPrintDialog_PrintDialogOption_CppToPython_QAbstractPrintDialog_PrintDialogOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAbstractPrintDialog::PrintDialogOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX], castCppIn);

}

static void QFlags_QAbstractPrintDialog_PrintDialogOption__PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractPrintDialog::PrintDialogOption> *>(cppOut) =
        ::QFlags<QAbstractPrintDialog::PrintDialogOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QAbstractPrintDialog_PrintDialogOption__PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]))
        return QFlags_QAbstractPrintDialog_PrintDialogOption__PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_;
    return {};
}
static PyObject *QFlags_QAbstractPrintDialog_PrintDialogOption__CppToPython_QFlags_QAbstractPrintDialog_PrintDialogOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QAbstractPrintDialog::PrintDialogOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]));

}

static void QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QAbstractPrintDialog::PrintDialogOption> *>(cppOut) =
        ::QFlags<QAbstractPrintDialog::PrintDialogOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]))
        return QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QAbstractPrintDialog::PrintDialogOption> *>(cppOut) =
        ::QFlags<QAbstractPrintDialog::PrintDialogOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]))
        return number_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAbstractPrintDialog_PythonToCpp_QAbstractPrintDialog_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAbstractPrintDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAbstractPrintDialog_PythonToCpp_QAbstractPrintDialog_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAbstractPrintDialog_TypeF())))
        return QAbstractPrintDialog_PythonToCpp_QAbstractPrintDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAbstractPrintDialog_PTR_CppToPython_QAbstractPrintDialog(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QAbstractPrintDialog *>(const_cast<void *>(cppIn)), Sbk_QAbstractPrintDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAbstractPrintDialog_SignatureStrings[] = {
    "PySide2.QtPrintSupport.QAbstractPrintDialog(self,printer:PySide2.QtPrintSupport.QPrinter,parent:PySide2.QtWidgets.QWidget=nullptr)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.addEnabledOption(self,option:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.enabledOptions(self)->PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.fromPage(self)->int",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.isOptionEnabled(self,option:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption)->bool",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.maxPage(self)->int",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.minPage(self)->int",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.printRange(self)->PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.printer(self)->PySide2.QtPrintSupport.QPrinter",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setEnabledOptions(self,options:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setFromTo(self,fromPage:int,toPage:int)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setMinMax(self,min:int,max:int)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setOptionTabs(self,tabs:QList[PySide2.QtWidgets.QWidget])",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.setPrintRange(self,range:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange)",
    "PySide2.QtPrintSupport.QAbstractPrintDialog.toPage(self)->int",
    nullptr}; // Sentinel

void init_QAbstractPrintDialog(PyObject *module)
{
    _Sbk_QAbstractPrintDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAbstractPrintDialog",
        "QAbstractPrintDialog*",
        &Sbk_QAbstractPrintDialog_spec,
        &Shiboken::callCppDestructor< ::QAbstractPrintDialog >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDIALOG_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractPrintDialog_Type);
    InitSignatureStrings(pyType, QAbstractPrintDialog_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAbstractPrintDialog_Type), Sbk_QAbstractPrintDialog_PropertyStrings);
    SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAbstractPrintDialog_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAbstractPrintDialog_TypeF(),
        QAbstractPrintDialog_PythonToCpp_QAbstractPrintDialog_PTR,
        is_QAbstractPrintDialog_PythonToCpp_QAbstractPrintDialog_PTR_Convertible,
        QAbstractPrintDialog_PTR_CppToPython_QAbstractPrintDialog);

    Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog*");
    Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractPrintDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAbstractPrintDialogWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QAbstractPrintDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QAbstractPrintDialog_TypeF(), &Sbk_QAbstractPrintDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QAbstractPrintDialog_TypeF(), &Sbk_QAbstractPrintDialog_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'PrintRange'.
    SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractPrintDialog_TypeF(),
        "PrintRange",
        "2:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintRange",
        "QAbstractPrintDialog::PrintRange");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "AllPages", (long) QAbstractPrintDialog::PrintRange::AllPages))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "Selection", (long) QAbstractPrintDialog::PrintRange::Selection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PageRange", (long) QAbstractPrintDialog::PrintRange::PageRange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "CurrentPage", (long) QAbstractPrintDialog::PrintRange::CurrentPage))
        return;
    // Register converter for enum 'QAbstractPrintDialog::PrintRange'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX],
            QAbstractPrintDialog_PrintRange_CppToPython_QAbstractPrintDialog_PrintRange);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractPrintDialog_PrintRange_PythonToCpp_QAbstractPrintDialog_PrintRange,
            is_QAbstractPrintDialog_PrintRange_PythonToCpp_QAbstractPrintDialog_PrintRange_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTRANGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog::PrintRange");
        Shiboken::Conversions::registerConverterName(converter, "PrintRange");
    }
    // End of 'PrintRange' enum.

    // Initialization of enum 'PrintDialogOption'.
    SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOptions", SbkPySide2_QtPrintSupport_QAbstractPrintDialog_PrintDialogOption_number_slots);
    SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAbstractPrintDialog_TypeF(),
        "PrintDialogOption",
        "2:PySide2.QtPrintSupport.QAbstractPrintDialog.PrintDialogOption",
        "QAbstractPrintDialog::PrintDialogOption",
        SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX]);
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "None_", (long) QAbstractPrintDialog::PrintDialogOption::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintToFile", (long) QAbstractPrintDialog::PrintDialogOption::PrintToFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintSelection", (long) QAbstractPrintDialog::PrintDialogOption::PrintSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintPageRange", (long) QAbstractPrintDialog::PrintDialogOption::PrintPageRange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintShowPageSize", (long) QAbstractPrintDialog::PrintDialogOption::PrintShowPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintCollateCopies", (long) QAbstractPrintDialog::PrintDialogOption::PrintCollateCopies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "DontUseSheet", (long) QAbstractPrintDialog::PrintDialogOption::DontUseSheet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
        Sbk_QAbstractPrintDialog_TypeF(), "PrintCurrentPage", (long) QAbstractPrintDialog::PrintDialogOption::PrintCurrentPage))
        return;
    // Register converter for enum 'QAbstractPrintDialog::PrintDialogOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
            QAbstractPrintDialog_PrintDialogOption_CppToPython_QAbstractPrintDialog_PrintDialogOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QAbstractPrintDialog_PrintDialogOption,
            is_QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QAbstractPrintDialog_PrintDialogOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog::PrintDialogOption");
        Shiboken::Conversions::registerConverterName(converter, "PrintDialogOption");
    }
    // Register converter for flag 'QFlags<QAbstractPrintDialog::PrintDialogOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX],
            QFlags_QAbstractPrintDialog_PrintDialogOption__CppToPython_QFlags_QAbstractPrintDialog_PrintDialogOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_,
            is_QAbstractPrintDialog_PrintDialogOption_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QAbstractPrintDialog_PrintDialogOption__PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_,
            is_QFlags_QAbstractPrintDialog_PrintDialogOption__PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption_,
            is_number_PythonToCpp_QFlags_QAbstractPrintDialog_PrintDialogOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QFLAGS_QABSTRACTPRINTDIALOG_PRINTDIALOGOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAbstractPrintDialog::PrintDialogOptions");
        Shiboken::Conversions::registerConverterName(converter, "PrintDialogOptions");
    }
    // End of 'PrintDialogOption' enum/flags.

    PySide::Signal::registerSignals(Sbk_QAbstractPrintDialog_TypeF(), &::QAbstractPrintDialog::staticMetaObject);
    qRegisterMetaType< ::QAbstractPrintDialog::PrintRange >("QAbstractPrintDialog::PrintRange");
    qRegisterMetaType< ::QAbstractPrintDialog::PrintDialogOption >("QAbstractPrintDialog::PrintDialogOption");
    qRegisterMetaType< ::QAbstractPrintDialog::PrintDialogOptions >("QAbstractPrintDialog::PrintDialogOptions");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QAbstractPrintDialog_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QAbstractPrintDialog_TypeF(), &::QAbstractPrintDialog::staticMetaObject, sizeof(QAbstractPrintDialogWrapper));
}
