/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qjsvalue_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtQml/qjsengine.h>
#include <QtQml/qjsvalue.h>
#include <qdatetime.h>
#include <qobject.h>
#include <qobjectdefs.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QJSValue_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QJSValue >()))
        return -1;

    ::QJSValue *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSValue_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QJSValue", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QJSValue::QJSValue(QJSValue::SpecialValue)
    // 1: QJSValue::QJSValue(bool)
    // 2: QJSValue::QJSValue(QJSValue)
    // 3: QJSValue::QJSValue(QString)
    // 4: QJSValue::QJSValue(const char*)
    // 5: QJSValue::QJSValue(double)
    // 6: QJSValue::QJSValue(int)
    // 7: QJSValue::QJSValue(uint)
    if (numArgs == 0) {
        overloadId = 0; // QJSValue(QJSValue::SpecialValue)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QJSValue(QJSValue::SpecialValue)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 7; // QJSValue(uint)
    } else if (numArgs == 1
        && PyFloat_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<double>(), (pyArgs[0])))) {
        overloadId = 5; // QJSValue(double)
    } else if (numArgs == 1
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 4; // QJSValue(const char*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 3; // QJSValue(QString)
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 1; // QJSValue(bool)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 6; // QJSValue(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QJSValue(QJSValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValue_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QJSValue(QJSValue::SpecialValue value)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_value = Shiboken::String::createStaticString("value");
                if (PyDict_Contains(kwds, key_value)) {
                    value = PyDict_GetItem(kwds, key_value);
                    if (value && pyArgs[0]) {
                        errInfo = key_value;
                        Py_INCREF(errInfo);
                        goto Sbk_QJSValue_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QJSValue_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_value);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QJSValue_Init_TypeError;
                }
            }
            ::QJSValue::SpecialValue cppArg0 = QJSValue::SpecialValue::UndefinedValue;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(QJSValue::SpecialValue)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 1: // QJSValue(bool value)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(bool)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 2: // QJSValue(const QJSValue & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QJSValue cppArg0_local;
            ::QJSValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QJSValue(QJSValue)
                cptr = new ::QJSValue(*cppArg0);
            }
            break;
        }
        case 3: // QJSValue(const QString & value)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(QString)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 4: // QJSValue(const char * str)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(const char*)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 5: // QJSValue(double value)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            double cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(double)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 6: // QJSValue(int value)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(int)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
        case 7: // QJSValue(uint value)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QJSValue_Init_TypeError;
            }
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QJSValue(uint)
                cptr = new ::QJSValue(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QJSValue >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QJSValue_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QJSValue_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QJSValueFunc_call(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.call";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSValueFunc_call_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:call", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJSValue::call(QList<QJSValue>)
    if (numArgs == 0) {
        overloadId = 0; // call(QList<QJSValue>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[0])))) {
        overloadId = 0; // call(QList<QJSValue>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_call_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_args = Shiboken::String::createStaticString("args");
            if (PyDict_Contains(kwds, key_args)) {
                value = PyDict_GetItem(kwds, key_args);
                if (value && pyArgs[0]) {
                    errInfo = key_args;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSValueFunc_call_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[0]))))
                        goto Sbk_QJSValueFunc_call_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_args);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSValueFunc_call_TypeError;
            }
        }
        ::QList<QJSValue > cppArg0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // call(QList<QJSValue>)
            QJSValue cppResult = cppSelf->call(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_call_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_callAsConstructor(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.callAsConstructor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSValueFunc_callAsConstructor_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:callAsConstructor", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QJSValue::callAsConstructor(QList<QJSValue>)
    if (numArgs == 0) {
        overloadId = 0; // callAsConstructor(QList<QJSValue>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[0])))) {
        overloadId = 0; // callAsConstructor(QList<QJSValue>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_callAsConstructor_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_args = Shiboken::String::createStaticString("args");
            if (PyDict_Contains(kwds, key_args)) {
                value = PyDict_GetItem(kwds, key_args);
                if (value && pyArgs[0]) {
                    errInfo = key_args;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSValueFunc_callAsConstructor_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[0]))))
                        goto Sbk_QJSValueFunc_callAsConstructor_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_args);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSValueFunc_callAsConstructor_TypeError;
            }
        }
        ::QList<QJSValue > cppArg0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // callAsConstructor(QList<QJSValue>)
            QJSValue cppResult = cppSelf->callAsConstructor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_callAsConstructor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_callWithInstance(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.callWithInstance";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QJSValueFunc_callWithInstance_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QJSValueFunc_callWithInstance_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:callWithInstance", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QJSValue::callWithInstance(QJSValue,QList<QJSValue>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // callWithInstance(QJSValue,QList<QJSValue>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[1])))) {
            overloadId = 0; // callWithInstance(QJSValue,QList<QJSValue>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_callWithInstance_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_args = Shiboken::String::createStaticString("args");
            if (PyDict_Contains(kwds, key_args)) {
                value = PyDict_GetItem(kwds, key_args);
                if (value && pyArgs[1]) {
                    errInfo = key_args;
                    Py_INCREF(errInfo);
                    goto Sbk_QJSValueFunc_callWithInstance_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QJSVALUE_IDX], (pyArgs[1]))))
                        goto Sbk_QJSValueFunc_callWithInstance_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_args);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QJSValueFunc_callWithInstance_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QJSValue cppArg0_local;
        ::QJSValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QList<QJSValue > cppArg1;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // callWithInstance(QJSValue,QList<QJSValue>)
            QJSValue cppResult = cppSelf->callWithInstance(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_callWithInstance_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_deleteProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.deleteProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::deleteProperty(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // deleteProperty(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_deleteProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // deleteProperty(QString)
            bool cppResult = cppSelf->deleteProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_deleteProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QJSEngine * cppResult = const_cast<const ::QJSValue *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_equals(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.equals";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::equals(QJSValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // equals(QJSValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_equals_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJSValue cppArg0_local;
        ::QJSValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // equals(QJSValue)const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->equals(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_equals_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_errorType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.errorType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorType()const
            QJSValue::ErrorType cppResult = const_cast<const ::QJSValue *>(cppSelf)->errorType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_hasOwnProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.hasOwnProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::hasOwnProperty(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // hasOwnProperty(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_hasOwnProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasOwnProperty(QString)const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->hasOwnProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_hasOwnProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_hasProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.hasProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::hasProperty(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // hasProperty(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_hasProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasProperty(QString)const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->hasProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_hasProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_isArray(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isArray";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isArray()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isArray();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBool()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isCallable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isCallable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCallable()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isCallable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isDate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isDate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isDate()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isDate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isError()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNumber()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isObject()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isQMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isQMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQMetaObject()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isQMetaObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isQObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isQObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isQObject()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isQObject();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isRegExp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isRegExp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isRegExp()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isRegExp();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isString()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isString();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isUndefined(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isUndefined";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUndefined()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isUndefined();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_isVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.isVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVariant()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->isVariant();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::property(QString)const
    // 1: QJSValue::property(quint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 1; // property(quint32)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // property(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_property_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // property(const QString & name) const
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // property(QString)const
                QJSValue cppResult = const_cast<const ::QJSValue *>(cppSelf)->property(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
            }
            break;
        }
        case 1: // property(quint32 arrayIndex) const
        {
            quint32 cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // property(quint32)const
                QJSValue cppResult = const_cast<const ::QJSValue *>(cppSelf)->property(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_prototype(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.prototype";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prototype()const
            QJSValue cppResult = const_cast<const ::QJSValue *>(cppSelf)->prototype();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_setProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QJSValue::setProperty(QString,QJSValue)
    // 1: QJSValue::setProperty(quint32,QJSValue)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[1])))) {
        overloadId = 1; // setProperty(quint32,QJSValue)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setProperty(QString,QJSValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_setProperty_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setProperty(const QString & name, const QJSValue & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QJSValue cppArg1_local;
            ::QJSValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setProperty(QString,QJSValue)
                cppSelf->setProperty(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setProperty(quint32 arrayIndex, const QJSValue & value)
        {
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QJSValue cppArg1_local;
            ::QJSValue *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setProperty(quint32,QJSValue)
                cppSelf->setProperty(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSValueFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_setPrototype(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.setPrototype";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::setPrototype(QJSValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // setPrototype(QJSValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_setPrototype_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJSValue cppArg0_local;
        ::QJSValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPrototype(QJSValue)
            cppSelf->setPrototype(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QJSValueFunc_setPrototype_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_strictlyEquals(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.strictlyEquals";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QJSValue::strictlyEquals(QJSValue)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // strictlyEquals(QJSValue)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QJSValueFunc_strictlyEquals_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QJSValue cppArg0_local;
        ::QJSValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // strictlyEquals(QJSValue)const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->strictlyEquals(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QJSValueFunc_strictlyEquals_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QJSValueFunc_toBool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toBool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toBool()const
            bool cppResult = const_cast<const ::QJSValue *>(cppSelf)->toBool();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toDateTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toDateTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toDateTime()const
            QDateTime cppResult = const_cast<const ::QJSValue *>(cppSelf)->toDateTime();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toInt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toInt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toInt()const
            qint32 cppResult = const_cast<const ::QJSValue *>(cppSelf)->toInt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toNumber()const
            double cppResult = const_cast<const ::QJSValue *>(cppSelf)->toNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<double>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toQMetaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toQMetaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toQMetaObject()const
            const QMetaObject * cppResult = const_cast<const ::QJSValue *>(cppSelf)->toQMetaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toQObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toQObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toQObject()const
            QObject * cppResult = const_cast<const ::QJSValue *>(cppSelf)->toQObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QJSValue *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toUInt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toUInt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toUInt()const
            quint32 cppResult = const_cast<const ::QJSValue *>(cppSelf)->toUInt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValueFunc_toVariant(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QJSValue.toVariant";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toVariant()const
            QVariant cppResult = const_cast<const ::QJSValue *>(cppSelf)->toVariant();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QJSValue___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QJSValue_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QJSValue_methods[] = {
    {"call", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_call), METH_VARARGS|METH_KEYWORDS},
    {"callAsConstructor", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_callAsConstructor), METH_VARARGS|METH_KEYWORDS},
    {"callWithInstance", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_callWithInstance), METH_VARARGS|METH_KEYWORDS},
    {"deleteProperty", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_deleteProperty), METH_O},
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_engine), METH_NOARGS},
    {"equals", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_equals), METH_O},
    {"errorType", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_errorType), METH_NOARGS},
    {"hasOwnProperty", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_hasOwnProperty), METH_O},
    {"hasProperty", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_hasProperty), METH_O},
    {"isArray", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isArray), METH_NOARGS},
    {"isBool", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isBool), METH_NOARGS},
    {"isCallable", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isCallable), METH_NOARGS},
    {"isDate", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isDate), METH_NOARGS},
    {"isError", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isError), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isNull), METH_NOARGS},
    {"isNumber", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isNumber), METH_NOARGS},
    {"isObject", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isObject), METH_NOARGS},
    {"isQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isQMetaObject), METH_NOARGS},
    {"isQObject", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isQObject), METH_NOARGS},
    {"isRegExp", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isRegExp), METH_NOARGS},
    {"isString", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isString), METH_NOARGS},
    {"isUndefined", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isUndefined), METH_NOARGS},
    {"isVariant", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_isVariant), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_property), METH_O},
    {"prototype", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_prototype), METH_NOARGS},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_setProperty), METH_VARARGS},
    {"setPrototype", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_setPrototype), METH_O},
    {"strictlyEquals", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_strictlyEquals), METH_O},
    {"toBool", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toBool), METH_NOARGS},
    {"toDateTime", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toDateTime), METH_NOARGS},
    {"toInt", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toInt), METH_NOARGS},
    {"toNumber", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toNumber), METH_NOARGS},
    {"toQMetaObject", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toQMetaObject), METH_NOARGS},
    {"toQObject", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toQObject), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toString), METH_NOARGS},
    {"toUInt", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toUInt), METH_NOARGS},
    {"toVariant", reinterpret_cast<PyCFunction>(Sbk_QJSValueFunc_toVariant), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QJSValue___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QJSValue___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QJSValue_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QJSValue_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QJSValue_Type = nullptr;
static SbkObjectType *Sbk_QJSValue_TypeF(void)
{
    return _Sbk_QJSValue_Type;
}

static PyType_Slot Sbk_QJSValue_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QJSValue_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QJSValue_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QJSValue_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QJSValue_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QJSValue___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QJSValue___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QJSValue_spec = {
    "2:PySide2.QtQml.QJSValue",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QJSValue_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QJSValue_SpecialValue_PythonToCpp_QJSValue_SpecialValue(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJSValue::SpecialValue *>(cppOut) =
        static_cast<::QJSValue::SpecialValue>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJSValue_SpecialValue_PythonToCpp_QJSValue_SpecialValue_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX]))
        return QJSValue_SpecialValue_PythonToCpp_QJSValue_SpecialValue;
    return {};
}
static PyObject *QJSValue_SpecialValue_CppToPython_QJSValue_SpecialValue(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJSValue::SpecialValue *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX], castCppIn);

}

static void QJSValue_ErrorType_PythonToCpp_QJSValue_ErrorType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJSValue::ErrorType *>(cppOut) =
        static_cast<::QJSValue::ErrorType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QJSValue_ErrorType_PythonToCpp_QJSValue_ErrorType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX]))
        return QJSValue_ErrorType_PythonToCpp_QJSValue_ErrorType;
    return {};
}
static PyObject *QJSValue_ErrorType_CppToPython_QJSValue_ErrorType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QJSValue::ErrorType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QJSValue_PythonToCpp_QJSValue_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QJSValue_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QJSValue_PythonToCpp_QJSValue_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJSValue_TypeF())))
        return QJSValue_PythonToCpp_QJSValue_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QJSValue_PTR_CppToPython_QJSValue(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QJSValue *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QJSValue_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QJSValue_COPY_CppToPython_QJSValue(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QJSValue_TypeF(), new ::QJSValue(*reinterpret_cast<const ::QJSValue *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QJSValue_PythonToCpp_QJSValue_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QJSValue *>(cppOut) = *reinterpret_cast< ::QJSValue *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QJSValue_PythonToCpp_QJSValue_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QJSValue_TypeF())))
        return QJSValue_PythonToCpp_QJSValue_COPY;
    return {};
}

// Implicit conversions.
static void QJSValue_SpecialValue_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    ::QJSValue::SpecialValue cppIn{QJSValue::NullValue};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_QJSValue_SpecialValue_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX], pyIn))
        return QJSValue_SpecialValue_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_bool_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    bool cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_bool_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (PyBool_Check(pyIn))
        return PySide2_QtCore_bool_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_constQStringREF_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    ::QString cppIn;
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constQStringREF_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constQStringREF_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_constcharPTR_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    const char* cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_constcharPTR_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (Shiboken::String::check(pyIn))
        return PySide2_QtCore_constcharPTR_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_double_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    double cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<double>(), pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_double_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (PyFloat_Check(pyIn))
        return PySide2_QtCore_double_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_int_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_int_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_int_PythonToCpp_QJSValue;
    return {};
}

static void PySide2_QtCore_uint_PythonToCpp_QJSValue(PyObject *pyIn, void *cppOut) {
    uint cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), pyIn, &cppIn);
    *reinterpret_cast<::QJSValue *>(cppOut) = ::QJSValue(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_uint_PythonToCpp_QJSValue_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_uint_PythonToCpp_QJSValue;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QJSValue_SignatureStrings[] = {
    "7:PySide2.QtQml.QJSValue(self,value:PySide2.QtQml.QJSValue.SpecialValue=UndefinedValue)",
    "6:PySide2.QtQml.QJSValue(self,value:bool)",
    "5:PySide2.QtQml.QJSValue(self,other:PySide2.QtQml.QJSValue)",
    "4:PySide2.QtQml.QJSValue(self,value:QString)",
    "3:PySide2.QtQml.QJSValue(self,str:char*)",
    "2:PySide2.QtQml.QJSValue(self,value:double)",
    "1:PySide2.QtQml.QJSValue(self,value:int)",
    "0:PySide2.QtQml.QJSValue(self,value:uint)",
    "PySide2.QtQml.QJSValue.call(self,args:QList[PySide2.QtQml.QJSValue]=QJSValueList())->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSValue.callAsConstructor(self,args:QList[PySide2.QtQml.QJSValue]=QJSValueList())->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSValue.callWithInstance(self,instance:PySide2.QtQml.QJSValue,args:QList[PySide2.QtQml.QJSValue]=QJSValueList())->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSValue.deleteProperty(self,name:QString)->bool",
    "PySide2.QtQml.QJSValue.engine(self)->PySide2.QtQml.QJSEngine",
    "PySide2.QtQml.QJSValue.equals(self,other:PySide2.QtQml.QJSValue)->bool",
    "PySide2.QtQml.QJSValue.errorType(self)->PySide2.QtQml.QJSValue.ErrorType",
    "PySide2.QtQml.QJSValue.hasOwnProperty(self,name:QString)->bool",
    "PySide2.QtQml.QJSValue.hasProperty(self,name:QString)->bool",
    "PySide2.QtQml.QJSValue.isArray(self)->bool",
    "PySide2.QtQml.QJSValue.isBool(self)->bool",
    "PySide2.QtQml.QJSValue.isCallable(self)->bool",
    "PySide2.QtQml.QJSValue.isDate(self)->bool",
    "PySide2.QtQml.QJSValue.isError(self)->bool",
    "PySide2.QtQml.QJSValue.isNull(self)->bool",
    "PySide2.QtQml.QJSValue.isNumber(self)->bool",
    "PySide2.QtQml.QJSValue.isObject(self)->bool",
    "PySide2.QtQml.QJSValue.isQMetaObject(self)->bool",
    "PySide2.QtQml.QJSValue.isQObject(self)->bool",
    "PySide2.QtQml.QJSValue.isRegExp(self)->bool",
    "PySide2.QtQml.QJSValue.isString(self)->bool",
    "PySide2.QtQml.QJSValue.isUndefined(self)->bool",
    "PySide2.QtQml.QJSValue.isVariant(self)->bool",
    "1:PySide2.QtQml.QJSValue.property(self,name:QString)->PySide2.QtQml.QJSValue",
    "0:PySide2.QtQml.QJSValue.property(self,arrayIndex:quint32)->PySide2.QtQml.QJSValue",
    "PySide2.QtQml.QJSValue.prototype(self)->PySide2.QtQml.QJSValue",
    "1:PySide2.QtQml.QJSValue.setProperty(self,name:QString,value:PySide2.QtQml.QJSValue)",
    "0:PySide2.QtQml.QJSValue.setProperty(self,arrayIndex:quint32,value:PySide2.QtQml.QJSValue)",
    "PySide2.QtQml.QJSValue.setPrototype(self,prototype:PySide2.QtQml.QJSValue)",
    "PySide2.QtQml.QJSValue.strictlyEquals(self,other:PySide2.QtQml.QJSValue)->bool",
    "PySide2.QtQml.QJSValue.toBool(self)->bool",
    "PySide2.QtQml.QJSValue.toDateTime(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtQml.QJSValue.toInt(self)->qint32",
    "PySide2.QtQml.QJSValue.toNumber(self)->double",
    "PySide2.QtQml.QJSValue.toQMetaObject(self)->PySide2.QtCore.QMetaObject",
    "PySide2.QtQml.QJSValue.toQObject(self)->PySide2.QtCore.QObject",
    "PySide2.QtQml.QJSValue.toString(self)->QString",
    "PySide2.QtQml.QJSValue.toUInt(self)->quint32",
    "PySide2.QtQml.QJSValue.toVariant(self)->QVariant",
    "PySide2.QtQml.QJSValue.__copy__()",
    nullptr}; // Sentinel

void init_QJSValue(PyObject *module)
{
    _Sbk_QJSValue_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QJSValue",
        "QJSValue",
        &Sbk_QJSValue_spec,
        &Shiboken::callCppDestructor< ::QJSValue >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QJSValue_Type);
    InitSignatureStrings(pyType, QJSValue_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QJSValue_Type), Sbk_QJSValue_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QJSValue_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QJSValue_TypeF(),
        QJSValue_PythonToCpp_QJSValue_PTR,
        is_QJSValue_PythonToCpp_QJSValue_PTR_Convertible,
        QJSValue_PTR_CppToPython_QJSValue,
        QJSValue_COPY_CppToPython_QJSValue);

    Shiboken::Conversions::registerConverterName(converter, "QJSValue");
    Shiboken::Conversions::registerConverterName(converter, "QJSValue*");
    Shiboken::Conversions::registerConverterName(converter, "QJSValue&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QJSValue).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJSValue_PythonToCpp_QJSValue_COPY,
        is_QJSValue_PythonToCpp_QJSValue_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QJSValue_SpecialValue_PythonToCpp_QJSValue,
        is_QJSValue_SpecialValue_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_bool_PythonToCpp_QJSValue,
        is_PySide2_QtCore_bool_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQStringREF_PythonToCpp_QJSValue,
        is_PySide2_QtCore_constQStringREF_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constcharPTR_PythonToCpp_QJSValue,
        is_PySide2_QtCore_constcharPTR_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_double_PythonToCpp_QJSValue,
        is_PySide2_QtCore_double_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_int_PythonToCpp_QJSValue,
        is_PySide2_QtCore_int_PythonToCpp_QJSValue_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_uint_PythonToCpp_QJSValue,
        is_PySide2_QtCore_uint_PythonToCpp_QJSValue_Convertible);

    // Initialization of enums.

    // Initialization of enum 'SpecialValue'.
    SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJSValue_TypeF(),
        "SpecialValue",
        "2:PySide2.QtQml.QJSValue.SpecialValue",
        "QJSValue::SpecialValue");
    if (!SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX],
        Sbk_QJSValue_TypeF(), "NullValue", (long) QJSValue::SpecialValue::NullValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX],
        Sbk_QJSValue_TypeF(), "UndefinedValue", (long) QJSValue::SpecialValue::UndefinedValue))
        return;
    // Register converter for enum 'QJSValue::SpecialValue'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX],
            QJSValue_SpecialValue_CppToPython_QJSValue_SpecialValue);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJSValue_SpecialValue_PythonToCpp_QJSValue_SpecialValue,
            is_QJSValue_SpecialValue_PythonToCpp_QJSValue_SpecialValue_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_SPECIALVALUE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJSValue::SpecialValue");
        Shiboken::Conversions::registerConverterName(converter, "SpecialValue");
    }
    // End of 'SpecialValue' enum.

    // Initialization of enum 'ErrorType'.
    SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QJSValue_TypeF(),
        "ErrorType",
        "2:PySide2.QtQml.QJSValue.ErrorType",
        "QJSValue::ErrorType");
    if (!SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "NoError", (long) QJSValue::ErrorType::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "GenericError", (long) QJSValue::ErrorType::GenericError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "EvalError", (long) QJSValue::ErrorType::EvalError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "RangeError", (long) QJSValue::ErrorType::RangeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "ReferenceError", (long) QJSValue::ErrorType::ReferenceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "SyntaxError", (long) QJSValue::ErrorType::SyntaxError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "TypeError", (long) QJSValue::ErrorType::TypeError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
        Sbk_QJSValue_TypeF(), "URIError", (long) QJSValue::ErrorType::URIError))
        return;
    // Register converter for enum 'QJSValue::ErrorType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX],
            QJSValue_ErrorType_CppToPython_QJSValue_ErrorType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QJSValue_ErrorType_PythonToCpp_QJSValue_ErrorType,
            is_QJSValue_ErrorType_PythonToCpp_QJSValue_ErrorType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_ERRORTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QJSValue::ErrorType");
        Shiboken::Conversions::registerConverterName(converter, "ErrorType");
    }
    // End of 'ErrorType' enum.

    qRegisterMetaType< ::QJSValue::SpecialValue >("QJSValue::SpecialValue");
    qRegisterMetaType< ::QJSValue::ErrorType >("QJSValue::ErrorType");
}
