/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlabstracturlinterceptor_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlAbstractUrlInterceptorWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQmlAbstractUrlInterceptorWrapper::QQmlAbstractUrlInterceptorWrapper() : QQmlAbstractUrlInterceptor()
{
    resetPyMethodCache();
    // ... middle
}

::QUrl QQmlAbstractUrlInterceptorWrapper::intercept(const ::QUrl & path, ::QQmlAbstractUrlInterceptor::DataType type)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlAbstractUrlInterceptor.intercept()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "intercept";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlAbstractUrlInterceptor.intercept()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &path),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX])->converter, &type)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQmlAbstractUrlInterceptor.intercept", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QUrl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QUrl cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QQmlAbstractUrlInterceptorWrapper::~QQmlAbstractUrlInterceptorWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlAbstractUrlInterceptor_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QQmlAbstractUrlInterceptor' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlAbstractUrlInterceptor >()))
        return -1;

    ::QQmlAbstractUrlInterceptorWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlAbstractUrlInterceptor.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QQmlAbstractUrlInterceptor()
            cptr = new ::QQmlAbstractUrlInterceptorWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlAbstractUrlInterceptor >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QQmlAbstractUrlInterceptorFunc_intercept(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlAbstractUrlInterceptor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlAbstractUrlInterceptor.intercept";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "intercept", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlAbstractUrlInterceptor::intercept(QUrl,QQmlAbstractUrlInterceptor::DataType)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // intercept(QUrl,QQmlAbstractUrlInterceptor::DataType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlAbstractUrlInterceptorFunc_intercept_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QQmlAbstractUrlInterceptor::DataType cppArg1{QQmlAbstractUrlInterceptor::QmlFile};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // intercept(QUrl,QQmlAbstractUrlInterceptor::DataType)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlAbstractUrlInterceptor.intercept()' not implemented.");
                return {};
            }
            QUrl cppResult = cppSelf->intercept(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQmlAbstractUrlInterceptorFunc_intercept_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlAbstractUrlInterceptor_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlAbstractUrlInterceptor_methods[] = {
    {"intercept", reinterpret_cast<PyCFunction>(Sbk_QQmlAbstractUrlInterceptorFunc_intercept), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlAbstractUrlInterceptor_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlAbstractUrlInterceptor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlAbstractUrlInterceptorWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQmlAbstractUrlInterceptor_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlAbstractUrlInterceptor_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlAbstractUrlInterceptor_Type = nullptr;
static SbkObjectType *Sbk_QQmlAbstractUrlInterceptor_TypeF(void)
{
    return _Sbk_QQmlAbstractUrlInterceptor_Type;
}

static PyType_Slot Sbk_QQmlAbstractUrlInterceptor_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlAbstractUrlInterceptor_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlAbstractUrlInterceptor_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlAbstractUrlInterceptor_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlAbstractUrlInterceptor_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlAbstractUrlInterceptor_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlAbstractUrlInterceptor_spec = {
    "2:PySide2.QtQml.QQmlAbstractUrlInterceptor",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlAbstractUrlInterceptor_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlAbstractUrlInterceptor_DataType_PythonToCpp_QQmlAbstractUrlInterceptor_DataType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlAbstractUrlInterceptor::DataType *>(cppOut) =
        static_cast<::QQmlAbstractUrlInterceptor::DataType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlAbstractUrlInterceptor_DataType_PythonToCpp_QQmlAbstractUrlInterceptor_DataType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX]))
        return QQmlAbstractUrlInterceptor_DataType_PythonToCpp_QQmlAbstractUrlInterceptor_DataType;
    return {};
}
static PyObject *QQmlAbstractUrlInterceptor_DataType_CppToPython_QQmlAbstractUrlInterceptor_DataType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlAbstractUrlInterceptor::DataType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlAbstractUrlInterceptor_PythonToCpp_QQmlAbstractUrlInterceptor_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlAbstractUrlInterceptor_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlAbstractUrlInterceptor_PythonToCpp_QQmlAbstractUrlInterceptor_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlAbstractUrlInterceptor_TypeF())))
        return QQmlAbstractUrlInterceptor_PythonToCpp_QQmlAbstractUrlInterceptor_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlAbstractUrlInterceptor_PTR_CppToPython_QQmlAbstractUrlInterceptor(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlAbstractUrlInterceptor *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlAbstractUrlInterceptor_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlAbstractUrlInterceptor_SignatureStrings[] = {
    "PySide2.QtQml.QQmlAbstractUrlInterceptor(self)",
    "PySide2.QtQml.QQmlAbstractUrlInterceptor.intercept(self,path:PySide2.QtCore.QUrl,type:PySide2.QtQml.QQmlAbstractUrlInterceptor.DataType)->PySide2.QtCore.QUrl",
    nullptr}; // Sentinel

void init_QQmlAbstractUrlInterceptor(PyObject *module)
{
    _Sbk_QQmlAbstractUrlInterceptor_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlAbstractUrlInterceptor",
        "QQmlAbstractUrlInterceptor*",
        &Sbk_QQmlAbstractUrlInterceptor_spec,
        &Shiboken::callCppDestructor< ::QQmlAbstractUrlInterceptor >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlAbstractUrlInterceptor_Type);
    InitSignatureStrings(pyType, QQmlAbstractUrlInterceptor_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlAbstractUrlInterceptor_Type), Sbk_QQmlAbstractUrlInterceptor_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlAbstractUrlInterceptor_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlAbstractUrlInterceptor_TypeF(),
        QQmlAbstractUrlInterceptor_PythonToCpp_QQmlAbstractUrlInterceptor_PTR,
        is_QQmlAbstractUrlInterceptor_PythonToCpp_QQmlAbstractUrlInterceptor_PTR_Convertible,
        QQmlAbstractUrlInterceptor_PTR_CppToPython_QQmlAbstractUrlInterceptor);

    Shiboken::Conversions::registerConverterName(converter, "QQmlAbstractUrlInterceptor");
    Shiboken::Conversions::registerConverterName(converter, "QQmlAbstractUrlInterceptor*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlAbstractUrlInterceptor&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlAbstractUrlInterceptor).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlAbstractUrlInterceptorWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'DataType'.
    SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlAbstractUrlInterceptor_TypeF(),
        "DataType",
        "2:PySide2.QtQml.QQmlAbstractUrlInterceptor.DataType",
        "QQmlAbstractUrlInterceptor::DataType");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX],
        Sbk_QQmlAbstractUrlInterceptor_TypeF(), "QmlFile", (long) QQmlAbstractUrlInterceptor::DataType::QmlFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX],
        Sbk_QQmlAbstractUrlInterceptor_TypeF(), "JavaScriptFile", (long) QQmlAbstractUrlInterceptor::DataType::JavaScriptFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX],
        Sbk_QQmlAbstractUrlInterceptor_TypeF(), "QmldirFile", (long) QQmlAbstractUrlInterceptor::DataType::QmldirFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX],
        Sbk_QQmlAbstractUrlInterceptor_TypeF(), "UrlString", (long) QQmlAbstractUrlInterceptor::DataType::UrlString))
        return;
    // Register converter for enum 'QQmlAbstractUrlInterceptor::DataType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX],
            QQmlAbstractUrlInterceptor_DataType_CppToPython_QQmlAbstractUrlInterceptor_DataType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlAbstractUrlInterceptor_DataType_PythonToCpp_QQmlAbstractUrlInterceptor_DataType,
            is_QQmlAbstractUrlInterceptor_DataType_PythonToCpp_QQmlAbstractUrlInterceptor_DataType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLABSTRACTURLINTERCEPTOR_DATATYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlAbstractUrlInterceptor::DataType");
        Shiboken::Conversions::registerConverterName(converter, "DataType");
    }
    // End of 'DataType' enum.

    qRegisterMetaType< ::QQmlAbstractUrlInterceptor::DataType >("QQmlAbstractUrlInterceptor::DataType");
}
