/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlextensioninterface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlExtensionInterfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQmlExtensionInterfaceWrapper::QQmlExtensionInterfaceWrapper() : QQmlExtensionInterface()
{
    resetPyMethodCache();
    // ... middle
}

void QQmlExtensionInterfaceWrapper::initializeEngine(::QQmlEngine * engine, const char * uri)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlExtensionInterface.initializeEngine()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initializeEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlExtensionInterface.initializeEngine()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), engine),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), uri)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQmlExtensionInterfaceWrapper::registerTypes(const char * uri)
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlExtensionInterface.registerTypes()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "registerTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlExtensionInterface.registerTypes()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), uri)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QQmlExtensionInterfaceWrapper::~QQmlExtensionInterfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlExtensionInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLEXTENSIONINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QQmlExtensionInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlExtensionInterface >()))
        return -1;

    ::QQmlExtensionInterfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlExtensionInterface.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QQmlExtensionInterface()
            cptr = new ::QQmlExtensionInterfaceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlExtensionInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QQmlExtensionInterfaceFunc_initializeEngine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlExtensionInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLEXTENSIONINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlExtensionInterface.initializeEngine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "initializeEngine", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQmlExtensionInterface::initializeEngine(QQmlEngine*,const char*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLENGINE_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // initializeEngine(QQmlEngine*,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlExtensionInterfaceFunc_initializeEngine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQmlEngine *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        const char* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // initializeEngine(QQmlEngine*,const char*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlExtensionInterface.initializeEngine()' not implemented.");
                return {};
            }
            cppSelf->initializeEngine(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlExtensionInterfaceFunc_initializeEngine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlExtensionInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlExtensionInterface_methods[] = {
    {"initializeEngine", reinterpret_cast<PyCFunction>(Sbk_QQmlExtensionInterfaceFunc_initializeEngine), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlExtensionInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlExtensionInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLEXTENSIONINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlExtensionInterfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQmlExtensionInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlExtensionInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlExtensionInterface_Type = nullptr;
static SbkObjectType *Sbk_QQmlExtensionInterface_TypeF(void)
{
    return _Sbk_QQmlExtensionInterface_Type;
}

static PyType_Slot Sbk_QQmlExtensionInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlExtensionInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlExtensionInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlExtensionInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlExtensionInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlExtensionInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlExtensionInterface_spec = {
    "2:PySide2.QtQml.QQmlExtensionInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlExtensionInterface_slots
};

} //extern "C"

static void *Sbk_QQmlExtensionInterface_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QQmlTypesExtensionInterface >()))
        return dynamic_cast< ::QQmlExtensionInterface *>(reinterpret_cast< ::QQmlTypesExtensionInterface *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlExtensionInterface_PythonToCpp_QQmlExtensionInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlExtensionInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlExtensionInterface_PythonToCpp_QQmlExtensionInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlExtensionInterface_TypeF())))
        return QQmlExtensionInterface_PythonToCpp_QQmlExtensionInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlExtensionInterface_PTR_CppToPython_QQmlExtensionInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlExtensionInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlExtensionInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlExtensionInterface_SignatureStrings[] = {
    "PySide2.QtQml.QQmlExtensionInterface(self)",
    "PySide2.QtQml.QQmlExtensionInterface.initializeEngine(self,engine:PySide2.QtQml.QQmlEngine,uri:char*)",
    nullptr}; // Sentinel

void init_QQmlExtensionInterface(PyObject *module)
{
    _Sbk_QQmlExtensionInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlExtensionInterface",
        "QQmlExtensionInterface*",
        &Sbk_QQmlExtensionInterface_spec,
        &Shiboken::callCppDestructor< ::QQmlExtensionInterface >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLTYPESEXTENSIONINTERFACE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlExtensionInterface_Type);
    InitSignatureStrings(pyType, QQmlExtensionInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlExtensionInterface_Type), Sbk_QQmlExtensionInterface_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLEXTENSIONINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlExtensionInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlExtensionInterface_TypeF(),
        QQmlExtensionInterface_PythonToCpp_QQmlExtensionInterface_PTR,
        is_QQmlExtensionInterface_PythonToCpp_QQmlExtensionInterface_PTR_Convertible,
        QQmlExtensionInterface_PTR_CppToPython_QQmlExtensionInterface);

    Shiboken::Conversions::registerConverterName(converter, "QQmlExtensionInterface");
    Shiboken::Conversions::registerConverterName(converter, "QQmlExtensionInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlExtensionInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlExtensionInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlExtensionInterfaceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QQmlExtensionInterface_TypeF(), &Sbk_QQmlExtensionInterface_typeDiscovery);

}
