/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlincubator_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlIncubatorWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQmlIncubatorWrapper::QQmlIncubatorWrapper(::QQmlIncubator::IncubationMode arg__1) : QQmlIncubator(arg__1)
{
    resetPyMethodCache();
    // ... middle
}

void QQmlIncubatorWrapper::setInitialState(::QObject * arg__1)
{
    if (m_PyMethodCache[0]) {
        return this->::QQmlIncubator::setInitialState(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setInitialState";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQmlIncubator::setInitialState(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQmlIncubatorWrapper::statusChanged(::QQmlIncubator::Status arg__1)
{
    if (m_PyMethodCache[1]) {
        return this->::QQmlIncubator::statusChanged(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "statusChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QQmlIncubator::statusChanged(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QQmlIncubatorWrapper::~QQmlIncubatorWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlIncubator_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlIncubator >()))
        return -1;

    ::QQmlIncubatorWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQmlIncubator_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QQmlIncubator", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QQmlIncubator::QQmlIncubator(QQmlIncubator::IncubationMode)
    if (numArgs == 0) {
        overloadId = 0; // QQmlIncubator(QQmlIncubator::IncubationMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QQmlIncubator(QQmlIncubator::IncubationMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubator_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_arg__1 = Shiboken::String::createStaticString("arg__1");
            if (PyDict_Contains(kwds, key_arg__1)) {
                value = PyDict_GetItem(kwds, key_arg__1);
                if (value && pyArgs[0]) {
                    errInfo = key_arg__1;
                    Py_INCREF(errInfo);
                    goto Sbk_QQmlIncubator_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QQmlIncubator_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_arg__1);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQmlIncubator_Init_TypeError;
            }
        }
        ::QQmlIncubator::IncubationMode cppArg0 = QQmlIncubator::IncubationMode::Asynchronous;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QQmlIncubator(QQmlIncubator::IncubationMode)
            cptr = new ::QQmlIncubatorWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlIncubator >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQmlIncubator_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QQmlIncubator_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQmlIncubatorFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQmlIncubatorFunc_errors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.errors";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errors()const
            QList<QQmlError > cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->errors();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QLIST_QQMLERROR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_forceCompletion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.forceCompletion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // forceCompletion()
            cppSelf->forceCompletion();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQmlIncubatorFunc_incubationMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.incubationMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // incubationMode()const
            QQmlIncubator::IncubationMode cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->incubationMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_isError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.isError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isError()const
            bool cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->isError();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_isLoading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.isLoading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoading()const
            bool cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->isLoading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_isReady(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.isReady";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReady()const
            bool cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->isReady();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_object(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.object";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // object()const
            QObject * cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->object();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_setInitialProperties(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.setInitialProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlIncubator::setInitialProperties(QMap<QString,QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQmlTypeConverters[SBK_QTQML_QMAP_QSTRING_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setInitialProperties(QMap<QString,QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubatorFunc_setInitialProperties_TypeError;

    // Call function/method
    {
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInitialProperties(QMap<QString,QVariant>)
            cppSelf->setInitialProperties(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubatorFunc_setInitialProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlIncubatorFunc_setInitialState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.setInitialState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlIncubator::setInitialState(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setInitialState(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubatorFunc_setInitialState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInitialState(QObject*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQmlIncubator::setInitialState(cppArg0)
                : cppSelf->setInitialState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubatorFunc_setInitialState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQmlIncubatorFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QQmlIncubator::Status cppResult = const_cast<const ::QQmlIncubator *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQmlIncubatorFunc_statusChanged(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlIncubator.statusChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlIncubator::statusChanged(QQmlIncubator::Status)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // statusChanged(QQmlIncubator::Status)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlIncubatorFunc_statusChanged_TypeError;

    // Call function/method
    {
        ::QQmlIncubator::Status cppArg0{QQmlIncubator::Null};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // statusChanged(QQmlIncubator::Status)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQmlIncubator::statusChanged(cppArg0)
                : cppSelf->statusChanged(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlIncubatorFunc_statusChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlIncubator_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlIncubator_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_clear), METH_NOARGS},
    {"errors", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_errors), METH_NOARGS},
    {"forceCompletion", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_forceCompletion), METH_NOARGS},
    {"incubationMode", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_incubationMode), METH_NOARGS},
    {"isError", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_isError), METH_NOARGS},
    {"isLoading", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_isLoading), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_isNull), METH_NOARGS},
    {"isReady", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_isReady), METH_NOARGS},
    {"object", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_object), METH_NOARGS},
    {"setInitialProperties", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_setInitialProperties), METH_O},
    {"setInitialState", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_setInitialState), METH_O},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_status), METH_NOARGS},
    {"statusChanged", reinterpret_cast<PyCFunction>(Sbk_QQmlIncubatorFunc_statusChanged), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlIncubator_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlIncubatorWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static int Sbk_QQmlIncubator___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QQmlIncubator *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

} // extern "C"

static int Sbk_QQmlIncubator_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlIncubator_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlIncubator_Type = nullptr;
static SbkObjectType *Sbk_QQmlIncubator_TypeF(void)
{
    return _Sbk_QQmlIncubator_Type;
}

static PyType_Slot Sbk_QQmlIncubator_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlIncubator_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlIncubator_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlIncubator_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlIncubator_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlIncubator_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QQmlIncubator___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QQmlIncubator___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlIncubator_spec = {
    "2:PySide2.QtQml.QQmlIncubator",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlIncubator_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QQmlIncubator_IncubationMode_PythonToCpp_QQmlIncubator_IncubationMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlIncubator::IncubationMode *>(cppOut) =
        static_cast<::QQmlIncubator::IncubationMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlIncubator_IncubationMode_PythonToCpp_QQmlIncubator_IncubationMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX]))
        return QQmlIncubator_IncubationMode_PythonToCpp_QQmlIncubator_IncubationMode;
    return {};
}
static PyObject *QQmlIncubator_IncubationMode_CppToPython_QQmlIncubator_IncubationMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlIncubator::IncubationMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX], castCppIn);

}

static void QQmlIncubator_Status_PythonToCpp_QQmlIncubator_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQmlIncubator::Status *>(cppOut) =
        static_cast<::QQmlIncubator::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQmlIncubator_Status_PythonToCpp_QQmlIncubator_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX]))
        return QQmlIncubator_Status_PythonToCpp_QQmlIncubator_Status;
    return {};
}
static PyObject *QQmlIncubator_Status_CppToPython_QQmlIncubator_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQmlIncubator::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlIncubator_PythonToCpp_QQmlIncubator_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlIncubator_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlIncubator_PythonToCpp_QQmlIncubator_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlIncubator_TypeF())))
        return QQmlIncubator_PythonToCpp_QQmlIncubator_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlIncubator_PTR_CppToPython_QQmlIncubator(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlIncubator *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlIncubator_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlIncubator_SignatureStrings[] = {
    "PySide2.QtQml.QQmlIncubator(self,arg__1:PySide2.QtQml.QQmlIncubator.IncubationMode=Asynchronous)",
    "PySide2.QtQml.QQmlIncubator.clear(self)",
    "PySide2.QtQml.QQmlIncubator.errors(self)->QList[PySide2.QtQml.QQmlError]",
    "PySide2.QtQml.QQmlIncubator.forceCompletion(self)",
    "PySide2.QtQml.QQmlIncubator.incubationMode(self)->PySide2.QtQml.QQmlIncubator.IncubationMode",
    "PySide2.QtQml.QQmlIncubator.isError(self)->bool",
    "PySide2.QtQml.QQmlIncubator.isLoading(self)->bool",
    "PySide2.QtQml.QQmlIncubator.isNull(self)->bool",
    "PySide2.QtQml.QQmlIncubator.isReady(self)->bool",
    "PySide2.QtQml.QQmlIncubator.object(self)->PySide2.QtCore.QObject",
    "PySide2.QtQml.QQmlIncubator.setInitialProperties(self,initialProperties:QMap[QString, QVariant])",
    "PySide2.QtQml.QQmlIncubator.setInitialState(self,arg__1:PySide2.QtCore.QObject)",
    "PySide2.QtQml.QQmlIncubator.status(self)->PySide2.QtQml.QQmlIncubator.Status",
    "PySide2.QtQml.QQmlIncubator.statusChanged(self,arg__1:PySide2.QtQml.QQmlIncubator.Status)",
    nullptr}; // Sentinel

void init_QQmlIncubator(PyObject *module)
{
    _Sbk_QQmlIncubator_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlIncubator",
        "QQmlIncubator*",
        &Sbk_QQmlIncubator_spec,
        &Shiboken::callCppDestructor< ::QQmlIncubator >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlIncubator_Type);
    InitSignatureStrings(pyType, QQmlIncubator_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlIncubator_Type), Sbk_QQmlIncubator_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlIncubator_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlIncubator_TypeF(),
        QQmlIncubator_PythonToCpp_QQmlIncubator_PTR,
        is_QQmlIncubator_PythonToCpp_QQmlIncubator_PTR_Convertible,
        QQmlIncubator_PTR_CppToPython_QQmlIncubator);

    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubator");
    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubator*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlIncubator&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlIncubator).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlIncubatorWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'IncubationMode'.
    SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlIncubator_TypeF(),
        "IncubationMode",
        "2:PySide2.QtQml.QQmlIncubator.IncubationMode",
        "QQmlIncubator::IncubationMode");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX],
        Sbk_QQmlIncubator_TypeF(), "Asynchronous", (long) QQmlIncubator::IncubationMode::Asynchronous))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX],
        Sbk_QQmlIncubator_TypeF(), "AsynchronousIfNested", (long) QQmlIncubator::IncubationMode::AsynchronousIfNested))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX],
        Sbk_QQmlIncubator_TypeF(), "Synchronous", (long) QQmlIncubator::IncubationMode::Synchronous))
        return;
    // Register converter for enum 'QQmlIncubator::IncubationMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX],
            QQmlIncubator_IncubationMode_CppToPython_QQmlIncubator_IncubationMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlIncubator_IncubationMode_PythonToCpp_QQmlIncubator_IncubationMode,
            is_QQmlIncubator_IncubationMode_PythonToCpp_QQmlIncubator_IncubationMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_INCUBATIONMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlIncubator::IncubationMode");
        Shiboken::Conversions::registerConverterName(converter, "IncubationMode");
    }
    // End of 'IncubationMode' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQmlIncubator_TypeF(),
        "Status",
        "2:PySide2.QtQml.QQmlIncubator.Status",
        "QQmlIncubator::Status");
    if (!SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX],
        Sbk_QQmlIncubator_TypeF(), "Null", (long) QQmlIncubator::Status::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX],
        Sbk_QQmlIncubator_TypeF(), "Ready", (long) QQmlIncubator::Status::Ready))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX],
        Sbk_QQmlIncubator_TypeF(), "Loading", (long) QQmlIncubator::Status::Loading))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX],
        Sbk_QQmlIncubator_TypeF(), "Error", (long) QQmlIncubator::Status::Error))
        return;
    // Register converter for enum 'QQmlIncubator::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX],
            QQmlIncubator_Status_CppToPython_QQmlIncubator_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQmlIncubator_Status_PythonToCpp_QQmlIncubator_Status,
            is_QQmlIncubator_Status_PythonToCpp_QQmlIncubator_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQmlTypes[SBK_QQMLINCUBATOR_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQmlIncubator::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    qRegisterMetaType< ::QQmlIncubator::IncubationMode >("QQmlIncubator::IncubationMode");
    qRegisterMetaType< ::QQmlIncubator::Status >("QQmlIncubator::Status");
}
