/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtqml_python.h"

// main header
#include "qqmlpropertyvaluesource_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQmlPropertyValueSourceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQmlPropertyValueSourceWrapper::QQmlPropertyValueSourceWrapper() : QQmlPropertyValueSource()
{
    resetPyMethodCache();
    // ... middle
}

void QQmlPropertyValueSourceWrapper::setTarget(const ::QQmlProperty & arg__1)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlPropertyValueSource.setTarget()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setTarget";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlPropertyValueSource.setTarget()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QQmlPropertyValueSourceWrapper::~QQmlPropertyValueSourceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQmlPropertyValueSource_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTYVALUESOURCE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QQmlPropertyValueSource' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQmlPropertyValueSource >()))
        return -1;

    ::QQmlPropertyValueSourceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlPropertyValueSource.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QQmlPropertyValueSource()
            cptr = new ::QQmlPropertyValueSourceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQmlPropertyValueSource >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QQmlPropertyValueSourceFunc_setTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQmlPropertyValueSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTYVALUESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQml.QQmlPropertyValueSource.setTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQmlPropertyValueSource::setTarget(QQmlProperty)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), (pyArg)))) {
        overloadId = 0; // setTarget(QQmlProperty)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQmlPropertyValueSourceFunc_setTarget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQmlProperty cppArg0_local;
        ::QQmlProperty *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTarget(QQmlProperty)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QQmlPropertyValueSource.setTarget()' not implemented.");
                return {};
            }
            cppSelf->setTarget(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQmlPropertyValueSourceFunc_setTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QQmlPropertyValueSource_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQmlPropertyValueSource_methods[] = {
    {"setTarget", reinterpret_cast<PyCFunction>(Sbk_QQmlPropertyValueSourceFunc_setTarget), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQmlPropertyValueSource_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQmlPropertyValueSource *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTYVALUESOURCE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQmlPropertyValueSourceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQmlPropertyValueSource_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQmlPropertyValueSource_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQmlPropertyValueSource_Type = nullptr;
static SbkObjectType *Sbk_QQmlPropertyValueSource_TypeF(void)
{
    return _Sbk_QQmlPropertyValueSource_Type;
}

static PyType_Slot Sbk_QQmlPropertyValueSource_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQmlPropertyValueSource_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQmlPropertyValueSource_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQmlPropertyValueSource_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQmlPropertyValueSource_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQmlPropertyValueSource_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQmlPropertyValueSource_spec = {
    "2:PySide2.QtQml.QQmlPropertyValueSource",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQmlPropertyValueSource_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQmlPropertyValueSource_PythonToCpp_QQmlPropertyValueSource_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQmlPropertyValueSource_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQmlPropertyValueSource_PythonToCpp_QQmlPropertyValueSource_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQmlPropertyValueSource_TypeF())))
        return QQmlPropertyValueSource_PythonToCpp_QQmlPropertyValueSource_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQmlPropertyValueSource_PTR_CppToPython_QQmlPropertyValueSource(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QQmlPropertyValueSource *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QQmlPropertyValueSource_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQmlPropertyValueSource_SignatureStrings[] = {
    "PySide2.QtQml.QQmlPropertyValueSource(self)",
    "PySide2.QtQml.QQmlPropertyValueSource.setTarget(self,arg__1:PySide2.QtQml.QQmlProperty)",
    nullptr}; // Sentinel

void init_QQmlPropertyValueSource(PyObject *module)
{
    _Sbk_QQmlPropertyValueSource_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQmlPropertyValueSource",
        "QQmlPropertyValueSource*",
        &Sbk_QQmlPropertyValueSource_spec,
        &Shiboken::callCppDestructor< ::QQmlPropertyValueSource >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQmlPropertyValueSource_Type);
    InitSignatureStrings(pyType, QQmlPropertyValueSource_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQmlPropertyValueSource_Type), Sbk_QQmlPropertyValueSource_PropertyStrings);
    SbkPySide2_QtQmlTypes[SBK_QQMLPROPERTYVALUESOURCE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQmlPropertyValueSource_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQmlPropertyValueSource_TypeF(),
        QQmlPropertyValueSource_PythonToCpp_QQmlPropertyValueSource_PTR,
        is_QQmlPropertyValueSource_PythonToCpp_QQmlPropertyValueSource_PTR_Convertible,
        QQmlPropertyValueSource_PTR_CppToPython_QQmlPropertyValueSource);

    Shiboken::Conversions::registerConverterName(converter, "QQmlPropertyValueSource");
    Shiboken::Conversions::registerConverterName(converter, "QQmlPropertyValueSource*");
    Shiboken::Conversions::registerConverterName(converter, "QQmlPropertyValueSource&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlPropertyValueSource).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQmlPropertyValueSourceWrapper).name());


}
