/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qquickitem_wrapper.h"

// inner classes
#include "qquickitem_updatepaintnodedata_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QQuickItemWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QQuickItemWrapper::QQuickItemWrapper(::QQuickItem * parent) : QQuickItem(parent)
{
    resetPyMethodCache();
    // ... middle
}

::QRectF QQuickItemWrapper::boundingRect() const
{
    if (m_PyMethodCache[0])
        return this->::QQuickItem::boundingRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "boundingRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QQuickItem::boundingRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.boundingRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QQuickItemWrapper::childMouseEventFilter(::QQuickItem * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[2])
        return this->::QQuickItem::childMouseEventFilter(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childMouseEventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QQuickItem::childMouseEventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.childMouseEventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::classBegin()
{
    if (m_PyMethodCache[3]) {
        return this->::QQuickItem::classBegin();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "classBegin";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QQuickItem::classBegin();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QRectF QQuickItemWrapper::clipRect() const
{
    if (m_PyMethodCache[4])
        return this->::QQuickItem::clipRect();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "clipRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QQuickItem::clipRect();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.clipRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRectF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRectF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::componentComplete()
{
    if (m_PyMethodCache[5]) {
        return this->::QQuickItem::componentComplete();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "componentComplete";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QQuickItem::componentComplete();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickItemWrapper::contains(const ::QPointF & point) const
{
    if (m_PyMethodCache[7])
        return this->::QQuickItem::contains(point);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contains";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QQuickItem::contains(point);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &point)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.contains", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickItemWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::dragEnterEvent(::QDragEnterEvent * arg__1)
{
    if (m_PyMethodCache[10]) {
        return this->::QQuickItem::dragEnterEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QQuickItem::dragEnterEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::dragLeaveEvent(::QDragLeaveEvent * arg__1)
{
    if (m_PyMethodCache[11]) {
        return this->::QQuickItem::dragLeaveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QQuickItem::dragLeaveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::dragMoveEvent(::QDragMoveEvent * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QQuickItem::dragMoveEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QQuickItem::dragMoveEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::dropEvent(::QDropEvent * arg__1)
{
    if (m_PyMethodCache[13]) {
        return this->::QQuickItem::dropEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QQuickItem::dropEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QQuickItemWrapper::event(::QEvent * arg__1)
{
    if (m_PyMethodCache[14])
        return this->::QQuickItem::event(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QQuickItem::event(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QQuickItemWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[15])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QQuickItemWrapper::focusInEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[16]) {
        return this->::QQuickItem::focusInEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QQuickItem::focusInEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::focusOutEvent(::QFocusEvent * arg__1)
{
    if (m_PyMethodCache[17]) {
        return this->::QQuickItem::focusOutEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QQuickItem::focusOutEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::geometryChanged(const ::QRectF & newGeometry, const ::QRectF & oldGeometry)
{
    if (m_PyMethodCache[18]) {
        return this->::QQuickItem::geometryChanged(newGeometry, oldGeometry);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "geometryChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QQuickItem::geometryChanged(newGeometry, oldGeometry);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &newGeometry),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &oldGeometry)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::hoverEnterEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QQuickItem::hoverEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QQuickItem::hoverEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::hoverLeaveEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[20]) {
        return this->::QQuickItem::hoverLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QQuickItem::hoverLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::hoverMoveEvent(::QHoverEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QQuickItem::hoverMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hoverMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QQuickItem::hoverMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::inputMethodEvent(::QInputMethodEvent * arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QQuickItem::inputMethodEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QQuickItem::inputMethodEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QVariant QQuickItemWrapper::inputMethodQuery(::Qt::InputMethodQuery query) const
{
    if (m_PyMethodCache[23])
        return this->::QQuickItem::inputMethodQuery(query);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QQuickItem::inputMethodQuery(query);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &query)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QQuickItemWrapper::isTextureProvider() const
{
    if (m_PyMethodCache[24])
        return this->::QQuickItem::isTextureProvider();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isTextureProvider";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QQuickItem::isTextureProvider();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.isTextureProvider", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::keyPressEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[25]) {
        return this->::QQuickItem::keyPressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QQuickItem::keyPressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QQuickItem::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QQuickItem::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QQuickItem::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QQuickItem::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QQuickItem::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QQuickItem::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QQuickItem::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QQuickItem::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[31]) {
        return this->::QQuickItem::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[31] = true;
        return this->::QQuickItem::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::mouseUngrabEvent()
{
    if (m_PyMethodCache[32]) {
        return this->::QQuickItem::mouseUngrabEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseUngrabEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QQuickItem::mouseUngrabEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::releaseResources()
{
    if (m_PyMethodCache[33]) {
        return this->::QQuickItem::releaseResources();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "releaseResources";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QQuickItem::releaseResources();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSGTextureProvider * QQuickItemWrapper::textureProvider() const
{
    if (m_PyMethodCache[34])
        return this->::QQuickItem::textureProvider();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "textureProvider";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QQuickItem::textureProvider();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTUREPROVIDER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.textureProvider", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGTextureProvider >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSGTextureProvider *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[35]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QQuickItemWrapper::touchEvent(::QTouchEvent * event)
{
    if (m_PyMethodCache[36]) {
        return this->::QQuickItem::touchEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QQuickItem::touchEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::touchUngrabEvent()
{
    if (m_PyMethodCache[37]) {
        return this->::QQuickItem::touchUngrabEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "touchUngrabEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QQuickItem::touchUngrabEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSGNode * QQuickItemWrapper::updatePaintNode(::QSGNode * arg__1, ::QQuickItem::UpdatePaintNodeData * arg__2)
{
    if (m_PyMethodCache[38])
        return this->::QQuickItem::updatePaintNode(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updatePaintNode";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QQuickItem::updatePaintNode(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]), arg__2)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QQuickItem.updatePaintNode", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGNode >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSGNode *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QQuickItemWrapper::updatePolish()
{
    if (m_PyMethodCache[39]) {
        return this->::QQuickItem::updatePolish();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updatePolish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QQuickItem::updatePolish();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[40]) {
        return this->::QQuickItem::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QQuickItem::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QQuickItemWrapper::windowDeactivateEvent()
{
    if (m_PyMethodCache[41]) {
        return this->::QQuickItem::windowDeactivateEvent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "windowDeactivateEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QQuickItem::windowDeactivateEvent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QQuickItemWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QQuickItem::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QQuickItemWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QQuickItem::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QQuickItemWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QQuickItemWrapper *>(this));
        return QQuickItem::qt_metacast(_clname);
}

QQuickItemWrapper::~QQuickItemWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QQuickItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QQuickItem >()))
        return -1;

    ::QQuickItemWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QQuickItem", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QQuickItem::QQuickItem(QQuickItem*)
    if (numArgs == 0) {
        overloadId = 0; // QQuickItem(QQuickItem*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QQuickItem(QQuickItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0]))))
                        goto Sbk_QQuickItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QQuickItem *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QQuickItem(QQuickItem*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QQuickItemWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QQuickItemWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QQuickItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QQuickItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QQuickItem_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QQuickItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QQuickItemFunc_acceptHoverEvents(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.acceptHoverEvents";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acceptHoverEvents()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->acceptHoverEvents();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_acceptTouchEvents(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.acceptTouchEvents";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acceptTouchEvents()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->acceptTouchEvents();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_acceptedMouseButtons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.acceptedMouseButtons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acceptedMouseButtons()const
            QFlags<Qt::MouseButton> cppResult = const_cast<const ::QQuickItem *>(cppSelf)->acceptedMouseButtons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_activeFocusOnTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.activeFocusOnTab";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeFocusOnTab()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->activeFocusOnTab();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_antialiasing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.antialiasing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // antialiasing()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->antialiasing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_baselineOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.baselineOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // baselineOffset()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->baselineOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_boundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.boundingRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // boundingRect()const
            QRectF cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::boundingRect()
                : const_cast<const ::QQuickItem *>(cppSelf)->boundingRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_childAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.childAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "childAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::childAt(qreal,qreal)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // childAt(qreal,qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_childAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // childAt(qreal,qreal)const
            QQuickItem * cppResult = const_cast<const ::QQuickItem *>(cppSelf)->childAt(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_childAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_childItems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.childItems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childItems()const
            QList<QQuickItem* > cppResult = const_cast<const ::QQuickItem *>(cppSelf)->childItems();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtQuickTypeConverters[SBK_QTQUICK_QLIST_QQUICKITEMPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_childMouseEventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.childMouseEventFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "childMouseEventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::childMouseEventFilter(QQuickItem*,QEvent*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // childMouseEventFilter(QQuickItem*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_childMouseEventFilter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // childMouseEventFilter(QQuickItem*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::childMouseEventFilter(cppArg0, cppArg1)
                : cppSelf->childMouseEventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_childMouseEventFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_childrenRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.childrenRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // childrenRect()
            QRectF cppResult = cppSelf->childrenRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_classBegin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.classBegin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // classBegin()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::classBegin()
                : cppSelf->classBegin();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_clip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.clip";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clip()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->clip();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_clipRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.clipRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipRect()const
            QRectF cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::clipRect()
                : const_cast<const ::QQuickItem *>(cppSelf)->clipRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_componentComplete(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.componentComplete";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // componentComplete()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::componentComplete()
                : cppSelf->componentComplete();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_containmentMask(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.containmentMask";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // containmentMask()const
            QObject * cppResult = const_cast<const ::QQuickItem *>(cppSelf)->containmentMask();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::contains(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // contains(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_contains_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // contains(QPointF)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::contains(*cppArg0)
                : const_cast<const ::QQuickItem *>(cppSelf)->contains(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_cursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.cursor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cursor()const
            QCursor cppResult = const_cast<const ::QQuickItem *>(cppSelf)->cursor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_dragEnterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.dragEnterEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::dragEnterEvent(QDragEnterEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragEnterEvent(QDragEnterEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_dragEnterEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragEnterEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragEnterEvent(QDragEnterEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::dragEnterEvent(cppArg0)
                : cppSelf->dragEnterEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_dragEnterEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_dragLeaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.dragLeaveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::dragLeaveEvent(QDragLeaveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragLeaveEvent(QDragLeaveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_dragLeaveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragLeaveEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragLeaveEvent(QDragLeaveEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::dragLeaveEvent(cppArg0)
                : cppSelf->dragLeaveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_dragLeaveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_dragMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.dragMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::dragMoveEvent(QDragMoveEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dragMoveEvent(QDragMoveEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_dragMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDragMoveEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dragMoveEvent(QDragMoveEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::dragMoveEvent(cppArg0)
                : cppSelf->dragMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_dragMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_dropEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.dropEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::dropEvent(QDropEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // dropEvent(QDropEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_dropEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDropEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dropEvent(QDropEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::dropEvent(cppArg0)
                : cppSelf->dropEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_dropEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_event(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.event";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::event(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // event(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_event_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // event(QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::event(cppArg0)
                : cppSelf->event(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_event_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_filtersChildMouseEvents(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.filtersChildMouseEvents";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filtersChildMouseEvents()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->filtersChildMouseEvents();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QQuickItem::Flag> cppResult = const_cast<const ::QQuickItem *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_focusInEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.focusInEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::focusInEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusInEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_focusInEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusInEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::focusInEvent(cppArg0)
                : cppSelf->focusInEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_focusInEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_focusOutEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.focusOutEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::focusOutEvent(QFocusEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // focusOutEvent(QFocusEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_focusOutEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFocusEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // focusOutEvent(QFocusEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::focusOutEvent(cppArg0)
                : cppSelf->focusOutEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_focusOutEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_forceActiveFocus(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.forceActiveFocus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "forceActiveFocus", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::forceActiveFocus()
    // 1: QQuickItem::forceActiveFocus(Qt::FocusReason)
    if (numArgs == 0) {
        overloadId = 0; // forceActiveFocus()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // forceActiveFocus(Qt::FocusReason)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_forceActiveFocus_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // forceActiveFocus()
        {

            if (!PyErr_Occurred()) {
                // forceActiveFocus()
                cppSelf->forceActiveFocus();
            }
            break;
        }
        case 1: // forceActiveFocus(Qt::FocusReason reason)
        {
            ::Qt::FocusReason cppArg0{Qt::MouseFocusReason};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // forceActiveFocus(Qt::FocusReason)
                cppSelf->forceActiveFocus(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_forceActiveFocus_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_geometryChanged(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.geometryChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "geometryChanged", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::geometryChanged(QRectF,QRectF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // geometryChanged(QRectF,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_geometryChanged_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // geometryChanged(QRectF,QRectF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::geometryChanged(*cppArg0, *cppArg1)
                : cppSelf->geometryChanged(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_geometryChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_grabMouse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.grabMouse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // grabMouse()
            cppSelf->grabMouse();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_grabToImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.grabToImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickItemFunc_grabToImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:grabToImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::grabToImage(QJSValue,QSize)
    // 1: QQuickItem::grabToImage(QSize)
    if (numArgs == 0) {
        overloadId = 1; // grabToImage(QSize)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // grabToImage(QSize)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // grabToImage(QJSValue,QSize)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // grabToImage(QJSValue,QSize)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_grabToImage_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // grabToImage(const QJSValue & callback, const QSize & targetSize)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_targetSize = Shiboken::String::createStaticString("targetSize");
                if (PyDict_Contains(kwds, key_targetSize)) {
                    value = PyDict_GetItem(kwds, key_targetSize);
                    if (value && pyArgs[1]) {
                        errInfo = key_targetSize;
                        Py_INCREF(errInfo);
                        goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1]))))
                            goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_targetSize);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QJSValue cppArg0_local;
            ::QJSValue *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QJSVALUE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QSize cppArg1_local = QSize();
            ::QSize *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // grabToImage(QJSValue,QSize)
                bool cppResult = cppSelf->grabToImage(*cppArg0, *cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // grabToImage(const QSize & targetSize)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_targetSize = Shiboken::String::createStaticString("targetSize");
                if (PyDict_Contains(kwds, key_targetSize)) {
                    value = PyDict_GetItem(kwds, key_targetSize);
                    if (value && pyArgs[0]) {
                        errInfo = key_targetSize;
                        Py_INCREF(errInfo);
                        goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0]))))
                            goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_targetSize);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QQuickItemFunc_grabToImage_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local = QSize();
            ::QSize *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

            if (!PyErr_Occurred()) {
                // grabToImage(QSize)
                QSharedPointer<QQuickItemGrabResult > cppResult = cppSelf->grabToImage(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSHAREDPOINTER_QQUICKITEMGRABRESULT_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_grabToImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_grabTouchPoints(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.grabTouchPoints";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::grabTouchPoints(QVector<int>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtQuickTypeConverters[SBK_QTQUICK_QVECTOR_INT_IDX], (pyArg)))) {
        overloadId = 0; // grabTouchPoints(QVector<int>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_grabTouchPoints_TypeError;

    // Call function/method
    {
        ::QVector<int > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // grabTouchPoints(QVector<int>)
            cppSelf->grabTouchPoints(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_grabTouchPoints_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_hasActiveFocus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.hasActiveFocus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasActiveFocus()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->hasActiveFocus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_hasFocus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.hasFocus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasFocus()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->hasFocus();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_heightValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.heightValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // heightValid()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->heightValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_hoverEnterEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.hoverEnterEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::hoverEnterEvent(QHoverEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // hoverEnterEvent(QHoverEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_hoverEnterEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHoverEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hoverEnterEvent(QHoverEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::hoverEnterEvent(cppArg0)
                : cppSelf->hoverEnterEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_hoverEnterEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_hoverLeaveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.hoverLeaveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::hoverLeaveEvent(QHoverEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // hoverLeaveEvent(QHoverEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_hoverLeaveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHoverEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hoverLeaveEvent(QHoverEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::hoverLeaveEvent(cppArg0)
                : cppSelf->hoverLeaveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_hoverLeaveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_hoverMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.hoverMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::hoverMoveEvent(QHoverEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHOVEREVENT_IDX]), (pyArg)))) {
        overloadId = 0; // hoverMoveEvent(QHoverEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_hoverMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHoverEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hoverMoveEvent(QHoverEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::hoverMoveEvent(cppArg0)
                : cppSelf->hoverMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_hoverMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_implicitHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.implicitHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // implicitHeight()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->implicitHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_implicitWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.implicitWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // implicitWidth()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->implicitWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_inputMethodEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.inputMethodEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::inputMethodEvent(QInputMethodEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // inputMethodEvent(QInputMethodEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_inputMethodEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QInputMethodEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodEvent(QInputMethodEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::inputMethodEvent(cppArg0)
                : cppSelf->inputMethodEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_inputMethodEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_inputMethodQuery(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.inputMethodQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::inputMethodQuery(Qt::InputMethodQuery)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // inputMethodQuery(Qt::InputMethodQuery)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_inputMethodQuery_TypeError;

    // Call function/method
    {
        ::Qt::InputMethodQuery cppArg0 = static_cast< ::Qt::InputMethodQuery>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // inputMethodQuery(Qt::InputMethodQuery)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::inputMethodQuery(cppArg0)
                : const_cast<const ::QQuickItem *>(cppSelf)->inputMethodQuery(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_inputMethodQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_isAncestorOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isAncestorOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::isAncestorOf(const QQuickItem*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // isAncestorOf(const QQuickItem*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_isAncestorOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isAncestorOf(const QQuickItem*)const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isAncestorOf(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_isAncestorOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_isComponentComplete(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isComponentComplete";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isComponentComplete()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isComponentComplete();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_isFocusScope(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isFocusScope";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFocusScope()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isFocusScope();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_isTextureProvider(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isTextureProvider";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTextureProvider()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::isTextureProvider()
                : const_cast<const ::QQuickItem *>(cppSelf)->isTextureProvider();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_isUnderMouse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isUnderMouse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUnderMouse()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isUnderMouse();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_isVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.isVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isVisible()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->isVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_itemTransform(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.itemTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::itemTransform(QQuickItem*,bool*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // itemTransform(QQuickItem*,bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_itemTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemTransform(QQuickItem*,bool*)const
            // Begin code injection
            // TEMPLATE - fix_args,bool* - START
            bool ok_;
            ::QTransform retval_ = cppSelf->itemTransform(cppArg0, &ok_);
            // TEMPLATE - tuple_retval_ok - START
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &ok_));
            // TEMPLATE - tuple_retval_ok - END
            // TEMPLATE - fix_args,bool* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_itemTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_keepMouseGrab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.keepMouseGrab";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keepMouseGrab()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->keepMouseGrab();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_keepTouchGrab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.keepTouchGrab";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keepTouchGrab()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->keepTouchGrab();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.keyPressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_keyPressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyPressEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::keyPressEvent(cppArg0)
                : cppSelf->keyPressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_keyPressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.keyReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_keyReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // keyReleaseEvent(QKeyEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::keyReleaseEvent(cppArg0)
                : cppSelf->keyReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_keyReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapFromGlobal(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapFromGlobal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapFromGlobal(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapFromGlobal(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapFromGlobal_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapFromGlobal(QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapFromGlobal(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapFromGlobal_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapFromItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapFromItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapFromItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::mapFromItem(const QQuickItem*,QPointF)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // mapFromItem(const QQuickItem*,QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapFromItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // mapFromItem(const QQuickItem*,QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapFromItem(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapFromItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapFromScene(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapFromScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapFromScene(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapFromScene(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapFromScene_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapFromScene(QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapFromScene(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapFromScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapRectFromItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapRectFromItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapRectFromItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::mapRectFromItem(const QQuickItem*,QRectF)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // mapRectFromItem(const QQuickItem*,QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapRectFromItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // mapRectFromItem(const QQuickItem*,QRectF)const
            QRectF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapRectFromItem(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapRectFromItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapRectFromScene(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapRectFromScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapRectFromScene(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapRectFromScene(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapRectFromScene_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapRectFromScene(QRectF)const
            QRectF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapRectFromScene(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapRectFromScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapRectToItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapRectToItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapRectToItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::mapRectToItem(const QQuickItem*,QRectF)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // mapRectToItem(const QQuickItem*,QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapRectToItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // mapRectToItem(const QQuickItem*,QRectF)const
            QRectF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapRectToItem(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapRectToItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapRectToScene(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapRectToScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapRectToScene(QRectF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapRectToScene(QRectF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapRectToScene_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapRectToScene(QRectF)const
            QRectF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapRectToScene(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapRectToScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapToGlobal(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapToGlobal";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapToGlobal(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapToGlobal(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapToGlobal_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapToGlobal(QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapToGlobal(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapToGlobal_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapToItem(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapToItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "mapToItem", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::mapToItem(const QQuickItem*,QPointF)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // mapToItem(const QQuickItem*,QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapToItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // mapToItem(const QQuickItem*,QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapToItem(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapToItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mapToScene(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mapToScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mapToScene(QPointF)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // mapToScene(QPointF)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mapToScene_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // mapToScene(QPointF)const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->mapToScene(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_mapToScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mouseDoubleClickEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mouseDoubleClickEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mouseDoubleClickEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseDoubleClickEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mouseDoubleClickEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseDoubleClickEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::mouseDoubleClickEvent(cppArg0)
                : cppSelf->mouseDoubleClickEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_mouseDoubleClickEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mouseMoveEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mouseMoveEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mouseMoveEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseMoveEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mouseMoveEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseMoveEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::mouseMoveEvent(cppArg0)
                : cppSelf->mouseMoveEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_mouseMoveEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mousePressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mousePressEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mousePressEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mousePressEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mousePressEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mousePressEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::mousePressEvent(cppArg0)
                : cppSelf->mousePressEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_mousePressEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mouseReleaseEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_mouseReleaseEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMouseEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // mouseReleaseEvent(QMouseEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::mouseReleaseEvent(cppArg0)
                : cppSelf->mouseReleaseEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_mouseReleaseEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_mouseUngrabEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.mouseUngrabEvent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mouseUngrabEvent()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::mouseUngrabEvent()
                : cppSelf->mouseUngrabEvent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_nextItemInFocusChain(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.nextItemInFocusChain";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:nextItemInFocusChain", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::nextItemInFocusChain(bool)
    if (numArgs == 0) {
        overloadId = 0; // nextItemInFocusChain(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // nextItemInFocusChain(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_forward = Shiboken::String::createStaticString("forward");
            if (PyDict_Contains(kwds, key_forward)) {
                value = PyDict_GetItem(kwds, key_forward);
                if (value && pyArgs[0]) {
                    errInfo = key_forward;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))
                        goto Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_forward);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError;
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // nextItemInFocusChain(bool)
            QQuickItem * cppResult = cppSelf->nextItemInFocusChain(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_nextItemInFocusChain_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_opacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.opacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // opacity()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->opacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_parentItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.parentItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentItem()const
            QQuickItem * cppResult = const_cast<const ::QQuickItem *>(cppSelf)->parentItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_polish(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.polish";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // polish()
            cppSelf->polish();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_position(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.position";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // position()const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->position();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_releaseResources(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.releaseResources";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // releaseResources()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::releaseResources()
                : cppSelf->releaseResources();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_resetAntialiasing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.resetAntialiasing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetAntialiasing()
            cppSelf->resetAntialiasing();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_resetHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.resetHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetHeight()
            cppSelf->resetHeight();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_resetWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.resetWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetWidth()
            cppSelf->resetWidth();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_rotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.rotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotation()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->rotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_scale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.scale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scale()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->scale();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_scopedFocusItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.scopedFocusItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scopedFocusItem()const
            QQuickItem * cppResult = const_cast<const ::QQuickItem *>(cppSelf)->scopedFocusItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_setAcceptHoverEvents(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setAcceptHoverEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setAcceptHoverEvents(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAcceptHoverEvents(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setAcceptHoverEvents_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAcceptHoverEvents(bool)
            cppSelf->setAcceptHoverEvents(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setAcceptHoverEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setAcceptTouchEvents(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setAcceptTouchEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setAcceptTouchEvents(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAcceptTouchEvents(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setAcceptTouchEvents_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAcceptTouchEvents(bool)
            cppSelf->setAcceptTouchEvents(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setAcceptTouchEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setAcceptedMouseButtons(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setAcceptedMouseButtons";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setAcceptedMouseButtons(QFlags<Qt::MouseButton>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAcceptedMouseButtons(QFlags<Qt::MouseButton>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setAcceptedMouseButtons_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::MouseButton> cppArg0 = QFlags<Qt::MouseButton>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAcceptedMouseButtons(QFlags<Qt::MouseButton>)
            cppSelf->setAcceptedMouseButtons(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setAcceptedMouseButtons_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setActiveFocusOnTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setActiveFocusOnTab";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setActiveFocusOnTab(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActiveFocusOnTab(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setActiveFocusOnTab_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setActiveFocusOnTab(bool)
            cppSelf->setActiveFocusOnTab(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setActiveFocusOnTab_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setAntialiasing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setAntialiasing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setAntialiasing(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAntialiasing(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setAntialiasing_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAntialiasing(bool)
            cppSelf->setAntialiasing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setAntialiasing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setBaselineOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setBaselineOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setBaselineOffset(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBaselineOffset(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setBaselineOffset_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBaselineOffset(qreal)
            cppSelf->setBaselineOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setBaselineOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setClip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setClip";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setClip(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setClip(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setClip_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClip(bool)
            cppSelf->setClip(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setClip_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setContainmentMask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setContainmentMask";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setContainmentMask(QObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setContainmentMask(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setContainmentMask_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContainmentMask(QObject*)
            cppSelf->setContainmentMask(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setContainmentMask_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setCursor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setCursor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setCursor(QCursor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), (pyArg)))) {
        overloadId = 0; // setCursor(QCursor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setCursor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCursor cppArg0_local;
        ::QCursor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCURSOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCursor(QCursor)
            cppSelf->setCursor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setCursor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setFiltersChildMouseEvents(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setFiltersChildMouseEvents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setFiltersChildMouseEvents(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFiltersChildMouseEvents(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setFiltersChildMouseEvents_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFiltersChildMouseEvents(bool)
            cppSelf->setFiltersChildMouseEvents(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setFiltersChildMouseEvents_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setFlag(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setFlag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickItemFunc_setFlag_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QQuickItemFunc_setFlag_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setFlag", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::setFlag(QQuickItem::Flag,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFlag(QQuickItem::Flag,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setFlag(QQuickItem::Flag,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setFlag_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_enabled = Shiboken::String::createStaticString("enabled");
            if (PyDict_Contains(kwds, key_enabled)) {
                value = PyDict_GetItem(kwds, key_enabled);
                if (value && pyArgs[1]) {
                    errInfo = key_enabled;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickItemFunc_setFlag_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QQuickItemFunc_setFlag_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_enabled);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickItemFunc_setFlag_TypeError;
            }
        }
        ::QQuickItem::Flag cppArg0 = static_cast< ::QQuickItem::Flag>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFlag(QQuickItem::Flag,bool)
            cppSelf->setFlag(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setFlag_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setFlags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setFlags(QFlags<QQuickItem::Flag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFlags(QFlags<QQuickItem::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setFlags_TypeError;

    // Call function/method
    {
        ::QFlags<QQuickItem::Flag> cppArg0 = QFlags<QQuickItem::Flag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFlags(QFlags<QQuickItem::Flag>)
            cppSelf->setFlags(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setFocus(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setFocus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFocus", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::setFocus(bool)
    // 1: QQuickItem::setFocus(bool,Qt::FocusReason)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setFocus(bool)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_FOCUSREASON_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // setFocus(bool,Qt::FocusReason)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setFocus_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFocus(bool arg__1)
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setFocus(bool)
                cppSelf->setFocus(cppArg0);
            }
            break;
        }
        case 1: // setFocus(bool focus, Qt::FocusReason reason)
        {
            bool cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::FocusReason cppArg1{Qt::MouseFocusReason};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFocus(bool,Qt::FocusReason)
                cppSelf->setFocus(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setFocus_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setHeight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHeight(qreal)
            cppSelf->setHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setImplicitHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setImplicitHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setImplicitHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setImplicitHeight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setImplicitHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setImplicitHeight(qreal)
            cppSelf->setImplicitHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setImplicitHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setImplicitSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setImplicitSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setImplicitSize", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::setImplicitSize(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // setImplicitSize(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setImplicitSize_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setImplicitSize(qreal,qreal)
            cppSelf->setImplicitSize(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setImplicitSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setImplicitWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setImplicitWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setImplicitWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setImplicitWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setImplicitWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setImplicitWidth(qreal)
            cppSelf->setImplicitWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setImplicitWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setKeepMouseGrab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setKeepMouseGrab";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setKeepMouseGrab(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeepMouseGrab(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setKeepMouseGrab_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeepMouseGrab(bool)
            cppSelf->setKeepMouseGrab(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setKeepMouseGrab_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setKeepTouchGrab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setKeepTouchGrab";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setKeepTouchGrab(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setKeepTouchGrab(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setKeepTouchGrab_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setKeepTouchGrab(bool)
            cppSelf->setKeepTouchGrab(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setKeepTouchGrab_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setOpacity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setOpacity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setOpacity(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setOpacity(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setOpacity_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpacity(qreal)
            cppSelf->setOpacity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setOpacity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setParentItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setParentItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setParentItem(QQuickItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // setParentItem(QQuickItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setParentItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setParentItem(QQuickItem*)
            cppSelf->setParentItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setParentItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setPosition(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setPosition(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setPosition(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setPosition_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPosition(QPointF)
            cppSelf->setPosition(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setRotation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setRotation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setRotation(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRotation(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setRotation_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRotation(qreal)
            cppSelf->setRotation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setRotation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setScale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setScale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setScale(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setScale(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setScale_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScale(qreal)
            cppSelf->setScale(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setScale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setSize(QSizeF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
        overloadId = 0; // setSize(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSizeF cppArg0_local;
        ::QSizeF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSize(QSizeF)
            cppSelf->setSize(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setSmooth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setSmooth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setSmooth(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSmooth(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setSmooth_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSmooth(bool)
            cppSelf->setSmooth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setSmooth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setState(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setState(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setState_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setState(QString)
            cppSelf->setState(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setTransformOrigin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setTransformOrigin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setTransformOrigin(QQuickItem::TransformOrigin)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTransformOrigin(QQuickItem::TransformOrigin)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setTransformOrigin_TypeError;

    // Call function/method
    {
        ::QQuickItem::TransformOrigin cppArg0{QQuickItem::TopLeft};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTransformOrigin(QQuickItem::TransformOrigin)
            cppSelf->setTransformOrigin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setTransformOrigin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setTransformOriginPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setTransformOriginPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setTransformOriginPoint(QPointF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArg)))) {
        overloadId = 0; // setTransformOriginPoint(QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setTransformOriginPoint_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTransformOriginPoint(QPointF)
            cppSelf->setTransformOriginPoint(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setTransformOriginPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(qreal)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setX(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setX";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setX(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setX(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setX_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setX(qreal)
            cppSelf->setX(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setX_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setY(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setY";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setY(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setY(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setY_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setY(qreal)
            cppSelf->setY(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setY_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_setZ(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.setZ";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::setZ(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setZ(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_setZ_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setZ(qreal)
            cppSelf->setZ(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_setZ_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSizeF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_smooth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.smooth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // smooth()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->smooth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_stackAfter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.stackAfter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::stackAfter(const QQuickItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // stackAfter(const QQuickItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_stackAfter_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // stackAfter(const QQuickItem*)
            cppSelf->stackAfter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_stackAfter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_stackBefore(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.stackBefore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::stackBefore(const QQuickItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]), (pyArg)))) {
        overloadId = 0; // stackBefore(const QQuickItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_stackBefore_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QQuickItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // stackBefore(const QQuickItem*)
            cppSelf->stackBefore(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_stackBefore_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QString cppResult = const_cast<const ::QQuickItem *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_textureProvider(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.textureProvider";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureProvider()const
            QSGTextureProvider * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QQuickItem *>(cppSelf)->::QQuickItem::textureProvider()
                : const_cast<const ::QQuickItem *>(cppSelf)->textureProvider();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTUREPROVIDER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_touchEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.touchEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::touchEvent(QTouchEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTOUCHEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // touchEvent(QTouchEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_touchEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTouchEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // touchEvent(QTouchEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::touchEvent(cppArg0)
                : cppSelf->touchEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_touchEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_touchUngrabEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.touchUngrabEvent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // touchUngrabEvent()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::touchUngrabEvent()
                : cppSelf->touchUngrabEvent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_transformOrigin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.transformOrigin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transformOrigin()const
            QQuickItem::TransformOrigin cppResult = const_cast<const ::QQuickItem *>(cppSelf)->transformOrigin();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_transformOriginPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.transformOriginPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transformOriginPoint()const
            QPointF cppResult = const_cast<const ::QQuickItem *>(cppSelf)->transformOriginPoint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_ungrabMouse(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.ungrabMouse";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ungrabMouse()
            cppSelf->ungrabMouse();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_ungrabTouchPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.ungrabTouchPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ungrabTouchPoints()
            cppSelf->ungrabTouchPoints();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_unsetCursor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.unsetCursor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unsetCursor()
            cppSelf->unsetCursor();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_update(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.update";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // update()
            cppSelf->update();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_updateInputMethod(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.updateInputMethod";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QQuickItemFunc_updateInputMethod_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:updateInputMethod", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::updateInputMethod(QFlags<Qt::InputMethodQuery>)
    if (numArgs == 0) {
        overloadId = 0; // updateInputMethod(QFlags<Qt::InputMethodQuery>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // updateInputMethod(QFlags<Qt::InputMethodQuery>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_updateInputMethod_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_queries = Shiboken::String::createStaticString("queries");
            if (PyDict_Contains(kwds, key_queries)) {
                value = PyDict_GetItem(kwds, key_queries);
                if (value && pyArgs[0]) {
                    errInfo = key_queries;
                    Py_INCREF(errInfo);
                    goto Sbk_QQuickItemFunc_updateInputMethod_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_INPUTMETHODQUERY_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QQuickItemFunc_updateInputMethod_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_queries);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QQuickItemFunc_updateInputMethod_TypeError;
            }
        }
        ::QFlags<Qt::InputMethodQuery> cppArg0 = Qt::ImQueryInput;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // updateInputMethod(QFlags<Qt::InputMethodQuery>)
            cppSelf->updateInputMethod(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_updateInputMethod_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_updatePaintNode(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.updatePaintNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updatePaintNode", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QQuickItem::updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_UPDATEPAINTNODEDATA_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_updatePaintNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QQuickItem::UpdatePaintNodeData *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)
            QSGNode * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::updatePaintNode(cppArg0, cppArg1)
                : cppSelf->updatePaintNode(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QQuickItemFunc_updatePaintNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_updatePolish(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.updatePolish";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updatePolish()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::updatePolish()
                : cppSelf->updatePolish();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_wheelEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.wheelEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QQuickItem::wheelEvent(QWheelEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // wheelEvent(QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QQuickItemFunc_wheelEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWheelEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // wheelEvent(QWheelEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::wheelEvent(cppArg0)
                : cppSelf->wheelEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QQuickItemFunc_wheelEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QQuickItemFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_widthValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.widthValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // widthValid()const
            bool cppResult = const_cast<const ::QQuickItem *>(cppSelf)->widthValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.window";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // window()const
            QQuickWindow * cppResult = const_cast<const ::QQuickItem *>(cppSelf)->window();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_windowDeactivateEvent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.windowDeactivateEvent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowDeactivateEvent()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QQuickItem::windowDeactivateEvent()
                : cppSelf->windowDeactivateEvent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QQuickItemFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QQuickItemFunc_z(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QQuickItem.z";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // z()const
            qreal cppResult = const_cast<const ::QQuickItem *>(cppSelf)->z();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QQuickItem_PropertyStrings[] = {
    "activeFocus:hasActiveFocus",
    "activeFocusOnTab::",
    "antialiasing::",
    "baselineOffset::",
    "childrenRect:",
    "clip::",
    "containmentMask::",
    "enabled:isEnabled:",
    "focus:hasFocus:",
    "height::",
    "implicitHeight::",
    "implicitWidth::",
    "opacity::",
    "parent:parentItem:setParentItem",
    "rotation::",
    "scale::",
    "smooth::",
    "state::",
    "transformOrigin::",
    "transformOriginPoint:",
    "visible:isVisible:",
    "width::",
    "x::",
    "y::",
    "z::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QQuickItem_methods[] = {
    {"acceptHoverEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_acceptHoverEvents), METH_NOARGS},
    {"acceptTouchEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_acceptTouchEvents), METH_NOARGS},
    {"acceptedMouseButtons", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_acceptedMouseButtons), METH_NOARGS},
    {"activeFocusOnTab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_activeFocusOnTab), METH_NOARGS},
    {"antialiasing", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_antialiasing), METH_NOARGS},
    {"baselineOffset", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_baselineOffset), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_boundingRect), METH_NOARGS},
    {"childAt", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_childAt), METH_VARARGS},
    {"childItems", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_childItems), METH_NOARGS},
    {"childMouseEventFilter", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_childMouseEventFilter), METH_VARARGS},
    {"childrenRect", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_childrenRect), METH_NOARGS},
    {"classBegin", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_classBegin), METH_NOARGS},
    {"clip", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_clip), METH_NOARGS},
    {"clipRect", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_clipRect), METH_NOARGS},
    {"componentComplete", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_componentComplete), METH_NOARGS},
    {"containmentMask", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_containmentMask), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_contains), METH_O},
    {"cursor", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_cursor), METH_NOARGS},
    {"dragEnterEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_dragEnterEvent), METH_O},
    {"dragLeaveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_dragLeaveEvent), METH_O},
    {"dragMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_dragMoveEvent), METH_O},
    {"dropEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_dropEvent), METH_O},
    {"event", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_event), METH_O},
    {"filtersChildMouseEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_filtersChildMouseEvents), METH_NOARGS},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_flags), METH_NOARGS},
    {"focusInEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_focusInEvent), METH_O},
    {"focusOutEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_focusOutEvent), METH_O},
    {"forceActiveFocus", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_forceActiveFocus), METH_VARARGS},
    {"geometryChanged", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_geometryChanged), METH_VARARGS},
    {"grabMouse", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_grabMouse), METH_NOARGS},
    {"grabToImage", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_grabToImage), METH_VARARGS|METH_KEYWORDS},
    {"grabTouchPoints", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_grabTouchPoints), METH_O},
    {"hasActiveFocus", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_hasActiveFocus), METH_NOARGS},
    {"hasFocus", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_hasFocus), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_height), METH_NOARGS},
    {"heightValid", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_heightValid), METH_NOARGS},
    {"hoverEnterEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_hoverEnterEvent), METH_O},
    {"hoverLeaveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_hoverLeaveEvent), METH_O},
    {"hoverMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_hoverMoveEvent), METH_O},
    {"implicitHeight", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_implicitHeight), METH_NOARGS},
    {"implicitWidth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_implicitWidth), METH_NOARGS},
    {"inputMethodEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_inputMethodEvent), METH_O},
    {"inputMethodQuery", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_inputMethodQuery), METH_O},
    {"isAncestorOf", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isAncestorOf), METH_O},
    {"isComponentComplete", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isComponentComplete), METH_NOARGS},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isEnabled), METH_NOARGS},
    {"isFocusScope", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isFocusScope), METH_NOARGS},
    {"isTextureProvider", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isTextureProvider), METH_NOARGS},
    {"isUnderMouse", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isUnderMouse), METH_NOARGS},
    {"isVisible", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_isVisible), METH_NOARGS},
    {"itemTransform", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_itemTransform), METH_O},
    {"keepMouseGrab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_keepMouseGrab), METH_NOARGS},
    {"keepTouchGrab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_keepTouchGrab), METH_NOARGS},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_keyPressEvent), METH_O},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_keyReleaseEvent), METH_O},
    {"mapFromGlobal", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapFromGlobal), METH_O},
    {"mapFromItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapFromItem), METH_VARARGS},
    {"mapFromScene", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapFromScene), METH_O},
    {"mapRectFromItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapRectFromItem), METH_VARARGS},
    {"mapRectFromScene", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapRectFromScene), METH_O},
    {"mapRectToItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapRectToItem), METH_VARARGS},
    {"mapRectToScene", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapRectToScene), METH_O},
    {"mapToGlobal", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapToGlobal), METH_O},
    {"mapToItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapToItem), METH_VARARGS},
    {"mapToScene", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mapToScene), METH_O},
    {"mouseDoubleClickEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mouseDoubleClickEvent), METH_O},
    {"mouseMoveEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mouseMoveEvent), METH_O},
    {"mousePressEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mousePressEvent), METH_O},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mouseReleaseEvent), METH_O},
    {"mouseUngrabEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_mouseUngrabEvent), METH_NOARGS},
    {"nextItemInFocusChain", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_nextItemInFocusChain), METH_VARARGS|METH_KEYWORDS},
    {"opacity", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_opacity), METH_NOARGS},
    {"parentItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_parentItem), METH_NOARGS},
    {"polish", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_polish), METH_NOARGS},
    {"position", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_position), METH_NOARGS},
    {"releaseResources", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_releaseResources), METH_NOARGS},
    {"resetAntialiasing", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_resetAntialiasing), METH_NOARGS},
    {"resetHeight", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_resetHeight), METH_NOARGS},
    {"resetWidth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_resetWidth), METH_NOARGS},
    {"rotation", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_rotation), METH_NOARGS},
    {"scale", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_scale), METH_NOARGS},
    {"scopedFocusItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_scopedFocusItem), METH_NOARGS},
    {"setAcceptHoverEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setAcceptHoverEvents), METH_O},
    {"setAcceptTouchEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setAcceptTouchEvents), METH_O},
    {"setAcceptedMouseButtons", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setAcceptedMouseButtons), METH_O},
    {"setActiveFocusOnTab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setActiveFocusOnTab), METH_O},
    {"setAntialiasing", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setAntialiasing), METH_O},
    {"setBaselineOffset", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setBaselineOffset), METH_O},
    {"setClip", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setClip), METH_O},
    {"setContainmentMask", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setContainmentMask), METH_O},
    {"setCursor", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setCursor), METH_O},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setEnabled), METH_O},
    {"setFiltersChildMouseEvents", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setFiltersChildMouseEvents), METH_O},
    {"setFlag", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setFlag), METH_VARARGS|METH_KEYWORDS},
    {"setFlags", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setFlags), METH_O},
    {"setFocus", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setFocus), METH_VARARGS},
    {"setHeight", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setHeight), METH_O},
    {"setImplicitHeight", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setImplicitHeight), METH_O},
    {"setImplicitSize", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setImplicitSize), METH_VARARGS},
    {"setImplicitWidth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setImplicitWidth), METH_O},
    {"setKeepMouseGrab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setKeepMouseGrab), METH_O},
    {"setKeepTouchGrab", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setKeepTouchGrab), METH_O},
    {"setOpacity", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setOpacity), METH_O},
    {"setParentItem", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setParentItem), METH_O},
    {"setPosition", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setPosition), METH_O},
    {"setRotation", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setRotation), METH_O},
    {"setScale", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setScale), METH_O},
    {"setSize", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setSize), METH_O},
    {"setSmooth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setSmooth), METH_O},
    {"setState", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setState), METH_O},
    {"setTransformOrigin", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setTransformOrigin), METH_O},
    {"setTransformOriginPoint", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setTransformOriginPoint), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setVisible), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setWidth), METH_O},
    {"setX", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setX), METH_O},
    {"setY", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setY), METH_O},
    {"setZ", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_setZ), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_size), METH_NOARGS},
    {"smooth", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_smooth), METH_NOARGS},
    {"stackAfter", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_stackAfter), METH_O},
    {"stackBefore", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_stackBefore), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_state), METH_NOARGS},
    {"textureProvider", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_textureProvider), METH_NOARGS},
    {"touchEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_touchEvent), METH_O},
    {"touchUngrabEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_touchUngrabEvent), METH_NOARGS},
    {"transformOrigin", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_transformOrigin), METH_NOARGS},
    {"transformOriginPoint", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_transformOriginPoint), METH_NOARGS},
    {"ungrabMouse", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_ungrabMouse), METH_NOARGS},
    {"ungrabTouchPoints", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_ungrabTouchPoints), METH_NOARGS},
    {"unsetCursor", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_unsetCursor), METH_NOARGS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_update), METH_NOARGS},
    {"updateInputMethod", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_updateInputMethod), METH_VARARGS|METH_KEYWORDS},
    {"updatePaintNode", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_updatePaintNode), METH_VARARGS},
    {"updatePolish", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_updatePolish), METH_NOARGS},
    {"wheelEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_wheelEvent), METH_O},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_width), METH_NOARGS},
    {"widthValid", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_widthValid), METH_NOARGS},
    {"window", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_window), METH_NOARGS},
    {"windowDeactivateEvent", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_windowDeactivateEvent), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_x), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_y), METH_NOARGS},
    {"z", reinterpret_cast<PyCFunction>(Sbk_QQuickItemFunc_z), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QQuickItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QQuickItemWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QQuickItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QQuickItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QQuickItem__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QQuickItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QQuickItem_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QQuickItem *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QQuickItem *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QQmlParserStatus *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QQmlParserStatus *>(static_cast<const QQuickItem *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QQuickItemSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QQuickItem *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQmlTypes[SBK_QQMLPARSERSTATUS_IDX]))
        return static_cast< ::QQmlParserStatus *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QQuickItem_Type = nullptr;
static SbkObjectType *Sbk_QQuickItem_TypeF(void)
{
    return _Sbk_QQuickItem_Type;
}

static PyType_Slot Sbk_QQuickItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QQuickItem__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QQuickItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QQuickItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QQuickItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QQuickItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QQuickItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QQuickItem_spec = {
    "2:PySide2.QtQuick.QQuickItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QQuickItem_slots
};

} //extern "C"

static void *Sbk_QQuickItem_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QQuickItem *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QQmlParserStatus >()))
        return dynamic_cast< ::QQuickItem *>(reinterpret_cast< ::QQmlParserStatus *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QQuickItem_Flag___and__(PyObject *self, PyObject *pyArg)
{
    ::QQuickItem::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickItem_Flag___or__(PyObject *self, PyObject *pyArg)
{
    ::QQuickItem::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickItem_Flag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QQuickItem::Flags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QQuickItem::Flags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QQuickItem::Flags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QQuickItem_Flag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QQuickItem::Flags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, self, &cppSelf);
    ::QQuickItem::Flags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QQuickItem_Flag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QQuickItem_Flag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QQuickItem_Flag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QQuickItem_Flag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QQuickItem_Flag_PythonToCpp_QQuickItem_Flag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickItem::Flag *>(cppOut) =
        static_cast<::QQuickItem::Flag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickItem_Flag_PythonToCpp_QQuickItem_Flag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX]))
        return QQuickItem_Flag_PythonToCpp_QQuickItem_Flag;
    return {};
}
static PyObject *QQuickItem_Flag_CppToPython_QQuickItem_Flag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickItem::Flag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX], castCppIn);

}

static void QFlags_QQuickItem_Flag__PythonToCpp_QFlags_QQuickItem_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickItem::Flag> *>(cppOut) =
        ::QFlags<QQuickItem::Flag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QQuickItem_Flag__PythonToCpp_QFlags_QQuickItem_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX]))
        return QFlags_QQuickItem_Flag__PythonToCpp_QFlags_QQuickItem_Flag_;
    return {};
}
static PyObject *QFlags_QQuickItem_Flag__CppToPython_QFlags_QQuickItem_Flag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QQuickItem::Flag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX]));

}

static void QQuickItem_Flag_PythonToCpp_QFlags_QQuickItem_Flag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QQuickItem::Flag> *>(cppOut) =
        ::QFlags<QQuickItem::Flag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QQuickItem_Flag_PythonToCpp_QFlags_QQuickItem_Flag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX]))
        return QQuickItem_Flag_PythonToCpp_QFlags_QQuickItem_Flag_;
    return {};
}
static void number_PythonToCpp_QFlags_QQuickItem_Flag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QQuickItem::Flag> *>(cppOut) =
        ::QFlags<QQuickItem::Flag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QQuickItem_Flag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX]))
        return number_PythonToCpp_QFlags_QQuickItem_Flag_;
    return {};
}
static void QQuickItem_ItemChange_PythonToCpp_QQuickItem_ItemChange(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickItem::ItemChange *>(cppOut) =
        static_cast<::QQuickItem::ItemChange>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickItem_ItemChange_PythonToCpp_QQuickItem_ItemChange_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX]))
        return QQuickItem_ItemChange_PythonToCpp_QQuickItem_ItemChange;
    return {};
}
static PyObject *QQuickItem_ItemChange_CppToPython_QQuickItem_ItemChange(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickItem::ItemChange *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX], castCppIn);

}

static void QQuickItem_TransformOrigin_PythonToCpp_QQuickItem_TransformOrigin(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QQuickItem::TransformOrigin *>(cppOut) =
        static_cast<::QQuickItem::TransformOrigin>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QQuickItem_TransformOrigin_PythonToCpp_QQuickItem_TransformOrigin_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX]))
        return QQuickItem_TransformOrigin_PythonToCpp_QQuickItem_TransformOrigin;
    return {};
}
static PyObject *QQuickItem_TransformOrigin_CppToPython_QQuickItem_TransformOrigin(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QQuickItem::TransformOrigin *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QQuickItem_PythonToCpp_QQuickItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QQuickItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QQuickItem_PythonToCpp_QQuickItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QQuickItem_TypeF())))
        return QQuickItem_PythonToCpp_QQuickItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QQuickItem_PTR_CppToPython_QQuickItem(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QQuickItem *>(const_cast<void *>(cppIn)), Sbk_QQuickItem_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QQuickItem_SignatureStrings[] = {
    "PySide2.QtQuick.QQuickItem(self,parent:PySide2.QtQuick.QQuickItem=nullptr)",
    "PySide2.QtQuick.QQuickItem.acceptHoverEvents(self)->bool",
    "PySide2.QtQuick.QQuickItem.acceptTouchEvents(self)->bool",
    "PySide2.QtQuick.QQuickItem.acceptedMouseButtons(self)->PySide2.QtCore.Qt.MouseButtons",
    "PySide2.QtQuick.QQuickItem.activeFocusOnTab(self)->bool",
    "PySide2.QtQuick.QQuickItem.antialiasing(self)->bool",
    "PySide2.QtQuick.QQuickItem.baselineOffset(self)->qreal",
    "PySide2.QtQuick.QQuickItem.boundingRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.childAt(self,x:qreal,y:qreal)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickItem.childItems(self)->QList[PySide2.QtQuick.QQuickItem]",
    "PySide2.QtQuick.QQuickItem.childMouseEventFilter(self,arg__1:PySide2.QtQuick.QQuickItem,arg__2:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtQuick.QQuickItem.childrenRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.classBegin(self)",
    "PySide2.QtQuick.QQuickItem.clip(self)->bool",
    "PySide2.QtQuick.QQuickItem.clipRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.componentComplete(self)",
    "PySide2.QtQuick.QQuickItem.containmentMask(self)->PySide2.QtCore.QObject",
    "PySide2.QtQuick.QQuickItem.contains(self,point:PySide2.QtCore.QPointF)->bool",
    "PySide2.QtQuick.QQuickItem.cursor(self)->PySide2.QtGui.QCursor",
    "PySide2.QtQuick.QQuickItem.dragEnterEvent(self,arg__1:PySide2.QtGui.QDragEnterEvent)",
    "PySide2.QtQuick.QQuickItem.dragLeaveEvent(self,arg__1:PySide2.QtGui.QDragLeaveEvent)",
    "PySide2.QtQuick.QQuickItem.dragMoveEvent(self,arg__1:PySide2.QtGui.QDragMoveEvent)",
    "PySide2.QtQuick.QQuickItem.dropEvent(self,arg__1:PySide2.QtGui.QDropEvent)",
    "PySide2.QtQuick.QQuickItem.event(self,arg__1:PySide2.QtCore.QEvent)->bool",
    "PySide2.QtQuick.QQuickItem.filtersChildMouseEvents(self)->bool",
    "PySide2.QtQuick.QQuickItem.flags(self)->PySide2.QtQuick.QQuickItem.Flags",
    "PySide2.QtQuick.QQuickItem.focusInEvent(self,arg__1:PySide2.QtGui.QFocusEvent)",
    "PySide2.QtQuick.QQuickItem.focusOutEvent(self,arg__1:PySide2.QtGui.QFocusEvent)",
    "1:PySide2.QtQuick.QQuickItem.forceActiveFocus(self)",
    "0:PySide2.QtQuick.QQuickItem.forceActiveFocus(self,reason:PySide2.QtCore.Qt.FocusReason)",
    "PySide2.QtQuick.QQuickItem.geometryChanged(self,newGeometry:PySide2.QtCore.QRectF,oldGeometry:PySide2.QtCore.QRectF)",
    "PySide2.QtQuick.QQuickItem.grabMouse(self)",
    "1:PySide2.QtQuick.QQuickItem.grabToImage(self,callback:PySide2.QtQml.QJSValue,targetSize:PySide2.QtCore.QSize=QSize())->bool",
    "0:PySide2.QtQuick.QQuickItem.grabToImage(self,targetSize:PySide2.QtCore.QSize=QSize())->QSharedPointer[PySide2.QtQuick.QQuickItemGrabResult]",
    "PySide2.QtQuick.QQuickItem.grabTouchPoints(self,ids:QVector[int])",
    "PySide2.QtQuick.QQuickItem.hasActiveFocus(self)->bool",
    "PySide2.QtQuick.QQuickItem.hasFocus(self)->bool",
    "PySide2.QtQuick.QQuickItem.height(self)->qreal",
    "PySide2.QtQuick.QQuickItem.heightValid(self)->bool",
    "PySide2.QtQuick.QQuickItem.hoverEnterEvent(self,event:PySide2.QtGui.QHoverEvent)",
    "PySide2.QtQuick.QQuickItem.hoverLeaveEvent(self,event:PySide2.QtGui.QHoverEvent)",
    "PySide2.QtQuick.QQuickItem.hoverMoveEvent(self,event:PySide2.QtGui.QHoverEvent)",
    "PySide2.QtQuick.QQuickItem.implicitHeight(self)->qreal",
    "PySide2.QtQuick.QQuickItem.implicitWidth(self)->qreal",
    "PySide2.QtQuick.QQuickItem.inputMethodEvent(self,arg__1:PySide2.QtGui.QInputMethodEvent)",
    "PySide2.QtQuick.QQuickItem.inputMethodQuery(self,query:PySide2.QtCore.Qt.InputMethodQuery)->QVariant",
    "PySide2.QtQuick.QQuickItem.isAncestorOf(self,child:PySide2.QtQuick.QQuickItem)->bool",
    "PySide2.QtQuick.QQuickItem.isComponentComplete(self)->bool",
    "PySide2.QtQuick.QQuickItem.isEnabled(self)->bool",
    "PySide2.QtQuick.QQuickItem.isFocusScope(self)->bool",
    "PySide2.QtQuick.QQuickItem.isTextureProvider(self)->bool",
    "PySide2.QtQuick.QQuickItem.isUnderMouse(self)->bool",
    "PySide2.QtQuick.QQuickItem.isVisible(self)->bool",
    "PySide2.QtQuick.QQuickItem.itemTransform(self,arg__1:PySide2.QtQuick.QQuickItem,arg__2:bool*)->PySide2.QtGui.QTransform",
    "PySide2.QtQuick.QQuickItem.keepMouseGrab(self)->bool",
    "PySide2.QtQuick.QQuickItem.keepTouchGrab(self)->bool",
    "PySide2.QtQuick.QQuickItem.keyPressEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtQuick.QQuickItem.keyReleaseEvent(self,event:PySide2.QtGui.QKeyEvent)",
    "PySide2.QtQuick.QQuickItem.mapFromGlobal(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mapFromItem(self,item:PySide2.QtQuick.QQuickItem,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mapFromScene(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mapRectFromItem(self,item:PySide2.QtQuick.QQuickItem,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.mapRectFromScene(self,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.mapRectToItem(self,item:PySide2.QtQuick.QQuickItem,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.mapRectToScene(self,rect:PySide2.QtCore.QRectF)->PySide2.QtCore.QRectF",
    "PySide2.QtQuick.QQuickItem.mapToGlobal(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mapToItem(self,item:PySide2.QtQuick.QQuickItem,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mapToScene(self,point:PySide2.QtCore.QPointF)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.mouseDoubleClickEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickItem.mouseMoveEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickItem.mousePressEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickItem.mouseReleaseEvent(self,event:PySide2.QtGui.QMouseEvent)",
    "PySide2.QtQuick.QQuickItem.mouseUngrabEvent(self)",
    "PySide2.QtQuick.QQuickItem.nextItemInFocusChain(self,forward:bool=true)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickItem.opacity(self)->qreal",
    "PySide2.QtQuick.QQuickItem.parentItem(self)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickItem.polish(self)",
    "PySide2.QtQuick.QQuickItem.position(self)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.releaseResources(self)",
    "PySide2.QtQuick.QQuickItem.resetAntialiasing(self)",
    "PySide2.QtQuick.QQuickItem.resetHeight(self)",
    "PySide2.QtQuick.QQuickItem.resetWidth(self)",
    "PySide2.QtQuick.QQuickItem.rotation(self)->qreal",
    "PySide2.QtQuick.QQuickItem.scale(self)->qreal",
    "PySide2.QtQuick.QQuickItem.scopedFocusItem(self)->PySide2.QtQuick.QQuickItem",
    "PySide2.QtQuick.QQuickItem.setAcceptHoverEvents(self,enabled:bool)",
    "PySide2.QtQuick.QQuickItem.setAcceptTouchEvents(self,accept:bool)",
    "PySide2.QtQuick.QQuickItem.setAcceptedMouseButtons(self,buttons:PySide2.QtCore.Qt.MouseButtons)",
    "PySide2.QtQuick.QQuickItem.setActiveFocusOnTab(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setAntialiasing(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setBaselineOffset(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setClip(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setContainmentMask(self,mask:PySide2.QtCore.QObject)",
    "PySide2.QtQuick.QQuickItem.setCursor(self,cursor:PySide2.QtGui.QCursor)",
    "PySide2.QtQuick.QQuickItem.setEnabled(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setFiltersChildMouseEvents(self,filter:bool)",
    "PySide2.QtQuick.QQuickItem.setFlag(self,flag:PySide2.QtQuick.QQuickItem.Flag,enabled:bool=true)",
    "PySide2.QtQuick.QQuickItem.setFlags(self,flags:PySide2.QtQuick.QQuickItem.Flags)",
    "1:PySide2.QtQuick.QQuickItem.setFocus(self,arg__1:bool)",
    "0:PySide2.QtQuick.QQuickItem.setFocus(self,focus:bool,reason:PySide2.QtCore.Qt.FocusReason)",
    "PySide2.QtQuick.QQuickItem.setHeight(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setImplicitHeight(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setImplicitSize(self,arg__1:qreal,arg__2:qreal)",
    "PySide2.QtQuick.QQuickItem.setImplicitWidth(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setKeepMouseGrab(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setKeepTouchGrab(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setOpacity(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setParentItem(self,parent:PySide2.QtQuick.QQuickItem)",
    "PySide2.QtQuick.QQuickItem.setPosition(self,arg__1:PySide2.QtCore.QPointF)",
    "PySide2.QtQuick.QQuickItem.setRotation(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setScale(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setSize(self,size:PySide2.QtCore.QSizeF)",
    "PySide2.QtQuick.QQuickItem.setSmooth(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setState(self,arg__1:QString)",
    "PySide2.QtQuick.QQuickItem.setTransformOrigin(self,arg__1:PySide2.QtQuick.QQuickItem.TransformOrigin)",
    "PySide2.QtQuick.QQuickItem.setTransformOriginPoint(self,arg__1:PySide2.QtCore.QPointF)",
    "PySide2.QtQuick.QQuickItem.setVisible(self,arg__1:bool)",
    "PySide2.QtQuick.QQuickItem.setWidth(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setX(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setY(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.setZ(self,arg__1:qreal)",
    "PySide2.QtQuick.QQuickItem.size(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtQuick.QQuickItem.smooth(self)->bool",
    "PySide2.QtQuick.QQuickItem.stackAfter(self,arg__1:PySide2.QtQuick.QQuickItem)",
    "PySide2.QtQuick.QQuickItem.stackBefore(self,arg__1:PySide2.QtQuick.QQuickItem)",
    "PySide2.QtQuick.QQuickItem.state(self)->QString",
    "PySide2.QtQuick.QQuickItem.textureProvider(self)->PySide2.QtQuick.QSGTextureProvider",
    "PySide2.QtQuick.QQuickItem.touchEvent(self,event:PySide2.QtGui.QTouchEvent)",
    "PySide2.QtQuick.QQuickItem.touchUngrabEvent(self)",
    "PySide2.QtQuick.QQuickItem.transformOrigin(self)->PySide2.QtQuick.QQuickItem.TransformOrigin",
    "PySide2.QtQuick.QQuickItem.transformOriginPoint(self)->PySide2.QtCore.QPointF",
    "PySide2.QtQuick.QQuickItem.ungrabMouse(self)",
    "PySide2.QtQuick.QQuickItem.ungrabTouchPoints(self)",
    "PySide2.QtQuick.QQuickItem.unsetCursor(self)",
    "PySide2.QtQuick.QQuickItem.update(self)",
    "PySide2.QtQuick.QQuickItem.updateInputMethod(self,queries:PySide2.QtCore.Qt.InputMethodQueries=Qt.ImQueryInput)",
    "PySide2.QtQuick.QQuickItem.updatePaintNode(self,arg__1:PySide2.QtQuick.QSGNode,arg__2:PySide2.QtQuick.QQuickItem.UpdatePaintNodeData)->PySide2.QtQuick.QSGNode",
    "PySide2.QtQuick.QQuickItem.updatePolish(self)",
    "PySide2.QtQuick.QQuickItem.wheelEvent(self,event:PySide2.QtGui.QWheelEvent)",
    "PySide2.QtQuick.QQuickItem.width(self)->qreal",
    "PySide2.QtQuick.QQuickItem.widthValid(self)->bool",
    "PySide2.QtQuick.QQuickItem.window(self)->PySide2.QtQuick.QQuickWindow",
    "PySide2.QtQuick.QQuickItem.windowDeactivateEvent(self)",
    "PySide2.QtQuick.QQuickItem.x(self)->qreal",
    "PySide2.QtQuick.QQuickItem.y(self)->qreal",
    "PySide2.QtQuick.QQuickItem.z(self)->qreal",
    nullptr}; // Sentinel

void init_QQuickItem(PyObject *module)
{
    PyObject *Sbk_QQuickItem_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtQmlTypes[SBK_QQMLPARSERSTATUS_IDX]));

    _Sbk_QQuickItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QQuickItem",
        "QQuickItem*",
        &Sbk_QQuickItem_spec,
        &Shiboken::callCppDestructor< ::QQuickItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QQuickItem_Type_bases,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QQuickItem_Type);
    InitSignatureStrings(pyType, QQuickItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QQuickItem_Type), Sbk_QQuickItem_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QQuickItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QQuickItem_TypeF(),
        QQuickItem_PythonToCpp_QQuickItem_PTR,
        is_QQuickItem_PythonToCpp_QQuickItem_PTR_Convertible,
        QQuickItem_PTR_CppToPython_QQuickItem);

    Shiboken::Conversions::registerConverterName(converter, "QQuickItem");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItem*");
    Shiboken::Conversions::registerConverterName(converter, "QQuickItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QQuickItemWrapper).name());


    MultipleInheritanceInitFunction func = Sbk_QQuickItem_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QQuickItem_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QQuickItem_TypeF(), &Sbk_QQuickItemSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QQuickItem_TypeF(), &Sbk_QQuickItem_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Flag'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QQuickItem.Flags", SbkPySide2_QtQuick_QQuickItem_Flag_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickItem_TypeF(),
        "Flag",
        "2:PySide2.QtQuick.QQuickItem.Flag",
        "QQuickItem::Flag",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
        Sbk_QQuickItem_TypeF(), "ItemClipsChildrenToShape", (long) QQuickItem::Flag::ItemClipsChildrenToShape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
        Sbk_QQuickItem_TypeF(), "ItemAcceptsInputMethod", (long) QQuickItem::Flag::ItemAcceptsInputMethod))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
        Sbk_QQuickItem_TypeF(), "ItemIsFocusScope", (long) QQuickItem::Flag::ItemIsFocusScope))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
        Sbk_QQuickItem_TypeF(), "ItemHasContents", (long) QQuickItem::Flag::ItemHasContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
        Sbk_QQuickItem_TypeF(), "ItemAcceptsDrops", (long) QQuickItem::Flag::ItemAcceptsDrops))
        return;
    // Register converter for enum 'QQuickItem::Flag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX],
            QQuickItem_Flag_CppToPython_QQuickItem_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickItem_Flag_PythonToCpp_QQuickItem_Flag,
            is_QQuickItem_Flag_PythonToCpp_QQuickItem_Flag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickItem::Flag");
        Shiboken::Conversions::registerConverterName(converter, "Flag");
    }
    // Register converter for flag 'QFlags<QQuickItem::Flag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX],
            QFlags_QQuickItem_Flag__CppToPython_QFlags_QQuickItem_Flag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickItem_Flag_PythonToCpp_QFlags_QQuickItem_Flag_,
            is_QQuickItem_Flag_PythonToCpp_QFlags_QQuickItem_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QQuickItem_Flag__PythonToCpp_QFlags_QQuickItem_Flag_,
            is_QFlags_QQuickItem_Flag__PythonToCpp_QFlags_QQuickItem_Flag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QQuickItem_Flag_,
            is_number_PythonToCpp_QFlags_QQuickItem_Flag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QQUICKITEM_FLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickItem::Flags");
        Shiboken::Conversions::registerConverterName(converter, "Flags");
    }
    // End of 'Flag' enum/flags.

    // Initialization of enum 'ItemChange'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickItem_TypeF(),
        "ItemChange",
        "2:PySide2.QtQuick.QQuickItem.ItemChange",
        "QQuickItem::ItemChange");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemChildAddedChange", (long) QQuickItem::ItemChange::ItemChildAddedChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemChildRemovedChange", (long) QQuickItem::ItemChange::ItemChildRemovedChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemSceneChange", (long) QQuickItem::ItemChange::ItemSceneChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemVisibleHasChanged", (long) QQuickItem::ItemChange::ItemVisibleHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemParentHasChanged", (long) QQuickItem::ItemChange::ItemParentHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemOpacityHasChanged", (long) QQuickItem::ItemChange::ItemOpacityHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemActiveFocusHasChanged", (long) QQuickItem::ItemChange::ItemActiveFocusHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemRotationHasChanged", (long) QQuickItem::ItemChange::ItemRotationHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemAntialiasingHasChanged", (long) QQuickItem::ItemChange::ItemAntialiasingHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemDevicePixelRatioHasChanged", (long) QQuickItem::ItemChange::ItemDevicePixelRatioHasChanged))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
        Sbk_QQuickItem_TypeF(), "ItemEnabledHasChanged", (long) QQuickItem::ItemChange::ItemEnabledHasChanged))
        return;
    // Register converter for enum 'QQuickItem::ItemChange'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX],
            QQuickItem_ItemChange_CppToPython_QQuickItem_ItemChange);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickItem_ItemChange_PythonToCpp_QQuickItem_ItemChange,
            is_QQuickItem_ItemChange_PythonToCpp_QQuickItem_ItemChange_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_ITEMCHANGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickItem::ItemChange");
        Shiboken::Conversions::registerConverterName(converter, "ItemChange");
    }
    // End of 'ItemChange' enum.

    // Initialization of enum 'TransformOrigin'.
    SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QQuickItem_TypeF(),
        "TransformOrigin",
        "2:PySide2.QtQuick.QQuickItem.TransformOrigin",
        "QQuickItem::TransformOrigin");
    if (!SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "TopLeft", (long) QQuickItem::TransformOrigin::TopLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "Top", (long) QQuickItem::TransformOrigin::Top))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "TopRight", (long) QQuickItem::TransformOrigin::TopRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "Left", (long) QQuickItem::TransformOrigin::Left))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "Center", (long) QQuickItem::TransformOrigin::Center))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "Right", (long) QQuickItem::TransformOrigin::Right))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "BottomLeft", (long) QQuickItem::TransformOrigin::BottomLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "Bottom", (long) QQuickItem::TransformOrigin::Bottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
        Sbk_QQuickItem_TypeF(), "BottomRight", (long) QQuickItem::TransformOrigin::BottomRight))
        return;
    // Register converter for enum 'QQuickItem::TransformOrigin'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX],
            QQuickItem_TransformOrigin_CppToPython_QQuickItem_TransformOrigin);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QQuickItem_TransformOrigin_PythonToCpp_QQuickItem_TransformOrigin,
            is_QQuickItem_TransformOrigin_PythonToCpp_QQuickItem_TransformOrigin_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QQUICKITEM_TRANSFORMORIGIN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QQuickItem::TransformOrigin");
        Shiboken::Conversions::registerConverterName(converter, "TransformOrigin");
    }
    // End of 'TransformOrigin' enum.

    PySide::Signal::registerSignals(Sbk_QQuickItem_TypeF(), &::QQuickItem::staticMetaObject);
    qRegisterMetaType< ::QQuickItem::Flag >("QQuickItem::Flag");
    qRegisterMetaType< ::QQuickItem::Flags >("QQuickItem::Flags");
    qRegisterMetaType< ::QQuickItem::ItemChange >("QQuickItem::ItemChange");
    qRegisterMetaType< ::QQuickItem::TransformOrigin >("QQuickItem::TransformOrigin");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QQuickItem_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QQuickItem_TypeF(), &::QQuickItem::staticMetaObject, sizeof(QQuickItemWrapper));
}
