/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgabstractrenderer_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGAbstractRendererWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGAbstractRendererWrapper::QSGAbstractRendererWrapper(::QObject * parent) : QSGAbstractRenderer(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSGAbstractRendererWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGAbstractRendererWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGAbstractRendererWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGAbstractRendererWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSGAbstractRendererWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGAbstractRenderer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSGAbstractRendererWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGAbstractRenderer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSGAbstractRendererWrapper::nodeChanged(::QSGNode * node, ::QFlags<QSGNode::DirtyStateBit> state)
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.nodeChanged()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nodeChanged";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.nodeChanged()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), node),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, &state)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGAbstractRendererWrapper::renderScene(uint fboId)
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.renderScene()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "renderScene";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.renderScene()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(I)",
    fboId
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGAbstractRendererWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSGAbstractRendererWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSGAbstractRenderer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSGAbstractRendererWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSGAbstractRenderer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSGAbstractRendererWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSGAbstractRendererWrapper *>(this));
        return QSGAbstractRenderer::qt_metacast(_clname);
}

QSGAbstractRendererWrapper::~QSGAbstractRendererWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGAbstractRenderer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSGAbstractRenderer' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGAbstractRenderer >()))
        return -1;

    ::QSGAbstractRendererWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSGAbstractRenderer", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSGAbstractRenderer::QSGAbstractRenderer(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSGAbstractRenderer(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSGAbstractRenderer(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRenderer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGAbstractRenderer_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QSGAbstractRenderer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QSGAbstractRenderer(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QSGAbstractRendererWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QSGAbstractRendererWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGAbstractRenderer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGAbstractRenderer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSGAbstractRenderer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSGAbstractRenderer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGAbstractRendererFunc_clearColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.clearColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearColor()const
            QColor cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->clearColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGAbstractRendererFunc_clearMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.clearMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearMode()const
            QFlags<QSGAbstractRenderer::ClearModeBit> cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->clearMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGAbstractRendererFunc_deviceRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.deviceRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceRect()const
            QRect cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->deviceRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGAbstractRendererFunc_nodeChanged(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.nodeChanged";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "nodeChanged", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGAbstractRenderer::nodeChanged(QSGNode*,QFlags<QSGNode::DirtyStateBit>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGNODE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGNODE_DIRTYSTATEBIT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // nodeChanged(QSGNode*,QFlags<QSGNode::DirtyStateBit>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_nodeChanged_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QSGNode::DirtyStateBit> cppArg1 = QFlags<QSGNode::DirtyStateBit>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // nodeChanged(QSGNode*,QFlags<QSGNode::DirtyStateBit>)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.nodeChanged()' not implemented.");
                return {};
            }
            cppSelf->nodeChanged(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_nodeChanged_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_projectionMatrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.projectionMatrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // projectionMatrix()const
            QMatrix4x4 cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->projectionMatrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGAbstractRendererFunc_projectionMatrixWithNativeNDC(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.projectionMatrixWithNativeNDC";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // projectionMatrixWithNativeNDC()const
            QMatrix4x4 cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->projectionMatrixWithNativeNDC();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGAbstractRendererFunc_renderScene(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.renderScene";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGAbstractRendererFunc_renderScene_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:renderScene", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QSGAbstractRenderer::renderScene(uint)
    if (numArgs == 0) {
        overloadId = 0; // renderScene(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 0; // renderScene(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_renderScene_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fboId = Shiboken::String::createStaticString("fboId");
            if (PyDict_Contains(kwds, key_fboId)) {
                value = PyDict_GetItem(kwds, key_fboId);
                if (value && pyArgs[0]) {
                    errInfo = key_fboId;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGAbstractRendererFunc_renderScene_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0]))))
                        goto Sbk_QSGAbstractRendererFunc_renderScene_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fboId);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGAbstractRendererFunc_renderScene_TypeError;
            }
        }
        uint cppArg0 = 0;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // renderScene(uint)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGAbstractRenderer.renderScene()' not implemented.");
                return {};
            }
            cppSelf->renderScene(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_renderScene_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setClearColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setClearColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setClearColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setClearColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setClearColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setClearColor(QColor)
            cppSelf->setClearColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setClearColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setClearMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setClearMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setClearMode(QFlags<QSGAbstractRenderer::ClearModeBit>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setClearMode(QFlags<QSGAbstractRenderer::ClearModeBit>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setClearMode_TypeError;

    // Call function/method
    {
        ::QFlags<QSGAbstractRenderer::ClearModeBit> cppArg0 = QFlags<QSGAbstractRenderer::ClearModeBit>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setClearMode(QFlags<QSGAbstractRenderer::ClearModeBit>)
            cppSelf->setClearMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setClearMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setDeviceRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setDeviceRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setDeviceRect(QRect)
    // 1: QSGAbstractRenderer::setDeviceRect(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 1; // setDeviceRect(QSize)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setDeviceRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setDeviceRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setDeviceRect(const QRect & rect)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setDeviceRect(QRect)
                cppSelf->setDeviceRect(*cppArg0);
            }
            break;
        }
        case 1: // setDeviceRect(const QSize & size)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setDeviceRect(QSize)
                cppSelf->setDeviceRect(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setDeviceRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setProjectionMatrix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setProjectionMatrix(QMatrix4x4)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // setProjectionMatrix(QMatrix4x4)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setProjectionMatrix_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProjectionMatrix(QMatrix4x4)
            cppSelf->setProjectionMatrix(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setProjectionMatrix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setProjectionMatrixToRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrixToRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProjectionMatrixToRect", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setProjectionMatrixToRect(QRectF)
    // 1: QSGAbstractRenderer::setProjectionMatrixToRect(QRectF,QFlags<QSGAbstractRenderer::MatrixTransformFlag>)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setProjectionMatrixToRect(QRectF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // setProjectionMatrixToRect(QRectF,QFlags<QSGAbstractRenderer::MatrixTransformFlag>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setProjectionMatrixToRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setProjectionMatrixToRect(const QRectF & rect)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setProjectionMatrixToRect(QRectF)
                cppSelf->setProjectionMatrixToRect(*cppArg0);
            }
            break;
        }
        case 1: // setProjectionMatrixToRect(const QRectF & rect, QFlags<QSGAbstractRenderer::MatrixTransformFlag> flags)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QSGAbstractRenderer::MatrixTransformFlag> cppArg1 = QFlags<QSGAbstractRenderer::MatrixTransformFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setProjectionMatrixToRect(QRectF,QFlags<QSGAbstractRenderer::MatrixTransformFlag>)
                cppSelf->setProjectionMatrixToRect(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setProjectionMatrixToRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setProjectionMatrixWithNativeNDC(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrixWithNativeNDC";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setProjectionMatrixWithNativeNDC(QMatrix4x4)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArg)))) {
        overloadId = 0; // setProjectionMatrixWithNativeNDC(QMatrix4x4)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setProjectionMatrixWithNativeNDC_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMatrix4x4 cppArg0_local;
        ::QMatrix4x4 *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProjectionMatrixWithNativeNDC(QMatrix4x4)
            cppSelf->setProjectionMatrixWithNativeNDC(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setProjectionMatrixWithNativeNDC_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_setViewportRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.setViewportRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGAbstractRenderer::setViewportRect(QRect)
    // 1: QSGAbstractRenderer::setViewportRect(QSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArg)))) {
        overloadId = 1; // setViewportRect(QSize)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setViewportRect(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGAbstractRendererFunc_setViewportRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setViewportRect(const QRect & rect)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QRect cppArg0_local;
            ::QRect *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setViewportRect(QRect)
                cppSelf->setViewportRect(*cppArg0);
            }
            break;
        }
        case 1: // setViewportRect(const QSize & size)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setViewportRect(QSize)
                cppSelf->setViewportRect(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGAbstractRendererFunc_setViewportRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGAbstractRendererFunc_viewportRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGAbstractRenderer.viewportRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewportRect()const
            QRect cppResult = const_cast<const ::QSGAbstractRenderer *>(cppSelf)->viewportRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGAbstractRenderer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGAbstractRenderer_methods[] = {
    {"clearColor", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_clearColor), METH_NOARGS},
    {"clearMode", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_clearMode), METH_NOARGS},
    {"deviceRect", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_deviceRect), METH_NOARGS},
    {"nodeChanged", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_nodeChanged), METH_VARARGS},
    {"projectionMatrix", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_projectionMatrix), METH_NOARGS},
    {"projectionMatrixWithNativeNDC", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_projectionMatrixWithNativeNDC), METH_NOARGS},
    {"renderScene", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_renderScene), METH_VARARGS|METH_KEYWORDS},
    {"setClearColor", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setClearColor), METH_O},
    {"setClearMode", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setClearMode), METH_O},
    {"setDeviceRect", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setDeviceRect), METH_O},
    {"setProjectionMatrix", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setProjectionMatrix), METH_O},
    {"setProjectionMatrixToRect", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setProjectionMatrixToRect), METH_VARARGS},
    {"setProjectionMatrixWithNativeNDC", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setProjectionMatrixWithNativeNDC), METH_O},
    {"setViewportRect", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_setViewportRect), METH_O},
    {"viewportRect", reinterpret_cast<PyCFunction>(Sbk_QSGAbstractRendererFunc_viewportRect), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGAbstractRenderer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGAbstractRenderer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGAbstractRendererWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGAbstractRenderer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGAbstractRenderer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGAbstractRenderer_Type = nullptr;
static SbkObjectType *Sbk_QSGAbstractRenderer_TypeF(void)
{
    return _Sbk_QSGAbstractRenderer_Type;
}

static PyType_Slot Sbk_QSGAbstractRenderer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGAbstractRenderer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGAbstractRenderer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGAbstractRenderer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGAbstractRenderer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGAbstractRenderer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGAbstractRenderer_spec = {
    "2:PySide2.QtQuick.QSGAbstractRenderer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGAbstractRenderer_slots
};

} //extern "C"

static void *Sbk_QSGAbstractRenderer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSGAbstractRenderer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::ClearMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::ClearMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::ClearMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::ClearMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::ClearMode cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, self, &cppSelf);
    ::QSGAbstractRenderer::ClearMode cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::MatrixTransformFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::MatrixTransformFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::MatrixTransformFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGAbstractRenderer::MatrixTransformFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGAbstractRenderer::MatrixTransformFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, self, &cppSelf);
    ::QSGAbstractRenderer::MatrixTransformFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSGAbstractRenderer_ClearModeBit_PythonToCpp_QSGAbstractRenderer_ClearModeBit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGAbstractRenderer::ClearModeBit *>(cppOut) =
        static_cast<::QSGAbstractRenderer::ClearModeBit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGAbstractRenderer_ClearModeBit_PythonToCpp_QSGAbstractRenderer_ClearModeBit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]))
        return QSGAbstractRenderer_ClearModeBit_PythonToCpp_QSGAbstractRenderer_ClearModeBit;
    return {};
}
static PyObject *QSGAbstractRenderer_ClearModeBit_CppToPython_QSGAbstractRenderer_ClearModeBit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGAbstractRenderer::ClearModeBit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX], castCppIn);

}

static void QFlags_QSGAbstractRenderer_ClearModeBit__PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::ClearModeBit> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::ClearModeBit>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGAbstractRenderer_ClearModeBit__PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]))
        return QFlags_QSGAbstractRenderer_ClearModeBit__PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_;
    return {};
}
static PyObject *QFlags_QSGAbstractRenderer_ClearModeBit__CppToPython_QFlags_QSGAbstractRenderer_ClearModeBit_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGAbstractRenderer::ClearModeBit> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]));

}

static void QSGAbstractRenderer_ClearModeBit_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::ClearModeBit> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::ClearModeBit>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGAbstractRenderer_ClearModeBit_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]))
        return QSGAbstractRenderer_ClearModeBit_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::ClearModeBit> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::ClearModeBit>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]))
        return number_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_;
    return {};
}
static void QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QSGAbstractRenderer_MatrixTransformFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGAbstractRenderer::MatrixTransformFlag *>(cppOut) =
        static_cast<::QSGAbstractRenderer::MatrixTransformFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QSGAbstractRenderer_MatrixTransformFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]))
        return QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QSGAbstractRenderer_MatrixTransformFlag;
    return {};
}
static PyObject *QSGAbstractRenderer_MatrixTransformFlag_CppToPython_QSGAbstractRenderer_MatrixTransformFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGAbstractRenderer::MatrixTransformFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX], castCppIn);

}

static void QFlags_QSGAbstractRenderer_MatrixTransformFlag__PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::MatrixTransformFlag> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::MatrixTransformFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGAbstractRenderer_MatrixTransformFlag__PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]))
        return QFlags_QSGAbstractRenderer_MatrixTransformFlag__PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_;
    return {};
}
static PyObject *QFlags_QSGAbstractRenderer_MatrixTransformFlag__CppToPython_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGAbstractRenderer::MatrixTransformFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]));

}

static void QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::MatrixTransformFlag> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::MatrixTransformFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]))
        return QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGAbstractRenderer::MatrixTransformFlag> *>(cppOut) =
        ::QFlags<QSGAbstractRenderer::MatrixTransformFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]))
        return number_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGAbstractRenderer_PythonToCpp_QSGAbstractRenderer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGAbstractRenderer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGAbstractRenderer_PythonToCpp_QSGAbstractRenderer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGAbstractRenderer_TypeF())))
        return QSGAbstractRenderer_PythonToCpp_QSGAbstractRenderer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGAbstractRenderer_PTR_CppToPython_QSGAbstractRenderer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSGAbstractRenderer *>(const_cast<void *>(cppIn)), Sbk_QSGAbstractRenderer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGAbstractRenderer_SignatureStrings[] = {
    "PySide2.QtQuick.QSGAbstractRenderer(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtQuick.QSGAbstractRenderer.clearColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtQuick.QSGAbstractRenderer.clearMode(self)->PySide2.QtQuick.QSGAbstractRenderer.ClearMode",
    "PySide2.QtQuick.QSGAbstractRenderer.deviceRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtQuick.QSGAbstractRenderer.nodeChanged(self,node:PySide2.QtQuick.QSGNode,state:PySide2.QtQuick.QSGNode.DirtyState)",
    "PySide2.QtQuick.QSGAbstractRenderer.projectionMatrix(self)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtQuick.QSGAbstractRenderer.projectionMatrixWithNativeNDC(self)->PySide2.QtGui.QMatrix4x4",
    "PySide2.QtQuick.QSGAbstractRenderer.renderScene(self,fboId:uint=0)",
    "PySide2.QtQuick.QSGAbstractRenderer.setClearColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtQuick.QSGAbstractRenderer.setClearMode(self,mode:PySide2.QtQuick.QSGAbstractRenderer.ClearMode)",
    "1:PySide2.QtQuick.QSGAbstractRenderer.setDeviceRect(self,rect:PySide2.QtCore.QRect)",
    "0:PySide2.QtQuick.QSGAbstractRenderer.setDeviceRect(self,size:PySide2.QtCore.QSize)",
    "PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrix(self,matrix:PySide2.QtGui.QMatrix4x4)",
    "1:PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrixToRect(self,rect:PySide2.QtCore.QRectF)",
    "0:PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrixToRect(self,rect:PySide2.QtCore.QRectF,flags:PySide2.QtQuick.QSGAbstractRenderer.MatrixTransformFlags)",
    "PySide2.QtQuick.QSGAbstractRenderer.setProjectionMatrixWithNativeNDC(self,matrix:PySide2.QtGui.QMatrix4x4)",
    "1:PySide2.QtQuick.QSGAbstractRenderer.setViewportRect(self,rect:PySide2.QtCore.QRect)",
    "0:PySide2.QtQuick.QSGAbstractRenderer.setViewportRect(self,size:PySide2.QtCore.QSize)",
    "PySide2.QtQuick.QSGAbstractRenderer.viewportRect(self)->PySide2.QtCore.QRect",
    nullptr}; // Sentinel

void init_QSGAbstractRenderer(PyObject *module)
{
    _Sbk_QSGAbstractRenderer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGAbstractRenderer",
        "QSGAbstractRenderer*",
        &Sbk_QSGAbstractRenderer_spec,
        &Shiboken::callCppDestructor< ::QSGAbstractRenderer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGAbstractRenderer_Type);
    InitSignatureStrings(pyType, QSGAbstractRenderer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGAbstractRenderer_Type), Sbk_QSGAbstractRenderer_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGAbstractRenderer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGAbstractRenderer_TypeF(),
        QSGAbstractRenderer_PythonToCpp_QSGAbstractRenderer_PTR,
        is_QSGAbstractRenderer_PythonToCpp_QSGAbstractRenderer_PTR_Convertible,
        QSGAbstractRenderer_PTR_CppToPython_QSGAbstractRenderer);

    Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer");
    Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer*");
    Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGAbstractRenderer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGAbstractRendererWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGAbstractRenderer_TypeF(), &Sbk_QSGAbstractRenderer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ClearModeBit'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGAbstractRenderer.ClearMode", SbkPySide2_QtQuick_QSGAbstractRenderer_ClearModeBit_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGAbstractRenderer_TypeF(),
        "ClearModeBit",
        "2:PySide2.QtQuick.QSGAbstractRenderer.ClearModeBit",
        "QSGAbstractRenderer::ClearModeBit",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX],
        Sbk_QSGAbstractRenderer_TypeF(), "ClearColorBuffer", (long) QSGAbstractRenderer::ClearModeBit::ClearColorBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX],
        Sbk_QSGAbstractRenderer_TypeF(), "ClearDepthBuffer", (long) QSGAbstractRenderer::ClearModeBit::ClearDepthBuffer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX],
        Sbk_QSGAbstractRenderer_TypeF(), "ClearStencilBuffer", (long) QSGAbstractRenderer::ClearModeBit::ClearStencilBuffer))
        return;
    // Register converter for enum 'QSGAbstractRenderer::ClearModeBit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX],
            QSGAbstractRenderer_ClearModeBit_CppToPython_QSGAbstractRenderer_ClearModeBit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGAbstractRenderer_ClearModeBit_PythonToCpp_QSGAbstractRenderer_ClearModeBit,
            is_QSGAbstractRenderer_ClearModeBit_PythonToCpp_QSGAbstractRenderer_ClearModeBit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer::ClearModeBit");
        Shiboken::Conversions::registerConverterName(converter, "ClearModeBit");
    }
    // Register converter for flag 'QFlags<QSGAbstractRenderer::ClearModeBit>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX],
            QFlags_QSGAbstractRenderer_ClearModeBit__CppToPython_QFlags_QSGAbstractRenderer_ClearModeBit_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGAbstractRenderer_ClearModeBit_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_,
            is_QSGAbstractRenderer_ClearModeBit_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGAbstractRenderer_ClearModeBit__PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_,
            is_QFlags_QSGAbstractRenderer_ClearModeBit__PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit_,
            is_number_PythonToCpp_QFlags_QSGAbstractRenderer_ClearModeBit__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_CLEARMODEBIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer::ClearMode");
        Shiboken::Conversions::registerConverterName(converter, "ClearMode");
    }
    // End of 'ClearModeBit' enum/flags.

    // Initialization of enum 'MatrixTransformFlag'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGAbstractRenderer.MatrixTransformFlags", SbkPySide2_QtQuick_QSGAbstractRenderer_MatrixTransformFlag_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGAbstractRenderer_TypeF(),
        "MatrixTransformFlag",
        "2:PySide2.QtQuick.QSGAbstractRenderer.MatrixTransformFlag",
        "QSGAbstractRenderer::MatrixTransformFlag",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX],
        Sbk_QSGAbstractRenderer_TypeF(), "MatrixTransformFlipY", (long) QSGAbstractRenderer::MatrixTransformFlag::MatrixTransformFlipY))
        return;
    // Register converter for enum 'QSGAbstractRenderer::MatrixTransformFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX],
            QSGAbstractRenderer_MatrixTransformFlag_CppToPython_QSGAbstractRenderer_MatrixTransformFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QSGAbstractRenderer_MatrixTransformFlag,
            is_QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QSGAbstractRenderer_MatrixTransformFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer::MatrixTransformFlag");
        Shiboken::Conversions::registerConverterName(converter, "MatrixTransformFlag");
    }
    // Register converter for flag 'QFlags<QSGAbstractRenderer::MatrixTransformFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX],
            QFlags_QSGAbstractRenderer_MatrixTransformFlag__CppToPython_QFlags_QSGAbstractRenderer_MatrixTransformFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_,
            is_QSGAbstractRenderer_MatrixTransformFlag_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGAbstractRenderer_MatrixTransformFlag__PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_,
            is_QFlags_QSGAbstractRenderer_MatrixTransformFlag__PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag_,
            is_number_PythonToCpp_QFlags_QSGAbstractRenderer_MatrixTransformFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGABSTRACTRENDERER_MATRIXTRANSFORMFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGAbstractRenderer::MatrixTransformFlags");
        Shiboken::Conversions::registerConverterName(converter, "MatrixTransformFlags");
    }
    // End of 'MatrixTransformFlag' enum/flags.

    PySide::Signal::registerSignals(Sbk_QSGAbstractRenderer_TypeF(), &::QSGAbstractRenderer::staticMetaObject);
    qRegisterMetaType< ::QSGAbstractRenderer::ClearModeBit >("QSGAbstractRenderer::ClearModeBit");
    qRegisterMetaType< ::QSGAbstractRenderer::ClearMode >("QSGAbstractRenderer::ClearMode");
    qRegisterMetaType< ::QSGAbstractRenderer::MatrixTransformFlag >("QSGAbstractRenderer::MatrixTransformFlag");
    qRegisterMetaType< ::QSGAbstractRenderer::MatrixTransformFlags >("QSGAbstractRenderer::MatrixTransformFlags");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSGAbstractRenderer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSGAbstractRenderer_TypeF(), &::QSGAbstractRenderer::staticMetaObject, sizeof(QSGAbstractRendererWrapper));
}
