/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGEngineWrapper::QSGEngineWrapper(::QObject * parent) : QSGEngine(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QSGEngineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGEngineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QSGEngineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QSGEngineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QSGEngineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGEngine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QSGEngineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGEngine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QSGEngineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QSGEngineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QSGEngine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QSGEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QSGEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QSGEngineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QSGEngineWrapper *>(this));
        return QSGEngine::qt_metacast(_clname);
}

QSGEngineWrapper::~QSGEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGEngine >()))
        return -1;

    ::QSGEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QSGEngine", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QSGEngine::QSGEngine(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QSGEngine(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QSGEngine(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGEngine_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGEngine_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QSGEngine_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QSGEngine(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QSGEngineWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QSGEngineWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QSGEngine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QSGEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGEngineFunc_createRenderer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.createRenderer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // createRenderer()const
            QSGAbstractRenderer * cppResult = const_cast<const ::QSGEngine *>(cppSelf)->createRenderer();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGABSTRACTRENDERER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGEngineFunc_createTextureFromId(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.createTextureFromId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:createTextureFromId", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QSGEngine::createTextureFromId(uint,QSize,QFlags<QSGEngine::CreateTextureOption>)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // createTextureFromId(uint,QSize,QFlags<QSGEngine::CreateTextureOption>)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // createTextureFromId(uint,QSize,QFlags<QSGEngine::CreateTextureOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[2]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGEngineFunc_createTextureFromId_TypeError;
            }
        }
        uint cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local;
        ::QSize *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QFlags<QSGEngine::CreateTextureOption> cppArg2 = QSGEngine::CreateTextureOption();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createTextureFromId(uint,QSize,QFlags<QSGEngine::CreateTextureOption>)const
            QSGTexture * cppResult = const_cast<const ::QSGEngine *>(cppSelf)->createTextureFromId(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGEngineFunc_createTextureFromId_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGEngineFunc_createTextureFromImage(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.createTextureFromImage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:createTextureFromImage", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGEngine::createTextureFromImage(QImage,QFlags<QSGEngine::CreateTextureOption>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createTextureFromImage(QImage,QFlags<QSGEngine::CreateTextureOption>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // createTextureFromImage(QImage,QFlags<QSGEngine::CreateTextureOption>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[1]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGEngineFunc_createTextureFromImage_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QImage cppArg0_local;
        ::QImage *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QSGEngine::CreateTextureOption> cppArg1 = QSGEngine::CreateTextureOption();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createTextureFromImage(QImage,QFlags<QSGEngine::CreateTextureOption>)const
            QSGTexture * cppResult = const_cast<const ::QSGEngine *>(cppSelf)->createTextureFromImage(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGTEXTURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGEngineFunc_createTextureFromImage_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGEngineFunc_initialize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.initialize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGEngine::initialize(QOpenGLContext*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArg)))) {
        overloadId = 0; // initialize(QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGEngineFunc_initialize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLContext *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // initialize(QOpenGLContext*)
            cppSelf->initialize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGEngineFunc_initialize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGEngineFunc_invalidate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.invalidate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate()
            cppSelf->invalidate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGEngineFunc_rendererInterface(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGEngine.rendererInterface";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rendererInterface()const
            QSGRendererInterface * cppResult = const_cast<const ::QSGEngine *>(cppSelf)->rendererInterface();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGEngine_methods[] = {
    {"createRenderer", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_createRenderer), METH_NOARGS},
    {"createTextureFromId", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_createTextureFromId), METH_VARARGS|METH_KEYWORDS},
    {"createTextureFromImage", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_createTextureFromImage), METH_VARARGS|METH_KEYWORDS},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_initialize), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_invalidate), METH_NOARGS},
    {"rendererInterface", reinterpret_cast<PyCFunction>(Sbk_QSGEngineFunc_rendererInterface), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGEngine_Type = nullptr;
static SbkObjectType *Sbk_QSGEngine_TypeF(void)
{
    return _Sbk_QSGEngine_Type;
}

static PyType_Slot Sbk_QSGEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGEngine_spec = {
    "2:PySide2.QtQuick.QSGEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGEngine_slots
};

} //extern "C"

static void *Sbk_QSGEngine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QSGEngine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGEngine::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGEngine::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGEngine::CreateTextureOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGEngine::CreateTextureOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGEngine::CreateTextureOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, self, &cppSelf);
    ::QSGEngine::CreateTextureOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGEngine_CreateTextureOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSGEngine_CreateTextureOption_PythonToCpp_QSGEngine_CreateTextureOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGEngine::CreateTextureOption *>(cppOut) =
        static_cast<::QSGEngine::CreateTextureOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGEngine_CreateTextureOption_PythonToCpp_QSGEngine_CreateTextureOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX]))
        return QSGEngine_CreateTextureOption_PythonToCpp_QSGEngine_CreateTextureOption;
    return {};
}
static PyObject *QSGEngine_CreateTextureOption_CppToPython_QSGEngine_CreateTextureOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGEngine::CreateTextureOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX], castCppIn);

}

static void QFlags_QSGEngine_CreateTextureOption__PythonToCpp_QFlags_QSGEngine_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGEngine::CreateTextureOption> *>(cppOut) =
        ::QFlags<QSGEngine::CreateTextureOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGEngine_CreateTextureOption__PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX]))
        return QFlags_QSGEngine_CreateTextureOption__PythonToCpp_QFlags_QSGEngine_CreateTextureOption_;
    return {};
}
static PyObject *QFlags_QSGEngine_CreateTextureOption__CppToPython_QFlags_QSGEngine_CreateTextureOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGEngine::CreateTextureOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX]));

}

static void QSGEngine_CreateTextureOption_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGEngine::CreateTextureOption> *>(cppOut) =
        ::QFlags<QSGEngine::CreateTextureOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGEngine_CreateTextureOption_PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX]))
        return QSGEngine_CreateTextureOption_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGEngine::CreateTextureOption> *>(cppOut) =
        ::QFlags<QSGEngine::CreateTextureOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX]))
        return number_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGEngine_PythonToCpp_QSGEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGEngine_PythonToCpp_QSGEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGEngine_TypeF())))
        return QSGEngine_PythonToCpp_QSGEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGEngine_PTR_CppToPython_QSGEngine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QSGEngine *>(const_cast<void *>(cppIn)), Sbk_QSGEngine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGEngine_SignatureStrings[] = {
    "PySide2.QtQuick.QSGEngine(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtQuick.QSGEngine.createRenderer(self)->PySide2.QtQuick.QSGAbstractRenderer",
    "PySide2.QtQuick.QSGEngine.createTextureFromId(self,id:uint,size:PySide2.QtCore.QSize,options:PySide2.QtQuick.QSGEngine.CreateTextureOptions=QSGEngine.CreateTextureOption())->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QSGEngine.createTextureFromImage(self,image:PySide2.QtGui.QImage,options:PySide2.QtQuick.QSGEngine.CreateTextureOptions=QSGEngine.CreateTextureOption())->PySide2.QtQuick.QSGTexture",
    "PySide2.QtQuick.QSGEngine.initialize(self,context:PySide2.QtGui.QOpenGLContext)",
    "PySide2.QtQuick.QSGEngine.invalidate(self)",
    "PySide2.QtQuick.QSGEngine.rendererInterface(self)->PySide2.QtQuick.QSGRendererInterface",
    nullptr}; // Sentinel

void init_QSGEngine(PyObject *module)
{
    _Sbk_QSGEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGEngine",
        "QSGEngine*",
        &Sbk_QSGEngine_spec,
        &Shiboken::callCppDestructor< ::QSGEngine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGEngine_Type);
    InitSignatureStrings(pyType, QSGEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGEngine_Type), Sbk_QSGEngine_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGEngine_TypeF(),
        QSGEngine_PythonToCpp_QSGEngine_PTR,
        is_QSGEngine_PythonToCpp_QSGEngine_PTR_Convertible,
        QSGEngine_PTR_CppToPython_QSGEngine);

    Shiboken::Conversions::registerConverterName(converter, "QSGEngine");
    Shiboken::Conversions::registerConverterName(converter, "QSGEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QSGEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGEngineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QSGEngine_TypeF(), &Sbk_QSGEngine_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'CreateTextureOption'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGEngine.CreateTextureOptions", SbkPySide2_QtQuick_QSGEngine_CreateTextureOption_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGEngine_TypeF(),
        "CreateTextureOption",
        "2:PySide2.QtQuick.QSGEngine.CreateTextureOption",
        "QSGEngine::CreateTextureOption",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX],
        Sbk_QSGEngine_TypeF(), "TextureHasAlphaChannel", (long) QSGEngine::CreateTextureOption::TextureHasAlphaChannel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX],
        Sbk_QSGEngine_TypeF(), "TextureOwnsGLTexture", (long) QSGEngine::CreateTextureOption::TextureOwnsGLTexture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX],
        Sbk_QSGEngine_TypeF(), "TextureCanUseAtlas", (long) QSGEngine::CreateTextureOption::TextureCanUseAtlas))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX],
        Sbk_QSGEngine_TypeF(), "TextureIsOpaque", (long) QSGEngine::CreateTextureOption::TextureIsOpaque))
        return;
    // Register converter for enum 'QSGEngine::CreateTextureOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX],
            QSGEngine_CreateTextureOption_CppToPython_QSGEngine_CreateTextureOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGEngine_CreateTextureOption_PythonToCpp_QSGEngine_CreateTextureOption,
            is_QSGEngine_CreateTextureOption_PythonToCpp_QSGEngine_CreateTextureOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGENGINE_CREATETEXTUREOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGEngine::CreateTextureOption");
        Shiboken::Conversions::registerConverterName(converter, "CreateTextureOption");
    }
    // Register converter for flag 'QFlags<QSGEngine::CreateTextureOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX],
            QFlags_QSGEngine_CreateTextureOption__CppToPython_QFlags_QSGEngine_CreateTextureOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGEngine_CreateTextureOption_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_,
            is_QSGEngine_CreateTextureOption_PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGEngine_CreateTextureOption__PythonToCpp_QFlags_QSGEngine_CreateTextureOption_,
            is_QFlags_QSGEngine_CreateTextureOption__PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGEngine_CreateTextureOption_,
            is_number_PythonToCpp_QFlags_QSGEngine_CreateTextureOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGENGINE_CREATETEXTUREOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGEngine::CreateTextureOptions");
        Shiboken::Conversions::registerConverterName(converter, "CreateTextureOptions");
    }
    // End of 'CreateTextureOption' enum/flags.

    PySide::Signal::registerSignals(Sbk_QSGEngine_TypeF(), &::QSGEngine::staticMetaObject);
    qRegisterMetaType< ::QSGEngine::CreateTextureOption >("QSGEngine::CreateTextureOption");
    qRegisterMetaType< ::QSGEngine::CreateTextureOptions >("QSGEngine::CreateTextureOptions");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QSGEngine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QSGEngine_TypeF(), &::QSGEngine::staticMetaObject, sizeof(QSGEngineWrapper));
}
