/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsggeometry_attribute_wrapper.h"

// inner classes

// Extra includes
#include <QtQuick/qsggeometry.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGGeometry_Attribute_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGGeometry::Attribute >()))
        return -1;

    ::QSGGeometry::Attribute *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.Attribute.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Attribute", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Attribute::Attribute()
    // 1: Attribute::Attribute(QSGGeometry::Attribute)
    if (numArgs == 0) {
        overloadId = 0; // Attribute()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Attribute(QSGGeometry::Attribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_Attribute_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // Attribute()
        {

            if (!PyErr_Occurred()) {
                // Attribute()
                cptr = new ::QSGGeometry::Attribute();
            }
            break;
        }
        case 1: // Attribute(const QSGGeometry::Attribute & Attribute)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSGGeometry::Attribute cppArg0_local;
            ::QSGGeometry::Attribute *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // Attribute(QSGGeometry::Attribute)
                cptr = new ::QSGGeometry::Attribute(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGGeometry::Attribute >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGGeometry_Attribute_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGGeometry_Attribute_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGGeometry_AttributeFunc_create(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.Attribute.create";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:create", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static Attribute::create(int,int,int,bool)
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // create(int,int,int,bool)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
            overloadId = 0; // create(int,int,int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_isPosition = Shiboken::String::createStaticString("isPosition");
            if (PyDict_Contains(kwds, key_isPosition)) {
                value = PyDict_GetItem(kwds, key_isPosition);
                if (value && pyArgs[3]) {
                    errInfo = key_isPosition;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))
                        goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_isPosition);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGGeometry_AttributeFunc_create_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3 = false;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // create(int,int,int,bool)
            QSGGeometry::Attribute cppResult = ::QSGGeometry::Attribute::create(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGGeometry_AttributeFunc_create_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometry_AttributeFunc_createWithAttributeType(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.Attribute.createWithAttributeType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createWithAttributeType", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static Attribute::createWithAttributeType(int,int,int,QSGGeometry::AttributeType)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX])->converter, (pyArgs[3])))) {
        overloadId = 0; // createWithAttributeType(int,int,int,QSGGeometry::AttributeType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_AttributeFunc_createWithAttributeType_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QSGGeometry::AttributeType cppArg3{QSGGeometry::UnknownAttribute};
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // createWithAttributeType(int,int,int,QSGGeometry::AttributeType)
            QSGGeometry::Attribute cppResult = ::QSGGeometry::Attribute::createWithAttributeType(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGGeometry_AttributeFunc_createWithAttributeType_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometry_Attribute___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGGeometry_Attribute_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGGeometry_Attribute_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_QSGGeometry_AttributeFunc_create), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"createWithAttributeType", reinterpret_cast<PyCFunction>(Sbk_QSGGeometry_AttributeFunc_createWithAttributeType), METH_VARARGS|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSGGeometry_Attribute___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QSGGeometry_Attribute_get_position(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->position;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_position(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->position;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->position = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_Attribute_get_tupleSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->tupleSize;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_tupleSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'tupleSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tupleSize', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->tupleSize;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->tupleSize = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_Attribute_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_Attribute_get_isVertexCoordinate(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->isVertexCoordinate;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_isVertexCoordinate(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'isVertexCoordinate' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'isVertexCoordinate', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->isVertexCoordinate;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->isVertexCoordinate = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_Attribute_get_attributeType(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QSGGeometry::AttributeType cppOut_local = cppSelf->attributeType;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_attributeType(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'attributeType' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'attributeType', 'AttributeType' or convertible type expected");
        return -1;
    }

    ::QSGGeometry::AttributeType cppOut_local = cppSelf->attributeType;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->attributeType = cppOut_local;

    return 0;
}

static PyObject *Sbk_QSGGeometry_Attribute_get_reserved(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    uint cppOut_local = cppSelf->reserved;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QSGGeometry_Attribute_set_reserved(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'reserved' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'reserved', 'uint' or convertible type expected");
        return -1;
    }

    uint cppOut_local = cppSelf->reserved;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->reserved = cppOut_local;

    return 0;
}

// Getters and Setters for Attribute
static PyGetSetDef Sbk_QSGGeometry_Attribute_getsetlist[] = {
    {const_cast<char *>("position"), Sbk_QSGGeometry_Attribute_get_position, Sbk_QSGGeometry_Attribute_set_position},
    {const_cast<char *>("tupleSize"), Sbk_QSGGeometry_Attribute_get_tupleSize, Sbk_QSGGeometry_Attribute_set_tupleSize},
    {const_cast<char *>("type"), Sbk_QSGGeometry_Attribute_get_type, Sbk_QSGGeometry_Attribute_set_type},
    {const_cast<char *>("isVertexCoordinate"), Sbk_QSGGeometry_Attribute_get_isVertexCoordinate, Sbk_QSGGeometry_Attribute_set_isVertexCoordinate},
    {const_cast<char *>("attributeType"), Sbk_QSGGeometry_Attribute_get_attributeType, Sbk_QSGGeometry_Attribute_set_attributeType},
    {const_cast<char *>("reserved"), Sbk_QSGGeometry_Attribute_get_reserved, Sbk_QSGGeometry_Attribute_set_reserved},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QSGGeometry_Attribute_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGGeometry_Attribute_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGGeometry_Attribute_Type = nullptr;
static SbkObjectType *Sbk_QSGGeometry_Attribute_TypeF(void)
{
    return _Sbk_QSGGeometry_Attribute_Type;
}

static PyType_Slot Sbk_QSGGeometry_Attribute_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGGeometry_Attribute_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGGeometry_Attribute_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGGeometry_Attribute_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QSGGeometry_Attribute_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGGeometry_Attribute_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGGeometry_Attribute_spec = {
    "2:PySide2.QtQuick.QSGGeometry.Attribute",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGGeometry_Attribute_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Attribute_PythonToCpp_Attribute_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGGeometry_Attribute_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Attribute_PythonToCpp_Attribute_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_Attribute_TypeF())))
        return Attribute_PythonToCpp_Attribute_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Attribute_PTR_CppToPython_Attribute(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGGeometry::Attribute *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGGeometry_Attribute_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *Attribute_COPY_CppToPython_Attribute(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSGGeometry_Attribute_TypeF(), new ::QSGGeometry::Attribute(*reinterpret_cast<const ::QSGGeometry::Attribute *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void Attribute_PythonToCpp_Attribute_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::Attribute *>(cppOut) = *reinterpret_cast< ::QSGGeometry::Attribute *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_Attribute_PythonToCpp_Attribute_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_Attribute_TypeF())))
        return Attribute_PythonToCpp_Attribute_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGGeometry_Attribute_SignatureStrings[] = {
    "1:PySide2.QtQuick.QSGGeometry.Attribute(self)",
    "0:PySide2.QtQuick.QSGGeometry.Attribute(self,Attribute:PySide2.QtQuick.QSGGeometry.Attribute)",
    "PySide2.QtQuick.QSGGeometry.Attribute.create(pos:int,tupleSize:int,primitiveType:int,isPosition:bool=false)->PySide2.QtQuick.QSGGeometry.Attribute",
    "PySide2.QtQuick.QSGGeometry.Attribute.createWithAttributeType(pos:int,tupleSize:int,primitiveType:int,attributeType:PySide2.QtQuick.QSGGeometry.AttributeType)->PySide2.QtQuick.QSGGeometry.Attribute",
    "PySide2.QtQuick.QSGGeometry.Attribute.__copy__()",
    nullptr}; // Sentinel

void init_QSGGeometry_Attribute(PyObject *enclosingClass)
{
    _Sbk_QSGGeometry_Attribute_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Attribute",
        "QSGGeometry::Attribute",
        &Sbk_QSGGeometry_Attribute_spec,
        &Shiboken::callCppDestructor< ::QSGGeometry::Attribute >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_Attribute_Type);
    InitSignatureStrings(pyType, QSGGeometry_Attribute_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_Attribute_Type), Sbk_QSGGeometry_Attribute_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_Attribute_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGGeometry_Attribute_TypeF(),
        Attribute_PythonToCpp_Attribute_PTR,
        is_Attribute_PythonToCpp_Attribute_PTR_Convertible,
        Attribute_PTR_CppToPython_Attribute,
        Attribute_COPY_CppToPython_Attribute);

    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::Attribute");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::Attribute*");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::Attribute&");
    Shiboken::Conversions::registerConverterName(converter, "Attribute");
    Shiboken::Conversions::registerConverterName(converter, "Attribute*");
    Shiboken::Conversions::registerConverterName(converter, "Attribute&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometry::Attribute).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        Attribute_PythonToCpp_Attribute_COPY,
        is_Attribute_PythonToCpp_Attribute_COPY_Convertible);

    qRegisterMetaType< ::QSGGeometry::Attribute >("Attribute");
    qRegisterMetaType< ::QSGGeometry::Attribute >("QSGGeometry::Attribute");
}
