/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsggeometry_wrapper.h"

// inner classes
#include "qsggeometry_coloredpoint2d_wrapper.h"
#include "qsggeometry_texturedpoint2d_wrapper.h"
#include "qsggeometry_point2d_wrapper.h"
#include "qsggeometry_attribute_wrapper.h"
#include "qsggeometry_attributeset_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGGeometryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGGeometryWrapper::QSGGeometryWrapper(const ::QSGGeometry::AttributeSet & attribs, int vertexCount, int indexCount, int indexType) : QSGGeometry(attribs, vertexCount, indexCount, indexType)
{
    resetPyMethodCache();
    // ... middle
}

QSGGeometryWrapper::~QSGGeometryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGGeometry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGGeometry >()))
        return -1;

    ::QSGGeometryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometry_Init_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometry_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:QSGGeometry", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QSGGeometry::QSGGeometry(QSGGeometry::AttributeSet,int,int,int)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTESET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QSGGeometry(QSGGeometry::AttributeSet,int,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // QSGGeometry(QSGGeometry::AttributeSet,int,int,int)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                overloadId = 0; // QSGGeometry(QSGGeometry::AttributeSet,int,int,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometry_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_indexCount = Shiboken::String::createStaticString("indexCount");
            if (PyDict_Contains(kwds, key_indexCount)) {
                value = PyDict_GetItem(kwds, key_indexCount);
                if (value && pyArgs[2]) {
                    errInfo = key_indexCount;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGGeometry_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))
                        goto Sbk_QSGGeometry_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_indexCount);
            }
            static PyObject *const key_indexType = Shiboken::String::createStaticString("indexType");
            if (PyDict_Contains(kwds, key_indexType)) {
                value = PyDict_GetItem(kwds, key_indexType);
                if (value && pyArgs[3]) {
                    errInfo = key_indexType;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGGeometry_Init_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                        goto Sbk_QSGGeometry_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_indexType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGGeometry_Init_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QSGGeometry::AttributeSet cppArg0_local;
        ::QSGGeometry::AttributeSet *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTESET_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 0;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = QSGGeometry::UnsignedShortType;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // QSGGeometry(QSGGeometry::AttributeSet,int,int,int)
            cptr = new ::QSGGeometryWrapper(*cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGGeometry >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSGGeometry_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSGGeometry_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSGGeometryFunc_allocate(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.allocate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometryFunc_allocate_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QSGGeometryFunc_allocate_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:allocate", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGGeometry::allocate(int,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // allocate(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // allocate(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_allocate_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_indexCount = Shiboken::String::createStaticString("indexCount");
            if (PyDict_Contains(kwds, key_indexCount)) {
                value = PyDict_GetItem(kwds, key_indexCount);
                if (value && pyArgs[1]) {
                    errInfo = key_indexCount;
                    Py_INCREF(errInfo);
                    goto Sbk_QSGGeometryFunc_allocate_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QSGGeometryFunc_allocate_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_indexCount);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QSGGeometryFunc_allocate_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // allocate(int,int)
            cppSelf->allocate(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_allocate_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_attributeCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.attributeCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributeCount()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->attributeCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_attributes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.attributes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attributes()const
            const QSGGeometry::Attribute * cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->attributes();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_defaultAttributes_ColoredPoint2D(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.defaultAttributes_ColoredPoint2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultAttributes_ColoredPoint2D()
            const QSGGeometry::AttributeSet & cppResult = ::QSGGeometry::defaultAttributes_ColoredPoint2D();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTESET_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_defaultAttributes_Point2D(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.defaultAttributes_Point2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultAttributes_Point2D()
            const QSGGeometry::AttributeSet & cppResult = ::QSGGeometry::defaultAttributes_Point2D();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTESET_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_defaultAttributes_TexturedPoint2D(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.defaultAttributes_TexturedPoint2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultAttributes_TexturedPoint2D()
            const QSGGeometry::AttributeSet & cppResult = ::QSGGeometry::defaultAttributes_TexturedPoint2D();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTESET_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_drawingMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.drawingMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // drawingMode()const
            unsigned int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->drawingMode();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexCount()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->indexCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexData()
            void * cppResult = cppSelf->indexData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexDataAsUInt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexDataAsUInt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexDataAsUInt()
            uint * cppResult = cppSelf->indexDataAsUInt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexDataAsUShort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexDataAsUShort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexDataAsUShort()
            quint16 * cppResult = cppSelf->indexDataAsUShort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexDataPattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexDataPattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexDataPattern()const
            QSGGeometry::DataPattern cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->indexDataPattern();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_indexType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.indexType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // indexType()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->indexType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_lineWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.lineWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineWidth()const
            float cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->lineWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<float>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_markIndexDataDirty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.markIndexDataDirty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // markIndexDataDirty()
            cppSelf->markIndexDataDirty();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGGeometryFunc_markVertexDataDirty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.markVertexDataDirty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // markVertexDataDirty()
            cppSelf->markVertexDataDirty();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QSGGeometryFunc_setDrawingMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.setDrawingMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometry::setDrawingMode(uint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArg)))) {
        overloadId = 0; // setDrawingMode(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_setDrawingMode_TypeError;

    // Call function/method
    {
        unsigned int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDrawingMode(uint)
            cppSelf->setDrawingMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_setDrawingMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_setIndexDataPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.setIndexDataPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometry::setIndexDataPattern(QSGGeometry::DataPattern)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setIndexDataPattern(QSGGeometry::DataPattern)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_setIndexDataPattern_TypeError;

    // Call function/method
    {
        ::QSGGeometry::DataPattern cppArg0{QSGGeometry::AlwaysUploadPattern};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIndexDataPattern(QSGGeometry::DataPattern)
            cppSelf->setIndexDataPattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_setIndexDataPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_setLineWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.setLineWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometry::setLineWidth(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setLineWidth(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_setLineWidth_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLineWidth(float)
            cppSelf->setLineWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_setLineWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_setVertexDataPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.setVertexDataPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSGGeometry::setVertexDataPattern(QSGGeometry::DataPattern)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setVertexDataPattern(QSGGeometry::DataPattern)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_setVertexDataPattern_TypeError;

    // Call function/method
    {
        ::QSGGeometry::DataPattern cppArg0{QSGGeometry::AlwaysUploadPattern};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVertexDataPattern(QSGGeometry::DataPattern)
            cppSelf->setVertexDataPattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_setVertexDataPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_sizeOfIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.sizeOfIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeOfIndex()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->sizeOfIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_sizeOfVertex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.sizeOfVertex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeOfVertex()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->sizeOfVertex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_updateColoredRectGeometry(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.updateColoredRectGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateColoredRectGeometry", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSGGeometry::updateColoredRectGeometry(QSGGeometry*,QRectF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updateColoredRectGeometry(QSGGeometry*,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_updateColoredRectGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGGeometry *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // updateColoredRectGeometry(QSGGeometry*,QRectF)
            ::QSGGeometry::updateColoredRectGeometry(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_updateColoredRectGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_updateRectGeometry(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.updateRectGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRectGeometry", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QSGGeometry::updateRectGeometry(QSGGeometry*,QRectF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updateRectGeometry(QSGGeometry*,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_updateRectGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGGeometry *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // updateRectGeometry(QSGGeometry*,QRectF)
            ::QSGGeometry::updateRectGeometry(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_updateRectGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_updateTexturedRectGeometry(PyObject *self, PyObject *args)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.updateTexturedRectGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateTexturedRectGeometry", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QSGGeometry::updateTexturedRectGeometry(QSGGeometry*,QRectF,QRectF)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[2])))) {
        overloadId = 0; // updateTexturedRectGeometry(QSGGeometry*,QRectF,QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGGeometryFunc_updateTexturedRectGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QSGGeometry *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRectF cppArg2_local;
        ::QRectF *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // updateTexturedRectGeometry(QSGGeometry*,QRectF,QRectF)
            ::QSGGeometry::updateTexturedRectGeometry(cppArg0, *cppArg1, *cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSGGeometryFunc_updateTexturedRectGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGGeometryFunc_vertexCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexCount()const
            int cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->vertexCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_vertexData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexData()
            void * cppResult = cppSelf->vertexData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_vertexDataAsColoredPoint2D(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexDataAsColoredPoint2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexDataAsColoredPoint2D()
            QSGGeometry::ColoredPoint2D * cppResult = cppSelf->vertexDataAsColoredPoint2D();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_COLOREDPOINT2D_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_vertexDataAsPoint2D(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexDataAsPoint2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexDataAsPoint2D()
            QSGGeometry::Point2D * cppResult = cppSelf->vertexDataAsPoint2D();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_POINT2D_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_vertexDataAsTexturedPoint2D(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexDataAsTexturedPoint2D";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexDataAsTexturedPoint2D()
            QSGGeometry::TexturedPoint2D * cppResult = cppSelf->vertexDataAsTexturedPoint2D();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TEXTUREDPOINT2D_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGGeometryFunc_vertexDataPattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGGeometry.vertexDataPattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // vertexDataPattern()const
            QSGGeometry::DataPattern cppResult = const_cast<const ::QSGGeometry *>(cppSelf)->vertexDataPattern();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGGeometry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGGeometry_methods[] = {
    {"allocate", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_allocate), METH_VARARGS|METH_KEYWORDS},
    {"attributeCount", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_attributeCount), METH_NOARGS},
    {"attributes", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_attributes), METH_NOARGS},
    {"defaultAttributes_ColoredPoint2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_defaultAttributes_ColoredPoint2D), METH_NOARGS|METH_STATIC},
    {"defaultAttributes_Point2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_defaultAttributes_Point2D), METH_NOARGS|METH_STATIC},
    {"defaultAttributes_TexturedPoint2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_defaultAttributes_TexturedPoint2D), METH_NOARGS|METH_STATIC},
    {"drawingMode", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_drawingMode), METH_NOARGS},
    {"indexCount", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexCount), METH_NOARGS},
    {"indexData", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexData), METH_NOARGS},
    {"indexDataAsUInt", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexDataAsUInt), METH_NOARGS},
    {"indexDataAsUShort", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexDataAsUShort), METH_NOARGS},
    {"indexDataPattern", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexDataPattern), METH_NOARGS},
    {"indexType", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_indexType), METH_NOARGS},
    {"lineWidth", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_lineWidth), METH_NOARGS},
    {"markIndexDataDirty", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_markIndexDataDirty), METH_NOARGS},
    {"markVertexDataDirty", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_markVertexDataDirty), METH_NOARGS},
    {"setDrawingMode", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_setDrawingMode), METH_O},
    {"setIndexDataPattern", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_setIndexDataPattern), METH_O},
    {"setLineWidth", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_setLineWidth), METH_O},
    {"setVertexDataPattern", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_setVertexDataPattern), METH_O},
    {"sizeOfIndex", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_sizeOfIndex), METH_NOARGS},
    {"sizeOfVertex", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_sizeOfVertex), METH_NOARGS},
    {"updateColoredRectGeometry", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_updateColoredRectGeometry), METH_VARARGS|METH_STATIC},
    {"updateRectGeometry", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_updateRectGeometry), METH_VARARGS|METH_STATIC},
    {"updateTexturedRectGeometry", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_updateTexturedRectGeometry), METH_VARARGS|METH_STATIC},
    {"vertexCount", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexCount), METH_NOARGS},
    {"vertexData", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexData), METH_NOARGS},
    {"vertexDataAsColoredPoint2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexDataAsColoredPoint2D), METH_NOARGS},
    {"vertexDataAsPoint2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexDataAsPoint2D), METH_NOARGS},
    {"vertexDataAsTexturedPoint2D", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexDataAsTexturedPoint2D), METH_NOARGS},
    {"vertexDataPattern", reinterpret_cast<PyCFunction>(Sbk_QSGGeometryFunc_vertexDataPattern), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGGeometry_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGGeometry *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGGeometryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGGeometry_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGGeometry_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGGeometry_Type = nullptr;
static SbkObjectType *Sbk_QSGGeometry_TypeF(void)
{
    return _Sbk_QSGGeometry_Type;
}

static PyType_Slot Sbk_QSGGeometry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGGeometry_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGGeometry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGGeometry_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGGeometry_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGGeometry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGGeometry_spec = {
    "2:PySide2.QtQuick.QSGGeometry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGGeometry_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QSGGeometry_AttributeType_PythonToCpp_QSGGeometry_AttributeType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::AttributeType *>(cppOut) =
        static_cast<::QSGGeometry::AttributeType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGGeometry_AttributeType_PythonToCpp_QSGGeometry_AttributeType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX]))
        return QSGGeometry_AttributeType_PythonToCpp_QSGGeometry_AttributeType;
    return {};
}
static PyObject *QSGGeometry_AttributeType_CppToPython_QSGGeometry_AttributeType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGGeometry::AttributeType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX], castCppIn);

}

static void QSGGeometry_DataPattern_PythonToCpp_QSGGeometry_DataPattern(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::DataPattern *>(cppOut) =
        static_cast<::QSGGeometry::DataPattern>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGGeometry_DataPattern_PythonToCpp_QSGGeometry_DataPattern_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX]))
        return QSGGeometry_DataPattern_PythonToCpp_QSGGeometry_DataPattern;
    return {};
}
static PyObject *QSGGeometry_DataPattern_CppToPython_QSGGeometry_DataPattern(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGGeometry::DataPattern *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX], castCppIn);

}

static void QSGGeometry_DrawingMode_PythonToCpp_QSGGeometry_DrawingMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::DrawingMode *>(cppOut) =
        static_cast<::QSGGeometry::DrawingMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGGeometry_DrawingMode_PythonToCpp_QSGGeometry_DrawingMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX]))
        return QSGGeometry_DrawingMode_PythonToCpp_QSGGeometry_DrawingMode;
    return {};
}
static PyObject *QSGGeometry_DrawingMode_CppToPython_QSGGeometry_DrawingMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGGeometry::DrawingMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX], castCppIn);

}

static void QSGGeometry_Type_PythonToCpp_QSGGeometry_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGGeometry::Type *>(cppOut) =
        static_cast<::QSGGeometry::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGGeometry_Type_PythonToCpp_QSGGeometry_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX]))
        return QSGGeometry_Type_PythonToCpp_QSGGeometry_Type;
    return {};
}
static PyObject *QSGGeometry_Type_CppToPython_QSGGeometry_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGGeometry::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGGeometry_PythonToCpp_QSGGeometry_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGGeometry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGGeometry_PythonToCpp_QSGGeometry_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_TypeF())))
        return QSGGeometry_PythonToCpp_QSGGeometry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGGeometry_PTR_CppToPython_QSGGeometry(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGGeometry *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGGeometry_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGGeometry_SignatureStrings[] = {
    "PySide2.QtQuick.QSGGeometry(self,attribs:PySide2.QtQuick.QSGGeometry.AttributeSet,vertexCount:int,indexCount:int=0,indexType:int=UnsignedShortType)",
    "PySide2.QtQuick.QSGGeometry.allocate(self,vertexCount:int,indexCount:int=0)",
    "PySide2.QtQuick.QSGGeometry.attributeCount(self)->int",
    "PySide2.QtQuick.QSGGeometry.attributes(self)->PySide2.QtQuick.QSGGeometry.Attribute",
    "PySide2.QtQuick.QSGGeometry.defaultAttributes_ColoredPoint2D()->PySide2.QtQuick.QSGGeometry.AttributeSet",
    "PySide2.QtQuick.QSGGeometry.defaultAttributes_Point2D()->PySide2.QtQuick.QSGGeometry.AttributeSet",
    "PySide2.QtQuick.QSGGeometry.defaultAttributes_TexturedPoint2D()->PySide2.QtQuick.QSGGeometry.AttributeSet",
    "PySide2.QtQuick.QSGGeometry.drawingMode(self)->unsigned int",
    "PySide2.QtQuick.QSGGeometry.indexCount(self)->int",
    "1:PySide2.QtQuick.QSGGeometry.indexData(self)->void",
    "0:PySide2.QtQuick.QSGGeometry.indexData(self)->void",
    "1:PySide2.QtQuick.QSGGeometry.indexDataAsUInt(self)->uint*",
    "0:PySide2.QtQuick.QSGGeometry.indexDataAsUInt(self)->uint*",
    "1:PySide2.QtQuick.QSGGeometry.indexDataAsUShort(self)->quint16*",
    "0:PySide2.QtQuick.QSGGeometry.indexDataAsUShort(self)->quint16*",
    "PySide2.QtQuick.QSGGeometry.indexDataPattern(self)->PySide2.QtQuick.QSGGeometry.DataPattern",
    "PySide2.QtQuick.QSGGeometry.indexType(self)->int",
    "PySide2.QtQuick.QSGGeometry.lineWidth(self)->float",
    "PySide2.QtQuick.QSGGeometry.markIndexDataDirty(self)",
    "PySide2.QtQuick.QSGGeometry.markVertexDataDirty(self)",
    "PySide2.QtQuick.QSGGeometry.setDrawingMode(self,mode:unsigned int)",
    "PySide2.QtQuick.QSGGeometry.setIndexDataPattern(self,p:PySide2.QtQuick.QSGGeometry.DataPattern)",
    "PySide2.QtQuick.QSGGeometry.setLineWidth(self,w:float)",
    "PySide2.QtQuick.QSGGeometry.setVertexDataPattern(self,p:PySide2.QtQuick.QSGGeometry.DataPattern)",
    "PySide2.QtQuick.QSGGeometry.sizeOfIndex(self)->int",
    "PySide2.QtQuick.QSGGeometry.sizeOfVertex(self)->int",
    "PySide2.QtQuick.QSGGeometry.updateColoredRectGeometry(g:PySide2.QtQuick.QSGGeometry,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtQuick.QSGGeometry.updateRectGeometry(g:PySide2.QtQuick.QSGGeometry,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtQuick.QSGGeometry.updateTexturedRectGeometry(g:PySide2.QtQuick.QSGGeometry,rect:PySide2.QtCore.QRectF,sourceRect:PySide2.QtCore.QRectF)",
    "PySide2.QtQuick.QSGGeometry.vertexCount(self)->int",
    "1:PySide2.QtQuick.QSGGeometry.vertexData(self)->void",
    "0:PySide2.QtQuick.QSGGeometry.vertexData(self)->void",
    "1:PySide2.QtQuick.QSGGeometry.vertexDataAsColoredPoint2D(self)->PySide2.QtQuick.QSGGeometry.ColoredPoint2D",
    "0:PySide2.QtQuick.QSGGeometry.vertexDataAsColoredPoint2D(self)->PySide2.QtQuick.QSGGeometry.ColoredPoint2D",
    "1:PySide2.QtQuick.QSGGeometry.vertexDataAsPoint2D(self)->PySide2.QtQuick.QSGGeometry.Point2D",
    "0:PySide2.QtQuick.QSGGeometry.vertexDataAsPoint2D(self)->PySide2.QtQuick.QSGGeometry.Point2D",
    "1:PySide2.QtQuick.QSGGeometry.vertexDataAsTexturedPoint2D(self)->PySide2.QtQuick.QSGGeometry.TexturedPoint2D",
    "0:PySide2.QtQuick.QSGGeometry.vertexDataAsTexturedPoint2D(self)->PySide2.QtQuick.QSGGeometry.TexturedPoint2D",
    "PySide2.QtQuick.QSGGeometry.vertexDataPattern(self)->PySide2.QtQuick.QSGGeometry.DataPattern",
    nullptr}; // Sentinel

void init_QSGGeometry(PyObject *module)
{
    _Sbk_QSGGeometry_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGGeometry",
        "QSGGeometry*",
        &Sbk_QSGGeometry_spec,
        &Shiboken::callCppDestructor< ::QSGGeometry >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_Type);
    InitSignatureStrings(pyType, QSGGeometry_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGGeometry_Type), Sbk_QSGGeometry_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGGeometry_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGGeometry_TypeF(),
        QSGGeometry_PythonToCpp_QSGGeometry_PTR,
        is_QSGGeometry_PythonToCpp_QSGGeometry_PTR_Convertible,
        QSGGeometry_PTR_CppToPython_QSGGeometry);

    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry*");
    Shiboken::Conversions::registerConverterName(converter, "QSGGeometry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometry).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGGeometryWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'AttributeType'.
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGGeometry_TypeF(),
        "AttributeType",
        "2:PySide2.QtQuick.QSGGeometry.AttributeType",
        "QSGGeometry::AttributeType");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "UnknownAttribute", (long) QSGGeometry::AttributeType::UnknownAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "PositionAttribute", (long) QSGGeometry::AttributeType::PositionAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "ColorAttribute", (long) QSGGeometry::AttributeType::ColorAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "TexCoordAttribute", (long) QSGGeometry::AttributeType::TexCoordAttribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "TexCoord1Attribute", (long) QSGGeometry::AttributeType::TexCoord1Attribute))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "TexCoord2Attribute", (long) QSGGeometry::AttributeType::TexCoord2Attribute))
        return;
    // Register converter for enum 'QSGGeometry::AttributeType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX],
            QSGGeometry_AttributeType_CppToPython_QSGGeometry_AttributeType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGGeometry_AttributeType_PythonToCpp_QSGGeometry_AttributeType,
            is_QSGGeometry_AttributeType_PythonToCpp_QSGGeometry_AttributeType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_ATTRIBUTETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::AttributeType");
        Shiboken::Conversions::registerConverterName(converter, "AttributeType");
    }
    // End of 'AttributeType' enum.

    // Initialization of enum 'DataPattern'.
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGGeometry_TypeF(),
        "DataPattern",
        "2:PySide2.QtQuick.QSGGeometry.DataPattern",
        "QSGGeometry::DataPattern");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX],
        Sbk_QSGGeometry_TypeF(), "AlwaysUploadPattern", (long) QSGGeometry::DataPattern::AlwaysUploadPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX],
        Sbk_QSGGeometry_TypeF(), "StreamPattern", (long) QSGGeometry::DataPattern::StreamPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX],
        Sbk_QSGGeometry_TypeF(), "DynamicPattern", (long) QSGGeometry::DataPattern::DynamicPattern))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX],
        Sbk_QSGGeometry_TypeF(), "StaticPattern", (long) QSGGeometry::DataPattern::StaticPattern))
        return;
    // Register converter for enum 'QSGGeometry::DataPattern'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX],
            QSGGeometry_DataPattern_CppToPython_QSGGeometry_DataPattern);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGGeometry_DataPattern_PythonToCpp_QSGGeometry_DataPattern,
            is_QSGGeometry_DataPattern_PythonToCpp_QSGGeometry_DataPattern_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DATAPATTERN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::DataPattern");
        Shiboken::Conversions::registerConverterName(converter, "DataPattern");
    }
    // End of 'DataPattern' enum.

    // Initialization of enum 'DrawingMode'.
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGGeometry_TypeF(),
        "DrawingMode",
        "2:PySide2.QtQuick.QSGGeometry.DrawingMode",
        "QSGGeometry::DrawingMode");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawPoints", (long) QSGGeometry::DrawingMode::DrawPoints))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawLines", (long) QSGGeometry::DrawingMode::DrawLines))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawLineLoop", (long) QSGGeometry::DrawingMode::DrawLineLoop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawLineStrip", (long) QSGGeometry::DrawingMode::DrawLineStrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawTriangles", (long) QSGGeometry::DrawingMode::DrawTriangles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawTriangleStrip", (long) QSGGeometry::DrawingMode::DrawTriangleStrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
        Sbk_QSGGeometry_TypeF(), "DrawTriangleFan", (long) QSGGeometry::DrawingMode::DrawTriangleFan))
        return;
    // Register converter for enum 'QSGGeometry::DrawingMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX],
            QSGGeometry_DrawingMode_CppToPython_QSGGeometry_DrawingMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGGeometry_DrawingMode_PythonToCpp_QSGGeometry_DrawingMode,
            is_QSGGeometry_DrawingMode_PythonToCpp_QSGGeometry_DrawingMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_DRAWINGMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::DrawingMode");
        Shiboken::Conversions::registerConverterName(converter, "DrawingMode");
    }
    // End of 'DrawingMode' enum.

    // Initialization of enum 'Type'.
    SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGGeometry_TypeF(),
        "Type",
        "2:PySide2.QtQuick.QSGGeometry.Type",
        "QSGGeometry::Type");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "ByteType", (long) QSGGeometry::Type::ByteType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "UnsignedByteType", (long) QSGGeometry::Type::UnsignedByteType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "ShortType", (long) QSGGeometry::Type::ShortType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "UnsignedShortType", (long) QSGGeometry::Type::UnsignedShortType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "IntType", (long) QSGGeometry::Type::IntType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "UnsignedIntType", (long) QSGGeometry::Type::UnsignedIntType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "FloatType", (long) QSGGeometry::Type::FloatType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "Bytes2Type", (long) QSGGeometry::Type::Bytes2Type))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "Bytes3Type", (long) QSGGeometry::Type::Bytes3Type))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "Bytes4Type", (long) QSGGeometry::Type::Bytes4Type))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
        Sbk_QSGGeometry_TypeF(), "DoubleType", (long) QSGGeometry::Type::DoubleType))
        return;
    // Register converter for enum 'QSGGeometry::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX],
            QSGGeometry_Type_CppToPython_QSGGeometry_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGGeometry_Type_PythonToCpp_QSGGeometry_Type,
            is_QSGGeometry_Type_PythonToCpp_QSGGeometry_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGGEOMETRY_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGGeometry::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    qRegisterMetaType< ::QSGGeometry::AttributeType >("QSGGeometry::AttributeType");
    qRegisterMetaType< ::QSGGeometry::DataPattern >("QSGGeometry::DataPattern");
    qRegisterMetaType< ::QSGGeometry::DrawingMode >("QSGGeometry::DrawingMode");
    qRegisterMetaType< ::QSGGeometry::Type >("QSGGeometry::Type");
}
