/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtquick_python.h"

// main header
#include "qsgrendererinterface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QSGRendererInterfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QSGRendererInterfaceWrapper::QSGRendererInterfaceWrapper() : QSGRendererInterface()
{
    resetPyMethodCache();
    // ... middle
}

void * QSGRendererInterfaceWrapper::getResource(::QQuickWindow * window, ::QSGRendererInterface::Resource resource) const
{
    if (m_PyMethodCache[0])
        return this->::QSGRendererInterface::getResource(window, resource);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getResource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QSGRendererInterface::getResource(window, resource);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX]), window),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX])->converter, &resource)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.getResource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< void >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    void* cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void * QSGRendererInterfaceWrapper::getResource(::QQuickWindow * window, const char * resource) const
{
    if (m_PyMethodCache[1])
        return this->::QSGRendererInterface::getResource(window, resource);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getResource";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QSGRendererInterface::getResource(window, resource);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX]), window),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), resource)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.getResource", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< void >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    void* cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSGRendererInterface::GraphicsApi QSGRendererInterfaceWrapper::graphicsApi() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.graphicsApi()' not implemented.");
        return QSGRendererInterface::Unknown;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSGRendererInterface::Unknown;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "graphicsApi";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.graphicsApi()' not implemented.");
        return QSGRendererInterface::Unknown;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSGRendererInterface::Unknown;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.graphicsApi", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGRendererInterface::GraphicsApi >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSGRendererInterface::Unknown;
    }
    ::QSGRendererInterface::GraphicsApi cppResult{QSGRendererInterface::Unknown};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QSGRendererInterface::ShaderCompilationType> QSGRendererInterfaceWrapper::shaderCompilationType() const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderCompilationType()' not implemented.");
        return QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "shaderCompilationType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderCompilationType()' not implemented.");
        return QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.shaderCompilationType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QSGRendererInterface::ShaderCompilationType> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    }
    ::QFlags<QSGRendererInterface::ShaderCompilationType> cppResult = QFlags<QSGRendererInterface::ShaderCompilationType>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QSGRendererInterface::ShaderSourceType> QSGRendererInterfaceWrapper::shaderSourceType() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderSourceType()' not implemented.");
        return QFlags<QSGRendererInterface::ShaderSourceType>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QSGRendererInterface::ShaderSourceType>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "shaderSourceType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderSourceType()' not implemented.");
        return QFlags<QSGRendererInterface::ShaderSourceType>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QSGRendererInterface::ShaderSourceType>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.shaderSourceType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QSGRendererInterface::ShaderSourceType> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QSGRendererInterface::ShaderSourceType>(0);
    }
    ::QFlags<QSGRendererInterface::ShaderSourceType> cppResult = QFlags<QSGRendererInterface::ShaderSourceType>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSGRendererInterface::ShaderType QSGRendererInterfaceWrapper::shaderType() const
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderType()' not implemented.");
        return QSGRendererInterface::UnknownShadingLanguage;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QSGRendererInterface::UnknownShadingLanguage;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "shaderType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderType()' not implemented.");
        return QSGRendererInterface::UnknownShadingLanguage;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QSGRendererInterface::UnknownShadingLanguage;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QSGRendererInterface.shaderType", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSGRendererInterface::ShaderType >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QSGRendererInterface::UnknownShadingLanguage;
    }
    ::QSGRendererInterface::ShaderType cppResult{QSGRendererInterface::UnknownShadingLanguage};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QSGRendererInterfaceWrapper::~QSGRendererInterfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSGRendererInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QSGRendererInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSGRendererInterface >()))
        return -1;

    ::QSGRendererInterfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QSGRendererInterface()
            cptr = new ::QSGRendererInterfaceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSGRendererInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QSGRendererInterfaceFunc_getResource(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.getResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "getResource", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QSGRendererInterface::getResource(QQuickWindow*,const char*)const
    // 1: QSGRendererInterface::getResource(QQuickWindow*,QSGRendererInterface::Resource)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtQuickTypes[SBK_QQUICKWINDOW_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // getResource(QQuickWindow*,QSGRendererInterface::Resource)const
        } else if (numArgs == 2
            && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 0; // getResource(QQuickWindow*,const char*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGRendererInterfaceFunc_getResource_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // getResource(QQuickWindow * window, const char * resource) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QQuickWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // getResource(QQuickWindow*,const char*)const
                void * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QSGRendererInterface *>(cppSelf)->::QSGRendererInterface::getResource(cppArg0, cppArg1)
                    : const_cast<const ::QSGRendererInterface *>(cppSelf)->getResource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
            }
            break;
        }
        case 1: // getResource(QQuickWindow * window, QSGRendererInterface::Resource resource) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QQuickWindow *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSGRendererInterface::Resource cppArg1{QSGRendererInterface::DeviceResource};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // getResource(QQuickWindow*,QSGRendererInterface::Resource)const
                void * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QSGRendererInterface *>(cppSelf)->::QSGRendererInterface::getResource(cppArg0, cppArg1)
                    : const_cast<const ::QSGRendererInterface *>(cppSelf)->getResource(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGRendererInterfaceFunc_getResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGRendererInterfaceFunc_graphicsApi(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.graphicsApi";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // graphicsApi()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.graphicsApi()' not implemented.");
                return {};
            }
            QSGRendererInterface::GraphicsApi cppResult = const_cast<const ::QSGRendererInterface *>(cppSelf)->graphicsApi();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGRendererInterfaceFunc_isApiRhiBased(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.isApiRhiBased";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QSGRendererInterface::isApiRhiBased(QSGRendererInterface::GraphicsApi)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isApiRhiBased(QSGRendererInterface::GraphicsApi)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSGRendererInterfaceFunc_isApiRhiBased_TypeError;

    // Call function/method
    {
        ::QSGRendererInterface::GraphicsApi cppArg0{QSGRendererInterface::Unknown};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isApiRhiBased(QSGRendererInterface::GraphicsApi)
            bool cppResult = ::QSGRendererInterface::isApiRhiBased(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QSGRendererInterfaceFunc_isApiRhiBased_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSGRendererInterfaceFunc_shaderCompilationType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.shaderCompilationType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaderCompilationType()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderCompilationType()' not implemented.");
                return {};
            }
            QFlags<QSGRendererInterface::ShaderCompilationType> cppResult = const_cast<const ::QSGRendererInterface *>(cppSelf)->shaderCompilationType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGRendererInterfaceFunc_shaderSourceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.shaderSourceType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaderSourceType()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderSourceType()' not implemented.");
                return {};
            }
            QFlags<QSGRendererInterface::ShaderSourceType> cppResult = const_cast<const ::QSGRendererInterface *>(cppSelf)->shaderSourceType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSGRendererInterfaceFunc_shaderType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtQuick.QSGRendererInterface.shaderType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shaderType()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QSGRendererInterface.shaderType()' not implemented.");
                return {};
            }
            QSGRendererInterface::ShaderType cppResult = const_cast<const ::QSGRendererInterface *>(cppSelf)->shaderType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSGRendererInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSGRendererInterface_methods[] = {
    {"getResource", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_getResource), METH_VARARGS},
    {"graphicsApi", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_graphicsApi), METH_NOARGS},
    {"isApiRhiBased", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_isApiRhiBased), METH_O|METH_STATIC},
    {"shaderCompilationType", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_shaderCompilationType), METH_NOARGS},
    {"shaderSourceType", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_shaderSourceType), METH_NOARGS},
    {"shaderType", reinterpret_cast<PyCFunction>(Sbk_QSGRendererInterfaceFunc_shaderType), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSGRendererInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QSGRendererInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QSGRendererInterfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QSGRendererInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSGRendererInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSGRendererInterface_Type = nullptr;
static SbkObjectType *Sbk_QSGRendererInterface_TypeF(void)
{
    return _Sbk_QSGRendererInterface_Type;
}

static PyType_Slot Sbk_QSGRendererInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QSGRendererInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSGRendererInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSGRendererInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSGRendererInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSGRendererInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QSGRendererInterface_spec = {
    "2:PySide2.QtQuick.QSGRendererInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSGRendererInterface_slots
};

} //extern "C"

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderCompilationTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderCompilationTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderCompilationTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderCompilationTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderCompilationTypes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, self, &cppSelf);
    ::QSGRendererInterface::ShaderCompilationTypes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___and__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderSourceTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___or__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderSourceTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___xor__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderSourceTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QSGRendererInterface::ShaderSourceTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___invert__(PyObject *self, PyObject *pyArg)
{
    ::QSGRendererInterface::ShaderSourceTypes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, self, &cppSelf);
    ::QSGRendererInterface::ShaderSourceTypes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QSGRendererInterface_GraphicsApi_PythonToCpp_QSGRendererInterface_GraphicsApi(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGRendererInterface::GraphicsApi *>(cppOut) =
        static_cast<::QSGRendererInterface::GraphicsApi>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGRendererInterface_GraphicsApi_PythonToCpp_QSGRendererInterface_GraphicsApi_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX]))
        return QSGRendererInterface_GraphicsApi_PythonToCpp_QSGRendererInterface_GraphicsApi;
    return {};
}
static PyObject *QSGRendererInterface_GraphicsApi_CppToPython_QSGRendererInterface_GraphicsApi(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGRendererInterface::GraphicsApi *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX], castCppIn);

}

static void QSGRendererInterface_Resource_PythonToCpp_QSGRendererInterface_Resource(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGRendererInterface::Resource *>(cppOut) =
        static_cast<::QSGRendererInterface::Resource>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGRendererInterface_Resource_PythonToCpp_QSGRendererInterface_Resource_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX]))
        return QSGRendererInterface_Resource_PythonToCpp_QSGRendererInterface_Resource;
    return {};
}
static PyObject *QSGRendererInterface_Resource_CppToPython_QSGRendererInterface_Resource(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGRendererInterface::Resource *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX], castCppIn);

}

static void QSGRendererInterface_ShaderType_PythonToCpp_QSGRendererInterface_ShaderType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGRendererInterface::ShaderType *>(cppOut) =
        static_cast<::QSGRendererInterface::ShaderType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGRendererInterface_ShaderType_PythonToCpp_QSGRendererInterface_ShaderType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX]))
        return QSGRendererInterface_ShaderType_PythonToCpp_QSGRendererInterface_ShaderType;
    return {};
}
static PyObject *QSGRendererInterface_ShaderType_CppToPython_QSGRendererInterface_ShaderType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGRendererInterface::ShaderType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX], castCppIn);

}

static void QSGRendererInterface_ShaderCompilationType_PythonToCpp_QSGRendererInterface_ShaderCompilationType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGRendererInterface::ShaderCompilationType *>(cppOut) =
        static_cast<::QSGRendererInterface::ShaderCompilationType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGRendererInterface_ShaderCompilationType_PythonToCpp_QSGRendererInterface_ShaderCompilationType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]))
        return QSGRendererInterface_ShaderCompilationType_PythonToCpp_QSGRendererInterface_ShaderCompilationType;
    return {};
}
static PyObject *QSGRendererInterface_ShaderCompilationType_CppToPython_QSGRendererInterface_ShaderCompilationType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGRendererInterface::ShaderCompilationType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX], castCppIn);

}

static void QFlags_QSGRendererInterface_ShaderCompilationType__PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderCompilationType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderCompilationType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGRendererInterface_ShaderCompilationType__PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]))
        return QFlags_QSGRendererInterface_ShaderCompilationType__PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_;
    return {};
}
static PyObject *QFlags_QSGRendererInterface_ShaderCompilationType__CppToPython_QFlags_QSGRendererInterface_ShaderCompilationType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGRendererInterface::ShaderCompilationType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]));

}

static void QSGRendererInterface_ShaderCompilationType_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderCompilationType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderCompilationType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGRendererInterface_ShaderCompilationType_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]))
        return QSGRendererInterface_ShaderCompilationType_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderCompilationType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderCompilationType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]))
        return number_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_;
    return {};
}
static void QSGRendererInterface_ShaderSourceType_PythonToCpp_QSGRendererInterface_ShaderSourceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSGRendererInterface::ShaderSourceType *>(cppOut) =
        static_cast<::QSGRendererInterface::ShaderSourceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QSGRendererInterface_ShaderSourceType_PythonToCpp_QSGRendererInterface_ShaderSourceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]))
        return QSGRendererInterface_ShaderSourceType_PythonToCpp_QSGRendererInterface_ShaderSourceType;
    return {};
}
static PyObject *QSGRendererInterface_ShaderSourceType_CppToPython_QSGRendererInterface_ShaderSourceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QSGRendererInterface::ShaderSourceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX], castCppIn);

}

static void QFlags_QSGRendererInterface_ShaderSourceType__PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderSourceType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderSourceType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QSGRendererInterface_ShaderSourceType__PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]))
        return QFlags_QSGRendererInterface_ShaderSourceType__PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_;
    return {};
}
static PyObject *QFlags_QSGRendererInterface_ShaderSourceType__CppToPython_QFlags_QSGRendererInterface_ShaderSourceType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QSGRendererInterface::ShaderSourceType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]));

}

static void QSGRendererInterface_ShaderSourceType_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderSourceType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderSourceType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QSGRendererInterface_ShaderSourceType_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]))
        return QSGRendererInterface_ShaderSourceType_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_;
    return {};
}
static void number_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QSGRendererInterface::ShaderSourceType> *>(cppOut) =
        ::QFlags<QSGRendererInterface::ShaderSourceType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]))
        return number_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSGRendererInterface_PythonToCpp_QSGRendererInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSGRendererInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSGRendererInterface_PythonToCpp_QSGRendererInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSGRendererInterface_TypeF())))
        return QSGRendererInterface_PythonToCpp_QSGRendererInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSGRendererInterface_PTR_CppToPython_QSGRendererInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSGRendererInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSGRendererInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSGRendererInterface_SignatureStrings[] = {
    "PySide2.QtQuick.QSGRendererInterface(self)",
    "1:PySide2.QtQuick.QSGRendererInterface.getResource(self,window:PySide2.QtQuick.QQuickWindow,resource:char*)->void",
    "0:PySide2.QtQuick.QSGRendererInterface.getResource(self,window:PySide2.QtQuick.QQuickWindow,resource:PySide2.QtQuick.QSGRendererInterface.Resource)->void",
    "PySide2.QtQuick.QSGRendererInterface.graphicsApi(self)->PySide2.QtQuick.QSGRendererInterface.GraphicsApi",
    "PySide2.QtQuick.QSGRendererInterface.isApiRhiBased(api:PySide2.QtQuick.QSGRendererInterface.GraphicsApi)->bool",
    "PySide2.QtQuick.QSGRendererInterface.shaderCompilationType(self)->PySide2.QtQuick.QSGRendererInterface.ShaderCompilationTypes",
    "PySide2.QtQuick.QSGRendererInterface.shaderSourceType(self)->PySide2.QtQuick.QSGRendererInterface.ShaderSourceTypes",
    "PySide2.QtQuick.QSGRendererInterface.shaderType(self)->PySide2.QtQuick.QSGRendererInterface.ShaderType",
    nullptr}; // Sentinel

void init_QSGRendererInterface(PyObject *module)
{
    _Sbk_QSGRendererInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSGRendererInterface",
        "QSGRendererInterface*",
        &Sbk_QSGRendererInterface_spec,
        &Shiboken::callCppDestructor< ::QSGRendererInterface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSGRendererInterface_Type);
    InitSignatureStrings(pyType, QSGRendererInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSGRendererInterface_Type), Sbk_QSGRendererInterface_PropertyStrings);
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSGRendererInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSGRendererInterface_TypeF(),
        QSGRendererInterface_PythonToCpp_QSGRendererInterface_PTR,
        is_QSGRendererInterface_PythonToCpp_QSGRendererInterface_PTR_Convertible,
        QSGRendererInterface_PTR_CppToPython_QSGRendererInterface);

    Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface");
    Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGRendererInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSGRendererInterfaceWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'GraphicsApi'.
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGRendererInterface_TypeF(),
        "GraphicsApi",
        "2:PySide2.QtQuick.QSGRendererInterface.GraphicsApi",
        "QSGRendererInterface::GraphicsApi");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "Unknown", (long) QSGRendererInterface::GraphicsApi::Unknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "Software", (long) QSGRendererInterface::GraphicsApi::Software))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "OpenGL", (long) QSGRendererInterface::GraphicsApi::OpenGL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "Direct3D12", (long) QSGRendererInterface::GraphicsApi::Direct3D12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "OpenVG", (long) QSGRendererInterface::GraphicsApi::OpenVG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "OpenGLRhi", (long) QSGRendererInterface::GraphicsApi::OpenGLRhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "Direct3D11Rhi", (long) QSGRendererInterface::GraphicsApi::Direct3D11Rhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "VulkanRhi", (long) QSGRendererInterface::GraphicsApi::VulkanRhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "MetalRhi", (long) QSGRendererInterface::GraphicsApi::MetalRhi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
        Sbk_QSGRendererInterface_TypeF(), "NullRhi", (long) QSGRendererInterface::GraphicsApi::NullRhi))
        return;
    // Register converter for enum 'QSGRendererInterface::GraphicsApi'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX],
            QSGRendererInterface_GraphicsApi_CppToPython_QSGRendererInterface_GraphicsApi);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_GraphicsApi_PythonToCpp_QSGRendererInterface_GraphicsApi,
            is_QSGRendererInterface_GraphicsApi_PythonToCpp_QSGRendererInterface_GraphicsApi_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_GRAPHICSAPI_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::GraphicsApi");
        Shiboken::Conversions::registerConverterName(converter, "GraphicsApi");
    }
    // End of 'GraphicsApi' enum.

    // Initialization of enum 'Resource'.
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGRendererInterface_TypeF(),
        "Resource",
        "2:PySide2.QtQuick.QSGRendererInterface.Resource",
        "QSGRendererInterface::Resource");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "DeviceResource", (long) QSGRendererInterface::Resource::DeviceResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "CommandQueueResource", (long) QSGRendererInterface::Resource::CommandQueueResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "CommandListResource", (long) QSGRendererInterface::Resource::CommandListResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "PainterResource", (long) QSGRendererInterface::Resource::PainterResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "RhiResource", (long) QSGRendererInterface::Resource::RhiResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "PhysicalDeviceResource", (long) QSGRendererInterface::Resource::PhysicalDeviceResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "OpenGLContextResource", (long) QSGRendererInterface::Resource::OpenGLContextResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "DeviceContextResource", (long) QSGRendererInterface::Resource::DeviceContextResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "CommandEncoderResource", (long) QSGRendererInterface::Resource::CommandEncoderResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "VulkanInstanceResource", (long) QSGRendererInterface::Resource::VulkanInstanceResource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "RenderPassResource", (long) QSGRendererInterface::Resource::RenderPassResource))
        return;
    // Register converter for enum 'QSGRendererInterface::Resource'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX],
            QSGRendererInterface_Resource_CppToPython_QSGRendererInterface_Resource);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_Resource_PythonToCpp_QSGRendererInterface_Resource,
            is_QSGRendererInterface_Resource_PythonToCpp_QSGRendererInterface_Resource_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_RESOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::Resource");
        Shiboken::Conversions::registerConverterName(converter, "Resource");
    }
    // End of 'Resource' enum.

    // Initialization of enum 'ShaderType'.
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGRendererInterface_TypeF(),
        "ShaderType",
        "2:PySide2.QtQuick.QSGRendererInterface.ShaderType",
        "QSGRendererInterface::ShaderType");
    if (!SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "UnknownShadingLanguage", (long) QSGRendererInterface::ShaderType::UnknownShadingLanguage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "GLSL", (long) QSGRendererInterface::ShaderType::GLSL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "HLSL", (long) QSGRendererInterface::ShaderType::HLSL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "RhiShader", (long) QSGRendererInterface::ShaderType::RhiShader))
        return;
    // Register converter for enum 'QSGRendererInterface::ShaderType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX],
            QSGRendererInterface_ShaderType_CppToPython_QSGRendererInterface_ShaderType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_ShaderType_PythonToCpp_QSGRendererInterface_ShaderType,
            is_QSGRendererInterface_ShaderType_PythonToCpp_QSGRendererInterface_ShaderType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::ShaderType");
        Shiboken::Conversions::registerConverterName(converter, "ShaderType");
    }
    // End of 'ShaderType' enum.

    // Initialization of enum 'ShaderCompilationType'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGRendererInterface.ShaderCompilationTypes", SbkPySide2_QtQuick_QSGRendererInterface_ShaderCompilationType_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGRendererInterface_TypeF(),
        "ShaderCompilationType",
        "2:PySide2.QtQuick.QSGRendererInterface.ShaderCompilationType",
        "QSGRendererInterface::ShaderCompilationType",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "RuntimeCompilation", (long) QSGRendererInterface::ShaderCompilationType::RuntimeCompilation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "OfflineCompilation", (long) QSGRendererInterface::ShaderCompilationType::OfflineCompilation))
        return;
    // Register converter for enum 'QSGRendererInterface::ShaderCompilationType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX],
            QSGRendererInterface_ShaderCompilationType_CppToPython_QSGRendererInterface_ShaderCompilationType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_ShaderCompilationType_PythonToCpp_QSGRendererInterface_ShaderCompilationType,
            is_QSGRendererInterface_ShaderCompilationType_PythonToCpp_QSGRendererInterface_ShaderCompilationType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::ShaderCompilationType");
        Shiboken::Conversions::registerConverterName(converter, "ShaderCompilationType");
    }
    // Register converter for flag 'QFlags<QSGRendererInterface::ShaderCompilationType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX],
            QFlags_QSGRendererInterface_ShaderCompilationType__CppToPython_QFlags_QSGRendererInterface_ShaderCompilationType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_ShaderCompilationType_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_,
            is_QSGRendererInterface_ShaderCompilationType_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGRendererInterface_ShaderCompilationType__PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_,
            is_QFlags_QSGRendererInterface_ShaderCompilationType__PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType_,
            is_number_PythonToCpp_QFlags_QSGRendererInterface_ShaderCompilationType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERCOMPILATIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::ShaderCompilationTypes");
        Shiboken::Conversions::registerConverterName(converter, "ShaderCompilationTypes");
    }
    // End of 'ShaderCompilationType' enum/flags.

    // Initialization of enum 'ShaderSourceType'.
    SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX] = PySide::QFlags::create("2:PySide2.QtQuick.QSGRendererInterface.ShaderSourceTypes", SbkPySide2_QtQuick_QSGRendererInterface_ShaderSourceType_number_slots);
    SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QSGRendererInterface_TypeF(),
        "ShaderSourceType",
        "2:PySide2.QtQuick.QSGRendererInterface.ShaderSourceType",
        "QSGRendererInterface::ShaderSourceType",
        SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX]);
    if (!SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "ShaderSourceString", (long) QSGRendererInterface::ShaderSourceType::ShaderSourceString))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "ShaderSourceFile", (long) QSGRendererInterface::ShaderSourceType::ShaderSourceFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX],
        Sbk_QSGRendererInterface_TypeF(), "ShaderByteCode", (long) QSGRendererInterface::ShaderSourceType::ShaderByteCode))
        return;
    // Register converter for enum 'QSGRendererInterface::ShaderSourceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX],
            QSGRendererInterface_ShaderSourceType_CppToPython_QSGRendererInterface_ShaderSourceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_ShaderSourceType_PythonToCpp_QSGRendererInterface_ShaderSourceType,
            is_QSGRendererInterface_ShaderSourceType_PythonToCpp_QSGRendererInterface_ShaderSourceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::ShaderSourceType");
        Shiboken::Conversions::registerConverterName(converter, "ShaderSourceType");
    }
    // Register converter for flag 'QFlags<QSGRendererInterface::ShaderSourceType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX],
            QFlags_QSGRendererInterface_ShaderSourceType__CppToPython_QFlags_QSGRendererInterface_ShaderSourceType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QSGRendererInterface_ShaderSourceType_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_,
            is_QSGRendererInterface_ShaderSourceType_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QSGRendererInterface_ShaderSourceType__PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_,
            is_QFlags_QSGRendererInterface_ShaderSourceType__PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType_,
            is_number_PythonToCpp_QFlags_QSGRendererInterface_ShaderSourceType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtQuickTypes[SBK_QFLAGS_QSGRENDERERINTERFACE_SHADERSOURCETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QSGRendererInterface::ShaderSourceTypes");
        Shiboken::Conversions::registerConverterName(converter, "ShaderSourceTypes");
    }
    // End of 'ShaderSourceType' enum/flags.

    qRegisterMetaType< ::QSGRendererInterface::GraphicsApi >("QSGRendererInterface::GraphicsApi");
    qRegisterMetaType< ::QSGRendererInterface::Resource >("QSGRendererInterface::Resource");
    qRegisterMetaType< ::QSGRendererInterface::ShaderType >("QSGRendererInterface::ShaderType");
    qRegisterMetaType< ::QSGRendererInterface::ShaderCompilationType >("QSGRendererInterface::ShaderCompilationType");
    qRegisterMetaType< ::QSGRendererInterface::ShaderCompilationTypes >("QSGRendererInterface::ShaderCompilationTypes");
    qRegisterMetaType< ::QSGRendererInterface::ShaderSourceType >("QSGRendererInterface::ShaderSourceType");
    qRegisterMetaType< ::QSGRendererInterface::ShaderSourceTypes >("QSGRendererInterface::ShaderSourceTypes");
}
