/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtremoteobjects_python.h"

// main header
#include "qremoteobjectpendingcall_wrapper.h"

// inner classes

// Extra includes
#include <QtRemoteObjects/qremoteobjectpendingcall.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRemoteObjectPendingCall_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRemoteObjectPendingCall >()))
        return -1;

    ::QRemoteObjectPendingCall *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QRemoteObjectPendingCall", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QRemoteObjectPendingCall::QRemoteObjectPendingCall()
    // 1: QRemoteObjectPendingCall::QRemoteObjectPendingCall(QRemoteObjectPendingCall)
    if (numArgs == 0) {
        overloadId = 0; // QRemoteObjectPendingCall()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QRemoteObjectPendingCall(QRemoteObjectPendingCall)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectPendingCall_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRemoteObjectPendingCall()
        {

            if (!PyErr_Occurred()) {
                // QRemoteObjectPendingCall()
                cptr = new ::QRemoteObjectPendingCall();
            }
            break;
        }
        case 1: // QRemoteObjectPendingCall(const QRemoteObjectPendingCall & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRemoteObjectPendingCall *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QRemoteObjectPendingCall(QRemoteObjectPendingCall)
                cptr = new ::QRemoteObjectPendingCall(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRemoteObjectPendingCall >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRemoteObjectPendingCall_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRemoteObjectPendingCall_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRemoteObjectPendingCallFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectPendingCall *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QRemoteObjectPendingCall::Error cppResult = const_cast<const ::QRemoteObjectPendingCall *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectPendingCallFunc_fromCompletedCall(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.fromCompletedCall";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QRemoteObjectPendingCall::fromCompletedCall(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // fromCompletedCall(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectPendingCallFunc_fromCompletedCall_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromCompletedCall(QVariant)
            QRemoteObjectPendingCall* cppResult = new QRemoteObjectPendingCall(::QRemoteObjectPendingCall::fromCompletedCall(cppArg0));
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectPendingCallFunc_fromCompletedCall_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectPendingCallFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectPendingCall *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QRemoteObjectPendingCall *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectPendingCallFunc_returnValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectPendingCall *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.returnValue";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // returnValue()const
            QVariant cppResult = const_cast<const ::QRemoteObjectPendingCall *>(cppSelf)->returnValue();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectPendingCallFunc_waitForFinished(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectPendingCall *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.waitForFinished";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForFinished", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectPendingCall::waitForFinished(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForFinished(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForFinished(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForFinished(int)
            bool cppResult = cppSelf->waitForFinished(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectPendingCallFunc_waitForFinished_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QRemoteObjectPendingCall_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRemoteObjectPendingCall_methods[] = {
    {"error", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectPendingCallFunc_error), METH_NOARGS},
    {"fromCompletedCall", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectPendingCallFunc_fromCompletedCall), METH_O|METH_STATIC},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectPendingCallFunc_isFinished), METH_NOARGS},
    {"returnValue", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectPendingCallFunc_returnValue), METH_NOARGS},
    {"waitForFinished", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectPendingCallFunc_waitForFinished), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QRemoteObjectPendingCall_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRemoteObjectPendingCall_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRemoteObjectPendingCall_Type = nullptr;
static SbkObjectType *Sbk_QRemoteObjectPendingCall_TypeF(void)
{
    return _Sbk_QRemoteObjectPendingCall_Type;
}

static PyType_Slot Sbk_QRemoteObjectPendingCall_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRemoteObjectPendingCall_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRemoteObjectPendingCall_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRemoteObjectPendingCall_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRemoteObjectPendingCall_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRemoteObjectPendingCall_spec = {
    "2:PySide2.QtRemoteObjects.QRemoteObjectPendingCall",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRemoteObjectPendingCall_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QRemoteObjectPendingCall_Error_PythonToCpp_QRemoteObjectPendingCall_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRemoteObjectPendingCall::Error *>(cppOut) =
        static_cast<::QRemoteObjectPendingCall::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRemoteObjectPendingCall_Error_PythonToCpp_QRemoteObjectPendingCall_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX]))
        return QRemoteObjectPendingCall_Error_PythonToCpp_QRemoteObjectPendingCall_Error;
    return {};
}
static PyObject *QRemoteObjectPendingCall_Error_CppToPython_QRemoteObjectPendingCall_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRemoteObjectPendingCall::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRemoteObjectPendingCall_PythonToCpp_QRemoteObjectPendingCall_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRemoteObjectPendingCall_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRemoteObjectPendingCall_PythonToCpp_QRemoteObjectPendingCall_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectPendingCall_TypeF())))
        return QRemoteObjectPendingCall_PythonToCpp_QRemoteObjectPendingCall_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRemoteObjectPendingCall_PTR_CppToPython_QRemoteObjectPendingCall(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRemoteObjectPendingCall *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRemoteObjectPendingCall_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRemoteObjectPendingCall_SignatureStrings[] = {
    "1:PySide2.QtRemoteObjects.QRemoteObjectPendingCall(self)",
    "0:PySide2.QtRemoteObjects.QRemoteObjectPendingCall(self,other:PySide2.QtRemoteObjects.QRemoteObjectPendingCall)",
    "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.error(self)->PySide2.QtRemoteObjects.QRemoteObjectPendingCall.Error",
    "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.fromCompletedCall(returnValue:QVariant)->PySide2.QtRemoteObjects.QRemoteObjectPendingCall",
    "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.isFinished(self)->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.returnValue(self)->QVariant",
    "PySide2.QtRemoteObjects.QRemoteObjectPendingCall.waitForFinished(self,timeout:int=30000)->bool",
    nullptr}; // Sentinel

void init_QRemoteObjectPendingCall(PyObject *module)
{
    _Sbk_QRemoteObjectPendingCall_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRemoteObjectPendingCall",
        "QRemoteObjectPendingCall*",
        &Sbk_QRemoteObjectPendingCall_spec,
        &Shiboken::callCppDestructor< ::QRemoteObjectPendingCall >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectPendingCall_Type);
    InitSignatureStrings(pyType, QRemoteObjectPendingCall_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectPendingCall_Type), Sbk_QRemoteObjectPendingCall_PropertyStrings);
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectPendingCall_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRemoteObjectPendingCall_TypeF(),
        QRemoteObjectPendingCall_PythonToCpp_QRemoteObjectPendingCall_PTR,
        is_QRemoteObjectPendingCall_PythonToCpp_QRemoteObjectPendingCall_PTR_Convertible,
        QRemoteObjectPendingCall_PTR_CppToPython_QRemoteObjectPendingCall);

    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectPendingCall");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectPendingCall*");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectPendingCall&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectPendingCall).name());


    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRemoteObjectPendingCall_TypeF(),
        "Error",
        "2:PySide2.QtRemoteObjects.QRemoteObjectPendingCall.Error",
        "QRemoteObjectPendingCall::Error");
    if (!SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX],
        Sbk_QRemoteObjectPendingCall_TypeF(), "NoError", (long) QRemoteObjectPendingCall::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX],
        Sbk_QRemoteObjectPendingCall_TypeF(), "InvalidMessage", (long) QRemoteObjectPendingCall::Error::InvalidMessage))
        return;
    // Register converter for enum 'QRemoteObjectPendingCall::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX],
            QRemoteObjectPendingCall_Error_CppToPython_QRemoteObjectPendingCall_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRemoteObjectPendingCall_Error_PythonToCpp_QRemoteObjectPendingCall_Error,
            is_QRemoteObjectPendingCall_Error_PythonToCpp_QRemoteObjectPendingCall_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectPendingCall::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    qRegisterMetaType< ::QRemoteObjectPendingCall::Error >("QRemoteObjectPendingCall::Error");
}
