/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtremoteobjects_python.h"

// main header
#include "qremoteobjectreplica_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QRemoteObjectReplicaWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QRemoteObjectReplicaWrapper::QRemoteObjectReplicaWrapper() : QRemoteObjectReplica()
{
    resetPyMethodCache();
    // ... middle
}

void QRemoteObjectReplicaWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectReplicaWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRemoteObjectReplicaWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QRemoteObjectReplicaWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QRemoteObjectReplicaWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectReplica.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QRemoteObjectReplicaWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QRemoteObjectReplica.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QRemoteObjectReplicaWrapper::initialize()
{
    if (m_PyMethodCache[6]) {
        return this->::QRemoteObjectReplica::initialize();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initialize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QRemoteObjectReplica::initialize();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRemoteObjectReplicaWrapper::setNode(::QRemoteObjectNode * node)
{
    if (m_PyMethodCache[8]) {
        return this->::QRemoteObjectReplica::setNode(node);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    // This method belongs to a property.
    static const char *funcName = "2:setNode";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QRemoteObjectReplica::setNode(node);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTNODE_IDX]), node)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QRemoteObjectReplicaWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QRemoteObjectReplicaWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QRemoteObjectReplica::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QRemoteObjectReplicaWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QRemoteObjectReplica::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QRemoteObjectReplicaWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QRemoteObjectReplicaWrapper *>(this));
        return QRemoteObjectReplica::qt_metacast(_clname);
}

QRemoteObjectReplicaWrapper::~QRemoteObjectReplicaWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRemoteObjectReplica_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRemoteObjectReplica >()))
        return -1;

    ::QRemoteObjectReplicaWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QRemoteObjectReplica()
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QRemoteObjectReplicaWrapper();
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QRemoteObjectReplicaWrapper();
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRemoteObjectReplica >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QRemoteObjectReplica_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QRemoteObjectReplica_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_initialize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.initialize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialize()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRemoteObjectReplica::initialize()
                : cppSelf->initialize();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_initializeNode(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.initializeNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:initializeNode", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::initializeNode(QRemoteObjectNode*,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTNODE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // initializeNode(QRemoteObjectNode*,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // initializeNode(QRemoteObjectNode*,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_name = Shiboken::String::createStaticString("name");
            if (PyDict_Contains(kwds, key_name)) {
                value = PyDict_GetItem(kwds, key_name);
                if (value && pyArgs[1]) {
                    errInfo = key_name;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_name);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRemoteObjectNode *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // initializeNode(QRemoteObjectNode*,QString)
            cppSelf->initializeNode(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_initializeNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_isInitialized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.isInitialized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isInitialized()const
            bool cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->isInitialized();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_isReplicaValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.isReplicaValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReplicaValid()const
            bool cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->isReplicaValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_node(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.node";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // node()const
            QRemoteObjectNode * cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->node();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTNODE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_persistProperties(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.persistProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "persistProperties", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::persistProperties(QString,QByteArray,QList<QVariant>)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QLIST_QVARIANT_IDX], (pyArgs[2])))) {
        overloadId = 0; // persistProperties(QString,QByteArray,QList<QVariant>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_persistProperties_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QList<QVariant > cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // persistProperties(QString,QByteArray,QList<QVariant>)const
            const_cast<const ::QRemoteObjectReplica *>(cppSelf)->persistProperties(cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_persistProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_propAsVariant(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.propAsVariant";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectReplica::propAsVariant(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // propAsVariant(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_propAsVariant_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // propAsVariant(int)const
            const QVariant cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->propAsVariant(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectReplicaFunc_propAsVariant_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_retrieveProperties(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.retrieveProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "retrieveProperties", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::retrieveProperties(QString,QByteArray)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // retrieveProperties(QString,QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_retrieveProperties_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // retrieveProperties(QString,QByteArray)const
            QList<QVariant > cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->retrieveProperties(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QLIST_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectReplicaFunc_retrieveProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_send(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.send";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "send", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::send(QMetaObject::Call,int,QList<QVariant>)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QLIST_QVARIANT_IDX], (pyArgs[2])))) {
        overloadId = 0; // send(QMetaObject::Call,int,QList<QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_send_TypeError;

    // Call function/method
    {
        ::QMetaObject::Call cppArg0{QMetaObject::InvokeMetaMethod};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QList<QVariant > cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // send(QMetaObject::Call,int,QList<QVariant>)
            cppSelf->send(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_send_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_sendWithReply(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.sendWithReply";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sendWithReply", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::sendWithReply(QMetaObject::Call,int,QList<QVariant>)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QMETAOBJECT_CALL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QLIST_QVARIANT_IDX], (pyArgs[2])))) {
        overloadId = 0; // sendWithReply(QMetaObject::Call,int,QList<QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_sendWithReply_TypeError;

    // Call function/method
    {
        ::QMetaObject::Call cppArg0{QMetaObject::InvokeMetaMethod};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QList<QVariant > cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // sendWithReply(QMetaObject::Call,int,QList<QVariant>)
            QRemoteObjectPendingCall* cppResult = new QRemoteObjectPendingCall(cppSelf->sendWithReply(cppArg0, cppArg1, cppArg2));
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTPENDINGCALL_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectReplicaFunc_sendWithReply_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_setChild(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.setChild";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setChild", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::setChild(int,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setChild(int,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_setChild_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setChild(int,QVariant)
            cppSelf->setChild(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_setChild_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_setNode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.setNode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectReplica::setNode(QRemoteObjectNode*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTNODE_IDX]), (pyArg)))) {
        overloadId = 0; // setNode(QRemoteObjectNode*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_setNode_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRemoteObjectNode *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNode(QRemoteObjectNode*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QRemoteObjectReplica::setNode(cppArg0)
                : cppSelf->setNode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_setNode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_setProperties(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.setProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRemoteObjectReplica::setProperties(QList<QVariant>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtRemoteObjectsTypeConverters[SBK_QTREMOTEOBJECTS_QLIST_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setProperties(QList<QVariant>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_setProperties_TypeError;

    // Call function/method
    {
        ::QList<QVariant > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProperties(QList<QVariant>)
            cppSelf->setProperties(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRemoteObjectReplicaFunc_setProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QRemoteObjectReplica::State cppResult = const_cast<const ::QRemoteObjectReplica *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRemoteObjectReplicaFunc_waitForSource(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtRemoteObjects.QRemoteObjectReplica.waitForSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForSource", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QRemoteObjectReplica::waitForSource(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForSource(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForSource(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForSource(int)
            bool cppResult = cppSelf->waitForSource(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRemoteObjectReplicaFunc_waitForSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QRemoteObjectReplica_PropertyStrings[] = {
    "node::",
    "state:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRemoteObjectReplica_methods[] = {
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_initialize), METH_NOARGS},
    {"initializeNode", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_initializeNode), METH_VARARGS|METH_KEYWORDS},
    {"isInitialized", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_isInitialized), METH_NOARGS},
    {"isReplicaValid", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_isReplicaValid), METH_NOARGS},
    {"node", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_node), METH_NOARGS},
    {"persistProperties", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_persistProperties), METH_VARARGS},
    {"propAsVariant", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_propAsVariant), METH_O},
    {"retrieveProperties", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_retrieveProperties), METH_VARARGS},
    {"send", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_send), METH_VARARGS},
    {"sendWithReply", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_sendWithReply), METH_VARARGS},
    {"setChild", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_setChild), METH_VARARGS},
    {"setNode", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_setNode), METH_O},
    {"setProperties", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_setProperties), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_state), METH_NOARGS},
    {"waitForSource", reinterpret_cast<PyCFunction>(Sbk_QRemoteObjectReplicaFunc_waitForSource), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QRemoteObjectReplica_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QRemoteObjectReplica *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QRemoteObjectReplicaWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QRemoteObjectReplica_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRemoteObjectReplica_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRemoteObjectReplica_Type = nullptr;
static SbkObjectType *Sbk_QRemoteObjectReplica_TypeF(void)
{
    return _Sbk_QRemoteObjectReplica_Type;
}

static PyType_Slot Sbk_QRemoteObjectReplica_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QRemoteObjectReplica_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRemoteObjectReplica_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRemoteObjectReplica_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRemoteObjectReplica_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRemoteObjectReplica_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRemoteObjectReplica_spec = {
    "2:PySide2.QtRemoteObjects.QRemoteObjectReplica",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRemoteObjectReplica_slots
};

} //extern "C"

static void *Sbk_QRemoteObjectReplica_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QRemoteObjectReplica *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QRemoteObjectReplica_State_PythonToCpp_QRemoteObjectReplica_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRemoteObjectReplica::State *>(cppOut) =
        static_cast<::QRemoteObjectReplica::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRemoteObjectReplica_State_PythonToCpp_QRemoteObjectReplica_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX]))
        return QRemoteObjectReplica_State_PythonToCpp_QRemoteObjectReplica_State;
    return {};
}
static PyObject *QRemoteObjectReplica_State_CppToPython_QRemoteObjectReplica_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRemoteObjectReplica::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRemoteObjectReplica_PythonToCpp_QRemoteObjectReplica_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRemoteObjectReplica_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRemoteObjectReplica_PythonToCpp_QRemoteObjectReplica_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectReplica_TypeF())))
        return QRemoteObjectReplica_PythonToCpp_QRemoteObjectReplica_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRemoteObjectReplica_PTR_CppToPython_QRemoteObjectReplica(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QRemoteObjectReplica *>(const_cast<void *>(cppIn)), Sbk_QRemoteObjectReplica_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRemoteObjectReplica_SignatureStrings[] = {
    "PySide2.QtRemoteObjects.QRemoteObjectReplica(self)",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.initialize(self)",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.initializeNode(self,node:PySide2.QtRemoteObjects.QRemoteObjectNode,name:QString=QString())",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.isInitialized(self)->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.isReplicaValid(self)->bool",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.node(self)->PySide2.QtRemoteObjects.QRemoteObjectNode",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.persistProperties(self,repName:QString,repSig:PySide2.QtCore.QByteArray,props:QList[QVariant])",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.propAsVariant(self,i:int)->QVariant",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.retrieveProperties(self,repName:QString,repSig:PySide2.QtCore.QByteArray)->QList[QVariant]",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.send(self,call:PySide2.QtCore.QMetaObject.Call,index:int,args:QList[QVariant])",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.sendWithReply(self,call:PySide2.QtCore.QMetaObject.Call,index:int,args:QList[QVariant])->PySide2.QtRemoteObjects.QRemoteObjectPendingCall",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.setChild(self,i:int,arg__2:QVariant)",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.setNode(self,node:PySide2.QtRemoteObjects.QRemoteObjectNode)",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.setProperties(self,arg__1:QList[QVariant])",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.state(self)->PySide2.QtRemoteObjects.QRemoteObjectReplica.State",
    "PySide2.QtRemoteObjects.QRemoteObjectReplica.waitForSource(self,timeout:int=30000)->bool",
    nullptr}; // Sentinel

void init_QRemoteObjectReplica(PyObject *module)
{
    _Sbk_QRemoteObjectReplica_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRemoteObjectReplica",
        "QRemoteObjectReplica*",
        &Sbk_QRemoteObjectReplica_spec,
        &Shiboken::callCppDestructor< ::QRemoteObjectReplica >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectReplica_Type);
    InitSignatureStrings(pyType, QRemoteObjectReplica_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRemoteObjectReplica_Type), Sbk_QRemoteObjectReplica_PropertyStrings);
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRemoteObjectReplica_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRemoteObjectReplica_TypeF(),
        QRemoteObjectReplica_PythonToCpp_QRemoteObjectReplica_PTR,
        is_QRemoteObjectReplica_PythonToCpp_QRemoteObjectReplica_PTR_Convertible,
        QRemoteObjectReplica_PTR_CppToPython_QRemoteObjectReplica);

    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectReplica");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectReplica*");
    Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectReplica&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectReplica).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRemoteObjectReplicaWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QRemoteObjectReplica_TypeF(), &Sbk_QRemoteObjectReplica_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRemoteObjectReplica_TypeF(),
        "State",
        "2:PySide2.QtRemoteObjects.QRemoteObjectReplica.State",
        "QRemoteObjectReplica::State");
    if (!SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
        Sbk_QRemoteObjectReplica_TypeF(), "Uninitialized", (long) QRemoteObjectReplica::State::Uninitialized))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
        Sbk_QRemoteObjectReplica_TypeF(), "Default", (long) QRemoteObjectReplica::State::Default))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
        Sbk_QRemoteObjectReplica_TypeF(), "Valid", (long) QRemoteObjectReplica::State::Valid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
        Sbk_QRemoteObjectReplica_TypeF(), "Suspect", (long) QRemoteObjectReplica::State::Suspect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
        Sbk_QRemoteObjectReplica_TypeF(), "SignatureMismatch", (long) QRemoteObjectReplica::State::SignatureMismatch))
        return;
    // Register converter for enum 'QRemoteObjectReplica::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX],
            QRemoteObjectReplica_State_CppToPython_QRemoteObjectReplica_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRemoteObjectReplica_State_PythonToCpp_QRemoteObjectReplica_State,
            is_QRemoteObjectReplica_State_PythonToCpp_QRemoteObjectReplica_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtRemoteObjectsTypes[SBK_QREMOTEOBJECTREPLICA_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRemoteObjectReplica::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    PySide::Signal::registerSignals(Sbk_QRemoteObjectReplica_TypeF(), &::QRemoteObjectReplica::staticMetaObject);
    qRegisterMetaType< ::QRemoteObjectReplica::State >("QRemoteObjectReplica::State");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QRemoteObjectReplica_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QRemoteObjectReplica_TypeF(), &::QRemoteObjectReplica::staticMetaObject, sizeof(QRemoteObjectReplicaWrapper));
}
