/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptclass_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScriptClassWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScriptClassWrapper::QScriptClassWrapper(::QScriptEngine * engine) : QScriptClass(engine)
{
    resetPyMethodCache();
    // ... middle
}

::QVariant QScriptClassWrapper::extension(::QScriptClass::Extension extension, const ::QVariant & argument)
{
    if (m_PyMethodCache[0])
        return this->::QScriptClass::extension(extension, argument);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "extension";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QScriptClass::extension(extension, argument);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])->converter, &extension),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &argument)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.extension", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QScriptClassWrapper::name() const
{
    if (m_PyMethodCache[1])
        return this->::QScriptClass::name();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QScriptClass::name();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.name", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScriptClassPropertyIterator * QScriptClassWrapper::newIterator(const ::QScriptValue & object)
{
    if (m_PyMethodCache[2])
        return this->::QScriptClass::newIterator(object);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "newIterator";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QScriptClass::newIterator(object);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &object)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.newIterator", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScriptClassPropertyIterator >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QScriptClassPropertyIterator *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScriptValue QScriptClassWrapper::property(const ::QScriptValue & object, const ::QScriptString & name, uint id)
{
    if (m_PyMethodCache[3])
        return this->::QScriptClass::property(object, name, id);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "property";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QScriptClass::property(object, name, id);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNI)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &object),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), &name),
    id
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.property", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScriptValue >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QScriptValue cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<QScriptValue::PropertyFlag> QScriptClassWrapper::propertyFlags(const ::QScriptValue & object, const ::QScriptString & name, uint id)
{
    if (m_PyMethodCache[4])
        return this->::QScriptClass::propertyFlags(object, name, id);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QScriptValue::PropertyFlag>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "propertyFlags";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QScriptClass::propertyFlags(object, name, id);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNI)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &object),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), &name),
    id
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QScriptValue::PropertyFlag>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.propertyFlags", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QScriptValue::PropertyFlag> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QScriptValue::PropertyFlag>(0);
    }
    ::QFlags<QScriptValue::PropertyFlag> cppResult = QFlags<QScriptValue::PropertyFlag>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScriptValue QScriptClassWrapper::prototype() const
{
    if (m_PyMethodCache[5])
        return this->::QScriptClass::prototype();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "prototype";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QScriptClass::prototype();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.prototype", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScriptValue >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QScriptValue cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QScriptClassWrapper::setProperty(::QScriptValue & object, const ::QScriptString & name, uint id, const ::QScriptValue & value)
{
    if (m_PyMethodCache[6]) {
        return this->::QScriptClass::setProperty(object, name, id, value);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setProperty";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QScriptClass::setProperty(object, name, id, value);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNIN)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &object),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), &name),
    id,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QScriptClassWrapper::supportsExtension(::QScriptClass::Extension extension) const
{
    if (m_PyMethodCache[7])
        return this->::QScriptClass::supportsExtension(extension);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "supportsExtension";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QScriptClass::supportsExtension(extension);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])->converter, &extension)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScriptClass.supportsExtension", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QScriptClassWrapper::~QScriptClassWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptClass_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptClass >()))
        return -1;

    ::QScriptClassWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptClass", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptClass::QScriptClass(QScriptEngine*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QScriptClass(QScriptEngine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClass_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QScriptEngine *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QScriptClass(QScriptEngine*)
            cptr = new ::QScriptClassWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptClass >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptClass_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScriptClass_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptClassFunc_engine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.engine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // engine()const
            QScriptEngine * cppResult = const_cast<const ::QScriptClass *>(cppSelf)->engine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptClassFunc_extension(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.extension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QScriptClassFunc_extension_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QScriptClassFunc_extension_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:extension", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScriptClass::extension(QScriptClass::Extension,QVariant)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // extension(QScriptClass::Extension,QVariant)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
            overloadId = 0; // extension(QScriptClass::Extension,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_extension_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_argument = Shiboken::String::createStaticString("argument");
            if (PyDict_Contains(kwds, key_argument)) {
                value = PyDict_GetItem(kwds, key_argument);
                if (value && pyArgs[1]) {
                    errInfo = key_argument;
                    Py_INCREF(errInfo);
                    goto Sbk_QScriptClassFunc_extension_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1]))))
                        goto Sbk_QScriptClassFunc_extension_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_argument);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QScriptClassFunc_extension_TypeError;
            }
        }
        ::QScriptClass::Extension cppArg0{QScriptClass::Callable};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1 = QVariant();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // extension(QScriptClass::Extension,QVariant)
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptClass::extension(cppArg0, cppArg1)
                : cppSelf->extension(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptClassFunc_extension_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptClassFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QScriptClass *>(cppSelf)->::QScriptClass::name()
                : const_cast<const ::QScriptClass *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptClassFunc_newIterator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.newIterator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptClass::newIterator(QScriptValue)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArg)))) {
        overloadId = 0; // newIterator(QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_newIterator_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // newIterator(QScriptValue)
            QScriptClassPropertyIterator * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptClass::newIterator(*cppArg0)
                : cppSelf->newIterator(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASSPROPERTYITERATOR_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptClassFunc_newIterator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptClassFunc_property(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "property", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptClass::property(QScriptValue,QScriptString,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))) {
        overloadId = 0; // property(QScriptValue,QScriptString,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_property_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptString cppArg1_local;
        ::QScriptString *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        uint cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // property(QScriptValue,QScriptString,uint)
            QScriptValue cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptClass::property(*cppArg0, *cppArg1, cppArg2)
                : cppSelf->property(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptClassFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptClassFunc_propertyFlags(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.propertyFlags";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "propertyFlags", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QScriptClass::propertyFlags(QScriptValue,QScriptString,uint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))) {
        overloadId = 0; // propertyFlags(QScriptValue,QScriptString,uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_propertyFlags_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptString cppArg1_local;
        ::QScriptString *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        uint cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // propertyFlags(QScriptValue,QScriptString,uint)
            QFlags<QScriptValue::PropertyFlag> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptClass::propertyFlags(*cppArg0, *cppArg1, cppArg2)
                : cppSelf->propertyFlags(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QFLAGS_QSCRIPTVALUE_PROPERTYFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptClassFunc_propertyFlags_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptClassFunc_prototype(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.prototype";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // prototype()const
            QScriptValue cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QScriptClass *>(cppSelf)->::QScriptClass::prototype()
                : const_cast<const ::QScriptClass *>(cppSelf)->prototype();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptClassFunc_setProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProperty", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QScriptClass::setProperty(QScriptValue&,QScriptString,uint,QScriptValue)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), (pyArgs[3])))) {
        overloadId = 0; // setProperty(QScriptValue&,QScriptString,uint,QScriptValue)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_setProperty_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QScriptValue cppArg0_local;
        ::QScriptValue *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QScriptString cppArg1_local;
        ::QScriptString *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTSTRING_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        uint cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QScriptValue cppArg3_local;
        ::QScriptValue *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTVALUE_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);


        if (!PyErr_Occurred()) {
            // setProperty(QScriptValue&,QScriptString,uint,QScriptValue)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QScriptClass::setProperty(*cppArg0, *cppArg1, cppArg2, *cppArg3)
                : cppSelf->setProperty(*cppArg0, *cppArg1, cppArg2, *cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScriptClassFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptClassFunc_supportsExtension(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptClass.supportsExtension";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScriptClass::supportsExtension(QScriptClass::Extension)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // supportsExtension(QScriptClass::Extension)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptClassFunc_supportsExtension_TypeError;

    // Call function/method
    {
        ::QScriptClass::Extension cppArg0{QScriptClass::Callable};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // supportsExtension(QScriptClass::Extension)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QScriptClass *>(cppSelf)->::QScriptClass::supportsExtension(cppArg0)
                : const_cast<const ::QScriptClass *>(cppSelf)->supportsExtension(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptClassFunc_supportsExtension_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScriptClass_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptClass_methods[] = {
    {"engine", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_engine), METH_NOARGS},
    {"extension", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_extension), METH_VARARGS|METH_KEYWORDS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_name), METH_NOARGS},
    {"newIterator", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_newIterator), METH_O},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_property), METH_VARARGS},
    {"propertyFlags", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_propertyFlags), METH_VARARGS},
    {"prototype", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_prototype), METH_NOARGS},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_setProperty), METH_VARARGS},
    {"supportsExtension", reinterpret_cast<PyCFunction>(Sbk_QScriptClassFunc_supportsExtension), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScriptClass_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScriptClass *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScriptClassWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScriptClass_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptClass_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptClass_Type = nullptr;
static SbkObjectType *Sbk_QScriptClass_TypeF(void)
{
    return _Sbk_QScriptClass_Type;
}

static PyType_Slot Sbk_QScriptClass_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScriptClass_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptClass_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptClass_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptClass_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptClass_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptClass_spec = {
    "2:PySide2.QtScript.QScriptClass",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptClass_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptClass_QueryFlag_PythonToCpp_QScriptClass_QueryFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptClass::QueryFlag *>(cppOut) =
        static_cast<::QScriptClass::QueryFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptClass_QueryFlag_PythonToCpp_QScriptClass_QueryFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX]))
        return QScriptClass_QueryFlag_PythonToCpp_QScriptClass_QueryFlag;
    return {};
}
static PyObject *QScriptClass_QueryFlag_CppToPython_QScriptClass_QueryFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptClass::QueryFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX], castCppIn);

}

static void QScriptClass_Extension_PythonToCpp_QScriptClass_Extension(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptClass::Extension *>(cppOut) =
        static_cast<::QScriptClass::Extension>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptClass_Extension_PythonToCpp_QScriptClass_Extension_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX]))
        return QScriptClass_Extension_PythonToCpp_QScriptClass_Extension;
    return {};
}
static PyObject *QScriptClass_Extension_CppToPython_QScriptClass_Extension(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptClass::Extension *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptClass_PythonToCpp_QScriptClass_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptClass_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptClass_PythonToCpp_QScriptClass_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptClass_TypeF())))
        return QScriptClass_PythonToCpp_QScriptClass_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptClass_PTR_CppToPython_QScriptClass(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptClass *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptClass_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptClass_SignatureStrings[] = {
    "PySide2.QtScript.QScriptClass(self,engine:PySide2.QtScript.QScriptEngine)",
    "PySide2.QtScript.QScriptClass.engine(self)->PySide2.QtScript.QScriptEngine",
    "PySide2.QtScript.QScriptClass.extension(self,extension:PySide2.QtScript.QScriptClass.Extension,argument:QVariant=QVariant())->QVariant",
    "PySide2.QtScript.QScriptClass.name(self)->QString",
    "PySide2.QtScript.QScriptClass.newIterator(self,object:PySide2.QtScript.QScriptValue)->PySide2.QtScript.QScriptClassPropertyIterator",
    "PySide2.QtScript.QScriptClass.property(self,object:PySide2.QtScript.QScriptValue,name:PySide2.QtScript.QScriptString,id:uint)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptClass.propertyFlags(self,object:PySide2.QtScript.QScriptValue,name:PySide2.QtScript.QScriptString,id:uint)->PySide2.QtScript.QScriptValue.PropertyFlags",
    "PySide2.QtScript.QScriptClass.prototype(self)->PySide2.QtScript.QScriptValue",
    "PySide2.QtScript.QScriptClass.setProperty(self,object:PySide2.QtScript.QScriptValue,name:PySide2.QtScript.QScriptString,id:uint,value:PySide2.QtScript.QScriptValue)",
    "PySide2.QtScript.QScriptClass.supportsExtension(self,extension:PySide2.QtScript.QScriptClass.Extension)->bool",
    nullptr}; // Sentinel

void init_QScriptClass(PyObject *module)
{
    _Sbk_QScriptClass_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptClass",
        "QScriptClass*",
        &Sbk_QScriptClass_spec,
        &Shiboken::callCppDestructor< ::QScriptClass >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptClass_Type);
    InitSignatureStrings(pyType, QScriptClass_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptClass_Type), Sbk_QScriptClass_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptClass_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptClass_TypeF(),
        QScriptClass_PythonToCpp_QScriptClass_PTR,
        is_QScriptClass_PythonToCpp_QScriptClass_PTR_Convertible,
        QScriptClass_PTR_CppToPython_QScriptClass);

    Shiboken::Conversions::registerConverterName(converter, "QScriptClass");
    Shiboken::Conversions::registerConverterName(converter, "QScriptClass*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptClass&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptClass).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptClassWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'QueryFlag'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptClass_TypeF(),
        "QueryFlag",
        "2:PySide2.QtScript.QScriptClass.QueryFlag",
        "QScriptClass::QueryFlag");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX],
        Sbk_QScriptClass_TypeF(), "HandlesReadAccess", (long) QScriptClass::QueryFlag::HandlesReadAccess))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX],
        Sbk_QScriptClass_TypeF(), "HandlesWriteAccess", (long) QScriptClass::QueryFlag::HandlesWriteAccess))
        return;
    // Register converter for enum 'QScriptClass::QueryFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX],
            QScriptClass_QueryFlag_CppToPython_QScriptClass_QueryFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptClass_QueryFlag_PythonToCpp_QScriptClass_QueryFlag,
            is_QScriptClass_QueryFlag_PythonToCpp_QScriptClass_QueryFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_QUERYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptClass::QueryFlag");
        Shiboken::Conversions::registerConverterName(converter, "QueryFlag");
    }
    // End of 'QueryFlag' enum.

    // Initialization of enum 'Extension'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptClass_TypeF(),
        "Extension",
        "2:PySide2.QtScript.QScriptClass.Extension",
        "QScriptClass::Extension");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX],
        Sbk_QScriptClass_TypeF(), "Callable", (long) QScriptClass::Extension::Callable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX],
        Sbk_QScriptClass_TypeF(), "HasInstance", (long) QScriptClass::Extension::HasInstance))
        return;
    // Register converter for enum 'QScriptClass::Extension'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX],
            QScriptClass_Extension_CppToPython_QScriptClass_Extension);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptClass_Extension_PythonToCpp_QScriptClass_Extension,
            is_QScriptClass_Extension_PythonToCpp_QScriptClass_Extension_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCLASS_EXTENSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptClass::Extension");
        Shiboken::Conversions::registerConverterName(converter, "Extension");
    }
    // End of 'Extension' enum.

    qRegisterMetaType< ::QScriptClass::QueryFlag >("QScriptClass::QueryFlag");
    qRegisterMetaType< ::QScriptClass::Extension >("QScriptClass::Extension");
}
