/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscript_python.h"

// main header
#include "qscriptcontextinfo_wrapper.h"

// inner classes

// Extra includes
#include <QtScript/qscriptcontext.h>
#include <QtScript/qscriptcontextinfo.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScriptContextInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScriptContextInfo >()))
        return -1;

    ::QScriptContextInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScriptContextInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScriptContextInfo::QScriptContextInfo()
    // 1: QScriptContextInfo::QScriptContextInfo(const QScriptContext*)
    // 2: QScriptContextInfo::QScriptContextInfo(QScriptContextInfo)
    if (numArgs == 0) {
        overloadId = 0; // QScriptContextInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QScriptContextInfo(const QScriptContext*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QScriptContextInfo(QScriptContextInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScriptContextInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScriptContextInfo()
        {

            if (!PyErr_Occurred()) {
                // QScriptContextInfo()
                cptr = new ::QScriptContextInfo();
            }
            break;
        }
        case 1: // QScriptContextInfo(const QScriptContext * context)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptContext *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QScriptContextInfo(const QScriptContext*)
                cptr = new ::QScriptContextInfo(cppArg0);
            }
            break;
        }
        case 2: // QScriptContextInfo(const QScriptContextInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScriptContextInfo cppArg0_local;
            ::QScriptContextInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScriptContextInfo(QScriptContextInfo)
                cptr = new ::QScriptContextInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScriptContextInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScriptContextInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScriptContextInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScriptContextInfoFunc_columnNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.columnNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // columnNumber()const
            int cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->columnNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_fileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.fileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileName()const
            QString cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->fileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionEndLineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionEndLineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionEndLineNumber()const
            int cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionEndLineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionMetaIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionMetaIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionMetaIndex()const
            int cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionMetaIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionName()const
            QString cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionParameterNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionParameterNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionParameterNames()const
            QStringList cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionParameterNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionStartLineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionStartLineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionStartLineNumber()const
            int cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionStartLineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_functionType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.functionType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // functionType()const
            QScriptContextInfo::FunctionType cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->functionType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_lineNumber(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.lineNumber";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineNumber()const
            int cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->lineNumber();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfoFunc_scriptId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.scriptId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scriptId()const
            qint64 cppResult = const_cast<const ::QScriptContextInfo *>(cppSelf)->scriptId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScriptContextInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScriptContextInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScriptContextInfo_methods[] = {
    {"columnNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_columnNumber), METH_NOARGS},
    {"fileName", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_fileName), METH_NOARGS},
    {"functionEndLineNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionEndLineNumber), METH_NOARGS},
    {"functionMetaIndex", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionMetaIndex), METH_NOARGS},
    {"functionName", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionName), METH_NOARGS},
    {"functionParameterNames", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionParameterNames), METH_NOARGS},
    {"functionStartLineNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionStartLineNumber), METH_NOARGS},
    {"functionType", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_functionType), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_isNull), METH_NOARGS},
    {"lineNumber", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_lineNumber), METH_NOARGS},
    {"scriptId", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfoFunc_scriptId), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QScriptContextInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScriptContextInfo___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QScriptContextInfoFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QScriptContextInfo::operator<<(QDataStream&,QScriptContextInfo)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QScriptContextInfo)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QScriptContextInfoFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QScriptContextInfo) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptContextInfoFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScriptContextInfoFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScript.QScriptContextInfo.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QScriptContextInfo::operator>>(QDataStream&,QScriptContextInfo&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QScriptContextInfo&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QScriptContextInfoFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QScriptContextInfo&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScriptContextInfoFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QScriptContextInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), (pyArg)))) {
                // operator!=(const QScriptContextInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QScriptContextInfo cppArg0_local;
                ::QScriptContextInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), (pyArg)))) {
                // operator==(const QScriptContextInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QScriptContextInfo cppArg0_local;
                ::QScriptContextInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QScriptContextInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QScriptContextInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QScriptContextInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScriptContextInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScriptContextInfo_Type = nullptr;
static SbkObjectType *Sbk_QScriptContextInfo_TypeF(void)
{
    return _Sbk_QScriptContextInfo_Type;
}

static PyType_Slot Sbk_QScriptContextInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScriptContextInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScriptContextInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QScriptContextInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScriptContextInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScriptContextInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QScriptContextInfoFunc___rshift__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QScriptContextInfo___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QScriptContextInfo___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QScriptContextInfoFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QScriptContextInfo_spec = {
    "2:PySide2.QtScript.QScriptContextInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScriptContextInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScriptContextInfo_FunctionType_PythonToCpp_QScriptContextInfo_FunctionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptContextInfo::FunctionType *>(cppOut) =
        static_cast<::QScriptContextInfo::FunctionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScriptContextInfo_FunctionType_PythonToCpp_QScriptContextInfo_FunctionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX]))
        return QScriptContextInfo_FunctionType_PythonToCpp_QScriptContextInfo_FunctionType;
    return {};
}
static PyObject *QScriptContextInfo_FunctionType_CppToPython_QScriptContextInfo_FunctionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScriptContextInfo::FunctionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScriptContextInfo_PythonToCpp_QScriptContextInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScriptContextInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScriptContextInfo_PythonToCpp_QScriptContextInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptContextInfo_TypeF())))
        return QScriptContextInfo_PythonToCpp_QScriptContextInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScriptContextInfo_PTR_CppToPython_QScriptContextInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScriptContextInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScriptContextInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QScriptContextInfo_COPY_CppToPython_QScriptContextInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QScriptContextInfo_TypeF(), new ::QScriptContextInfo(*reinterpret_cast<const ::QScriptContextInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QScriptContextInfo_PythonToCpp_QScriptContextInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptContextInfo *>(cppOut) = *reinterpret_cast< ::QScriptContextInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QScriptContextInfo_PythonToCpp_QScriptContextInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScriptContextInfo_TypeF())))
        return QScriptContextInfo_PythonToCpp_QScriptContextInfo_COPY;
    return {};
}

// Implicit conversions.
static void constQScriptContextPTR_PythonToCpp_QScriptContextInfo(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScriptContextInfo *>(cppOut) = ::QScriptContextInfo(reinterpret_cast< ::QScriptContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQScriptContextPTR_PythonToCpp_QScriptContextInfo_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXT_IDX], pyIn))
        return constQScriptContextPTR_PythonToCpp_QScriptContextInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScriptContextInfo_SignatureStrings[] = {
    "2:PySide2.QtScript.QScriptContextInfo(self)",
    "1:PySide2.QtScript.QScriptContextInfo(self,context:PySide2.QtScript.QScriptContext)",
    "0:PySide2.QtScript.QScriptContextInfo(self,other:PySide2.QtScript.QScriptContextInfo)",
    "PySide2.QtScript.QScriptContextInfo.columnNumber(self)->int",
    "PySide2.QtScript.QScriptContextInfo.fileName(self)->QString",
    "PySide2.QtScript.QScriptContextInfo.functionEndLineNumber(self)->int",
    "PySide2.QtScript.QScriptContextInfo.functionMetaIndex(self)->int",
    "PySide2.QtScript.QScriptContextInfo.functionName(self)->QString",
    "PySide2.QtScript.QScriptContextInfo.functionParameterNames(self)->QStringList",
    "PySide2.QtScript.QScriptContextInfo.functionStartLineNumber(self)->int",
    "PySide2.QtScript.QScriptContextInfo.functionType(self)->PySide2.QtScript.QScriptContextInfo.FunctionType",
    "PySide2.QtScript.QScriptContextInfo.isNull(self)->bool",
    "PySide2.QtScript.QScriptContextInfo.lineNumber(self)->int",
    "PySide2.QtScript.QScriptContextInfo.scriptId(self)->qint64",
    "PySide2.QtScript.QScriptContextInfo.__copy__()",
    "PySide2.QtScript.QScriptContextInfo.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtScript.QScriptContextInfo.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QScriptContextInfo(PyObject *module)
{
    _Sbk_QScriptContextInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScriptContextInfo",
        "QScriptContextInfo",
        &Sbk_QScriptContextInfo_spec,
        &Shiboken::callCppDestructor< ::QScriptContextInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScriptContextInfo_Type);
    InitSignatureStrings(pyType, QScriptContextInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScriptContextInfo_Type), Sbk_QScriptContextInfo_PropertyStrings);
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScriptContextInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScriptContextInfo_TypeF(),
        QScriptContextInfo_PythonToCpp_QScriptContextInfo_PTR,
        is_QScriptContextInfo_PythonToCpp_QScriptContextInfo_PTR_Convertible,
        QScriptContextInfo_PTR_CppToPython_QScriptContextInfo,
        QScriptContextInfo_COPY_CppToPython_QScriptContextInfo);

    Shiboken::Conversions::registerConverterName(converter, "QScriptContextInfo");
    Shiboken::Conversions::registerConverterName(converter, "QScriptContextInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QScriptContextInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScriptContextInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScriptContextInfo_PythonToCpp_QScriptContextInfo_COPY,
        is_QScriptContextInfo_PythonToCpp_QScriptContextInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQScriptContextPTR_PythonToCpp_QScriptContextInfo,
        is_constQScriptContextPTR_PythonToCpp_QScriptContextInfo_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FunctionType'.
    SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScriptContextInfo_TypeF(),
        "FunctionType",
        "2:PySide2.QtScript.QScriptContextInfo.FunctionType",
        "QScriptContextInfo::FunctionType");
    if (!SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX],
        Sbk_QScriptContextInfo_TypeF(), "ScriptFunction", (long) QScriptContextInfo::FunctionType::ScriptFunction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX],
        Sbk_QScriptContextInfo_TypeF(), "QtFunction", (long) QScriptContextInfo::FunctionType::QtFunction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX],
        Sbk_QScriptContextInfo_TypeF(), "QtPropertyFunction", (long) QScriptContextInfo::FunctionType::QtPropertyFunction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX],
        Sbk_QScriptContextInfo_TypeF(), "NativeFunction", (long) QScriptContextInfo::FunctionType::NativeFunction))
        return;
    // Register converter for enum 'QScriptContextInfo::FunctionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX],
            QScriptContextInfo_FunctionType_CppToPython_QScriptContextInfo_FunctionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScriptContextInfo_FunctionType_PythonToCpp_QScriptContextInfo_FunctionType,
            is_QScriptContextInfo_FunctionType_PythonToCpp_QScriptContextInfo_FunctionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtScriptTypes[SBK_QSCRIPTCONTEXTINFO_FUNCTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScriptContextInfo::FunctionType");
        Shiboken::Conversions::registerConverterName(converter, "FunctionType");
    }
    // End of 'FunctionType' enum.

    qRegisterMetaType< ::QScriptContextInfo >("QScriptContextInfo");
    qRegisterMetaType< ::QScriptContextInfo::FunctionType >("QScriptContextInfo::FunctionType");
}
