/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmlexecutablecontent_foreachinfo_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>

using namespace QScxmlExecutableContent;



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlExecutableContent_ForeachInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlExecutableContent::ForeachInfo >()))
        return -1;

    ::QScxmlExecutableContent::ForeachInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ForeachInfo", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: ForeachInfo::ForeachInfo()
    // 1: ForeachInfo::ForeachInfo(QScxmlExecutableContent::ForeachInfo)
    if (numArgs == 0) {
        overloadId = 0; // ForeachInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]), (pyArgs[0])))) {
        overloadId = 1; // ForeachInfo(QScxmlExecutableContent::ForeachInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlExecutableContent_ForeachInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ForeachInfo()
        {

            if (!PyErr_Occurred()) {
                // ForeachInfo()
                cptr = new ::QScxmlExecutableContent::ForeachInfo();
            }
            break;
        }
        case 1: // ForeachInfo(const QScxmlExecutableContent::ForeachInfo & ForeachInfo)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScxmlExecutableContent::ForeachInfo cppArg0_local;
            ::QScxmlExecutableContent::ForeachInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // ForeachInfo(QScxmlExecutableContent::ForeachInfo)
                cptr = new ::QScxmlExecutableContent::ForeachInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlExecutableContent::ForeachInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScxmlExecutableContent_ForeachInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScxmlExecutableContent_ForeachInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScxmlExecutableContent_ForeachInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScxmlExecutableContent_ForeachInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlExecutableContent_ForeachInfo_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QScxmlExecutableContent_ForeachInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QScxmlExecutableContent_ForeachInfo_get_array(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->array;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QScxmlExecutableContent_ForeachInfo_set_array(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'array' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'array', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->array;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->array = cppOut_local;

    return 0;
}

static PyObject *Sbk_QScxmlExecutableContent_ForeachInfo_get_item(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->item;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QScxmlExecutableContent_ForeachInfo_set_item(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'item' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'item', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->item;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->item = cppOut_local;

    return 0;
}

static PyObject *Sbk_QScxmlExecutableContent_ForeachInfo_get_index(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->index;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QScxmlExecutableContent_ForeachInfo_set_index(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'index' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'index', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->index;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->index = cppOut_local;

    return 0;
}

static PyObject *Sbk_QScxmlExecutableContent_ForeachInfo_get_context(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->context;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QScxmlExecutableContent_ForeachInfo_set_context(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'context' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'context', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->context;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->context = cppOut_local;

    return 0;
}

// Getters and Setters for ForeachInfo
static PyGetSetDef Sbk_QScxmlExecutableContent_ForeachInfo_getsetlist[] = {
    {const_cast<char *>("array"), Sbk_QScxmlExecutableContent_ForeachInfo_get_array, Sbk_QScxmlExecutableContent_ForeachInfo_set_array},
    {const_cast<char *>("item"), Sbk_QScxmlExecutableContent_ForeachInfo_get_item, Sbk_QScxmlExecutableContent_ForeachInfo_set_item},
    {const_cast<char *>("index"), Sbk_QScxmlExecutableContent_ForeachInfo_get_index, Sbk_QScxmlExecutableContent_ForeachInfo_set_index},
    {const_cast<char *>("context"), Sbk_QScxmlExecutableContent_ForeachInfo_get_context, Sbk_QScxmlExecutableContent_ForeachInfo_set_context},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QScxmlExecutableContent_ForeachInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlExecutableContent_ForeachInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlExecutableContent_ForeachInfo_Type = nullptr;
static SbkObjectType *Sbk_QScxmlExecutableContent_ForeachInfo_TypeF(void)
{
    return _Sbk_QScxmlExecutableContent_ForeachInfo_Type;
}

static PyType_Slot Sbk_QScxmlExecutableContent_ForeachInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlExecutableContent_ForeachInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlExecutableContent_ForeachInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlExecutableContent_ForeachInfo_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QScxmlExecutableContent_ForeachInfo_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlExecutableContent_ForeachInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlExecutableContent_ForeachInfo_spec = {
    "2:PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlExecutableContent_ForeachInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ForeachInfo_PythonToCpp_ForeachInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ForeachInfo_PythonToCpp_ForeachInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF())))
        return ForeachInfo_PythonToCpp_ForeachInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ForeachInfo_PTR_CppToPython_ForeachInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScxmlExecutableContent::ForeachInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *ForeachInfo_COPY_CppToPython_ForeachInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF(), new ::QScxmlExecutableContent::ForeachInfo(*reinterpret_cast<const ::QScxmlExecutableContent::ForeachInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void ForeachInfo_PythonToCpp_ForeachInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScxmlExecutableContent::ForeachInfo *>(cppOut) = *reinterpret_cast< ::QScxmlExecutableContent::ForeachInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_ForeachInfo_PythonToCpp_ForeachInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF())))
        return ForeachInfo_PythonToCpp_ForeachInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlExecutableContent_ForeachInfo_SignatureStrings[] = {
    "1:PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo(self)",
    "0:PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo(self,ForeachInfo:PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo)",
    "PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo.__copy__()",
    nullptr}; // Sentinel

void init_QScxmlExecutableContent_ForeachInfo(PyObject *enclosingClass)
{
    _Sbk_QScxmlExecutableContent_ForeachInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ForeachInfo",
        "QScxmlExecutableContent::ForeachInfo",
        &Sbk_QScxmlExecutableContent_ForeachInfo_spec,
        &Shiboken::callCppDestructor< ::QScxmlExecutableContent::ForeachInfo >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlExecutableContent_ForeachInfo_Type);
    InitSignatureStrings(pyType, QScxmlExecutableContent_ForeachInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlExecutableContent_ForeachInfo_Type), Sbk_QScxmlExecutableContent_ForeachInfo_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlExecutableContent_ForeachInfo_TypeF(),
        ForeachInfo_PythonToCpp_ForeachInfo_PTR,
        is_ForeachInfo_PythonToCpp_ForeachInfo_PTR_Convertible,
        ForeachInfo_PTR_CppToPython_ForeachInfo,
        ForeachInfo_COPY_CppToPython_ForeachInfo);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlExecutableContent::ForeachInfo");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlExecutableContent::ForeachInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlExecutableContent::ForeachInfo&");
    Shiboken::Conversions::registerConverterName(converter, "ForeachInfo");
    Shiboken::Conversions::registerConverterName(converter, "ForeachInfo*");
    Shiboken::Conversions::registerConverterName(converter, "ForeachInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlExecutableContent::ForeachInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        ForeachInfo_PythonToCpp_ForeachInfo_COPY,
        is_ForeachInfo_PythonToCpp_ForeachInfo_COPY_Convertible);

    qRegisterMetaType< ::QScxmlExecutableContent::ForeachInfo >("ForeachInfo");
    qRegisterMetaType< ::QScxmlExecutableContent::ForeachInfo >("QScxmlExecutableContent::ForeachInfo");
}
