/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtscxml_python.h"

// main header
#include "qscxmltabledata_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScxmlTableDataWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScxmlTableDataWrapper::QScxmlTableDataWrapper() : QScxmlTableData()
{
    resetPyMethodCache();
    // ... middle
}

::QScxmlExecutableContent::AssignmentInfo QScxmlTableDataWrapper::assignmentInfo(int assignmentId) const
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.assignmentInfo()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "assignmentInfo";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.assignmentInfo()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    assignmentId
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_ASSIGNMENTINFO_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.assignmentInfo", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScxmlExecutableContent::AssignmentInfo >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QScxmlExecutableContent::AssignmentInfo cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int * QScxmlTableDataWrapper::dataNames(int * count) const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.dataNames()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dataNames";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.dataNames()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &count)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.dataNames", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< int >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    int *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScxmlExecutableContent::EvaluatorInfo QScxmlTableDataWrapper::evaluatorInfo(int evaluatorId) const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.evaluatorInfo()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "evaluatorInfo";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.evaluatorInfo()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    evaluatorId
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_EVALUATORINFO_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.evaluatorInfo", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScxmlExecutableContent::EvaluatorInfo >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QScxmlExecutableContent::EvaluatorInfo cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScxmlExecutableContent::ForeachInfo QScxmlTableDataWrapper::foreachInfo(int foreachId) const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.foreachInfo()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "foreachInfo";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.foreachInfo()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    foreachId
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.foreachInfo", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScxmlExecutableContent::ForeachInfo >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QScxmlExecutableContent::ForeachInfo cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QScxmlTableDataWrapper::initialSetup() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.initialSetup()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initialSetup";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.initialSetup()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.initialSetup", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int * QScxmlTableDataWrapper::instructions() const
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.instructions()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "instructions";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.instructions()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.instructions", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< int >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    int *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QScxmlTableDataWrapper::name() const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.name()' not implemented.");
        return ::QString();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "name";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.name()' not implemented.");
        return ::QString();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.name", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QScxmlInvokableServiceFactory * QScxmlTableDataWrapper::serviceFactory(int id) const
{
    if (m_PyMethodCache[7]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.serviceFactory()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "serviceFactory";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.serviceFactory()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    id
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICEFACTORY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.serviceFactory", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QScxmlInvokableServiceFactory >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QScxmlInvokableServiceFactory *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const qint32 * QScxmlTableDataWrapper::stateMachineTable() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.stateMachineTable()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "stateMachineTable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.stateMachineTable()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.stateMachineTable", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< qint32 >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    qint32 *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QString QScxmlTableDataWrapper::string(int id) const
{
    if (m_PyMethodCache[9]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.string()' not implemented.");
        return ::QString();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QString();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "string";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.string()' not implemented.");
        return ::QString();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    id
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QString();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QScxmlTableData.string", "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QScxmlTableDataWrapper::~QScxmlTableDataWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScxmlTableData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QScxmlTableData' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScxmlTableData >()))
        return -1;

    ::QScxmlTableDataWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QScxmlTableData()
            cptr = new ::QScxmlTableDataWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScxmlTableData >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QScxmlTableDataFunc_assignmentInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.assignmentInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::assignmentInfo(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // assignmentInfo(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_assignmentInfo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // assignmentInfo(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.assignmentInfo()' not implemented.");
                return {};
            }
            QScxmlExecutableContent::AssignmentInfo cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->assignmentInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_ASSIGNMENTINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_assignmentInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlTableDataFunc_dataNames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.dataNames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::dataNames(int*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // dataNames(int*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_dataNames_TypeError;

    // Call function/method
    {
        int *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // dataNames(int*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.dataNames()' not implemented.");
                return {};
            }
            int * cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->dataNames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_dataNames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlTableDataFunc_evaluatorInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.evaluatorInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::evaluatorInfo(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // evaluatorInfo(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_evaluatorInfo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // evaluatorInfo(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.evaluatorInfo()' not implemented.");
                return {};
            }
            QScxmlExecutableContent::EvaluatorInfo cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->evaluatorInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_EVALUATORINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_evaluatorInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlTableDataFunc_foreachInfo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.foreachInfo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::foreachInfo(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // foreachInfo(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_foreachInfo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // foreachInfo(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.foreachInfo()' not implemented.");
                return {};
            }
            QScxmlExecutableContent::ForeachInfo cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->foreachInfo(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLEXECUTABLECONTENT_FOREACHINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_foreachInfo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlTableDataFunc_initialSetup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.initialSetup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialSetup()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.initialSetup()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->initialSetup();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlTableDataFunc_instructions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.instructions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // instructions()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.instructions()' not implemented.");
                return {};
            }
            int * cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->instructions();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlTableDataFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.name()' not implemented.");
                return {};
            }
            QString cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlTableDataFunc_serviceFactory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.serviceFactory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::serviceFactory(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // serviceFactory(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_serviceFactory_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // serviceFactory(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.serviceFactory()' not implemented.");
                return {};
            }
            QScxmlInvokableServiceFactory * cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->serviceFactory(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtScxmlTypes[SBK_QSCXMLINVOKABLESERVICEFACTORY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_serviceFactory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScxmlTableDataFunc_stateMachineTable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.stateMachineTable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stateMachineTable()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.stateMachineTable()' not implemented.");
                return {};
            }
            const qint32 * cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->stateMachineTable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QScxmlTableDataFunc_string(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtScxml.QScxmlTableData.string";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScxmlTableData::string(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // string(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScxmlTableDataFunc_string_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // string(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QScxmlTableData.string()' not implemented.");
                return {};
            }
            QString cppResult = const_cast<const ::QScxmlTableData *>(cppSelf)->string(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScxmlTableDataFunc_string_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QScxmlTableData_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScxmlTableData_methods[] = {
    {"assignmentInfo", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_assignmentInfo), METH_O},
    {"dataNames", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_dataNames), METH_O},
    {"evaluatorInfo", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_evaluatorInfo), METH_O},
    {"foreachInfo", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_foreachInfo), METH_O},
    {"initialSetup", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_initialSetup), METH_NOARGS},
    {"instructions", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_instructions), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_name), METH_NOARGS},
    {"serviceFactory", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_serviceFactory), METH_O},
    {"stateMachineTable", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_stateMachineTable), METH_NOARGS},
    {"string", reinterpret_cast<PyCFunction>(Sbk_QScxmlTableDataFunc_string), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScxmlTableData_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScxmlTableData *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScxmlTableDataWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QScxmlTableData_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScxmlTableData_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScxmlTableData_Type = nullptr;
static SbkObjectType *Sbk_QScxmlTableData_TypeF(void)
{
    return _Sbk_QScxmlTableData_Type;
}

static PyType_Slot Sbk_QScxmlTableData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScxmlTableData_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScxmlTableData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScxmlTableData_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScxmlTableData_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScxmlTableData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScxmlTableData_spec = {
    "2:PySide2.QtScxml.QScxmlTableData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScxmlTableData_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScxmlTableData_PythonToCpp_QScxmlTableData_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScxmlTableData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScxmlTableData_PythonToCpp_QScxmlTableData_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScxmlTableData_TypeF())))
        return QScxmlTableData_PythonToCpp_QScxmlTableData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScxmlTableData_PTR_CppToPython_QScxmlTableData(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScxmlTableData *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScxmlTableData_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScxmlTableData_SignatureStrings[] = {
    "PySide2.QtScxml.QScxmlTableData(self)",
    "PySide2.QtScxml.QScxmlTableData.assignmentInfo(self,assignmentId:int)->PySide2.QtScxml.QScxmlExecutableContent.AssignmentInfo",
    "PySide2.QtScxml.QScxmlTableData.dataNames(self,count:int*)->int*",
    "PySide2.QtScxml.QScxmlTableData.evaluatorInfo(self,evaluatorId:int)->PySide2.QtScxml.QScxmlExecutableContent.EvaluatorInfo",
    "PySide2.QtScxml.QScxmlTableData.foreachInfo(self,foreachId:int)->PySide2.QtScxml.QScxmlExecutableContent.ForeachInfo",
    "PySide2.QtScxml.QScxmlTableData.initialSetup(self)->int",
    "PySide2.QtScxml.QScxmlTableData.instructions(self)->int*",
    "PySide2.QtScxml.QScxmlTableData.name(self)->QString",
    "PySide2.QtScxml.QScxmlTableData.serviceFactory(self,id:int)->PySide2.QtScxml.QScxmlInvokableServiceFactory",
    "PySide2.QtScxml.QScxmlTableData.stateMachineTable(self)->qint32*",
    "PySide2.QtScxml.QScxmlTableData.string(self,id:int)->QString",
    nullptr}; // Sentinel

void init_QScxmlTableData(PyObject *module)
{
    _Sbk_QScxmlTableData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScxmlTableData",
        "QScxmlTableData*",
        &Sbk_QScxmlTableData_spec,
        &Shiboken::callCppDestructor< ::QScxmlTableData >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlTableData_Type);
    InitSignatureStrings(pyType, QScxmlTableData_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScxmlTableData_Type), Sbk_QScxmlTableData_PropertyStrings);
    SbkPySide2_QtScxmlTypes[SBK_QSCXMLTABLEDATA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScxmlTableData_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScxmlTableData_TypeF(),
        QScxmlTableData_PythonToCpp_QScxmlTableData_PTR,
        is_QScxmlTableData_PythonToCpp_QScxmlTableData_PTR_Convertible,
        QScxmlTableData_PTR_CppToPython_QScxmlTableData);

    Shiboken::Conversions::registerConverterName(converter, "QScxmlTableData");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlTableData*");
    Shiboken::Conversions::registerConverterName(converter, "QScxmlTableData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlTableData).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScxmlTableDataWrapper).name());


}
